/*
 *  linux/arch/ppc/kernel/traps.c
 *
 *  Copyright (C) 1995  Gary Thomas
 *  Adapted for PowerPC by Gary Thomas
 *  Modified by Cort Dougan (cort@cs.nmt.edu)
 */

/*
 * This file handles the architecture-dependent parts of hardware exceptions
 */

#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/stddef.h>
#include <linux/unistd.h>
#include <linux/ptrace.h>
#include <linux/malloc.h>
#include <linux/user.h>
#include <linux/a.out.h>

#include <asm/pgtable.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <asm/io.h>

#include <asm/ppc_machine.h>

/*
 * Trap & Exception support
 */

void
trap_init(void)
{
}

void
_exception(int signr, struct pt_regs *regs)
{
  /*	dump_regs(regs);*/
  force_sig(signr, current);
  if (!user_mode(regs))
    {
      printk("Failure in kernel at PC: %x, MSR: %x\n", regs->nip, regs->msr);
      while (1) ;
    }
}

MachineCheckException(struct pt_regs *regs)
{
  printk("Machine check at PC: %x[%x], SR: %x\n", regs->nip, va_to_phys(regs->nip), regs->msr);
  _exception(SIGSEGV, regs);	
}

ProgramCheckException(struct pt_regs *regs)
{
#if 0
  printk("Program check at PC: %x[%x], SR: %x\n",
	 regs->nip, va_to_phys(regs->nip), regs->msr);
  #endif
  if (current->flags & PF_PTRACED)
  {
    _exception(SIGTRAP, regs);
  } else
  {
    _exception(SIGILL, regs);
  }
}

SingleStepException(struct pt_regs *regs)
{
	regs->msr &= ~MSR_SE;  /* Turn off 'trace' bit */
	_exception(SIGTRAP, regs);	
}

FloatingPointCheckException(struct pt_regs *regs)
{
  /* if fpu already on -- then exception was generated by an error */
  if ( (unsigned long)(regs->msr) & (unsigned long)MSR_FP )
  {
    _exception(SIGFPE, regs);
    return 0;
  }

#if 0
  printk("fpu off -- turning on: %s pc %x fpscr %x msr %x ksp %x r1 %x\n",
	 current->comm,regs->nip,regs->fpcsr,regs->msr,regs,regs->gpr[1]);
#endif

  /* if the fpu is off then turn it on and return */
  regs->msr |= MSR_FP;
  current->tss.fp_used++;
  /* tells return_from_int to restore fp regs since fp was turned on
     see head.S -- Cort */  
  return MSR_FP;		
}

AlignmentException(struct pt_regs *regs)
{
/*	printk("Alignment error at PC: %x, SR: %x\n", regs->nip, regs->msr);
	dump_regs(regs);
	printk("Alignment error at PC: %x[%x], SR: %x\n", regs->nip, va_to_phys(regs->nip), regs->msr);*/
	_exception(SIGBUS, regs);	
}


/* see CHECK_STACK macro in head.S for argument definitions */
bad_stack(unsigned int r3, unsigned int r4, unsigned int r5, unsigned int r6)
{
  /* r6 (was r1) kernel stack pointer */
  /* r5 (was r2) kernel stack page */
  /* r4 kernel stack magic */
  /* r3 stack magic or ksp masked to page boundary */
  printk("bad_stack(): Kernel stack bad.\n");
  printk("ksp %x kpage %x stack magic %x r3 %x\n",
	 r6,r5,r4,r3);
  printk("current: %s/%d\n",
	 current->comm,current->pid);
  while(1);
}

dump_regs(struct pt_regs *regs)
{
	int i;
	printk("NIP: %08X, MSR: %08X, XER: %08X, LR: %08X, FRAME: %08X\n", regs->nip, regs->msr, regs->xer, regs->link, regs);
#if 0	
	printk("HASH = %08X/%08X, MISS = %08X/%08X, CMP = %08X/%08X\n", regs->hash1, regs->hash2, regs->imiss, regs->dmiss, regs->icmp, regs->dcmp);
#endif	
	printk("TASK = %x[%d] '%s'\n", current, current->pid, current->comm);
	for (i = 0;  i < 32;  i++)
	{
		if ((i % 8) == 0)
		{
			printk("GPR%02d: ", i);
		}
		printk("%08X ", regs->gpr[i]);
		if ((i % 8) == 7)
		{
			printk("\n");
		}
	}
#if 0	
	if (regs->nip >= 0x1000)
		dump_buf(regs->nip-32, 64);
	dump_buf((regs->nip&0x0FFFFFFF)|KERNELBASE, 32);
#endif
}

trace_syscall(struct pt_regs *regs)
{
	static int count;
	printk("Task: %08X(%d), PC: %08X/%08X, Syscall: %3d, Result: %s%d\n", current, current->pid, regs->nip, regs->link, regs->gpr[0], regs->ccr&0x10000000?"Error=":"", regs->gpr[3]);
	if (++count == 20)
	{
		count = 0;
	}
}

