#       rfc822.pl - parse RFC822 mail header
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
# Copyright (c) 1998                              RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: rfc822.pl,v 2.3 1998/07/15 18:01:38 joao Exp $
#
#	$RCSfile: rfc822.pl,v $
#	$Revision: 2.3 $
#	$Author: joao $
#	$Date: 1998/07/15 18:01:38 $

# Takes filehandle from input mail to read as argument
#
# Sets the following global variables:
#
# $FROM	- "From:" field in header
# $REPLYTO - equal to $FROM if "Reply-To:" is not present, else equal to 
#            the "Reply-To:" field
# $SUBJECT - subject in header
# $MDATE - date in header
# $MSGID - message ID in header
# $HELPREQUESTED - help file is requested
# $NEWMODE - only accept new objects
# $opt_A if send to auto-assign or ASSIGN in Subject line
# $opt_v if LONGACK in subject


sub parserfc822 {
    local($file)=@_;

    local(%header) = ();

    while (<$file>) {

        s/\s+$//;
        
        last if (!$_);
        
        #
	# check to see if this went to auto-assign, then set -A flag
	# Hardcoded and yuck.

	$opt_A = 1 if (/auto\-assign/i);

        if (/^From:\s+(.*)/i) {
	    
	   if (!$header{"ra"}) {
	      $curfield = "ra";
	      $header{$curfield}=$1;
	   }
	   
	   next;
	   
	}
	
	if (/^Cc:\s+(.*)/i) {
           $curfield = "cc";
           $header{$curfield} = $1;
           next;
        }

	if (/^Reply-To:\s+(.*)/i) {
	    
	    $curfield = "rp";
	    
	    if ($header{$curfield}) {
		$header{$curfield}.=", ".$1;
	    }
	    else {
		$header{$curfield}=$1;
	    }
	    
	    next;
	    
	}
	
	if (/^Subject:\s+(.*)/i) {
	   
	   $curfield="sj";
	   $header{$curfield} = $1;
	   
	   next;
	   
	}

	if (/^Message-Id:\s+(.*)/i) {
	   $curfield = "mi";
	   $header{$curfield} = $1;
	   next;
	}

        
          
	if (/^Date:\s+(.*)/i) {
	    $curfield = "dt";
	    $header{$curfield} = $1;
	    next;
	}

	if (/^\s+(\S.*)$/) {
	   
	   if ($curfield) {
	      $header{$curfield}.=" ".$1;
	   }
	    
	   next;
	
	}

	$curfield = "";
	
    }
    
    if ($header{"ra"}) {
		
       $FROM=$header{"ra"};
		
       $REPLYTO=$FROM;
       $REPLYTO=$header{"rp"} if ($header{"rp"}); 
		
       $CC=$header{"cc"};
		
       $SUBJECT=$header{"sj"};
       $opt_v=1 if ($SUBJECT=~ /\bLONGACK\b/i);
       $NEWMODE=1 if ($SUBJECT=~ /\bNEW\b/i);
       $opt_A=1 if ($SUBJECT=~ /\bASSIGN\b/i);
       $HELPREQUESTED=1 if ($SUBJECT=~ /\b(HELP|HOWTO)\b/i);
		
       $MDATE=$header{"dt"};
		
       $MSGID=$header{"mi"};
		
       return $OK;
		
    }
    else {
	    
       return $NOK;
		
    }

}

1;
