#       serial - serialize updates & support routines
#
#	$RCSfile: serial.pl,v $
#	$Revision: 1.1 $
#	$Author: ripe-dbm $
#	$Date: 1995/11/17 14:43:00 $

require "misc.pl";

sub getcurrentserial {
   local($source)=@_;

   if ($LOGFILE{"SERIALDIR"}) {
      open(SERIAL,"<".$LOGFILE{"SERIALDIR"}.$source.".CURRENTSERIAL") || die "getcurrentserial - cannot open serial file\n";
   }
   else {
      open(SERIAL,"<".$TOPDIR."\/".$source.".CURRENTSERIAL") || die "getcurrentserial - cannot open serial file\n";      
   }
   
   &lock(SERIAL) || die "getcurrentserial - cannot lock serial file\n";
   
   local($serial)=<SERIAL>;
   ($serial)=($serial=~ /^\s*(\d+)\s*$/);
      
   print STDERR "CurrentSerial: *$serial*\n" if $opt_V;
   
   &unlock(SERIAL) || die "getcurrentserial - cannot unlock serial file\n";
   close(SERIAL);
    
   return $serial;
}

sub getoldestserial {
   local($source)=@_;

   if ($LOGFILE{"SERIALDIR"}) {
      open(SERIAL,"<".$LOGFILE{"SERIALDIR"}.$source.".OLDESTSERIAL") || die "getoldestserial - cannot open serial file\n";
   }
   else {
      open(SERIAL,"+<".$TOPDIR."\/".$source.".OLDESTSERIAL") || die "getoldestserial - cannot open serial file\n";
   }
   &lock(SERIAL) || die "getoldestserial - cannot lock serial file\n";
   
   local($serial)=<SERIAL>;
   ($serial)=($serial=~ /^\s*(\d+)\s*$/);
      
   print STDERR "OldestSerial: *$serial*\n" if $opt_V;
   
   &unlock(SERIAL) || die "getoldestserial - cannot unlock serial file\n";
   close(SERIAL);
    
   return $serial
}


sub writeseriallog {
   local($transaction, *en)=@_;
   
   # open the serial file
   
   if ($LOGFILE{"SERIALDIR"}) {
      open(SERIAL,"+<".$LOGFILE{"SERIALDIR"}.$en{"so"}.".CURRENTSERIAL") || die "writeseriallog - cannot open serial file in: ", $LOGFILE{"SERIALDIR"}, "\n";
   }
   else {
      open(SERIAL,"+<".$TOPDIR."\/".$en{"so"}.".CURRENTSERIAL") || die "writeseriallog - cannot open serial file in: $TOPDIR\n";
   }
   
   &lock(SERIAL) || die "writeseriallog - cannot lock serial file\n";
   
   # get the serial number ...
   
   local($serial)=<SERIAL>;
   ($serial)=($serial=~ /^\s*(\d+)\s*$/);
   
   # and update it ...
   
   ++$serial;
   seek(SERIAL,0,0);
   print SERIAL $serial;
   
   &unlock(SERIAL) || die "writeseriallog - cannot unlock serial file\n";
   close(SERIAL);
   
   #
   # write a log if needed
   #
   # not most secure but performance is also important...
   #
      
   if ($LOGFILE{"SERIALDIR"}) {
      
      open(OUTP,">".$LOGFILE{"SERIALDIR"}.$en{"so"}.".".$serial); &lock(OUTP);
   
      print OUTP "$transaction\n\n";

      local($oldhandle)=select(OUTP); $|=1;
      &enwrite(*en);
      select($oldhandle);
      
      &unlock(OUTP); close(OUTP);
   }
   
   return $serial;
}

1;
