/***************************************
  $Revision: 1.7 $

  Error reporting (er) erroutines.h  - definition of error reporting aspects.

  Status: NOT REVUED, TESTED, 

  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/* define a list of aspects for debugging. 

   Generally, the aspects for different facilities can have the same values
   and generally, the values don't matter.

   But a good practice is to give lowe values to the messages 
   that are more detailed and appear more often.

   The top 0xFF000000 bits are reserved for special codes common to all
   facilities, such as circular buffer.
 */

typedef enum {
  /* Global */
  
  ASP_CIRC_BUF    = 0x40000000,   /* write also into the circular buffer */
    /* 0x20000000 - 0x01000000  are reserved for global tags */
  
  /* RADIX: */
  ASP_RX_NODCRE_GEN = 0x000080,     /* general node creation tag */
  ASP_RX_NODCRE_DET = 0x000040,     /* also details on node creation */
  ASP_RX_NODCRE_BOT = 0x0000C0,     /* both general and detailed */

  ASP_RX_STKBLD_GEN = 0x000020,     /* general stack building */
  ASP_RX_STKBLD_DET = 0x000010,     /* also detailed stack building */
  ASP_RX_STKBLD_BOT = 0x000030,     /* both general and detailed */
  
  ASP_RX_SRCH_GEN   = 0x000800,     /* search */
  ASP_RX_SRCH_DET   = 0x000400,
  ASP_RX_SRCH_BOT   = 0x000C00,

  ASP_RX_TREE_GEN   = 0x002000,     /* general tree/forest administration */
  ASP_RX_TREE_DET   = 0x001000,     /* detailed */
  ASP_RX_TREE_BOT   = 0x003000,     /* both general and detailed */

  ASP_RX_TREE_WALK  = 0x000001,


  /* Radix payload */
  ASP_RP_PACK_DET   = 0x000100,    /* pack conversion */
  ASP_RP_TREE_DET   = 0x001000,    /* finding tree in forest */
  ASP_RP_LOAD_GEN   = 0x010000,    /* loading of trees */
  ASP_RP_LOAD_DET   = 0x000010,    /* loading of trees - detailed */
  ASP_RP_SRCH_DATA  = 0x000040,    /* search - display 'immediate data' */
  ASP_RP_SRCH_DET   = 0x004000,    /* search - detailed */
  ASP_RP_SRCH_GEN   = 0x040000,    /* search - general */

  
  /* Query instructions */ 
  ASP_QI_LAST_DET   = 0x001000,    /* ids of the objects from the LAST table */
  ASP_QI_SKIP       = 0x004000,    /* query skipped */ 

  ASP_QI_REF_DET    = 0x010000,    /* referral, detailed */
  ASP_QI_REF_GEN    = 0x020000,    /* referral */

  ASP_QI_COLL_DET   = 0x100000,    /* id collection (exec. of subqueries) */
  ASP_QI_COLL_GEN   = 0x200000,    /* query list */

  /* Query command */
  ASP_QC_BUILD      = 0x800000,    /* query preparation */

  /* Threads */
  ASP_TH_NEW        = 0x800000,    /* new thread */
  
  /* Sockets */
  ASP_SK_GEN        = 0x000100,    /* general aspect */
  ASP_SK_WRIT       = 0x000001,    /* writing functions; buffer printed too */

  /* Protocol whois */
  ASP_PW_CONN       = 0x001000,    /* connection opened */
  
  
  /* Protocol whois - aspects for INFO (log) messages */
  ASP_PWI_PASSUN    = 0x010000,    /* unauthorised address passing */
  ASP_PWI_QRYLOG    = 0x100000,    /* log query after it's been processed */
  ASP_PWI_DENTRY    = 0x200000     /* log connection from a denied host */
				      
} er_asp_t;
