/*
  ssh-signer2.h

  Authors: Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 1997-2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.
                  
  Hostbased authentication, client-side. This program is supposed to
  be suid, as it should have access to the private part of the host
  key.
*/

#ifndef SSH_SIGNER2_H
#define SSH_SIGNER2_H

/* Packet types for the over-simple protocol used to converse with
   ssh-signer. */
/* Packet types from ssh2 to ssh-signer2 */

/* Packet payload is a SSH_MSG_USERAUTH_REQUEST packet for
   "hostbased"-authentication.*/
#define SSH_AUTH_HOSTBASED_PACKET    (SshPacketType)1
/* Packet has no payload. */
#define SSH_AUTH_HOSTBASED_END       (SshPacketType)2
/* Packet payload is string, containing a comma-separated list of
   compatibility flags. This is needed to interoperate with older
   versions of sshd2. If this is to be used, it MUST be sent first,
   before any other data, to ssh-signer2. */
#define SSH_AUTH_HOSTBASED_COMPAT    (SshPacketType)5

/* Packet types from ssh-signer2 to ssh2 */
/* Packet payload is the signature for the packet, encoded as
   string. */
#define SSH_AUTH_HOSTBASED_SIGNATURE (SshPacketType)3

/* Common packet types. */
/* Packet payload:      byte    error code (type SshAuthHostBasedError)
                        string  human readable error string (UTF-8)
                        string  language tag (as defined in [RFC-1766])

   After this packet nothing else should sent to the stream, and both
   should close it.  */
#define SSH_AUTH_HOSTBASED_ERROR     (SshPacketType)4

typedef enum
{
  SIGNER_ERROR_GENERIC = 1,
  SIGNER_ERROR_DATA_VERIFICATION_FAILED,
  SIGNER_ERROR_SIGNING_OPERATION_FAILED,
  SIGNER_ERROR_PROTOCOL_ERROR
} SshAuthHostBasedError;

/* Defines for valid compatibility flags. */
#define HOSTBASED_REQUESTED_SERVICE_DRAFT_INCOMPAT "requested-service-name"
#define SIGNATURE_ENCODE_DRAFT_INCOMPAT "signature-encoding"

/* Used in fetching the hostname. */
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 256
#endif /* MAXHOSTNAMELEN */

#endif /* SSH_SIGNER2_H */
