/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/cfile/RCS/get_in_cfile.c,v $
 *
 *
 *  MODULE NAME:    get_in_cfile.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <pwd.h>
#include "BigNum.h"
#include "BigRSA.h"
#include "SPHINX-types.h"
#include "objid.h"
#include "random.h"
#include "hashes.h"
#include "cdc.h"
#include "cdc_db.h"
#include "spxapi_defs.h"

#ifdef sun
#define strcasecmp     strcmp_support
#endif

KTEXT_ST cfile_rpkt_st;
KTEXT cfile_rpkt = &cfile_rpkt_st;      /* response packet from CDC */

#define MAX_SIZE 2*DigitLim*sizeof(BigNumDigit)
struct type_SPHINX_TicketInfo encode_SPHINX_TicketInfo();
struct type_SPHINX_LoginTicket encode_SPHINX_LoginTicket();

#define	ILLEGAL_PASSWORD	-3

int cdc_get_pwd_in_cfile(myname, user, life, s_bitlen, uselocalfile, ca, longname, vflag)
char *myname, *user;
int  life, s_bitlen, uselocalfile;
char *ca, *longname;
int  vflag;
{
    int     ta_index = 0, ta_num = 0, status;
    char user_ava[ANAME_SZ], ca_fullname[FULLNAME_SZ], myname[ANAME_SZ];
    char domain_fullname[FULLNAME_SZ], localcdcfile[80];
    RSAKeyStorage userRSAKey, delegationRSAKey;
    char    *asn1_buf, cdc_server[2*ANAME_SZ], *cp;
    ClaimantCred      cred;
    TrustedCred       *ta_cred;
    TrustedAuthority  *ta;
    struct type_SPHINX_Certificate            *tacertif;
    struct type_SPHINX_LoginTicket            *userTicket;
    struct type_SPHINX_TicketInfo             *tktinfo;
    struct passwd       *pwd;
    DESblock pwkey;
    char  privkey[sizeof(RSAKeyStorage)];
    int privkeylen;

    if (longname[0] != '/') {
      strcpy(domain_fullname, get_domain_name(NULL));
      strcpy(ca_fullname, domain_fullname);
      strcat(ca_fullname, "/");
      strcat(ca_fullname, ca);
      strcpy(cred.fullname, ca_fullname);
      strcat(cred.fullname, "/");
      strcat(cred.fullname, longname);
    } else {
      strcpy(cred.fullname, longname);
      strcpy(ca_fullname, cred.fullname);
      if ((cp = rindex(ca_fullname, '/')) != 0)
	*cp = 0;
      strcpy(domain_fullname, ca_fullname);
      if ((cp = rindex(domain_fullname, '/')) != 0)
	*cp = 0;
    }

    if (uselocalfile) {
      char uuid[UID_SZ], hashk[MD_BLOCK_SIZE];
      int uidlen;

      pwd = getpwuid(getuid());
      strcpy(myname, pwd->pw_name);

      strcpy(localcdcfile, pwd->pw_dir);
      strcat(localcdcfile, "/.SPX_");
      strcat(localcdcfile, myname);
      strcat(localcdcfile, ".privkey");

      status = cfile_file_hexread(localcdcfile, cfile_rpkt->dat, &cfile_rpkt->length);
      if (!status) {
	printf("unable to read encrypted private key from local file\n");
	return(-1);
      }
      status = check_login_res_apdu(cfile_rpkt->dat, cfile_rpkt->length, privkey, &privkeylen, 0);
    } else {
      if ((status=read_login_cstub(cred.fullname, 0, privkey, &privkeylen, cdc_server, 0)) != 0) {
        return(status);
      }
    }
    DES_read_password(&pwkey, "password: ", 0);
    if(!recover_private(&pwkey,privkey,privkeylen,&userRSAKey)) {
      bzero(&pwkey, sizeof(pwkey));
      bzero(privkey, sizeof(privkey));
      bzero(&userRSAKey, sizeof(userRSAKey));
      return(ILLEGAL_PASSWORD);
    }
    bzero(&pwkey, sizeof(pwkey));
    bzero(privkey, sizeof(privkey));

    dest_claimant(0);
    /*  get user's uid if one exists from ta certif  */

    ta_cred = (TrustedCred *) malloc(sizeof(TrustedCred));
    ta_cred->count = 0;
    ta_cred->head = NULL;
    ta_index = 0;
    if (build_ta_cred(uselocalfile,cred.fullname,2,&ta_index,ta_cred,&userRSAKey,&tacertif,cdc_server)>0) {
      char uuid[UID_SZ];
      int  uidlen;
      if(uid_from_certif(tacertif->cinfo, uuid, &uidlen, cred.uuid, &cred.uidlen));
      else {
	printf("Warning: UIDs don't exist in TA certificates, set to 0\n");
	bzero(cred.uuid, UID_SZ);
	cred.uidlen = 0;
      }
      free_SPHINX_Certificate(tacertif);
    } else {
      printf("%s: verify of ta failed.\n", __FILE__);
      bzero(&userRSAKey, sizeof(userRSAKey));
      return(-1);
    }
    if (ta_index != 0)  printf("Warning: didn't get all the TAs for %s\n",user);

    /*  initialize credential file cache  */

    if (spx_in_tkt(myname, user, NULL) != ASUCCESS) {
      printf("%s: unable to initialize ticket file\n", __FILE__);
      bzero(&userRSAKey, sizeof(userRSAKey));
      return(-1);
    }
    if (spx_tf_init(spx_tkt_string(myname, NULL), W_TKT_FIL) != ASUCCESS) {
      printf("%s: cannot spx_tf_init\n",__FILE__);
      bzero(&userRSAKey, sizeof(userRSAKey));
      return(-1);
    }
    if (spx_tf_get_pname(cred.name) != ASUCCESS) {
      printf("%s: spx_tf_get_pname error\n",__FILE__);
      bzero(&userRSAKey, sizeof(userRSAKey));
      return(-1);
    }

    /*  generate new RSA session key  */

    initialize_rng_state(&userRSAKey.q[3], 16);
    cred.bitlen = s_bitlen;
    if (newRSAKey (s_bitlen, &delegationRSAKey));
    else  {
      printf("\n%s: error generating session keys\n", __FILE__);
      bzero(&userRSAKey, sizeof(userRSAKey));
      return(-1);
    }
    cred.s_privRSAKey = &delegationRSAKey;

    cred.before = time(0);
    cred.after = cred.before + life * 60;
    cred.deleg_flag = 1;

    /*  build ticket info structure */

    if (create_ticket_aux (&delegationRSAKey, &cred, &tktinfo));
    else {
        printf("\n%s: Error creating user ticket.\n", __FILE__);
        bzero(&userRSAKey, sizeof(userRSAKey));
        return(-1);
    }
    
    /*  produce signature over ticket info  */
    /*  build user ticket w/ signature  */

    if (rsamd2_sign_aux(tktinfo, encode_SPHINX_TicketInfo, &userRSAKey, &userTicket));
    else {
        printf("\n%s: Error signing user ticket.\n", __FILE__);
        bzero(&userRSAKey, sizeof(userRSAKey));
        return(-1);
    }

    if (ber_encode(userTicket, encode_SPHINX_LoginTicket, PS_LEN_LONG,
                                          &asn1_buf, &cred.userticket_len) == NOTOK) {
        printf("\n%s: Error encoding signed user ticket.\n", __FILE__);
        return(-1);
    }

    bcopy(asn1_buf, cred.userticket, cred.userticket_len);
    free(asn1_buf);
    free_SPHINX_LoginTicket(userTicket);    

    /*
     * Remove private key components.
     */
    Private2Public (&userRSAKey);

    /*  write out claimant credentials  */

    if (vflag) {
      printf("display claimant credentials\n");
      display_claimant_cred(&cred, 1);
      printf("  userticket_len is %d\n",cred.userticket_len);
      printf("  userticket   :\n");
      hexdump(cred.userticket, cred.userticket_len);
    }

    spx_tf_save_cred(&cred);
    bzero(&delegationRSAKey, sizeof(delegationRSAKey));

    /*  get more ta(s) if exist  */

    ta = ta_cred->head;
    while (ta) {
      if (strcasecmp(ca_fullname, ta->fullname) == 0) {
	bcopy(ta->pubRSAKey , &userRSAKey, PUBLIC_KEY_SIZE);
	ta_index = 0;
	build_ta_cred(uselocalfile,ca_fullname,1,&ta_index,ta_cred,&userRSAKey,&tacertif,cdc_server);
	break;
      }
      ta = ta->next;
    }

    while (ta) {
      if (strcasecmp(domain_fullname, ta->fullname) == 0) {
	bcopy(ta->pubRSAKey , &userRSAKey, PUBLIC_KEY_SIZE);
	ta_index = 0;
	build_ta_cred(uselocalfile,domain_fullname,0,&ta_index,ta_cred,&userRSAKey,&tacertif,cdc_server);
	break;
      }
      ta = ta->next;
    }

    spx_tf_save_ta(ta_cred);

    if (vflag) {
        printf("  '%s' ",cred.fullname);
        display_ta_cred(ta_cred, 1);
    }
    spx_tf_close();
    return(0);
}


int cdc_put_in_file(myname, localcdcfile, ca, longname, vflag)
char *myname, *localcdcfile, *ca, *longname;
int vflag;
{
    int     ta_index = 0, ta_num = 0, status, len, i;
    char fullname[FULLNAME_SZ], filename[80];
    char user_ava[ANAME_SZ], ca_fullname[FULLNAME_SZ];
    char domain_fullname[FULLNAME_SZ];
    char    *asn1_buf, cdc_server[2*ANAME_SZ], *cp;
    KTEXT_ST   pkt_st;
    KTEXT      pkt = &pkt_st;

    if (longname[0] != '/') {
      strcpy(domain_fullname, get_domain_name(NULL));
      strcpy(ca_fullname, domain_fullname);
      strcat(ca_fullname, "/");
      strcat(ca_fullname, ca);
      strcpy(fullname, ca_fullname);
      strcat(fullname, "/");
      strcat(fullname, longname);
    } else {
      strcpy(fullname, longname);
      strcpy(ca_fullname, fullname);
      if ((cp = rindex(ca_fullname, '/')) != 0)
	*cp = 0;
      strcpy(domain_fullname, ca_fullname);
      if ((cp = rindex(domain_fullname, '/')) != 0)
	*cp = 0;
    }

    if ((build_login_req_apdu(pkt, 0, fullname, NULL, 0, vflag)) < 0) {
      return(CDC_BUILD_REQ_ERROR);
    }

    if (send_to_cdc(pkt, cfile_rpkt, fullname, cdc_server) != ASUCCESS) {
      return(CDC_UNAVAILABLE);
    }

    printf("saving encrypted private key in '%s.privkey' ... ", localcdcfile);
    strcpy(filename, localcdcfile);
    strcat(filename, ".privkey");
    status = cfile_file_hexdump(filename, cfile_rpkt->dat, cfile_rpkt->length);
    if (status) printf("success\n");
    else printf("fail\n");

    ta_index = 0;
    if ((i = build_tacertif_req_apdu(pkt, 0, ta_index, fullname, vflag)) < 0)
      return(CDC_BUILD_REQ_ERROR);

    if (send_to_cdc(pkt, cfile_rpkt, fullname, cdc_server) != ASUCCESS)
      return(CDC_UNAVAILABLE);

    printf("saving TA certif for User in '%s.userTA' ... ", localcdcfile);
    strcpy(filename, localcdcfile);
    strcat(filename, ".userTA");
    status = cfile_file_hexdump(filename, cfile_rpkt->dat, cfile_rpkt->length);
    if (status) printf("success\n");
    else printf("fail\n");

    ta_index = 0;
    if ((i = build_tacertif_req_apdu(pkt, 0, ta_index, ca_fullname, vflag)) < 0)
      return(CDC_BUILD_REQ_ERROR);

    if (send_to_cdc(pkt, cfile_rpkt, ca_fullname, cdc_server) != ASUCCESS)
      return(CDC_UNAVAILABLE);

    printf("saving TA certif for CA in '%s.caTA' ... ", localcdcfile);
    strcpy(filename, localcdcfile);
    strcat(filename, ".caTA");
    status = cfile_file_hexdump(filename, cfile_rpkt->dat, cfile_rpkt->length);
    if (status) printf("success\n");
    else printf("fail\n");

    ta_index = 0;
    if ((i = build_tacertif_req_apdu(pkt, 0, ta_index, domain_fullname, vflag)) < 0)
      return(CDC_BUILD_REQ_ERROR);

    if (send_to_cdc(pkt, cfile_rpkt, domain_fullname, cdc_server) != ASUCCESS)
      return(CDC_UNAVAILABLE);

    printf("saving TA certif for Domain in '%s.domainTA' ... ", localcdcfile);
    strcpy(filename, localcdcfile);
    strcat(filename, ".domainTA");
    status = cfile_file_hexdump(filename, cfile_rpkt->dat, cfile_rpkt->length);
    if (status) printf("success\n");
    else printf("fail\n");
}

int cfile_file_hexdump(name, p, l)
char *name;
char *p;
int l;
{
  int i;
  FILE *fopen(), *f;


  if (!(f = fopen(name, "w+"))) {
        return(0);
  }

  for (i=0; i<l; i++)  {
    if ((i>0) && (i%16 == 0))  fprintf(f, "\n");
    fprintf(f, " %02x", (unsigned char ) p[i]);
  }
  fprintf(f, "\n");
  fclose(f);
  return(1);
}

int cfile_file_hexread(name, p, l)
char *name;
char *p;
int *l;
{
  int i, hex1, hex2;
  FILE *fopen(), *f;


  if (!(f = fopen(name, "r"))) {
        return(0);
  }

  i = 0;
  while (fscanf(f, " %1x%1x", &hex1, &hex2) == 2) {
    p[i] = (hex1<<4)+hex2;
    i++;
  }
  fclose(f);
  *l = i;
  return(1);
}

