/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/cdc/RCS/send_to_cdc.c,v $
 *
 *
 *  MODULE NAME:    send_to_cdc.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/time.h>
#ifdef ultrix
#include <unistd.h>
#include <signal.h>
#endif
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <strings.h>
#include "cdc.h"
#include "cdc_db.h"
#ifdef lint
#include <sys/uio.h>            /* struct iovec to make lint happy */
#endif /* lint */

#ifdef sun
typedef long   fd_mask;

#define NBBY    8               /* number of bits in a byte */

#define NFDBITS (sizeof(fd_mask) * NBBY)        /* bits per mask (power of 2!)*/
#define NFDSHIFT 5                              /* Shift based on above */

#define FD_SET(n, p)    ((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define FD_CLR(n, p)    ((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define FD_ISSET(n, p)  ((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)      bzero((char *)(p), sizeof(*(p)))
#endif

extern int errno;
extern int cdc_debug;

extern char *malloc(), *calloc(), *realloc();

int cdc_tcp_port = 0;

/* CLIENT_CDC_TIMEOUT indicates the time to wait before
 * retrying a server.  It's defined in "cdc.h".
 */
static struct timeval timeout = { CLIENT_CDC_TIMEOUT, 0};
static char *prog = "send_to_cdc";
static send_recv();

/*
 * This file contains two routines, send_to_cdc() and send_recv().
 * send_recv() is a static routine used by send_to_cdc().
 */

int send_to_cdc(pkt,rpkt,cdc_domain,cdc_server)
KTEXT pkt;
KTEXT rpkt;
char *cdc_domain;
char *cdc_server;
{
  int i, f;
  int retry;
  int n_hosts;
  int retval;
  struct sockaddr_in to;
  struct hostent *host;
  char *cp;
  char host_names[8][ANAME_SZ];
  unsigned char *tmpaddress;
  unsigned long addrval;

  /* from now on, exit through rtn label for cleanup */

  /* get an initial allocation */
  n_hosts = 0;
  find_cdc(cdc_domain, &n_hosts, host_names);
  if (cdc_debug) {
    for (i=0; i<n_hosts; i++)
      printf("host #%d is %s\n", i+1, host_names[i]);
  }

  if (n_hosts == 0) {
    if (cdc_debug)
      fprintf(stderr, "%s: can't find any CDC server hosts for domain '%s'.\n",
	      prog, cdc_domain);
    return(CDC_UNKNOWN_HOST);
  }

  if ((cdc_server) && (cdc_server[0] != '\0')) {
    /*
     *  check if we have a match for cdc server name from our list
     */
    for (i=0; i<n_hosts; i++) {
      if (strcmp(cdc_server, host_names[i]) == 0)
	break;
    }
    if (i >=  n_hosts) i = 0;
  } else i=0;

  if (cdc_tcp_port == 0) {
    register struct servent *sp;
    if ((sp = getservbyname("cdc","tcp")) == 0)
      cdc_tcp_port = htons(CDC_PORT);
    else
      cdc_tcp_port = sp->s_port;
    if (cdc_debug)
      printf("cdc_tcp_port is %d\n", cdc_tcp_port);
  }

  while (i < n_hosts) {

    if ((f = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
      if (cdc_debug)
	fprintf(stderr,"%s: Can't open socket\n", prog);
      return(CDC_SOCK_FAIL);          /*  can't create socket for request  */
    }

    if (cdc_debug) {
      printf("Getting host entry for %s...",host_names[i]);
      (void) fflush(stdout);
    }

    host = gethostbyname(host_names[i]);

    if (cdc_debug) {
      printf("%s.\n",host ? "Got it" : "Didn't get it");
      (void) fflush(stdout);
    }

    if (!host) {
      addrval = inet_addr(host_names[i]);
      if (addrval != -1) {
        host = (struct hostent *) malloc(sizeof(struct hostent));
        host->h_name = (char *) host_names[i];
        host->h_aliases = NULL;
        host->h_addrtype = AF_INET;
        host->h_length = 4;
        addrval = htonl(addrval);
        tmpaddress = (unsigned char *) malloc(4);
        tmpaddress[0] = ((addrval & 0xff000000) >> 24);
        tmpaddress[1] = ((addrval & 0xff0000) >> 16);
        tmpaddress[2] = ((addrval & 0xff00) >> 8);
        tmpaddress[3] = (addrval & 0xff);
        host->h_addr_list = (char **) &tmpaddress;
      } else {
        i++;
        continue;
      }
    }
    
    cp = malloc((unsigned)host->h_length);
    if (!cp) {
      retval = /*errno */CDC_MALLOC_ERR;
      close(f);
      goto rtn;
    }

    bzero((char *)&to, S_AD_SZ);
    bcopy((char *)host->h_addr, cp, host->h_length);
    host->h_addr = cp;
    to.sin_family = host->h_addrtype;
    bcopy(host->h_addr, (char *)&to.sin_addr,
	  host->h_length);
    to.sin_port = cdc_tcp_port;

    if ((retval = send_recv(pkt, rpkt, f, &to)) == ASUCCESS) {
      if (cdc_debug)
	printf("correct cdc_server is '%s'\n", host_names[i]);
      if (cdc_server)
        strcpy(cdc_server, host_names[i]);
      close(f);
      goto rtn;
    }

    if (cdc_debug) {
      printf("send_recv returns %d, move on to next CDC hostname\n", retval);
      (void) fflush(stdout);
    }
    i++;
    close(f);
  }
 
 rtn:
  return(retval);
}

/*
 * try to send out and receive message.
 * return 1 on success, 0 on failure
 */

static send_recv(pkt,rpkt,f,_to)
    KTEXT pkt;
    KTEXT rpkt;
    int f;
    struct sockaddr_in *_to;
{
    fd_set readfds;
    int sin_size, cc;
    int numsent, length, i;
    struct sockaddr  to_name;
#ifdef ultrix
    int send_recv_timout();
#endif

    if (cdc_debug) {
        if (_to->sin_family == AF_INET)
            printf("Sending message to %s...",
                   inet_ntoa(_to->sin_addr));
        else
            printf("Sending message...");
        (void) fflush(stdout);
    }

#ifdef ultrix
    signal(SIGALRM, send_recv_timout);
    alarm(CLIENT_CDC_TIMEOUT);
#endif

    if (connect(f, (struct sockaddr *)_to, S_AD_SZ) < 0) {
      if (cdc_debug) {
        printf("connect error - errno is %d\n", errno);
      }
      alarm(0);
      return(CDC_CONNECT_ERR);
    }
    alarm(0);

    if ((numsent = write(f, (char *)(pkt->dat), pkt->length))
	!= pkt->length) {
        if (cdc_debug)
            printf("sent only %d/%d\n",numsent, pkt->length);
        return(CDC_WRITE_ERR);
    }

    if (cdc_debug) {
        printf("Sent\nWaiting for reply...");
        (void) fflush(stdout);
    }
    FD_ZERO(&readfds);
    FD_SET(f, &readfds);
    errno = 0;
    /* select - either recv is ready, or timeout */
    /* see if timeout or error or wrong descriptor */

    if (cdc_debug) {
      printf("call read(f, )\n");
      (void) fflush(stdout);
    }
#ifdef ultrix
    signal(SIGALRM, send_recv_timout);
    alarm(CLIENT_CDC_READ_TIMEOUT);
#endif
    if ((cc = read(f, (char *)(rpkt->dat), sizeof(rpkt->dat))) <= 0) {
        if (cdc_debug)
            printf("read response error - %d\n", cc);
	alarm(0);
        return(CDC_READ_ERR);
    }
    alarm(0);
/*
 * check if we read everything - received packet must be BER encoded (TLV)
 *
 *   WARNING : If packet is indefinite length encoded, we don't guarantee
 *             that it will be received completely across segmented networks.
 */

    length = DecodeTotalLength((char *)(rpkt->dat));

    if (cdc_debug) {
      printf("did we read everything ... received %d, expecting %d\n", cc, length);
      printf("sizeof buffer is %d\n", sizeof(rpkt->dat));
      (void) fflush(stdout);
    }
    
#ifdef ultrix
    signal(SIGALRM, send_recv_timout);
    alarm(CLIENT_CDC_READ_TIMEOUT);
#endif
    while (cc < length) {
      if ((i = read(f, (char *)(&rpkt->dat[cc]), sizeof(rpkt->dat)-cc)) < 0) {
        if (cdc_debug)
	  printf("read response error\n");
	alarm(0);
        return(CDC_READ_REST_ERR);
      }
      cc = cc + i;
    }
    alarm(0);

    rpkt->length = cc;
    if (cdc_debug) {
      printf("Received it\n");
      (void) fflush(stdout);
    }
    return(ASUCCESS);
}

int send_recv_timout()
{
  return(CDC_TIMEOUT);
}
