/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/cdc/RCS/build_req_apdu.c,v $
 *
 *
 *  MODULE NAME:    build_req_apdu.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include "SPHINX-types.h"
#include "cdc.h"
#include "cdc_db.h"

extern int ps_len_strategy;

int build_login_req_apdu(pkt, flag, fullname, logindata, logindata_len, debugflag)
KTEXT          pkt;
char           flag, *fullname;
unsigned char  *logindata;
int            logindata_len, debugflag;
{
  struct type_SPHINX_CDCAPDU  *cdc_request;
  struct type_SPHINX_ReadPrinLoginRequest  *loginreq;
  char   *asn1_buf;
  int    asn1len = 0;
  PE     cdc_req_apdu_pe;

  ps_len_strategy = PS_LEN_LONG;
  cdc_request = (struct type_SPHINX_CDCAPDU *) malloc(sizeof(struct type_SPHINX_CDCAPDU));
  cdc_request->offset = type_SPHINX_CDCAPDU_readPrinLoginRequest;
  loginreq = (struct type_SPHINX_ReadPrinLoginRequest *)
    malloc(sizeof(struct type_SPHINX_ReadPrinLoginRequest));
  cdc_request->un.readPrinLoginRequest = loginreq;

  if (flag != 0)
    loginreq->flags = strb2bitstr(&flag, 8, PE_CLASS_UNIV, PE_PRIM_BITS);
  else loginreq->flags = NULL;

  loginreq->principal = (struct type_SPHINX_Name *) str_to_rdn(fullname);

  if (logindata == NULL)
    loginreq->logindata = NULL;
  else
    loginreq->logindata=strb2bitstr(&logindata,logindata_len*8,PE_CLASS_UNIV,PE_PRIM_BITS);

  encode_SPHINX_CDCAPDU(&cdc_req_apdu_pe, 1, NULL, NULLCP, cdc_request);
  pe2ssdu(cdc_req_apdu_pe, &asn1_buf, &asn1len);
  pkt->length = asn1len;
  bcopy(asn1_buf, pkt->dat, asn1len);
  pkt->mbz = 0;
  free_SPHINX_CDCAPDU(cdc_request);
  return(ASUCCESS);
}

int build_certif_req_apdu(pkt, flag, index, resolvefrom, fullname, crossnames, debugflag)
KTEXT pkt;
char  flag;
int   index;
char  *resolvefrom, *fullname;
CrossNameList  *crossnames;
int   debugflag;
{
  struct type_SPHINX_CDCAPDU  *cdc_request;
  struct type_SPHINX_ReadPrinCertRequest  *certreq;
  struct type_SPHINX_ListOfNames   *crossdomain;
  char   *asn1_buf;
  int    asn1len = 0, numnames, i;
  PE     cdc_req_apdu_pe;

  if (debugflag) {
    printf("build certif apdu for '%s'\n", fullname);
    printf("  flag is %d, num of crossname is %d\n", flag, crossnames->num);
    printf("  index is %d\n", index);
    printf("  resolvefrom is '%s'\n", resolvefrom);
  }

  ps_len_strategy = PS_LEN_LONG;
  cdc_request = (struct type_SPHINX_CDCAPDU *) malloc(sizeof(struct type_SPHINX_CDCAPDU));
  cdc_request->offset = type_SPHINX_CDCAPDU_readPrinCertRequest;
  certreq = (struct type_SPHINX_ReadPrinCertRequest *) malloc(sizeof(struct type_SPHINX_ReadPrinCertRequest));
  cdc_request->un.readPrinCertRequest = certreq;

  if (flag != 0)
    certreq->flags = strb2bitstr(&flag, 8, PE_CLASS_UNIV, PE_PRIM_BITS);
  else certreq->flags = NULL;

  if (index != 0)  certreq->index = index;
  else certreq->index = NULL;

  if (resolvefrom != 0)
    certreq->resolveFrom = (struct type_SPHINX_Name *) str_to_rdn(resolvefrom);
  else certreq->resolveFrom = NULL;

  certreq->principal = (struct type_SPHINX_Name *) str_to_rdn(fullname);

  numnames = crossnames->num;

  if (numnames > 0) {
    if (debugflag)  printf("check name of crosscertifiers\n");
    for (i=0; i < numnames; i++) {
      if (i == 0) {
	crossdomain = (struct type_SPHINX_ListOfNames *) malloc(sizeof(struct type_SPHINX_ListOfNames));
	certreq->crossDomains = crossdomain;
      } else {
	crossdomain = crossdomain->next;
	crossdomain = (struct type_SPHINX_ListOfNames *) malloc(sizeof(struct type_SPHINX_ListOfNames));
      }
      if (debugflag)
	printf("    ... '%s'\n", crossnames->names[i]);
      crossdomain->Name = (struct type_SPHINX_Name *) str_to_rdn(crossnames->names[i]);
      crossdomain->next = NULL;
    }
  } else certreq->crossDomains = NULL;

  encode_SPHINX_CDCAPDU(&cdc_req_apdu_pe, 1, NULL, NULLCP, cdc_request);
  pe2ssdu(cdc_req_apdu_pe, &asn1_buf, &asn1len);
  pkt->length = asn1len;
  bcopy(asn1_buf, pkt->dat, asn1len);
  pkt->mbz = 0;
  free_SPHINX_CDCAPDU(cdc_request);
  return(ASUCCESS);
}

int build_tacertif_req_apdu(pkt, flag, index, fullname, debugflag)
KTEXT pkt;
char  flag;
int   index;
char  *fullname;
int   debugflag;
{
  struct type_SPHINX_CDCAPDU  *cdc_request;
  struct type_SPHINX_ReadTACertRequest  *tacertreq;
  char   *asn1_buf;
  int    asn1len = 0;
  PE     cdc_req_apdu_pe;

  ps_len_strategy = PS_LEN_LONG;
  cdc_request = (struct type_SPHINX_CDCAPDU *) malloc(sizeof(struct type_SPHINX_CDCAPDU));
  cdc_request->offset = type_SPHINX_CDCAPDU_readTACertRequest;
  tacertreq = (struct type_SPHINX_ReadTACertRequest *) malloc(sizeof(struct type_SPHINX_ReadTACertRequest));
  cdc_request->un.readTACertRequest = tacertreq;

  if (flag != 0)
    tacertreq->flags = strb2bitstr(&flag, 8, PE_CLASS_UNIV, PE_PRIM_BITS);
  else tacertreq->flags = NULL;

  if (index != 0) tacertreq->index = index;
  else tacertreq->index = NULL;

  tacertreq->principal = (struct type_SPHINX_Name *) str_to_rdn(fullname);

  encode_SPHINX_CDCAPDU(&cdc_req_apdu_pe, 1, NULL, NULLCP, cdc_request);
  pe2ssdu(cdc_req_apdu_pe, &asn1_buf, &asn1len);
  pkt->length = asn1len;
  bcopy(asn1_buf, pkt->dat, asn1len);
  pkt->mbz = 0;
  free_SPHINX_CDCAPDU(cdc_request);
  return(ASUCCESS);
}
