/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/cdb_gdbm/RCS/add_ca.c,v $
 *
 *
 *  MODULE NAME:    add_ca.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include "cdc.h"
#include "cdc_db.h"
#include "BigNum.h"
#include "BigRSA.h"

int add_ca(p_name, ca_name)
char *p_name, *ca_name;
{
  char           relativename[FULLNAME_SZ], certif[CERTIF_SZ];
  char           uuid[UID_SZ], hashkey[8], pubkey[PUBLIC_KEY_SIZE];
  char           prin_ava[ANAME_SZ];
  int            certiflen, uidlen, pubkeylen;

  if (strcmp(p_name, ".") == 0) {
    strcpy(relativename, ".");
  } else {
    if ((read_key(p_name, 1, prin_ava, uuid, &uidlen, hashkey, pubkey, &pubkeylen)) < 0)
      return(-1);
    strcpy(relativename, prin_ava);
  }

  certiflen = 0;
  bzero(certif, CERTIF_SZ);
  if ((read_certif(p_name, ca_name, certif, &certiflen))<0)
    return(-1);
  if (cdb_add_entry(relativename, TA_CERTIF_ATTRIB, certif, certiflen) < 0)
    return(-1);

  certiflen = 0;
  bzero(certif, CERTIF_SZ);
  if ((read_certif(ca_name, p_name, certif, &certiflen))<0)
    return(-1);
  if (cdb_add_entry(relativename, CERTIF_ATTRIB, certif, certiflen) < 0)
    return(-1);

  return (0);
}


int add_ta_certif(p_name, ca_name)
char *p_name, *ca_name;
{
  char           relativename[FULLNAME_SZ], certif[CERTIF_SZ];
  char           uuid[UID_SZ], hashkey[8], pubkey[PUBLIC_KEY_SIZE];
  char           ava[ANAME_SZ];
  int            certiflen, uidlen, pubkeylen;

  if (strcmp(ca_name, ".") == 0) {
    strcpy(relativename, ".");
  } else {
    if ((read_key(ca_name, 1, ava, uuid, &uidlen, hashkey, pubkey, &pubkeylen)) < 0)
      return(-1);
    strcpy(relativename, ava);
  }

  certiflen = 0;
  bzero(certif, CERTIF_SZ);
  if ((read_certif(ca_name, p_name, certif, &certiflen))<0)
    return(-1);
  if (cdb_add_entry(relativename, TA_CERTIF_ATTRIB, certif, certiflen) < 0)
    return(-1);

  return (0);
}
