
/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#ifndef SPXAPI_DEFS
#define SPXAPI_DEFS


#define SIGNATURE_SZ            128
#define USERTICKET_SZ           360
#define DESKEY_SZ               8
#define ENCRYPKEY_SZ            96
#define EVIDENCE_SZ             256
#define MUTUAL_RESP_SZ          16
#define MAX_TOKEN_SZ            1600
#define MAX_REPLAY_ENTRIES      300

struct TrustedAuthorityStruct {
    char              fullname[FULLNAME_SZ];
    int               uidlen;
    char              uuid[UID_SZ];
    RSAKeyStorage     *pubRSAKey;
    int               cross_certifier;
    struct TrustedAuthorityStruct  *next;
};

typedef struct TrustedAuthorityStruct  TrustedAuthority;

typedef struct {
    int                count;
    TrustedAuthority   *head;
}  TrustedCred;

typedef struct {
    char           name[ANAME_SZ];
    char           fullname[FULLNAME_SZ];
    int            uidlen;
    char           uuid[UID_SZ];
    int            before;
    int            after;
    int            deleg_flag;
    int            bitlen;
    RSAKeyStorage  *s_privRSAKey;
    int            userticket_len;
    char           userticket[USERTICKET_SZ];
} ClaimantCred;

typedef struct {
    char           name[ANAME_SZ];
    char           fullname[FULLNAME_SZ];
    int            uidlen;
    char           uuid[UID_SZ];
    int            before;
    int            after;
    RSAKeyStorage  *privRSAKey;
} VerifierCred;

typedef struct {
    DESblock	   deskey;
    int            before;
    int            after;
    int            deleg_flag;
    int	           chanbinding_len;
    int            verifier_fn_len;
    int            token_len;
    char           charbuf[FULLNAME_SZ+MAX_TOKEN_SZ];
} Claimant_ContextCache;

typedef struct {
    DESblock	   deskey;
    int            before;
    int            after;
    int            deleg_flag;
    int            claimant_fn_len;
    int            encryptedkey_len;
    char           charbuf[FULLNAME_SZ+ENCRYPKEY_SZ];
} Verifier_ContextCache;

typedef struct {
    int            timestamp;
    DESblock       mac ;
} ReplayCache_Entry;

typedef struct {
    int            index;
    ReplayCache_Entry  entries[MAX_REPLAY_ENTRIES];
} ReplayCache;

typedef struct {
    DESblock	   deskey;
    char           issuer_ln[ANAME_SZ];
    char           issuer_fn[FULLNAME_SZ];
    char           claimant_file[FULLNAME_SZ];
    int            deleg_flag;
    char           mutual_len;
    char           mutual_resp[MUTUAL_RESP_SZ];
} ContextHandle;

typedef struct {
    ClaimantCred      *clm_handle;
    VerifierCred      *ver_handle;
    TrustedCred       *ta_handle;
    char              credential_file[FULLNAME_SZ];
} SPXCredentials;

typedef struct {
    char              mechtype[ANAME_SZ];
    int               mechlen;
    ContextHandle     *context_handle;
} SPXContextHandle;

#define SPX_S_SUCCESS                       1

/*
 *  SPX Acquire credentials status
 */

#define SPX_S_ACQUIRE_SUCCESS               1

#define SPX_S_UNABLE_TO_ACCESS_CLAIM_CRED        -1
#define SPX_S_UNABLE_TO_ACCESS_VERIF_CRED        -2
#define SPX_S_CLAIM_CRED_CORRUPT                 -3
#define SPX_S_VERIF_CRED_CORRUPT                 -4
#define SPX_S_CLAIM_CRED_EXPIRED                 -5
#define SPX_S_VERIF_CRED_EXPIRED                 -6
#define SPX_S_CLAIM_CRED_NOT_VALID_YET           -7
#define SPX_S_VERIF_CRED_NOT_VALID_YET           -8

/*
 *  SPX Init security context status
 */

#define   SPX_S_INIT_SUCCESS                1
#define   SPX_S_INIT_CONTINUE               2

#define   SPX_S_NOT_PROPER_CRED              -11
#define   SPX_S_TICKET_EXPIRED               -12
#define   SPX_S_TICKET_NOT_VALID_YET         -13
#define   SPX_S_CLAIM_UNABLE_TO_ACCESS_CDC   -14
#define   SPX_S_CLAIM_VERIFY_PUBKEY_FAILED   -15
#define   SPX_S_CLAIM_CANT_FIND_CERTIF_PATH  -16  /*  general error  */
#define   SPX_S_RSA_SIGN_ERROR               -17
#define   SPX_S_CANT_ESTAB_CLAIMANT_CRED     -18
#define   SPX_S_MUTUAL_RESPONSE_BAD          -19

/*
 *  SPX Accept security context status
 */

#define   SPX_S_ACCEPT_SUCCESS              1

#define   SPX_S_BAD_TOKEN_FORMAT                   -21
#define   SPX_S_UNSUPPORTED_TOKEN                  -22
#define   SPX_S_NO_NAME_IN_TOKEN                   -23
#define   SPX_S_VERIF_UNABLE_TO_ACCESS_CDC         -24
#define   SPX_S_VERIF_VERIFY_PUBKEY_FAILED         -25
#define   SPX_S_VERIF_CANT_FIND_CERTIF_PATH        -26  /*  general error  */
#define   SPX_S_WRONG_EVID_IN_TOKEN                -27
#define   SPX_S_ERROR_EXTRACTING_DESKEY            -28
#define   SPX_S_DESKEY_EXPIRED                     -29
#define   SPX_S_INVALID_AUTHENTICATOR              -30
       /* may be bad chanbinding */
#define   SPX_S_ILLEGAL_TICKET                     -31
#define   SPX_S_DELEGATOR_EVID_FAILED              -32
#define   SPX_S_VERIFY_TICKET_FAILED               -33
#define   SPX_S_CANT_ESTAB_DELEGATED_CLAIM_CRED    -34
#define   SPX_S_AUTHENTICATOR_ASKEW                -35

#define   SPX_S_CLAIM_CANT_FIND_CERTIF_PATH_GOING_UP        -40
#define   SPX_S_CLAIM_CANT_FIND_CERTIF_PATH_GOING_DN        -41

#define   SPX_S_VERIF_CANT_FIND_CERTIF_PATH_GOING_UP        -42
#define   SPX_S_VERIF_CANT_FIND_CERTIF_PATH_GOING_DN        -43

#define   SPX_S_CLAIM_TARGET_IN_UNKNOWN_DOMAIN              -44
#define   SPX_S_CLAIM_READ_PUB_KEY_ERROR                    -45

#define   SPX_S_VERIF_TARGET_IN_UNKNOWN_DOMAIN              -46
#define   SPX_S_VERIF_READ_PUB_KEY_ERROR                    -47

#define   SPX_S_CLAIM_CERTIFS_DONT_EXIST_IN_CDC     -48
#define   SPX_S_VERIF_CERTIFS_DONT_EXIST_IN_CDC     -49

#define   SPX_S_FWD_CLAIM_UNABLE_TO_ACCESS_CDC          -54
#define   SPX_S_FWD_VERIF_UNABLE_TO_ACCESS_CDC          -55

#define   SPX_S_ACCEPT_WITH_CHALLENGE                   -57
#define   SPX_S_FAILURE_WITH_CHALLENGE                  -58

/*
 *  SPX Make response status
 */

#define   SPX_S_ILLEGAL_PASSWORD                   -51
#define   SPX_S_ERROR_SIGNING_MUTUAL               -52


/*
 *  SPX Verify response status
 */

#define   SPX_S_ERROR_VERIFY_MUTUAL                -61

/*
 * SPX misc status
 */

#define   SPX_S_MALLOC_ERROR                   -99

/*
 * SPX API structures
 */

typedef struct {
    char       issuer_fn[256];
    char       service[256];
    char       resource[256];
    int        mode;
} AuthData;

#endif  /*  SPXAPI_DEFS  */
