/*
** Copyright (C) 1999, 2000, Lorenzo Bettini <lorenzo.bettini@penteres.it>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

// generators.cc

// generators and decorators

#include "textgen.h"
#include "decorators.h"
#include "tags.h"
#include "keys.h"

#define GET_DECORATED( d ) ( d ? d : GlobalGenerator )

TextGenerator *GlobalGenerator ;
TextGenerator *NormalGenerator ;
TextGenerator *KeywordGenerator ;
TextGenerator *CommentGenerator ;
TextGenerator *StringGenerator ;
TextGenerator *TypeGenerator ;
TextGenerator *NumberGenerator ;
TextGenerator *PreProcGenerator ;
TextGenerator *SymbolGenerator ;
TextGenerator *FunctionGenerator ;
TextGenerator *CBracketGenerator ;


static TextGenerator *createGenerator( char *key, CharTranslator *tr ) ;

void
createGenerators(CharTranslator *trans)
{
  GlobalGenerator = new TextGenerator (trans);
  NormalGenerator = createGenerator (NORMAL, trans);
  KeywordGenerator = createGenerator( KEYWORD, trans ) ;
  CommentGenerator = createGenerator( COMMENT, trans ) ;
  StringGenerator = createGenerator( STRING, trans ) ;
  TypeGenerator = createGenerator( TYPE, trans ) ;
  NumberGenerator = createGenerator( NUMBER, trans ) ;
  PreProcGenerator = createGenerator( PREPROC, trans ) ;
  SymbolGenerator = createGenerator( SYMBOL, trans ) ;
  FunctionGenerator = createGenerator( FUNCTION, trans ) ;
  CBracketGenerator = createGenerator ( CBRACKET, trans ) ;
}

void
createGeneratorsForCSS(CharTranslator *trans)
{
  GlobalGenerator = new TextGenerator (trans);
  NormalGenerator = new SpanDecorator (GlobalGenerator, trans, NORMAL);
  KeywordGenerator = new SpanDecorator(GlobalGenerator, trans, KEYWORD) ;
  CommentGenerator = new SpanDecorator(GlobalGenerator, trans, COMMENT) ;
  StringGenerator = new SpanDecorator(GlobalGenerator, trans, STRING) ;
  TypeGenerator = new SpanDecorator(GlobalGenerator, trans, TYPE) ;
  NumberGenerator = new SpanDecorator(GlobalGenerator, trans, NUMBER) ;
  PreProcGenerator = new SpanDecorator(GlobalGenerator, trans, PREPROC) ;
  SymbolGenerator = new SpanDecorator(GlobalGenerator, trans, SYMBOL) ;
  FunctionGenerator = new SpanDecorator(GlobalGenerator, trans, FUNCTION) ;
  CBracketGenerator = new SpanDecorator(GlobalGenerator, trans, CBRACKET) ;
}

TextGenerator *
createGenerator( char *key, CharTranslator *tr )
{
  Tag *tag = getTag( key ) ;
  TextDecorator *dec = NULL ;

  if ( ! tag ) // no options
    return GlobalGenerator ;

  char * color = tag->GetColor() ;
  if ( color )
    dec = new ColorDecorator( GlobalGenerator, tr, color ) ;

  if ( tag->IsBold() )
    dec = new TagDecorator( GET_DECORATED( dec ), tr, BOLD_TAG ) ;
  if ( tag->IsItalic() )
    dec = new TagDecorator( GET_DECORATED( dec ), tr, ITALIC_TAG ) ;
  if ( tag->IsUnderline() )
    dec = new TagDecorator( GET_DECORATED( dec ), tr, UNDERLINE_TAG ) ;

  return GET_DECORATED( dec ) ;
  // There should be some options, but it's not ncessary ...
  // so this is just to be safe
}
