/* This file is automatically generated by aarch64-gen.  Do not edit!  */
/* Copyright (C) 2012-2026 Free Software Foundation, Inc.
   Contributed by Arm Ltd.

   This file is part of the GNU opcodes library.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING3. If not,
   see <http://www.gnu.org/licenses/>.  */

#include "sysdep.h"
#include "aarch64-tbl-2.h"
#include "aarch64-asm.h"


const aarch64_opcode *
aarch64_find_real_opcode (const aarch64_opcode *opcode)
{
  /* Use the index as the key to locate the real opcode.  */
  enum aarch64_opcode_idx key = opcode - aarch64_opcode_table;
  enum aarch64_opcode_idx value;
  switch (key)
    {
    case A64_OPID_5a0003e0_ngc_Rd_Rm:
    case A64_OPID_5a000000_sbc_Rd_Rn_Rm:
      value = A64_OPID_5a000000_sbc_Rd_Rn_Rm;
      break;
    case A64_OPID_7a0003e0_ngcs_Rd_Rm:
    case A64_OPID_7a000000_sbcs_Rd_Rn_Rm:
      value = A64_OPID_7a000000_sbcs_Rd_Rn_Rm;
      break;
    case A64_OPID_2b20001f_cmn_Rn_SP_Rm_EXT:
    case A64_OPID_2b200000_adds_Rd_Rn_SP_Rm_EXT:
      value = A64_OPID_2b200000_adds_Rd_Rn_SP_Rm_EXT;
      break;
    case A64_OPID_6b20001f_cmp_Rn_SP_Rm_EXT:
    case A64_OPID_6b200000_subs_Rd_Rn_SP_Rm_EXT:
      value = A64_OPID_6b200000_subs_Rd_Rn_SP_Rm_EXT;
      break;
    case A64_OPID_11000000_mov_Rd_SP_Rn_SP:
    case A64_OPID_11000000_add_Rd_SP_Rn_SP_AIMM:
      value = A64_OPID_11000000_add_Rd_SP_Rn_SP_AIMM;
      break;
    case A64_OPID_3100001f_cmn_Rn_SP_AIMM:
    case A64_OPID_31000000_adds_Rd_Rn_SP_AIMM:
      value = A64_OPID_31000000_adds_Rd_Rn_SP_AIMM;
      break;
    case A64_OPID_7100001f_cmp_Rn_SP_AIMM:
    case A64_OPID_71000000_subs_Rd_Rn_SP_AIMM:
      value = A64_OPID_71000000_subs_Rd_Rn_SP_AIMM;
      break;
    case A64_OPID_2b00001f_cmn_Rn_Rm_SFT:
    case A64_OPID_2b000000_adds_Rd_Rn_Rm_SFT:
      value = A64_OPID_2b000000_adds_Rd_Rn_Rm_SFT;
      break;
    case A64_OPID_4b0003e0_neg_Rd_Rm_SFT:
    case A64_OPID_4b000000_sub_Rd_Rn_Rm_SFT:
      value = A64_OPID_4b000000_sub_Rd_Rn_Rm_SFT;
      break;
    case A64_OPID_6b00001f_cmp_Rn_Rm_SFT:
    case A64_OPID_6b0003e0_negs_Rd_Rm_SFT:
    case A64_OPID_6b000000_subs_Rd_Rn_Rm_SFT:
      value = A64_OPID_6b000000_subs_Rd_Rn_Rm_SFT;
      break;
    case A64_OPID_0e003c00_mov_Rd_En:
    case A64_OPID_0e003c00_umov_Rd_En:
      value = A64_OPID_0e003c00_umov_Rd_En;
      break;
    case A64_OPID_4e001c00_mov_Ed_Rn:
    case A64_OPID_4e001c00_ins_Ed_Rn:
      value = A64_OPID_4e001c00_ins_Ed_Rn;
      break;
    case A64_OPID_6e000400_mov_Ed_En:
    case A64_OPID_6e000400_ins_Ed_En:
      value = A64_OPID_6e000400_ins_Ed_En;
      break;
    case A64_OPID_2e205800_mvn_Vd_Vn:
    case A64_OPID_2e205800_not_Vd_Vn:
      value = A64_OPID_2e205800_not_Vd_Vn;
      break;
    case A64_OPID_0ea01c00_mov_Vd_Vn:
    case A64_OPID_0ea01c00_orr_Vd_Vn_Vm:
      value = A64_OPID_0ea01c00_orr_Vd_Vn_Vm;
      break;
    case A64_OPID_0f00a400_sxtl_Vd_Vn:
    case A64_OPID_0f00a400_sshll_Vd_Vn_IMM_VLSL:
      value = A64_OPID_0f00a400_sshll_Vd_Vn_IMM_VLSL;
      break;
    case A64_OPID_4f00a400_sxtl2_Vd_Vn:
    case A64_OPID_4f00a400_sshll2_Vd_Vn_IMM_VLSL:
      value = A64_OPID_4f00a400_sshll2_Vd_Vn_IMM_VLSL;
      break;
    case A64_OPID_2f00a400_uxtl_Vd_Vn:
    case A64_OPID_2f00a400_ushll_Vd_Vn_IMM_VLSL:
      value = A64_OPID_2f00a400_ushll_Vd_Vn_IMM_VLSL;
      break;
    case A64_OPID_6f00a400_uxtl2_Vd_Vn:
    case A64_OPID_6f00a400_ushll2_Vd_Vn_IMM_VLSL:
      value = A64_OPID_6f00a400_ushll2_Vd_Vn_IMM_VLSL;
      break;
    case A64_OPID_5e000400_mov_Sd_En:
    case A64_OPID_5e000400_dup_Sd_En:
      value = A64_OPID_5e000400_dup_Sd_En;
      break;
    case A64_OPID_93407c00_sxtw_Rd_Rn:
    case A64_OPID_13003c00_sxth_Rd_Rn:
    case A64_OPID_13001c00_sxtb_Rd_Rn:
    case A64_OPID_13000000_asr_Rd_Rn_IMM:
    case A64_OPID_13000000_sbfx_Rd_Rn_IMM_WIDTH:
    case A64_OPID_13000000_sbfiz_Rd_Rn_IMM_WIDTH:
    case A64_OPID_13000000_sbfm_Rd_Rn_IMMR_IMMS:
      value = A64_OPID_13000000_sbfm_Rd_Rn_IMMR_IMMS;
      break;
    case A64_OPID_330003e0_bfc_Rd_IMM_WIDTH:
    case A64_OPID_33000000_bfxil_Rd_Rn_IMM_WIDTH:
    case A64_OPID_33000000_bfi_Rd_Rn_IMM_WIDTH:
    case A64_OPID_33000000_bfm_Rd_Rn_IMMR_IMMS:
      value = A64_OPID_33000000_bfm_Rd_Rn_IMMR_IMMS;
      break;
    case A64_OPID_53003c00_uxth_Rd_Rn:
    case A64_OPID_53001c00_uxtb_Rd_Rn:
    case A64_OPID_53000000_lsr_Rd_Rn_IMM:
    case A64_OPID_53000000_lsl_Rd_Rn_IMM:
    case A64_OPID_53000000_ubfx_Rd_Rn_IMM_WIDTH:
    case A64_OPID_53000000_ubfiz_Rd_Rn_IMM_WIDTH:
    case A64_OPID_53000000_ubfm_Rd_Rn_IMMR_IMMS:
      value = A64_OPID_53000000_ubfm_Rd_Rn_IMMR_IMMS;
      break;
    case A64_OPID_74000000_cblt_Rm_Rt_ADDR_PCREL9:
    case A64_OPID_74000000_cbgt_Rt_Rm_ADDR_PCREL9:
      value = A64_OPID_74000000_cbgt_Rt_Rm_ADDR_PCREL9;
      break;
    case A64_OPID_74200000_cble_Rm_Rt_ADDR_PCREL9:
    case A64_OPID_74200000_cbge_Rt_Rm_ADDR_PCREL9:
      value = A64_OPID_74200000_cbge_Rt_Rm_ADDR_PCREL9;
      break;
    case A64_OPID_74400000_cblo_Rm_Rt_ADDR_PCREL9:
    case A64_OPID_74400000_cbhi_Rt_Rm_ADDR_PCREL9:
      value = A64_OPID_74400000_cbhi_Rt_Rm_ADDR_PCREL9;
      break;
    case A64_OPID_74600000_cbls_Rm_Rt_ADDR_PCREL9:
    case A64_OPID_74600000_cbhs_Rt_Rm_ADDR_PCREL9:
      value = A64_OPID_74600000_cbhs_Rt_Rm_ADDR_PCREL9;
      break;
    case A64_OPID_75000000_cbge_Rt_IMMP1_2_ADDR_PCREL9:
    case A64_OPID_75000000_cbgt_Rt_IMM_2_ADDR_PCREL9:
      value = A64_OPID_75000000_cbgt_Rt_IMM_2_ADDR_PCREL9;
      break;
    case A64_OPID_75200000_cble_Rt_IMMS1_2_ADDR_PCREL9:
    case A64_OPID_75200000_cblt_Rt_IMM_2_ADDR_PCREL9:
      value = A64_OPID_75200000_cblt_Rt_IMM_2_ADDR_PCREL9;
      break;
    case A64_OPID_75400000_cbhs_Rt_IMMP1_2_ADDR_PCREL9:
    case A64_OPID_75400000_cbhi_Rt_IMM_2_ADDR_PCREL9:
      value = A64_OPID_75400000_cbhi_Rt_IMM_2_ADDR_PCREL9;
      break;
    case A64_OPID_75600000_cbls_Rt_IMMS1_2_ADDR_PCREL9:
    case A64_OPID_75600000_cblo_Rt_IMM_2_ADDR_PCREL9:
      value = A64_OPID_75600000_cblo_Rt_IMM_2_ADDR_PCREL9;
      break;
    case A64_OPID_74008000_cbblt_Rm_Rt_ADDR_PCREL9:
    case A64_OPID_74008000_cbbgt_Rt_Rm_ADDR_PCREL9:
      value = A64_OPID_74008000_cbbgt_Rt_Rm_ADDR_PCREL9;
      break;
    case A64_OPID_74208000_cbble_Rm_Rt_ADDR_PCREL9:
    case A64_OPID_74208000_cbbge_Rt_Rm_ADDR_PCREL9:
      value = A64_OPID_74208000_cbbge_Rt_Rm_ADDR_PCREL9;
      break;
    case A64_OPID_74408000_cbblo_Rm_Rt_ADDR_PCREL9:
    case A64_OPID_74408000_cbbhi_Rt_Rm_ADDR_PCREL9:
      value = A64_OPID_74408000_cbbhi_Rt_Rm_ADDR_PCREL9;
      break;
    case A64_OPID_74608000_cbbls_Rm_Rt_ADDR_PCREL9:
    case A64_OPID_74608000_cbbhs_Rt_Rm_ADDR_PCREL9:
      value = A64_OPID_74608000_cbbhs_Rt_Rm_ADDR_PCREL9;
      break;
    case A64_OPID_7400c000_cbhlt_Rm_Rt_ADDR_PCREL9:
    case A64_OPID_7400c000_cbhgt_Rt_Rm_ADDR_PCREL9:
      value = A64_OPID_7400c000_cbhgt_Rt_Rm_ADDR_PCREL9;
      break;
    case A64_OPID_7420c000_cbhle_Rm_Rt_ADDR_PCREL9:
    case A64_OPID_7420c000_cbhge_Rt_Rm_ADDR_PCREL9:
      value = A64_OPID_7420c000_cbhge_Rt_Rm_ADDR_PCREL9;
      break;
    case A64_OPID_7440c000_cbhlo_Rm_Rt_ADDR_PCREL9:
    case A64_OPID_7440c000_cbhhi_Rt_Rm_ADDR_PCREL9:
      value = A64_OPID_7440c000_cbhhi_Rt_Rm_ADDR_PCREL9;
      break;
    case A64_OPID_7460c000_cbhls_Rm_Rt_ADDR_PCREL9:
    case A64_OPID_7460c000_cbhhs_Rt_Rm_ADDR_PCREL9:
      value = A64_OPID_7460c000_cbhhs_Rt_Rm_ADDR_PCREL9;
      break;
    case A64_OPID_1a9f07e0_cset_Rd_COND1:
    case A64_OPID_1a800400_cinc_Rd_Rn_COND1:
    case A64_OPID_1a800400_csinc_Rd_Rn_Rm_COND:
      value = A64_OPID_1a800400_csinc_Rd_Rn_Rm_COND;
      break;
    case A64_OPID_5a9f03e0_csetm_Rd_COND1:
    case A64_OPID_5a800000_cinv_Rd_Rn_COND1:
    case A64_OPID_5a800000_csinv_Rd_Rn_Rm_COND:
      value = A64_OPID_5a800000_csinv_Rd_Rn_Rm_COND;
      break;
    case A64_OPID_5a800400_cneg_Rd_Rn_COND1:
    case A64_OPID_5a800400_csneg_Rd_Rn_Rm_COND:
      value = A64_OPID_5a800400_csneg_Rd_Rn_Rm_COND;
      break;
    case A64_OPID_dac00c00_rev64_Rd_Rn:
    case A64_OPID_dac00c00_rev_Rd_Rn:
      value = A64_OPID_dac00c00_rev_Rd_Rn;
      break;
    case A64_OPID_1ac02000_lsl_Rd_Rn_Rm:
    case A64_OPID_1ac02000_lslv_Rd_Rn_Rm:
      value = A64_OPID_1ac02000_lslv_Rd_Rn_Rm;
      break;
    case A64_OPID_1ac02400_lsr_Rd_Rn_Rm:
    case A64_OPID_1ac02400_lsrv_Rd_Rn_Rm:
      value = A64_OPID_1ac02400_lsrv_Rd_Rn_Rm;
      break;
    case A64_OPID_1ac02800_asr_Rd_Rn_Rm:
    case A64_OPID_1ac02800_asrv_Rd_Rn_Rm:
      value = A64_OPID_1ac02800_asrv_Rd_Rn_Rm;
      break;
    case A64_OPID_1ac02c00_ror_Rd_Rn_Rm:
    case A64_OPID_1ac02c00_rorv_Rd_Rn_Rm:
      value = A64_OPID_1ac02c00_rorv_Rd_Rn_Rm;
      break;
    case A64_OPID_bac0001f_cmpp_Rn_SP_Rm_SP:
    case A64_OPID_bac00000_subps_Rd_Rn_SP_Rm_SP:
      value = A64_OPID_bac00000_subps_Rd_Rn_SP_Rm_SP;
      break;
    case A64_OPID_1b007c00_mul_Rd_Rn_Rm:
    case A64_OPID_1b000000_madd_Rd_Rn_Rm_Ra:
      value = A64_OPID_1b000000_madd_Rd_Rn_Rm_Ra;
      break;
    case A64_OPID_1b00fc00_mneg_Rd_Rn_Rm:
    case A64_OPID_1b008000_msub_Rd_Rn_Rm_Ra:
      value = A64_OPID_1b008000_msub_Rd_Rn_Rm_Ra;
      break;
    case A64_OPID_9b207c00_smull_Rd_Rn_Rm:
    case A64_OPID_9b200000_smaddl_Rd_Rn_Rm_Ra:
      value = A64_OPID_9b200000_smaddl_Rd_Rn_Rm_Ra;
      break;
    case A64_OPID_9b20fc00_smnegl_Rd_Rn_Rm:
    case A64_OPID_9b208000_smsubl_Rd_Rn_Rm_Ra:
      value = A64_OPID_9b208000_smsubl_Rd_Rn_Rm_Ra;
      break;
    case A64_OPID_9ba07c00_umull_Rd_Rn_Rm:
    case A64_OPID_9ba00000_umaddl_Rd_Rn_Rm_Ra:
      value = A64_OPID_9ba00000_umaddl_Rd_Rn_Rm_Ra;
      break;
    case A64_OPID_9ba0fc00_umnegl_Rd_Rn_Rm:
    case A64_OPID_9ba08000_umsubl_Rd_Rn_Rm_Ra:
      value = A64_OPID_9ba08000_umsubl_Rd_Rn_Rm_Ra;
      break;
    case A64_OPID_13800000_ror_Rd_Rm_IMMS:
    case A64_OPID_13800000_extr_Rd_Rn_Rm_IMMS:
      value = A64_OPID_13800000_extr_Rd_Rn_Rm_IMMS;
      break;
    case A64_OPID_12000000_bic_Rd_SP_Rn_LIMM:
    case A64_OPID_12000000_and_Rd_SP_Rn_LIMM:
      value = A64_OPID_12000000_and_Rd_SP_Rn_LIMM;
      break;
    case A64_OPID_320003e0_mov_Rd_SP_IMM_MOV:
    case A64_OPID_32000000_orr_Rd_SP_Rn_LIMM:
      value = A64_OPID_32000000_orr_Rd_SP_Rn_LIMM;
      break;
    case A64_OPID_7200001f_tst_Rn_LIMM:
    case A64_OPID_72000000_ands_Rd_Rn_LIMM:
      value = A64_OPID_72000000_ands_Rd_Rn_LIMM;
      break;
    case A64_OPID_2a0003e0_uxtw_Rd_Rm:
    case A64_OPID_2a0003e0_mov_Rd_Rm_SFT:
    case A64_OPID_2a000000_orr_Rd_Rn_Rm_SFT:
      value = A64_OPID_2a000000_orr_Rd_Rn_Rm_SFT;
      break;
    case A64_OPID_2a2003e0_mvn_Rd_Rm_SFT:
    case A64_OPID_2a200000_orn_Rd_Rn_Rm_SFT:
      value = A64_OPID_2a200000_orn_Rd_Rn_Rm_SFT;
      break;
    case A64_OPID_6a00001f_tst_Rn_Rm_SFT:
    case A64_OPID_6a000000_ands_Rd_Rn_Rm_SFT:
      value = A64_OPID_6a000000_ands_Rd_Rn_Rm_SFT;
      break;
    case A64_OPID_3820001f_staddb_Rs_ADDR_SIMPLE:
    case A64_OPID_38200000_ldaddb_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_38200000_ldaddb_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_7820001f_staddh_Rs_ADDR_SIMPLE:
    case A64_OPID_78200000_ldaddh_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_78200000_ldaddh_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_b820001f_stadd_Rs_ADDR_SIMPLE:
    case A64_OPID_b8200000_ldadd_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_b8200000_ldadd_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_3860001f_staddlb_Rs_ADDR_SIMPLE:
    case A64_OPID_38600000_ldaddlb_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_38600000_ldaddlb_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_7860001f_staddlh_Rs_ADDR_SIMPLE:
    case A64_OPID_78600000_ldaddlh_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_78600000_ldaddlh_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_b860001f_staddl_Rs_ADDR_SIMPLE:
    case A64_OPID_b8600000_ldaddl_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_b8600000_ldaddl_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_3820101f_stclrb_Rs_ADDR_SIMPLE:
    case A64_OPID_38201000_ldclrb_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_38201000_ldclrb_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_7820101f_stclrh_Rs_ADDR_SIMPLE:
    case A64_OPID_78201000_ldclrh_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_78201000_ldclrh_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_b820101f_stclr_Rs_ADDR_SIMPLE:
    case A64_OPID_b8201000_ldclr_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_b8201000_ldclr_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_3860101f_stclrlb_Rs_ADDR_SIMPLE:
    case A64_OPID_38601000_ldclrlb_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_38601000_ldclrlb_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_7860101f_stclrlh_Rs_ADDR_SIMPLE:
    case A64_OPID_78601000_ldclrlh_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_78601000_ldclrlh_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_b860101f_stclrl_Rs_ADDR_SIMPLE:
    case A64_OPID_b8601000_ldclrl_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_b8601000_ldclrl_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_3820201f_steorb_Rs_ADDR_SIMPLE:
    case A64_OPID_38202000_ldeorb_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_38202000_ldeorb_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_7820201f_steorh_Rs_ADDR_SIMPLE:
    case A64_OPID_78202000_ldeorh_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_78202000_ldeorh_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_b820201f_steor_Rs_ADDR_SIMPLE:
    case A64_OPID_b8202000_ldeor_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_b8202000_ldeor_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_3860201f_steorlb_Rs_ADDR_SIMPLE:
    case A64_OPID_38602000_ldeorlb_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_38602000_ldeorlb_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_7860201f_steorlh_Rs_ADDR_SIMPLE:
    case A64_OPID_78602000_ldeorlh_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_78602000_ldeorlh_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_b860201f_steorl_Rs_ADDR_SIMPLE:
    case A64_OPID_b8602000_ldeorl_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_b8602000_ldeorl_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_3820301f_stsetb_Rs_ADDR_SIMPLE:
    case A64_OPID_38203000_ldsetb_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_38203000_ldsetb_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_7820301f_stseth_Rs_ADDR_SIMPLE:
    case A64_OPID_78203000_ldseth_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_78203000_ldseth_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_b820301f_stset_Rs_ADDR_SIMPLE:
    case A64_OPID_b8203000_ldset_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_b8203000_ldset_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_3860301f_stsetlb_Rs_ADDR_SIMPLE:
    case A64_OPID_38603000_ldsetlb_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_38603000_ldsetlb_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_7860301f_stsetlh_Rs_ADDR_SIMPLE:
    case A64_OPID_78603000_ldsetlh_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_78603000_ldsetlh_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_b860301f_stsetl_Rs_ADDR_SIMPLE:
    case A64_OPID_b8603000_ldsetl_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_b8603000_ldsetl_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_3820401f_stsmaxb_Rs_ADDR_SIMPLE:
    case A64_OPID_38204000_ldsmaxb_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_38204000_ldsmaxb_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_7820401f_stsmaxh_Rs_ADDR_SIMPLE:
    case A64_OPID_78204000_ldsmaxh_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_78204000_ldsmaxh_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_b820401f_stsmax_Rs_ADDR_SIMPLE:
    case A64_OPID_b8204000_ldsmax_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_b8204000_ldsmax_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_3860401f_stsmaxlb_Rs_ADDR_SIMPLE:
    case A64_OPID_38604000_ldsmaxlb_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_38604000_ldsmaxlb_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_7860401f_stsmaxlh_Rs_ADDR_SIMPLE:
    case A64_OPID_78604000_ldsmaxlh_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_78604000_ldsmaxlh_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_b860401f_stsmaxl_Rs_ADDR_SIMPLE:
    case A64_OPID_b8604000_ldsmaxl_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_b8604000_ldsmaxl_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_3820501f_stsminb_Rs_ADDR_SIMPLE:
    case A64_OPID_38205000_ldsminb_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_38205000_ldsminb_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_7820501f_stsminh_Rs_ADDR_SIMPLE:
    case A64_OPID_78205000_ldsminh_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_78205000_ldsminh_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_b820501f_stsmin_Rs_ADDR_SIMPLE:
    case A64_OPID_b8205000_ldsmin_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_b8205000_ldsmin_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_3860501f_stsminlb_Rs_ADDR_SIMPLE:
    case A64_OPID_38605000_ldsminlb_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_38605000_ldsminlb_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_7860501f_stsminlh_Rs_ADDR_SIMPLE:
    case A64_OPID_78605000_ldsminlh_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_78605000_ldsminlh_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_b860501f_stsminl_Rs_ADDR_SIMPLE:
    case A64_OPID_b8605000_ldsminl_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_b8605000_ldsminl_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_3820601f_stumaxb_Rs_ADDR_SIMPLE:
    case A64_OPID_38206000_ldumaxb_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_38206000_ldumaxb_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_7820601f_stumaxh_Rs_ADDR_SIMPLE:
    case A64_OPID_78206000_ldumaxh_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_78206000_ldumaxh_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_b820601f_stumax_Rs_ADDR_SIMPLE:
    case A64_OPID_b8206000_ldumax_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_b8206000_ldumax_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_3860601f_stumaxlb_Rs_ADDR_SIMPLE:
    case A64_OPID_38606000_ldumaxlb_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_38606000_ldumaxlb_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_7860601f_stumaxlh_Rs_ADDR_SIMPLE:
    case A64_OPID_78606000_ldumaxlh_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_78606000_ldumaxlh_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_b860601f_stumaxl_Rs_ADDR_SIMPLE:
    case A64_OPID_b8606000_ldumaxl_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_b8606000_ldumaxl_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_3820701f_stuminb_Rs_ADDR_SIMPLE:
    case A64_OPID_38207000_lduminb_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_38207000_lduminb_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_7820701f_stuminh_Rs_ADDR_SIMPLE:
    case A64_OPID_78207000_lduminh_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_78207000_lduminh_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_b820701f_stumin_Rs_ADDR_SIMPLE:
    case A64_OPID_b8207000_ldumin_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_b8207000_ldumin_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_3860701f_stuminlb_Rs_ADDR_SIMPLE:
    case A64_OPID_38607000_lduminlb_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_38607000_lduminlb_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_7860701f_stuminlh_Rs_ADDR_SIMPLE:
    case A64_OPID_78607000_lduminlh_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_78607000_lduminlh_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_b860701f_stuminl_Rs_ADDR_SIMPLE:
    case A64_OPID_b8607000_lduminl_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_b8607000_lduminl_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_1920041f_sttadd_Rs_ADDR_SIMPLE:
    case A64_OPID_19200400_ldtadd_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_19200400_ldtadd_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_1960041f_sttaddl_Rs_ADDR_SIMPLE:
    case A64_OPID_19600400_ldtaddl_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_19600400_ldtaddl_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_1920141f_sttclr_Rs_ADDR_SIMPLE:
    case A64_OPID_19201400_ldtclr_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_19201400_ldtclr_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_1960141f_sttclrl_Rs_ADDR_SIMPLE:
    case A64_OPID_19601400_ldtclrl_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_19601400_ldtclrl_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_1920341f_sttset_Rs_ADDR_SIMPLE:
    case A64_OPID_19203400_ldtset_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_19203400_ldtset_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_1960341f_sttsetl_Rs_ADDR_SIMPLE:
    case A64_OPID_19603400_ldtsetl_Rs_Rt_ADDR_SIMPLE:
      value = A64_OPID_19603400_ldtsetl_Rs_Rt_ADDR_SIMPLE;
      break;
    case A64_OPID_12800000_mov_Rd_IMM_MOV:
    case A64_OPID_12800000_movn_Rd_HALF:
      value = A64_OPID_12800000_movn_Rd_HALF;
      break;
    case A64_OPID_52800000_mov_Rd_IMM_MOV:
    case A64_OPID_52800000_movz_Rd_HALF:
      value = A64_OPID_52800000_movz_Rd_HALF;
      break;
    case A64_OPID_d50322df_clrbhb:
    case A64_OPID_d50323ff_autibsp:
    case A64_OPID_d50323df_autibz:
    case A64_OPID_d50323bf_autiasp:
    case A64_OPID_d503239f_autiaz:
    case A64_OPID_d503237f_pacibsp:
    case A64_OPID_d503235f_pacibz:
    case A64_OPID_d503233f_paciasp:
    case A64_OPID_d503231f_paciaz:
    case A64_OPID_d503227f_gcsb_BARRIER_GCSB:
    case A64_OPID_d50322df_clearbhb:
    case A64_OPID_d503225f_tsb_BARRIER_PSB:
    case A64_OPID_d503223f_psb_BARRIER_PSB:
    case A64_OPID_d503221f_esb:
    case A64_OPID_d50321df_autib1716:
    case A64_OPID_d503219f_autia1716:
    case A64_OPID_d503215f_pacib1716:
    case A64_OPID_d503211f_pacia1716:
    case A64_OPID_d50320ff_xpaclri:
    case A64_OPID_d50320df_dgh:
    case A64_OPID_d50320bf_sevl:
    case A64_OPID_d503209f_sev:
    case A64_OPID_d503207f_wfi:
    case A64_OPID_d503205f_wfe:
    case A64_OPID_d503203f_yield:
    case A64_OPID_d503241f_bti_BTI_TARGET:
    case A64_OPID_d503229f_csdb:
    case A64_OPID_d503201f_nop:
    case A64_OPID_d503265f_shuh_SHUH_PHINT:
    case A64_OPID_d503269f_stcph:
    case A64_OPID_d503261f_stshh_STSHH_POLICY:
    case A64_OPID_d503201f_hint_UIMM7:
      value = A64_OPID_d503201f_hint_UIMM7;
      break;
    case A64_OPID_d503349f_pssbb:
    case A64_OPID_d503309f_ssbb:
    case A64_OPID_d5033c9f_dfb:
    case A64_OPID_d503309f_dsb_BARRIER:
      value = A64_OPID_d503309f_dsb_BARRIER;
      break;
    case A64_OPID_d503323f_dsb_BARRIER_DSB_NXS:
      value = A64_OPID_d503323f_dsb_BARRIER_DSB_NXS;
      break;
    case A64_OPID_d5080000_plbi_SYSREG_PLBI_Rt_SYS:
    case A64_OPID_d508001f_gsb_GSB:
    case A64_OPID_d5080000_gicr_Rd_GICR:
    case A64_OPID_d5080000_gic_GIC_Rd:
    case A64_OPID_d50b72e0_trcit_Rt:
    case A64_OPID_d5097280_brb_BRBOP_Rt_IN_SYS_ALIASES:
    case A64_OPID_d50b73c0_cosp_SYSREG_SR_Rt:
    case A64_OPID_d50b73e0_cpp_SYSREG_SR_Rt:
    case A64_OPID_d50b73a0_dvp_SYSREG_SR_Rt:
    case A64_OPID_d50b7380_cfp_SYSREG_SR_Rt:
    case A64_OPID_d5080000_tlbi_SYSREG_TLBI_Rt_SYS:
    case A64_OPID_d5080000_ic_SYSREG_IC_Rt_SYS:
    case A64_OPID_d5080000_dc_SYSREG_DC_Rt:
    case A64_OPID_d5080000_at_SYSREG_AT_Rt:
    case A64_OPID_d5080000_mlbi_SYSREG_MLBI_Rt_SYS:
    case A64_OPID_d5080000_sys_UIMM3_OP1_CRn_CRm_UIMM3_OP2_Rt:
      value = A64_OPID_d5080000_sys_UIMM3_OP1_CRn_CRm_UIMM3_OP2_Rt;
      break;
    case A64_OPID_d5480000_tlbip_SYSREG_TLBIP_Rt_SYS_PAIRREG_OR_XZR:
    case A64_OPID_d5480000_sysp_UIMM3_OP1_CRn_CRm_UIMM3_OP2_Rt_PAIRREG_OR_XZR:
      value = A64_OPID_d5480000_sysp_UIMM3_OP1_CRn_CRm_UIMM3_OP2_Rt_PAIRREG_OR_XZR;
      break;
    case A64_OPID_d5031000_wfet_Rd:
      value = A64_OPID_d5031000_wfet_Rd;
      break;
    case A64_OPID_d5031020_wfit_Rd:
      value = A64_OPID_d5031020_wfit_Rd;
      break;
    case A64_OPID_05800000_bic_SVE_Zd_SVE_Zd_SVE_INV_LIMM:
    case A64_OPID_05800000_and_SVE_Zd_SVE_Zd_SVE_LIMM:
      value = A64_OPID_05800000_and_SVE_Zd_SVE_Zd_SVE_LIMM;
      break;
    case A64_OPID_25004000_mov_SVE_Pd_SVE_Pg4_10_SVE_Pn:
    case A64_OPID_25004000_and_SVE_Pd_SVE_Pg4_10_SVE_Pn_SVE_Pm:
      value = A64_OPID_25004000_and_SVE_Pd_SVE_Pg4_10_SVE_Pn_SVE_Pm;
      break;
    case A64_OPID_25404000_movs_SVE_Pd_SVE_Pg4_10_SVE_Pn:
    case A64_OPID_25404000_ands_SVE_Pd_SVE_Pg4_10_SVE_Pn_SVE_Pm:
      value = A64_OPID_25404000_ands_SVE_Pd_SVE_Pg4_10_SVE_Pn_SVE_Pm;
      break;
    case A64_OPID_24008000_cmple_SVE_Pd_SVE_Pg3_SVE_Zm_16_SVE_Zn:
    case A64_OPID_24008000_cmpge_SVE_Pd_SVE_Pg3_SVE_Zn_SVE_Zm_16:
      value = A64_OPID_24008000_cmpge_SVE_Pd_SVE_Pg3_SVE_Zn_SVE_Zm_16;
      break;
    case A64_OPID_24008010_cmplt_SVE_Pd_SVE_Pg3_SVE_Zm_16_SVE_Zn:
    case A64_OPID_24008010_cmpgt_SVE_Pd_SVE_Pg3_SVE_Zn_SVE_Zm_16:
      value = A64_OPID_24008010_cmpgt_SVE_Pd_SVE_Pg3_SVE_Zn_SVE_Zm_16;
      break;
    case A64_OPID_24000010_cmplo_SVE_Pd_SVE_Pg3_SVE_Zm_16_SVE_Zn:
    case A64_OPID_24000010_cmphi_SVE_Pd_SVE_Pg3_SVE_Zn_SVE_Zm_16:
      value = A64_OPID_24000010_cmphi_SVE_Pd_SVE_Pg3_SVE_Zn_SVE_Zm_16;
      break;
    case A64_OPID_24000000_cmpls_SVE_Pd_SVE_Pg3_SVE_Zm_16_SVE_Zn:
    case A64_OPID_24000000_cmphs_SVE_Pd_SVE_Pg3_SVE_Zn_SVE_Zm_16:
      value = A64_OPID_24000000_cmphs_SVE_Pd_SVE_Pg3_SVE_Zn_SVE_Zm_16;
      break;
    case A64_OPID_05208000_mov_SVE_Zd_SVE_Pg3_SVE_Vn:
    case A64_OPID_05208000_cpy_SVE_Zd_SVE_Pg3_SVE_Vn:
      value = A64_OPID_05208000_cpy_SVE_Zd_SVE_Pg3_SVE_Vn;
      break;
    case A64_OPID_0528a000_mov_SVE_Zd_SVE_Pg3_Rn_SP:
    case A64_OPID_0528a000_cpy_SVE_Zd_SVE_Pg3_Rn_SP:
      value = A64_OPID_0528a000_cpy_SVE_Zd_SVE_Pg3_Rn_SP;
      break;
    case A64_OPID_05104000_fmov_SVE_Zd_SVE_Pg4_16_FPIMM0:
    case A64_OPID_05100000_mov_SVE_Zd_SVE_Pg4_16_SVE_ASIMM:
    case A64_OPID_05100000_cpy_SVE_Zd_SVE_Pg4_16_SVE_ASIMM:
      value = A64_OPID_05100000_cpy_SVE_Zd_SVE_Pg4_16_SVE_ASIMM;
      break;
    case A64_OPID_05203800_mov_SVE_Zd_Rn_SP:
    case A64_OPID_05203800_dup_SVE_Zd_Rn_SP:
      value = A64_OPID_05203800_dup_SVE_Zd_Rn_SP;
      break;
    case A64_OPID_05202000_mov_SVE_Zd_SVE_Zn_INDEX:
    case A64_OPID_05202000_mov_SVE_Zd_SVE_VZn:
    case A64_OPID_05202000_dup_SVE_Zd_SVE_Zn_INDEX:
      value = A64_OPID_05202000_dup_SVE_Zd_SVE_Zn_INDEX;
      break;
    case A64_OPID_2538c000_fmov_SVE_Zd_FPIMM0:
    case A64_OPID_2538c000_mov_SVE_Zd_SVE_ASIMM:
    case A64_OPID_2538c000_dup_SVE_Zd_SVE_ASIMM:
      value = A64_OPID_2538c000_dup_SVE_Zd_SVE_ASIMM;
      break;
    case A64_OPID_05c00000_mov_SVE_Zd_SVE_LIMM_MOV:
    case A64_OPID_05c00000_dupm_SVE_Zd_SVE_LIMM:
      value = A64_OPID_05c00000_dupm_SVE_Zd_SVE_LIMM;
      break;
    case A64_OPID_05400000_eon_SVE_Zd_SVE_Zd_SVE_INV_LIMM:
    case A64_OPID_05400000_eor_SVE_Zd_SVE_Zd_SVE_LIMM:
      value = A64_OPID_05400000_eor_SVE_Zd_SVE_Zd_SVE_LIMM;
      break;
    case A64_OPID_25004200_not_SVE_Pd_SVE_Pg4_10_SVE_Pn:
    case A64_OPID_25004200_eor_SVE_Pd_SVE_Pg4_10_SVE_Pn_SVE_Pm:
      value = A64_OPID_25004200_eor_SVE_Pd_SVE_Pg4_10_SVE_Pn_SVE_Pm;
      break;
    case A64_OPID_25404200_nots_SVE_Pd_SVE_Pg4_10_SVE_Pn:
    case A64_OPID_25404200_eors_SVE_Pd_SVE_Pg4_10_SVE_Pn_SVE_Pm:
      value = A64_OPID_25404200_eors_SVE_Pd_SVE_Pg4_10_SVE_Pn_SVE_Pm;
      break;
    case A64_OPID_6500c010_facle_SVE_Pd_SVE_Pg3_SVE_Zm_16_SVE_Zn:
    case A64_OPID_6500c010_facge_SVE_Pd_SVE_Pg3_SVE_Zn_SVE_Zm_16:
      value = A64_OPID_6500c010_facge_SVE_Pd_SVE_Pg3_SVE_Zn_SVE_Zm_16;
      break;
    case A64_OPID_6500e010_faclt_SVE_Pd_SVE_Pg3_SVE_Zm_16_SVE_Zn:
    case A64_OPID_6500e010_facgt_SVE_Pd_SVE_Pg3_SVE_Zn_SVE_Zm_16:
      value = A64_OPID_6500e010_facgt_SVE_Pd_SVE_Pg3_SVE_Zn_SVE_Zm_16;
      break;
    case A64_OPID_65004000_fcmle_SVE_Pd_SVE_Pg3_SVE_Zm_16_SVE_Zn:
    case A64_OPID_65004000_fcmge_SVE_Pd_SVE_Pg3_SVE_Zn_SVE_Zm_16:
      value = A64_OPID_65004000_fcmge_SVE_Pd_SVE_Pg3_SVE_Zn_SVE_Zm_16;
      break;
    case A64_OPID_65004010_fcmlt_SVE_Pd_SVE_Pg3_SVE_Zm_16_SVE_Zn:
    case A64_OPID_65004010_fcmgt_SVE_Pd_SVE_Pg3_SVE_Zn_SVE_Zm_16:
      value = A64_OPID_65004010_fcmgt_SVE_Pd_SVE_Pg3_SVE_Zn_SVE_Zm_16;
      break;
    case A64_OPID_0510c000_fmov_SVE_Zd_SVE_Pg4_16_SVE_FPIMM8:
    case A64_OPID_0510c000_fcpy_SVE_Zd_SVE_Pg4_16_SVE_FPIMM8:
      value = A64_OPID_0510c000_fcpy_SVE_Zd_SVE_Pg4_16_SVE_FPIMM8;
      break;
    case A64_OPID_2539c000_fmov_SVE_Zd_SVE_FPIMM8:
    case A64_OPID_2539c000_fdup_SVE_Zd_SVE_FPIMM8:
      value = A64_OPID_2539c000_fdup_SVE_Zd_SVE_FPIMM8;
      break;
    case A64_OPID_85800000_ldr_SVE_PNt_SVE_ADDR_RI_S9xVL:
    case A64_OPID_85800000_ldr_SVE_Pt_SVE_ADDR_RI_S9xVL:
      value = A64_OPID_85800000_ldr_SVE_Pt_SVE_ADDR_RI_S9xVL;
      break;
    case A64_OPID_04603000_mov_SVE_Zd_SVE_Zn:
    case A64_OPID_04603000_orr_SVE_Zd_SVE_Zn_SVE_Zm_16:
      value = A64_OPID_04603000_orr_SVE_Zd_SVE_Zn_SVE_Zm_16;
      break;
    case A64_OPID_05000000_orn_SVE_Zd_SVE_Zd_SVE_INV_LIMM:
    case A64_OPID_05000000_orr_SVE_Zd_SVE_Zd_SVE_LIMM:
      value = A64_OPID_05000000_orr_SVE_Zd_SVE_Zd_SVE_LIMM;
      break;
    case A64_OPID_25804000_mov_SVE_PNd_SVE_PNn:
    case A64_OPID_25804000_mov_SVE_Pd_SVE_Pn:
    case A64_OPID_25804000_orr_SVE_Pd_SVE_Pg4_10_SVE_Pn_SVE_Pm:
      value = A64_OPID_25804000_orr_SVE_Pd_SVE_Pg4_10_SVE_Pn_SVE_Pm;
      break;
    case A64_OPID_25c04000_movs_SVE_Pd_SVE_Pn:
    case A64_OPID_25c04000_orrs_SVE_Pd_SVE_Pg4_10_SVE_Pn_SVE_Pm:
      value = A64_OPID_25c04000_orrs_SVE_Pd_SVE_Pg4_10_SVE_Pn_SVE_Pm;
      break;
    case A64_OPID_2518e400_pfalse_SVE_PNd:
    case A64_OPID_2518e400_pfalse_SVE_Pd:
      value = A64_OPID_2518e400_pfalse_SVE_Pd;
      break;
    case A64_OPID_0520c000_mov_SVE_Zd_SVE_Pg4_10_SVE_Zn:
    case A64_OPID_0520c000_sel_SVE_Zd_SVE_Pg4_10_SVE_Zn_SVE_Zm_16:
      value = A64_OPID_0520c000_sel_SVE_Zd_SVE_Pg4_10_SVE_Zn_SVE_Zm_16;
      break;
    case A64_OPID_25004210_mov_SVE_Pd_SVE_Pg4_10_SVE_Pn:
    case A64_OPID_25004210_sel_SVE_Pd_SVE_Pg4_10_SVE_Pn_SVE_Pm:
      value = A64_OPID_25004210_sel_SVE_Pd_SVE_Pg4_10_SVE_Pn_SVE_Pm;
      break;
    case A64_OPID_e5800000_str_SVE_PNt_SVE_ADDR_RI_S9xVL:
    case A64_OPID_e5800000_str_SVE_Pt_SVE_ADDR_RI_S9xVL:
      value = A64_OPID_e5800000_str_SVE_Pt_SVE_ADDR_RI_S9xVL;
      break;
    case A64_OPID_c0020000_mov_SVE_Zd_SVE_Pg3_SME_ZA_HV_idx_src:
    case A64_OPID_c0020000_mova_SVE_Zd_SVE_Pg3_SME_ZA_HV_idx_src:
      value = A64_OPID_c0020000_mova_SVE_Zd_SVE_Pg3_SME_ZA_HV_idx_src;
      break;
    case A64_OPID_c0000000_mov_SME_ZA_HV_idx_dest_SVE_Pg3_SVE_Zn:
    case A64_OPID_c0000000_mova_SME_ZA_HV_idx_dest_SVE_Pg3_SVE_Zn:
      value = A64_OPID_c0000000_mova_SME_ZA_HV_idx_dest_SVE_Pg3_SVE_Zn;
      break;
    case A64_OPID_25204000_psel_SVE_PNd_SVE_PNg4_10_SME_PnT_Wm_imm:
    case A64_OPID_25204000_psel_SVE_Pd_SVE_Pg4_10_SME_PnT_Wm_imm:
      value = A64_OPID_25204000_psel_SVE_Pd_SVE_Pg4_10_SME_PnT_Wm_imm;
      break;
    case A64_OPID_c0060800_mov_SME_Zdnx2_SME_ZA_array_off3_5:
    case A64_OPID_c0060800_mova_SME_Zdnx2_SME_ZA_array_off3_5:
      value = A64_OPID_c0060800_mova_SME_Zdnx2_SME_ZA_array_off3_5;
      break;
    case A64_OPID_c0060c00_mov_SME_Zdnx4_SME_ZA_array_off3_5:
    case A64_OPID_c0060c00_mova_SME_Zdnx4_SME_ZA_array_off3_5:
      value = A64_OPID_c0060c00_mova_SME_Zdnx4_SME_ZA_array_off3_5;
      break;
    case A64_OPID_c0060000_mov_SME_Zdnx2_SME_ZA_HV_idx_srcxN:
    case A64_OPID_c0060000_mova_SME_Zdnx2_SME_ZA_HV_idx_srcxN:
      value = A64_OPID_c0060000_mova_SME_Zdnx2_SME_ZA_HV_idx_srcxN;
      break;
    case A64_OPID_c0060400_mov_SME_Zdnx4_SME_ZA_HV_idx_srcxN:
    case A64_OPID_c0060400_mova_SME_Zdnx4_SME_ZA_HV_idx_srcxN:
      value = A64_OPID_c0060400_mova_SME_Zdnx4_SME_ZA_HV_idx_srcxN;
      break;
    case A64_OPID_c0040800_mov_SME_ZA_array_off3_0_SME_Znx2:
    case A64_OPID_c0040800_mova_SME_ZA_array_off3_0_SME_Znx2:
      value = A64_OPID_c0040800_mova_SME_ZA_array_off3_0_SME_Znx2;
      break;
    case A64_OPID_c0040c00_mov_SME_ZA_array_off3_0_SME_Znx4:
    case A64_OPID_c0040c00_mova_SME_ZA_array_off3_0_SME_Znx4:
      value = A64_OPID_c0040c00_mova_SME_ZA_array_off3_0_SME_Znx4;
      break;
    case A64_OPID_c0040000_mov_SME_ZA_HV_idx_destxN_SME_Znx2:
    case A64_OPID_c0040000_mova_SME_ZA_HV_idx_destxN_SME_Znx2:
      value = A64_OPID_c0040000_mova_SME_ZA_HV_idx_destxN_SME_Znx2;
      break;
    case A64_OPID_c0040400_mov_SME_ZA_HV_idx_destxN_SME_Znx4:
    case A64_OPID_c0040400_mova_SME_ZA_HV_idx_destxN_SME_Znx4:
      value = A64_OPID_c0040400_mova_SME_ZA_HV_idx_destxN_SME_Znx4;
      break;
    default: return NULL;
    }

  return aarch64_opcode_table + value;
}

bool
aarch64_insert_operand (const aarch64_operand *self,
			   const aarch64_opnd_info *info,
			   aarch64_insn *code, const aarch64_inst *inst,
			   aarch64_operand_error *errors)
{
  /* Use the index as the key.  */
  enum aarch64_opnd key = self - aarch64_operands;
  switch (key)
    {
    case AARCH64_OPND_Rd:
    case AARCH64_OPND_Rn:
    case AARCH64_OPND_Rm:
    case AARCH64_OPND_Rt:
    case AARCH64_OPND_Rt2:
    case AARCH64_OPND_Rt_LS64:
    case AARCH64_OPND_Rt_SP:
    case AARCH64_OPND_Rs:
    case AARCH64_OPND_Ra:
    case AARCH64_OPND_Rt_SYS:
    case AARCH64_OPND_Rd_SP:
    case AARCH64_OPND_Rn_SP:
    case AARCH64_OPND_Rm_SP:
    case AARCH64_OPND_Fd:
    case AARCH64_OPND_Fn:
    case AARCH64_OPND_Fm:
    case AARCH64_OPND_Fa:
    case AARCH64_OPND_Ft2:
    case AARCH64_OPND_Sd:
    case AARCH64_OPND_Sn:
    case AARCH64_OPND_Sm:
    case AARCH64_OPND_Va:
    case AARCH64_OPND_Vd:
    case AARCH64_OPND_Vn:
    case AARCH64_OPND_Vm:
    case AARCH64_OPND_VdD1:
    case AARCH64_OPND_VnD1:
    case AARCH64_OPND_Rt_IN_SYS_ALIASES:
    case AARCH64_OPND_LSE128_Rt:
    case AARCH64_OPND_LSE128_Rt2:
    case AARCH64_OPND_SVE_Pd:
    case AARCH64_OPND_SVE_PNd:
    case AARCH64_OPND_SVE_Pg3:
    case AARCH64_OPND_SVE_Pg4_5:
    case AARCH64_OPND_SVE_Pg4_10:
    case AARCH64_OPND_SVE_PNg4_10:
    case AARCH64_OPND_SVE_Pg4_16:
    case AARCH64_OPND_SVE_Pm:
    case AARCH64_OPND_SVE_Pn:
    case AARCH64_OPND_SVE_PNn:
    case AARCH64_OPND_SVE_Pt:
    case AARCH64_OPND_SVE_PNt:
    case AARCH64_OPND_SVE_Rm:
    case AARCH64_OPND_SVE_Rn_SP:
    case AARCH64_OPND_SVE_VZn:
    case AARCH64_OPND_SVE_Vd:
    case AARCH64_OPND_SVE_Vm:
    case AARCH64_OPND_SVE_Vn:
    case AARCH64_OPND_SVE_Za_5:
    case AARCH64_OPND_SVE_Za_16:
    case AARCH64_OPND_SVE_Zd:
    case AARCH64_OPND_SVE_Zm_5:
    case AARCH64_OPND_SVE_Zm_16:
    case AARCH64_OPND_SVE_Zn:
    case AARCH64_OPND_SVE_Zt:
    case AARCH64_OPND_SME_Zm:
    case AARCH64_OPND_SME_Zm_17:
    case AARCH64_OPND_SME_Zn_6_3:
    case AARCH64_OPND_SME_Zm_17_3:
    case AARCH64_OPND_SME_ZAda_1b:
    case AARCH64_OPND_SME_ZAda_2b:
    case AARCH64_OPND_SME_ZAda_3b:
    case AARCH64_OPND_SME_Pm:
    case AARCH64_OPND_SME_PNd3:
    case AARCH64_OPND_SME_PNg3:
    case AARCH64_OPND_SME_PNn:
    case AARCH64_OPND_SVE_Zn0_INDEX:
    case AARCH64_OPND_SVE_Zd0_INDEX:
      return aarch64_ins_regno (self, info, code, inst, errors);
    case AARCH64_OPND_X16:
    case AARCH64_OPND_BARRIER_PSB:
    case AARCH64_OPND_BARRIER_GCSB:
    case AARCH64_OPND_SME_ZT0:
    case AARCH64_OPND_SME_ZT0_LIST:
      return aarch64_ins_none (self, info, code, inst, errors);
    case AARCH64_OPND_Rm_EXT:
      return aarch64_ins_reg_extended (self, info, code, inst, errors);
    case AARCH64_OPND_Rm_SFT:
      return aarch64_ins_reg_shifted (self, info, code, inst, errors);
    case AARCH64_OPND_Rm_LSL:
      return aarch64_ins_reg_lsl_shifted (self, info, code, inst, errors);
    case AARCH64_OPND_Ft:
      return aarch64_ins_ft (self, info, code, inst, errors);
    case AARCH64_OPND_Ed:
    case AARCH64_OPND_En:
    case AARCH64_OPND_Em:
    case AARCH64_OPND_Em16:
    case AARCH64_OPND_Em8:
    case AARCH64_OPND_SM3_IMM2:
      return aarch64_ins_reglane (self, info, code, inst, errors);
    case AARCH64_OPND_Em_INDEX1_14:
    case AARCH64_OPND_Em_INDEX2_13:
    case AARCH64_OPND_Em_INDEX3_12:
    case AARCH64_OPND_SVE_Zm1_23_INDEX:
    case AARCH64_OPND_SVE_Zm2_22_INDEX:
    case AARCH64_OPND_SVE_Zm3_12_INDEX:
    case AARCH64_OPND_SME_PNn3_INDEX1:
    case AARCH64_OPND_SME_PNn3_INDEX2:
    case AARCH64_OPND_SME_Zk_INDEX:
    case AARCH64_OPND_SME_Zm_INDEX1:
    case AARCH64_OPND_SME_Zm_INDEX2:
    case AARCH64_OPND_SME_Zm_INDEX2_3:
    case AARCH64_OPND_SME_Zm_INDEX3_1:
    case AARCH64_OPND_SME_Zm_INDEX3_2:
    case AARCH64_OPND_SME_Zm_INDEX3_3:
    case AARCH64_OPND_SME_Zm_INDEX3_10:
    case AARCH64_OPND_SME_Zm_INDEX4_1:
    case AARCH64_OPND_SME_Zm_INDEX4_2:
    case AARCH64_OPND_SME_Zm_INDEX4_3:
    case AARCH64_OPND_SME_Zm_INDEX4_10:
    case AARCH64_OPND_SME_Zn_INDEX1_16:
    case AARCH64_OPND_SME_Zn_INDEX2_15:
    case AARCH64_OPND_SME_Zn_INDEX2_16:
    case AARCH64_OPND_SME_Zn_INDEX2_19:
    case AARCH64_OPND_SME_Zn_INDEX3_14:
    case AARCH64_OPND_SME_Zn_INDEX3_15:
    case AARCH64_OPND_SME_Zn_INDEX4_14:
    case AARCH64_OPND_SVE_Zn1_17_INDEX:
    case AARCH64_OPND_SVE_Zn2_18_INDEX:
    case AARCH64_OPND_SVE_Zn3_22_INDEX:
    case AARCH64_OPND_SVE_Zd1_17_INDEX:
    case AARCH64_OPND_SVE_Zd2_18_INDEX:
    case AARCH64_OPND_SVE_Zd3_22_INDEX:
      return aarch64_ins_simple_index (self, info, code, inst, errors);
    case AARCH64_OPND_LVn:
      return aarch64_ins_reglist (self, info, code, inst, errors);
    case AARCH64_OPND_LVt:
      return aarch64_ins_ldst_reglist (self, info, code, inst, errors);
    case AARCH64_OPND_LVt_AL:
      return aarch64_ins_ldst_reglist_r (self, info, code, inst, errors);
    case AARCH64_OPND_LVn_LUT:
      return aarch64_ins_lut_reglist (self, info, code, inst, errors);
    case AARCH64_OPND_LEt:
      return aarch64_ins_ldst_elemlist (self, info, code, inst, errors);
    case AARCH64_OPND_CRn:
    case AARCH64_OPND_CRm:
    case AARCH64_OPND_IDX:
    case AARCH64_OPND_MASK:
    case AARCH64_OPND_IMMR:
    case AARCH64_OPND_IMMS:
    case AARCH64_OPND_WIDTH:
    case AARCH64_OPND_IMM:
    case AARCH64_OPND_IMM_2:
    case AARCH64_OPND_IMMP1_2:
    case AARCH64_OPND_IMMS1_2:
    case AARCH64_OPND_UIMM3_OP1:
    case AARCH64_OPND_UIMM3_OP2:
    case AARCH64_OPND_UIMM4:
    case AARCH64_OPND_UIMM4_ADDG:
    case AARCH64_OPND_UIMM7:
    case AARCH64_OPND_UIMM10:
    case AARCH64_OPND_BIT_NUM:
    case AARCH64_OPND_EXCEPTION:
    case AARCH64_OPND_UNDEFINED:
    case AARCH64_OPND_CCMP_IMM:
    case AARCH64_OPND_SIMM5:
    case AARCH64_OPND_NOT_BALANCED_10:
    case AARCH64_OPND_NOT_BALANCED_17:
    case AARCH64_OPND_NZCV:
    case AARCH64_OPND_ADDR_PCREL9:
    case AARCH64_OPND_ADDR_PCREL14:
    case AARCH64_OPND_ADDR_PCREL19:
    case AARCH64_OPND_ADDR_PCREL21:
    case AARCH64_OPND_ADDR_PCREL26:
    case AARCH64_OPND_RPRFMOP:
    case AARCH64_OPND_BRBOP:
    case AARCH64_OPND_SVE_PATTERN:
    case AARCH64_OPND_SVE_PRFOP:
    case AARCH64_OPND_SVE_SIMM5:
    case AARCH64_OPND_SVE_SIMM5B:
    case AARCH64_OPND_SVE_SIMM6:
    case AARCH64_OPND_SVE_SIMM8:
    case AARCH64_OPND_SVE_UIMM3:
    case AARCH64_OPND_SVE_UIMM7:
    case AARCH64_OPND_SVE_UIMM8:
    case AARCH64_OPND_SVE_UIMM8_53:
    case AARCH64_OPND_SVE_UIMM4:
    case AARCH64_OPND_SME_list_of_64bit_tiles:
    case AARCH64_OPND_SME_VLxN_10:
    case AARCH64_OPND_SME_VLxN_13:
    case AARCH64_OPND_SME_ZT0_INDEX:
    case AARCH64_OPND_SME_ZT0_INDEX_MUL_VL:
    case AARCH64_OPND_TME_UIMM16:
    case AARCH64_OPND_CSSC_SIMM8:
    case AARCH64_OPND_CSSC_UIMM8:
      return aarch64_ins_imm (self, info, code, inst, errors);
    case AARCH64_OPND_IMM_VLSL:
    case AARCH64_OPND_IMM_VLSR:
      return aarch64_ins_advsimd_imm_shift (self, info, code, inst, errors);
    case AARCH64_OPND_SIMD_IMM:
    case AARCH64_OPND_SIMD_IMM_SFT:
    case AARCH64_OPND_SIMD_FPIMM:
      return aarch64_ins_advsimd_imm_modified (self, info, code, inst, errors);
    case AARCH64_OPND_FPIMM:
    case AARCH64_OPND_SVE_FPIMM8:
      return aarch64_ins_fpimm (self, info, code, inst, errors);
    case AARCH64_OPND_LIMM:
    case AARCH64_OPND_SVE_LIMM:
      return aarch64_ins_limm (self, info, code, inst, errors);
    case AARCH64_OPND_AIMM:
      return aarch64_ins_aimm (self, info, code, inst, errors);
    case AARCH64_OPND_HALF:
      return aarch64_ins_imm_half (self, info, code, inst, errors);
    case AARCH64_OPND_FBITS:
      return aarch64_ins_fbits (self, info, code, inst, errors);
    case AARCH64_OPND_IMM_ROT1:
    case AARCH64_OPND_IMM_ROT2:
    case AARCH64_OPND_SVE_IMM_ROT2:
      return aarch64_ins_imm_rotate2 (self, info, code, inst, errors);
    case AARCH64_OPND_IMM_ROT3:
    case AARCH64_OPND_SVE_IMM_ROT1:
    case AARCH64_OPND_SVE_IMM_ROT3:
      return aarch64_ins_imm_rotate1 (self, info, code, inst, errors);
    case AARCH64_OPND_COND:
    case AARCH64_OPND_COND1:
      return aarch64_ins_cond (self, info, code, inst, errors);
    case AARCH64_OPND_ADDR_SIMPLE:
    case AARCH64_OPND_SIMD_ADDR_SIMPLE:
      return aarch64_ins_addr_simple (self, info, code, inst, errors);
    case AARCH64_OPND_ADDR_REGOFF:
      return aarch64_ins_addr_regoff (self, info, code, inst, errors);
    case AARCH64_OPND_ADDR_SIMM7:
    case AARCH64_OPND_ADDR_SIMM9:
    case AARCH64_OPND_ADDR_SIMM9_2:
    case AARCH64_OPND_ADDR_SIMM11:
    case AARCH64_OPND_ADDR_SIMM13:
      return aarch64_ins_addr_simm (self, info, code, inst, errors);
    case AARCH64_OPND_ADDR_SIMM10:
      return aarch64_ins_addr_simm10 (self, info, code, inst, errors);
    case AARCH64_OPND_ADDR_UIMM12:
      return aarch64_ins_addr_uimm12 (self, info, code, inst, errors);
    case AARCH64_OPND_ADDR_OFFSET:
      return aarch64_ins_addr_offset (self, info, code, inst, errors);
    case AARCH64_OPND_SIMD_ADDR_POST:
      return aarch64_ins_simd_addr_post (self, info, code, inst, errors);
    case AARCH64_OPND_SYSREG:
    case AARCH64_OPND_SYSREG128:
      return aarch64_ins_sysreg (self, info, code, inst, errors);
    case AARCH64_OPND_PSTATEFIELD:
      return aarch64_ins_pstatefield (self, info, code, inst, errors);
    case AARCH64_OPND_SYSREG_AT:
    case AARCH64_OPND_SYSREG_DC:
    case AARCH64_OPND_SYSREG_IC:
    case AARCH64_OPND_SYSREG_TLBI:
    case AARCH64_OPND_SYSREG_TLBIP:
    case AARCH64_OPND_SYSREG_PLBI:
    case AARCH64_OPND_SYSREG_MLBI:
    case AARCH64_OPND_SYSREG_SR:
    case AARCH64_OPND_GIC:
    case AARCH64_OPND_GICR:
    case AARCH64_OPND_GSB:
      return aarch64_ins_sysins_op (self, info, code, inst, errors);
    case AARCH64_OPND_BARRIER:
    case AARCH64_OPND_BARRIER_ISB:
      return aarch64_ins_barrier (self, info, code, inst, errors);
    case AARCH64_OPND_BARRIER_DSB_NXS:
      return aarch64_ins_barrier_dsb_nxs (self, info, code, inst, errors);
    case AARCH64_OPND_PRFOP:
      return aarch64_ins_prfop (self, info, code, inst, errors);
    case AARCH64_OPND_BTI_TARGET:
    case AARCH64_OPND_STSHH_POLICY:
    case AARCH64_OPND_SHUH_PHINT:
      return aarch64_ins_hint (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_ADDR_RI_S4x16:
    case AARCH64_OPND_SVE_ADDR_RI_S4x32:
      return aarch64_ins_sve_addr_ri_s4 (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_ADDR_RI_S4xVL:
    case AARCH64_OPND_SVE_ADDR_RI_S4x2xVL:
    case AARCH64_OPND_SVE_ADDR_RI_S4x3xVL:
    case AARCH64_OPND_SVE_ADDR_RI_S4x4xVL:
      return aarch64_ins_sve_addr_ri_s4xvl (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_ADDR_RI_S6xVL:
      return aarch64_ins_sve_addr_ri_s6xvl (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_ADDR_RI_S9xVL:
      return aarch64_ins_sve_addr_ri_s9xvl (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_ADDR_RI_U6:
    case AARCH64_OPND_SVE_ADDR_RI_U6x2:
    case AARCH64_OPND_SVE_ADDR_RI_U6x4:
    case AARCH64_OPND_SVE_ADDR_RI_U6x8:
      return aarch64_ins_sve_addr_ri_u6 (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_ADDR_RR:
    case AARCH64_OPND_SVE_ADDR_RR_LSL1:
    case AARCH64_OPND_SVE_ADDR_RR_LSL2:
    case AARCH64_OPND_SVE_ADDR_RR_LSL3:
    case AARCH64_OPND_SVE_ADDR_RR_LSL4:
    case AARCH64_OPND_SVE_ADDR_RM:
    case AARCH64_OPND_SVE_ADDR_RM_LSL1:
    case AARCH64_OPND_SVE_ADDR_RM_LSL2:
    case AARCH64_OPND_SVE_ADDR_RM_LSL3:
    case AARCH64_OPND_SVE_ADDR_RM_LSL4:
    case AARCH64_OPND_SVE_ADDR_RX:
    case AARCH64_OPND_SVE_ADDR_RX_LSL1:
    case AARCH64_OPND_SVE_ADDR_RX_LSL2:
    case AARCH64_OPND_SVE_ADDR_RX_LSL3:
    case AARCH64_OPND_SVE_ADDR_RX_LSL4:
    case AARCH64_OPND_SVE_ADDR_ZX:
    case AARCH64_OPND_SVE_ADDR_RZ:
    case AARCH64_OPND_SVE_ADDR_RZ_LSL1:
    case AARCH64_OPND_SVE_ADDR_RZ_LSL2:
    case AARCH64_OPND_SVE_ADDR_RZ_LSL3:
      return aarch64_ins_sve_addr_rr_lsl (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_ADDR_RZ_XTW_14:
    case AARCH64_OPND_SVE_ADDR_RZ_XTW_22:
    case AARCH64_OPND_SVE_ADDR_RZ_XTW1_14:
    case AARCH64_OPND_SVE_ADDR_RZ_XTW1_22:
    case AARCH64_OPND_SVE_ADDR_RZ_XTW2_14:
    case AARCH64_OPND_SVE_ADDR_RZ_XTW2_22:
    case AARCH64_OPND_SVE_ADDR_RZ_XTW3_14:
    case AARCH64_OPND_SVE_ADDR_RZ_XTW3_22:
      return aarch64_ins_sve_addr_rz_xtw (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_ADDR_ZI_U5:
    case AARCH64_OPND_SVE_ADDR_ZI_U5x2:
    case AARCH64_OPND_SVE_ADDR_ZI_U5x4:
    case AARCH64_OPND_SVE_ADDR_ZI_U5x8:
      return aarch64_ins_sve_addr_zi_u5 (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_ADDR_ZZ_LSL:
      return aarch64_ins_sve_addr_zz_lsl (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_ADDR_ZZ_SXTW:
      return aarch64_ins_sve_addr_zz_sxtw (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_ADDR_ZZ_UXTW:
      return aarch64_ins_sve_addr_zz_uxtw (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_AIMM:
      return aarch64_ins_sve_aimm (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_ASIMM:
      return aarch64_ins_sve_asimm (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_I1_HALF_ONE:
      return aarch64_ins_sve_float_half_one (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_I1_HALF_TWO:
      return aarch64_ins_sve_float_half_two (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_I1_ZERO_ONE:
      return aarch64_ins_sve_float_zero_one (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_INV_LIMM:
      return aarch64_ins_inv_limm (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_LIMM_MOV:
      return aarch64_ins_sve_limm_mov (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_PATTERN_SCALED:
      return aarch64_ins_sve_scale (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_SHLIMM_PRED:
    case AARCH64_OPND_SVE_SHLIMM_UNPRED:
    case AARCH64_OPND_SVE_SHLIMM_UNPRED_22:
      return aarch64_ins_sve_shlimm (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_SHRIMM_PRED:
    case AARCH64_OPND_SVE_SHRIMM_UNPRED:
    case AARCH64_OPND_SVE_SHRIMM_UNPRED_22:
    case AARCH64_OPND_SME_SHRIMM5:
      return aarch64_ins_sve_shrimm (self, info, code, inst, errors);
    case AARCH64_OPND_SME_ZA_array_vrsb_1:
    case AARCH64_OPND_SME_ZA_array_vrsh_1:
    case AARCH64_OPND_SME_ZA_array_vrss_1:
    case AARCH64_OPND_SME_ZA_array_vrsd_1:
      return aarch64_ins_sme_za_vrs1 (self, info, code, inst, errors);
    case AARCH64_OPND_SME_ZA_array_vrsb_2:
    case AARCH64_OPND_SME_ZA_array_vrsh_2:
    case AARCH64_OPND_SME_ZA_array_vrss_2:
    case AARCH64_OPND_SME_ZA_array_vrsd_2:
      return aarch64_ins_sme_za_vrs2 (self, info, code, inst, errors);
    case AARCH64_OPND_SME_ZA_ARRAY4:
      return aarch64_ins_sme_za_tile_to_vec (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_Zm3_INDEX:
    case AARCH64_OPND_SVE_Zm3_11_INDEX:
    case AARCH64_OPND_SVE_Zm3_19_INDEX:
    case AARCH64_OPND_SVE_Zm3_22_INDEX:
    case AARCH64_OPND_SVE_Zm3_10_INDEX:
    case AARCH64_OPND_SVE_Zm4_11_INDEX:
    case AARCH64_OPND_SVE_Zm4_INDEX:
      return aarch64_ins_sve_quad_index (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_Zn_INDEX:
    case AARCH64_OPND_SVE_Zn_5_INDEX:
      return aarch64_ins_sve_index (self, info, code, inst, errors);
    case AARCH64_OPND_SVE_ZnxN:
    case AARCH64_OPND_SVE_ZtxN:
    case AARCH64_OPND_SME_Zn7xN_UNTYPED:
    case AARCH64_OPND_SME_PdxN:
      return aarch64_ins_sve_reglist (self, info, code, inst, errors);
    case AARCH64_OPND_SME_Zdnx2:
    case AARCH64_OPND_SME_Zdnx4:
    case AARCH64_OPND_SME_Znx2_6_3:
    case AARCH64_OPND_SME_Zmx2_17_3:
    case AARCH64_OPND_SME_Zmx2:
    case AARCH64_OPND_SME_Zmx4:
    case AARCH64_OPND_SME_Znx2:
    case AARCH64_OPND_SME_Znx2_BIT_INDEX:
    case AARCH64_OPND_SME_Znx4:
    case AARCH64_OPND_SME_Pdx2:
      return aarch64_ins_sve_aligned_reglist (self, info, code, inst, errors);
    case AARCH64_OPND_SME_Zmx2_INDEX_22:
      return aarch64_ins_sve_reglist_index (self, info, code, inst, errors);
    case AARCH64_OPND_SME_Ztx2_STRIDED:
    case AARCH64_OPND_SME_Ztx4_STRIDED:
      return aarch64_ins_sve_strided_reglist (self, info, code, inst, errors);
    case AARCH64_OPND_SME_ZA_HV_idx_src:
    case AARCH64_OPND_SME_ZA_HV_idx_dest:
    case AARCH64_OPND_SME_ZA_HV_idx_ldstr:
      return aarch64_ins_sme_za_hv_tiles (self, info, code, inst, errors);
    case AARCH64_OPND_SME_ZA_HV_idx_srcxN:
    case AARCH64_OPND_SME_ZA_HV_idx_destxN:
      return aarch64_ins_sme_za_hv_tiles_range (self, info, code, inst, errors);
    case AARCH64_OPND_SME_ZA_array_off1x4:
    case AARCH64_OPND_SME_ZA_array_off2x2:
    case AARCH64_OPND_SME_ZA_array_off2x4:
    case AARCH64_OPND_SME_ZA_array_off3_0:
    case AARCH64_OPND_SME_ZA_array_off3_5:
    case AARCH64_OPND_SME_ZA_array_off3x2:
    case AARCH64_OPND_SME_ZA_array_off4:
      return aarch64_ins_sme_za_array (self, info, code, inst, errors);
    case AARCH64_OPND_SME_ADDR_RI_U4xVL:
      return aarch64_ins_sme_addr_ri_u4xvl (self, info, code, inst, errors);
    case AARCH64_OPND_SME_SM_ZA:
      return aarch64_ins_sme_sm_za (self, info, code, inst, errors);
    case AARCH64_OPND_SME_PnT_Wm_imm:
      return aarch64_ins_sme_pred_reg_with_index (self, info, code, inst, errors);
    case AARCH64_OPND_SME_SHRIMM3:
    case AARCH64_OPND_SME_SHRIMM4:
      return aarch64_ins_plain_shrimm (self, info, code, inst, errors);
    case AARCH64_OPND_MOPS_ADDR_Rd:
    case AARCH64_OPND_MOPS_ADDR_Rs:
    case AARCH64_OPND_MOPS_WB_Rn:
      return aarch64_ins_x0_to_x30 (self, info, code, inst, errors);
    case AARCH64_OPND_RCPC3_ADDR_OPT_POSTIND:
    case AARCH64_OPND_RCPC3_ADDR_OPT_PREIND_WB:
    case AARCH64_OPND_RCPC3_ADDR_POSTIND:
    case AARCH64_OPND_RCPC3_ADDR_PREIND_WB:
      return aarch64_ins_rcpc3_addr_opt_offset (self, info, code, inst, errors);
    case AARCH64_OPND_RCPC3_ADDR_OFFSET:
      return aarch64_ins_rcpc3_addr_offset (self, info, code, inst, errors);
    default: assert (0); abort ();
    }
}
