
;;; d-key-toggle.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-key-toggle.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: toggles the value of selective-display
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(if prefs-home-emacs-p
    (global-set-key [f6] 'd-k-toggle))

(defun d-k-toggle--are-we-inside-a-class ()
  (if (or (eq major-mode 'c-mode)
          (eq major-mode 'c++-mode)
          (eq major-mode 'java-mode))
      (save-excursion
        (let ((p (point)))
          ;;(when (re-search-backward "^\\(\\(public\\|[A-Z]+\\)[ \t]+\\)*\\(class\\|interface\\)" nil t)
          (when (re-search-backward "^\\(public\\)?[ \t]+\\(class\\|interface\\)" nil t)
            (beginning-of-line)
            (forward-line 1)
            (assert (looking-at "{"))
            (forward-sexp 1)
            (< p (point)))
          ))))

(defun d-k-toggle--are-we-inside-a-lisp++-class ()
  (if (eq major-mode 'c++-mode)
      (save-excursion
        (let ((p (point)))
          (when (re-search-backward "^(cclass " nil t)
            (beginning-of-line)
            (forward-sexp 1)
            (< p (point)))
          ))))

(defun d-k-toggle ()
  (interactive)
  (if (or (not (boundp 'selective-display)) (not selective-display))
      (set-selective-display 0))
  (cond
   ((d-k-toggle--are-we-inside-a-class)
    (cond
     ((eq selective-display 0)
      (set-selective-display 6))
     ((eq selective-display 3)
      (set-selective-display 6))
     ((eq selective-display 6)
      (set-selective-display 0))))
   ((d-k-toggle--are-we-inside-a-lisp++-class)
    (cond
     ((eq selective-display 0)
      (set-selective-display 1))
     ((eq selective-display 1)
      (set-selective-display 2))
     ((eq selective-display 2)
      (set-selective-display 0)))
    )
   (t
    (cond
     ((eq selective-display 0)
      (set-selective-display 3))
     ((eq selective-display 3)
      (set-selective-display 0))
     ((eq selective-display 6)
      (set-selective-display 0)))
    )
   )
  )

(provide 'd-key-toggle)
;;; d-key-toggle.el ends here
