
(defun d-elisp-stuff ()
  "My own Emacs Lisp stuff.  Currently remaps ^J and ^M and customizes
dynamic abbrevs."
  (set (make-local-variable 'dabbrev-case-fold-search) nil)
  (set (make-local-variable 'dabbrev-case-replace) nil)
  (modify-syntax-entry ?- "w")
  ;;; NOTE: temporary workaround for d-latexize.el
  (modify-syntax-entry ?{ "(")
  (modify-syntax-entry ?} ")")
  (setq case-fold-search nil)
  (define-key emacs-lisp-mode-map "\C-j" 'd-indent-new-comment-line)
  (define-key emacs-lisp-mode-map "\C-m" 'd-indent-new-comment-line)
  (if emacs-dialect--xemacs-p
      (define-key emacs-lisp-mode-map [return] 'd-indent-new-comment-line))
  (define-key emacs-lisp-mode-map "\C-f" nil)
  (define-key emacs-lisp-mode-map "\C-t" 'find-lisp-definition)
  (progn
    (define-key emacs-lisp-mode-map [(control prior)] 'd-control-prior)
    (define-key emacs-lisp-mode-map [(control next)]  'd-control-next)
    (define-key emacs-lisp-mode-map [(shift prior)] 'backward-paragraph)
    (define-key emacs-lisp-mode-map [(shift next)]  'forward-paragraph)
    )
  (setq truncate-lines nil)
  )
(add-hook 'emacs-lisp-mode-hook 'd-elisp-stuff)
(add-hook 'emacs-lisp-mode-hook 'turn-on-font-lock)

;;(defadvice error (before fix-bug activate)
;;  (setq debug-on-error global-debug-on-error))

;;(error "smeg")

(provide 'd-lisp)
;;; d-lisp.el ends here
