;;;TwoNoteTremolo
;;;repeats the selection the given number of times
(if TwoNoteTremolo::params
    (d-InfoDialog (_ "This Denemo Directive is part of a set of four creating a \"Two note (or chord) tremolo\". Be sure to delete them all if you delete one of them."))
    (if (d-IsInSelection)
        (let ((tag "TremoloRepeat")(duration #f)(num_repeats (d-GetUserInput (_ "Tremolo Repeat") (_ "Give number of times the two notes/chords should be sounded 2,4... \n(must total up to proper note duration)") "8")))
            (define (at-start) ;;;enter with d-IsInSelection
                (define ret #f)
                (if (not (d-MoveCursorLeft))
                    (set! ret #t)
                    (begin
                        (set! ret (not (d-IsInSelection)))
                        (d-MoveCursorRight)))
                ret)
            (MoveToEndOfSelection)
            (set! duration (d-GetDurationInTicks))
            (if (and num_repeats (d-MoveCursorLeft) (at-start) (= duration (d-GetDurationInTicks))) ;;;precisely two objects selected of same duration
                (let ()
                    (set! num_repeats (string->number num_repeats))
                    (d-Copy)
                    (d-Directive-standalone tag)
                    (d-DirectivePut-standalone-minpixels tag 40)
                    (d-DirectivePut-standalone-postfix tag (string-append "\\repeat tremolo " (number->string num_repeats) "{ "))
                    (d-DirectivePut-standalone-display tag (string-append "% " (number->string num_repeats)))                   
                    (d-DirectivePut-standalone-graphic tag (string-append "\nR{\nDenemo\n36"))
                    (d-DirectivePut-standalone-gy tag 10)
                    (d-MoveCursorRight)
                    (d-MoveCursorRight)
                    (d-MoveCursorRight)
                    (d-Directive-standalone tag)
                    (d-DirectivePut-standalone-minpixels tag 60)
                    (d-DirectivePut-standalone-postfix tag "} %{ ")
                    (d-DirectivePut-standalone-graphic tag "\n}%{\nDenemo\n36")
                    (d-DirectivePut-standalone-gy tag 10)
                    (d-MoveCursorRight)
                    (let loop ((count num_repeats))
                        (d-Paste)
                        (if (> count 2)
                            (loop (1- count))))
                    (d-Directive-standalone tag)
                    (d-DirectivePut-standalone-minpixels tag 40)       
                    (d-DirectivePut-standalone-postfix tag " %} ")
                    (d-DirectivePut-standalone-graphic tag "\n%}\nDenemo\n36")
                    (d-DirectivePut-standalone-gy tag 10)
                    (d-MoveCursorRight)
                    (d-RefreshDisplay)
                    (d-SetSaved #f))
                (begin    
                    (d-WarningDialog (_ "The selection must comprise two notes/chords which will sound alternately as a tremolo. The display will show and sound out repetitions, while LilyPond will typeset them using the tremolo notation.")))))
        (d-WarningDialog (_ "Cursor not in selection"))))