#include <stdio.h>
#include "cci.h"

#include "mosaic.h"
extern mo_window *current_win;

int cci_get = 0;

char *mo_post_pull_er_over (char *url, char *content_type,
                                   char *post_data,
                                   char **texthead);
char *MoReturnURLFromFileName(char *fileName);
char *mo_fetch_personal_annotations(char *url);


/***************************************************************************/
/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/* This module contains bindings between the new cci code and the browser  */
/* If you are retrofitting the cci on to your browser strip out everything */
/* except the function headers and the return values and stick in the      */
/* appropriate calls for your browser.                                     */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/
/***************************************************************************/


void MCCIRequestGetURL(retCode,retText,url,output,additionalHeader)
int *retCode;
char *retText; /* must be less MCCI_MAX_RETURN_TEXT*/
char *url;
int output;
char *additionalHeader; 	/* currently additional header ignored */
{
mo_status moStatus;

#ifdef DEBUG
if (additionalHeader)
  printf("MCCIRequestGetURL(url=\"%s\",output=%d,header=\"%s\")\n",
	 url,output,additionalHeader);
else
  printf("MCCIRequestGetURL(url=\"%s\",output=%d)\n",
	 url,output);
#endif

	if (!Rdata.load_local_file)
		if (!strncasecmp(url,"file:",5)) {
			*retCode = MCCIR_GET_FAILED;
			strcpy(retText,
				" Can't get local file (for CCI security reasons)");
			return;
			}

	/*do it */
	if (!strchr (url, ':')) {
		url = mo_url_canonicalize_local (url);
		}

	switch (output) {
	    case MCCI_OUTPUT_CURRENT:
		/* turn flag on so mosaic will know to do a get*/
		cci_get = 1; 	

		moStatus = mo_load_window_text (current_win, url, NULL);
		if (moStatus == mo_succeed) {
			*retCode = MCCIR_GET_OK;
			strcpy(retText,"Got the URL");
			}
		else {
			*retCode = MCCIR_GET_FAILED;
			sprintf(retText,"Couldn't get URL %s",url);
			}
			break;

		cci_get = 0;  	/* done with get, turn flag off */
	    case MCCI_OUTPUT_NEW:
		/* turn flag on so mosaic will know to do a get*/
		cci_get = 1; 	

		if (!mo_open_another_window(current_win,url,NULL,NULL)) {
			*retCode = MCCIR_GET_FAILED;
			sprintf(retText,"Couldn't get URL %s",url);
			}
		else {
			*retCode = MCCIR_GET_OK;
			strcpy(retText,"Got the URL");
			}

		cci_get = 0;  	/* done with get, turn flag off */
		break;
	    case MCCI_OUTPUT_NONE:
		*retCode = MCCIR_GET_FAILED;
		strcpy(retText,"Sorry, OUTPUT to no where not supported yet");
		break;
	    default:
		*retCode = MCCIR_GET_FAILED;
		strcpy(retText,"Send output where???");
		break;
	    }

	return;
}

void MCCIRequestForm(client, retCode,retText,actionID,status)
MCCIPort client;
int *retCode;
char *retText; /* must be less MCCI_MAX_RETURN_TEXT*/
char *actionID;
int status;
{
mo_status moStatus;

#ifdef DEBUG
  printf("MCCIRequestGetURL(url=\"%s\",output=%d)\n",
	 url,output);
#endif

	MoCCIForm(client, actionID, status, 0);
	*retCode = MCCIR_FORM_OK;
	strcpy(retText, "Form Submit Received");

	return;
}

void MCCIRequestSendAnchor(retCode,retText,client,status)
int *retCode;
char *retText; /* must be less MCCI_MAX_RETURN_TEXT*/
MCCIPort client;
int status; /* 0, MCCI_SEND_BEFORE, or MCCI_SEND_AFTER */
/* anchor replies may be sent back using MCCISendAnchorHistory(client,url)*/
{

#ifdef DEBUG
		printf("MCCIRequestSendAnchor(%d)\n",status);
#endif

		switch (status) {
		      case MCCI_SEND_BEFORE:
			MoCCISendAnchor(client,1);
			*retCode = MCCIR_SEND_ANCH_BEF_OTHR_OK;
			strcpy(retText,"Send Anchor Before enabled");
			break;
		      case MCCI_SEND_AFTER:
		        MoCCISendAnchor(client,2);
			*retCode = MCCIR_SEND_ANCH_AFT_OTHR_OK;
			strcpy(retText,"Send Anchor After enabled");
			break;
		      case 0:
			MoCCISendAnchor(client,0);
			*retCode = MCCIR_SEND_A_STOP_OK;
			strcpy(retText,"Send Anchor disabled");
			break;
		}
}

void MCCIRequestSendOutput(retCode,retText,client,on,type)
int *retCode;
char *retText; /* must be less MCCI_MAX_RETURN_TEXT*/
MCCIPort client;
int on;		/* boolean value....turn on - true, off - false */
char *type;	/* if null, assume all types */
{

#ifdef DEBUG
		printf("MCCIRequestSendOutput(%d,%s)\n",on,type);
#endif
	if (on) {
		MoCCISendOutput(client,1,type);
		*retCode = MCCIR_SEND_OUTPUT_OK;
		strcpy(retText,"Send OUTPUT enabled");
		}
	else {
		MoCCISendOutput(client,0,type);
		*retCode = MCCIR_SEND_O_STOP_OK;
		strcpy(retText,"Send OUTPUT disabled");
		}
	return;
}



void MCCIRequestSendBrowserView(retCode,retText,client,on)
int *retCode;
char *retText; /* must be less MCCI_MAX_RETURN_TEXT*/
MCCIPort client;
int on;		/* boolean value....turn on - true, off - false */
{

#ifdef DEBUG
		printf("MCCIRequestSendBrowserView(%d)\n",on);
#endif
	if (on) {
		MoCCISendBrowserView(client,1);
		*retCode = MCCIR_BROWSERVIEW_OK;
		strcpy(retText,"Send BROWSERVIEW enabled");
		}
	else {
		MoCCISendBrowserView(client,0);
		*retCode = MCCIR_BROWSERVIEW_STOP_OK;
		strcpy(retText,"Send BROWSERVIEW disabled");
		}
	return;
}



void MCCIRequestPost(client,retCode,retText,url,contentType,
			postData,dataLength,output)
MCCIPort client;
int *retCode;
char *retText;
char *url;
char *contentType;
char *postData;
int dataLength;
int output;
{
char *textHead;
char *response;
char buff[256];
int length;

#ifdef DEBUG
	printf("MCCIRequestPost(): about to mo_post_pull_er_over()\n");
	printf("mo_post_pull_er_over(url=\"%s\",type=\"%s\",postData=\"%s\")\n"
			,url,contentType,postData);
#endif

	*retCode = MCCIR_POST_OK;
	strcpy(retText,"Post Request ok");

	switch(output) {
		case MCCI_OUTPUT_NONE:
			/* do not display output of post, but send the
			   output back through the cci to the client */
			response = mo_post_pull_er_over(url, 
				contentType, postData, &textHead);

			/* send response back through cci */
			if (response && (length = strlen(response))) {
				MCCISendResponseLine(client,MCCIR_POST_OUTPUT,
							"POST output");
				sprintf(buff,"Content-Length: %d\r\n",length);
				if (length!=NetServerWrite(client,
							buff,strlen(buff))){
					/* this is pointless... I know */
					strcpy(retText,"couldn't send output");
					*retCode = MCCI_FAIL;
					}
				if (length!=NetServerWrite(client,
							response,length)) {
					/* this is pointless... I know */
					strcpy(retText,"couldn't send output");
					*retCode = MCCI_FAIL;
					}
				}
			
			break;
		case MCCI_OUTPUT_NEW:
			/* open a new window and display posting... */
			/* ...not done yet...*/

		case MCCI_DEFAULT: /* default to output current */
		case MCCI_OUTPUT_CURRENT:
		default:
			/* display in current window */
			response = mo_post_pull_er_over(url, 
				contentType, postData, &textHead);
			/*mo_decode_internal_reference(url,response,url);*/
			mo_do_window_text(current_win,url,
						response,response,1,url,0,0);
			
			break;
		}

#ifdef DEBUG
	printf("result from mo_post_pull_er_over():\"%s\"\n",response);
	printf("MCCIRequestPost(): returning now\n");
#endif

}


void MCCIRequestDisplay(client,retCode,retText,url,contentType,
			displayData,dataLength,output)
MCCIPort client;
int *retCode;
char *retText;
char *url;
char *contentType;
char *displayData;
int dataLength;
int output;
{
char *textHead;
char *response;
char buff[256];
int length;
char *ref;
char *new_url;

#ifdef DEBUG
	printf("MCCIRequestDisplay(): about to mo_post_pull_er_over()\n");
	printf("mo_post_pull_er_over(url=\"%s\",type=\"%s\",	\
		displayData=\"%s\")\n" ,url,contentType,displayData);
#endif

	*retCode = MCCIR_DISPLAY_OK;
	strcpy(retText,"Display Request ok");

	switch(output) {
		case MCCI_OUTPUT_NONE:
			strcpy(retText, "OUTPUT NONE not support yet\n");
			break;
		case MCCI_OUTPUT_NEW:
			/* open a new window and display... */
			/* ...not done yet...*/
			strcpy(retText, "OUTPUT NEW not support yet\n");

		case MCCI_DEFAULT: /* default to output current */
		case MCCI_OUTPUT_CURRENT:
		default:
			/* display in current window */
			ref = strdup(url);
			new_url = strdup(url);
			if (strcmp(contentType, "text/html") == 0)
				mo_do_window_text(current_win, new_url, 
					displayData, displayData, 1, ref, current_win->current_node->last_modified, current_win->current_node->expires);
			else
				strcpy(retText, "Display text/html only");	
			break;
		}

#ifdef DEBUG
	printf("MCCIRequestDisplay(): returning now\n");
#endif

}

void MCCIRequestQuit()
/* time to die */
{
	mo_exit();
}

void MCCIRequestGetAnnotation(retCode,retText,retData,retDataLength,url,type)
int *retCode;
char *retText;
char **retData;
int *retDataLength;
char *url;
int type;
{
  *retDataLength = 0;
  
  if ((type == MCCI_PRIVATE_ANNOTATION) || 
      (type == MCCI_ALL_ANNOTATION)) {
    if ((*retData) = mo_fetch_personal_annotations(url)) {
      *retCode = MCCIR_PRIVATE_ANNOTATION;
      strcpy(retText,"Annotation follows");
      *retDataLength = strlen(*retData);
    }
    else {
      *retData = NULL;
      *retCode = MCCIR_NO_ANNOTATION;
      strcpy(retText,"No annotation for this URL");
    }
  }
  else {
    *retCode = MCCIR_NO_ANNOTATION;
    strcpy(retText,"Only Private annotations currently supported");
  }
  
  return;
}


MCCIRequestPutAnnotation(retCode,retText,type,url,annotation,annotationLength)
int *retCode;
char *retText;
int type;
char *url;
char *annotation;
int annotationLength;
{
  if (type == MCCI_PRIVATE_ANNOTATION) {
    *retCode = mo_new_pan(url, NULL, NULL, annotation);
  }
}

MCCIRequestFileToURL(retCode,retText,fileName)
int *retCode;
char *retText;
char *fileName;
{
char *url;

	url = MoReturnURLFromFileName(fileName);
	if (url) {
		strcpy(retText,url);
		*retCode = MCCIR_FILE_TO_URL;
		}
	else {
		strcpy(retText,"No URL for given file name");
		*retCode = MCCIR_NO_URL_FOR_FILE; 
		}
}

