/*
* $XConsortium: UtkasciiSinkP.h,v 1.2 89/10/04 13:56:34 kit Exp $
*/


/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* 
 * utkasciiSinkP.h - Private definitions for utkasciiSink object
 * 
 */
/*
 * 
$Log: UtkasciiSinkP.h,v $
 * Revision 1.2  1992/12/05  17:27:42  larose
 * added rcs logging
 *
 *
 */


#ifndef _UtkasciiSinkP_h
#define _UtkasciiSinkP_h

/***********************************************************************
 *
 * UtkasciiSink Object Private Data
 *
 ***********************************************************************/

#include <X11/Xaw/TextSinkP.h> 
#include "UtkasciiSink.h" 

/************************************************************
 *
 * New fields for the UtkasciiSink object class record.
 *
 ************************************************************/

typedef struct _UtkasciiSinkClassPart {
  int foo;
} UtkasciiSinkClassPart;

/* Full class record declaration */

typedef struct _UtkasciiSinkClassRec {
    ObjectClassPart     object_class;
    TextSinkClassPart	text_sink_class;
    UtkasciiSinkClassPart	utkascii_sink_class;
} UtkasciiSinkClassRec;

extern UtkasciiSinkClassRec utkasciiSinkClassRec;

/* New fields for the UtkasciiSink object record */
typedef struct {
    /* public resources */
    Boolean hyper;
    Boolean echo;
    Boolean display_nonprinting;
	Pixel fileSelColor, fileColor, libColor;

    /* private state */
	GC libgc;
	Dimension libWide, libHigh;
	int libYoff;
	Pixmap lib_pic, bang_pic;
	GC filegc, filexgc;
	Dimension fileWide, fileHigh;
	int fileYoff;
	Pixmap file_pic, filex_pic;

    GC normgc, invgc, xorgc;
    Pixmap insertCursorOn;
    XawTextInsertState laststate;
    short cursor_x, cursor_y;	/* Cursor Location. */
} UtkasciiSinkPart;

/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _UtkasciiSinkRec {
    ObjectPart          object;
    TextSinkPart	text_sink;
    UtkasciiSinkPart	utkascii_sink;
} UtkasciiSinkRec;

#endif /* _UtkasciiSinkP_h */

