#include <ctype.h>

#if defined(ultrix)
#  include <cursesX.h>
#else
#  include <curses.h>
#endif

#include "boolean.h"
#include "STRstring.h"

#ifdef KEY_RIGHT
#define SYSVCURSES
#endif

struct CursesStruct {
     WINDOW *Screen;
     String *Termtype;

     /** Termcap/terminfo stuff **/
     String *Clearscreen;
     String *AudibleBell;
     String *Highlighton;
     String *Highlightoff;
     
     boolean inCurses;
     
     int COLS;
     int ROWS;
     
     void (*sigtstp)();
     void (*sigwinch)();
};

typedef struct CursesStruct CursesObj;
typedef struct CursesStruct *CursesObjp;

#ifndef SYSVCURSES
#define KEY_DOWN        0402           /* The four arrow keys ...*/
#define KEY_UP          0403
#define KEY_LEFT        0404
#define KEY_RIGHT       0405           
#define KEY_NPAGE       0522           /* Next page */
#define KEY_PPAGE       0523           /* Previous page */
#define KEY_ENTER       0527
#endif

#if defined(VMS) || defined(__convex__) || defined(sequent)
#if !defined(cbreak)
#define cbreak crmode
#endif
#endif


/*
 * access functions
 */

#define CURgetScreen(a)    ((a)->Screen)
#define CURgetTerm(a)      (STRget((a)->Termtype))
#define CURgetCLS(a)       (STRget((a)->Clearscreen))
#define CURgetBell(a)      (STRget((a)->AudibleBell))
#define CURgetHighon(a)    (STRget((a)->Highlighton))
#define CURgetHighoff(a)   (STRget((a)->Highlightoff))

#define CURsetScreen(a,b)  ((a)->Screen=(b))
#define CURsetTerm(a,b)    (STRset((a)->Termtype, (b)))
#define CURsetCLS(a,b)     (STRset((a)->Clearscreen,(b)))
#define CURsetBell(a,b)    (STRset((a)->AudibleBell,(b)))
#define CURsetHighon(a,b)  (STRset((a)->Highlighton,(b)))
#define CURsetHighoff(a,b) (STRset((a)->Highlightoff,(b)))
#define CURsetSIGTSTP(a,b) ((a)->sigtstp=(b))
#define CURsetSIGWINCH(a,b) ((a)->sigwinch=(b))


CursesObj *CURnew();
void      CURinit();
void      CURcenterline();
void      CURenter();
void      CURexit();
int       CURgetstr();
int       CURgetch();
void      CURresize();
int       CURoutchar();
int       CURGetOneOption();
void      CURBeep();
