///////////////////////////////////////////////////////////////////////////////
// $Id: Deck.hxx,v 1.1 1995/01/12 02:10:49 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// Deck.hxx - Deck class
//
//
// Bradford W. Mott
// Copyright (C) 1994
// November 11,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: Deck.hxx,v $
// Revision 1.1  1995/01/12  02:10:49  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef DECK_HXX
#define DECK_HXX

#include "LinkedList.hxx"
#include "DrawingArea.hxx"
#include "Card.hxx"
#include "SpriteCollection.hxx"


class Deck : public DrawingArea {
  private:
    double myCardOffset;

  protected:
    // Maximum height the deck's view is allowed to be
    int myMaximumHeight; 

    // Collection of all the sprites in the system
    SpriteCollection* mySprites; 

    // Linked list to hold all of my cards
    LinkedList<Card> myListOfCards;

    // Determine the corresponding card index from the y coordinate in my view
    int cardIndexFromCoordinate(int y);

    // Update graphical view of myself
    virtual void updateView();

    // Called whenever an event arrives for me (I need to override the default)
    virtual void handleEvent(XEvent* event);

    // Protected constructor to prevent instantiation
    Deck(ContainerWidget* parent, const char *const widgetName,
        int x, int y, int width, int maxHeight, SpriteCollection* sprites);

  public:
    // Destructor
    virtual ~Deck();

    // Add the given card to myself
    void add(Card* card);

    // Add the given cards to myself
    void add(LinkedList<Card>* cards);

    // Remove my top card if one exists
    Card* remove();

    // Turn my top card over if it needs to be
    void turnTopCardFaceUp();

    // Shuffle deck of cards
    void shuffle();
};
#endif

