/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.collections;

import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class CircularArray<T> {
    private Object[] data;
    private int offset;

    public CircularArray(int length) {
        if (length <= 0) {
            throw new ReviewedStingException("CircularArray length must be positive. Passed: " + length);
        }
        this.data = new Object[length];
        this.offset = 0;
    }

    public int length() {
        return this.data.length;
    }

    public T get(int i) {
        if (i < 0 || i >= this.data.length) {
            throw new IndexOutOfBoundsException("Length of CircularArray: " + this.data.length + "; element requested: " + i);
        }
        return (T)this.data[(this.offset + i) % this.data.length];
    }

    public void set(int i, T value) {
        if (i < 0 || i >= this.data.length) {
            throw new IndexOutOfBoundsException("Length of CircularArray: " + this.data.length + "; set element request at: " + i);
        }
        this.data[(this.offset + i) % this.data.length] = value;
    }

    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = null;
        }
        this.offset = 0;
    }

    public void shiftData(int shift) {
        if (shift >= this.data.length) {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = null;
            }
            this.offset = 0;
            return;
        }
        int newOffset = (this.offset + shift) % this.data.length;
        if (newOffset < this.offset) {
            int i;
            for (i = this.offset; i < this.data.length; ++i) {
                this.data[i] = null;
            }
            for (i = 0; i < newOffset; ++i) {
                this.data[i] = null;
            }
        } else {
            for (int i = this.offset; i < newOffset; ++i) {
                this.data[i] = null;
            }
        }
        this.offset = newOffset;
    }

    public static class Int {
        private int[] data;
        private int offset;

        public Int(int length) {
            if (length <= 0) {
                throw new ReviewedStingException("CircularArray length must be positive. Passed: " + length);
            }
            this.data = new int[length];
            this.offset = 0;
        }

        public int length() {
            return this.data.length;
        }

        public int get(int i) {
            if (i < 0 || i >= this.data.length) {
                throw new IndexOutOfBoundsException("Length of CircularArray: " + this.data.length + "; element requested: " + i);
            }
            return this.data[(this.offset + i) % this.data.length];
        }

        public void set(int i, int value) {
            if (i < 0 || i >= this.data.length) {
                throw new IndexOutOfBoundsException("Length of CircularArray: " + this.data.length + "; set element request at: " + i);
            }
            this.data[(this.offset + i) % this.data.length] = value;
        }

        public void increment(int i, int value) {
            if (i < 0 || i >= this.data.length) {
                throw new IndexOutOfBoundsException("Length of CircularArray: " + this.data.length + "; increment element request at: " + i);
            }
            int n = (this.offset + i) % this.data.length;
            this.data[n] = this.data[n] + value;
        }

        public void clear() {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = 0;
            }
            this.offset = 0;
        }

        public void shiftData(int shift) {
            if (shift >= this.data.length) {
                for (int i = 0; i < this.data.length; ++i) {
                    this.data[i] = 0;
                }
                this.offset = 0;
                return;
            }
            int newOffset = (this.offset + shift) % this.data.length;
            if (newOffset < this.offset) {
                int i;
                for (i = this.offset; i < this.data.length; ++i) {
                    this.data[i] = 0;
                }
                for (i = 0; i < newOffset; ++i) {
                    this.data[i] = 0;
                }
            } else {
                for (int i = this.offset; i < newOffset; ++i) {
                    this.data[i] = 0;
                }
            }
            this.offset = newOffset;
        }
    }
}

