# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ComplianceStatus(_serialization.Model):
    """Compliance Status details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar compliance_state: The compliance state of the configuration. Known values are: "Pending",
     "Compliant", "Noncompliant", "Installed", and "Failed".
    :vartype compliance_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.ComplianceStateType
    :ivar last_config_applied: Datetime the configuration was last applied.
    :vartype last_config_applied: ~datetime.datetime
    :ivar message: Message from when the configuration was applied.
    :vartype message: str
    :ivar message_level: Level of the message. Known values are: "Error", "Warning", and
     "Information".
    :vartype message_level: str or
     ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.MessageLevelType
    """

    _validation = {
        "compliance_state": {"readonly": True},
    }

    _attribute_map = {
        "compliance_state": {"key": "complianceState", "type": "str"},
        "last_config_applied": {"key": "lastConfigApplied", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
        "message_level": {"key": "messageLevel", "type": "str"},
    }

    def __init__(
        self,
        *,
        last_config_applied: Optional[datetime.datetime] = None,
        message: Optional[str] = None,
        message_level: Optional[Union[str, "_models.MessageLevelType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword last_config_applied: Datetime the configuration was last applied.
        :paramtype last_config_applied: ~datetime.datetime
        :keyword message: Message from when the configuration was applied.
        :paramtype message: str
        :keyword message_level: Level of the message. Known values are: "Error", "Warning", and
         "Information".
        :paramtype message_level: str or
         ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.MessageLevelType
        """
        super().__init__(**kwargs)
        self.compliance_state = None
        self.last_config_applied = last_config_applied
        self.message = message
        self.message_level = message_level


class ErrorDefinition(_serialization.Model):
    """Error definition.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
     Required.
    :vartype code: str
    :ivar message: Description of the error. Required.
    :vartype message: str
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: str, message: str, **kwargs: Any) -> None:
        """
        :keyword code: Service specific error code which serves as the substatus for the HTTP error
         code. Required.
        :paramtype code: str
        :keyword message: Description of the error. Required.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class ErrorResponse(_serialization.Model):
    """Error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Error definition.
    :vartype error: ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.ErrorDefinition
    """

    _validation = {
        "error": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDefinition"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error = None


class HelmOperatorProperties(_serialization.Model):
    """Properties for Helm operator.

    :ivar chart_version: Version of the operator Helm chart.
    :vartype chart_version: str
    :ivar chart_values: Values override for the operator Helm chart.
    :vartype chart_values: str
    """

    _attribute_map = {
        "chart_version": {"key": "chartVersion", "type": "str"},
        "chart_values": {"key": "chartValues", "type": "str"},
    }

    def __init__(
        self, *, chart_version: Optional[str] = None, chart_values: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword chart_version: Version of the operator Helm chart.
        :paramtype chart_version: str
        :keyword chart_values: Values override for the operator Helm chart.
        :paramtype chart_values: str
        """
        super().__init__(**kwargs)
        self.chart_version = chart_version
        self.chart_values = chart_values


class Resource(_serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Top level metadata
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, *, system_data: Optional["_models.SystemData"] = None, **kwargs: Any) -> None:
        """
        :keyword system_data: Top level metadata
         https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
        :paramtype system_data:
         ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.SystemData
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = system_data


class ProxyResource(Resource):
    """ARM proxy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Top level metadata
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, *, system_data: Optional["_models.SystemData"] = None, **kwargs: Any) -> None:
        """
        :keyword system_data: Top level metadata
         https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
        :paramtype system_data:
         ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.SystemData
        """
        super().__init__(system_data=system_data, **kwargs)


class ResourceProviderOperation(_serialization.Model):
    """Supported operation of this resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name, in format of {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display:
     ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.ResourceProviderOperationDisplay
    :ivar is_data_action: The flag that indicates whether the operation applies to data plane.
    :vartype is_data_action: bool
    """

    _validation = {
        "is_data_action": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "ResourceProviderOperationDisplay"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.ResourceProviderOperationDisplay"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name, in format of {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display:
         ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.ResourceProviderOperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.is_data_action = None


class ResourceProviderOperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Resource provider: Microsoft KubernetesConfiguration.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Type of operation: get, read, delete, etc.
    :vartype operation: str
    :ivar description: Description of this operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Resource provider: Microsoft KubernetesConfiguration.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: Type of operation: get, read, delete, etc.
        :paramtype operation: str
        :keyword description: Description of this operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ResourceProviderOperationList(_serialization.Model):
    """Result of the request to list operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by this resource provider.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.ResourceProviderOperation]
    :ivar next_link: URL to the next set of results, if any.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceProviderOperation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ResourceProviderOperation"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of operations supported by this resource provider.
        :paramtype value:
         list[~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.ResourceProviderOperation]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class Result(_serialization.Model):
    """Sample result definition.

    :ivar sample_property: Sample property of type string.
    :vartype sample_property: str
    """

    _attribute_map = {
        "sample_property": {"key": "sampleProperty", "type": "str"},
    }

    def __init__(self, *, sample_property: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword sample_property: Sample property of type string.
        :paramtype sample_property: str
        """
        super().__init__(**kwargs)
        self.sample_property = sample_property


class SourceControlConfiguration(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """The SourceControl Configuration object returned in Get & Put response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Top level metadata
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.SystemData
    :ivar repository_url: Url of the SourceControl Repository.
    :vartype repository_url: str
    :ivar operator_namespace: The namespace to which this operator is installed to. Maximum of 253
     lower case alphanumeric characters, hyphen and period only.
    :vartype operator_namespace: str
    :ivar operator_instance_name: Instance name of the operator - identifying the specific
     configuration.
    :vartype operator_instance_name: str
    :ivar operator_type: Type of the operator. "Flux"
    :vartype operator_type: str or
     ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.OperatorType
    :ivar operator_params: Any Parameters for the Operator instance in string format.
    :vartype operator_params: str
    :ivar configuration_protected_settings: Name-value pairs of protected configuration settings
     for the configuration.
    :vartype configuration_protected_settings: dict[str, str]
    :ivar operator_scope: Scope at which the operator will be installed. Known values are:
     "cluster" and "namespace".
    :vartype operator_scope: str or
     ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.OperatorScopeType
    :ivar repository_public_key: Public Key associated with this SourceControl configuration
     (either generated within the cluster or provided by the user).
    :vartype repository_public_key: str
    :ivar ssh_known_hosts_contents: Base64-encoded known_hosts contents containing public SSH keys
     required to access private Git instances.
    :vartype ssh_known_hosts_contents: str
    :ivar enable_helm_operator: Option to enable Helm Operator for this git configuration.
    :vartype enable_helm_operator: bool
    :ivar helm_operator_properties: Properties for Helm operator.
    :vartype helm_operator_properties:
     ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.HelmOperatorProperties
    :ivar provisioning_state: The provisioning state of the resource provider. Known values are:
     "Accepted", "Deleting", "Running", "Succeeded", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.ProvisioningStateType
    :ivar compliance_status: Compliance Status of the Configuration.
    :vartype compliance_status:
     ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.ComplianceStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "repository_public_key": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "compliance_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "repository_url": {"key": "properties.repositoryUrl", "type": "str"},
        "operator_namespace": {"key": "properties.operatorNamespace", "type": "str"},
        "operator_instance_name": {"key": "properties.operatorInstanceName", "type": "str"},
        "operator_type": {"key": "properties.operatorType", "type": "str"},
        "operator_params": {"key": "properties.operatorParams", "type": "str"},
        "configuration_protected_settings": {"key": "properties.configurationProtectedSettings", "type": "{str}"},
        "operator_scope": {"key": "properties.operatorScope", "type": "str"},
        "repository_public_key": {"key": "properties.repositoryPublicKey", "type": "str"},
        "ssh_known_hosts_contents": {"key": "properties.sshKnownHostsContents", "type": "str"},
        "enable_helm_operator": {"key": "properties.enableHelmOperator", "type": "bool"},
        "helm_operator_properties": {"key": "properties.helmOperatorProperties", "type": "HelmOperatorProperties"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "compliance_status": {"key": "properties.complianceStatus", "type": "ComplianceStatus"},
    }

    def __init__(
        self,
        *,
        system_data: Optional["_models.SystemData"] = None,
        repository_url: Optional[str] = None,
        operator_namespace: str = "default",
        operator_instance_name: Optional[str] = None,
        operator_type: Optional[Union[str, "_models.OperatorType"]] = None,
        operator_params: Optional[str] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        operator_scope: Union[str, "_models.OperatorScopeType"] = "cluster",
        ssh_known_hosts_contents: Optional[str] = None,
        enable_helm_operator: Optional[bool] = None,
        helm_operator_properties: Optional["_models.HelmOperatorProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword system_data: Top level metadata
         https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
        :paramtype system_data:
         ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.SystemData
        :keyword repository_url: Url of the SourceControl Repository.
        :paramtype repository_url: str
        :keyword operator_namespace: The namespace to which this operator is installed to. Maximum of
         253 lower case alphanumeric characters, hyphen and period only.
        :paramtype operator_namespace: str
        :keyword operator_instance_name: Instance name of the operator - identifying the specific
         configuration.
        :paramtype operator_instance_name: str
        :keyword operator_type: Type of the operator. "Flux"
        :paramtype operator_type: str or
         ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.OperatorType
        :keyword operator_params: Any Parameters for the Operator instance in string format.
        :paramtype operator_params: str
        :keyword configuration_protected_settings: Name-value pairs of protected configuration settings
         for the configuration.
        :paramtype configuration_protected_settings: dict[str, str]
        :keyword operator_scope: Scope at which the operator will be installed. Known values are:
         "cluster" and "namespace".
        :paramtype operator_scope: str or
         ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.OperatorScopeType
        :keyword ssh_known_hosts_contents: Base64-encoded known_hosts contents containing public SSH
         keys required to access private Git instances.
        :paramtype ssh_known_hosts_contents: str
        :keyword enable_helm_operator: Option to enable Helm Operator for this git configuration.
        :paramtype enable_helm_operator: bool
        :keyword helm_operator_properties: Properties for Helm operator.
        :paramtype helm_operator_properties:
         ~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.HelmOperatorProperties
        """
        super().__init__(system_data=system_data, **kwargs)
        self.repository_url = repository_url
        self.operator_namespace = operator_namespace
        self.operator_instance_name = operator_instance_name
        self.operator_type = operator_type
        self.operator_params = operator_params
        self.configuration_protected_settings = configuration_protected_settings
        self.operator_scope = operator_scope
        self.repository_public_key = None
        self.ssh_known_hosts_contents = ssh_known_hosts_contents
        self.enable_helm_operator = enable_helm_operator
        self.helm_operator_properties = helm_operator_properties
        self.provisioning_state = None
        self.compliance_status = None


class SourceControlConfigurationList(_serialization.Model):
    """Result of the request to list Source Control Configurations.  It contains a list of
    SourceControlConfiguration objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Source Control Configurations within a Kubernetes cluster.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2020_10_01_preview.models.SourceControlConfiguration]
    :ivar next_link: URL to get the next set of configuration objects, if any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SourceControlConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SystemData(_serialization.Model):
    """Top level metadata
    https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_by: A string identifier for the identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource: user, application,
     managedIdentity, key.
    :vartype created_by_type: str
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: A string identifier for the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource: user,
     application, managedIdentity, key.
    :vartype last_modified_by_type: str
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _validation = {
        "created_by": {"readonly": True},
        "created_by_type": {"readonly": True},
        "created_at": {"readonly": True},
        "last_modified_by": {"readonly": True},
        "last_modified_by_type": {"readonly": True},
        "last_modified_at": {"readonly": True},
    }

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.created_by = None
        self.created_by_type = None
        self.created_at = None
        self.last_modified_by = None
        self.last_modified_by_type = None
        self.last_modified_at = None
