# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class TimeSeriesDatabaseConnectionProperties(_serialization.Model):
    """Properties of a time series database connection resource.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureDataExplorerConnectionProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar connection_type: The type of time series connection resource. Required.
     "AzureDataExplorer"
    :vartype connection_type: str or ~azure.mgmt.digitaltwins.models.ConnectionType
    :ivar provisioning_state: The provisioning state. Known values are: "Provisioning", "Deleting",
     "Updating", "Succeeded", "Failed", "Canceled", "Deleted", "Warning", "Suspending", "Restoring",
     "Moving", and "Disabled".
    :vartype provisioning_state: str or
     ~azure.mgmt.digitaltwins.models.TimeSeriesDatabaseConnectionState
    :ivar identity: Managed identity properties for the time series database connection resource.
    :vartype identity: ~azure.mgmt.digitaltwins.models.ManagedIdentityReference
    """

    _validation = {
        "connection_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "connection_type": {"key": "connectionType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedIdentityReference"},
    }

    _subtype_map = {"connection_type": {"AzureDataExplorer": "AzureDataExplorerConnectionProperties"}}

    def __init__(self, *, identity: Optional["_models.ManagedIdentityReference"] = None, **kwargs: Any) -> None:
        """
        :keyword identity: Managed identity properties for the time series database connection
         resource.
        :paramtype identity: ~azure.mgmt.digitaltwins.models.ManagedIdentityReference
        """
        super().__init__(**kwargs)
        self.connection_type: Optional[str] = None
        self.provisioning_state = None
        self.identity = identity


class AzureDataExplorerConnectionProperties(
    TimeSeriesDatabaseConnectionProperties
):  # pylint: disable=too-many-instance-attributes
    """Properties of a time series database connection to Azure Data Explorer with data being sent via
    an EventHub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar connection_type: The type of time series connection resource. Required.
     "AzureDataExplorer"
    :vartype connection_type: str or ~azure.mgmt.digitaltwins.models.ConnectionType
    :ivar provisioning_state: The provisioning state. Known values are: "Provisioning", "Deleting",
     "Updating", "Succeeded", "Failed", "Canceled", "Deleted", "Warning", "Suspending", "Restoring",
     "Moving", and "Disabled".
    :vartype provisioning_state: str or
     ~azure.mgmt.digitaltwins.models.TimeSeriesDatabaseConnectionState
    :ivar identity: Managed identity properties for the time series database connection resource.
    :vartype identity: ~azure.mgmt.digitaltwins.models.ManagedIdentityReference
    :ivar adx_resource_id: The resource ID of the Azure Data Explorer cluster. Required.
    :vartype adx_resource_id: str
    :ivar adx_endpoint_uri: The URI of the Azure Data Explorer endpoint. Required.
    :vartype adx_endpoint_uri: str
    :ivar adx_database_name: The name of the Azure Data Explorer database. Required.
    :vartype adx_database_name: str
    :ivar adx_table_name: The name of the Azure Data Explorer table used for storing updates to
     properties of twins and relationships. Defaults to AdtPropertyEvents.
    :vartype adx_table_name: str
    :ivar adx_twin_lifecycle_events_table_name: The name of the Azure Data Explorer table used for
     recording twin lifecycle events. The table will not be created if this property is left
     unspecified.
    :vartype adx_twin_lifecycle_events_table_name: str
    :ivar adx_relationship_lifecycle_events_table_name: The name of the Azure Data Explorer table
     used for recording relationship lifecycle events. The table will not be created if this
     property is left unspecified.
    :vartype adx_relationship_lifecycle_events_table_name: str
    :ivar event_hub_endpoint_uri: The URL of the EventHub namespace for identity-based
     authentication. It must include the protocol sb://. Required.
    :vartype event_hub_endpoint_uri: str
    :ivar event_hub_entity_path: The EventHub name in the EventHub namespace for identity-based
     authentication. Required.
    :vartype event_hub_entity_path: str
    :ivar event_hub_namespace_resource_id: The resource ID of the EventHub namespace. Required.
    :vartype event_hub_namespace_resource_id: str
    :ivar event_hub_consumer_group: The EventHub consumer group to use when ADX reads from
     EventHub. Defaults to $Default.
    :vartype event_hub_consumer_group: str
    :ivar record_property_and_item_removals: Specifies whether or not to record twin / relationship
     property and item removals, including removals of indexed or keyed values (such as map entries,
     array elements, etc.). This feature is de-activated unless explicitly set to 'true'. Setting
     this property to 'true' will generate an additional column in the property events table in ADX.
     Known values are: "true" and "false".
    :vartype record_property_and_item_removals: str or
     ~azure.mgmt.digitaltwins.models.RecordPropertyAndItemRemovals
    """

    _validation = {
        "connection_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "adx_resource_id": {"required": True},
        "adx_endpoint_uri": {"required": True},
        "adx_database_name": {"required": True},
        "event_hub_endpoint_uri": {"required": True},
        "event_hub_entity_path": {"required": True},
        "event_hub_namespace_resource_id": {"required": True},
    }

    _attribute_map = {
        "connection_type": {"key": "connectionType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedIdentityReference"},
        "adx_resource_id": {"key": "adxResourceId", "type": "str"},
        "adx_endpoint_uri": {"key": "adxEndpointUri", "type": "str"},
        "adx_database_name": {"key": "adxDatabaseName", "type": "str"},
        "adx_table_name": {"key": "adxTableName", "type": "str"},
        "adx_twin_lifecycle_events_table_name": {"key": "adxTwinLifecycleEventsTableName", "type": "str"},
        "adx_relationship_lifecycle_events_table_name": {
            "key": "adxRelationshipLifecycleEventsTableName",
            "type": "str",
        },
        "event_hub_endpoint_uri": {"key": "eventHubEndpointUri", "type": "str"},
        "event_hub_entity_path": {"key": "eventHubEntityPath", "type": "str"},
        "event_hub_namespace_resource_id": {"key": "eventHubNamespaceResourceId", "type": "str"},
        "event_hub_consumer_group": {"key": "eventHubConsumerGroup", "type": "str"},
        "record_property_and_item_removals": {"key": "recordPropertyAndItemRemovals", "type": "str"},
    }

    def __init__(
        self,
        *,
        adx_resource_id: str,
        adx_endpoint_uri: str,
        adx_database_name: str,
        event_hub_endpoint_uri: str,
        event_hub_entity_path: str,
        event_hub_namespace_resource_id: str,
        identity: Optional["_models.ManagedIdentityReference"] = None,
        adx_table_name: str = "AdtPropertyEvents",
        adx_twin_lifecycle_events_table_name: Optional[str] = None,
        adx_relationship_lifecycle_events_table_name: Optional[str] = None,
        event_hub_consumer_group: str = "$Default",
        record_property_and_item_removals: Union[str, "_models.RecordPropertyAndItemRemovals"] = "false",
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: Managed identity properties for the time series database connection
         resource.
        :paramtype identity: ~azure.mgmt.digitaltwins.models.ManagedIdentityReference
        :keyword adx_resource_id: The resource ID of the Azure Data Explorer cluster. Required.
        :paramtype adx_resource_id: str
        :keyword adx_endpoint_uri: The URI of the Azure Data Explorer endpoint. Required.
        :paramtype adx_endpoint_uri: str
        :keyword adx_database_name: The name of the Azure Data Explorer database. Required.
        :paramtype adx_database_name: str
        :keyword adx_table_name: The name of the Azure Data Explorer table used for storing updates to
         properties of twins and relationships. Defaults to AdtPropertyEvents.
        :paramtype adx_table_name: str
        :keyword adx_twin_lifecycle_events_table_name: The name of the Azure Data Explorer table used
         for recording twin lifecycle events. The table will not be created if this property is left
         unspecified.
        :paramtype adx_twin_lifecycle_events_table_name: str
        :keyword adx_relationship_lifecycle_events_table_name: The name of the Azure Data Explorer
         table used for recording relationship lifecycle events. The table will not be created if this
         property is left unspecified.
        :paramtype adx_relationship_lifecycle_events_table_name: str
        :keyword event_hub_endpoint_uri: The URL of the EventHub namespace for identity-based
         authentication. It must include the protocol sb://. Required.
        :paramtype event_hub_endpoint_uri: str
        :keyword event_hub_entity_path: The EventHub name in the EventHub namespace for identity-based
         authentication. Required.
        :paramtype event_hub_entity_path: str
        :keyword event_hub_namespace_resource_id: The resource ID of the EventHub namespace. Required.
        :paramtype event_hub_namespace_resource_id: str
        :keyword event_hub_consumer_group: The EventHub consumer group to use when ADX reads from
         EventHub. Defaults to $Default.
        :paramtype event_hub_consumer_group: str
        :keyword record_property_and_item_removals: Specifies whether or not to record twin /
         relationship property and item removals, including removals of indexed or keyed values (such as
         map entries, array elements, etc.). This feature is de-activated unless explicitly set to
         'true'. Setting this property to 'true' will generate an additional column in the property
         events table in ADX. Known values are: "true" and "false".
        :paramtype record_property_and_item_removals: str or
         ~azure.mgmt.digitaltwins.models.RecordPropertyAndItemRemovals
        """
        super().__init__(identity=identity, **kwargs)
        self.connection_type: str = "AzureDataExplorer"
        self.adx_resource_id = adx_resource_id
        self.adx_endpoint_uri = adx_endpoint_uri
        self.adx_database_name = adx_database_name
        self.adx_table_name = adx_table_name
        self.adx_twin_lifecycle_events_table_name = adx_twin_lifecycle_events_table_name
        self.adx_relationship_lifecycle_events_table_name = adx_relationship_lifecycle_events_table_name
        self.event_hub_endpoint_uri = event_hub_endpoint_uri
        self.event_hub_entity_path = event_hub_entity_path
        self.event_hub_namespace_resource_id = event_hub_namespace_resource_id
        self.event_hub_consumer_group = event_hub_consumer_group
        self.record_property_and_item_removals = record_property_and_item_removals


class CheckNameRequest(_serialization.Model):
    """The result returned from a database check name availability request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: Resource name. Required.
    :vartype name: str
    :ivar type: The type of resource, for instance Microsoft.DigitalTwins/digitalTwinsInstances.
     Required. Default value is "Microsoft.DigitalTwins/digitalTwinsInstances".
    :vartype type: str
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True, "constant": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    type = "Microsoft.DigitalTwins/digitalTwinsInstances"

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: Resource name. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class CheckNameResult(_serialization.Model):
    """The result returned from a check name availability request.

    :ivar name_available: Specifies a Boolean value that indicates if the name is available.
    :vartype name_available: bool
    :ivar message: Message indicating an unavailable name due to a conflict, or a description of
     the naming rules that are violated.
    :vartype message: str
    :ivar reason: Message providing the reason why the given name is invalid. Known values are:
     "Invalid" and "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.digitaltwins.models.Reason
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "message": {"key": "message", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        message: Optional[str] = None,
        reason: Optional[Union[str, "_models.Reason"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: Specifies a Boolean value that indicates if the name is available.
        :paramtype name_available: bool
        :keyword message: Message indicating an unavailable name due to a conflict, or a description of
         the naming rules that are violated.
        :paramtype message: str
        :keyword reason: Message providing the reason why the given name is invalid. Known values are:
         "Invalid" and "AlreadyExists".
        :paramtype reason: str or ~azure.mgmt.digitaltwins.models.Reason
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.message = message
        self.reason = reason


class ConnectionProperties(_serialization.Model):
    """The properties of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The provisioning state. Known values are: "Pending", "Approved",
     "Rejected", and "Disconnected".
    :vartype provisioning_state: str or
     ~azure.mgmt.digitaltwins.models.ConnectionPropertiesProvisioningState
    :ivar private_endpoint: The private endpoint.
    :vartype private_endpoint: ~azure.mgmt.digitaltwins.models.PrivateEndpoint
    :ivar group_ids: The list of group ids for the private endpoint connection.
    :vartype group_ids: list[str]
    :ivar private_link_service_connection_state: The connection state.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.digitaltwins.models.ConnectionPropertiesPrivateLinkServiceConnectionState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "private_endpoint": {"key": "privateEndpoint", "type": "PrivateEndpoint"},
        "group_ids": {"key": "groupIds", "type": "[str]"},
        "private_link_service_connection_state": {
            "key": "privateLinkServiceConnectionState",
            "type": "ConnectionPropertiesPrivateLinkServiceConnectionState",
        },
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        group_ids: Optional[List[str]] = None,
        private_link_service_connection_state: Optional[
            "_models.ConnectionPropertiesPrivateLinkServiceConnectionState"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The private endpoint.
        :paramtype private_endpoint: ~azure.mgmt.digitaltwins.models.PrivateEndpoint
        :keyword group_ids: The list of group ids for the private endpoint connection.
        :paramtype group_ids: list[str]
        :keyword private_link_service_connection_state: The connection state.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.digitaltwins.models.ConnectionPropertiesPrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.private_endpoint = private_endpoint
        self.group_ids = group_ids
        self.private_link_service_connection_state = private_link_service_connection_state


class ConnectionState(_serialization.Model):
    """The current state of a private endpoint connection.

    All required parameters must be populated in order to send to server.

    :ivar status: The status of a private endpoint connection. Required. Known values are:
     "Pending", "Approved", "Rejected", and "Disconnected".
    :vartype status: str or ~azure.mgmt.digitaltwins.models.PrivateLinkServiceConnectionStatus
    :ivar description: The description for the current state of a private endpoint connection.
     Required.
    :vartype description: str
    :ivar actions_required: Actions required for a private endpoint connection.
    :vartype actions_required: str
    """

    _validation = {
        "status": {"required": True},
        "description": {"required": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Union[str, "_models.PrivateLinkServiceConnectionStatus"],
        description: str,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The status of a private endpoint connection. Required. Known values are:
         "Pending", "Approved", "Rejected", and "Disconnected".
        :paramtype status: str or ~azure.mgmt.digitaltwins.models.PrivateLinkServiceConnectionStatus
        :keyword description: The description for the current state of a private endpoint connection.
         Required.
        :paramtype description: str
        :keyword actions_required: Actions required for a private endpoint connection.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class ConnectionPropertiesPrivateLinkServiceConnectionState(ConnectionState):  # pylint: disable=name-too-long
    """The connection state.

    All required parameters must be populated in order to send to server.

    :ivar status: The status of a private endpoint connection. Required. Known values are:
     "Pending", "Approved", "Rejected", and "Disconnected".
    :vartype status: str or ~azure.mgmt.digitaltwins.models.PrivateLinkServiceConnectionStatus
    :ivar description: The description for the current state of a private endpoint connection.
     Required.
    :vartype description: str
    :ivar actions_required: Actions required for a private endpoint connection.
    :vartype actions_required: str
    """


class DigitalTwinsResource(_serialization.Model):
    """The common properties of a DigitalTwinsInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar location: The resource location. Required.
    :vartype location: str
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The managed identity for the DigitalTwinsInstance.
    :vartype identity: ~azure.mgmt.digitaltwins.models.DigitalTwinsIdentity
    :ivar system_data: Metadata pertaining to creation and last modification of the
     DigitalTwinsInstance.
    :vartype system_data: ~azure.mgmt.digitaltwins.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?!-)[A-Za-z0-9-]{3,63}(?<!-)$"},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "DigitalTwinsIdentity"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.DigitalTwinsIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The resource location. Required.
        :paramtype location: str
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The managed identity for the DigitalTwinsInstance.
        :paramtype identity: ~azure.mgmt.digitaltwins.models.DigitalTwinsIdentity
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.identity = identity
        self.system_data = None


class DigitalTwinsDescription(DigitalTwinsResource):  # pylint: disable=too-many-instance-attributes
    """The description of the DigitalTwins service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar location: The resource location. Required.
    :vartype location: str
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The managed identity for the DigitalTwinsInstance.
    :vartype identity: ~azure.mgmt.digitaltwins.models.DigitalTwinsIdentity
    :ivar system_data: Metadata pertaining to creation and last modification of the
     DigitalTwinsInstance.
    :vartype system_data: ~azure.mgmt.digitaltwins.models.SystemData
    :ivar created_time: Time when DigitalTwinsInstance was created.
    :vartype created_time: ~datetime.datetime
    :ivar last_updated_time: Time when DigitalTwinsInstance was updated.
    :vartype last_updated_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state. Known values are: "Provisioning", "Deleting",
     "Updating", "Succeeded", "Failed", "Canceled", "Deleted", "Warning", "Suspending", "Restoring",
     and "Moving".
    :vartype provisioning_state: str or ~azure.mgmt.digitaltwins.models.ProvisioningState
    :ivar host_name: Api endpoint to work with DigitalTwinsInstance.
    :vartype host_name: str
    :ivar private_endpoint_connections: The private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.digitaltwins.models.PrivateEndpointConnection]
    :ivar public_network_access: Public network access for the DigitalTwinsInstance. Known values
     are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.digitaltwins.models.PublicNetworkAccess
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?!-)[A-Za-z0-9-]{3,63}(?<!-)$"},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "created_time": {"readonly": True},
        "last_updated_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "host_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "DigitalTwinsIdentity"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "created_time": {"key": "properties.createdTime", "type": "iso-8601"},
        "last_updated_time": {"key": "properties.lastUpdatedTime", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.DigitalTwinsIdentity"] = None,
        private_endpoint_connections: Optional[List["_models.PrivateEndpointConnection"]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The resource location. Required.
        :paramtype location: str
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The managed identity for the DigitalTwinsInstance.
        :paramtype identity: ~azure.mgmt.digitaltwins.models.DigitalTwinsIdentity
        :keyword private_endpoint_connections: The private endpoint connections.
        :paramtype private_endpoint_connections:
         list[~azure.mgmt.digitaltwins.models.PrivateEndpointConnection]
        :keyword public_network_access: Public network access for the DigitalTwinsInstance. Known
         values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.digitaltwins.models.PublicNetworkAccess
        """
        super().__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.created_time = None
        self.last_updated_time = None
        self.provisioning_state = None
        self.host_name = None
        self.private_endpoint_connections = private_endpoint_connections
        self.public_network_access = public_network_access


class DigitalTwinsDescriptionListResult(_serialization.Model):
    """A list of DigitalTwins description objects with a next link.

    :ivar next_link: The link used to get the next page of DigitalTwins description objects.
    :vartype next_link: str
    :ivar value: A list of DigitalTwins description objects.
    :vartype value: list[~azure.mgmt.digitaltwins.models.DigitalTwinsDescription]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[DigitalTwinsDescription]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.DigitalTwinsDescription"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of DigitalTwins description objects.
        :paramtype next_link: str
        :keyword value: A list of DigitalTwins description objects.
        :paramtype value: list[~azure.mgmt.digitaltwins.models.DigitalTwinsDescription]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ExternalResource(_serialization.Model):
    """Definition of a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: Extension resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.digitaltwins.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$"},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class DigitalTwinsEndpointResource(ExternalResource):
    """DigitalTwinsInstance endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: Extension resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.digitaltwins.models.SystemData
    :ivar properties: DigitalTwinsInstance endpoint resource properties. Required.
    :vartype properties: ~azure.mgmt.digitaltwins.models.DigitalTwinsEndpointResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$"},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DigitalTwinsEndpointResourceProperties"},
    }

    def __init__(self, *, properties: "_models.DigitalTwinsEndpointResourceProperties", **kwargs: Any) -> None:
        """
        :keyword properties: DigitalTwinsInstance endpoint resource properties. Required.
        :paramtype properties: ~azure.mgmt.digitaltwins.models.DigitalTwinsEndpointResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DigitalTwinsEndpointResourceListResult(_serialization.Model):
    """A list of DigitalTwinsInstance Endpoints with a next link.

    :ivar next_link: The link used to get the next page of DigitalTwinsInstance Endpoints.
    :vartype next_link: str
    :ivar value: A list of DigitalTwinsInstance Endpoints.
    :vartype value: list[~azure.mgmt.digitaltwins.models.DigitalTwinsEndpointResource]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[DigitalTwinsEndpointResource]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.DigitalTwinsEndpointResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of DigitalTwinsInstance Endpoints.
        :paramtype next_link: str
        :keyword value: A list of DigitalTwinsInstance Endpoints.
        :paramtype value: list[~azure.mgmt.digitaltwins.models.DigitalTwinsEndpointResource]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DigitalTwinsEndpointResourceProperties(_serialization.Model):
    """Properties related to Digital Twins Endpoint.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    EventGrid, EventHub, ServiceBus

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar endpoint_type: The type of Digital Twins endpoint. Required. Known values are:
     "EventHub", "EventGrid", and "ServiceBus".
    :vartype endpoint_type: str or ~azure.mgmt.digitaltwins.models.EndpointType
    :ivar provisioning_state: The provisioning state. Known values are: "Provisioning", "Deleting",
     "Updating", "Succeeded", "Failed", "Canceled", "Deleted", "Warning", "Suspending", "Restoring",
     "Moving", and "Disabled".
    :vartype provisioning_state: str or ~azure.mgmt.digitaltwins.models.EndpointProvisioningState
    :ivar created_time: Time when the Endpoint was added to DigitalTwinsInstance.
    :vartype created_time: ~datetime.datetime
    :ivar authentication_type: Specifies the authentication type being used for connecting to the
     endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be
     specified (at least the primary connection string). If 'IdentityBased' is select, the
     endpointUri and entityPath properties must be specified. Known values are: "KeyBased" and
     "IdentityBased".
    :vartype authentication_type: str or ~azure.mgmt.digitaltwins.models.AuthenticationType
    :ivar dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
     obfuscated during read.
    :vartype dead_letter_secret: str
    :ivar dead_letter_uri: Dead letter storage URL for identity-based authentication.
    :vartype dead_letter_uri: str
    :ivar identity: Managed identity properties for the endpoint.
    :vartype identity: ~azure.mgmt.digitaltwins.models.ManagedIdentityReference
    """

    _validation = {
        "endpoint_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_time": {"readonly": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "dead_letter_secret": {"key": "deadLetterSecret", "type": "str"},
        "dead_letter_uri": {"key": "deadLetterUri", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedIdentityReference"},
    }

    _subtype_map = {"endpoint_type": {"EventGrid": "EventGrid", "EventHub": "EventHub", "ServiceBus": "ServiceBus"}}

    def __init__(
        self,
        *,
        authentication_type: Optional[Union[str, "_models.AuthenticationType"]] = None,
        dead_letter_secret: Optional[str] = None,
        dead_letter_uri: Optional[str] = None,
        identity: Optional["_models.ManagedIdentityReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword authentication_type: Specifies the authentication type being used for connecting to
         the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be
         specified (at least the primary connection string). If 'IdentityBased' is select, the
         endpointUri and entityPath properties must be specified. Known values are: "KeyBased" and
         "IdentityBased".
        :paramtype authentication_type: str or ~azure.mgmt.digitaltwins.models.AuthenticationType
        :keyword dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
         obfuscated during read.
        :paramtype dead_letter_secret: str
        :keyword dead_letter_uri: Dead letter storage URL for identity-based authentication.
        :paramtype dead_letter_uri: str
        :keyword identity: Managed identity properties for the endpoint.
        :paramtype identity: ~azure.mgmt.digitaltwins.models.ManagedIdentityReference
        """
        super().__init__(**kwargs)
        self.endpoint_type: Optional[str] = None
        self.provisioning_state = None
        self.created_time = None
        self.authentication_type = authentication_type
        self.dead_letter_secret = dead_letter_secret
        self.dead_letter_uri = dead_letter_uri
        self.identity = identity


class DigitalTwinsIdentity(_serialization.Model):
    """The managed identity for the DigitalTwinsInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of Managed Identity used by the DigitalTwinsInstance. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.digitaltwins.models.DigitalTwinsIdentityType
    :ivar principal_id: The object id of the Managed Identity Resource. This will be sent to the RP
     from ARM via the x-ms-identity-principal-id header in the PUT request if the resource has a
     systemAssigned(implicit) identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the Managed Identity Resource. This will be sent to the RP
     from ARM via the x-ms-client-tenant-id header in the PUT request if the resource has a
     systemAssigned(implicit) identity.
    :vartype tenant_id: str
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity dictionary key references will be ARM resource ids in the form:
    '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.  # pylint: disable=line-too-long
     .
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.digitaltwins.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.DigitalTwinsIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of Managed Identity used by the DigitalTwinsInstance. Known values are:
         "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.digitaltwins.models.DigitalTwinsIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the resource.
         The user identity dictionary key references will be ARM resource ids in the form:
        '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.  # pylint: disable=line-too-long
         .
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.digitaltwins.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.type = type
        self.principal_id = None
        self.tenant_id = None
        self.user_assigned_identities = user_assigned_identities


class DigitalTwinsPatchDescription(_serialization.Model):
    """The description of the DigitalTwins service.

    :ivar tags: Instance patch properties.
    :vartype tags: dict[str, str]
    :ivar identity: The managed identity for the DigitalTwinsInstance.
    :vartype identity: ~azure.mgmt.digitaltwins.models.DigitalTwinsIdentity
    :ivar properties: Properties for the DigitalTwinsInstance.
    :vartype properties: ~azure.mgmt.digitaltwins.models.DigitalTwinsPatchProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "DigitalTwinsIdentity"},
        "properties": {"key": "properties", "type": "DigitalTwinsPatchProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.DigitalTwinsIdentity"] = None,
        properties: Optional["_models.DigitalTwinsPatchProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Instance patch properties.
        :paramtype tags: dict[str, str]
        :keyword identity: The managed identity for the DigitalTwinsInstance.
        :paramtype identity: ~azure.mgmt.digitaltwins.models.DigitalTwinsIdentity
        :keyword properties: Properties for the DigitalTwinsInstance.
        :paramtype properties: ~azure.mgmt.digitaltwins.models.DigitalTwinsPatchProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.properties = properties


class DigitalTwinsPatchProperties(_serialization.Model):
    """The properties of a DigitalTwinsInstance.

    :ivar public_network_access: Public network access for the DigitalTwinsInstance. Known values
     are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.digitaltwins.models.PublicNetworkAccess
    """

    _attribute_map = {
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
    }

    def __init__(
        self, *, public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword public_network_access: Public network access for the DigitalTwinsInstance. Known
         values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.digitaltwins.models.PublicNetworkAccess
        """
        super().__init__(**kwargs)
        self.public_network_access = public_network_access


class ErrorDefinition(_serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar details: Internal error details.
    :vartype details: list[~azure.mgmt.digitaltwins.models.ErrorDefinition]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDefinition]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = None


class ErrorResponse(_serialization.Model):
    """Error response.

    :ivar error: Error description.
    :vartype error: ~azure.mgmt.digitaltwins.models.ErrorDefinition
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDefinition"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDefinition"] = None, **kwargs: Any) -> None:
        """
        :keyword error: Error description.
        :paramtype error: ~azure.mgmt.digitaltwins.models.ErrorDefinition
        """
        super().__init__(**kwargs)
        self.error = error


class EventGrid(DigitalTwinsEndpointResourceProperties):
    """Properties related to EventGrid.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar endpoint_type: The type of Digital Twins endpoint. Required. Known values are:
     "EventHub", "EventGrid", and "ServiceBus".
    :vartype endpoint_type: str or ~azure.mgmt.digitaltwins.models.EndpointType
    :ivar provisioning_state: The provisioning state. Known values are: "Provisioning", "Deleting",
     "Updating", "Succeeded", "Failed", "Canceled", "Deleted", "Warning", "Suspending", "Restoring",
     "Moving", and "Disabled".
    :vartype provisioning_state: str or ~azure.mgmt.digitaltwins.models.EndpointProvisioningState
    :ivar created_time: Time when the Endpoint was added to DigitalTwinsInstance.
    :vartype created_time: ~datetime.datetime
    :ivar authentication_type: Specifies the authentication type being used for connecting to the
     endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be
     specified (at least the primary connection string). If 'IdentityBased' is select, the
     endpointUri and entityPath properties must be specified. Known values are: "KeyBased" and
     "IdentityBased".
    :vartype authentication_type: str or ~azure.mgmt.digitaltwins.models.AuthenticationType
    :ivar dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
     obfuscated during read.
    :vartype dead_letter_secret: str
    :ivar dead_letter_uri: Dead letter storage URL for identity-based authentication.
    :vartype dead_letter_uri: str
    :ivar identity: Managed identity properties for the endpoint.
    :vartype identity: ~azure.mgmt.digitaltwins.models.ManagedIdentityReference
    :ivar topic_endpoint: EventGrid Topic Endpoint. Required.
    :vartype topic_endpoint: str
    :ivar access_key1: EventGrid secondary accesskey. Will be obfuscated during read. Required.
    :vartype access_key1: str
    :ivar access_key2: EventGrid secondary accesskey. Will be obfuscated during read.
    :vartype access_key2: str
    """

    _validation = {
        "endpoint_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_time": {"readonly": True},
        "topic_endpoint": {"required": True},
        "access_key1": {"required": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "dead_letter_secret": {"key": "deadLetterSecret", "type": "str"},
        "dead_letter_uri": {"key": "deadLetterUri", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedIdentityReference"},
        "topic_endpoint": {"key": "TopicEndpoint", "type": "str"},
        "access_key1": {"key": "accessKey1", "type": "str"},
        "access_key2": {"key": "accessKey2", "type": "str"},
    }

    def __init__(
        self,
        *,
        topic_endpoint: str,
        access_key1: str,
        authentication_type: Optional[Union[str, "_models.AuthenticationType"]] = None,
        dead_letter_secret: Optional[str] = None,
        dead_letter_uri: Optional[str] = None,
        identity: Optional["_models.ManagedIdentityReference"] = None,
        access_key2: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword authentication_type: Specifies the authentication type being used for connecting to
         the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be
         specified (at least the primary connection string). If 'IdentityBased' is select, the
         endpointUri and entityPath properties must be specified. Known values are: "KeyBased" and
         "IdentityBased".
        :paramtype authentication_type: str or ~azure.mgmt.digitaltwins.models.AuthenticationType
        :keyword dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
         obfuscated during read.
        :paramtype dead_letter_secret: str
        :keyword dead_letter_uri: Dead letter storage URL for identity-based authentication.
        :paramtype dead_letter_uri: str
        :keyword identity: Managed identity properties for the endpoint.
        :paramtype identity: ~azure.mgmt.digitaltwins.models.ManagedIdentityReference
        :keyword topic_endpoint: EventGrid Topic Endpoint. Required.
        :paramtype topic_endpoint: str
        :keyword access_key1: EventGrid secondary accesskey. Will be obfuscated during read. Required.
        :paramtype access_key1: str
        :keyword access_key2: EventGrid secondary accesskey. Will be obfuscated during read.
        :paramtype access_key2: str
        """
        super().__init__(
            authentication_type=authentication_type,
            dead_letter_secret=dead_letter_secret,
            dead_letter_uri=dead_letter_uri,
            identity=identity,
            **kwargs
        )
        self.endpoint_type: str = "EventGrid"
        self.topic_endpoint = topic_endpoint
        self.access_key1 = access_key1
        self.access_key2 = access_key2


class EventHub(DigitalTwinsEndpointResourceProperties):  # pylint: disable=too-many-instance-attributes
    """Properties related to EventHub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar endpoint_type: The type of Digital Twins endpoint. Required. Known values are:
     "EventHub", "EventGrid", and "ServiceBus".
    :vartype endpoint_type: str or ~azure.mgmt.digitaltwins.models.EndpointType
    :ivar provisioning_state: The provisioning state. Known values are: "Provisioning", "Deleting",
     "Updating", "Succeeded", "Failed", "Canceled", "Deleted", "Warning", "Suspending", "Restoring",
     "Moving", and "Disabled".
    :vartype provisioning_state: str or ~azure.mgmt.digitaltwins.models.EndpointProvisioningState
    :ivar created_time: Time when the Endpoint was added to DigitalTwinsInstance.
    :vartype created_time: ~datetime.datetime
    :ivar authentication_type: Specifies the authentication type being used for connecting to the
     endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be
     specified (at least the primary connection string). If 'IdentityBased' is select, the
     endpointUri and entityPath properties must be specified. Known values are: "KeyBased" and
     "IdentityBased".
    :vartype authentication_type: str or ~azure.mgmt.digitaltwins.models.AuthenticationType
    :ivar dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
     obfuscated during read.
    :vartype dead_letter_secret: str
    :ivar dead_letter_uri: Dead letter storage URL for identity-based authentication.
    :vartype dead_letter_uri: str
    :ivar identity: Managed identity properties for the endpoint.
    :vartype identity: ~azure.mgmt.digitaltwins.models.ManagedIdentityReference
    :ivar connection_string_primary_key: PrimaryConnectionString of the endpoint for key-based
     authentication. Will be obfuscated during read.
    :vartype connection_string_primary_key: str
    :ivar connection_string_secondary_key: SecondaryConnectionString of the endpoint for key-based
     authentication. Will be obfuscated during read.
    :vartype connection_string_secondary_key: str
    :ivar endpoint_uri: The URL of the EventHub namespace for identity-based authentication. It
     must include the protocol 'sb://'.
    :vartype endpoint_uri: str
    :ivar entity_path: The EventHub name in the EventHub namespace for identity-based
     authentication.
    :vartype entity_path: str
    """

    _validation = {
        "endpoint_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_time": {"readonly": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "dead_letter_secret": {"key": "deadLetterSecret", "type": "str"},
        "dead_letter_uri": {"key": "deadLetterUri", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedIdentityReference"},
        "connection_string_primary_key": {"key": "connectionStringPrimaryKey", "type": "str"},
        "connection_string_secondary_key": {"key": "connectionStringSecondaryKey", "type": "str"},
        "endpoint_uri": {"key": "endpointUri", "type": "str"},
        "entity_path": {"key": "entityPath", "type": "str"},
    }

    def __init__(
        self,
        *,
        authentication_type: Optional[Union[str, "_models.AuthenticationType"]] = None,
        dead_letter_secret: Optional[str] = None,
        dead_letter_uri: Optional[str] = None,
        identity: Optional["_models.ManagedIdentityReference"] = None,
        connection_string_primary_key: Optional[str] = None,
        connection_string_secondary_key: Optional[str] = None,
        endpoint_uri: Optional[str] = None,
        entity_path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword authentication_type: Specifies the authentication type being used for connecting to
         the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be
         specified (at least the primary connection string). If 'IdentityBased' is select, the
         endpointUri and entityPath properties must be specified. Known values are: "KeyBased" and
         "IdentityBased".
        :paramtype authentication_type: str or ~azure.mgmt.digitaltwins.models.AuthenticationType
        :keyword dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
         obfuscated during read.
        :paramtype dead_letter_secret: str
        :keyword dead_letter_uri: Dead letter storage URL for identity-based authentication.
        :paramtype dead_letter_uri: str
        :keyword identity: Managed identity properties for the endpoint.
        :paramtype identity: ~azure.mgmt.digitaltwins.models.ManagedIdentityReference
        :keyword connection_string_primary_key: PrimaryConnectionString of the endpoint for key-based
         authentication. Will be obfuscated during read.
        :paramtype connection_string_primary_key: str
        :keyword connection_string_secondary_key: SecondaryConnectionString of the endpoint for
         key-based authentication. Will be obfuscated during read.
        :paramtype connection_string_secondary_key: str
        :keyword endpoint_uri: The URL of the EventHub namespace for identity-based authentication. It
         must include the protocol 'sb://'.
        :paramtype endpoint_uri: str
        :keyword entity_path: The EventHub name in the EventHub namespace for identity-based
         authentication.
        :paramtype entity_path: str
        """
        super().__init__(
            authentication_type=authentication_type,
            dead_letter_secret=dead_letter_secret,
            dead_letter_uri=dead_letter_uri,
            identity=identity,
            **kwargs
        )
        self.endpoint_type: str = "EventHub"
        self.connection_string_primary_key = connection_string_primary_key
        self.connection_string_secondary_key = connection_string_secondary_key
        self.endpoint_uri = endpoint_uri
        self.entity_path = entity_path


class GroupIdInformation(_serialization.Model):
    """The group information for creating a private endpoint on Digital Twin.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar properties: The group information properties. Required.
    :vartype properties: ~azure.mgmt.digitaltwins.models.GroupIdInformationProperties
    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        "properties": {"required": True},
        "name": {"readonly": True, "pattern": r"^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$"},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "GroupIdInformationProperties"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        properties: "_models.GroupIdInformationProperties",
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: The group information properties. Required.
        :paramtype properties: ~azure.mgmt.digitaltwins.models.GroupIdInformationProperties
        :keyword id: The resource identifier.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.id = id
        self.name = None
        self.type = None


class GroupIdInformationProperties(_serialization.Model):
    """The properties for a group information object.

    :ivar group_id: The group id.
    :vartype group_id: str
    :ivar required_members: The required members for a specific group id.
    :vartype required_members: list[str]
    :ivar required_zone_names: The required DNS zones for a specific group id.
    :vartype required_zone_names: list[str]
    """

    _attribute_map = {
        "group_id": {"key": "groupId", "type": "str"},
        "required_members": {"key": "requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "requiredZoneNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        group_id: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword group_id: The group id.
        :paramtype group_id: str
        :keyword required_members: The required members for a specific group id.
        :paramtype required_members: list[str]
        :keyword required_zone_names: The required DNS zones for a specific group id.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id = group_id
        self.required_members = required_members
        self.required_zone_names = required_zone_names


class GroupIdInformationResponse(_serialization.Model):
    """The available private link resources for a Digital Twin.

    :ivar value: The list of available private link resources for a Digital Twin.
    :vartype value: list[~azure.mgmt.digitaltwins.models.GroupIdInformation]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GroupIdInformation]"},
    }

    def __init__(self, *, value: Optional[List["_models.GroupIdInformation"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of available private link resources for a Digital Twin.
        :paramtype value: list[~azure.mgmt.digitaltwins.models.GroupIdInformation]
        """
        super().__init__(**kwargs)
        self.value = value


class ManagedIdentityReference(_serialization.Model):
    """The properties of the Managed Identity.

    :ivar type: The type of managed identity used. Known values are: "SystemAssigned" and
     "UserAssigned".
    :vartype type: str or ~azure.mgmt.digitaltwins.models.IdentityType
    :ivar user_assigned_identity: The user identity ARM resource id if the managed identity type is
     'UserAssigned'.
    :vartype user_assigned_identity: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_assigned_identity": {"key": "userAssignedIdentity", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.IdentityType"]] = None,
        user_assigned_identity: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of managed identity used. Known values are: "SystemAssigned" and
         "UserAssigned".
        :paramtype type: str or ~azure.mgmt.digitaltwins.models.IdentityType
        :keyword user_assigned_identity: The user identity ARM resource id if the managed identity type
         is 'UserAssigned'.
        :paramtype user_assigned_identity: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.user_assigned_identity = user_assigned_identity


class Operation(_serialization.Model):
    """DigitalTwins service REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{read | write | action | delete}.
    :vartype name: str
    :ivar display: Operation properties display.
    :vartype display: ~azure.mgmt.digitaltwins.models.OperationDisplay
    :ivar origin: The intended executor of the operation.
    :vartype origin: str
    :ivar is_data_action: If the operation is a data action (for data plane rbac).
    :vartype is_data_action: bool
    :ivar properties: Operation properties.
    :vartype properties: dict[str, JSON]
    """

    _validation = {
        "name": {"readonly": True},
        "origin": {"readonly": True},
        "is_data_action": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "properties": {"key": "properties", "type": "{object}"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Operation properties display.
        :paramtype display: ~azure.mgmt.digitaltwins.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.display = display
        self.origin = None
        self.is_data_action = None
        self.properties = None


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft DigitalTwins.
    :vartype provider: str
    :ivar resource: Resource Type: DigitalTwinsInstances.
    :vartype resource: str
    :ivar operation: Name of the operation.
    :vartype operation: str
    :ivar description: Friendly description for the operation.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of DigitalTwins service operations. It contains a list of operations and a URL link to
    get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link: The link used to get the next page of DigitalTwins description objects.
    :vartype next_link: str
    :ivar value: A list of DigitalTwins operations supported by the Microsoft.DigitalTwins resource
     provider.
    :vartype value: list[~azure.mgmt.digitaltwins.models.Operation]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The link used to get the next page of DigitalTwins description objects.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = None


class PrivateEndpoint(_serialization.Model):
    """The private endpoint property of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(_serialization.Model):
    """The private endpoint connection of a Digital Twin.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar properties: The connection properties. Required.
    :vartype properties: ~azure.mgmt.digitaltwins.models.ConnectionProperties
    :ivar system_data: Metadata pertaining to creation and last modification of the private
     endpoint connection.
    :vartype system_data: ~azure.mgmt.digitaltwins.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$"},
        "type": {"readonly": True},
        "properties": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "ConnectionProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, *, properties: "_models.ConnectionProperties", **kwargs: Any) -> None:
        """
        :keyword properties: The connection properties. Required.
        :paramtype properties: ~azure.mgmt.digitaltwins.models.ConnectionProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties
        self.system_data = None


class PrivateEndpointConnectionsResponse(_serialization.Model):
    """The available private link connections for a Digital Twin.

    :ivar value: The list of available private link connections for a Digital Twin.
    :vartype value: list[~azure.mgmt.digitaltwins.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of available private link connections for a Digital Twin.
        :paramtype value: list[~azure.mgmt.digitaltwins.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value


class ServiceBus(DigitalTwinsEndpointResourceProperties):  # pylint: disable=too-many-instance-attributes
    """Properties related to ServiceBus.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar endpoint_type: The type of Digital Twins endpoint. Required. Known values are:
     "EventHub", "EventGrid", and "ServiceBus".
    :vartype endpoint_type: str or ~azure.mgmt.digitaltwins.models.EndpointType
    :ivar provisioning_state: The provisioning state. Known values are: "Provisioning", "Deleting",
     "Updating", "Succeeded", "Failed", "Canceled", "Deleted", "Warning", "Suspending", "Restoring",
     "Moving", and "Disabled".
    :vartype provisioning_state: str or ~azure.mgmt.digitaltwins.models.EndpointProvisioningState
    :ivar created_time: Time when the Endpoint was added to DigitalTwinsInstance.
    :vartype created_time: ~datetime.datetime
    :ivar authentication_type: Specifies the authentication type being used for connecting to the
     endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be
     specified (at least the primary connection string). If 'IdentityBased' is select, the
     endpointUri and entityPath properties must be specified. Known values are: "KeyBased" and
     "IdentityBased".
    :vartype authentication_type: str or ~azure.mgmt.digitaltwins.models.AuthenticationType
    :ivar dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
     obfuscated during read.
    :vartype dead_letter_secret: str
    :ivar dead_letter_uri: Dead letter storage URL for identity-based authentication.
    :vartype dead_letter_uri: str
    :ivar identity: Managed identity properties for the endpoint.
    :vartype identity: ~azure.mgmt.digitaltwins.models.ManagedIdentityReference
    :ivar primary_connection_string: PrimaryConnectionString of the endpoint for key-based
     authentication. Will be obfuscated during read.
    :vartype primary_connection_string: str
    :ivar secondary_connection_string: SecondaryConnectionString of the endpoint for key-based
     authentication. Will be obfuscated during read.
    :vartype secondary_connection_string: str
    :ivar endpoint_uri: The URL of the ServiceBus namespace for identity-based authentication. It
     must include the protocol 'sb://'.
    :vartype endpoint_uri: str
    :ivar entity_path: The ServiceBus Topic name for identity-based authentication.
    :vartype entity_path: str
    """

    _validation = {
        "endpoint_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_time": {"readonly": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "dead_letter_secret": {"key": "deadLetterSecret", "type": "str"},
        "dead_letter_uri": {"key": "deadLetterUri", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedIdentityReference"},
        "primary_connection_string": {"key": "primaryConnectionString", "type": "str"},
        "secondary_connection_string": {"key": "secondaryConnectionString", "type": "str"},
        "endpoint_uri": {"key": "endpointUri", "type": "str"},
        "entity_path": {"key": "entityPath", "type": "str"},
    }

    def __init__(
        self,
        *,
        authentication_type: Optional[Union[str, "_models.AuthenticationType"]] = None,
        dead_letter_secret: Optional[str] = None,
        dead_letter_uri: Optional[str] = None,
        identity: Optional["_models.ManagedIdentityReference"] = None,
        primary_connection_string: Optional[str] = None,
        secondary_connection_string: Optional[str] = None,
        endpoint_uri: Optional[str] = None,
        entity_path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword authentication_type: Specifies the authentication type being used for connecting to
         the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be
         specified (at least the primary connection string). If 'IdentityBased' is select, the
         endpointUri and entityPath properties must be specified. Known values are: "KeyBased" and
         "IdentityBased".
        :paramtype authentication_type: str or ~azure.mgmt.digitaltwins.models.AuthenticationType
        :keyword dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
         obfuscated during read.
        :paramtype dead_letter_secret: str
        :keyword dead_letter_uri: Dead letter storage URL for identity-based authentication.
        :paramtype dead_letter_uri: str
        :keyword identity: Managed identity properties for the endpoint.
        :paramtype identity: ~azure.mgmt.digitaltwins.models.ManagedIdentityReference
        :keyword primary_connection_string: PrimaryConnectionString of the endpoint for key-based
         authentication. Will be obfuscated during read.
        :paramtype primary_connection_string: str
        :keyword secondary_connection_string: SecondaryConnectionString of the endpoint for key-based
         authentication. Will be obfuscated during read.
        :paramtype secondary_connection_string: str
        :keyword endpoint_uri: The URL of the ServiceBus namespace for identity-based authentication.
         It must include the protocol 'sb://'.
        :paramtype endpoint_uri: str
        :keyword entity_path: The ServiceBus Topic name for identity-based authentication.
        :paramtype entity_path: str
        """
        super().__init__(
            authentication_type=authentication_type,
            dead_letter_secret=dead_letter_secret,
            dead_letter_uri=dead_letter_uri,
            identity=identity,
            **kwargs
        )
        self.endpoint_type: str = "ServiceBus"
        self.primary_connection_string = primary_connection_string
        self.secondary_connection_string = secondary_connection_string
        self.endpoint_uri = endpoint_uri
        self.entity_path = entity_path


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.digitaltwins.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.digitaltwins.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.digitaltwins.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.digitaltwins.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TimeSeriesDatabaseConnection(ExternalResource):
    """Describes a time series database connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: Extension resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.digitaltwins.models.SystemData
    :ivar properties: Properties of a specific time series database connection.
    :vartype properties: ~azure.mgmt.digitaltwins.models.TimeSeriesDatabaseConnectionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$"},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "TimeSeriesDatabaseConnectionProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.TimeSeriesDatabaseConnectionProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Properties of a specific time series database connection.
        :paramtype properties: ~azure.mgmt.digitaltwins.models.TimeSeriesDatabaseConnectionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class TimeSeriesDatabaseConnectionListResult(_serialization.Model):
    """A pageable list of time series database connection resources.

    :ivar next_link: The link used to get the next page of results.
    :vartype next_link: str
    :ivar value: A list of time series database connection resources.
    :vartype value: list[~azure.mgmt.digitaltwins.models.TimeSeriesDatabaseConnection]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[TimeSeriesDatabaseConnection]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.TimeSeriesDatabaseConnection"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of results.
        :paramtype next_link: str
        :keyword value: A list of time series database connection resources.
        :paramtype value: list[~azure.mgmt.digitaltwins.models.TimeSeriesDatabaseConnection]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class UserAssignedIdentity(_serialization.Model):
    """The information about the user assigned identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar client_id: The client id of the User Assigned Identity Resource.
    :vartype client_id: str
    :ivar principal_id: The object id of the User Assigned Identity Resource.
    :vartype principal_id: str
    """

    _validation = {
        "client_id": {"readonly": True},
        "principal_id": {"readonly": True},
    }

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.client_id = None
        self.principal_id = None
