#ifndef __MACH_MX50_H__
#define __MACH_MX50_H__

/*
 * IROM
 */
#define MX50_IROM_BASE_ADDR		0x0
#define MX50_IROM_SIZE			SZ_64K

/* TZIC */
#define MX50_TZIC_BASE_ADDR		0x0fffc000
#define MX50_TZIC_SIZE			SZ_16K

/*
 * IRAM
 */
#define MX50_IRAM_BASE_ADDR	0xf8000000	/* internal ram */
#define MX50_IRAM_PARTITIONS	16
#define MX50_IRAM_SIZE		(MX50_IRAM_PARTITIONS * SZ_8K)	/* 128KB */

/*
 * Databahn
 */
#define MX50_DATABAHN_BASE_ADDR			0x14000000

/*
 * Graphics Memory of GPU
 */
#define MX50_GPU2D_BASE_ADDR		0x20000000

#define MX50_DEBUG_BASE_ADDR		0x40000000
#define MX50_DEBUG_SIZE			SZ_1M
#define MX50_ETB_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x00001000)
#define MX50_ETM_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x00002000)
#define MX50_TPIU_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x00003000)
#define MX50_CTI0_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x00004000)
#define MX50_CTI1_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x00005000)
#define MX50_CTI2_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x00006000)
#define MX50_CTI3_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x00007000)
#define MX50_CORTEX_DBG_BASE_ADDR	(MX50_DEBUG_BASE_ADDR + 0x00008000)

#define MX50_APBHDMA_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x01000000)
#define MX50_OCOTP_CTRL_BASE_ADDR	(MX50_DEBUG_BASE_ADDR + 0x01002000)
#define MX50_DIGCTL_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x01004000)
#define MX50_GPMI_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x01006000)
#define MX50_BCH_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x01008000)
#define MX50_ELCDIF_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x0100a000)
#define MX50_EPXP_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x0100c000)
#define MX50_DCP_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x0100e000)
#define MX50_EPDC_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x01010000)
#define MX50_QOSC_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x01012000)
#define MX50_PERFMON_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x01014000)
#define MX50_SSP_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x01016000)
#define MX50_ANATOP_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x01018000)
#define MX50_NIC_BASE_ADDR		(MX50_DEBUG_BASE_ADDR + 0x08000000)

/*
 * SPBA global module enabled #0
 */
#define MX50_SPBA0_BASE_ADDR		0x50000000
#define MX50_SPBA0_SIZE			SZ_1M

#define MX50_MMC_SDHC1_BASE_ADDR	(MX50_SPBA0_BASE_ADDR + 0x00004000)
#define MX50_MMC_SDHC2_BASE_ADDR	(MX50_SPBA0_BASE_ADDR + 0x00008000)
#define MX50_UART3_BASE_ADDR		(MX50_SPBA0_BASE_ADDR + 0x0000c000)
#define MX50_CSPI1_BASE_ADDR		(MX50_SPBA0_BASE_ADDR + 0x00010000)
#define MX50_SSI2_BASE_ADDR		(MX50_SPBA0_BASE_ADDR + 0x00014000)
#define MX50_MMC_SDHC3_BASE_ADDR	(MX50_SPBA0_BASE_ADDR + 0x00020000)
#define MX50_MMC_SDHC4_BASE_ADDR	(MX50_SPBA0_BASE_ADDR + 0x00024000)

/*
 * AIPS 1
 */
#define MX50_AIPS1_BASE_ADDR	0x53f00000
#define MX50_AIPS1_SIZE		SZ_1M

#define MX50_OTG_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x00080000)
#define MX50_GPIO1_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x00084000)
#define MX50_GPIO2_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x00088000)
#define MX50_GPIO3_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x0008c000)
#define MX50_GPIO4_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x00090000)
#define MX50_KPP_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x00094000)
#define MX50_WDOG_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x00098000)
#define MX50_GPT1_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000a0000)
#define MX50_SRTC_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000a4000)
#define MX50_IOMUXC_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000a8000)
#define MX50_EPIT1_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000ac000)
#define MX50_PWM1_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000b4000)
#define MX50_PWM2_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000b8000)
#define MX50_UART1_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000bc000)
#define MX50_UART2_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000c0000)
#define MX50_SRC_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000d0000)
#define MX50_CCM_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000d4000)
#define MX50_GPC_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000d8000)
#define MX50_GPIO5_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000dc000)
#define MX50_GPIO6_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000e0000)
#define MX50_I2C3_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000ec000)
#define MX50_UART4_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000f0000)

#define MX50_MSHC_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000f4000)
#define MX50_RNGB_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000f8000)

/*
 * AIPS 2
 */
#define MX50_AIPS2_BASE_ADDR	0x63f00000
#define MX50_AIPS2_SIZE		SZ_1M

#define MX50_PLL1_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x00080000)
#define MX50_PLL2_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x00084000)
#define MX50_PLL3_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x00088000)
#define MX50_UART5_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x00090000)
#define MX50_AHBMAX_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x00094000)
#define MX50_ARM_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000a0000)
#define MX50_OWIRE_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000a4000)
#define MX50_CSPI2_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000ac000)
#define MX50_SDMA_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000b0000)
#define MX50_ROMCP_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000b8000)
#define MX50_CSPI3_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000c0000)
#define MX50_I2C2_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000c4000)
#define MX50_I2C1_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000c8000)
#define MX50_SSI1_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000cc000)
#define MX50_AUDMUX_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000d0000)
#define MX50_WEIM_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000d8000)
#define MX50_FEC_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000ec000)

/*
 * Memory regions and CS
 */
#define MX50_CSD0_BASE_ADDR		0x70000000
#define MX50_CSD1_BASE_ADDR		0xb0000000
#define MX50_CS0_BASE_ADDR		0xf0000000

#define MX50_IO_P2V(x)			IMX_IO_P2V(x)
#define MX50_IO_ADDRESS(x)		IOMEM(MX50_IO_P2V(x))

/*
 * defines for SPBA modules
 */
#define MX50_SPBA_SDHC1		0x04
#define MX50_SPBA_SDHC2		0x08
#define MX50_SPBA_UART3		0x0c
#define MX50_SPBA_CSPI1		0x10
#define MX50_SPBA_SSI2		0x14
#define MX50_SPBA_SDHC3		0x20
#define MX50_SPBA_SDHC4		0x24
#define MX50_SPBA_SPDIF		0x28
#define MX50_SPBA_ATA		0x30
#define MX50_SPBA_SLIM		0x34
#define MX50_SPBA_HSI2C		0x38
#define MX50_SPBA_CTRL		0x3c

/*
 * DMA request assignments
 */
#define MX50_DMA_REQ_GPC		1
#define MX50_DMA_REQ_ATA_UART4_RX	2
#define MX50_DMA_REQ_ATA_UART4_TX	3
#define MX50_DMA_REQ_CSPI1_RX		6
#define MX50_DMA_REQ_CSPI1_TX		7
#define MX50_DMA_REQ_CSPI2_RX		8
#define MX50_DMA_REQ_CSPI2_TX		9
#define MX50_DMA_REQ_I2C3_SDHC3		10
#define MX50_DMA_REQ_SDHC4		11
#define MX50_DMA_REQ_UART2_FIRI_RX	12
#define MX50_DMA_REQ_UART2_FIRI_TX	13
#define MX50_DMA_REQ_EXT0		14
#define MX50_DMA_REQ_EXT1		15
#define MX50_DMA_REQ_UART5_RX		16
#define MX50_DMA_REQ_UART5_TX		17
#define MX50_DMA_REQ_UART1_RX		18
#define MX50_DMA_REQ_UART1_TX		19
#define MX50_DMA_REQ_I2C1_SDHC1		20
#define MX50_DMA_REQ_I2C2_SDHC2		21
#define MX50_DMA_REQ_SSI2_RX2		22
#define MX50_DMA_REQ_SSI2_TX2		23
#define MX50_DMA_REQ_SSI2_RX1		24
#define MX50_DMA_REQ_SSI2_TX1		25
#define MX50_DMA_REQ_SSI1_RX2		26
#define MX50_DMA_REQ_SSI1_TX2		27
#define MX50_DMA_REQ_SSI1_RX1		28
#define MX50_DMA_REQ_SSI1_TX1		29
#define MX50_DMA_REQ_CSPI_RX		38
#define MX50_DMA_REQ_CSPI_TX		39
#define MX50_DMA_REQ_UART3_RX		42
#define MX50_DMA_REQ_UART3_TX		43

/*
 * Interrupt numbers
 */
#include <asm/irq.h>
#define MX50_INT_MMC_SDHC1	(NR_IRQS_LEGACY + 1)
#define MX50_INT_MMC_SDHC2	(NR_IRQS_LEGACY + 2)
#define MX50_INT_MMC_SDHC3	(NR_IRQS_LEGACY + 3)
#define MX50_INT_MMC_SDHC4	(NR_IRQS_LEGACY + 4)
#define MX50_INT_DAP		(NR_IRQS_LEGACY + 5)
#define MX50_INT_SDMA		(NR_IRQS_LEGACY + 6)
#define MX50_INT_IOMUX		(NR_IRQS_LEGACY + 7)
#define MX50_INT_UART4		(NR_IRQS_LEGACY + 13)
#define MX50_INT_USB_H1		(NR_IRQS_LEGACY + 14)
#define MX50_INT_USB_OTG	(NR_IRQS_LEGACY + 18)
#define MX50_INT_DATABAHN	(NR_IRQS_LEGACY + 19)
#define MX50_INT_ELCDIF		(NR_IRQS_LEGACY + 20)
#define MX50_INT_EPXP		(NR_IRQS_LEGACY + 21)
#define MX50_INT_SRTC_NTZ	(NR_IRQS_LEGACY + 24)
#define MX50_INT_SRTC_TZ	(NR_IRQS_LEGACY + 25)
#define MX50_INT_EPDC		(NR_IRQS_LEGACY + 27)
#define MX50_INT_NIC		(NR_IRQS_LEGACY + 28)
#define MX50_INT_SSI1		(NR_IRQS_LEGACY + 29)
#define MX50_INT_SSI2		(NR_IRQS_LEGACY + 30)
#define MX50_INT_UART1		(NR_IRQS_LEGACY + 31)
#define MX50_INT_UART2		(NR_IRQS_LEGACY + 32)
#define MX50_INT_UART3		(NR_IRQS_LEGACY + 33)
#define MX50_INT_RESV34		(NR_IRQS_LEGACY + 34)
#define MX50_INT_RESV35		(NR_IRQS_LEGACY + 35)
#define MX50_INT_CSPI1		(NR_IRQS_LEGACY + 36)
#define MX50_INT_CSPI2		(NR_IRQS_LEGACY + 37)
#define MX50_INT_CSPI		(NR_IRQS_LEGACY + 38)
#define MX50_INT_GPT		(NR_IRQS_LEGACY + 39)
#define MX50_INT_EPIT1		(NR_IRQS_LEGACY + 40)
#define MX50_INT_GPIO1_INT7	(NR_IRQS_LEGACY + 42)
#define MX50_INT_GPIO1_INT6	(NR_IRQS_LEGACY + 43)
#define MX50_INT_GPIO1_INT5	(NR_IRQS_LEGACY + 44)
#define MX50_INT_GPIO1_INT4	(NR_IRQS_LEGACY + 45)
#define MX50_INT_GPIO1_INT3	(NR_IRQS_LEGACY + 46)
#define MX50_INT_GPIO1_INT2	(NR_IRQS_LEGACY + 47)
#define MX50_INT_GPIO1_INT1	(NR_IRQS_LEGACY + 48)
#define MX50_INT_GPIO1_INT0	(NR_IRQS_LEGACY + 49)
#define MX50_INT_GPIO1_LOW	(NR_IRQS_LEGACY + 50)
#define MX50_INT_GPIO1_HIGH	(NR_IRQS_LEGACY + 51)
#define MX50_INT_GPIO2_LOW	(NR_IRQS_LEGACY + 52)
#define MX50_INT_GPIO2_HIGH	(NR_IRQS_LEGACY + 53)
#define MX50_INT_GPIO3_LOW	(NR_IRQS_LEGACY + 54)
#define MX50_INT_GPIO3_HIGH	(NR_IRQS_LEGACY + 55)
#define MX50_INT_GPIO4_LOW	(NR_IRQS_LEGACY + 56)
#define MX50_INT_GPIO4_HIGH	(NR_IRQS_LEGACY + 57)
#define MX50_INT_WDOG1		(NR_IRQS_LEGACY + 58)
#define MX50_INT_KPP		(NR_IRQS_LEGACY + 60)
#define MX50_INT_PWM1		(NR_IRQS_LEGACY + 61)
#define MX50_INT_I2C1		(NR_IRQS_LEGACY + 62)
#define MX50_INT_I2C2		(NR_IRQS_LEGACY + 63)
#define MX50_INT_I2C3		(NR_IRQS_LEGACY + 64)
#define MX50_INT_RESV65		(NR_IRQS_LEGACY + 65)
#define MX50_INT_DCDC		(NR_IRQS_LEGACY + 66)
#define MX50_INT_THERMAL_ALARM	(NR_IRQS_LEGACY + 67)
#define MX50_INT_ANA3		(NR_IRQS_LEGACY + 68)
#define MX50_INT_ANA4		(NR_IRQS_LEGACY + 69)
#define MX50_INT_CCM1		(NR_IRQS_LEGACY + 71)
#define MX50_INT_CCM2		(NR_IRQS_LEGACY + 72)
#define MX50_INT_GPC1		(NR_IRQS_LEGACY + 73)
#define MX50_INT_GPC2		(NR_IRQS_LEGACY + 74)
#define MX50_INT_SRC		(NR_IRQS_LEGACY + 75)
#define MX50_INT_NM		(NR_IRQS_LEGACY + 76)
#define MX50_INT_PMU		(NR_IRQS_LEGACY + 77)
#define MX50_INT_CTI_IRQ	(NR_IRQS_LEGACY + 78)
#define MX50_INT_CTI1_TG0	(NR_IRQS_LEGACY + 79)
#define MX50_INT_CTI1_TG1	(NR_IRQS_LEGACY + 80)
#define MX50_INT_GPU2_IRQ	(NR_IRQS_LEGACY + 84)
#define MX50_INT_GPU2_BUSY	(NR_IRQS_LEGACY + 85)
#define MX50_INT_UART5		(NR_IRQS_LEGACY + 86)
#define MX50_INT_FEC		(NR_IRQS_LEGACY + 87)
#define MX50_INT_OWIRE		(NR_IRQS_LEGACY + 88)
#define MX50_INT_CTI1_TG2	(NR_IRQS_LEGACY + 89)
#define MX50_INT_SJC		(NR_IRQS_LEGACY + 90)
#define MX50_INT_DCP_CHAN1_3	(NR_IRQS_LEGACY + 91)
#define MX50_INT_DCP_CHAN0	(NR_IRQS_LEGACY + 92)
#define MX50_INT_PWM2		(NR_IRQS_LEGACY + 94)
#define MX50_INT_RNGB		(NR_IRQS_LEGACY + 97)
#define MX50_INT_CTI1_TG3	(NR_IRQS_LEGACY + 98)
#define MX50_INT_RAWNAND_BCH	(NR_IRQS_LEGACY + 100)
#define MX50_INT_RAWNAND_GPMI	(NR_IRQS_LEGACY + 102)
#define MX50_INT_GPIO5_LOW	(NR_IRQS_LEGACY + 103)
#define MX50_INT_GPIO5_HIGH	(NR_IRQS_LEGACY + 104)
#define MX50_INT_GPIO6_LOW	(NR_IRQS_LEGACY + 105)
#define MX50_INT_GPIO6_HIGH	(NR_IRQS_LEGACY + 106)
#define MX50_INT_MSHC		(NR_IRQS_LEGACY + 109)
#define MX50_INT_APBHDMA_CHAN0	(NR_IRQS_LEGACY + 110)
#define MX50_INT_APBHDMA_CHAN1	(NR_IRQS_LEGACY + 111)
#define MX50_INT_APBHDMA_CHAN2	(NR_IRQS_LEGACY + 112)
#define MX50_INT_APBHDMA_CHAN3	(NR_IRQS_LEGACY + 113)
#define MX50_INT_APBHDMA_CHAN4	(NR_IRQS_LEGACY + 114)
#define MX50_INT_APBHDMA_CHAN5	(NR_IRQS_LEGACY + 115)
#define MX50_INT_APBHDMA_CHAN6	(NR_IRQS_LEGACY + 116)
#define MX50_INT_APBHDMA_CHAN7	(NR_IRQS_LEGACY + 117)

#if !defined(__ASSEMBLY__) && !defined(__MXC_BOOT_UNCOMPRESS)
extern int mx50_revision(void);
#endif

#endif /* ifndef __MACH_MX50_H__ */
