/*****************************************************************************/

/*
 *	sm_fsk9600.h  --  soundcard radio modem driver, 
 *                        9600 baud G3RUH compatible FSK modem
 *
 *	Copyright (C) 1996  Thomas Sailer (sailer@ife.ee.ethz.ch)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Please note that the GPL allows you to use the driver, NOT the radio.
 *  In order to use the radio, you need a license from the communications
 *  authority of your country.
 *
 */

/* --------------------------------------------------------------------- */

struct demod_state_fsk96 {
	unsigned int shreg;
	unsigned long descram;
	unsigned int bit_pll;
	unsigned char last_sample;
	unsigned int dcd_shreg;
	int dcd_sum0, dcd_sum1, dcd_sum2;
	unsigned int dcd_time;
};

struct mod_state_fsk96 {
	unsigned int shreg;
	unsigned long scram;
	unsigned char tx_bit;
};

#define DEMOD_STATE ((struct demod_state_fsk96 *)(&sm->d))
#define MOD_STATE ((struct mod_state_fsk96 *)(&sm->m))

/* --------------------------------------------------------------------- */

#define DESCRAM_TAP1 0x20000
#define DESCRAM_TAP2 0x01000
#define DESCRAM_TAP3 0x00001

#define DESCRAM_TAPSH1 17
#define DESCRAM_TAPSH2 12
#define DESCRAM_TAPSH3 0

#define SCRAM_TAP1 0x20000 /* X^17 */
#define SCRAM_TAPN 0x00021 /* X^0+X^5 */

/* --------------------------------------------------------------------- */

static unsigned char tx_filter_9k6_4[] = {
	  65,  66,  63,  63,  76,  76,  73,  73,
	  54,  54,  51,  51,  64,  65,  61,  62,
	 214, 214, 211, 211, 224, 225, 221, 222,
	 202, 202, 199, 200, 213, 213, 210, 210,
	  38,  38,  35,  35,  48,  49,  45,  46,
	  26,  27,  23,  24,  37,  37,  34,  34,
	 186, 187, 183, 184, 197, 197, 194, 194,
	 175, 175, 172, 172, 185, 185, 182, 182,
	  73,  74,  70,  71,  84,  84,  81,  81,
	  62,  62,  59,  59,  72,  72,  69,  69,
	 221, 222, 218, 219, 232, 232, 229, 229,
	 210, 210, 207, 207, 220, 221, 217, 218,
	  46,  46,  43,  43,  56,  56,  53,  53,
	  34,  34,  31,  31,  44,  45,  41,  42,
	 194, 194, 191, 191, 204, 205, 201, 202,
	 182, 183, 179, 180, 193, 193, 190, 190,
	  65,  65,  62,  62,  75,  76,  72,  73,
	  53,  54,  50,  51,  64,  64,  61,  61,
	 213, 214, 210, 211, 224, 224, 221, 221,
	 202, 202, 199, 199, 212, 212, 209, 209,
	  37,  38,  34,  35,  48,  48,  45,  45,
	  26,  26,  23,  23,  36,  37,  33,  34,
	 186, 186, 183, 183, 196, 196, 193, 193,
	 174, 174, 171, 171, 184, 185, 181, 182,
	  73,  73,  70,  70,  83,  83,  80,  80,
	  61,  61,  58,  58,  71,  72,  68,  69,
	 221, 221, 218, 218, 231, 232, 228, 229,
	 209, 210, 206, 207, 220, 220, 217, 217,
	  45,  45,  42,  42,  55,  56,  53,  53,
	  33,  34,  30,  31,  44,  44,  41,  41,
	 193, 194, 190, 191, 204, 204, 201, 201,
	 182, 182, 179, 179, 192, 192, 189, 190,
	  65,  66,  62,  63,  67,  68,  64,  64,
	 103, 104, 100, 101, 105, 106, 101, 102,
	 168, 169, 164, 165, 169, 170, 166, 167,
	 205, 206, 202, 203, 207, 208, 204, 205,
	  49,  50,  46,  46,  51,  51,  47,  48,
	  87,  88,  83,  84,  88,  89,  85,  86,
	 151, 152, 148, 149, 153, 154, 149, 150,
	 189, 190, 186, 187, 191, 192, 187, 188,
	  66,  67,  63,  64,  68,  69,  64,  65,
	 104, 105, 100, 101, 105, 106, 102, 103,
	 168, 169, 165, 166, 170, 171, 167, 167,
	 206, 207, 203, 204, 208, 209, 204, 205,
	  50,  51,  46,  47,  51,  52,  48,  49,
	  87,  88,  84,  85,  89,  90,  85,  86,
	 152, 153, 149, 149, 154, 154, 150, 151,
	 190, 191, 186, 187, 191, 192, 188, 189,
	  66,  67,  63,  64,  68,  69,  64,  65,
	 104, 105, 101, 101, 106, 106, 102, 103,
	 169, 170, 165, 166, 170, 171, 167, 168,
	 206, 207, 203, 204, 208, 209, 204, 205,
	  50,  51,  46,  47,  51,  52,  48,  49,
	  88,  88,  84,  85,  89,  90,  86,  87,
	 152, 153, 149, 150, 154, 155, 150, 151,
	 190, 191, 186, 187, 191, 192, 188, 189,
	  67,  68,  63,  64,  68,  69,  65,  66,
	 105, 106, 101, 102, 106, 107, 103, 104,
	 169, 170, 166, 167, 171, 172, 167, 168,
	 207, 208, 204, 204, 209, 209, 205, 206,
	  50,  51,  47,  48,  52,  53,  49,  50,
	  88,  89,  85,  86,  90,  91,  86,  87,
	 153, 154, 149, 150, 154, 155, 151, 152,
	 191, 191, 187, 188, 192, 193, 189, 190,
	  65,  66,  66,  67,  49,  50,  50,  50,
	 168, 169, 168, 169, 151, 152, 152, 153,
	 103, 104, 104, 105,  87,  88,  87,  88,
	 205, 206, 206, 207, 189, 190, 190, 191,
	  67,  68,  68,  68,  51,  51,  51,  52,
	 169, 170, 170, 171, 153, 154, 154, 154,
	 105, 106, 105, 106,  88,  89,  89,  90,
	 207, 208, 208, 209, 191, 191, 191, 192,
	  62,  63,  63,  63,  46,  46,  46,  47,
	 164, 165, 165, 166, 148, 149, 149, 149,
	 100, 101, 100, 101,  83,  84,  84,  85,
	 202, 203, 203, 204, 186, 186, 186, 187,
	  64,  64,  64,  65,  47,  48,  48,  49,
	 166, 167, 167, 167, 149, 150, 150, 151,
	 101, 102, 102, 103,  85,  86,  85,  86,
	 204, 204, 204, 205, 187, 188, 188, 189,
	  66,  67,  67,  68,  50,  51,  51,  51,
	 169, 170, 169, 170, 152, 153, 153, 154,
	 104, 105, 105, 106,  88,  88,  88,  89,
	 206, 207, 207, 208, 190, 191, 191, 191,
	  68,  69,  69,  69,  51,  52,  52,  53,
	 170, 171, 171, 172, 154, 155, 154, 155,
	 106, 106, 106, 107,  89,  90,  90,  91,
	 208, 209, 209, 209, 192, 192, 192, 193,
	  63,  64,  64,  64,  46,  47,  47,  48,
	 165, 166, 166, 167, 149, 150, 149, 150,
	 101, 101, 101, 102,  84,  85,  85,  86,
	 203, 204, 204, 204, 187, 187, 187, 188,
	  64,  65,  65,  66,  48,  49,  49,  50,
	 167, 168, 167, 168, 150, 151, 151, 152,
	 102, 103, 103, 104,  86,  87,  86,  87,
	 205, 205, 205, 206, 188, 189, 189, 190,
	  65,  65,  73,  73,  38,  37,  46,  45,
	 214, 213, 221, 221, 186, 186, 194, 193,
	  54,  53,  62,  61,  26,  26,  34,  33,
	 202, 202, 210, 209, 175, 174, 182, 182,
	  76,  75,  84,  83,  48,  48,  56,  55,
	 224, 224, 232, 231, 197, 196, 204, 204,
	  64,  64,  72,  71,  37,  36,  44,  44,
	 213, 212, 220, 220, 185, 184, 193, 192,
	  63,  62,  70,  70,  35,  34,  43,  42,
	 211, 210, 218, 218, 183, 183, 191, 190,
	  51,  50,  59,  58,  23,  23,  31,  30,
	 199, 199, 207, 206, 172, 171, 179, 179,
	  73,  72,  81,  80,  45,  45,  53,  53,
	 221, 221, 229, 228, 194, 193, 201, 201,
	  61,  61,  69,  68,  34,  33,  41,  41,
	 210, 209, 217, 217, 182, 181, 190, 189,
	  66,  65,  74,  73,  38,  38,  46,  45,
	 214, 214, 222, 221, 187, 186, 194, 194,
	  54,  54,  62,  61,  27,  26,  34,  34,
	 202, 202, 210, 210, 175, 174, 183, 182,
	  76,  76,  84,  83,  49,  48,  56,  56,
	 225, 224, 232, 232, 197, 196, 205, 204,
	  65,  64,  72,  72,  37,  37,  45,  44,
	 213, 212, 221, 220, 185, 185, 193, 192,
	  63,  62,  71,  70,  35,  35,  43,  42,
	 211, 211, 219, 218, 184, 183, 191, 191,
	  51,  51,  59,  58,  24,  23,  31,  31,
	 200, 199, 207, 207, 172, 171, 180, 179,
	  73,  73,  81,  80,  46,  45,  53,  53,
	 222, 221, 229, 229, 194, 193, 202, 201,
	  62,  61,  69,  69,  34,  34,  42,  41,
	 210, 209, 218, 217, 182, 182, 190, 190
};

static unsigned char tx_filter_9k6_5[] = {
	  78,  78,  75,  76,  85,  85,  82,  83,
	  71,  72,  69,  69,  78,  78,  76,  76,
	 193, 193, 190, 191, 199, 200, 197, 198,
	 186, 187, 184, 184, 193, 193, 190, 191,
	  58,  59,  56,  57,  65,  66,  63,  63,
	  52,  52,  49,  50,  58,  59,  56,  57,
	 173, 174, 171, 171, 180, 180, 177, 178,
	 166, 167, 164, 165, 173, 174, 171, 171,
	  85,  86,  83,  83,  92,  92,  89,  90,
	  79,  79,  76,  77,  85,  86,  83,  83,
	 200, 200, 198, 198, 207, 207, 204, 205,
	 193, 194, 191, 191, 200, 201, 198, 198,
	  66,  66,  63,  64,  72,  73,  70,  70,
	  59,  60,  57,  57,  66,  66,  63,  64,
	 180, 181, 178, 179, 187, 188, 185, 185,
	 174, 174, 171, 172, 180, 181, 178, 179,
	  76,  77,  74,  75,  83,  84,  81,  81,
	  70,  70,  67,  68,  76,  77,  74,  75,
	 191, 192, 189, 189, 198, 198, 195, 196,
	 185, 185, 182, 183, 191, 192, 189, 189,
	  57,  57,  54,  55,  64,  64,  61,  62,
	  50,  51,  48,  48,  57,  57,  55,  55,
	 172, 172, 169, 170, 178, 179, 176, 177,
	 165, 166, 163, 163, 172, 172, 169, 170,
	  84,  84,  81,  82,  90,  91,  88,  89,
	  77,  78,  75,  75,  84,  84,  81,  82,
	 198, 199, 196, 197, 205, 206, 203, 203,
	 192, 192, 189, 190, 198, 199, 196, 197,
	  64,  65,  62,  62,  71,  71,  68,  69,
	  57,  58,  55,  56,  64,  65,  62,  62,
	 179, 179, 177, 177, 186, 186, 183, 184,
	 172, 173, 170, 170, 179, 180, 177, 177,
	  78,  79,  76,  77,  79,  79,  77,  77,
	  99, 100,  97,  98, 100, 100,  98,  98,
	 171, 172, 169, 170, 172, 173, 170, 171,
	 192, 193, 190, 191, 193, 194, 191, 192,
	  59,  60,  57,  58,  60,  61,  58,  59,
	  81,  81,  79,  79,  81,  82,  79,  80,
	 153, 153, 151, 151, 153, 154, 151, 152,
	 174, 175, 172, 173, 175, 175, 173, 173,
	  82,  83,  80,  81,  83,  83,  81,  81,
	 103, 104, 101, 102, 104, 105, 102, 103,
	 175, 176, 173, 174, 176, 177, 174, 175,
	 197, 197, 195, 195, 197, 198, 195, 196,
	  64,  64,  62,  62,  64,  65,  62,  63,
	  85,  85,  83,  83,  85,  86,  83,  84,
	 157, 158, 155, 156, 158, 158, 156, 156,
	 178, 179, 176, 177, 179, 179, 177, 177,
	  78,  78,  76,  76,  78,  79,  76,  77,
	  99,  99,  97,  97,  99, 100,  97,  98,
	 171, 172, 169, 170, 172, 172, 170, 170,
	 192, 193, 190, 191, 193, 193, 191, 191,
	  59,  60,  57,  58,  60,  60,  58,  58,
	  80,  81,  78,  79,  81,  82,  79,  80,
	 152, 153, 150, 151, 153, 154, 151, 152,
	 174, 174, 172, 172, 174, 175, 172, 173,
	  82,  82,  80,  80,  82,  83,  80,  81,
	 103, 104, 101, 102, 104, 104, 102, 102,
	 175, 176, 173, 174, 176, 176, 174, 174,
	 196, 197, 194, 195, 197, 198, 195, 196,
	  63,  64,  61,  62,  64,  65,  62,  63,
	  84,  85,  82,  83,  85,  86,  83,  84,
	 157, 157, 155, 155, 157, 158, 155, 156,
	 178, 178, 176, 176, 178, 179, 176, 177,
	  78,  78,  78,  79,  69,  69,  69,  69,
	 136, 136, 136, 137, 127, 127, 127, 128,
	 136, 136, 136, 137, 127, 127, 127, 128,
	 194, 195, 195, 195, 185, 185, 185, 186,
	  69,  69,  69,  69,  59,  60,  60,  60,
	 127, 127, 127, 128, 117, 118, 118, 118,
	 127, 127, 127, 128, 117, 118, 118, 118,
	 185, 185, 185, 186, 175, 176, 176, 176,
	  78,  79,  79,  79,  69,  69,  69,  70,
	 136, 137, 137, 137, 127, 128, 127, 128,
	 136, 137, 137, 137, 127, 128, 127, 128,
	 195, 195, 195, 195, 185, 186, 186, 186,
	  69,  69,  69,  70,  60,  60,  60,  60,
	 127, 128, 127, 128, 118, 118, 118, 119,
	 127, 128, 127, 128, 118, 118, 118, 119,
	 185, 186, 186, 186, 176, 176, 176, 177,
	  78,  79,  79,  79,  69,  69,  69,  70,
	 136, 137, 137, 137, 127, 128, 128, 128,
	 136, 137, 137, 137, 127, 128, 128, 128,
	 195, 195, 195, 195, 185, 186, 186, 186,
	  69,  69,  69,  70,  60,  60,  60,  60,
	 127, 128, 128, 128, 118, 118, 118, 119,
	 127, 128, 128, 128, 118, 118, 118, 119,
	 185, 186, 186, 186, 176, 176, 176, 177,
	  79,  79,  79,  80,  69,  70,  70,  70,
	 137, 137, 137, 138, 128, 128, 128, 128,
	 137, 137, 137, 138, 128, 128, 128, 128,
	 195, 195, 195, 196, 186, 186, 186, 186,
	  69,  70,  70,  70,  60,  60,  60,  61,
	 128, 128, 128, 128, 118, 119, 119, 119,
	 128, 128, 128, 128, 118, 119, 119, 119,
	 186, 186, 186, 186, 176, 177, 177, 177,
	  78,  78,  82,  82,  59,  59,  64,  63,
	 171, 171, 175, 175, 153, 152, 157, 157,
	  99,  99, 103, 103,  81,  80,  85,  84,
	 192, 192, 197, 196, 174, 174, 178, 178,
	  79,  78,  83,  82,  60,  60,  64,  64,
	 172, 172, 176, 176, 153, 153, 158, 157,
	 100,  99, 104, 104,  81,  81,  85,  85,
	 193, 193, 197, 197, 175, 174, 179, 178,
	  76,  76,  80,  80,  57,  57,  62,  61,
	 169, 169, 173, 173, 151, 150, 155, 155,
	  97,  97, 101, 101,  79,  78,  83,  82,
	 190, 190, 195, 194, 172, 172, 176, 176,
	  77,  76,  81,  80,  58,  58,  62,  62,
	 170, 170, 174, 174, 151, 151, 156, 155,
	  98,  97, 102, 102,  79,  79,  83,  83,
	 191, 191, 195, 195, 173, 172, 177, 176,
	  79,  78,  83,  82,  60,  60,  64,  64,
	 172, 172, 176, 176, 153, 153, 158, 157,
	 100,  99, 104, 104,  81,  81,  85,  85,
	 193, 193, 197, 197, 175, 174, 179, 178,
	  79,  79,  83,  83,  61,  60,  65,  65,
	 173, 172, 177, 176, 154, 154, 158, 158,
	 100, 100, 105, 104,  82,  82,  86,  86,
	 194, 193, 198, 198, 175, 175, 179, 179,
	  77,  76,  81,  80,  58,  58,  62,  62,
	 170, 170, 174, 174, 151, 151, 156, 155,
	  98,  97, 102, 102,  79,  79,  83,  83,
	 191, 191, 195, 195, 173, 172, 177, 176,
	  77,  77,  81,  81,  59,  58,  63,  63,
	 171, 170, 175, 174, 152, 152, 156, 156,
	  98,  98, 103, 102,  80,  80,  84,  84,
	 192, 191, 196, 196, 173, 173, 177, 177,
	  78,  76,  85,  84,  58,  57,  66,  64,
	 193, 191, 200, 198, 173, 172, 180, 179,
	  71,  70,  79,  77,  52,  50,  59,  57,
	 186, 185, 193, 192, 166, 165, 174, 172,
	  85,  83,  92,  90,  65,  64,  72,  71,
	 199, 198, 207, 205, 180, 178, 187, 186,
	  78,  76,  85,  84,  58,  57,  66,  64,
	 193, 191, 200, 198, 173, 172, 180, 179,
	  75,  74,  83,  81,  56,  54,  63,  62,
	 190, 189, 198, 196, 171, 169, 178, 177,
	  69,  67,  76,  75,  49,  48,  57,  55,
	 184, 182, 191, 189, 164, 163, 171, 170,
	  82,  81,  89,  88,  63,  61,  70,  68,
	 197, 195, 204, 203, 177, 176, 185, 183,
	  76,  74,  83,  81,  56,  55,  63,  62,
	 190, 189, 198, 196, 171, 169, 178, 177,
	  78,  77,  86,  84,  59,  57,  66,  65,
	 193, 192, 200, 199, 174, 172, 181, 179,
	  72,  70,  79,  78,  52,  51,  60,  58,
	 187, 185, 194, 192, 167, 166, 174, 173,
	  85,  84,  92,  91,  66,  64,  73,  71,
	 200, 198, 207, 206, 180, 179, 188, 186,
	  78,  77,  86,  84,  59,  57,  66,  65,
	 193, 192, 201, 199, 174, 172, 181, 180,
	  76,  75,  83,  82,  57,  55,  64,  62,
	 191, 189, 198, 197, 171, 170, 179, 177,
	  69,  68,  77,  75,  50,  48,  57,  56,
	 184, 183, 191, 190, 165, 163, 172, 170,
	  83,  81,  90,  89,  63,  62,  70,  69,
	 198, 196, 205, 203, 178, 177, 185, 184,
	  76,  75,  83,  82,  57,  55,  64,  62,
	 191, 189, 198, 197, 171, 170, 179, 177
};

/* --------------------------------------------------------------------- */

static void modulator_9600_4(struct sm_state *sm, unsigned char *buf, int buflen)
{
	int j;
	const unsigned char *cp;

	for (; buflen >= 4; buflen -= 4) {
		if (MOD_STATE->shreg <= 1)
			MOD_STATE->shreg = hdlcdrv_getbits(&sm->hdrv) | 0x10000;
		MOD_STATE->scram = ((MOD_STATE->scram << 1) |
				     (MOD_STATE->scram & 1));
		MOD_STATE->scram ^= (!(MOD_STATE->shreg & 1));
		MOD_STATE->shreg >>= 1;
		if (MOD_STATE->scram & (SCRAM_TAP1 << 1))
			MOD_STATE->scram ^= (SCRAM_TAPN << 1);
		MOD_STATE->tx_bit = (MOD_STATE->tx_bit << 1) | 
			(!!(MOD_STATE->scram & (SCRAM_TAP1 << 2)));
		cp = tx_filter_9k6_4 + (MOD_STATE->tx_bit & 0xff);
		for (j = 0; j < 4; j++) {
			*buf++ = *cp;
			cp += 0x100;
		}
	}
}

/* --------------------------------------------------------------------- */

static void demodulator_9600_4(struct sm_state *sm, unsigned char *buf, int buflen)
{
	static const int pll_corr[2] = { -0x1000, 0x1000 };
	unsigned char curbit;
	unsigned int descx;

	for (; buflen > 0; buflen--, buf++) {
		DEMOD_STATE->dcd_shreg <<= 1;
		DEMOD_STATE->bit_pll += 0x4000;
		curbit = (*buf >= 0x80);
		if (DEMOD_STATE->last_sample ^ curbit) {
			DEMOD_STATE->dcd_shreg |= 1;
			DEMOD_STATE->bit_pll += pll_corr
				[DEMOD_STATE->bit_pll < 0xa000];
			DEMOD_STATE->dcd_sum0 += 8 * 
				hweight8(DEMOD_STATE->dcd_shreg & 0x0c) - 
				!!(DEMOD_STATE->dcd_shreg & 0x10);
		}
		DEMOD_STATE->last_sample = curbit;
		hdlcdrv_channelbit(&sm->hdrv, DEMOD_STATE->last_sample);
		if ((--DEMOD_STATE->dcd_time) <= 0) {
			hdlcdrv_setdcd(&sm->hdrv, (DEMOD_STATE->dcd_sum0 + 
						   DEMOD_STATE->dcd_sum1 + 
						   DEMOD_STATE->dcd_sum2) < 0);
			DEMOD_STATE->dcd_sum2 = DEMOD_STATE->dcd_sum1;
			DEMOD_STATE->dcd_sum1 = DEMOD_STATE->dcd_sum0;
			DEMOD_STATE->dcd_sum0 = 2; /* slight bias */
			DEMOD_STATE->dcd_time = 240;
		}
		if (DEMOD_STATE->bit_pll >= 0x10000) {
			DEMOD_STATE->bit_pll &= 0xffff;
			DEMOD_STATE->descram = (DEMOD_STATE->descram << 1) | curbit;
			descx = DEMOD_STATE->descram ^ (DEMOD_STATE->descram >> 1);
			descx ^= ((descx >> DESCRAM_TAPSH1) ^
				  (descx >> DESCRAM_TAPSH2));
			DEMOD_STATE->shreg >>= 1;
			DEMOD_STATE->shreg |= (!(descx & 1)) << 16;
			if (DEMOD_STATE->shreg & 1) {
				hdlcdrv_putbits(&sm->hdrv, DEMOD_STATE->shreg >> 1);
				DEMOD_STATE->shreg = 0x10000;
			}
			diag_trigger(sm);
		}
		diag_add_one(sm, ((short)(*buf - 0x80)) << 8);
	}
}

/* --------------------------------------------------------------------- */

static void modulator_9600_5(struct sm_state *sm, unsigned char *buf, int buflen)
{
	int j;
	const unsigned char *cp;

	for (; buflen >= 5; buflen -= 5) {
		if (MOD_STATE->shreg <= 1)
			MOD_STATE->shreg = hdlcdrv_getbits(&sm->hdrv) | 0x10000;
		MOD_STATE->scram = ((MOD_STATE->scram << 1) |
				     (MOD_STATE->scram & 1));
		MOD_STATE->scram ^= (!(MOD_STATE->shreg & 1));
		MOD_STATE->shreg >>= 1;
		if (MOD_STATE->scram & (SCRAM_TAP1 << 1))
			MOD_STATE->scram ^= (SCRAM_TAPN << 1);
		MOD_STATE->tx_bit = (MOD_STATE->tx_bit << 1) | 
			(!!(MOD_STATE->scram & (SCRAM_TAP1 << 2)));
		cp = tx_filter_9k6_5 + (MOD_STATE->tx_bit & 0xff);
		for (j = 0; j < 5; j++) {
			*buf++ = *cp;
			cp += 0x100;
		}
	}
}

/* --------------------------------------------------------------------- */

static void demodulator_9600_5(struct sm_state *sm, unsigned char *buf, int buflen)
{
	static const int pll_corr[2] = { -0x1000, 0x1000 };
	unsigned char curbit;
	unsigned int descx;

	for (; buflen > 0; buflen--, buf++) {
		DEMOD_STATE->dcd_shreg <<= 1;
		DEMOD_STATE->bit_pll += 0x3333;
		curbit = (*buf >= 0x80);
		if (DEMOD_STATE->last_sample ^ curbit) {
			DEMOD_STATE->dcd_shreg |= 1;
			DEMOD_STATE->bit_pll += pll_corr
				[DEMOD_STATE->bit_pll < 0x9999];
			DEMOD_STATE->dcd_sum0 += 16 * 
				hweight8(DEMOD_STATE->dcd_shreg & 0x0c) - 
				hweight8(DEMOD_STATE->dcd_shreg & 0x70);
		}
		DEMOD_STATE->last_sample = curbit;
		hdlcdrv_channelbit(&sm->hdrv, DEMOD_STATE->last_sample);
		if ((--DEMOD_STATE->dcd_time) <= 0) {
			hdlcdrv_setdcd(&sm->hdrv, (DEMOD_STATE->dcd_sum0 + 
						   DEMOD_STATE->dcd_sum1 + 
						   DEMOD_STATE->dcd_sum2) < 0);
			DEMOD_STATE->dcd_sum2 = DEMOD_STATE->dcd_sum1;
			DEMOD_STATE->dcd_sum1 = DEMOD_STATE->dcd_sum0;
			DEMOD_STATE->dcd_sum0 = 2; /* slight bias */
			DEMOD_STATE->dcd_time = 240;
		}
		if (DEMOD_STATE->bit_pll >= 0x10000) {
			DEMOD_STATE->bit_pll &= 0xffff;
			DEMOD_STATE->descram = (DEMOD_STATE->descram << 1) | curbit;
			descx = DEMOD_STATE->descram ^ (DEMOD_STATE->descram >> 1);
			descx ^= ((descx >> DESCRAM_TAPSH1) ^
				  (descx >> DESCRAM_TAPSH2));
			DEMOD_STATE->shreg >>= 1;
			DEMOD_STATE->shreg |= (!(descx & 1)) << 16;
			if (DEMOD_STATE->shreg & 1) {
				hdlcdrv_putbits(&sm->hdrv, DEMOD_STATE->shreg >> 1);
				DEMOD_STATE->shreg = 0x10000;
			}
			diag_trigger(sm);
		}
		diag_add_one(sm, ((short)(*buf - 0x80)) << 8);
	}
}

/* --------------------------------------------------------------------- */

static void demod_init_9600(struct sm_state *sm)
{
	DEMOD_STATE->dcd_time = 240;
	DEMOD_STATE->dcd_sum0 = 2;	
}

/* --------------------------------------------------------------------- */

static const struct modem_tx_info fsk9600_4_tx = {
	NEXT_TX_INFO, "fsk9600", sizeof(struct mod_state_fsk96), 38400, 9600, 4,
	modulator_9600_4, NULL
};
#undef NEXT_TX_INFO
#define NEXT_TX_INFO (&fsk9600_4_tx)

static const struct modem_rx_info fsk9600_4_rx = {
	NEXT_RX_INFO, "fsk9600", sizeof(struct demod_state_fsk96), 38400, 9600, 4, 4,
	demodulator_9600_4, demod_init_9600
};
#undef NEXT_RX_INFO
#define NEXT_RX_INFO (&fsk9600_4_rx)

/* --------------------------------------------------------------------- */

static const struct modem_tx_info fsk9600_5_tx = {
	NEXT_TX_INFO, "fsk9600", sizeof(struct mod_state_fsk96), 48000, 9600, 5, 
	modulator_9600_5, NULL
};
#undef NEXT_TX_INFO
#define NEXT_TX_INFO (&fsk9600_5_tx)

static const struct modem_rx_info fsk9600_5_rx = {
	NEXT_RX_INFO, "fsk9600", sizeof(struct demod_state_fsk96), 48000, 9600, 5, 5, 
	demodulator_9600_5, demod_init_9600
};
#undef NEXT_RX_INFO
#define NEXT_RX_INFO (&fsk9600_5_rx)

/* --------------------------------------------------------------------- */

#undef DEMOD_STATE
#undef MOD_STATE
