# Maintainers

This document details any and all processes relevant to project maintainers. Maintainers should feel empowered to contribute back to this document with any process changes they feel improve the overall experience for themselves and other maintainers.

## Labels

Maintainers are encouraged to use the extensive and detailed list of labels for easier repo management.

* Generally, all issues should be labelled. The most general labels are `bug`, `enhancement`, and `Status: help-wanted`.
* Issues specific to a certain aspect of the project should be labeled using one of the specificity labels listed below. For example, a bug in the `Client` class should have the `Client` and `bug` label assigned.
  * Specificity labels:
    * `Agent`
    * `Client`
    * `Docs`
    * `Performance`
    * `Pool`
    * `Tests`
    * `Types`
* Any `question` or `usage help` issues should be converted into Q&A Discussions
* `Status:` labels should be added to all open issues indicating their relative development status.
  * Status labels:
    * `Status: blocked`
    * `Status: help-wanted`
    * `Status: in-progress`
    * `Status: wontfix`
* Issues and/or pull requests with an agreed upon semver status can be assigned the appropriate `semver-` label.
  * Semver labels:
    * `semver-major`
    * `semver-minor`
    * `semver-patch`
* Issues with a low-barrier of entry should be assigned the `good first issue` label.
* Do not use the `invalid` label, instead use `bug` or `Status: wontfix`.
* Duplicate issues should initially be assigned the `duplicate` label.
