/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.impl.jdbc.EncryptedLOBFile;
import org.apache.derby.impl.jdbc.LOBFile;
import org.apache.derby.impl.jdbc.LOBInputStream;
import org.apache.derby.impl.jdbc.LOBOutputStream;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.io.StorageFile;
import org.apache.derby.shared.common.error.ExceptionUtil;

class LOBStreamControl {
    private LOBFile tmpFile;
    private StorageFile lobFile;
    private byte[] dataBytes = new byte[0];
    private boolean isBytes = true;
    private final int bufferSize;
    private String dbName;
    private long updateCount;
    private static final int DEFAULT_MAX_BUF_SIZE = 4096;

    LOBStreamControl(String string) {
        this.dbName = string;
        this.updateCount = 0L;
        this.bufferSize = 4096;
    }

    LOBStreamControl(String string, byte[] byArray) throws IOException, SQLException, StandardException {
        this.dbName = string;
        this.updateCount = 0L;
        this.bufferSize = Math.max(4096, byArray.length);
        this.write(byArray, 0, byArray.length, 0L);
    }

    private void init(byte[] byArray, long l) throws IOException, SQLException, StandardException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, StandardException {
                    Object object = Monitor.findService("org.apache.derby.database.Database", LOBStreamControl.this.dbName);
                    DataFactory dataFactory = (DataFactory)Monitor.findServiceModule(object, "org.apache.derby.iapi.store.raw.data.DataFactory");
                    LOBStreamControl.this.lobFile = dataFactory.getStorageFactory().createTemporaryFile("lob", null);
                    if (dataFactory.databaseEncrypted()) {
                        LOBStreamControl.this.tmpFile = new EncryptedLOBFile(LOBStreamControl.this.lobFile, dataFactory);
                    } else {
                        LOBStreamControl.this.tmpFile = new LOBFile(LOBStreamControl.this.lobFile);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof StandardException) {
                throw Util.generateCsSQLException((StandardException)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        this.isBytes = false;
        if (l != 0L) {
            this.write(byArray, 0, (int)l, 0L);
        }
        this.dataBytes = null;
    }

    private long updateData(byte[] byArray, int n, int n2, long l) throws SQLException {
        if (this.dataBytes == null) {
            if ((int)l == 0) {
                this.dataBytes = new byte[n2];
                System.arraycopy(byArray, n, this.dataBytes, (int)l, n2);
                return n2;
            }
            throw Util.generateCsSQLException("XJ076.S", new Long(l));
        }
        if (l > (long)this.dataBytes.length) {
            throw Util.generateCsSQLException("XJ076.S", new Long(l));
        }
        if (l + (long)n2 < (long)this.dataBytes.length) {
            System.arraycopy(byArray, n, this.dataBytes, (int)l, n2);
        } else {
            byte[] byArray2 = new byte[n2 + (int)l];
            System.arraycopy(this.dataBytes, 0, byArray2, 0, (int)l);
            System.arraycopy(byArray, n, byArray2, (int)l, n2);
            this.dataBytes = byArray2;
        }
        return l + (long)n2;
    }

    private void isValidPostion(long l) throws SQLException, IOException {
        if (l < 0L) {
            throw Util.generateCsSQLException("XJ071.S", new Long(l + 1L));
        }
        if (l > Integer.MAX_VALUE) {
            throw Util.generateCsSQLException("XJ076.S", new Long(l + 1L));
        }
        if (this.isBytes ? (this.dataBytes == null ? l != 0L : (long)this.dataBytes.length < l) : l > this.tmpFile.length()) {
            throw Util.generateCsSQLException("XJ076.S", new Long(l + 1L));
        }
    }

    private void isValidOffset(int n, int n2) throws SQLException {
        if (n < 0 || n > n2) {
            throw Util.generateCsSQLException("XJ078.S", new Integer(n));
        }
    }

    synchronized long write(int n, long l) throws IOException, SQLException, StandardException {
        this.isValidPostion(l);
        ++this.updateCount;
        if (this.isBytes) {
            if (l < (long)this.bufferSize) {
                byte[] byArray = new byte[]{(byte)n};
                this.updateData(byArray, 0, 1, l);
                return l + 1L;
            }
            this.init(this.dataBytes, l);
        }
        this.tmpFile.seek(l);
        this.tmpFile.write(n);
        return this.tmpFile.getFilePointer();
    }

    synchronized long write(byte[] byArray, int n, int n2, long l) throws IOException, SQLException, StandardException {
        try {
            this.isValidPostion(l);
            this.isValidOffset(n, byArray.length);
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState().equals(ExceptionUtil.getSQLStateFromIdentifier("XJ078.S"))) {
                throw new ArrayIndexOutOfBoundsException(sQLException.getMessage());
            }
            throw sQLException;
        }
        ++this.updateCount;
        if (this.isBytes) {
            if (l + (long)n2 <= (long)this.bufferSize) {
                return this.updateData(byArray, n, n2, l);
            }
            this.init(this.dataBytes, l);
        }
        this.tmpFile.seek(l);
        this.tmpFile.write(byArray, n, n2);
        return this.tmpFile.getFilePointer();
    }

    synchronized int read(long l) throws IOException, SQLException, StandardException {
        this.isValidPostion(l);
        if (this.isBytes) {
            if ((long)this.dataBytes.length == l) {
                return -1;
            }
            return this.dataBytes[(int)l] & 0xFF;
        }
        if (this.tmpFile.getFilePointer() != l) {
            this.tmpFile.seek(l);
        }
        try {
            return this.tmpFile.readByte() & 0xFF;
        }
        catch (EOFException eOFException) {
            return -1;
        }
    }

    private int readBytes(byte[] byArray, int n, int n2, long l) {
        if (l >= (long)this.dataBytes.length) {
            return -1;
        }
        int n3 = this.dataBytes.length - (int)l;
        int n4 = n2 > n3 ? n3 : n2;
        byte[] byArray2 = new byte[n4];
        System.arraycopy(this.dataBytes, (int)l, byArray, n, n4);
        return n4;
    }

    synchronized int read(byte[] byArray, int n, int n2, long l) throws IOException, SQLException, StandardException {
        this.isValidPostion(l);
        this.isValidOffset(n, byArray.length);
        if (this.isBytes) {
            return this.readBytes(byArray, n, n2, l);
        }
        this.tmpFile.seek(l);
        return this.tmpFile.read(byArray, n, n2);
    }

    InputStream getInputStream(long l) {
        return new LOBInputStream(this, l);
    }

    OutputStream getOutputStream(long l) {
        return new LOBOutputStream(this, l);
    }

    long getLength() throws IOException {
        if (this.isBytes) {
            return this.dataBytes.length;
        }
        return this.tmpFile.length();
    }

    synchronized void truncate(long l) throws IOException, SQLException, StandardException {
        this.isValidPostion(l);
        if (this.isBytes) {
            byte[] byArray = new byte[(int)l];
            System.arraycopy(this.dataBytes, 0, byArray, 0, (int)l);
            this.dataBytes = byArray;
        } else if (l < (long)this.bufferSize) {
            this.dataBytes = new byte[(int)l];
            this.read(this.dataBytes, 0, this.dataBytes.length, 0L);
            this.isBytes = true;
            this.tmpFile.close();
            this.tmpFile = null;
        } else {
            try {
                this.tmpFile.setLength(l);
            }
            catch (StandardException standardException) {
                Util.generateCsSQLException(standardException);
            }
        }
    }

    synchronized void copyData(InputStream inputStream, long l) throws IOException, SQLException, StandardException {
        int n;
        byte[] byArray = new byte[this.bufferSize];
        for (long i = 0L; i < l; i += (long)n) {
            n = (int)Math.min(l - i, (long)this.bufferSize);
            if ((n = inputStream.read(byArray, 0, n)) < 0) {
                throw new EOFException("Reached end-of-stream prematurely at " + i);
            }
            this.write(byArray, 0, n, i);
        }
    }

    protected void finalize() throws Throwable {
        this.free();
    }

    private void deleteFile(StorageFile storageFile) throws IOException {
        try {
            final StorageFile storageFile2 = storageFile;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    storageFile2.delete();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    void free() throws IOException {
        this.dataBytes = null;
        if (this.tmpFile != null) {
            this.tmpFile.close();
            this.deleteFile(this.lobFile);
            this.tmpFile = null;
        }
    }

    synchronized long replaceBytes(byte[] byArray, long l, long l2) throws IOException, SQLException, StandardException {
        long l3 = this.getLength();
        long l4 = l3 - l2 + l + (long)byArray.length;
        if (this.isBytes) {
            if (l4 > (long)this.bufferSize) {
                byte[] byArray2 = this.dataBytes;
                this.init(byArray2, l);
                this.write(byArray, 0, byArray.length, this.getLength());
                if (l2 < l3) {
                    this.write(byArray2, (int)l2, (int)(l3 - l2), this.getLength());
                }
            } else {
                byte[] byArray3 = new byte[(int)l4];
                System.arraycopy(this.dataBytes, 0, byArray3, 0, (int)l);
                System.arraycopy(byArray, 0, byArray3, (int)l, byArray.length);
                if (l2 < l3) {
                    System.arraycopy(this.dataBytes, (int)l2, byArray3, (int)(l + (long)byArray.length), (int)(l3 - l2));
                }
                this.dataBytes = byArray3;
            }
        } else {
            int n;
            int n2;
            byte[] byArray4 = new byte[]{};
            LOBFile lOBFile = this.tmpFile;
            StorageFile storageFile = this.lobFile;
            this.init(byArray4, 0L);
            byte[] byArray5 = new byte[1024];
            lOBFile.seek(0L);
            for (long i = l; i != 0L && (n2 = lOBFile.read(byArray5, 0, n = (int)Math.min(1024L, i))) != -1; i -= (long)n2) {
                this.tmpFile.write(byArray5, 0, n2);
            }
            this.tmpFile.write(byArray);
            lOBFile.seek(l2);
            if (l2 < l3) {
                while ((n = lOBFile.read(byArray5, 0, 1024)) != -1) {
                    this.tmpFile.write(byArray5, 0, n);
                }
                lOBFile.close();
                this.deleteFile(storageFile);
            }
        }
        ++this.updateCount;
        return l + (long)byArray.length;
    }

    long getUpdateCount() {
        return this.updateCount;
    }
}

