r"""
Combinatorics
=============

Introductory material
---------------------

- :ref:`sage.combinat.quickref`
- :ref:`sage.combinat.tutorial`

Thematic indexes
----------------

- :ref:`sage.combinat.algebraic_combinatorics`

  - :ref:`sage.combinat.cluster_algebra_quiver`
  - :ref:`sage.combinat.crystals`
  - :ref:`sage.combinat.root_system`
  - :ref:`sage.combinat.sf`

- :ref:`sage.combinat.counting`
- :ref:`sage.combinat.enumerated_sets`
- :ref:`sage.combinat.catalog_partitions`
- :ref:`sage.combinat.finite_state_machine`
- :ref:`sage.combinat.species`
- :ref:`sage.combinat.designs`
- :ref:`sage.combinat.posets`
- :ref:`sage.combinat.words`

Utilities
---------

- :ref:`sage.combinat.output`
- :ref:`sage.combinat.ranker`
- :func:`Combinatorial maps <sage.combinat.combinatorial_map.combinatorial_map>`
- :ref:`sage.combinat.misc`

Related topics
--------------

- :ref:`sage.coding`
- :ref:`sage.dynamics`
- :ref:`sage.graphs`

"""
from . import quickref
from . import tutorial
