These examples demonstrate some of the functionality of the python-modelcif
software. See [the documentation](https://python-modelcif.readthedocs.io/)
for more information.

 - [convert\_bcif.py](convert_bcif.py) converts an mmCIF file containing
   ModelCIF data to [BinaryCIF](https://github.com/molstar/BinaryCIF) format.
 - [ligands.py](ligands.py) demonstrates writing an mmCIF file of a typical
   single-template homology or comparative model, including a ligand.
 - [mkmodbase.py](mkmodbase.py) demonstrates using the library to make an mmCIF
   file of a typical single-template single-chain homology or comparative
   model, similar to those generated by
   [MODELLER](https://salilab.org/modeller/) and deposited in the
   [ModBase database](https://modbase.compbio.ucsf.edu/).
 - [associated.py](associated.py) demonstrates reading a deposition from
   [ModelArchive](https://www.modelarchive.org/) that has been split into
   multiple mmCIF files.
 - [validate\_mmcif.py](validate_mmcif.py) demonstrates the use of the
   library's validator to validate a user-provided input mmCIF file against the
   [ModelCIF dictionary](https://mmcif.wwpdb.org/dictionaries/mmcif_ma.dic/Index/).
 - [validate\_modbase.py](validate_modbase.py) demonstrates downloading an
   mmCIF structure from the [ModBase database](https://modbase.compbio.ucsf.edu/)
   and validating it against the
   [ModelCIF dictionary](https://mmcif.wwpdb.org/dictionaries/mmcif_ma.dic/Index/)
    for compliance.
