[![Build Status](https://circleci.com/gh/ybrliiu/p5-Types-TypedCodeRef.svg)](https://circleci.com/gh/ybrliiu/p5-Types-TypedCodeRef) [![Coverage Status](http://codecov.io/github/ybrliiu/p5-Types-TypedCodeRef/coverage.svg?branch=master)](https://codecov.io/github/ybrliiu/p5-Types-TypedCodeRef?branch=master) [![MetaCPAN Release](https://badge.fury.io/pl/Types-TypedCodeRef.svg)](https://metacpan.org/release/Types-TypedCodeRef)
# NAME

Types::TypedCodeRef - Type constraint for any typed subroutine.

# SYNOPSIS

    use Test2::V0;
    use Types::TypedCodeRef -types;
    use Types::Standard -types;
    use Sub::WrapInType qw( wrap_sub );
    
    my $type = TypedCodeRef[ [Int, Int] => Int ];
    ok $type->check(wrap_sub [Int, Int] => Int, sub { $_[0] + $_[1] });
    ok !$type->check(0);
    ok !$type->check([]);
    ok !$type->check(sub {});

# DESCRIPTION

Types::TypedCodeRef is type constraint for any typed subroutine (example, generated by Sub::WrapInType).

# TYPES

## TypedCodeRef\[\`p, \`r\]

Only accepts typed subroutines.
A typed subroutine is a code reference in which the type of the parameter and the type of the return value are defined.
Types::TypedCodeRef is designed to inspect typed subroutines generated by Sub::WrapInType, but it is extensible enough to inspect typed subroutines created in other ways as well.

The first type parameter is the subroutine parameters type, and the second type parameter is the subroutine return values type.

# LICENSE

Copyright (C) ybrliiu.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

# AUTHOR

ybrliiu <raian@reeshome.org>

# SEE ALSO

[Sub::WrapInType](https://metacpan.org/pod/Sub%3A%3AWrapInType)

[Type::Tiny](https://metacpan.org/pod/Type%3A%3ATiny)
