# Generated by default/object.tt
package Paws::DMS::MicrosoftSQLServerSettings;
  use Moose;
  has BcpPacketSize => (is => 'ro', isa => 'Int');
  has ControlTablesFileGroup => (is => 'ro', isa => 'Str');
  has DatabaseName => (is => 'ro', isa => 'Str');
  has Password => (is => 'ro', isa => 'Str');
  has Port => (is => 'ro', isa => 'Int');
  has QuerySingleAlwaysOnNode => (is => 'ro', isa => 'Bool');
  has ReadBackupOnly => (is => 'ro', isa => 'Bool');
  has SafeguardPolicy => (is => 'ro', isa => 'Str');
  has SecretsManagerAccessRoleArn => (is => 'ro', isa => 'Str');
  has SecretsManagerSecretId => (is => 'ro', isa => 'Str');
  has ServerName => (is => 'ro', isa => 'Str');
  has UseBcpFullLoad => (is => 'ro', isa => 'Bool');
  has Username => (is => 'ro', isa => 'Str');
  has UseThirdPartyBackupDevice => (is => 'ro', isa => 'Bool');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DMS::MicrosoftSQLServerSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DMS::MicrosoftSQLServerSettings object:

  $service_obj->Method(Att1 => { BcpPacketSize => $value, ..., UseThirdPartyBackupDevice => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DMS::MicrosoftSQLServerSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->BcpPacketSize

=head1 DESCRIPTION

Provides information that defines a Microsoft SQL Server endpoint.

=head1 ATTRIBUTES


=head2 BcpPacketSize => Int

The maximum size of the packets (in bytes) used to transfer data using
BCP.


=head2 ControlTablesFileGroup => Str

Specifies a file group for the AWS DMS internal tables. When the
replication task starts, all the internal AWS DMS control tables
(awsdms_ apply_exception, awsdms_apply, awsdms_changes) are created for
the specified file group.


=head2 DatabaseName => Str

Database name for the endpoint.


=head2 Password => Str

Endpoint connection password.


=head2 Port => Int

Endpoint TCP port.


=head2 QuerySingleAlwaysOnNode => Bool

Cleans and recreates table metadata information on the replication
instance when a mismatch occurs. An example is a situation where
running an alter DDL statement on a table might result in different
information about the table cached in the replication instance.


=head2 ReadBackupOnly => Bool

When this attribute is set to C<Y>, AWS DMS only reads changes from
transaction log backups and doesn't read from the active transaction
log file during ongoing replication. Setting this parameter to C<Y>
enables you to control active transaction log file growth during full
load and ongoing replication tasks. However, it can add some source
latency to ongoing replication.


=head2 SafeguardPolicy => Str

Use this attribute to minimize the need to access the backup log and
enable AWS DMS to prevent truncation using one of the following two
methods.

I<Start transactions in the database:> This is the default method. When
this method is used, AWS DMS prevents TLOG truncation by mimicking a
transaction in the database. As long as such a transaction is open,
changes that appear after the transaction started aren't truncated. If
you need Microsoft Replication to be enabled in your database, then you
must choose this method.

I<Exclusively use sp_repldone within a single task>: When this method
is used, AWS DMS reads the changes and then uses sp_repldone to mark
the TLOG transactions as ready for truncation. Although this method
doesn't involve any transactional activities, it can only be used when
Microsoft Replication isn't running. Also, when using this method, only
one AWS DMS task can access the database at any given time. Therefore,
if you need to run parallel AWS DMS tasks against the same database,
use the default method.


=head2 SecretsManagerAccessRoleArn => Str

The full Amazon Resource Name (ARN) of the IAM role that specifies AWS
DMS as the trusted entity and grants the required permissions to access
the value in C<SecretsManagerSecret>. C<SecretsManagerSecret> has the
value of the AWS Secrets Manager secret that allows access to the SQL
Server endpoint.

You can specify one of two sets of values for these permissions. You
can specify the values for this setting and C<SecretsManagerSecretId>.
Or you can specify clear-text values for C<UserName>, C<Password>,
C<ServerName>, and C<Port>. You can't specify both. For more
information on creating this C<SecretsManagerSecret> and the
C<SecretsManagerAccessRoleArn> and C<SecretsManagerSecretId> required
to access it, see Using secrets to access AWS Database Migration
Service resources
(https://docs.aws.amazon.com/https:/docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager)
in the I<AWS Database Migration Service User Guide>.


=head2 SecretsManagerSecretId => Str

The full ARN, partial ARN, or friendly name of the
C<SecretsManagerSecret> that contains the SQL Server endpoint
connection details.


=head2 ServerName => Str

Fully qualified domain name of the endpoint.


=head2 UseBcpFullLoad => Bool

Use this to attribute to transfer data for full-load operations using
BCP. When the target table contains an identity column that does not
exist in the source table, you must disable the use BCP for loading
table option.


=head2 Username => Str

Endpoint connection user name.


=head2 UseThirdPartyBackupDevice => Bool

When this attribute is set to C<Y>, DMS processes third-party
transaction log backups if they are created in native format.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

