
package Google::Ads::AdWords::v201109_1::AccountService::get;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'https://adwords.google.com/api/adwords/account/v201109_1' }

__PACKAGE__->__set_name('get');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %accountSelector_of :ATTR(:get<accountSelector>);

__PACKAGE__->_factory(
    [ qw(        accountSelector

    ) ],
    {
        'accountSelector' => \%accountSelector_of,
    },
    {
        'accountSelector' => 'Google::Ads::AdWords::v201109_1::AccountSelector',
    },
    {

        'accountSelector' => 'accountSelector',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

Google::Ads::AdWords::v201109_1::AccountService::get

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
get from the namespace https://adwords.google.com/api/adwords/account/v201109_1.

Returns a list of account specified by the {@code accountSelectors}. @param accountSelector filter to select the account @return requested accounts ordered based on the requested ids in accountSelector 





=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * accountSelector

 $element->set_accountSelector($data);
 $element->get_accountSelector();





=back


=head1 METHODS

=head2 new

 my $element = Google::Ads::AdWords::v201109_1::AccountService::get->new($data);

Constructor. The following data structure may be passed to new():

 {
   accountSelector =>  $a_reference_to, # see Google::Ads::AdWords::v201109_1::AccountSelector
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

