package Google::Ads::AdWords::v201109::RelatedToKeywordSearchParameter;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/o/v201109' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201109::SearchParameter);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %SearchParameter__Type_of :ATTR(:get<SearchParameter__Type>);
my %keywords_of :ATTR(:get<keywords>);

__PACKAGE__->_factory(
    [ qw(        SearchParameter__Type
        keywords

    ) ],
    {
        'SearchParameter__Type' => \%SearchParameter__Type_of,
        'keywords' => \%keywords_of,
    },
    {
        'SearchParameter__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'keywords' => 'Google::Ads::AdWords::v201109::Keyword',
    },
    {

        'SearchParameter__Type' => 'SearchParameter.Type',
        'keywords' => 'keywords',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201109::RelatedToKeywordSearchParameter

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
RelatedToKeywordSearchParameter from the namespace https://adwords.google.com/api/adwords/o/v201109.

A {@link SearchParameter} for {@code KEYWORD} and {@code PLACEMENT} {@link IdeaType}s that specifies a generic keyword that results should be related to. <p>This search parameter can be used in bulk keyword requests through the {@link com.google.ads.api.services.targetingideas.TargetingIdeaService#getBulkKeywordIdeas(TargetingIdeaSelector)} method. <p>This element is supported by following {@link IdeaType}s: KEYWORD, PLACEMENT. <p>This element is supported by following {@link RequestType}s: IDEAS, STATS. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * keywords




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201109::RelatedToKeywordSearchParameter
   keywords =>  $a_reference_to, # see Google::Ads::AdWords::v201109::Keyword
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

