#!perl

use strict;
use warnings;

# This test was generated by inc::CheckJiraInChanges

use Test::More;

plan skip_all => "Disabled" if $ENV{NO_JIRA_CHECK};

my @commits = split /\n/, <<'EOC';
69d127fb PERL-841 Remove Try::Tiny from dependency list
3acf54d1 PERL-1061 Fix mongodb+srv boolean option parsing
17474ca9 PERL-1046 Skip tests on sharded clusters
5d729245 PERL-1046: Update tests for sharded and RS envs
eb04d174 PERL-1046 Add database aggregation method
d8d81c70 PERL-1041 Check bulk error can call result before calling it
c9096d99 PERL-920: Custom Server Selector
9dc04bf0 PERL-1008: Support index all paths
31644d10 PERL-785: Factor out read pref constants
e06f12b5 (shadowcat/master) PERL-1033 Fix docs link to BSON/wrap_numbers
8adfeee4 PERL-996 make write concern tests robust vs perl/dep versions
b0de0061 PERL-996 Ignore wtimeout in transactions spec tests
0401174f PERL-996 Revise wtimeout defaults
7b702557 PERL-785: Update logic for idle server
8b199aa1 PERL-867 resynced download.json spec
3abb460b PERL-976 Update transaction spec tests
1c2f9114 PERL-921 Split 3.2+ and pre-3.2 bypass testing
18359dbe PERL-996 Resync read/write concern tests
1b13a3be PERL-921 Only send bypassDocumentValidation when true
28179ad4 PERL-841 Remove Try::Tiny usage
b15a34bc PERL-986: Update causal consistency example
ada8bf68 PERL-987 Deprecate CopyDB
328a62c5 PERL-993 Deprecate parallelCollectionScan
faba0ac5 PERL-930 Support BSON::Raw in pre-insert and pre-update
ea1b1cbf PERL-1004 CI: Update driver testing Evergreen builds
b892b081 PERL-1004 CI: Update dependency Evergreen builds
1f37a18d PERL-999 CI: test only threaded perl 5.16+ on ZAP
6b080664 PERL-942 CI: Add Windows-32 Evergreen testing
556044d0 PERL-1012 Clear session pool on reconnect after fork/thread
babf8abc PERL-1006 Enable retry_writes during testing
c0a57939 PERL-1006 Force specific tests to disable retry_writes. Fix retryable error check
813fa994 PERL-1006 Fix issue with retry_writes and unordered bulk
b508724d PERL-65 Removed TODO labels on tests that now pass
470ed6c8 PERL-935 removing redundant supports_retry_writes sub
3c06679b PERL-1005 Split evergreen tasks
888b8827 PERL-1005 Revert parallel testing
86efe3d8 PERL-1005 CI: limit parallel testing
229e4fd6 PERL-1005 Defend txn example test vs possible abort
b4e9882c PERL-745 CI: save mongo-orchestration logs
82bddea1 PERL-1003 CI: switch private test config from curl to s3.get
4c68a415 PERL-1004 CI: Test Perl 5.28; drop SUSE 12 s390x
4b593aa8 PERL-1003 CI: switch from curl to s3.get Evergreen command
a56c2e8f PERL-999 CI: Build dependencies on s390x RHEL 6.7
ef049c12 PERL-999 CI: Add RHEL 7.2 to s390x Toolchain for Evergreen
d5fa6ec9 PERL-942 CI: Add 32-bit Windows toolchain for Evergreen
ca3e82f4 PERL-1002: CI: test in parallel to avoid timeouts
ea8018b2 PERL-927 Skip count hint test before MongoDB 3.6
1876d15e PERL-927 Coerce hint to IxHash or BSON::Doc if not string
5b6e7d2a (shadowcat/TBSliver/PERL-988) PERL-988 Preserve index key order in results
2b15e6e7 PERL-970 Allow BSON::Doc as sort argument
94cb8153 PERL-780 added documentation for TCP keepalive
fdb215bf PERL-789 add support for $readPreference
3f4e395e PERL-789 Implement OP_MSG support
6c3c77ac PERL-994 Stop GridFSBucket::DownloadStream length of undef warnings
79ddd536 PERL-972 Amended transaction examples for session args to come last
588bcaa0 PERL-806 Check compatibility for SDAM tests
232b6264 PERL-974 Drop MMAPv1 testing
bc0da496 PERL-972 Amended transaction examples to utilise session
908266fd PERL-968 Re-enable release time spell check tests; fix more errors
51418df3 PERL-968 Fix spelling errors
bb77f42f PERL-949 Add Strawberry Perl 5.28.0 to toolchain
240a242b PERL-967 Document that X509 doesn't need username
73babe47 PERL-833 Test QueryResult destructor kills cursor
c10809cf PERL-958 Don't require BSON::XS on Windows XP or earlier
9fb2ea75 PERL-897 Limit use of nameOnly for non-name filters
669dda4d PERL-897 Add nameOnly option to list_collections
8a066835 PERL-959 Undefer constructor in the private constructor
d14b1517 PERL-953 Fix warning with default compression level
4f14019e PERL-952 Show how to upgrade v2 over v1 without shadows

EOC

my %ticket_map;
for my $commit ( @commits ) {
    next if $commit =~ /PERL-\d+:?\s+CI:/i;
    for my $ticket ( $commit =~ /PERL-(\d+)/g ) {
        next if $ENV{CHECK_JIRA_SKIP}
            && grep { $ticket eq $_ } split " ", $ENV{CHECK_JIRA_SKIP};
        $ticket_map{$ticket} ||= [];
        push @{$ticket_map{$ticket}}, $commit;
    }
}

# grab Changes lines from new version to next un-indented line
open my $fh, "<:encoding(UTF-8)", "Changes";
my $changelog = do { local $/; <$fh> };

my @bad;
for my $ticket ( keys %ticket_map ) {
    if ( index( $changelog, "PERL-$ticket" ) < 0 ) {
       push @bad, $ticket;
    }
}

if ( !@commits ) {
    pass("No commits with Jira tickets");
}
else {
    ok( ! scalar @bad, "Jira tickets in Changes")
        or diag "Jira tickets missing:\n"
        . join("\n", map { "  * $_" } map { @{$ticket_map{$_}} } sort { $a <=> $b } @bad );
}

done_testing();
