# todo, native Windows needs a different pl($@)

use Test::Simple tests => 21;

# chdir to t/
$_ = $0;
s~[^/]+$~~;
chdir $_;

sub pl($@) {
    my $expect = shift;
    open my $fh, '-|', $^X, '../pl', @_;
    local $/;
    my $ret = <$fh>;
    ok $ret eq $expect, "pl @_";
    print "got: '$ret', expected: '$expect'\n" if $ret ne $expect;
}

sub alter(&@) {
    local $_ = $_;
    shift->();
    pl $_, @_;
}


my @abc = <[abc].txt>;
my $abc = join '', @abc;
my $abcn = join "\n", @abc, '';

pl '', '-o', '', @abc;
pl $abc, '-o', 'E', @abc;
pl $abc, '-op', '', @abc;
pl 'b.txt', '-oP', '/b/', @abc;
pl $abcn, '-opl12', '', @abc;
pl $abc, '-Op', '$_ = $A', @abc;
pl $abcn, '-O', 'e $A', @abc;


my $copy = $_ = <<EOF;
0;a.txt;1;a,1:A A
0;a.txt;2;b,2:B B
0;a.txt;3;c,3:C C
1;b.txt;1;a,1:A A
1;b.txt;2;b,2:BB B
1;b.txt;3;d,4:D D
2;c.txt;1;a,1:A A
2;c.txt;2;c,3:C CC
2;c.txt;3;d,:DD D
2;c.txt;4;e,5:E EE
EOF

pl $_, '-nr', 'echoN "$ARGI;$ARGV;$.;$_"', @abc;
pl $_, '-nr', 'E "$I;$A;$.;$_"', @abc;
alter { s/([0-9]).+,[34].+\n(?:\1.+\n)*//gm } '-nr', 'last if /[34]/; E "$I;$A;$.;$_"', @abc;

{ my $i = 0; s/;\K([1-9])(?=;)/++$i/eg } # convert $. to count across all files
pl $_, '-n', 'E "$I;$A;$.;$_"', @abc;
# remove each file's lines after [23], & again convert $. to count across all files
alter { s/([0-9]).+,[23].+\n\K(?:\1.+\n)*//gm; my $i = 0; s/;\K([1-9])(?=;)/++$i/eg } '-n', 'E "$I;$A;$.;$_"; last if /[23]/', @abc;

pl '', '-n', '', @abc;

s/.*;//mg; # reduce to only file contents
pl $_, '-n', 'E', @abc;
pl $_, '-ln', 'e', @abc;
pl $_, , '-p', '', @abc;
pl $_, , '-lp', '', @abc;

sub pl10($$) {
    my $sep = $_[1];
    alter { s/^(.+)$sep(.+)$/$2 $1/gm } $_[0], 'e @F[1, 0]', @abc;
}
pl10 '-al', ' ';
pl10 '-lF,', ',';
pl10 '-lF:', ':';
#pl10 '-034F:', ':';


# reproduce the splits that -054 will do
$_ = $copy;
s/^(.).*\K\n(?!\1)/\n][/mg; # different file numbers
chop; # extra [ on last line
s/[0-9].*;//mg; # reduce to only file contents
s/,/,][/g;
substr $_, 0, 0, '[';
pl $_, '-054n', 'E "[$_]"', @abc; # 054 is comma, also splits at file ends
