/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshIterator;
import bsh.Capabilities;
import bsh.Interpreter;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CollectionManager {
    private static CollectionManager manager;

    public static synchronized CollectionManager getCollectionManager() {
        if (manager == null && Capabilities.classExists("java.util.Collection")) {
            try {
                Class<?> clazz = Class.forName("bsh.collection.CollectionManagerImpl");
                manager = (CollectionManager)clazz.newInstance();
            }
            catch (Exception exception) {
                Interpreter.debug("unable to load CollectionManagerImpl: " + exception);
            }
        }
        if (manager == null) {
            manager = new CollectionManager();
        }
        return manager;
    }

    public boolean isBshIterable(Object object) {
        try {
            this.getBshIterator(object);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public BshIterator getBshIterator(Object object) throws IllegalArgumentException {
        return new BasicBshIterator(object);
    }

    public boolean isMap(Object object) {
        return object instanceof Hashtable;
    }

    public Object getFromMap(Object object, Object object2) {
        return ((Hashtable)object).get(object2);
    }

    public Object putInMap(Object object, Object object2, Object object3) {
        return ((Hashtable)object).put(object2, object3);
    }

    public static class BasicBshIterator
    implements BshIterator {
        Enumeration enumeration;

        public BasicBshIterator(Object object) {
            this.enumeration = this.createEnumeration(object);
        }

        protected Enumeration createEnumeration(Object object) {
            if (object == null) {
                throw new NullPointerException("Object arguments passed to the BasicBshIterator constructor cannot be null.");
            }
            if (object instanceof Enumeration) {
                return (Enumeration)object;
            }
            if (object instanceof Vector) {
                return ((Vector)object).elements();
            }
            if (object.getClass().isArray()) {
                Object object2 = object;
                return new Enumeration(this, object2){
                    int index;
                    int length;
                    private final /* synthetic */ Object val$array;
                    private final /* synthetic */ BasicBshIterator this$0;
                    {
                        this.this$0 = basicBshIterator;
                        this.val$array = object;
                        this.index = 0;
                        this.length = Array.getLength(this.val$array);
                    }

                    public Object nextElement() {
                        return Array.get(this.val$array, this.index++);
                    }

                    public boolean hasMoreElements() {
                        return this.index < this.length;
                    }
                };
            }
            if (object instanceof String) {
                return this.createEnumeration(((String)object).toCharArray());
            }
            if (object instanceof StringBuffer) {
                return this.createEnumeration(object.toString().toCharArray());
            }
            throw new IllegalArgumentException("Cannot enumerate object of type " + object.getClass());
        }

        public Object next() {
            return this.enumeration.nextElement();
        }

        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }
    }
}

