/*
 * $Id: ddefine.h,v 1.6 1994/06/28 02:06:51 kuwa Exp $
 */
/*
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991, 1992
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that all of the following conditions are satisfied:
 *
 * 1) The above copyright notices appear in all copies
 * 2) Both those copyright notices and this permission notice appear
 *    in supporting documentation
 * 3) The name of "Wnn" isn't changed unless substantial modifications
 *    are made, or
 * 3') Following words followed by the above copyright notices appear
 *    in all supporting documentation of software based on "Wnn":
 *
 *   "This software is based on the original version of Wnn developed by
 *    Kyoto University Research Institute for Mathematical Sciences (KURIMS),
 *    OMRON Corporation and ASTEC Inc."
 *
 * 4) The names KURIMS, OMRON and ASTEC not be used in advertising or
 *    publicity pertaining to distribution of the software without
 *    specific, written prior permission
 *
 * KURIMS, OMRON and ASTEC make no representations about the suitability
 * of this software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 * Wnn consortium is one of distributors of the official Wnn source code
 * release.  Wnn consortium also makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * KURIMS, OMRON, ASTEC AND WNN CONSORTIUM DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL KURIMS, OMRON, ASTEC OR
 * WNN CONSORTIUM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */
/*	Version 4.0
 */
/************************
 * define of daemon
 ************************/

/*
	!! !! !! !! !! !! !!
	<ctype.h>  󥯥롼ɤȤϡ
	Υե˥󥯥롼ɤ뤳
*/

#define SIZE_JISHOTABLE 1000  
#define SIZE_JISHOHEAP 2000

#define	KANGO_HINSI_MX	256		/* ʻκ */
#define	KANGO_VECT_L (KANGO_HINSI_MX+8*4-1)/(8*4) /* ³٥Ĺ */
#define	FZKVECT_L	5		/* °٥Ĺ */
#define	VECT_L	KANGO_VECT_L + FZKVECT_L /* ³٥Ĺ */
#ifdef nodef	/* This define doesn't need anymore, KUWARI */
#ifdef	CHINESE
#define	KANGO_VECT_KOSUU	256	/* ³٥κ */
#else
#define	KANGO_VECT_KOSUU	20	/* ³٥κ */
#endif	/* CHINESE */
#endif /* nodef */

struct	fzkkouho {		/* used in reffering to fuzokugo jouhou 
				 fuzokugo jouhou is stored using this struct*/
	int	offset;
	int	vector[KANGO_VECT_L];	/* 콪ü٥ */
};

/* macro C(i , j)  is useful for finding a pointer which points out 
   the first jishoentry whose yomi starts at i and endes at j
   which returns NULL if there is no entry which matches this
*/

#define	C(i,j)	(j > maxj[i] ? (struct jdata *)NULL : *(jmtp[i] + (j - i)))


/* #define	FZKIBNO	10 */
#define	FZKIBNO	5

/* °Ϸ */
struct	ICHBNP {
	struct	ICHBNP	*next_p;
	struct	fzkkouho fzkib[FZKIBNO];	/* vec βϷ */
	struct	fzkkouho fzkib1[FZKIBNO];	/* vec1 βϷ */
};
/* ¤ϡfzkib1->offset ϡߤäƤ */

#define	SV_KOSUU	3

#define	UJIS_A		0xa3c1	/*  */
#define UJIS_Z		0xa3da	/*  */
#define	UJIS_a		0xa3e1	/*  */
#define	UJIS_z		0xa3fa	/*  */
#ifdef CHINESE
#define	UJIS_comma	0xa3ac	/*  */
#define	S_PAREN		0xa1ae	/*  */
#define	E_PAREN		0xa1bf	/*  */
#else
# ifdef KOREAN
#define	UJIS_comma	0xa3ac	/*  */
#define	S_PAREN		0xa1ae	/*  */
#define	E_PAREN		0xa1bd	/*  */
# else
#define	UJIS_comma	0xa1a4	/*  */
#define	S_PAREN		0xa1c6	/*  */
#define	E_PAREN		0xa1db	/*  */
# endif
#endif /* CHINESE */
/*
#define	isdigit(x)	((unsigned)((x) - '0') <= ('9' - '0'))
#define	isalpha(x)	((unsigned)((x) - 'A') <= ('Z' - 'A') || \
			    (unsigned)((x) - 'a') <= ('z' - 'a'))
#define	isalnum(x)	(isalpha(x) || isdigit(x))
*/
#ifdef	isspace
#	undef	isspace	/* ctype.h  isspace() ϻȤʤ */
#endif
#define	isspace(x)	(((x) == ' ') || ((x) == 0x09))
#define	isjspace(x)	((x) == 0xa1a1)
#define	isparen_s(x)	(/* (x) == '\"' || */ (x) == '`' || \
/*  */		 (x) == '(' || (x) == '<' || \
			 (x) == '[' || (x) == '{')
#define	isparen_e(x)	((x) == '\"' || (x) == '\'' || \
/* ĳ */		 (x) == ')' || (x) == '>' || \
			 (x) == ']' || (x) == '}')

#define	isjdigit(x)	((unsigned)((x) - S_NUM) <= (E_NUM - S_NUM))
#define	isjalpha(x)	((unsigned)((x) - UJIS_A) <= (UJIS_Z - UJIS_A) || \
			 (unsigned)((x) - UJIS_a) <= (UJIS_z - UJIS_a))
#define	isjalnum(x)	(isjalpha(x) || isjdigit(x))
#define	isjhira(x)	((unsigned)((x) - S_HIRA) <= (E_HIRA - S_HIRA))
#define	isjkata(x)	((unsigned)((x) - S_KATA) <= (E_KATA - S_KATA))
#define	isj1bytekana(x)	((unsigned)((x) - S_HANKATA) <= (E_HANKATA - S_HANKATA))
# define S_KANJI	0xb0a1	/* 16 */
# define E_KANJI	0xfefe	/* 94 */
#ifdef	CHINESE
# define S_HANJI	0x20a1	/* 16 */
# define E_HANJI	0x7efe	/* 94 */
#define	isjkanji(x)	(((unsigned)((x) - S_KANJI) <= (E_KANJI - S_KANJI)) || \
			 ((unsigned)((x) - S_HANJI) <= (E_HANJI - S_HANJI)))
#define	isjparen(x)	((unsigned)((x) - S_PAREN) <= (E_PAREN - S_PAREN) || \
			 (x)==0xa3a8 || (x)==0xa3a9 ||  \
			 (x)==0xa3bc || (x)==0xa3be || \
			 (x)==0xa3db || (x)==0xa3dd || \
			 (x)==0xa3fb || (x)==0xa3fd )
			/*  for (  )  <  >  [  ]  { } */
#define	isjparen_s(x)	(((unsigned)((x) - S_PAREN) <= (E_PAREN - S_PAREN)) && \
			     (((x) & 0x01) == 0) || \
			 (x)==0xa3a8 || (x)==0xa3bc || \
			 (x)==0xa3db || (x)==0xa3fb )

#define	isjparen_e(x)	(((unsigned)((x) - S_PAREN) <= (E_PAREN - S_PAREN)) && \
			     (((x) & 0x01) == 1) || \
			 (x)==0xa3a9 || (x)==0xa3be || \
			 (x)==0xa3dd || (x)==0xa3fd )
#else
# ifdef KOREAN
#define S_HANJA	0xcaa1	/* ʡ */
#define E_HANJA	0xfdfe	/*  */
#define	isjkanji(x)	((unsigned)((x) - S_HANJA) <= (E_HANJA - S_HANJA))
#define	isjparen(x)	((unsigned)((x) - S_PAREN) <= (E_PAREN - S_PAREN) || \
			 (x)==0xa3a8 || (x) ==0xa3a9 || \
			 (x)==0xa3bc || (x) ==0xa3be || \
			 (x)==0xa3db || (x) ==0xa3dd || \
			 (x)==0xa3fb || (x) ==0xa3fc )
#define	isjparen_s(x)	(((unsigned)((x) - S_PAREN) <= (E_PAREN - S_PAREN)) && \
			    (((x) & 0x01) == 0) || \
			 (x)==0xa3a8 || (x)==0xa3bc || \
			 (x)==0xa3db || (x)==0xa3fb)
#define	isjparen_e(x)	(((unsigned)((x) - S_PAREN) <= (E_PAREN - S_PAREN)) && \
			    (((x) & 0x01) == 1) || \
			 (x) ==0xa3a9 || (x) ==0xa3be || \
			 (x) ==0xa3dd || (x) ==0xa3fc )
#define ishangul(x)	((unsigned)((x) - S_HANGUL) <= (E_HANGUL - S_HANGUL))
# else	/* JAPANESE */
#define	isjkanji(x)	((unsigned)((x) - S_KANJI) <= (E_KANJI - S_KANJI))
#define	isjparen(x)	((unsigned)((x) - S_PAREN) <= (E_PAREN - S_PAREN))
#define	isjparen_s(x)	(isjparen(x) && (((x) & 0x01) == 0))
#define	isjparen_e(x)	(isjparen(x) && ((x) & 0x01))
# endif	/* KOREAN */
#endif	/* CHINESE */

#define	UJIS_DKT	0xa1ab		/*  */
#define	UJIS_HDK	0xa1ac		/*  */

#define	BAR_CODE(x)	((x) == BAR)
#define	TOKU(x)	(((x) == UJIS_DKT) || ((x) == UJIS_HDK))

#define	TOKUSYU(x)	(TOKU(x) || isjkata(x) || isj1bytekana(x))
	/* this resembles macro before */

#define	kuten(x)	(((x)==KUTEN_NUM)? True:False)
#define	touten(x)	(((x)==TOUTEN_NUM)? True:False)

/* ü³٥ȥι¤ */
struct	kangovect	{
	unsigned int	vector[VECT_L];		/* ٥ȥ */
};

struct	SYO_BNSETSU {
	struct	SYO_BNSETSU	*lnk_br;	/* ¾ξʸؤΥݥ */
	struct	SYO_BNSETSU	*parent;	/* ξʸؤΥݥ */
	short	j_c;			/*  top index */
	short	i_jc;			/*  end index */
	short	bend_m;			/* ʸ end char index */
	int	v_jc;			/* ʸɾ */
	int	son_v;			/* ξʸޤǤɾͤι */
	struct	jdata	*jentptr;	/* ǡؤΥݥ */
	int	t_jc;			/* ʻ졢پΥǥå */
	int	kangovect;		/* ³٥ȥơ֥Υǥå */
	int	hinsi_fk;		/* ʻNo.(ʣʻޤ) */
	short	kbcnt;			/* ʸǲʸܤ */
	short	reference;		/* ξʸΥե󥹿 */
	short	status;			/* ʸ³Ǥ뤫 */
	short	status_bkwd;		/* ʸȤ³Ǥ뤫 */
};

struct	BZD	{
	struct	BZD	*lnk_br;	/* ¾ʸ */
	struct	BZD	*lnk_son;	/* ʸؤ pointer */
	short	j_c;			/*  top index */
	short	bend_m;			/* ʸ end char index */
	int	v_jc;			/* ʸɾ */
	int	son_v;			/* ʸɾ */
	struct	SYO_BNSETSU *sbn;	/* Ƭξʸ */
	short	sbn_cnt;		/* ʸ뾮ʸο */
	short	kbcnt;			/* ʸ˲ʸϤ  */
};

struct	JKT_SONE {
	struct	JKT_SONE *lnk_br;	/* ¾ξʸؤΥݥ */
	short	i_jc;			/*  end index */
	short	v_jc;			/* ʸɾ */
	struct	jdata	*jentptr;	/* ǡؤΥݥ */
	int	t_jc;			/* ʻ졢پΥǥå */
	int	hinsi_fk;		/* ʻNo.(ʣʻޤ) */
	short	status_bkwd;		/* ʸȤ³Ǥ뤫 */
};

struct	JKT_SBN {
	struct	JKT_SBN	*lnk_br;	/* ¾ξʸؤΥݥ */
	struct	JKT_SBN	*parent;	/* ξʸؤΥݥ */
	short	j_c;			/*  top index */
	short	bend_m;			/* ʸ end char index */
	struct	JKT_SONE *sbn;		/* ¾ξʸؤΥݥ */
	int	kangovect;		/* ³٥ȥơ֥Υǥå */
	short	kbcnt;			/* ʸǲʸܤ  */
	short	reference;		/* ξʸΥե󥹿 */
	short	status;			/* ʸ³Ǥ뤫 */
};

struct	JKT_DBN {
	struct	JKT_DBN	*lnk_br;	/* ¾ξʸؤΥݥ */
	short	j_c;			/*  top index */
	short	bend_m;			/* ʸ end char index */
	struct	JKT_SBN *sbn;		/* ¾ξʸؤΥݥ */
	int	v_jc;			/* ɾɾ */
	short	sbn_cnt;		/* ʸ뾮ʸο */
};

struct	DSD_SBN {
	short	bun_m;		/* ʸ end char index */
	short	bun_jc;		/* ʸ top char index */
	short	i_jc;		/* ʸμΩ end char index */
	struct	jdata *jentptr;	/* ʸμ entry pointer */
	int 	t_jc;		/* 伫Ωʻ &  index */ 
	int	hinsi;		/* ʻ */
	int	kangovect;	/* ³٥ȥơ֥Υǥå */
	int	v_jc;		/* ʸɾ */
	short	status;		/* ʸ³Ǥ뤫 */
	short	status_bkwd;	/* ʸȤ³Ǥ뤫 */
};

struct	DSD_DBN {
	short	bun_m;		/* ʸ end char index */
	short	bun_jc;		/* ʸ top char index */
	struct	DSD_SBN	*sbn;	/* ʸϷ̤ؤΥݥ */
	short	sbncnt;		/* ʸ (ξϡ)
				   DSD_SBNϡ*sbn  sbncnt  */
	int	v_jc;		/* ʸɾ */
};

#ifdef	nodef	/* move to jslib.h */
/* ʸľ򤷤 */
#define HIRAGANA	-1	/* Ҥ餬 *//* ɤߤΤޤ */
#define KATAKANA	-11	/*  */
/*  */
#define	NUM_HAN		-2	/* Ⱦѿ *//* ɤߤΤޤ */
#define	NUM_ZEN		-12	/* ѿ *//*  */
#define	NUM_KAN		-13	/*  *//*  */
#define	NUM_KANSUUJI	-15	/*  *//* ɴ󽽻 */
#define	NUM_KANOLD	-16	/*  *//* ɴ */
#define	NUM_HANCAN	-17	/* Ⱦѿ *//* 1,234 */
#define	NUM_ZENCAN	-18	/* ѿ *//*  */
/* ѿ */
#define	ALP_HAN		-4	/* Ⱦ *//* ɤߤΤޤ */
#define	ALP_ZEN		-30	/*  */
/*  */
#define	KIG_HAN		-5	/* Ⱦ *//* ɤߤΤޤ */
#define	KIG_JIS		-40	/* (JIS) */
#define	KIG_ASC		-41	/* (ASC) */
#endif	

#define	YES		1
#define	NO		0
#define	UN_KNOWN	-1

#define	NOTHING		0
