/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.MyCommonAST;
import com.puppycrawl.tools.checkstyle.Scope;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class MyModifierSet {
    private static final String[] JLS_ORDER = new String[]{"public", "protected", "private", "abstract", "static", "final", "transient", "volatile", "synchronized", "native", "strictfp"};
    private final List mModifiers = new ArrayList();
    private final List mModifierASTs = new ArrayList();
    private int mFirstLineNo = Integer.MAX_VALUE;
    private int mFirstColNo = 0;

    MyModifierSet() {
    }

    void addModifier(MyCommonAST aMCA) {
        if (aMCA.getLineNo() < this.mFirstLineNo) {
            this.mFirstLineNo = aMCA.getLineNo();
            this.mFirstColNo = aMCA.getColumnNo();
        }
        this.mModifiers.add(aMCA.getText());
        this.mModifierASTs.add(aMCA);
    }

    int size() {
        return this.mModifiers.size();
    }

    int getFirstLineNo() {
        return this.mFirstLineNo;
    }

    int getFirstColNo() {
        return this.mFirstColNo;
    }

    boolean containsStatic() {
        return this.mModifiers.contains("static");
    }

    boolean containsFinal() {
        return this.mModifiers.contains("final");
    }

    boolean containsPrivate() {
        return this.mModifiers.contains("private");
    }

    boolean containsProtected() {
        return this.mModifiers.contains("protected");
    }

    boolean containsPublic() {
        return this.mModifiers.contains("public");
    }

    boolean containsAbstract() {
        return this.mModifiers.contains("abstract");
    }

    Scope getVisibilityScope() {
        if (this.containsPublic()) {
            return Scope.PUBLIC;
        }
        if (this.containsProtected()) {
            return Scope.PROTECTED;
        }
        if (this.containsPrivate()) {
            return Scope.PRIVATE;
        }
        return Scope.PACKAGE;
    }

    MyCommonAST checkOrderSuggestedByJLS() {
        MyCommonAST modifier;
        int i = 0;
        Iterator it = this.mModifierASTs.iterator();
        do {
            if (!it.hasNext()) {
                return null;
            }
            modifier = (MyCommonAST)it.next();
            while (i < JLS_ORDER.length && !JLS_ORDER[i].equals(modifier.getText())) {
                ++i;
            }
        } while (i < JLS_ORDER.length);
        return modifier;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("MyModifierSet [ ");
        Iterator it = this.mModifiers.iterator();
        while (it.hasNext()) {
            buf.append((String)it.next());
            buf.append(" ");
        }
        buf.append("]");
        return buf.toString();
    }
}

