(defun ess-sqpe-versions-create ()
  "Generate the `M-x splusxy' functions for starting other versions
of Sqpe.  See `ess-sqpe-versions' for strings that determine which
functions are created."
  ;; This works by creating a temp buffer where the template function is
  ;; edited so that Sqpe+template is replaced by the version name.
  (let ((beg)
	(versions)
	(version)
	(eval-buf (get-buffer-create "*ess-temp-sqpe-evals*"))
	)
    ;;
    (save-excursion
      (set-buffer eval-buf)
      ;; clear the buffer.
      (delete-region (point-min) (point-max))

      ;; Find which versions of Sqpe we want.
      (setq versions (ess-uniq-list ess-SHOME-versions))
      ;; Iterate over each string in VERSIONS, creating a new defun each time.
      (while versions
	(setq version (car versions)
	      versions (cdr versions))
	(if (file-executable-p version)
	    (progn
	      (setq beg (point))
	      (prin1 (symbol-function 'Sqpe+template) eval-buf)
	      (insert "\n\n")
	      (goto-char beg)
	      (while (search-forward "lambda" nil t 1)
		(replace-match
		 (concat "defun " (file-name-nondirectory version))
		 t t))
	      (while (search-forward "ess-SHOME" nil t)
		(replace-match version t t))
	      (goto-char (point-max))
	      (ess-write-to-dribble-buffer
	       (format
		"(Sqpe): ess-sqpe-versions-create making M-x defun %s for %s \n"
		(file-name-nondirectory version) version))
	      )))
      ;; buffer has now been created with defuns, so eval them!
      (eval-buffer)
;      (kill-buffer eval-buf)
      )))

;; This is the union of all versions on several different machines.
;; Only ones that exist on your machine will generate a function.
;; The list of functions created appears in the *ESS* buffer.
(setq ess-SHOME-versions
      '("c:/progra~1/Insightful/splus62" ;; rmh home
	"c:/progra~1/Insightful/splus61" ;; rmh home
	"c:/progra~1/spls45se" ;; rmh home
	"y:/progra~1/Insightful/splus61netclient" ;; rmh work
	"c:/Progra~1/Insightful/splus61net/server" ;; rmh stat
	"c:/Progra~1/Insightful/splus6se" ;; rmh stat
	"d:/Apps/progra~1/Insightful/splus6" ;; rmh stat
	"d:/Apps/spls45se" ;; rmh stat
	"d:/OtherApps/MathSoft/splus6" ;; rmh stat
	"c:/progra~1/Insightful/splus61netclient" ;; stat0x
	))


;;; There are extra complications in Sqpe+6 (compared to S+3) because
;;; (1) The StatSci supplied Sqpe.exe won't work without SHOME as an
;;;     environment variable and Sqpe does not take command line
;;;     arguments and
;;; (2) Sqpe.exe comes up with options(interactive=F), which means it
;;;     doesn't provide prompts by default, and we must change it to T so
;;;     it will provide prompts.
;;;
(defun Sqpe+template (&optional proc-name)
  "Call 'Sqpe' from 'S-PLUS for Windows ess-SHOME',
the 'Real Thing'  from StatSci.
This function was generated by `ess-sqpe-versions-create'."
  (interactive)
  (setq ess-customize-alist Sqpe+6-customize-alist)
  (let* ((shome-old (getenv "SHOME"))
	 (inferior-Sqpe+6-SHOME-name "ess-SHOME")
	 (inferior-Sqpe+6-program-name (concat "ess-SHOME" "/cmd/sqpe.exe")))
    (setenv "SHOME" "ess-SHOME")
    (ess-write-to-dribble-buffer
     (format "\n(Sqpe+template): ess-dialect=%s, buf=%s\n" ess-dialect
	     (current-buffer)))
    (setq ess-customize-alist	 ; change inferior-ess-primary-prompt
	  (append ess-customize-alist
		  '((inferior-ess-primary-prompt   . "^"))))
    (inferior-ess)
    (setq ess-customize-alist Sqpe+6-customize-alist) ; restore i-e-p-p in alist
    (ess-setq-vars-local ess-customize-alist) ; restore i-e-p-p in buffer
    (setq inferior-ess-prompt		; define with correct i-e-p-p
	  ;; Do not anchor to bol with `^'       ; (copied from ess-inf.el)
	  (concat "\\("
		  inferior-ess-primary-prompt
		  "\\|"
		  inferior-ess-secondary-prompt
		  "\\)"))
    (setq comint-prompt-regexp (concat "^" inferior-ess-prompt))
					; define with correct i-e-p-p
    (setq comint-input-sender 'inferior-ess-input-sender)
    (add-hook 'comint-output-filter-functions 'shell-strip-ctrl-m nil t)
    (goto-char (point-max))
    (insert "options(interactive=T)")
    (inferior-ess-send-input)
    (setq mode-name "iESS(Sqpe)")
    ;;  (ess-eval-linewise inferior-S+6-editor-pager-command)
    (if inferior-ess-language-start
	(ess-eval-linewise inferior-ess-language-start))
    (setenv "SHOME" shome-old)))
