/*  gnutrition - a nutrition and diet analysis program.
 *  Copyright (C) 2000 Edgar Denny (e.denny@ic.ac.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>
#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>
#include <ctype.h>

#include "text_util.h"
#include "food.h"
#include "recipe.h"
#include "recipe_win.h"
#include "support.h"
#include "nutr_comp_dlg.h"

static void 
compute_percent_nutrient_goal( void);

/* Display the nutrition composition dialog. */
void
display_nutrient_dialog()
{
	GtkWidget *entry, *nutr_comp_win;
	GladeXML *xml = gnutr_ret_xml();
	gchar *text;
	Recipe_t *recipe = gnutr_ret_recipe();

	/* The nutrient values. */

	/* macro-nutrients. */

	entry = glade_xml_get_widget( xml, "protein_ndlg_entry");
	text = ftoa( recipe->nutr->total[0]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_ndlg_entry");
	text = ftoa( recipe->nutr->total[1]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "sat_fat_ndlg_entry");
	text = ftoa( recipe->nutr->total[52]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "mono_fat_ndlg_entry");
	text = ftoa( recipe->nutr->total[76]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "poly_fat_ndlg_entry");
	text = ftoa( recipe->nutr->total[77]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "carb_ndlg_entry");
	text = ftoa( recipe->nutr->total[2]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "chol_ndlg_entry");
	text = ftoa( recipe->nutr->total[51]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fiber_ndlg_entry");
	text = ftoa( recipe->nutr->total[11]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "kj_ndlg_entry");
	text = ftoa( recipe->nutr->total[9]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "kcal_ndlg_entry");
	text = ftoa( recipe->nutr->total[4]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	/* micro-nutrients. */

	entry = glade_xml_get_widget( xml, "vita_ndlg_entry");
	text = ftoa( recipe->nutr->total[22]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "vite_ndlg_entry");
	text = ftoa( recipe->nutr->total[24]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "vitc_ndlg_entry");
	text = ftoa( recipe->nutr->total[25]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "thia_ndlg_entry");
	text = ftoa( recipe->nutr->total[26]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "ribo_ndlg_entry");
	text = ftoa( recipe->nutr->total[27]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "nia_ndlg_entry");
	text = ftoa( recipe->nutr->total[28]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "panto_ndlg_entry");
	text = ftoa( recipe->nutr->total[29]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "vitb6_ndlg_entry");
	text = ftoa( recipe->nutr->total[30]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fol_ndlg_entry");
	text = ftoa( recipe->nutr->total[31]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "vitb12_ndlg_entry");
	text = ftoa( recipe->nutr->total[32]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "ca_ndlg_entry");
	text = ftoa( recipe->nutr->total[12]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fe_ndlg_entry");
	text = ftoa( recipe->nutr->total[13]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "mg_ndlg_entry");
	text = ftoa( recipe->nutr->total[14]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "p_ndlg_entry");
	text = ftoa( recipe->nutr->total[15]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "k_ndlg_entry");
	text = ftoa( recipe->nutr->total[16]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "na_ndlg_entry");
	text = ftoa( recipe->nutr->total[17]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "zn_ndlg_entry");
	text = ftoa( recipe->nutr->total[18]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "cu_ndlg_entry");
	text = ftoa( recipe->nutr->total[19]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "mn_ndlg_entry");
	text = ftoa( recipe->nutr->total[20]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "se_ndlg_entry");
	text = ftoa( recipe->nutr->total[21]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	/* proteins */
	entry = glade_xml_get_widget( xml, "tryp_ndlg_entry");
	text = ftoa( recipe->nutr->total[33]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "thre_ndlg_entry");
	text = ftoa( recipe->nutr->total[34]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "isol_ndlg_entry");
	text = ftoa( recipe->nutr->total[35]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "leuc_ndlg_entry");
	text = ftoa( recipe->nutr->total[36]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "lysi_ndlg_entry");
	text = ftoa( recipe->nutr->total[37]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "meth_ndlg_entry");
	text = ftoa( recipe->nutr->total[38]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "cyst_ndlg_entry");
	text = ftoa( recipe->nutr->total[39]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "phen_ndlg_entry");
	text = ftoa( recipe->nutr->total[40]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "tyro_ndlg_entry");
	text = ftoa( recipe->nutr->total[41]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "vali_ndlg_entry");
	text = ftoa( recipe->nutr->total[42]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "argi_ndlg_entry");
	text = ftoa( recipe->nutr->total[43]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "hist_ndlg_entry");
	text = ftoa( recipe->nutr->total[44]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "alan_ndlg_entry");
	text = ftoa( recipe->nutr->total[45]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "aspa_ndlg_entry");
	text = ftoa( recipe->nutr->total[46]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "glut_ndlg_entry");
	text = ftoa( recipe->nutr->total[47]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "glyc_ndlg_entry");
	text = ftoa( recipe->nutr->total[48]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "prol_ndlg_entry");
	text = ftoa( recipe->nutr->total[49]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "seri_ndlg_entry");
	text = ftoa( recipe->nutr->total[50]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	/* fats */
	entry = glade_xml_get_widget( xml, "fat_4d0_ndlg_entry");
	text = ftoa( recipe->nutr->total[53]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_6d0_ndlg_entry");
	text = ftoa( recipe->nutr->total[54]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_8d0_ndlg_entry");
	text = ftoa( recipe->nutr->total[55]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_10d0_ndlg_entry");
	text = ftoa( recipe->nutr->total[56]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_12d0_ndlg_entry");
	text = ftoa( recipe->nutr->total[57]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_14d0_ndlg_entry");
	text = ftoa( recipe->nutr->total[58]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_16d0_ndlg_entry");
	text = ftoa( recipe->nutr->total[59]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_18d0_ndlg_entry");
	text = ftoa( recipe->nutr->total[60]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_20d0_ndlg_entry");
	text = ftoa( recipe->nutr->total[61]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_18d1_ndlg_entry");
	text = ftoa( recipe->nutr->total[62]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_18d2_ndlg_entry");
	text = ftoa( recipe->nutr->total[63]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_18d3_ndlg_entry");
	text = ftoa( recipe->nutr->total[64]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_20d4_ndlg_entry");
	text = ftoa( recipe->nutr->total[65]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_22d6_ndlg_entry");
	text = ftoa( recipe->nutr->total[66]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_22d0_ndlg_entry");
	text = ftoa( recipe->nutr->total[67]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_14d1_ndlg_entry");
	text = ftoa( recipe->nutr->total[68]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_16d1_ndlg_entry");
	text = ftoa( recipe->nutr->total[69]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_18d4_ndlg_entry");
	text = ftoa( recipe->nutr->total[70]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_20d1_ndlg_entry");
	text = ftoa( recipe->nutr->total[71]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_20d5_ndlg_entry");
	text = ftoa( recipe->nutr->total[72]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_22d1_ndlg_entry");
	text = ftoa( recipe->nutr->total[73]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_22d5_ndlg_entry");
	text = ftoa( recipe->nutr->total[74]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_15d0_ndlg_entry");
	text = ftoa( recipe->nutr->total[78]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_17d0_ndlg_entry");
	text = ftoa( recipe->nutr->total[79]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_24d0_ndlg_entry");
	text = ftoa( recipe->nutr->total[80]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	/* miscelaneous */
	entry = glade_xml_get_widget( xml, "ash_ndlg_entry");
	text = ftoa( recipe->nutr->total[3]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "alco_ndlg_entry");
	text = ftoa( recipe->nutr->total[5]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "water_ndlg_entry");
	text = ftoa( recipe->nutr->total[6]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "phyto_ndlg_entry");
	text = ftoa( recipe->nutr->total[75]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "theob_ndlg_entry");
	text = ftoa( recipe->nutr->total[8]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "caff_ndlg_entry");
	text = ftoa( recipe->nutr->total[7]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "sugar_ndlg_entry");
	text = ftoa( recipe->nutr->total[10]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	/* The percentage of the dietary goal. */

	/* macro-nutrients. */

	entry = glade_xml_get_widget( xml, "protein_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[0]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[1]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "sat_fat_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[52]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "mono_fat_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[76]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "poly_fat_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[77]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "carb_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[2]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "chol_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[51]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fiber_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[11]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "kj_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[9]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "kcal_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[4]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	/* micro-nutrients. */

	entry = glade_xml_get_widget( xml, "vita_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[22]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "vite_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[24]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "vitc_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[25]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "thia_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[26]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "ribo_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[27]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "nia_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[28]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "panto_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[29]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "vitb6_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[30]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fol_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[31]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "vitb12_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[32]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "ca_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[12]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fe_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[13]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "mg_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[14]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "p_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[15]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "k_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[16]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "na_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[17]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "zn_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[18]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "cu_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[19]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "mn_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[20]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "se_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[21]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	/* proteins */
	entry = glade_xml_get_widget( xml, "tryp_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[33]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "thre_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[34]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "isol_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[35]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "leuc_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[36]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "lysi_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[37]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "meth_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[38]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "cyst_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[39]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "phen_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[40]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "tyro_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[41]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "vali_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[42]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "argi_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[43]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "hist_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[44]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "alan_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[45]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "aspa_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[46]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "glut_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[47]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "glyc_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[48]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "prol_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[49]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "seri_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[50]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	/* fats */
	entry = glade_xml_get_widget( xml, "fat_4d0_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[53]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_6d0_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[54]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_8d0_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[55]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_10d0_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[56]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_12d0_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[57]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_14d0_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[58]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_16d0_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[59]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_18d0_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[60]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_20d0_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[61]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_18d1_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[62]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_18d2_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[63]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_18d3_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[64]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_20d4_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[65]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_22d6_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[66]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_22d0_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[67]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_14d1_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[68]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_16d1_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[69]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_18d4_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[70]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_20d1_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[71]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_20d5_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[72]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_22d1_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[73]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_22d5_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[74]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_15d0_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[78]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_17d0_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[79]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "fat_24d0_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[80]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	/* miscelaneous */
	entry = glade_xml_get_widget( xml, "ash_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[3]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "alco_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[5]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "water_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[6]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "phyto_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[75]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "theob_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[8]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "caff_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[7]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	entry = glade_xml_get_widget( xml, "sugar_dg_ndlg_entry");
	text = ftoa( recipe->nutr->pcnt_goal[10]);
	gtk_entry_set_text( GTK_ENTRY( entry), text);

	/* show the widget. */
	nutr_comp_win = glade_xml_get_widget( xml, "nutr_comp_dlg");
	gtk_widget_show( nutr_comp_win);
}

/* compute the percentage of the nutrient goal achieved
 * by the total nutrient values. */
static void 
compute_percent_nutrient_goal()
{
	Recipe_t *recipe = gnutr_ret_recipe();
	gint i;

	for( i=0; i<NO_NUTR; i++)
	{
		if ( recipe->nutr->goal[i] == 0.0 )
		{
			recipe->nutr->pcnt_goal[i] = 0.0;
		}
		else
		{
			recipe->nutr->pcnt_goal[i] = 100.0 *  recipe->nutr->total[i] / 
					( recipe->nutr->goal[i] * atof( recipe->no_serv));
		}
	}
}

/* When the "Nutrients" button is released in the recipe window, show
 * the nutritional composition dialog. */
void
on_mw_nutr_comp_released( GtkButton *button,
                          gpointer   user_data)
{
	GladeXML *xml = gnutr_ret_xml();
	Recipe_t *recipe = gnutr_ret_recipe();
	Food_t *food;
	gint i, row = 0;
	gchar  *amount = NULL;

	recipe->ingredient_clist = (GtkCList *)
			glade_xml_get_widget( xml, "mw_fd_clist");
	recipe->no_serv = gtk_entry_get_text( GTK_ENTRY(
			glade_xml_get_widget( xml, "mw_no_serv_entry")));

	if ( !all_digits( recipe->no_serv))
	{
		GtkWidget *message = glade_xml_get_widget( xml, "nserv_msgbox");
		gnome_dialog_close_hides( GNOME_DIALOG( message), TRUE);
		gtk_widget_show( message);
		return;
	}

	for( i=0; i<NO_NUTR; i++) recipe->nutr->total[i] = 0.0;

	while ( row < recipe->no_ingredients ) 
	{
		gtk_clist_get_text( recipe->ingredient_clist, row, 0, &amount);

		food = (Food_t *)gtk_clist_get_row_data( 
				recipe->ingredient_clist, row);

		for( i=0; i<NO_NUTR; i++) 
		{
			recipe->nutr->total[i] += ( 1.0/ atof( recipe->no_serv)) *
				( atof( food->nutrs->value[i]) * atof( amount) * 
				  atof( food->msre[food->sel_msre]->msre_weight) / 100.0);
		}
		row++;
	}
	compute_percent_nutrient_goal();
	display_nutrient_dialog();
}

/* When the "OK" button is pressed in the nutrient composition dialog,
 * hide the dialog. */
void
on_ndlg_ok_button_released( GtkButton *button,
                            gpointer   user_data)
{
	GladeXML *xml = gnutr_ret_xml();
	GtkWidget *widget = glade_xml_get_widget( xml, "nutr_comp_dlg");
	gtk_widget_hide( widget);
}
