/*
    GNUbik -- A 3 dimensional magic cube game.
    Copyright (C) 2003  John Darrington

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
static const char RCSID[]="$Id: widget-set-gtk.c,v 1.16 2004/01/21 13:37:24 jmd Exp $";

#include "widget-set.h"
#include "menus-gtk.h"
#include "colour-sel.h"
#include "version.h"
#include "guile-hooks.h"


#include <gtk/gtk.h>
#include <gdk/gdk.h>

#include <X11/Xlib.h>
#include <gdk/gdkx.h>
#include <gtk/gtkgl.h>

#include "drwBlock.h"



extern GtkWidget *main_application_window;

void
widget_set_init(int *argc, char *** argv)
{

  gtk_init(argc, argv);
  
  gtk_gl_init(argc,argv);

}


static GtkWidget *window;

t_widget
create_top_level_widget(void)
{

  GtkWidget *win;

  /* create a new window */
  win = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  g_signal_connect (GTK_OBJECT(win),"delete-event",
		      GTK_SIGNAL_FUNC(gtk_main_quit),0);


  window = win;

  return win;

}

t_widget
create_container_widget(t_widget parent)
{
  GtkWidget *vbox ;

  /* create a vbox to hold the drawing area and the menubar */
  vbox = gtk_vbox_new(FALSE,0);


  gtk_container_add (GTK_CONTAINER (parent), vbox);

  gtk_widget_show(vbox);

  return vbox;

}



static GtkWidget *statusbar;
extern int move_count;
#define MSGLEN 100
void
update_statusbar(void)
{

  static int context=0;

  static guint mesg_id = 0;
  
  gchar mesg[MSGLEN];

  if ( 0 == context )
    context  = gtk_statusbar_get_context_id(GTK_STATUSBAR(statusbar),
					     "move-count");


  g_snprintf(mesg,MSGLEN,_("Moves: %d"),move_count);

  if ( mesg_id != 0 ) 
    gtk_statusbar_remove(GTK_STATUSBAR(statusbar),context,mesg_id);

  mesg_id = gtk_statusbar_push(GTK_STATUSBAR(statusbar), context, mesg);

}

void
declare_win(Cube_Status status)
{
  static int context=0;

  static guint mesg_id = 0;
  
  gchar mesg[MSGLEN];

  if ( 0 == context ) 
    context  = gtk_statusbar_get_context_id(GTK_STATUSBAR(statusbar),
					     "win");

  switch (status ) {
  case SOLVED:
    g_snprintf(mesg,MSGLEN, ngettext ("Cube solved in %d move",
				      "Cube solved in %d moves", move_count),
	       move_count);
    break ;
  case HALF_SOLVED:
    g_snprintf(mesg,MSGLEN,_("Cube is NOT solved! The colours are correct, but have incorrect orientation"));
    break;
  default:
    g_assert_not_reached();
  }


  mesg_id = gtk_statusbar_push(GTK_STATUSBAR(statusbar), context, mesg);


  
}

t_widget
create_statusbar(t_widget container)
{


  statusbar = gtk_statusbar_new();
  
  gtk_box_pack_start (GTK_BOX (container), statusbar, FALSE, TRUE, 0);

  gtk_widget_show(statusbar);

  return statusbar;

}

t_widget
create_menubar(t_widget container,t_widget toplevel)
{
  GtkWidget *menubar;
  int i=0;


  static GtkItemFactoryEntry menu_items[] = {
    { 0,         NULL,         NULL, 0, "<Branch>" },
    { 0,     "<control>N", new_game, 0, NULL },
    { 0,     NULL,         NULL, 0, "<Separator>" },
    { 0,     "<control>Q", gtk_main_quit, 0, NULL },
    { 0,      NULL,         NULL, 0, "<Branch>" },
    { 0,  NULL, preferences, 0, NULL },
    { 0,  NULL, colour_select_menu, 0, 0 },
#if DEBUG
    { "/_Debug",        NULL,         NULL, 0, "<Branch>" },
    { "/_Debug/_Move",     NULL,      move, 0, NULL },
#endif
    { 0,         NULL,         NULL, 0, "<Branch>" },
    { 0,   NULL,     about, 0, NULL },
  };


  GtkItemFactory *item_factory;
  GtkAccelGroup *accel_group;
  gint nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);

  menu_items[i++].path=g_strdup(_("/_Game"));
  menu_items[i++].path=g_strdup(_("/_Game/_New Game"));
  menu_items[i++].path=g_strdup(_("/_Game/sep"));
  menu_items[i++].path=g_strdup(_("/_Game/_Quit"));

  menu_items[i++].path=g_strdup(_("/_Settings"));

  menu_items[i].path=g_strdup(_("/_Settings/_Preferences"));
  menu_items[i++].callback_action=(gint)toplevel;  


  menu_items[i].path=g_strdup(_("/_Settings/_Colours"));
  menu_items[i++].callback_action=(gint)toplevel;

#ifdef HAVE_GUILE
  menu_items[i++].path=g_strdup(/*_*/("/Script-_fu"));
#endif
  
  
#if DEBUG
  i+=2;
#endif
  menu_items[i++].path=g_strdup(_("/_Help"));

  menu_items[i].path=g_strdup(_("/_Help/_About"));
  menu_items[i++].callback_action=(gint)toplevel;

  accel_group = gtk_accel_group_new ();

  /* This function initializes the item factory.
     Param 1: The type of menu - can be GTK_TYPE_MENU_BAR, GTK_TYPE_MENU,
     or GTK_TYPE_OPTION_MENU.
     Param 2: The path of the menu.
     Param 3: A pointer to a gtk_accel_group.  The item factory sets up
     the accelerator table while generating menus.
  */

  item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", 
                                       accel_group);

  /* This function generates the menu items. Pass the item factory,
     the number of items in the array, the array itself, and and
     callback data for the the menu items. */
  gtk_item_factory_create_items (item_factory, nmenu_items, 
				 (GtkItemFactoryEntry*) menu_items, NULL);

  for(i = 0 ; i < nmenu_items ; ++i ) {
#if DEBUG
    if ( i == 7 || i == 8 ) 
      continue;
#endif
    g_free(menu_items[i].path);
  }

  
#ifdef HAVE_GUILE
  
 {
     /* Get the menu structure asked for by the collection of Guile scripts. */
     Menu_Item_List *list = startup_guile_scripts ();

     /* And use the factory to add the items to the menu. */
     for (; list; list = list->next)
         gtk_item_factory_create_item (item_factory,
                                       &list->entry,
                                       list->callback_data,
                                       1);
 }

#endif

  
  /* Attach the new accelerator group to the window. */
  gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);


    /* Finally, return the actual menu bar created by the item factory. */ 
  menubar = gtk_item_factory_get_widget (item_factory, "<main>");


  gtk_box_pack_start (GTK_BOX (container), menubar, FALSE, TRUE, 0);

  gtk_widget_show(menubar);

  return menubar;

}

void cleanup(void)
{
}


void
show_widget(t_widget w)
{
  gtk_widget_show(w);

}


void
start_main_loop()
{
  gtk_main();
}

void set_the_colours(GtkWidget *w,const char *progname);


/* set the colours of the faces */
void
setCubeColours(char *progname)
{
  /*dummy*/

}

void
set_the_colours(GtkWidget *w, const char *progname)
{

  int i;

  Display *dpy;

  dpy = GDK_WINDOW_XDISPLAY(gtk_widget_get_parent_window(w));


  for(i=0;i<6;++i){
    char *colour=0;
    char resname[20];
    GdkColor xcolour;
    g_snprintf(resname,20,"color%d",i);
    colour=XGetDefault(dpy,progname,resname);

    if (!colour) 
      continue;

    if(!gdk_color_parse(colour,&xcolour)) {
      g_warning("colour %s not in database\n",colour);
    }
    else{
      /* convert colours to GLfloat values, and set them*/
      const unsigned short full = ~0;


      GLfloat red =   (GLfloat) xcolour.red/full ;
      GLfloat green = (GLfloat) xcolour.green/full ;
      GLfloat blue =  (GLfloat) xcolour.blue/full ;

      setColour(i,red,green,blue);
    }
  }


}




/* Popup an error dialog box */
void 
error_dialog(GtkWidget *parent, const gchar *format,...)
{
  va_list ap;

  GtkWidget *dialog ;

  gchar *message;
   

  va_start(ap,format);

  message = g_strdup_vprintf(format,ap);

  va_end(ap);

  dialog = gtk_message_dialog_new (GTK_WINDOW(parent),
				   GTK_DIALOG_MODAL,
				   GTK_MESSAGE_ERROR,
				   GTK_BUTTONS_CLOSE,
				   message);

  g_free(message);


  gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(parent));

 /* Destroy the dialog when the user responds to it (e.g. clicks a button) */
 g_signal_connect_swapped (GTK_OBJECT (dialog), "response",
                           G_CALLBACK (gtk_widget_destroy),
                           GTK_OBJECT (dialog));



 gtk_widget_show_all(dialog);

}

