/* ex: set ro ft=c: -*- mode: c; buffer-read-only: t -*- */
/*****************************************************************************/
/*  LibreDWG - free implementation of the DWG file format                    */
/*                                                                           */
/*  Copyright (C) 2019 Free Software Foundation, Inc.                        */
/*                                                                           */
/*  This library is free software, licensed under the terms of the GNU       */
/*  General Public License as published by the Free Software Foundation,     */
/*  either version 3 of the License, or (at your option) any later version.  */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.    */
/*****************************************************************************/
/* dynapi coverage tests, generated by gen-dynapi.pl from dynapi_test.c.in
   do not modify */
/* written by: Reini Urban */

#line 16 "dynapi_test.c.in"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <math.h>
#include <sys/stat.h>

#define DWG_LOGLEVEL DWG_LOGLEVEL_NONE
#include "../../src/config.h"
#include "../../src/common.h"
#include "dwg.h"
#include "dwg_api.h"
CLANG_DIAG_IGNORE (-Wformat-nonliteral)
CLANG_DIAG_IGNORE (-Wmissing-prototypes)
#include <dejagnu.h>
CLANG_DIAG_RESTORE
CLANG_DIAG_RESTORE

/* for all objects/entities/header_vars:
   compare direct api vs dynapi values
*/
static int
test_header (const Dwg_Data *dwg)
{
  int error = 0;
  BITCODE_RL rl;
  BITCODE_RC rc;
  BITCODE_BLL bll;
  BITCODE_BD bd;
  BITCODE_TV tv;

#line 48 "dynapi_test.c"
  /* @@for test_HEADER@@ */
  {
    BITCODE_RL size;
    if (dwg_dynapi_header_value (dwg, "size", &size, NULL)
        && size == dwg->header_vars.size)
      {
        pass ("HEADER.size [RL] %u", size);
      }
    else
      {
        fail ("HEADER.size [RL] %u != %u", dwg->header_vars.size, size);
        error++;
      }
    size++;
    if (dwg_dynapi_header_set_value (dwg, "size", &size)
        && size == dwg->header_vars.size)
      {
        pass ("HEADER.size [RL] set+1 %u", size);
      }
    else
      {
        fail ("HEADER.size [RL] set+1 %u != %u",
              dwg->header_vars.size, size);
        error++;
      }
    size--;
    dwg_dynapi_header_set_value (dwg, "size", &size);

  }
  {
    BITCODE_RL bitsize_hi;
    if (dwg_dynapi_header_value (dwg, "bitsize_hi", &bitsize_hi, NULL)
        && bitsize_hi == dwg->header_vars.bitsize_hi)
      {
        pass ("HEADER.bitsize_hi [RL] %u", bitsize_hi);
      }
    else
      {
        fail ("HEADER.bitsize_hi [RL] %u != %u", dwg->header_vars.bitsize_hi, bitsize_hi);
        error++;
      }
    bitsize_hi++;
    if (dwg_dynapi_header_set_value (dwg, "bitsize_hi", &bitsize_hi)
        && bitsize_hi == dwg->header_vars.bitsize_hi)
      {
        pass ("HEADER.bitsize_hi [RL] set+1 %u", bitsize_hi);
      }
    else
      {
        fail ("HEADER.bitsize_hi [RL] set+1 %u != %u",
              dwg->header_vars.bitsize_hi, bitsize_hi);
        error++;
      }
    bitsize_hi--;
    dwg_dynapi_header_set_value (dwg, "bitsize_hi", &bitsize_hi);

  }
  {
    BITCODE_RL bitsize;
    if (dwg_dynapi_header_value (dwg, "bitsize", &bitsize, NULL)
        && bitsize == dwg->header_vars.bitsize)
      {
        pass ("HEADER.bitsize [RL] %u", bitsize);
      }
    else
      {
        fail ("HEADER.bitsize [RL] %u != %u", dwg->header_vars.bitsize, bitsize);
        error++;
      }
    bitsize++;
    if (dwg_dynapi_header_set_value (dwg, "bitsize", &bitsize)
        && bitsize == dwg->header_vars.bitsize)
      {
        pass ("HEADER.bitsize [RL] set+1 %u", bitsize);
      }
    else
      {
        fail ("HEADER.bitsize [RL] set+1 %u != %u",
              dwg->header_vars.bitsize, bitsize);
        error++;
      }
    bitsize--;
    dwg_dynapi_header_set_value (dwg, "bitsize", &bitsize);

  }
  {
    BITCODE_RC acadmaintver;
    if (dwg_dynapi_header_value (dwg, "ACADMAINTVER", &acadmaintver, NULL)
        && acadmaintver == dwg->header_vars.ACADMAINTVER)
      {
        pass ("HEADER.ACADMAINTVER [RC] %u", acadmaintver);
      }
    else
      {
        fail ("HEADER.ACADMAINTVER [RC] %u != %u", dwg->header_vars.ACADMAINTVER, acadmaintver);
        error++;
      }
    acadmaintver++;
    if (dwg_dynapi_header_set_value (dwg, "ACADMAINTVER", &acadmaintver)
        && acadmaintver == dwg->header_vars.ACADMAINTVER)
      {
        pass ("HEADER.ACADMAINTVER [RC] set+1 %u", acadmaintver);
      }
    else
      {
        fail ("HEADER.ACADMAINTVER [RC] set+1 %u != %u",
              dwg->header_vars.ACADMAINTVER, acadmaintver);
        error++;
      }
    acadmaintver--;
    dwg_dynapi_header_set_value (dwg, "ACADMAINTVER", &acadmaintver);

  }
  {
    BITCODE_BLL requiredversions;
    if (dwg_dynapi_header_value (dwg, "REQUIREDVERSIONS", &requiredversions, NULL)
        && requiredversions == dwg->header_vars.REQUIREDVERSIONS)
      {
        pass ("HEADER.REQUIREDVERSIONS [BLL] " FORMAT_BLL "", requiredversions);
      }
    else
      {
        fail ("HEADER.REQUIREDVERSIONS [BLL] " FORMAT_BLL " != " FORMAT_BLL "", dwg->header_vars.REQUIREDVERSIONS, requiredversions);
        error++;
      }
    requiredversions++;
    if (dwg_dynapi_header_set_value (dwg, "REQUIREDVERSIONS", &requiredversions)
        && requiredversions == dwg->header_vars.REQUIREDVERSIONS)
      {
        pass ("HEADER.REQUIREDVERSIONS [BLL] set+1 " FORMAT_BLL "", requiredversions);
      }
    else
      {
        fail ("HEADER.REQUIREDVERSIONS [BLL] set+1 " FORMAT_BLL " != " FORMAT_BLL "",
              dwg->header_vars.REQUIREDVERSIONS, requiredversions);
        error++;
      }
    requiredversions--;
    dwg_dynapi_header_set_value (dwg, "REQUIREDVERSIONS", &requiredversions);

  }
  {
    BITCODE_TV dwgcodepage;
    if (dwg_dynapi_header_value (dwg, "DWGCODEPAGE", &dwgcodepage, NULL)
        && !memcmp (&dwgcodepage, &dwg->header_vars.DWGCODEPAGE, sizeof (dwg->header_vars.DWGCODEPAGE))
       )
      {
        pass ("HEADER.DWGCODEPAGE [TV]");
      }
    else
      {
        fail ("HEADER.DWGCODEPAGE [TV]");
        error++;
      }
  }
  {
    BITCODE_TU lastsavedby;
    if (dwg_dynapi_header_value (dwg, "LASTSAVEDBY", &lastsavedby, NULL)
        && !memcmp (&lastsavedby, &dwg->header_vars.LASTSAVEDBY, sizeof (dwg->header_vars.LASTSAVEDBY))
       )
      {
        pass ("HEADER.LASTSAVEDBY [TU]");
      }
    else
      {
        fail ("HEADER.LASTSAVEDBY [TU]");
        error++;
      }
  }
  {
    BITCODE_BD unknown_0;
    if (dwg_dynapi_header_value (dwg, "unknown_0", &unknown_0, NULL)
        && unknown_0 == dwg->header_vars.unknown_0)
      {
        pass ("HEADER.unknown_0 [BD] %g", unknown_0);
      }
    else
      {
        fail ("HEADER.unknown_0 [BD] %g != %g", dwg->header_vars.unknown_0, unknown_0);
        error++;
      }
    unknown_0++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_0", &unknown_0)
        && unknown_0 == dwg->header_vars.unknown_0)
      {
        pass ("HEADER.unknown_0 [BD] set+1 %g", unknown_0);
      }
    else
      {
        fail ("HEADER.unknown_0 [BD] set+1 %g != %g",
              dwg->header_vars.unknown_0, unknown_0);
        error++;
      }
    unknown_0--;
    dwg_dynapi_header_set_value (dwg, "unknown_0", &unknown_0);

  }
  {
    BITCODE_BD unknown_1;
    if (dwg_dynapi_header_value (dwg, "unknown_1", &unknown_1, NULL)
        && unknown_1 == dwg->header_vars.unknown_1)
      {
        pass ("HEADER.unknown_1 [BD] %g", unknown_1);
      }
    else
      {
        fail ("HEADER.unknown_1 [BD] %g != %g", dwg->header_vars.unknown_1, unknown_1);
        error++;
      }
    unknown_1++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_1", &unknown_1)
        && unknown_1 == dwg->header_vars.unknown_1)
      {
        pass ("HEADER.unknown_1 [BD] set+1 %g", unknown_1);
      }
    else
      {
        fail ("HEADER.unknown_1 [BD] set+1 %g != %g",
              dwg->header_vars.unknown_1, unknown_1);
        error++;
      }
    unknown_1--;
    dwg_dynapi_header_set_value (dwg, "unknown_1", &unknown_1);

  }
  {
    BITCODE_BD unknown_2;
    if (dwg_dynapi_header_value (dwg, "unknown_2", &unknown_2, NULL)
        && unknown_2 == dwg->header_vars.unknown_2)
      {
        pass ("HEADER.unknown_2 [BD] %g", unknown_2);
      }
    else
      {
        fail ("HEADER.unknown_2 [BD] %g != %g", dwg->header_vars.unknown_2, unknown_2);
        error++;
      }
    unknown_2++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_2", &unknown_2)
        && unknown_2 == dwg->header_vars.unknown_2)
      {
        pass ("HEADER.unknown_2 [BD] set+1 %g", unknown_2);
      }
    else
      {
        fail ("HEADER.unknown_2 [BD] set+1 %g != %g",
              dwg->header_vars.unknown_2, unknown_2);
        error++;
      }
    unknown_2--;
    dwg_dynapi_header_set_value (dwg, "unknown_2", &unknown_2);

  }
  {
    BITCODE_BD unknown_3;
    if (dwg_dynapi_header_value (dwg, "unknown_3", &unknown_3, NULL)
        && unknown_3 == dwg->header_vars.unknown_3)
      {
        pass ("HEADER.unknown_3 [BD] %g", unknown_3);
      }
    else
      {
        fail ("HEADER.unknown_3 [BD] %g != %g", dwg->header_vars.unknown_3, unknown_3);
        error++;
      }
    unknown_3++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_3", &unknown_3)
        && unknown_3 == dwg->header_vars.unknown_3)
      {
        pass ("HEADER.unknown_3 [BD] set+1 %g", unknown_3);
      }
    else
      {
        fail ("HEADER.unknown_3 [BD] set+1 %g != %g",
              dwg->header_vars.unknown_3, unknown_3);
        error++;
      }
    unknown_3--;
    dwg_dynapi_header_set_value (dwg, "unknown_3", &unknown_3);

  }
  {
    BITCODE_TV unknown_text1;
    if (dwg_dynapi_header_value (dwg, "unknown_text1", &unknown_text1, NULL)
        && !memcmp (&unknown_text1, &dwg->header_vars.unknown_text1, sizeof (dwg->header_vars.unknown_text1))
       )
      {
        pass ("HEADER.unknown_text1 [TV]");
      }
    else
      {
        fail ("HEADER.unknown_text1 [TV]");
        error++;
      }
  }
  {
    BITCODE_TV unknown_text2;
    if (dwg_dynapi_header_value (dwg, "unknown_text2", &unknown_text2, NULL)
        && !memcmp (&unknown_text2, &dwg->header_vars.unknown_text2, sizeof (dwg->header_vars.unknown_text2))
       )
      {
        pass ("HEADER.unknown_text2 [TV]");
      }
    else
      {
        fail ("HEADER.unknown_text2 [TV]");
        error++;
      }
  }
  {
    BITCODE_TV unknown_text3;
    if (dwg_dynapi_header_value (dwg, "unknown_text3", &unknown_text3, NULL)
        && !memcmp (&unknown_text3, &dwg->header_vars.unknown_text3, sizeof (dwg->header_vars.unknown_text3))
       )
      {
        pass ("HEADER.unknown_text3 [TV]");
      }
    else
      {
        fail ("HEADER.unknown_text3 [TV]");
        error++;
      }
  }
  {
    BITCODE_TV unknown_text4;
    if (dwg_dynapi_header_value (dwg, "unknown_text4", &unknown_text4, NULL)
        && !memcmp (&unknown_text4, &dwg->header_vars.unknown_text4, sizeof (dwg->header_vars.unknown_text4))
       )
      {
        pass ("HEADER.unknown_text4 [TV]");
      }
    else
      {
        fail ("HEADER.unknown_text4 [TV]");
        error++;
      }
  }
  {
    BITCODE_BL unknown_8;
    if (dwg_dynapi_header_value (dwg, "unknown_8", &unknown_8, NULL)
        && unknown_8 == dwg->header_vars.unknown_8)
      {
        pass ("HEADER.unknown_8 [BL] %u", unknown_8);
      }
    else
      {
        fail ("HEADER.unknown_8 [BL] %u != %u", dwg->header_vars.unknown_8, unknown_8);
        error++;
      }
    unknown_8++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_8", &unknown_8)
        && unknown_8 == dwg->header_vars.unknown_8)
      {
        pass ("HEADER.unknown_8 [BL] set+1 %u", unknown_8);
      }
    else
      {
        fail ("HEADER.unknown_8 [BL] set+1 %u != %u",
              dwg->header_vars.unknown_8, unknown_8);
        error++;
      }
    unknown_8--;
    dwg_dynapi_header_set_value (dwg, "unknown_8", &unknown_8);

  }
  {
    BITCODE_BL unknown_9;
    if (dwg_dynapi_header_value (dwg, "unknown_9", &unknown_9, NULL)
        && unknown_9 == dwg->header_vars.unknown_9)
      {
        pass ("HEADER.unknown_9 [BL] %u", unknown_9);
      }
    else
      {
        fail ("HEADER.unknown_9 [BL] %u != %u", dwg->header_vars.unknown_9, unknown_9);
        error++;
      }
    unknown_9++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_9", &unknown_9)
        && unknown_9 == dwg->header_vars.unknown_9)
      {
        pass ("HEADER.unknown_9 [BL] set+1 %u", unknown_9);
      }
    else
      {
        fail ("HEADER.unknown_9 [BL] set+1 %u != %u",
              dwg->header_vars.unknown_9, unknown_9);
        error++;
      }
    unknown_9--;
    dwg_dynapi_header_set_value (dwg, "unknown_9", &unknown_9);

  }
  {
    BITCODE_BS unknown_10;
    if (dwg_dynapi_header_value (dwg, "unknown_10", &unknown_10, NULL)
        && unknown_10 == dwg->header_vars.unknown_10)
      {
        pass ("HEADER.unknown_10 [BS] %hu", unknown_10);
      }
    else
      {
        fail ("HEADER.unknown_10 [BS] %hu != %hu", dwg->header_vars.unknown_10, unknown_10);
        error++;
      }
    unknown_10++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_10", &unknown_10)
        && unknown_10 == dwg->header_vars.unknown_10)
      {
        pass ("HEADER.unknown_10 [BS] set+1 %hu", unknown_10);
      }
    else
      {
        fail ("HEADER.unknown_10 [BS] set+1 %hu != %hu",
              dwg->header_vars.unknown_10, unknown_10);
        error++;
      }
    unknown_10--;
    dwg_dynapi_header_set_value (dwg, "unknown_10", &unknown_10);

  }
  {
    BITCODE_H vport_entity_header;
    if (dwg_dynapi_header_value (dwg, "vport_entity_header", &vport_entity_header, NULL)
        && !memcmp (&vport_entity_header, &dwg->header_vars.vport_entity_header, sizeof (dwg->header_vars.vport_entity_header))
       )
      {
        pass ("HEADER.vport_entity_header [H]");
      }
    else
      {
        fail ("HEADER.vport_entity_header [H]");
        error++;
      }
  }
  {
    BITCODE_B dimaso;
    if (dwg_dynapi_header_value (dwg, "DIMASO", &dimaso, NULL)
        && dimaso == dwg->header_vars.DIMASO)
      {
        pass ("HEADER.DIMASO [B] " FORMAT_B "", dimaso);
      }
    else
      {
        fail ("HEADER.DIMASO [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMASO, dimaso);
        error++;
      }
    dimaso++;
    if (dwg_dynapi_header_set_value (dwg, "DIMASO", &dimaso)
        && dimaso == dwg->header_vars.DIMASO)
      {
        pass ("HEADER.DIMASO [B] set+1 " FORMAT_B "", dimaso);
      }
    else
      {
        fail ("HEADER.DIMASO [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMASO, dimaso);
        error++;
      }
    dimaso--;
    dwg_dynapi_header_set_value (dwg, "DIMASO", &dimaso);

  }
  {
    BITCODE_B dimsho;
    if (dwg_dynapi_header_value (dwg, "DIMSHO", &dimsho, NULL)
        && dimsho == dwg->header_vars.DIMSHO)
      {
        pass ("HEADER.DIMSHO [B] " FORMAT_B "", dimsho);
      }
    else
      {
        fail ("HEADER.DIMSHO [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSHO, dimsho);
        error++;
      }
    dimsho++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSHO", &dimsho)
        && dimsho == dwg->header_vars.DIMSHO)
      {
        pass ("HEADER.DIMSHO [B] set+1 " FORMAT_B "", dimsho);
      }
    else
      {
        fail ("HEADER.DIMSHO [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMSHO, dimsho);
        error++;
      }
    dimsho--;
    dwg_dynapi_header_set_value (dwg, "DIMSHO", &dimsho);

  }
  {
    BITCODE_B dimsav;
    if (dwg_dynapi_header_value (dwg, "DIMSAV", &dimsav, NULL)
        && dimsav == dwg->header_vars.DIMSAV)
      {
        pass ("HEADER.DIMSAV [B] " FORMAT_B "", dimsav);
      }
    else
      {
        fail ("HEADER.DIMSAV [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSAV, dimsav);
        error++;
      }
    dimsav++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSAV", &dimsav)
        && dimsav == dwg->header_vars.DIMSAV)
      {
        pass ("HEADER.DIMSAV [B] set+1 " FORMAT_B "", dimsav);
      }
    else
      {
        fail ("HEADER.DIMSAV [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMSAV, dimsav);
        error++;
      }
    dimsav--;
    dwg_dynapi_header_set_value (dwg, "DIMSAV", &dimsav);

  }
  {
    BITCODE_B plinegen;
    if (dwg_dynapi_header_value (dwg, "PLINEGEN", &plinegen, NULL)
        && plinegen == dwg->header_vars.PLINEGEN)
      {
        pass ("HEADER.PLINEGEN [B] " FORMAT_B "", plinegen);
      }
    else
      {
        fail ("HEADER.PLINEGEN [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.PLINEGEN, plinegen);
        error++;
      }
    plinegen++;
    if (dwg_dynapi_header_set_value (dwg, "PLINEGEN", &plinegen)
        && plinegen == dwg->header_vars.PLINEGEN)
      {
        pass ("HEADER.PLINEGEN [B] set+1 " FORMAT_B "", plinegen);
      }
    else
      {
        fail ("HEADER.PLINEGEN [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.PLINEGEN, plinegen);
        error++;
      }
    plinegen--;
    dwg_dynapi_header_set_value (dwg, "PLINEGEN", &plinegen);

  }
  {
    BITCODE_B orthomode;
    if (dwg_dynapi_header_value (dwg, "ORTHOMODE", &orthomode, NULL)
        && orthomode == dwg->header_vars.ORTHOMODE)
      {
        pass ("HEADER.ORTHOMODE [B] " FORMAT_B "", orthomode);
      }
    else
      {
        fail ("HEADER.ORTHOMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.ORTHOMODE, orthomode);
        error++;
      }
    orthomode++;
    if (dwg_dynapi_header_set_value (dwg, "ORTHOMODE", &orthomode)
        && orthomode == dwg->header_vars.ORTHOMODE)
      {
        pass ("HEADER.ORTHOMODE [B] set+1 " FORMAT_B "", orthomode);
      }
    else
      {
        fail ("HEADER.ORTHOMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.ORTHOMODE, orthomode);
        error++;
      }
    orthomode--;
    dwg_dynapi_header_set_value (dwg, "ORTHOMODE", &orthomode);

  }
  {
    BITCODE_B regenmode;
    if (dwg_dynapi_header_value (dwg, "REGENMODE", &regenmode, NULL)
        && regenmode == dwg->header_vars.REGENMODE)
      {
        pass ("HEADER.REGENMODE [B] " FORMAT_B "", regenmode);
      }
    else
      {
        fail ("HEADER.REGENMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.REGENMODE, regenmode);
        error++;
      }
    regenmode++;
    if (dwg_dynapi_header_set_value (dwg, "REGENMODE", &regenmode)
        && regenmode == dwg->header_vars.REGENMODE)
      {
        pass ("HEADER.REGENMODE [B] set+1 " FORMAT_B "", regenmode);
      }
    else
      {
        fail ("HEADER.REGENMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.REGENMODE, regenmode);
        error++;
      }
    regenmode--;
    dwg_dynapi_header_set_value (dwg, "REGENMODE", &regenmode);

  }
  {
    BITCODE_B fillmode;
    if (dwg_dynapi_header_value (dwg, "FILLMODE", &fillmode, NULL)
        && fillmode == dwg->header_vars.FILLMODE)
      {
        pass ("HEADER.FILLMODE [B] " FORMAT_B "", fillmode);
      }
    else
      {
        fail ("HEADER.FILLMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.FILLMODE, fillmode);
        error++;
      }
    fillmode++;
    if (dwg_dynapi_header_set_value (dwg, "FILLMODE", &fillmode)
        && fillmode == dwg->header_vars.FILLMODE)
      {
        pass ("HEADER.FILLMODE [B] set+1 " FORMAT_B "", fillmode);
      }
    else
      {
        fail ("HEADER.FILLMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.FILLMODE, fillmode);
        error++;
      }
    fillmode--;
    dwg_dynapi_header_set_value (dwg, "FILLMODE", &fillmode);

  }
  {
    BITCODE_B qtextmode;
    if (dwg_dynapi_header_value (dwg, "QTEXTMODE", &qtextmode, NULL)
        && qtextmode == dwg->header_vars.QTEXTMODE)
      {
        pass ("HEADER.QTEXTMODE [B] " FORMAT_B "", qtextmode);
      }
    else
      {
        fail ("HEADER.QTEXTMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.QTEXTMODE, qtextmode);
        error++;
      }
    qtextmode++;
    if (dwg_dynapi_header_set_value (dwg, "QTEXTMODE", &qtextmode)
        && qtextmode == dwg->header_vars.QTEXTMODE)
      {
        pass ("HEADER.QTEXTMODE [B] set+1 " FORMAT_B "", qtextmode);
      }
    else
      {
        fail ("HEADER.QTEXTMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.QTEXTMODE, qtextmode);
        error++;
      }
    qtextmode--;
    dwg_dynapi_header_set_value (dwg, "QTEXTMODE", &qtextmode);

  }
  {
    BITCODE_B psltscale;
    if (dwg_dynapi_header_value (dwg, "PSLTSCALE", &psltscale, NULL)
        && psltscale == dwg->header_vars.PSLTSCALE)
      {
        pass ("HEADER.PSLTSCALE [B] " FORMAT_B "", psltscale);
      }
    else
      {
        fail ("HEADER.PSLTSCALE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.PSLTSCALE, psltscale);
        error++;
      }
    psltscale++;
    if (dwg_dynapi_header_set_value (dwg, "PSLTSCALE", &psltscale)
        && psltscale == dwg->header_vars.PSLTSCALE)
      {
        pass ("HEADER.PSLTSCALE [B] set+1 " FORMAT_B "", psltscale);
      }
    else
      {
        fail ("HEADER.PSLTSCALE [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.PSLTSCALE, psltscale);
        error++;
      }
    psltscale--;
    dwg_dynapi_header_set_value (dwg, "PSLTSCALE", &psltscale);

  }
  {
    BITCODE_B limcheck;
    if (dwg_dynapi_header_value (dwg, "LIMCHECK", &limcheck, NULL)
        && limcheck == dwg->header_vars.LIMCHECK)
      {
        pass ("HEADER.LIMCHECK [B] " FORMAT_B "", limcheck);
      }
    else
      {
        fail ("HEADER.LIMCHECK [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.LIMCHECK, limcheck);
        error++;
      }
    limcheck++;
    if (dwg_dynapi_header_set_value (dwg, "LIMCHECK", &limcheck)
        && limcheck == dwg->header_vars.LIMCHECK)
      {
        pass ("HEADER.LIMCHECK [B] set+1 " FORMAT_B "", limcheck);
      }
    else
      {
        fail ("HEADER.LIMCHECK [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.LIMCHECK, limcheck);
        error++;
      }
    limcheck--;
    dwg_dynapi_header_set_value (dwg, "LIMCHECK", &limcheck);

  }
  {
    BITCODE_B blipmode;
    if (dwg_dynapi_header_value (dwg, "BLIPMODE", &blipmode, NULL)
        && blipmode == dwg->header_vars.BLIPMODE)
      {
        pass ("HEADER.BLIPMODE [B] " FORMAT_B "", blipmode);
      }
    else
      {
        fail ("HEADER.BLIPMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.BLIPMODE, blipmode);
        error++;
      }
    blipmode++;
    if (dwg_dynapi_header_set_value (dwg, "BLIPMODE", &blipmode)
        && blipmode == dwg->header_vars.BLIPMODE)
      {
        pass ("HEADER.BLIPMODE [B] set+1 " FORMAT_B "", blipmode);
      }
    else
      {
        fail ("HEADER.BLIPMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.BLIPMODE, blipmode);
        error++;
      }
    blipmode--;
    dwg_dynapi_header_set_value (dwg, "BLIPMODE", &blipmode);

  }
  {
    BITCODE_B unknown_11;
    if (dwg_dynapi_header_value (dwg, "unknown_11", &unknown_11, NULL)
        && unknown_11 == dwg->header_vars.unknown_11)
      {
        pass ("HEADER.unknown_11 [B] " FORMAT_B "", unknown_11);
      }
    else
      {
        fail ("HEADER.unknown_11 [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.unknown_11, unknown_11);
        error++;
      }
    unknown_11++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_11", &unknown_11)
        && unknown_11 == dwg->header_vars.unknown_11)
      {
        pass ("HEADER.unknown_11 [B] set+1 " FORMAT_B "", unknown_11);
      }
    else
      {
        fail ("HEADER.unknown_11 [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.unknown_11, unknown_11);
        error++;
      }
    unknown_11--;
    dwg_dynapi_header_set_value (dwg, "unknown_11", &unknown_11);

  }
  {
    BITCODE_B usrtimer;
    if (dwg_dynapi_header_value (dwg, "USRTIMER", &usrtimer, NULL)
        && usrtimer == dwg->header_vars.USRTIMER)
      {
        pass ("HEADER.USRTIMER [B] " FORMAT_B "", usrtimer);
      }
    else
      {
        fail ("HEADER.USRTIMER [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.USRTIMER, usrtimer);
        error++;
      }
    usrtimer++;
    if (dwg_dynapi_header_set_value (dwg, "USRTIMER", &usrtimer)
        && usrtimer == dwg->header_vars.USRTIMER)
      {
        pass ("HEADER.USRTIMER [B] set+1 " FORMAT_B "", usrtimer);
      }
    else
      {
        fail ("HEADER.USRTIMER [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.USRTIMER, usrtimer);
        error++;
      }
    usrtimer--;
    dwg_dynapi_header_set_value (dwg, "USRTIMER", &usrtimer);

  }
  {
    BITCODE_B skpoly;
    if (dwg_dynapi_header_value (dwg, "SKPOLY", &skpoly, NULL)
        && skpoly == dwg->header_vars.SKPOLY)
      {
        pass ("HEADER.SKPOLY [B] " FORMAT_B "", skpoly);
      }
    else
      {
        fail ("HEADER.SKPOLY [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.SKPOLY, skpoly);
        error++;
      }
    skpoly++;
    if (dwg_dynapi_header_set_value (dwg, "SKPOLY", &skpoly)
        && skpoly == dwg->header_vars.SKPOLY)
      {
        pass ("HEADER.SKPOLY [B] set+1 " FORMAT_B "", skpoly);
      }
    else
      {
        fail ("HEADER.SKPOLY [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.SKPOLY, skpoly);
        error++;
      }
    skpoly--;
    dwg_dynapi_header_set_value (dwg, "SKPOLY", &skpoly);

  }
  {
    BITCODE_B angdir;
    if (dwg_dynapi_header_value (dwg, "ANGDIR", &angdir, NULL)
        && angdir == dwg->header_vars.ANGDIR)
      {
        pass ("HEADER.ANGDIR [B] " FORMAT_B "", angdir);
      }
    else
      {
        fail ("HEADER.ANGDIR [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.ANGDIR, angdir);
        error++;
      }
    angdir++;
    if (dwg_dynapi_header_set_value (dwg, "ANGDIR", &angdir)
        && angdir == dwg->header_vars.ANGDIR)
      {
        pass ("HEADER.ANGDIR [B] set+1 " FORMAT_B "", angdir);
      }
    else
      {
        fail ("HEADER.ANGDIR [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.ANGDIR, angdir);
        error++;
      }
    angdir--;
    dwg_dynapi_header_set_value (dwg, "ANGDIR", &angdir);

  }
  {
    BITCODE_B splframe;
    if (dwg_dynapi_header_value (dwg, "SPLFRAME", &splframe, NULL)
        && splframe == dwg->header_vars.SPLFRAME)
      {
        pass ("HEADER.SPLFRAME [B] " FORMAT_B "", splframe);
      }
    else
      {
        fail ("HEADER.SPLFRAME [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.SPLFRAME, splframe);
        error++;
      }
    splframe++;
    if (dwg_dynapi_header_set_value (dwg, "SPLFRAME", &splframe)
        && splframe == dwg->header_vars.SPLFRAME)
      {
        pass ("HEADER.SPLFRAME [B] set+1 " FORMAT_B "", splframe);
      }
    else
      {
        fail ("HEADER.SPLFRAME [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.SPLFRAME, splframe);
        error++;
      }
    splframe--;
    dwg_dynapi_header_set_value (dwg, "SPLFRAME", &splframe);

  }
  {
    BITCODE_B attreq;
    if (dwg_dynapi_header_value (dwg, "ATTREQ", &attreq, NULL)
        && attreq == dwg->header_vars.ATTREQ)
      {
        pass ("HEADER.ATTREQ [B] " FORMAT_B "", attreq);
      }
    else
      {
        fail ("HEADER.ATTREQ [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.ATTREQ, attreq);
        error++;
      }
    attreq++;
    if (dwg_dynapi_header_set_value (dwg, "ATTREQ", &attreq)
        && attreq == dwg->header_vars.ATTREQ)
      {
        pass ("HEADER.ATTREQ [B] set+1 " FORMAT_B "", attreq);
      }
    else
      {
        fail ("HEADER.ATTREQ [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.ATTREQ, attreq);
        error++;
      }
    attreq--;
    dwg_dynapi_header_set_value (dwg, "ATTREQ", &attreq);

  }
  {
    BITCODE_B attdia;
    if (dwg_dynapi_header_value (dwg, "ATTDIA", &attdia, NULL)
        && attdia == dwg->header_vars.ATTDIA)
      {
        pass ("HEADER.ATTDIA [B] " FORMAT_B "", attdia);
      }
    else
      {
        fail ("HEADER.ATTDIA [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.ATTDIA, attdia);
        error++;
      }
    attdia++;
    if (dwg_dynapi_header_set_value (dwg, "ATTDIA", &attdia)
        && attdia == dwg->header_vars.ATTDIA)
      {
        pass ("HEADER.ATTDIA [B] set+1 " FORMAT_B "", attdia);
      }
    else
      {
        fail ("HEADER.ATTDIA [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.ATTDIA, attdia);
        error++;
      }
    attdia--;
    dwg_dynapi_header_set_value (dwg, "ATTDIA", &attdia);

  }
  {
    BITCODE_B mirrtext;
    if (dwg_dynapi_header_value (dwg, "MIRRTEXT", &mirrtext, NULL)
        && mirrtext == dwg->header_vars.MIRRTEXT)
      {
        pass ("HEADER.MIRRTEXT [B] " FORMAT_B "", mirrtext);
      }
    else
      {
        fail ("HEADER.MIRRTEXT [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.MIRRTEXT, mirrtext);
        error++;
      }
    mirrtext++;
    if (dwg_dynapi_header_set_value (dwg, "MIRRTEXT", &mirrtext)
        && mirrtext == dwg->header_vars.MIRRTEXT)
      {
        pass ("HEADER.MIRRTEXT [B] set+1 " FORMAT_B "", mirrtext);
      }
    else
      {
        fail ("HEADER.MIRRTEXT [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.MIRRTEXT, mirrtext);
        error++;
      }
    mirrtext--;
    dwg_dynapi_header_set_value (dwg, "MIRRTEXT", &mirrtext);

  }
  {
    BITCODE_B worldview;
    if (dwg_dynapi_header_value (dwg, "WORLDVIEW", &worldview, NULL)
        && worldview == dwg->header_vars.WORLDVIEW)
      {
        pass ("HEADER.WORLDVIEW [B] " FORMAT_B "", worldview);
      }
    else
      {
        fail ("HEADER.WORLDVIEW [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.WORLDVIEW, worldview);
        error++;
      }
    worldview++;
    if (dwg_dynapi_header_set_value (dwg, "WORLDVIEW", &worldview)
        && worldview == dwg->header_vars.WORLDVIEW)
      {
        pass ("HEADER.WORLDVIEW [B] set+1 " FORMAT_B "", worldview);
      }
    else
      {
        fail ("HEADER.WORLDVIEW [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.WORLDVIEW, worldview);
        error++;
      }
    worldview--;
    dwg_dynapi_header_set_value (dwg, "WORLDVIEW", &worldview);

  }
  {
    BITCODE_B wireframe;
    if (dwg_dynapi_header_value (dwg, "WIREFRAME", &wireframe, NULL)
        && wireframe == dwg->header_vars.WIREFRAME)
      {
        pass ("HEADER.WIREFRAME [B] " FORMAT_B "", wireframe);
      }
    else
      {
        fail ("HEADER.WIREFRAME [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.WIREFRAME, wireframe);
        error++;
      }
    wireframe++;
    if (dwg_dynapi_header_set_value (dwg, "WIREFRAME", &wireframe)
        && wireframe == dwg->header_vars.WIREFRAME)
      {
        pass ("HEADER.WIREFRAME [B] set+1 " FORMAT_B "", wireframe);
      }
    else
      {
        fail ("HEADER.WIREFRAME [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.WIREFRAME, wireframe);
        error++;
      }
    wireframe--;
    dwg_dynapi_header_set_value (dwg, "WIREFRAME", &wireframe);

  }
  {
    BITCODE_B tilemode;
    if (dwg_dynapi_header_value (dwg, "TILEMODE", &tilemode, NULL)
        && tilemode == dwg->header_vars.TILEMODE)
      {
        pass ("HEADER.TILEMODE [B] " FORMAT_B "", tilemode);
      }
    else
      {
        fail ("HEADER.TILEMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.TILEMODE, tilemode);
        error++;
      }
    tilemode++;
    if (dwg_dynapi_header_set_value (dwg, "TILEMODE", &tilemode)
        && tilemode == dwg->header_vars.TILEMODE)
      {
        pass ("HEADER.TILEMODE [B] set+1 " FORMAT_B "", tilemode);
      }
    else
      {
        fail ("HEADER.TILEMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.TILEMODE, tilemode);
        error++;
      }
    tilemode--;
    dwg_dynapi_header_set_value (dwg, "TILEMODE", &tilemode);

  }
  {
    BITCODE_B plimcheck;
    if (dwg_dynapi_header_value (dwg, "PLIMCHECK", &plimcheck, NULL)
        && plimcheck == dwg->header_vars.PLIMCHECK)
      {
        pass ("HEADER.PLIMCHECK [B] " FORMAT_B "", plimcheck);
      }
    else
      {
        fail ("HEADER.PLIMCHECK [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.PLIMCHECK, plimcheck);
        error++;
      }
    plimcheck++;
    if (dwg_dynapi_header_set_value (dwg, "PLIMCHECK", &plimcheck)
        && plimcheck == dwg->header_vars.PLIMCHECK)
      {
        pass ("HEADER.PLIMCHECK [B] set+1 " FORMAT_B "", plimcheck);
      }
    else
      {
        fail ("HEADER.PLIMCHECK [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.PLIMCHECK, plimcheck);
        error++;
      }
    plimcheck--;
    dwg_dynapi_header_set_value (dwg, "PLIMCHECK", &plimcheck);

  }
  {
    BITCODE_B visretain;
    if (dwg_dynapi_header_value (dwg, "VISRETAIN", &visretain, NULL)
        && visretain == dwg->header_vars.VISRETAIN)
      {
        pass ("HEADER.VISRETAIN [B] " FORMAT_B "", visretain);
      }
    else
      {
        fail ("HEADER.VISRETAIN [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.VISRETAIN, visretain);
        error++;
      }
    visretain++;
    if (dwg_dynapi_header_set_value (dwg, "VISRETAIN", &visretain)
        && visretain == dwg->header_vars.VISRETAIN)
      {
        pass ("HEADER.VISRETAIN [B] set+1 " FORMAT_B "", visretain);
      }
    else
      {
        fail ("HEADER.VISRETAIN [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.VISRETAIN, visretain);
        error++;
      }
    visretain--;
    dwg_dynapi_header_set_value (dwg, "VISRETAIN", &visretain);

  }
  {
    BITCODE_B delobj;
    if (dwg_dynapi_header_value (dwg, "DELOBJ", &delobj, NULL)
        && delobj == dwg->header_vars.DELOBJ)
      {
        pass ("HEADER.DELOBJ [B] " FORMAT_B "", delobj);
      }
    else
      {
        fail ("HEADER.DELOBJ [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DELOBJ, delobj);
        error++;
      }
    delobj++;
    if (dwg_dynapi_header_set_value (dwg, "DELOBJ", &delobj)
        && delobj == dwg->header_vars.DELOBJ)
      {
        pass ("HEADER.DELOBJ [B] set+1 " FORMAT_B "", delobj);
      }
    else
      {
        fail ("HEADER.DELOBJ [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DELOBJ, delobj);
        error++;
      }
    delobj--;
    dwg_dynapi_header_set_value (dwg, "DELOBJ", &delobj);

  }
  {
    BITCODE_B dispsilh;
    if (dwg_dynapi_header_value (dwg, "DISPSILH", &dispsilh, NULL)
        && dispsilh == dwg->header_vars.DISPSILH)
      {
        pass ("HEADER.DISPSILH [B] " FORMAT_B "", dispsilh);
      }
    else
      {
        fail ("HEADER.DISPSILH [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DISPSILH, dispsilh);
        error++;
      }
    dispsilh++;
    if (dwg_dynapi_header_set_value (dwg, "DISPSILH", &dispsilh)
        && dispsilh == dwg->header_vars.DISPSILH)
      {
        pass ("HEADER.DISPSILH [B] set+1 " FORMAT_B "", dispsilh);
      }
    else
      {
        fail ("HEADER.DISPSILH [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DISPSILH, dispsilh);
        error++;
      }
    dispsilh--;
    dwg_dynapi_header_set_value (dwg, "DISPSILH", &dispsilh);

  }
  {
    BITCODE_B pellipse;
    if (dwg_dynapi_header_value (dwg, "PELLIPSE", &pellipse, NULL)
        && pellipse == dwg->header_vars.PELLIPSE)
      {
        pass ("HEADER.PELLIPSE [B] " FORMAT_B "", pellipse);
      }
    else
      {
        fail ("HEADER.PELLIPSE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.PELLIPSE, pellipse);
        error++;
      }
    pellipse++;
    if (dwg_dynapi_header_set_value (dwg, "PELLIPSE", &pellipse)
        && pellipse == dwg->header_vars.PELLIPSE)
      {
        pass ("HEADER.PELLIPSE [B] set+1 " FORMAT_B "", pellipse);
      }
    else
      {
        fail ("HEADER.PELLIPSE [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.PELLIPSE, pellipse);
        error++;
      }
    pellipse--;
    dwg_dynapi_header_set_value (dwg, "PELLIPSE", &pellipse);

  }
  {
    BITCODE_BS saveimages;
    if (dwg_dynapi_header_value (dwg, "SAVEIMAGES", &saveimages, NULL)
        && saveimages == dwg->header_vars.SAVEIMAGES)
      {
        pass ("HEADER.SAVEIMAGES [BS] %hu", saveimages);
      }
    else
      {
        fail ("HEADER.SAVEIMAGES [BS] %hu != %hu", dwg->header_vars.SAVEIMAGES, saveimages);
        error++;
      }
    saveimages++;
    if (dwg_dynapi_header_set_value (dwg, "SAVEIMAGES", &saveimages)
        && saveimages == dwg->header_vars.SAVEIMAGES)
      {
        pass ("HEADER.SAVEIMAGES [BS] set+1 %hu", saveimages);
      }
    else
      {
        fail ("HEADER.SAVEIMAGES [BS] set+1 %hu != %hu",
              dwg->header_vars.SAVEIMAGES, saveimages);
        error++;
      }
    saveimages--;
    dwg_dynapi_header_set_value (dwg, "SAVEIMAGES", &saveimages);

  }
  {
    BITCODE_BS proxygraphics;
    if (dwg_dynapi_header_value (dwg, "PROXYGRAPHICS", &proxygraphics, NULL)
        && proxygraphics == dwg->header_vars.PROXYGRAPHICS)
      {
        pass ("HEADER.PROXYGRAPHICS [BS] %hu", proxygraphics);
      }
    else
      {
        fail ("HEADER.PROXYGRAPHICS [BS] %hu != %hu", dwg->header_vars.PROXYGRAPHICS, proxygraphics);
        error++;
      }
    proxygraphics++;
    if (dwg_dynapi_header_set_value (dwg, "PROXYGRAPHICS", &proxygraphics)
        && proxygraphics == dwg->header_vars.PROXYGRAPHICS)
      {
        pass ("HEADER.PROXYGRAPHICS [BS] set+1 %hu", proxygraphics);
      }
    else
      {
        fail ("HEADER.PROXYGRAPHICS [BS] set+1 %hu != %hu",
              dwg->header_vars.PROXYGRAPHICS, proxygraphics);
        error++;
      }
    proxygraphics--;
    dwg_dynapi_header_set_value (dwg, "PROXYGRAPHICS", &proxygraphics);

  }
  {
    BITCODE_BS dragmode;
    if (dwg_dynapi_header_value (dwg, "DRAGMODE", &dragmode, NULL)
        && dragmode == dwg->header_vars.DRAGMODE)
      {
        pass ("HEADER.DRAGMODE [BS] %hu", dragmode);
      }
    else
      {
        fail ("HEADER.DRAGMODE [BS] %hu != %hu", dwg->header_vars.DRAGMODE, dragmode);
        error++;
      }
    dragmode++;
    if (dwg_dynapi_header_set_value (dwg, "DRAGMODE", &dragmode)
        && dragmode == dwg->header_vars.DRAGMODE)
      {
        pass ("HEADER.DRAGMODE [BS] set+1 %hu", dragmode);
      }
    else
      {
        fail ("HEADER.DRAGMODE [BS] set+1 %hu != %hu",
              dwg->header_vars.DRAGMODE, dragmode);
        error++;
      }
    dragmode--;
    dwg_dynapi_header_set_value (dwg, "DRAGMODE", &dragmode);

  }
  {
    BITCODE_BS treedepth;
    if (dwg_dynapi_header_value (dwg, "TREEDEPTH", &treedepth, NULL)
        && treedepth == dwg->header_vars.TREEDEPTH)
      {
        pass ("HEADER.TREEDEPTH [BS] %hu", treedepth);
      }
    else
      {
        fail ("HEADER.TREEDEPTH [BS] %hu != %hu", dwg->header_vars.TREEDEPTH, treedepth);
        error++;
      }
    treedepth++;
    if (dwg_dynapi_header_set_value (dwg, "TREEDEPTH", &treedepth)
        && treedepth == dwg->header_vars.TREEDEPTH)
      {
        pass ("HEADER.TREEDEPTH [BS] set+1 %hu", treedepth);
      }
    else
      {
        fail ("HEADER.TREEDEPTH [BS] set+1 %hu != %hu",
              dwg->header_vars.TREEDEPTH, treedepth);
        error++;
      }
    treedepth--;
    dwg_dynapi_header_set_value (dwg, "TREEDEPTH", &treedepth);

  }
  {
    BITCODE_BS lunits;
    if (dwg_dynapi_header_value (dwg, "LUNITS", &lunits, NULL)
        && lunits == dwg->header_vars.LUNITS)
      {
        pass ("HEADER.LUNITS [BS] %hu", lunits);
      }
    else
      {
        fail ("HEADER.LUNITS [BS] %hu != %hu", dwg->header_vars.LUNITS, lunits);
        error++;
      }
    lunits++;
    if (dwg_dynapi_header_set_value (dwg, "LUNITS", &lunits)
        && lunits == dwg->header_vars.LUNITS)
      {
        pass ("HEADER.LUNITS [BS] set+1 %hu", lunits);
      }
    else
      {
        fail ("HEADER.LUNITS [BS] set+1 %hu != %hu",
              dwg->header_vars.LUNITS, lunits);
        error++;
      }
    lunits--;
    dwg_dynapi_header_set_value (dwg, "LUNITS", &lunits);

  }
  {
    BITCODE_BS luprec;
    if (dwg_dynapi_header_value (dwg, "LUPREC", &luprec, NULL)
        && luprec == dwg->header_vars.LUPREC)
      {
        pass ("HEADER.LUPREC [BS] %hu", luprec);
      }
    else
      {
        fail ("HEADER.LUPREC [BS] %hu != %hu", dwg->header_vars.LUPREC, luprec);
        error++;
      }
    luprec++;
    if (dwg_dynapi_header_set_value (dwg, "LUPREC", &luprec)
        && luprec == dwg->header_vars.LUPREC)
      {
        pass ("HEADER.LUPREC [BS] set+1 %hu", luprec);
      }
    else
      {
        fail ("HEADER.LUPREC [BS] set+1 %hu != %hu",
              dwg->header_vars.LUPREC, luprec);
        error++;
      }
    luprec--;
    dwg_dynapi_header_set_value (dwg, "LUPREC", &luprec);

  }
  {
    BITCODE_BS aunits;
    if (dwg_dynapi_header_value (dwg, "AUNITS", &aunits, NULL)
        && aunits == dwg->header_vars.AUNITS)
      {
        pass ("HEADER.AUNITS [BS] %hu", aunits);
      }
    else
      {
        fail ("HEADER.AUNITS [BS] %hu != %hu", dwg->header_vars.AUNITS, aunits);
        error++;
      }
    aunits++;
    if (dwg_dynapi_header_set_value (dwg, "AUNITS", &aunits)
        && aunits == dwg->header_vars.AUNITS)
      {
        pass ("HEADER.AUNITS [BS] set+1 %hu", aunits);
      }
    else
      {
        fail ("HEADER.AUNITS [BS] set+1 %hu != %hu",
              dwg->header_vars.AUNITS, aunits);
        error++;
      }
    aunits--;
    dwg_dynapi_header_set_value (dwg, "AUNITS", &aunits);

  }
  {
    BITCODE_BS auprec;
    if (dwg_dynapi_header_value (dwg, "AUPREC", &auprec, NULL)
        && auprec == dwg->header_vars.AUPREC)
      {
        pass ("HEADER.AUPREC [BS] %hu", auprec);
      }
    else
      {
        fail ("HEADER.AUPREC [BS] %hu != %hu", dwg->header_vars.AUPREC, auprec);
        error++;
      }
    auprec++;
    if (dwg_dynapi_header_set_value (dwg, "AUPREC", &auprec)
        && auprec == dwg->header_vars.AUPREC)
      {
        pass ("HEADER.AUPREC [BS] set+1 %hu", auprec);
      }
    else
      {
        fail ("HEADER.AUPREC [BS] set+1 %hu != %hu",
              dwg->header_vars.AUPREC, auprec);
        error++;
      }
    auprec--;
    dwg_dynapi_header_set_value (dwg, "AUPREC", &auprec);

  }
  {
    BITCODE_BS osmode;
    if (dwg_dynapi_header_value (dwg, "OSMODE", &osmode, NULL)
        && osmode == dwg->header_vars.OSMODE)
      {
        pass ("HEADER.OSMODE [BS] %hu", osmode);
      }
    else
      {
        fail ("HEADER.OSMODE [BS] %hu != %hu", dwg->header_vars.OSMODE, osmode);
        error++;
      }
    osmode++;
    if (dwg_dynapi_header_set_value (dwg, "OSMODE", &osmode)
        && osmode == dwg->header_vars.OSMODE)
      {
        pass ("HEADER.OSMODE [BS] set+1 %hu", osmode);
      }
    else
      {
        fail ("HEADER.OSMODE [BS] set+1 %hu != %hu",
              dwg->header_vars.OSMODE, osmode);
        error++;
      }
    osmode--;
    dwg_dynapi_header_set_value (dwg, "OSMODE", &osmode);

  }
  {
    BITCODE_BS attmode;
    if (dwg_dynapi_header_value (dwg, "ATTMODE", &attmode, NULL)
        && attmode == dwg->header_vars.ATTMODE)
      {
        pass ("HEADER.ATTMODE [BS] %hu", attmode);
      }
    else
      {
        fail ("HEADER.ATTMODE [BS] %hu != %hu", dwg->header_vars.ATTMODE, attmode);
        error++;
      }
    attmode++;
    if (dwg_dynapi_header_set_value (dwg, "ATTMODE", &attmode)
        && attmode == dwg->header_vars.ATTMODE)
      {
        pass ("HEADER.ATTMODE [BS] set+1 %hu", attmode);
      }
    else
      {
        fail ("HEADER.ATTMODE [BS] set+1 %hu != %hu",
              dwg->header_vars.ATTMODE, attmode);
        error++;
      }
    attmode--;
    dwg_dynapi_header_set_value (dwg, "ATTMODE", &attmode);

  }
  {
    BITCODE_BS coords;
    if (dwg_dynapi_header_value (dwg, "COORDS", &coords, NULL)
        && coords == dwg->header_vars.COORDS)
      {
        pass ("HEADER.COORDS [BS] %hu", coords);
      }
    else
      {
        fail ("HEADER.COORDS [BS] %hu != %hu", dwg->header_vars.COORDS, coords);
        error++;
      }
    coords++;
    if (dwg_dynapi_header_set_value (dwg, "COORDS", &coords)
        && coords == dwg->header_vars.COORDS)
      {
        pass ("HEADER.COORDS [BS] set+1 %hu", coords);
      }
    else
      {
        fail ("HEADER.COORDS [BS] set+1 %hu != %hu",
              dwg->header_vars.COORDS, coords);
        error++;
      }
    coords--;
    dwg_dynapi_header_set_value (dwg, "COORDS", &coords);

  }
  {
    BITCODE_BS pdmode;
    if (dwg_dynapi_header_value (dwg, "PDMODE", &pdmode, NULL)
        && pdmode == dwg->header_vars.PDMODE)
      {
        pass ("HEADER.PDMODE [BS] %hu", pdmode);
      }
    else
      {
        fail ("HEADER.PDMODE [BS] %hu != %hu", dwg->header_vars.PDMODE, pdmode);
        error++;
      }
    pdmode++;
    if (dwg_dynapi_header_set_value (dwg, "PDMODE", &pdmode)
        && pdmode == dwg->header_vars.PDMODE)
      {
        pass ("HEADER.PDMODE [BS] set+1 %hu", pdmode);
      }
    else
      {
        fail ("HEADER.PDMODE [BS] set+1 %hu != %hu",
              dwg->header_vars.PDMODE, pdmode);
        error++;
      }
    pdmode--;
    dwg_dynapi_header_set_value (dwg, "PDMODE", &pdmode);

  }
  {
    BITCODE_BS pickstyle;
    if (dwg_dynapi_header_value (dwg, "PICKSTYLE", &pickstyle, NULL)
        && pickstyle == dwg->header_vars.PICKSTYLE)
      {
        pass ("HEADER.PICKSTYLE [BS] %hu", pickstyle);
      }
    else
      {
        fail ("HEADER.PICKSTYLE [BS] %hu != %hu", dwg->header_vars.PICKSTYLE, pickstyle);
        error++;
      }
    pickstyle++;
    if (dwg_dynapi_header_set_value (dwg, "PICKSTYLE", &pickstyle)
        && pickstyle == dwg->header_vars.PICKSTYLE)
      {
        pass ("HEADER.PICKSTYLE [BS] set+1 %hu", pickstyle);
      }
    else
      {
        fail ("HEADER.PICKSTYLE [BS] set+1 %hu != %hu",
              dwg->header_vars.PICKSTYLE, pickstyle);
        error++;
      }
    pickstyle--;
    dwg_dynapi_header_set_value (dwg, "PICKSTYLE", &pickstyle);

  }
  {
    BITCODE_BL unknown_12;
    if (dwg_dynapi_header_value (dwg, "unknown_12", &unknown_12, NULL)
        && unknown_12 == dwg->header_vars.unknown_12)
      {
        pass ("HEADER.unknown_12 [BL] %u", unknown_12);
      }
    else
      {
        fail ("HEADER.unknown_12 [BL] %u != %u", dwg->header_vars.unknown_12, unknown_12);
        error++;
      }
    unknown_12++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_12", &unknown_12)
        && unknown_12 == dwg->header_vars.unknown_12)
      {
        pass ("HEADER.unknown_12 [BL] set+1 %u", unknown_12);
      }
    else
      {
        fail ("HEADER.unknown_12 [BL] set+1 %u != %u",
              dwg->header_vars.unknown_12, unknown_12);
        error++;
      }
    unknown_12--;
    dwg_dynapi_header_set_value (dwg, "unknown_12", &unknown_12);

  }
  {
    BITCODE_BL unknown_13;
    if (dwg_dynapi_header_value (dwg, "unknown_13", &unknown_13, NULL)
        && unknown_13 == dwg->header_vars.unknown_13)
      {
        pass ("HEADER.unknown_13 [BL] %u", unknown_13);
      }
    else
      {
        fail ("HEADER.unknown_13 [BL] %u != %u", dwg->header_vars.unknown_13, unknown_13);
        error++;
      }
    unknown_13++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_13", &unknown_13)
        && unknown_13 == dwg->header_vars.unknown_13)
      {
        pass ("HEADER.unknown_13 [BL] set+1 %u", unknown_13);
      }
    else
      {
        fail ("HEADER.unknown_13 [BL] set+1 %u != %u",
              dwg->header_vars.unknown_13, unknown_13);
        error++;
      }
    unknown_13--;
    dwg_dynapi_header_set_value (dwg, "unknown_13", &unknown_13);

  }
  {
    BITCODE_BL unknown_14;
    if (dwg_dynapi_header_value (dwg, "unknown_14", &unknown_14, NULL)
        && unknown_14 == dwg->header_vars.unknown_14)
      {
        pass ("HEADER.unknown_14 [BL] %u", unknown_14);
      }
    else
      {
        fail ("HEADER.unknown_14 [BL] %u != %u", dwg->header_vars.unknown_14, unknown_14);
        error++;
      }
    unknown_14++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_14", &unknown_14)
        && unknown_14 == dwg->header_vars.unknown_14)
      {
        pass ("HEADER.unknown_14 [BL] set+1 %u", unknown_14);
      }
    else
      {
        fail ("HEADER.unknown_14 [BL] set+1 %u != %u",
              dwg->header_vars.unknown_14, unknown_14);
        error++;
      }
    unknown_14--;
    dwg_dynapi_header_set_value (dwg, "unknown_14", &unknown_14);

  }
  {
    BITCODE_BS useri1;
    if (dwg_dynapi_header_value (dwg, "USERI1", &useri1, NULL)
        && useri1 == dwg->header_vars.USERI1)
      {
        pass ("HEADER.USERI1 [BS] %hu", useri1);
      }
    else
      {
        fail ("HEADER.USERI1 [BS] %hu != %hu", dwg->header_vars.USERI1, useri1);
        error++;
      }
    useri1++;
    if (dwg_dynapi_header_set_value (dwg, "USERI1", &useri1)
        && useri1 == dwg->header_vars.USERI1)
      {
        pass ("HEADER.USERI1 [BS] set+1 %hu", useri1);
      }
    else
      {
        fail ("HEADER.USERI1 [BS] set+1 %hu != %hu",
              dwg->header_vars.USERI1, useri1);
        error++;
      }
    useri1--;
    dwg_dynapi_header_set_value (dwg, "USERI1", &useri1);

  }
  {
    BITCODE_BS useri2;
    if (dwg_dynapi_header_value (dwg, "USERI2", &useri2, NULL)
        && useri2 == dwg->header_vars.USERI2)
      {
        pass ("HEADER.USERI2 [BS] %hu", useri2);
      }
    else
      {
        fail ("HEADER.USERI2 [BS] %hu != %hu", dwg->header_vars.USERI2, useri2);
        error++;
      }
    useri2++;
    if (dwg_dynapi_header_set_value (dwg, "USERI2", &useri2)
        && useri2 == dwg->header_vars.USERI2)
      {
        pass ("HEADER.USERI2 [BS] set+1 %hu", useri2);
      }
    else
      {
        fail ("HEADER.USERI2 [BS] set+1 %hu != %hu",
              dwg->header_vars.USERI2, useri2);
        error++;
      }
    useri2--;
    dwg_dynapi_header_set_value (dwg, "USERI2", &useri2);

  }
  {
    BITCODE_BS useri3;
    if (dwg_dynapi_header_value (dwg, "USERI3", &useri3, NULL)
        && useri3 == dwg->header_vars.USERI3)
      {
        pass ("HEADER.USERI3 [BS] %hu", useri3);
      }
    else
      {
        fail ("HEADER.USERI3 [BS] %hu != %hu", dwg->header_vars.USERI3, useri3);
        error++;
      }
    useri3++;
    if (dwg_dynapi_header_set_value (dwg, "USERI3", &useri3)
        && useri3 == dwg->header_vars.USERI3)
      {
        pass ("HEADER.USERI3 [BS] set+1 %hu", useri3);
      }
    else
      {
        fail ("HEADER.USERI3 [BS] set+1 %hu != %hu",
              dwg->header_vars.USERI3, useri3);
        error++;
      }
    useri3--;
    dwg_dynapi_header_set_value (dwg, "USERI3", &useri3);

  }
  {
    BITCODE_BS useri4;
    if (dwg_dynapi_header_value (dwg, "USERI4", &useri4, NULL)
        && useri4 == dwg->header_vars.USERI4)
      {
        pass ("HEADER.USERI4 [BS] %hu", useri4);
      }
    else
      {
        fail ("HEADER.USERI4 [BS] %hu != %hu", dwg->header_vars.USERI4, useri4);
        error++;
      }
    useri4++;
    if (dwg_dynapi_header_set_value (dwg, "USERI4", &useri4)
        && useri4 == dwg->header_vars.USERI4)
      {
        pass ("HEADER.USERI4 [BS] set+1 %hu", useri4);
      }
    else
      {
        fail ("HEADER.USERI4 [BS] set+1 %hu != %hu",
              dwg->header_vars.USERI4, useri4);
        error++;
      }
    useri4--;
    dwg_dynapi_header_set_value (dwg, "USERI4", &useri4);

  }
  {
    BITCODE_BS useri5;
    if (dwg_dynapi_header_value (dwg, "USERI5", &useri5, NULL)
        && useri5 == dwg->header_vars.USERI5)
      {
        pass ("HEADER.USERI5 [BS] %hu", useri5);
      }
    else
      {
        fail ("HEADER.USERI5 [BS] %hu != %hu", dwg->header_vars.USERI5, useri5);
        error++;
      }
    useri5++;
    if (dwg_dynapi_header_set_value (dwg, "USERI5", &useri5)
        && useri5 == dwg->header_vars.USERI5)
      {
        pass ("HEADER.USERI5 [BS] set+1 %hu", useri5);
      }
    else
      {
        fail ("HEADER.USERI5 [BS] set+1 %hu != %hu",
              dwg->header_vars.USERI5, useri5);
        error++;
      }
    useri5--;
    dwg_dynapi_header_set_value (dwg, "USERI5", &useri5);

  }
  {
    BITCODE_BS splinesegs;
    if (dwg_dynapi_header_value (dwg, "SPLINESEGS", &splinesegs, NULL)
        && splinesegs == dwg->header_vars.SPLINESEGS)
      {
        pass ("HEADER.SPLINESEGS [BS] %hu", splinesegs);
      }
    else
      {
        fail ("HEADER.SPLINESEGS [BS] %hu != %hu", dwg->header_vars.SPLINESEGS, splinesegs);
        error++;
      }
    splinesegs++;
    if (dwg_dynapi_header_set_value (dwg, "SPLINESEGS", &splinesegs)
        && splinesegs == dwg->header_vars.SPLINESEGS)
      {
        pass ("HEADER.SPLINESEGS [BS] set+1 %hu", splinesegs);
      }
    else
      {
        fail ("HEADER.SPLINESEGS [BS] set+1 %hu != %hu",
              dwg->header_vars.SPLINESEGS, splinesegs);
        error++;
      }
    splinesegs--;
    dwg_dynapi_header_set_value (dwg, "SPLINESEGS", &splinesegs);

  }
  {
    BITCODE_BS surfu;
    if (dwg_dynapi_header_value (dwg, "SURFU", &surfu, NULL)
        && surfu == dwg->header_vars.SURFU)
      {
        pass ("HEADER.SURFU [BS] %hu", surfu);
      }
    else
      {
        fail ("HEADER.SURFU [BS] %hu != %hu", dwg->header_vars.SURFU, surfu);
        error++;
      }
    surfu++;
    if (dwg_dynapi_header_set_value (dwg, "SURFU", &surfu)
        && surfu == dwg->header_vars.SURFU)
      {
        pass ("HEADER.SURFU [BS] set+1 %hu", surfu);
      }
    else
      {
        fail ("HEADER.SURFU [BS] set+1 %hu != %hu",
              dwg->header_vars.SURFU, surfu);
        error++;
      }
    surfu--;
    dwg_dynapi_header_set_value (dwg, "SURFU", &surfu);

  }
  {
    BITCODE_BS surfv;
    if (dwg_dynapi_header_value (dwg, "SURFV", &surfv, NULL)
        && surfv == dwg->header_vars.SURFV)
      {
        pass ("HEADER.SURFV [BS] %hu", surfv);
      }
    else
      {
        fail ("HEADER.SURFV [BS] %hu != %hu", dwg->header_vars.SURFV, surfv);
        error++;
      }
    surfv++;
    if (dwg_dynapi_header_set_value (dwg, "SURFV", &surfv)
        && surfv == dwg->header_vars.SURFV)
      {
        pass ("HEADER.SURFV [BS] set+1 %hu", surfv);
      }
    else
      {
        fail ("HEADER.SURFV [BS] set+1 %hu != %hu",
              dwg->header_vars.SURFV, surfv);
        error++;
      }
    surfv--;
    dwg_dynapi_header_set_value (dwg, "SURFV", &surfv);

  }
  {
    BITCODE_BS surftype;
    if (dwg_dynapi_header_value (dwg, "SURFTYPE", &surftype, NULL)
        && surftype == dwg->header_vars.SURFTYPE)
      {
        pass ("HEADER.SURFTYPE [BS] %hu", surftype);
      }
    else
      {
        fail ("HEADER.SURFTYPE [BS] %hu != %hu", dwg->header_vars.SURFTYPE, surftype);
        error++;
      }
    surftype++;
    if (dwg_dynapi_header_set_value (dwg, "SURFTYPE", &surftype)
        && surftype == dwg->header_vars.SURFTYPE)
      {
        pass ("HEADER.SURFTYPE [BS] set+1 %hu", surftype);
      }
    else
      {
        fail ("HEADER.SURFTYPE [BS] set+1 %hu != %hu",
              dwg->header_vars.SURFTYPE, surftype);
        error++;
      }
    surftype--;
    dwg_dynapi_header_set_value (dwg, "SURFTYPE", &surftype);

  }
  {
    BITCODE_BS surftab1;
    if (dwg_dynapi_header_value (dwg, "SURFTAB1", &surftab1, NULL)
        && surftab1 == dwg->header_vars.SURFTAB1)
      {
        pass ("HEADER.SURFTAB1 [BS] %hu", surftab1);
      }
    else
      {
        fail ("HEADER.SURFTAB1 [BS] %hu != %hu", dwg->header_vars.SURFTAB1, surftab1);
        error++;
      }
    surftab1++;
    if (dwg_dynapi_header_set_value (dwg, "SURFTAB1", &surftab1)
        && surftab1 == dwg->header_vars.SURFTAB1)
      {
        pass ("HEADER.SURFTAB1 [BS] set+1 %hu", surftab1);
      }
    else
      {
        fail ("HEADER.SURFTAB1 [BS] set+1 %hu != %hu",
              dwg->header_vars.SURFTAB1, surftab1);
        error++;
      }
    surftab1--;
    dwg_dynapi_header_set_value (dwg, "SURFTAB1", &surftab1);

  }
  {
    BITCODE_BS surftab2;
    if (dwg_dynapi_header_value (dwg, "SURFTAB2", &surftab2, NULL)
        && surftab2 == dwg->header_vars.SURFTAB2)
      {
        pass ("HEADER.SURFTAB2 [BS] %hu", surftab2);
      }
    else
      {
        fail ("HEADER.SURFTAB2 [BS] %hu != %hu", dwg->header_vars.SURFTAB2, surftab2);
        error++;
      }
    surftab2++;
    if (dwg_dynapi_header_set_value (dwg, "SURFTAB2", &surftab2)
        && surftab2 == dwg->header_vars.SURFTAB2)
      {
        pass ("HEADER.SURFTAB2 [BS] set+1 %hu", surftab2);
      }
    else
      {
        fail ("HEADER.SURFTAB2 [BS] set+1 %hu != %hu",
              dwg->header_vars.SURFTAB2, surftab2);
        error++;
      }
    surftab2--;
    dwg_dynapi_header_set_value (dwg, "SURFTAB2", &surftab2);

  }
  {
    BITCODE_BS splinetype;
    if (dwg_dynapi_header_value (dwg, "SPLINETYPE", &splinetype, NULL)
        && splinetype == dwg->header_vars.SPLINETYPE)
      {
        pass ("HEADER.SPLINETYPE [BS] %hu", splinetype);
      }
    else
      {
        fail ("HEADER.SPLINETYPE [BS] %hu != %hu", dwg->header_vars.SPLINETYPE, splinetype);
        error++;
      }
    splinetype++;
    if (dwg_dynapi_header_set_value (dwg, "SPLINETYPE", &splinetype)
        && splinetype == dwg->header_vars.SPLINETYPE)
      {
        pass ("HEADER.SPLINETYPE [BS] set+1 %hu", splinetype);
      }
    else
      {
        fail ("HEADER.SPLINETYPE [BS] set+1 %hu != %hu",
              dwg->header_vars.SPLINETYPE, splinetype);
        error++;
      }
    splinetype--;
    dwg_dynapi_header_set_value (dwg, "SPLINETYPE", &splinetype);

  }
  {
    BITCODE_BS shadedge;
    if (dwg_dynapi_header_value (dwg, "SHADEDGE", &shadedge, NULL)
        && shadedge == dwg->header_vars.SHADEDGE)
      {
        pass ("HEADER.SHADEDGE [BS] %hu", shadedge);
      }
    else
      {
        fail ("HEADER.SHADEDGE [BS] %hu != %hu", dwg->header_vars.SHADEDGE, shadedge);
        error++;
      }
    shadedge++;
    if (dwg_dynapi_header_set_value (dwg, "SHADEDGE", &shadedge)
        && shadedge == dwg->header_vars.SHADEDGE)
      {
        pass ("HEADER.SHADEDGE [BS] set+1 %hu", shadedge);
      }
    else
      {
        fail ("HEADER.SHADEDGE [BS] set+1 %hu != %hu",
              dwg->header_vars.SHADEDGE, shadedge);
        error++;
      }
    shadedge--;
    dwg_dynapi_header_set_value (dwg, "SHADEDGE", &shadedge);

  }
  {
    BITCODE_BS shadedif;
    if (dwg_dynapi_header_value (dwg, "SHADEDIF", &shadedif, NULL)
        && shadedif == dwg->header_vars.SHADEDIF)
      {
        pass ("HEADER.SHADEDIF [BS] %hu", shadedif);
      }
    else
      {
        fail ("HEADER.SHADEDIF [BS] %hu != %hu", dwg->header_vars.SHADEDIF, shadedif);
        error++;
      }
    shadedif++;
    if (dwg_dynapi_header_set_value (dwg, "SHADEDIF", &shadedif)
        && shadedif == dwg->header_vars.SHADEDIF)
      {
        pass ("HEADER.SHADEDIF [BS] set+1 %hu", shadedif);
      }
    else
      {
        fail ("HEADER.SHADEDIF [BS] set+1 %hu != %hu",
              dwg->header_vars.SHADEDIF, shadedif);
        error++;
      }
    shadedif--;
    dwg_dynapi_header_set_value (dwg, "SHADEDIF", &shadedif);

  }
  {
    BITCODE_BS unitmode;
    if (dwg_dynapi_header_value (dwg, "UNITMODE", &unitmode, NULL)
        && unitmode == dwg->header_vars.UNITMODE)
      {
        pass ("HEADER.UNITMODE [BS] %hu", unitmode);
      }
    else
      {
        fail ("HEADER.UNITMODE [BS] %hu != %hu", dwg->header_vars.UNITMODE, unitmode);
        error++;
      }
    unitmode++;
    if (dwg_dynapi_header_set_value (dwg, "UNITMODE", &unitmode)
        && unitmode == dwg->header_vars.UNITMODE)
      {
        pass ("HEADER.UNITMODE [BS] set+1 %hu", unitmode);
      }
    else
      {
        fail ("HEADER.UNITMODE [BS] set+1 %hu != %hu",
              dwg->header_vars.UNITMODE, unitmode);
        error++;
      }
    unitmode--;
    dwg_dynapi_header_set_value (dwg, "UNITMODE", &unitmode);

  }
  {
    BITCODE_BS maxactvp;
    if (dwg_dynapi_header_value (dwg, "MAXACTVP", &maxactvp, NULL)
        && maxactvp == dwg->header_vars.MAXACTVP)
      {
        pass ("HEADER.MAXACTVP [BS] %hu", maxactvp);
      }
    else
      {
        fail ("HEADER.MAXACTVP [BS] %hu != %hu", dwg->header_vars.MAXACTVP, maxactvp);
        error++;
      }
    maxactvp++;
    if (dwg_dynapi_header_set_value (dwg, "MAXACTVP", &maxactvp)
        && maxactvp == dwg->header_vars.MAXACTVP)
      {
        pass ("HEADER.MAXACTVP [BS] set+1 %hu", maxactvp);
      }
    else
      {
        fail ("HEADER.MAXACTVP [BS] set+1 %hu != %hu",
              dwg->header_vars.MAXACTVP, maxactvp);
        error++;
      }
    maxactvp--;
    dwg_dynapi_header_set_value (dwg, "MAXACTVP", &maxactvp);

  }
  {
    BITCODE_BS isolines;
    if (dwg_dynapi_header_value (dwg, "ISOLINES", &isolines, NULL)
        && isolines == dwg->header_vars.ISOLINES)
      {
        pass ("HEADER.ISOLINES [BS] %hu", isolines);
      }
    else
      {
        fail ("HEADER.ISOLINES [BS] %hu != %hu", dwg->header_vars.ISOLINES, isolines);
        error++;
      }
    isolines++;
    if (dwg_dynapi_header_set_value (dwg, "ISOLINES", &isolines)
        && isolines == dwg->header_vars.ISOLINES)
      {
        pass ("HEADER.ISOLINES [BS] set+1 %hu", isolines);
      }
    else
      {
        fail ("HEADER.ISOLINES [BS] set+1 %hu != %hu",
              dwg->header_vars.ISOLINES, isolines);
        error++;
      }
    isolines--;
    dwg_dynapi_header_set_value (dwg, "ISOLINES", &isolines);

  }
  {
    BITCODE_BS cmljust;
    if (dwg_dynapi_header_value (dwg, "CMLJUST", &cmljust, NULL)
        && cmljust == dwg->header_vars.CMLJUST)
      {
        pass ("HEADER.CMLJUST [BS] %hu", cmljust);
      }
    else
      {
        fail ("HEADER.CMLJUST [BS] %hu != %hu", dwg->header_vars.CMLJUST, cmljust);
        error++;
      }
    cmljust++;
    if (dwg_dynapi_header_set_value (dwg, "CMLJUST", &cmljust)
        && cmljust == dwg->header_vars.CMLJUST)
      {
        pass ("HEADER.CMLJUST [BS] set+1 %hu", cmljust);
      }
    else
      {
        fail ("HEADER.CMLJUST [BS] set+1 %hu != %hu",
              dwg->header_vars.CMLJUST, cmljust);
        error++;
      }
    cmljust--;
    dwg_dynapi_header_set_value (dwg, "CMLJUST", &cmljust);

  }
  {
    BITCODE_BS textqlty;
    if (dwg_dynapi_header_value (dwg, "TEXTQLTY", &textqlty, NULL)
        && textqlty == dwg->header_vars.TEXTQLTY)
      {
        pass ("HEADER.TEXTQLTY [BS] %hu", textqlty);
      }
    else
      {
        fail ("HEADER.TEXTQLTY [BS] %hu != %hu", dwg->header_vars.TEXTQLTY, textqlty);
        error++;
      }
    textqlty++;
    if (dwg_dynapi_header_set_value (dwg, "TEXTQLTY", &textqlty)
        && textqlty == dwg->header_vars.TEXTQLTY)
      {
        pass ("HEADER.TEXTQLTY [BS] set+1 %hu", textqlty);
      }
    else
      {
        fail ("HEADER.TEXTQLTY [BS] set+1 %hu != %hu",
              dwg->header_vars.TEXTQLTY, textqlty);
        error++;
      }
    textqlty--;
    dwg_dynapi_header_set_value (dwg, "TEXTQLTY", &textqlty);

  }
  {
    BITCODE_BL unknown_14b;
    if (dwg_dynapi_header_value (dwg, "unknown_14b", &unknown_14b, NULL)
        && unknown_14b == dwg->header_vars.unknown_14b)
      {
        pass ("HEADER.unknown_14b [BL] %u", unknown_14b);
      }
    else
      {
        fail ("HEADER.unknown_14b [BL] %u != %u", dwg->header_vars.unknown_14b, unknown_14b);
        error++;
      }
    unknown_14b++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_14b", &unknown_14b)
        && unknown_14b == dwg->header_vars.unknown_14b)
      {
        pass ("HEADER.unknown_14b [BL] set+1 %u", unknown_14b);
      }
    else
      {
        fail ("HEADER.unknown_14b [BL] set+1 %u != %u",
              dwg->header_vars.unknown_14b, unknown_14b);
        error++;
      }
    unknown_14b--;
    dwg_dynapi_header_set_value (dwg, "unknown_14b", &unknown_14b);

  }
  {
    BITCODE_BD ltscale;
    if (dwg_dynapi_header_value (dwg, "LTSCALE", &ltscale, NULL)
        && ltscale == dwg->header_vars.LTSCALE)
      {
        pass ("HEADER.LTSCALE [BD] %g", ltscale);
      }
    else
      {
        fail ("HEADER.LTSCALE [BD] %g != %g", dwg->header_vars.LTSCALE, ltscale);
        error++;
      }
    ltscale++;
    if (dwg_dynapi_header_set_value (dwg, "LTSCALE", &ltscale)
        && ltscale == dwg->header_vars.LTSCALE)
      {
        pass ("HEADER.LTSCALE [BD] set+1 %g", ltscale);
      }
    else
      {
        fail ("HEADER.LTSCALE [BD] set+1 %g != %g",
              dwg->header_vars.LTSCALE, ltscale);
        error++;
      }
    ltscale--;
    dwg_dynapi_header_set_value (dwg, "LTSCALE", &ltscale);

  }
  {
    BITCODE_BD textsize;
    if (dwg_dynapi_header_value (dwg, "TEXTSIZE", &textsize, NULL)
        && textsize == dwg->header_vars.TEXTSIZE)
      {
        pass ("HEADER.TEXTSIZE [BD] %g", textsize);
      }
    else
      {
        fail ("HEADER.TEXTSIZE [BD] %g != %g", dwg->header_vars.TEXTSIZE, textsize);
        error++;
      }
    textsize++;
    if (dwg_dynapi_header_set_value (dwg, "TEXTSIZE", &textsize)
        && textsize == dwg->header_vars.TEXTSIZE)
      {
        pass ("HEADER.TEXTSIZE [BD] set+1 %g", textsize);
      }
    else
      {
        fail ("HEADER.TEXTSIZE [BD] set+1 %g != %g",
              dwg->header_vars.TEXTSIZE, textsize);
        error++;
      }
    textsize--;
    dwg_dynapi_header_set_value (dwg, "TEXTSIZE", &textsize);

  }
  {
    BITCODE_BD tracewid;
    if (dwg_dynapi_header_value (dwg, "TRACEWID", &tracewid, NULL)
        && tracewid == dwg->header_vars.TRACEWID)
      {
        pass ("HEADER.TRACEWID [BD] %g", tracewid);
      }
    else
      {
        fail ("HEADER.TRACEWID [BD] %g != %g", dwg->header_vars.TRACEWID, tracewid);
        error++;
      }
    tracewid++;
    if (dwg_dynapi_header_set_value (dwg, "TRACEWID", &tracewid)
        && tracewid == dwg->header_vars.TRACEWID)
      {
        pass ("HEADER.TRACEWID [BD] set+1 %g", tracewid);
      }
    else
      {
        fail ("HEADER.TRACEWID [BD] set+1 %g != %g",
              dwg->header_vars.TRACEWID, tracewid);
        error++;
      }
    tracewid--;
    dwg_dynapi_header_set_value (dwg, "TRACEWID", &tracewid);

  }
  {
    BITCODE_BD sketchinc;
    if (dwg_dynapi_header_value (dwg, "SKETCHINC", &sketchinc, NULL)
        && sketchinc == dwg->header_vars.SKETCHINC)
      {
        pass ("HEADER.SKETCHINC [BD] %g", sketchinc);
      }
    else
      {
        fail ("HEADER.SKETCHINC [BD] %g != %g", dwg->header_vars.SKETCHINC, sketchinc);
        error++;
      }
    sketchinc++;
    if (dwg_dynapi_header_set_value (dwg, "SKETCHINC", &sketchinc)
        && sketchinc == dwg->header_vars.SKETCHINC)
      {
        pass ("HEADER.SKETCHINC [BD] set+1 %g", sketchinc);
      }
    else
      {
        fail ("HEADER.SKETCHINC [BD] set+1 %g != %g",
              dwg->header_vars.SKETCHINC, sketchinc);
        error++;
      }
    sketchinc--;
    dwg_dynapi_header_set_value (dwg, "SKETCHINC", &sketchinc);

  }
  {
    BITCODE_BD filletrad;
    if (dwg_dynapi_header_value (dwg, "FILLETRAD", &filletrad, NULL)
        && filletrad == dwg->header_vars.FILLETRAD)
      {
        pass ("HEADER.FILLETRAD [BD] %g", filletrad);
      }
    else
      {
        fail ("HEADER.FILLETRAD [BD] %g != %g", dwg->header_vars.FILLETRAD, filletrad);
        error++;
      }
    filletrad++;
    if (dwg_dynapi_header_set_value (dwg, "FILLETRAD", &filletrad)
        && filletrad == dwg->header_vars.FILLETRAD)
      {
        pass ("HEADER.FILLETRAD [BD] set+1 %g", filletrad);
      }
    else
      {
        fail ("HEADER.FILLETRAD [BD] set+1 %g != %g",
              dwg->header_vars.FILLETRAD, filletrad);
        error++;
      }
    filletrad--;
    dwg_dynapi_header_set_value (dwg, "FILLETRAD", &filletrad);

  }
  {
    BITCODE_BD thickness;
    if (dwg_dynapi_header_value (dwg, "THICKNESS", &thickness, NULL)
        && thickness == dwg->header_vars.THICKNESS)
      {
        pass ("HEADER.THICKNESS [BD] %g", thickness);
      }
    else
      {
        fail ("HEADER.THICKNESS [BD] %g != %g", dwg->header_vars.THICKNESS, thickness);
        error++;
      }
    thickness++;
    if (dwg_dynapi_header_set_value (dwg, "THICKNESS", &thickness)
        && thickness == dwg->header_vars.THICKNESS)
      {
        pass ("HEADER.THICKNESS [BD] set+1 %g", thickness);
      }
    else
      {
        fail ("HEADER.THICKNESS [BD] set+1 %g != %g",
              dwg->header_vars.THICKNESS, thickness);
        error++;
      }
    thickness--;
    dwg_dynapi_header_set_value (dwg, "THICKNESS", &thickness);

  }
  {
    BITCODE_BD angbase;
    if (dwg_dynapi_header_value (dwg, "ANGBASE", &angbase, NULL)
        && angbase == dwg->header_vars.ANGBASE)
      {
        pass ("HEADER.ANGBASE [BD] %g", angbase);
      }
    else
      {
        fail ("HEADER.ANGBASE [BD] %g != %g", dwg->header_vars.ANGBASE, angbase);
        error++;
      }
    angbase++;
    if (dwg_dynapi_header_set_value (dwg, "ANGBASE", &angbase)
        && angbase == dwg->header_vars.ANGBASE)
      {
        pass ("HEADER.ANGBASE [BD] set+1 %g", angbase);
      }
    else
      {
        fail ("HEADER.ANGBASE [BD] set+1 %g != %g",
              dwg->header_vars.ANGBASE, angbase);
        error++;
      }
    angbase--;
    dwg_dynapi_header_set_value (dwg, "ANGBASE", &angbase);

  }
  {
    BITCODE_BD pdsize;
    if (dwg_dynapi_header_value (dwg, "PDSIZE", &pdsize, NULL)
        && pdsize == dwg->header_vars.PDSIZE)
      {
        pass ("HEADER.PDSIZE [BD] %g", pdsize);
      }
    else
      {
        fail ("HEADER.PDSIZE [BD] %g != %g", dwg->header_vars.PDSIZE, pdsize);
        error++;
      }
    pdsize++;
    if (dwg_dynapi_header_set_value (dwg, "PDSIZE", &pdsize)
        && pdsize == dwg->header_vars.PDSIZE)
      {
        pass ("HEADER.PDSIZE [BD] set+1 %g", pdsize);
      }
    else
      {
        fail ("HEADER.PDSIZE [BD] set+1 %g != %g",
              dwg->header_vars.PDSIZE, pdsize);
        error++;
      }
    pdsize--;
    dwg_dynapi_header_set_value (dwg, "PDSIZE", &pdsize);

  }
  {
    BITCODE_BD plinewid;
    if (dwg_dynapi_header_value (dwg, "PLINEWID", &plinewid, NULL)
        && plinewid == dwg->header_vars.PLINEWID)
      {
        pass ("HEADER.PLINEWID [BD] %g", plinewid);
      }
    else
      {
        fail ("HEADER.PLINEWID [BD] %g != %g", dwg->header_vars.PLINEWID, plinewid);
        error++;
      }
    plinewid++;
    if (dwg_dynapi_header_set_value (dwg, "PLINEWID", &plinewid)
        && plinewid == dwg->header_vars.PLINEWID)
      {
        pass ("HEADER.PLINEWID [BD] set+1 %g", plinewid);
      }
    else
      {
        fail ("HEADER.PLINEWID [BD] set+1 %g != %g",
              dwg->header_vars.PLINEWID, plinewid);
        error++;
      }
    plinewid--;
    dwg_dynapi_header_set_value (dwg, "PLINEWID", &plinewid);

  }
  {
    BITCODE_BD userr1;
    if (dwg_dynapi_header_value (dwg, "USERR1", &userr1, NULL)
        && userr1 == dwg->header_vars.USERR1)
      {
        pass ("HEADER.USERR1 [BD] %g", userr1);
      }
    else
      {
        fail ("HEADER.USERR1 [BD] %g != %g", dwg->header_vars.USERR1, userr1);
        error++;
      }
    userr1++;
    if (dwg_dynapi_header_set_value (dwg, "USERR1", &userr1)
        && userr1 == dwg->header_vars.USERR1)
      {
        pass ("HEADER.USERR1 [BD] set+1 %g", userr1);
      }
    else
      {
        fail ("HEADER.USERR1 [BD] set+1 %g != %g",
              dwg->header_vars.USERR1, userr1);
        error++;
      }
    userr1--;
    dwg_dynapi_header_set_value (dwg, "USERR1", &userr1);

  }
  {
    BITCODE_BD userr2;
    if (dwg_dynapi_header_value (dwg, "USERR2", &userr2, NULL)
        && userr2 == dwg->header_vars.USERR2)
      {
        pass ("HEADER.USERR2 [BD] %g", userr2);
      }
    else
      {
        fail ("HEADER.USERR2 [BD] %g != %g", dwg->header_vars.USERR2, userr2);
        error++;
      }
    userr2++;
    if (dwg_dynapi_header_set_value (dwg, "USERR2", &userr2)
        && userr2 == dwg->header_vars.USERR2)
      {
        pass ("HEADER.USERR2 [BD] set+1 %g", userr2);
      }
    else
      {
        fail ("HEADER.USERR2 [BD] set+1 %g != %g",
              dwg->header_vars.USERR2, userr2);
        error++;
      }
    userr2--;
    dwg_dynapi_header_set_value (dwg, "USERR2", &userr2);

  }
  {
    BITCODE_BD userr3;
    if (dwg_dynapi_header_value (dwg, "USERR3", &userr3, NULL)
        && userr3 == dwg->header_vars.USERR3)
      {
        pass ("HEADER.USERR3 [BD] %g", userr3);
      }
    else
      {
        fail ("HEADER.USERR3 [BD] %g != %g", dwg->header_vars.USERR3, userr3);
        error++;
      }
    userr3++;
    if (dwg_dynapi_header_set_value (dwg, "USERR3", &userr3)
        && userr3 == dwg->header_vars.USERR3)
      {
        pass ("HEADER.USERR3 [BD] set+1 %g", userr3);
      }
    else
      {
        fail ("HEADER.USERR3 [BD] set+1 %g != %g",
              dwg->header_vars.USERR3, userr3);
        error++;
      }
    userr3--;
    dwg_dynapi_header_set_value (dwg, "USERR3", &userr3);

  }
  {
    BITCODE_BD userr4;
    if (dwg_dynapi_header_value (dwg, "USERR4", &userr4, NULL)
        && userr4 == dwg->header_vars.USERR4)
      {
        pass ("HEADER.USERR4 [BD] %g", userr4);
      }
    else
      {
        fail ("HEADER.USERR4 [BD] %g != %g", dwg->header_vars.USERR4, userr4);
        error++;
      }
    userr4++;
    if (dwg_dynapi_header_set_value (dwg, "USERR4", &userr4)
        && userr4 == dwg->header_vars.USERR4)
      {
        pass ("HEADER.USERR4 [BD] set+1 %g", userr4);
      }
    else
      {
        fail ("HEADER.USERR4 [BD] set+1 %g != %g",
              dwg->header_vars.USERR4, userr4);
        error++;
      }
    userr4--;
    dwg_dynapi_header_set_value (dwg, "USERR4", &userr4);

  }
  {
    BITCODE_BD userr5;
    if (dwg_dynapi_header_value (dwg, "USERR5", &userr5, NULL)
        && userr5 == dwg->header_vars.USERR5)
      {
        pass ("HEADER.USERR5 [BD] %g", userr5);
      }
    else
      {
        fail ("HEADER.USERR5 [BD] %g != %g", dwg->header_vars.USERR5, userr5);
        error++;
      }
    userr5++;
    if (dwg_dynapi_header_set_value (dwg, "USERR5", &userr5)
        && userr5 == dwg->header_vars.USERR5)
      {
        pass ("HEADER.USERR5 [BD] set+1 %g", userr5);
      }
    else
      {
        fail ("HEADER.USERR5 [BD] set+1 %g != %g",
              dwg->header_vars.USERR5, userr5);
        error++;
      }
    userr5--;
    dwg_dynapi_header_set_value (dwg, "USERR5", &userr5);

  }
  {
    BITCODE_BD chamfera;
    if (dwg_dynapi_header_value (dwg, "CHAMFERA", &chamfera, NULL)
        && chamfera == dwg->header_vars.CHAMFERA)
      {
        pass ("HEADER.CHAMFERA [BD] %g", chamfera);
      }
    else
      {
        fail ("HEADER.CHAMFERA [BD] %g != %g", dwg->header_vars.CHAMFERA, chamfera);
        error++;
      }
    chamfera++;
    if (dwg_dynapi_header_set_value (dwg, "CHAMFERA", &chamfera)
        && chamfera == dwg->header_vars.CHAMFERA)
      {
        pass ("HEADER.CHAMFERA [BD] set+1 %g", chamfera);
      }
    else
      {
        fail ("HEADER.CHAMFERA [BD] set+1 %g != %g",
              dwg->header_vars.CHAMFERA, chamfera);
        error++;
      }
    chamfera--;
    dwg_dynapi_header_set_value (dwg, "CHAMFERA", &chamfera);

  }
  {
    BITCODE_BD chamferb;
    if (dwg_dynapi_header_value (dwg, "CHAMFERB", &chamferb, NULL)
        && chamferb == dwg->header_vars.CHAMFERB)
      {
        pass ("HEADER.CHAMFERB [BD] %g", chamferb);
      }
    else
      {
        fail ("HEADER.CHAMFERB [BD] %g != %g", dwg->header_vars.CHAMFERB, chamferb);
        error++;
      }
    chamferb++;
    if (dwg_dynapi_header_set_value (dwg, "CHAMFERB", &chamferb)
        && chamferb == dwg->header_vars.CHAMFERB)
      {
        pass ("HEADER.CHAMFERB [BD] set+1 %g", chamferb);
      }
    else
      {
        fail ("HEADER.CHAMFERB [BD] set+1 %g != %g",
              dwg->header_vars.CHAMFERB, chamferb);
        error++;
      }
    chamferb--;
    dwg_dynapi_header_set_value (dwg, "CHAMFERB", &chamferb);

  }
  {
    BITCODE_BD chamferc;
    if (dwg_dynapi_header_value (dwg, "CHAMFERC", &chamferc, NULL)
        && chamferc == dwg->header_vars.CHAMFERC)
      {
        pass ("HEADER.CHAMFERC [BD] %g", chamferc);
      }
    else
      {
        fail ("HEADER.CHAMFERC [BD] %g != %g", dwg->header_vars.CHAMFERC, chamferc);
        error++;
      }
    chamferc++;
    if (dwg_dynapi_header_set_value (dwg, "CHAMFERC", &chamferc)
        && chamferc == dwg->header_vars.CHAMFERC)
      {
        pass ("HEADER.CHAMFERC [BD] set+1 %g", chamferc);
      }
    else
      {
        fail ("HEADER.CHAMFERC [BD] set+1 %g != %g",
              dwg->header_vars.CHAMFERC, chamferc);
        error++;
      }
    chamferc--;
    dwg_dynapi_header_set_value (dwg, "CHAMFERC", &chamferc);

  }
  {
    BITCODE_BD chamferd;
    if (dwg_dynapi_header_value (dwg, "CHAMFERD", &chamferd, NULL)
        && chamferd == dwg->header_vars.CHAMFERD)
      {
        pass ("HEADER.CHAMFERD [BD] %g", chamferd);
      }
    else
      {
        fail ("HEADER.CHAMFERD [BD] %g != %g", dwg->header_vars.CHAMFERD, chamferd);
        error++;
      }
    chamferd++;
    if (dwg_dynapi_header_set_value (dwg, "CHAMFERD", &chamferd)
        && chamferd == dwg->header_vars.CHAMFERD)
      {
        pass ("HEADER.CHAMFERD [BD] set+1 %g", chamferd);
      }
    else
      {
        fail ("HEADER.CHAMFERD [BD] set+1 %g != %g",
              dwg->header_vars.CHAMFERD, chamferd);
        error++;
      }
    chamferd--;
    dwg_dynapi_header_set_value (dwg, "CHAMFERD", &chamferd);

  }
  {
    BITCODE_BD facetres;
    if (dwg_dynapi_header_value (dwg, "FACETRES", &facetres, NULL)
        && facetres == dwg->header_vars.FACETRES)
      {
        pass ("HEADER.FACETRES [BD] %g", facetres);
      }
    else
      {
        fail ("HEADER.FACETRES [BD] %g != %g", dwg->header_vars.FACETRES, facetres);
        error++;
      }
    facetres++;
    if (dwg_dynapi_header_set_value (dwg, "FACETRES", &facetres)
        && facetres == dwg->header_vars.FACETRES)
      {
        pass ("HEADER.FACETRES [BD] set+1 %g", facetres);
      }
    else
      {
        fail ("HEADER.FACETRES [BD] set+1 %g != %g",
              dwg->header_vars.FACETRES, facetres);
        error++;
      }
    facetres--;
    dwg_dynapi_header_set_value (dwg, "FACETRES", &facetres);

  }
  {
    BITCODE_BD cmlscale;
    if (dwg_dynapi_header_value (dwg, "CMLSCALE", &cmlscale, NULL)
        && cmlscale == dwg->header_vars.CMLSCALE)
      {
        pass ("HEADER.CMLSCALE [BD] %g", cmlscale);
      }
    else
      {
        fail ("HEADER.CMLSCALE [BD] %g != %g", dwg->header_vars.CMLSCALE, cmlscale);
        error++;
      }
    cmlscale++;
    if (dwg_dynapi_header_set_value (dwg, "CMLSCALE", &cmlscale)
        && cmlscale == dwg->header_vars.CMLSCALE)
      {
        pass ("HEADER.CMLSCALE [BD] set+1 %g", cmlscale);
      }
    else
      {
        fail ("HEADER.CMLSCALE [BD] set+1 %g != %g",
              dwg->header_vars.CMLSCALE, cmlscale);
        error++;
      }
    cmlscale--;
    dwg_dynapi_header_set_value (dwg, "CMLSCALE", &cmlscale);

  }
  {
    BITCODE_BD celtscale;
    if (dwg_dynapi_header_value (dwg, "CELTSCALE", &celtscale, NULL)
        && celtscale == dwg->header_vars.CELTSCALE)
      {
        pass ("HEADER.CELTSCALE [BD] %g", celtscale);
      }
    else
      {
        fail ("HEADER.CELTSCALE [BD] %g != %g", dwg->header_vars.CELTSCALE, celtscale);
        error++;
      }
    celtscale++;
    if (dwg_dynapi_header_set_value (dwg, "CELTSCALE", &celtscale)
        && celtscale == dwg->header_vars.CELTSCALE)
      {
        pass ("HEADER.CELTSCALE [BD] set+1 %g", celtscale);
      }
    else
      {
        fail ("HEADER.CELTSCALE [BD] set+1 %g != %g",
              dwg->header_vars.CELTSCALE, celtscale);
        error++;
      }
    celtscale--;
    dwg_dynapi_header_set_value (dwg, "CELTSCALE", &celtscale);

  }
  {
    BITCODE_TV menu;
    if (dwg_dynapi_header_value (dwg, "MENU", &menu, NULL)
        && !memcmp (&menu, &dwg->header_vars.MENU, sizeof (dwg->header_vars.MENU))
       )
      {
        pass ("HEADER.MENU [TV]");
      }
    else
      {
        fail ("HEADER.MENU [TV]");
        error++;
      }
  }
  {
    BITCODE_TIMEBLL tdcreate;
    if (dwg_dynapi_header_value (dwg, "TDCREATE", &tdcreate, NULL)
        && !memcmp (&tdcreate, &dwg->header_vars.TDCREATE, sizeof (dwg->header_vars.TDCREATE))
       )
      {
        pass ("HEADER.TDCREATE [TIMEBLL]");
      }
    else
      {
        fail ("HEADER.TDCREATE [TIMEBLL]");
        error++;
      }
  }
  {
    BITCODE_TIMEBLL tdupdate;
    if (dwg_dynapi_header_value (dwg, "TDUPDATE", &tdupdate, NULL)
        && !memcmp (&tdupdate, &dwg->header_vars.TDUPDATE, sizeof (dwg->header_vars.TDUPDATE))
       )
      {
        pass ("HEADER.TDUPDATE [TIMEBLL]");
      }
    else
      {
        fail ("HEADER.TDUPDATE [TIMEBLL]");
        error++;
      }
  }
  {
    BITCODE_BL unknown_15;
    if (dwg_dynapi_header_value (dwg, "unknown_15", &unknown_15, NULL)
        && unknown_15 == dwg->header_vars.unknown_15)
      {
        pass ("HEADER.unknown_15 [BL] %u", unknown_15);
      }
    else
      {
        fail ("HEADER.unknown_15 [BL] %u != %u", dwg->header_vars.unknown_15, unknown_15);
        error++;
      }
    unknown_15++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_15", &unknown_15)
        && unknown_15 == dwg->header_vars.unknown_15)
      {
        pass ("HEADER.unknown_15 [BL] set+1 %u", unknown_15);
      }
    else
      {
        fail ("HEADER.unknown_15 [BL] set+1 %u != %u",
              dwg->header_vars.unknown_15, unknown_15);
        error++;
      }
    unknown_15--;
    dwg_dynapi_header_set_value (dwg, "unknown_15", &unknown_15);

  }
  {
    BITCODE_BL unknown_16;
    if (dwg_dynapi_header_value (dwg, "unknown_16", &unknown_16, NULL)
        && unknown_16 == dwg->header_vars.unknown_16)
      {
        pass ("HEADER.unknown_16 [BL] %u", unknown_16);
      }
    else
      {
        fail ("HEADER.unknown_16 [BL] %u != %u", dwg->header_vars.unknown_16, unknown_16);
        error++;
      }
    unknown_16++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_16", &unknown_16)
        && unknown_16 == dwg->header_vars.unknown_16)
      {
        pass ("HEADER.unknown_16 [BL] set+1 %u", unknown_16);
      }
    else
      {
        fail ("HEADER.unknown_16 [BL] set+1 %u != %u",
              dwg->header_vars.unknown_16, unknown_16);
        error++;
      }
    unknown_16--;
    dwg_dynapi_header_set_value (dwg, "unknown_16", &unknown_16);

  }
  {
    BITCODE_BL unknown_17;
    if (dwg_dynapi_header_value (dwg, "unknown_17", &unknown_17, NULL)
        && unknown_17 == dwg->header_vars.unknown_17)
      {
        pass ("HEADER.unknown_17 [BL] %u", unknown_17);
      }
    else
      {
        fail ("HEADER.unknown_17 [BL] %u != %u", dwg->header_vars.unknown_17, unknown_17);
        error++;
      }
    unknown_17++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_17", &unknown_17)
        && unknown_17 == dwg->header_vars.unknown_17)
      {
        pass ("HEADER.unknown_17 [BL] set+1 %u", unknown_17);
      }
    else
      {
        fail ("HEADER.unknown_17 [BL] set+1 %u != %u",
              dwg->header_vars.unknown_17, unknown_17);
        error++;
      }
    unknown_17--;
    dwg_dynapi_header_set_value (dwg, "unknown_17", &unknown_17);

  }
  {
    BITCODE_TIMEBLL tdindwg;
    if (dwg_dynapi_header_value (dwg, "TDINDWG", &tdindwg, NULL)
        && !memcmp (&tdindwg, &dwg->header_vars.TDINDWG, sizeof (dwg->header_vars.TDINDWG))
       )
      {
        pass ("HEADER.TDINDWG [TIMEBLL]");
      }
    else
      {
        fail ("HEADER.TDINDWG [TIMEBLL]");
        error++;
      }
  }
  {
    BITCODE_TIMEBLL tdusrtimer;
    if (dwg_dynapi_header_value (dwg, "TDUSRTIMER", &tdusrtimer, NULL)
        && !memcmp (&tdusrtimer, &dwg->header_vars.TDUSRTIMER, sizeof (dwg->header_vars.TDUSRTIMER))
       )
      {
        pass ("HEADER.TDUSRTIMER [TIMEBLL]");
      }
    else
      {
        fail ("HEADER.TDUSRTIMER [TIMEBLL]");
        error++;
      }
  }
  {
    BITCODE_CMC cecolor;
    if (dwg_dynapi_header_value (dwg, "CECOLOR", &cecolor, NULL)
        && !memcmp (&cecolor, &dwg->header_vars.CECOLOR, sizeof (dwg->header_vars.CECOLOR))
       )
      {
        pass ("HEADER.CECOLOR [CMC]");
      }
    else
      {
        fail ("HEADER.CECOLOR [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS handling;
    if (dwg_dynapi_header_value (dwg, "HANDLING", &handling, NULL)
        && handling == dwg->header_vars.HANDLING)
      {
        pass ("HEADER.HANDLING [BS] %hu", handling);
      }
    else
      {
        fail ("HEADER.HANDLING [BS] %hu != %hu", dwg->header_vars.HANDLING, handling);
        error++;
      }
    handling++;
    if (dwg_dynapi_header_set_value (dwg, "HANDLING", &handling)
        && handling == dwg->header_vars.HANDLING)
      {
        pass ("HEADER.HANDLING [BS] set+1 %hu", handling);
      }
    else
      {
        fail ("HEADER.HANDLING [BS] set+1 %hu != %hu",
              dwg->header_vars.HANDLING, handling);
        error++;
      }
    handling--;
    dwg_dynapi_header_set_value (dwg, "HANDLING", &handling);

  }
  {
    BITCODE_H handseed;
    if (dwg_dynapi_header_value (dwg, "HANDSEED", &handseed, NULL)
        && !memcmp (&handseed, &dwg->header_vars.HANDSEED, sizeof (dwg->header_vars.HANDSEED))
       )
      {
        pass ("HEADER.HANDSEED [H]");
      }
    else
      {
        fail ("HEADER.HANDSEED [H]");
        error++;
      }
  }
  {
    BITCODE_H clayer;
    if (dwg_dynapi_header_value (dwg, "CLAYER", &clayer, NULL)
        && !memcmp (&clayer, &dwg->header_vars.CLAYER, sizeof (dwg->header_vars.CLAYER))
       )
      {
        pass ("HEADER.CLAYER [H]");
      }
    else
      {
        fail ("HEADER.CLAYER [H]");
        error++;
      }
  }
  {
    BITCODE_H textstyle;
    if (dwg_dynapi_header_value (dwg, "TEXTSTYLE", &textstyle, NULL)
        && !memcmp (&textstyle, &dwg->header_vars.TEXTSTYLE, sizeof (dwg->header_vars.TEXTSTYLE))
       )
      {
        pass ("HEADER.TEXTSTYLE [H]");
      }
    else
      {
        fail ("HEADER.TEXTSTYLE [H]");
        error++;
      }
  }
  {
    BITCODE_H celtype;
    if (dwg_dynapi_header_value (dwg, "CELTYPE", &celtype, NULL)
        && !memcmp (&celtype, &dwg->header_vars.CELTYPE, sizeof (dwg->header_vars.CELTYPE))
       )
      {
        pass ("HEADER.CELTYPE [H]");
      }
    else
      {
        fail ("HEADER.CELTYPE [H]");
        error++;
      }
  }
  {
    BITCODE_H cmaterial;
    if (dwg_dynapi_header_value (dwg, "CMATERIAL", &cmaterial, NULL)
        && !memcmp (&cmaterial, &dwg->header_vars.CMATERIAL, sizeof (dwg->header_vars.CMATERIAL))
       )
      {
        pass ("HEADER.CMATERIAL [H]");
      }
    else
      {
        fail ("HEADER.CMATERIAL [H]");
        error++;
      }
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_header_value (dwg, "DIMSTYLE", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dwg->header_vars.DIMSTYLE, sizeof (dwg->header_vars.DIMSTYLE))
       )
      {
        pass ("HEADER.DIMSTYLE [H]");
      }
    else
      {
        fail ("HEADER.DIMSTYLE [H]");
        error++;
      }
  }
  {
    BITCODE_H cmlstyle;
    if (dwg_dynapi_header_value (dwg, "CMLSTYLE", &cmlstyle, NULL)
        && !memcmp (&cmlstyle, &dwg->header_vars.CMLSTYLE, sizeof (dwg->header_vars.CMLSTYLE))
       )
      {
        pass ("HEADER.CMLSTYLE [H]");
      }
    else
      {
        fail ("HEADER.CMLSTYLE [H]");
        error++;
      }
  }
  {
    BITCODE_BD psvpscale;
    if (dwg_dynapi_header_value (dwg, "PSVPSCALE", &psvpscale, NULL)
        && psvpscale == dwg->header_vars.PSVPSCALE)
      {
        pass ("HEADER.PSVPSCALE [BD] %g", psvpscale);
      }
    else
      {
        fail ("HEADER.PSVPSCALE [BD] %g != %g", dwg->header_vars.PSVPSCALE, psvpscale);
        error++;
      }
    psvpscale++;
    if (dwg_dynapi_header_set_value (dwg, "PSVPSCALE", &psvpscale)
        && psvpscale == dwg->header_vars.PSVPSCALE)
      {
        pass ("HEADER.PSVPSCALE [BD] set+1 %g", psvpscale);
      }
    else
      {
        fail ("HEADER.PSVPSCALE [BD] set+1 %g != %g",
              dwg->header_vars.PSVPSCALE, psvpscale);
        error++;
      }
    psvpscale--;
    dwg_dynapi_header_set_value (dwg, "PSVPSCALE", &psvpscale);

  }
  {
    BITCODE_3BD pinsbase;
    if (dwg_dynapi_header_value (dwg, "PINSBASE", &pinsbase, NULL)
        && !memcmp (&pinsbase, &dwg->header_vars.PINSBASE, sizeof (dwg->header_vars.PINSBASE))
       )
      {
        pass ("HEADER.PINSBASE [3BD]");
      }
    else
      {
        fail ("HEADER.PINSBASE [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD pextmin;
    if (dwg_dynapi_header_value (dwg, "PEXTMIN", &pextmin, NULL)
        && !memcmp (&pextmin, &dwg->header_vars.PEXTMIN, sizeof (dwg->header_vars.PEXTMIN))
       )
      {
        pass ("HEADER.PEXTMIN [3BD]");
      }
    else
      {
        fail ("HEADER.PEXTMIN [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD pextmax;
    if (dwg_dynapi_header_value (dwg, "PEXTMAX", &pextmax, NULL)
        && !memcmp (&pextmax, &dwg->header_vars.PEXTMAX, sizeof (dwg->header_vars.PEXTMAX))
       )
      {
        pass ("HEADER.PEXTMAX [3BD]");
      }
    else
      {
        fail ("HEADER.PEXTMAX [3BD]");
        error++;
      }
  }
  {
    BITCODE_2RD plimmin;
    if (dwg_dynapi_header_value (dwg, "PLIMMIN", &plimmin, NULL)
        && !memcmp (&plimmin, &dwg->header_vars.PLIMMIN, sizeof (dwg->header_vars.PLIMMIN))
       )
      {
        pass ("HEADER.PLIMMIN [2RD]");
      }
    else
      {
        fail ("HEADER.PLIMMIN [2RD]");
        error++;
      }
  }
  {
    BITCODE_2RD plimmax;
    if (dwg_dynapi_header_value (dwg, "PLIMMAX", &plimmax, NULL)
        && !memcmp (&plimmax, &dwg->header_vars.PLIMMAX, sizeof (dwg->header_vars.PLIMMAX))
       )
      {
        pass ("HEADER.PLIMMAX [2RD]");
      }
    else
      {
        fail ("HEADER.PLIMMAX [2RD]");
        error++;
      }
  }
  {
    BITCODE_BD pelevation;
    if (dwg_dynapi_header_value (dwg, "PELEVATION", &pelevation, NULL)
        && pelevation == dwg->header_vars.PELEVATION)
      {
        pass ("HEADER.PELEVATION [BD] %g", pelevation);
      }
    else
      {
        fail ("HEADER.PELEVATION [BD] %g != %g", dwg->header_vars.PELEVATION, pelevation);
        error++;
      }
    pelevation++;
    if (dwg_dynapi_header_set_value (dwg, "PELEVATION", &pelevation)
        && pelevation == dwg->header_vars.PELEVATION)
      {
        pass ("HEADER.PELEVATION [BD] set+1 %g", pelevation);
      }
    else
      {
        fail ("HEADER.PELEVATION [BD] set+1 %g != %g",
              dwg->header_vars.PELEVATION, pelevation);
        error++;
      }
    pelevation--;
    dwg_dynapi_header_set_value (dwg, "PELEVATION", &pelevation);

  }
  {
    BITCODE_3BD pucsorg;
    if (dwg_dynapi_header_value (dwg, "PUCSORG", &pucsorg, NULL)
        && !memcmp (&pucsorg, &dwg->header_vars.PUCSORG, sizeof (dwg->header_vars.PUCSORG))
       )
      {
        pass ("HEADER.PUCSORG [3BD]");
      }
    else
      {
        fail ("HEADER.PUCSORG [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD pucsxdir;
    if (dwg_dynapi_header_value (dwg, "PUCSXDIR", &pucsxdir, NULL)
        && !memcmp (&pucsxdir, &dwg->header_vars.PUCSXDIR, sizeof (dwg->header_vars.PUCSXDIR))
       )
      {
        pass ("HEADER.PUCSXDIR [3BD]");
      }
    else
      {
        fail ("HEADER.PUCSXDIR [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD pucsydir;
    if (dwg_dynapi_header_value (dwg, "PUCSYDIR", &pucsydir, NULL)
        && !memcmp (&pucsydir, &dwg->header_vars.PUCSYDIR, sizeof (dwg->header_vars.PUCSYDIR))
       )
      {
        pass ("HEADER.PUCSYDIR [3BD]");
      }
    else
      {
        fail ("HEADER.PUCSYDIR [3BD]");
        error++;
      }
  }
  {
    BITCODE_H pucsname;
    if (dwg_dynapi_header_value (dwg, "PUCSNAME", &pucsname, NULL)
        && !memcmp (&pucsname, &dwg->header_vars.PUCSNAME, sizeof (dwg->header_vars.PUCSNAME))
       )
      {
        pass ("HEADER.PUCSNAME [H]");
      }
    else
      {
        fail ("HEADER.PUCSNAME [H]");
        error++;
      }
  }
  {
    BITCODE_H pucsbase;
    if (dwg_dynapi_header_value (dwg, "PUCSBASE", &pucsbase, NULL)
        && !memcmp (&pucsbase, &dwg->header_vars.PUCSBASE, sizeof (dwg->header_vars.PUCSBASE))
       )
      {
        pass ("HEADER.PUCSBASE [H]");
      }
    else
      {
        fail ("HEADER.PUCSBASE [H]");
        error++;
      }
  }
  {
    BITCODE_H pucsorthoref;
    if (dwg_dynapi_header_value (dwg, "PUCSORTHOREF", &pucsorthoref, NULL)
        && !memcmp (&pucsorthoref, &dwg->header_vars.PUCSORTHOREF, sizeof (dwg->header_vars.PUCSORTHOREF))
       )
      {
        pass ("HEADER.PUCSORTHOREF [H]");
      }
    else
      {
        fail ("HEADER.PUCSORTHOREF [H]");
        error++;
      }
  }
  {
    BITCODE_BS pucsorthoview;
    if (dwg_dynapi_header_value (dwg, "PUCSORTHOVIEW", &pucsorthoview, NULL)
        && pucsorthoview == dwg->header_vars.PUCSORTHOVIEW)
      {
        pass ("HEADER.PUCSORTHOVIEW [BS] %hu", pucsorthoview);
      }
    else
      {
        fail ("HEADER.PUCSORTHOVIEW [BS] %hu != %hu", dwg->header_vars.PUCSORTHOVIEW, pucsorthoview);
        error++;
      }
    pucsorthoview++;
    if (dwg_dynapi_header_set_value (dwg, "PUCSORTHOVIEW", &pucsorthoview)
        && pucsorthoview == dwg->header_vars.PUCSORTHOVIEW)
      {
        pass ("HEADER.PUCSORTHOVIEW [BS] set+1 %hu", pucsorthoview);
      }
    else
      {
        fail ("HEADER.PUCSORTHOVIEW [BS] set+1 %hu != %hu",
              dwg->header_vars.PUCSORTHOVIEW, pucsorthoview);
        error++;
      }
    pucsorthoview--;
    dwg_dynapi_header_set_value (dwg, "PUCSORTHOVIEW", &pucsorthoview);

  }
  {
    BITCODE_3BD pucsorgtop;
    if (dwg_dynapi_header_value (dwg, "PUCSORGTOP", &pucsorgtop, NULL)
        && !memcmp (&pucsorgtop, &dwg->header_vars.PUCSORGTOP, sizeof (dwg->header_vars.PUCSORGTOP))
       )
      {
        pass ("HEADER.PUCSORGTOP [3BD]");
      }
    else
      {
        fail ("HEADER.PUCSORGTOP [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD pucsorgbottom;
    if (dwg_dynapi_header_value (dwg, "PUCSORGBOTTOM", &pucsorgbottom, NULL)
        && !memcmp (&pucsorgbottom, &dwg->header_vars.PUCSORGBOTTOM, sizeof (dwg->header_vars.PUCSORGBOTTOM))
       )
      {
        pass ("HEADER.PUCSORGBOTTOM [3BD]");
      }
    else
      {
        fail ("HEADER.PUCSORGBOTTOM [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD pucsorgleft;
    if (dwg_dynapi_header_value (dwg, "PUCSORGLEFT", &pucsorgleft, NULL)
        && !memcmp (&pucsorgleft, &dwg->header_vars.PUCSORGLEFT, sizeof (dwg->header_vars.PUCSORGLEFT))
       )
      {
        pass ("HEADER.PUCSORGLEFT [3BD]");
      }
    else
      {
        fail ("HEADER.PUCSORGLEFT [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD pucsorgright;
    if (dwg_dynapi_header_value (dwg, "PUCSORGRIGHT", &pucsorgright, NULL)
        && !memcmp (&pucsorgright, &dwg->header_vars.PUCSORGRIGHT, sizeof (dwg->header_vars.PUCSORGRIGHT))
       )
      {
        pass ("HEADER.PUCSORGRIGHT [3BD]");
      }
    else
      {
        fail ("HEADER.PUCSORGRIGHT [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD pucsorgfront;
    if (dwg_dynapi_header_value (dwg, "PUCSORGFRONT", &pucsorgfront, NULL)
        && !memcmp (&pucsorgfront, &dwg->header_vars.PUCSORGFRONT, sizeof (dwg->header_vars.PUCSORGFRONT))
       )
      {
        pass ("HEADER.PUCSORGFRONT [3BD]");
      }
    else
      {
        fail ("HEADER.PUCSORGFRONT [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD pucsorgback;
    if (dwg_dynapi_header_value (dwg, "PUCSORGBACK", &pucsorgback, NULL)
        && !memcmp (&pucsorgback, &dwg->header_vars.PUCSORGBACK, sizeof (dwg->header_vars.PUCSORGBACK))
       )
      {
        pass ("HEADER.PUCSORGBACK [3BD]");
      }
    else
      {
        fail ("HEADER.PUCSORGBACK [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD insbase;
    if (dwg_dynapi_header_value (dwg, "INSBASE", &insbase, NULL)
        && !memcmp (&insbase, &dwg->header_vars.INSBASE, sizeof (dwg->header_vars.INSBASE))
       )
      {
        pass ("HEADER.INSBASE [3BD]");
      }
    else
      {
        fail ("HEADER.INSBASE [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD extmin;
    if (dwg_dynapi_header_value (dwg, "EXTMIN", &extmin, NULL)
        && !memcmp (&extmin, &dwg->header_vars.EXTMIN, sizeof (dwg->header_vars.EXTMIN))
       )
      {
        pass ("HEADER.EXTMIN [3BD]");
      }
    else
      {
        fail ("HEADER.EXTMIN [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD extmax;
    if (dwg_dynapi_header_value (dwg, "EXTMAX", &extmax, NULL)
        && !memcmp (&extmax, &dwg->header_vars.EXTMAX, sizeof (dwg->header_vars.EXTMAX))
       )
      {
        pass ("HEADER.EXTMAX [3BD]");
      }
    else
      {
        fail ("HEADER.EXTMAX [3BD]");
        error++;
      }
  }
  {
    BITCODE_2RD limmin;
    if (dwg_dynapi_header_value (dwg, "LIMMIN", &limmin, NULL)
        && !memcmp (&limmin, &dwg->header_vars.LIMMIN, sizeof (dwg->header_vars.LIMMIN))
       )
      {
        pass ("HEADER.LIMMIN [2RD]");
      }
    else
      {
        fail ("HEADER.LIMMIN [2RD]");
        error++;
      }
  }
  {
    BITCODE_2RD limmax;
    if (dwg_dynapi_header_value (dwg, "LIMMAX", &limmax, NULL)
        && !memcmp (&limmax, &dwg->header_vars.LIMMAX, sizeof (dwg->header_vars.LIMMAX))
       )
      {
        pass ("HEADER.LIMMAX [2RD]");
      }
    else
      {
        fail ("HEADER.LIMMAX [2RD]");
        error++;
      }
  }
  {
    BITCODE_2RD viewctr;
    if (dwg_dynapi_header_value (dwg, "VIEWCTR", &viewctr, NULL)
        && !memcmp (&viewctr, &dwg->header_vars.VIEWCTR, sizeof (dwg->header_vars.VIEWCTR))
       )
      {
        pass ("HEADER.VIEWCTR [2RD]");
      }
    else
      {
        fail ("HEADER.VIEWCTR [2RD]");
        error++;
      }
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_header_value (dwg, "ELEVATION", &elevation, NULL)
        && elevation == dwg->header_vars.ELEVATION)
      {
        pass ("HEADER.ELEVATION [BD] %g", elevation);
      }
    else
      {
        fail ("HEADER.ELEVATION [BD] %g != %g", dwg->header_vars.ELEVATION, elevation);
        error++;
      }
    elevation++;
    if (dwg_dynapi_header_set_value (dwg, "ELEVATION", &elevation)
        && elevation == dwg->header_vars.ELEVATION)
      {
        pass ("HEADER.ELEVATION [BD] set+1 %g", elevation);
      }
    else
      {
        fail ("HEADER.ELEVATION [BD] set+1 %g != %g",
              dwg->header_vars.ELEVATION, elevation);
        error++;
      }
    elevation--;
    dwg_dynapi_header_set_value (dwg, "ELEVATION", &elevation);

  }
  {
    BITCODE_RD viewsize;
    if (dwg_dynapi_header_value (dwg, "VIEWSIZE", &viewsize, NULL)
        && viewsize == dwg->header_vars.VIEWSIZE)
      {
        pass ("HEADER.VIEWSIZE [RD] %g", viewsize);
      }
    else
      {
        fail ("HEADER.VIEWSIZE [RD] %g != %g", dwg->header_vars.VIEWSIZE, viewsize);
        error++;
      }
    viewsize++;
    if (dwg_dynapi_header_set_value (dwg, "VIEWSIZE", &viewsize)
        && viewsize == dwg->header_vars.VIEWSIZE)
      {
        pass ("HEADER.VIEWSIZE [RD] set+1 %g", viewsize);
      }
    else
      {
        fail ("HEADER.VIEWSIZE [RD] set+1 %g != %g",
              dwg->header_vars.VIEWSIZE, viewsize);
        error++;
      }
    viewsize--;
    dwg_dynapi_header_set_value (dwg, "VIEWSIZE", &viewsize);

  }
  {
    BITCODE_RS snapmode;
    if (dwg_dynapi_header_value (dwg, "SNAPMODE", &snapmode, NULL)
        && snapmode == dwg->header_vars.SNAPMODE)
      {
        pass ("HEADER.SNAPMODE [RS] %hu", snapmode);
      }
    else
      {
        fail ("HEADER.SNAPMODE [RS] %hu != %hu", dwg->header_vars.SNAPMODE, snapmode);
        error++;
      }
    snapmode++;
    if (dwg_dynapi_header_set_value (dwg, "SNAPMODE", &snapmode)
        && snapmode == dwg->header_vars.SNAPMODE)
      {
        pass ("HEADER.SNAPMODE [RS] set+1 %hu", snapmode);
      }
    else
      {
        fail ("HEADER.SNAPMODE [RS] set+1 %hu != %hu",
              dwg->header_vars.SNAPMODE, snapmode);
        error++;
      }
    snapmode--;
    dwg_dynapi_header_set_value (dwg, "SNAPMODE", &snapmode);

  }
  {
    BITCODE_2RD snapunit;
    if (dwg_dynapi_header_value (dwg, "SNAPUNIT", &snapunit, NULL)
        && !memcmp (&snapunit, &dwg->header_vars.SNAPUNIT, sizeof (dwg->header_vars.SNAPUNIT))
       )
      {
        pass ("HEADER.SNAPUNIT [2RD]");
      }
    else
      {
        fail ("HEADER.SNAPUNIT [2RD]");
        error++;
      }
  }
  {
    BITCODE_2RD snapbase;
    if (dwg_dynapi_header_value (dwg, "SNAPBASE", &snapbase, NULL)
        && !memcmp (&snapbase, &dwg->header_vars.SNAPBASE, sizeof (dwg->header_vars.SNAPBASE))
       )
      {
        pass ("HEADER.SNAPBASE [2RD]");
      }
    else
      {
        fail ("HEADER.SNAPBASE [2RD]");
        error++;
      }
  }
  {
    BITCODE_RD snapang;
    if (dwg_dynapi_header_value (dwg, "SNAPANG", &snapang, NULL)
        && snapang == dwg->header_vars.SNAPANG)
      {
        pass ("HEADER.SNAPANG [RD] %g", snapang);
      }
    else
      {
        fail ("HEADER.SNAPANG [RD] %g != %g", dwg->header_vars.SNAPANG, snapang);
        error++;
      }
    snapang++;
    if (dwg_dynapi_header_set_value (dwg, "SNAPANG", &snapang)
        && snapang == dwg->header_vars.SNAPANG)
      {
        pass ("HEADER.SNAPANG [RD] set+1 %g", snapang);
      }
    else
      {
        fail ("HEADER.SNAPANG [RD] set+1 %g != %g",
              dwg->header_vars.SNAPANG, snapang);
        error++;
      }
    snapang--;
    dwg_dynapi_header_set_value (dwg, "SNAPANG", &snapang);

  }
  {
    BITCODE_RS snapstyl;
    if (dwg_dynapi_header_value (dwg, "SNAPSTYL", &snapstyl, NULL)
        && snapstyl == dwg->header_vars.SNAPSTYL)
      {
        pass ("HEADER.SNAPSTYL [RS] %hu", snapstyl);
      }
    else
      {
        fail ("HEADER.SNAPSTYL [RS] %hu != %hu", dwg->header_vars.SNAPSTYL, snapstyl);
        error++;
      }
    snapstyl++;
    if (dwg_dynapi_header_set_value (dwg, "SNAPSTYL", &snapstyl)
        && snapstyl == dwg->header_vars.SNAPSTYL)
      {
        pass ("HEADER.SNAPSTYL [RS] set+1 %hu", snapstyl);
      }
    else
      {
        fail ("HEADER.SNAPSTYL [RS] set+1 %hu != %hu",
              dwg->header_vars.SNAPSTYL, snapstyl);
        error++;
      }
    snapstyl--;
    dwg_dynapi_header_set_value (dwg, "SNAPSTYL", &snapstyl);

  }
  {
    BITCODE_RS snapisopair;
    if (dwg_dynapi_header_value (dwg, "SNAPISOPAIR", &snapisopair, NULL)
        && snapisopair == dwg->header_vars.SNAPISOPAIR)
      {
        pass ("HEADER.SNAPISOPAIR [RS] %hu", snapisopair);
      }
    else
      {
        fail ("HEADER.SNAPISOPAIR [RS] %hu != %hu", dwg->header_vars.SNAPISOPAIR, snapisopair);
        error++;
      }
    snapisopair++;
    if (dwg_dynapi_header_set_value (dwg, "SNAPISOPAIR", &snapisopair)
        && snapisopair == dwg->header_vars.SNAPISOPAIR)
      {
        pass ("HEADER.SNAPISOPAIR [RS] set+1 %hu", snapisopair);
      }
    else
      {
        fail ("HEADER.SNAPISOPAIR [RS] set+1 %hu != %hu",
              dwg->header_vars.SNAPISOPAIR, snapisopair);
        error++;
      }
    snapisopair--;
    dwg_dynapi_header_set_value (dwg, "SNAPISOPAIR", &snapisopair);

  }
  {
    BITCODE_RS gridmode;
    if (dwg_dynapi_header_value (dwg, "GRIDMODE", &gridmode, NULL)
        && gridmode == dwg->header_vars.GRIDMODE)
      {
        pass ("HEADER.GRIDMODE [RS] %hu", gridmode);
      }
    else
      {
        fail ("HEADER.GRIDMODE [RS] %hu != %hu", dwg->header_vars.GRIDMODE, gridmode);
        error++;
      }
    gridmode++;
    if (dwg_dynapi_header_set_value (dwg, "GRIDMODE", &gridmode)
        && gridmode == dwg->header_vars.GRIDMODE)
      {
        pass ("HEADER.GRIDMODE [RS] set+1 %hu", gridmode);
      }
    else
      {
        fail ("HEADER.GRIDMODE [RS] set+1 %hu != %hu",
              dwg->header_vars.GRIDMODE, gridmode);
        error++;
      }
    gridmode--;
    dwg_dynapi_header_set_value (dwg, "GRIDMODE", &gridmode);

  }
  {
    BITCODE_2RD gridunit;
    if (dwg_dynapi_header_value (dwg, "GRIDUNIT", &gridunit, NULL)
        && !memcmp (&gridunit, &dwg->header_vars.GRIDUNIT, sizeof (dwg->header_vars.GRIDUNIT))
       )
      {
        pass ("HEADER.GRIDUNIT [2RD]");
      }
    else
      {
        fail ("HEADER.GRIDUNIT [2RD]");
        error++;
      }
  }
  {
    BITCODE_3BD ucsorg;
    if (dwg_dynapi_header_value (dwg, "UCSORG", &ucsorg, NULL)
        && !memcmp (&ucsorg, &dwg->header_vars.UCSORG, sizeof (dwg->header_vars.UCSORG))
       )
      {
        pass ("HEADER.UCSORG [3BD]");
      }
    else
      {
        fail ("HEADER.UCSORG [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD ucsxdir;
    if (dwg_dynapi_header_value (dwg, "UCSXDIR", &ucsxdir, NULL)
        && !memcmp (&ucsxdir, &dwg->header_vars.UCSXDIR, sizeof (dwg->header_vars.UCSXDIR))
       )
      {
        pass ("HEADER.UCSXDIR [3BD]");
      }
    else
      {
        fail ("HEADER.UCSXDIR [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD ucsydir;
    if (dwg_dynapi_header_value (dwg, "UCSYDIR", &ucsydir, NULL)
        && !memcmp (&ucsydir, &dwg->header_vars.UCSYDIR, sizeof (dwg->header_vars.UCSYDIR))
       )
      {
        pass ("HEADER.UCSYDIR [3BD]");
      }
    else
      {
        fail ("HEADER.UCSYDIR [3BD]");
        error++;
      }
  }
  {
    BITCODE_H ucsname;
    if (dwg_dynapi_header_value (dwg, "UCSNAME", &ucsname, NULL)
        && !memcmp (&ucsname, &dwg->header_vars.UCSNAME, sizeof (dwg->header_vars.UCSNAME))
       )
      {
        pass ("HEADER.UCSNAME [H]");
      }
    else
      {
        fail ("HEADER.UCSNAME [H]");
        error++;
      }
  }
  {
    BITCODE_H ucsbase;
    if (dwg_dynapi_header_value (dwg, "UCSBASE", &ucsbase, NULL)
        && !memcmp (&ucsbase, &dwg->header_vars.UCSBASE, sizeof (dwg->header_vars.UCSBASE))
       )
      {
        pass ("HEADER.UCSBASE [H]");
      }
    else
      {
        fail ("HEADER.UCSBASE [H]");
        error++;
      }
  }
  {
    BITCODE_BS ucsorthoview;
    if (dwg_dynapi_header_value (dwg, "UCSORTHOVIEW", &ucsorthoview, NULL)
        && ucsorthoview == dwg->header_vars.UCSORTHOVIEW)
      {
        pass ("HEADER.UCSORTHOVIEW [BS] %hu", ucsorthoview);
      }
    else
      {
        fail ("HEADER.UCSORTHOVIEW [BS] %hu != %hu", dwg->header_vars.UCSORTHOVIEW, ucsorthoview);
        error++;
      }
    ucsorthoview++;
    if (dwg_dynapi_header_set_value (dwg, "UCSORTHOVIEW", &ucsorthoview)
        && ucsorthoview == dwg->header_vars.UCSORTHOVIEW)
      {
        pass ("HEADER.UCSORTHOVIEW [BS] set+1 %hu", ucsorthoview);
      }
    else
      {
        fail ("HEADER.UCSORTHOVIEW [BS] set+1 %hu != %hu",
              dwg->header_vars.UCSORTHOVIEW, ucsorthoview);
        error++;
      }
    ucsorthoview--;
    dwg_dynapi_header_set_value (dwg, "UCSORTHOVIEW", &ucsorthoview);

  }
  {
    BITCODE_H ucsorthoref;
    if (dwg_dynapi_header_value (dwg, "UCSORTHOREF", &ucsorthoref, NULL)
        && !memcmp (&ucsorthoref, &dwg->header_vars.UCSORTHOREF, sizeof (dwg->header_vars.UCSORTHOREF))
       )
      {
        pass ("HEADER.UCSORTHOREF [H]");
      }
    else
      {
        fail ("HEADER.UCSORTHOREF [H]");
        error++;
      }
  }
  {
    BITCODE_3BD ucsorgtop;
    if (dwg_dynapi_header_value (dwg, "UCSORGTOP", &ucsorgtop, NULL)
        && !memcmp (&ucsorgtop, &dwg->header_vars.UCSORGTOP, sizeof (dwg->header_vars.UCSORGTOP))
       )
      {
        pass ("HEADER.UCSORGTOP [3BD]");
      }
    else
      {
        fail ("HEADER.UCSORGTOP [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD ucsorgbottom;
    if (dwg_dynapi_header_value (dwg, "UCSORGBOTTOM", &ucsorgbottom, NULL)
        && !memcmp (&ucsorgbottom, &dwg->header_vars.UCSORGBOTTOM, sizeof (dwg->header_vars.UCSORGBOTTOM))
       )
      {
        pass ("HEADER.UCSORGBOTTOM [3BD]");
      }
    else
      {
        fail ("HEADER.UCSORGBOTTOM [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD ucsorgleft;
    if (dwg_dynapi_header_value (dwg, "UCSORGLEFT", &ucsorgleft, NULL)
        && !memcmp (&ucsorgleft, &dwg->header_vars.UCSORGLEFT, sizeof (dwg->header_vars.UCSORGLEFT))
       )
      {
        pass ("HEADER.UCSORGLEFT [3BD]");
      }
    else
      {
        fail ("HEADER.UCSORGLEFT [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD ucsorgright;
    if (dwg_dynapi_header_value (dwg, "UCSORGRIGHT", &ucsorgright, NULL)
        && !memcmp (&ucsorgright, &dwg->header_vars.UCSORGRIGHT, sizeof (dwg->header_vars.UCSORGRIGHT))
       )
      {
        pass ("HEADER.UCSORGRIGHT [3BD]");
      }
    else
      {
        fail ("HEADER.UCSORGRIGHT [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD ucsorgfront;
    if (dwg_dynapi_header_value (dwg, "UCSORGFRONT", &ucsorgfront, NULL)
        && !memcmp (&ucsorgfront, &dwg->header_vars.UCSORGFRONT, sizeof (dwg->header_vars.UCSORGFRONT))
       )
      {
        pass ("HEADER.UCSORGFRONT [3BD]");
      }
    else
      {
        fail ("HEADER.UCSORGFRONT [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD ucsorgback;
    if (dwg_dynapi_header_value (dwg, "UCSORGBACK", &ucsorgback, NULL)
        && !memcmp (&ucsorgback, &dwg->header_vars.UCSORGBACK, sizeof (dwg->header_vars.UCSORGBACK))
       )
      {
        pass ("HEADER.UCSORGBACK [3BD]");
      }
    else
      {
        fail ("HEADER.UCSORGBACK [3BD]");
        error++;
      }
  }
  {
    BITCODE_TV dimpost;
    if (dwg_dynapi_header_value (dwg, "DIMPOST", &dimpost, NULL)
        && !memcmp (&dimpost, &dwg->header_vars.DIMPOST, sizeof (dwg->header_vars.DIMPOST))
       )
      {
        pass ("HEADER.DIMPOST [TV]");
      }
    else
      {
        fail ("HEADER.DIMPOST [TV]");
        error++;
      }
  }
  {
    BITCODE_TV dimapost;
    if (dwg_dynapi_header_value (dwg, "DIMAPOST", &dimapost, NULL)
        && !memcmp (&dimapost, &dwg->header_vars.DIMAPOST, sizeof (dwg->header_vars.DIMAPOST))
       )
      {
        pass ("HEADER.DIMAPOST [TV]");
      }
    else
      {
        fail ("HEADER.DIMAPOST [TV]");
        error++;
      }
  }
  {
    BITCODE_B dimtol;
    if (dwg_dynapi_header_value (dwg, "DIMTOL", &dimtol, NULL)
        && dimtol == dwg->header_vars.DIMTOL)
      {
        pass ("HEADER.DIMTOL [B] " FORMAT_B "", dimtol);
      }
    else
      {
        fail ("HEADER.DIMTOL [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMTOL, dimtol);
        error++;
      }
    dimtol++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTOL", &dimtol)
        && dimtol == dwg->header_vars.DIMTOL)
      {
        pass ("HEADER.DIMTOL [B] set+1 " FORMAT_B "", dimtol);
      }
    else
      {
        fail ("HEADER.DIMTOL [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMTOL, dimtol);
        error++;
      }
    dimtol--;
    dwg_dynapi_header_set_value (dwg, "DIMTOL", &dimtol);

  }
  {
    BITCODE_B dimlim;
    if (dwg_dynapi_header_value (dwg, "DIMLIM", &dimlim, NULL)
        && dimlim == dwg->header_vars.DIMLIM)
      {
        pass ("HEADER.DIMLIM [B] " FORMAT_B "", dimlim);
      }
    else
      {
        fail ("HEADER.DIMLIM [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMLIM, dimlim);
        error++;
      }
    dimlim++;
    if (dwg_dynapi_header_set_value (dwg, "DIMLIM", &dimlim)
        && dimlim == dwg->header_vars.DIMLIM)
      {
        pass ("HEADER.DIMLIM [B] set+1 " FORMAT_B "", dimlim);
      }
    else
      {
        fail ("HEADER.DIMLIM [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMLIM, dimlim);
        error++;
      }
    dimlim--;
    dwg_dynapi_header_set_value (dwg, "DIMLIM", &dimlim);

  }
  {
    BITCODE_B dimtih;
    if (dwg_dynapi_header_value (dwg, "DIMTIH", &dimtih, NULL)
        && dimtih == dwg->header_vars.DIMTIH)
      {
        pass ("HEADER.DIMTIH [B] " FORMAT_B "", dimtih);
      }
    else
      {
        fail ("HEADER.DIMTIH [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMTIH, dimtih);
        error++;
      }
    dimtih++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTIH", &dimtih)
        && dimtih == dwg->header_vars.DIMTIH)
      {
        pass ("HEADER.DIMTIH [B] set+1 " FORMAT_B "", dimtih);
      }
    else
      {
        fail ("HEADER.DIMTIH [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMTIH, dimtih);
        error++;
      }
    dimtih--;
    dwg_dynapi_header_set_value (dwg, "DIMTIH", &dimtih);

  }
  {
    BITCODE_B dimtoh;
    if (dwg_dynapi_header_value (dwg, "DIMTOH", &dimtoh, NULL)
        && dimtoh == dwg->header_vars.DIMTOH)
      {
        pass ("HEADER.DIMTOH [B] " FORMAT_B "", dimtoh);
      }
    else
      {
        fail ("HEADER.DIMTOH [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMTOH, dimtoh);
        error++;
      }
    dimtoh++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTOH", &dimtoh)
        && dimtoh == dwg->header_vars.DIMTOH)
      {
        pass ("HEADER.DIMTOH [B] set+1 " FORMAT_B "", dimtoh);
      }
    else
      {
        fail ("HEADER.DIMTOH [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMTOH, dimtoh);
        error++;
      }
    dimtoh--;
    dwg_dynapi_header_set_value (dwg, "DIMTOH", &dimtoh);

  }
  {
    BITCODE_B dimse1;
    if (dwg_dynapi_header_value (dwg, "DIMSE1", &dimse1, NULL)
        && dimse1 == dwg->header_vars.DIMSE1)
      {
        pass ("HEADER.DIMSE1 [B] " FORMAT_B "", dimse1);
      }
    else
      {
        fail ("HEADER.DIMSE1 [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSE1, dimse1);
        error++;
      }
    dimse1++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSE1", &dimse1)
        && dimse1 == dwg->header_vars.DIMSE1)
      {
        pass ("HEADER.DIMSE1 [B] set+1 " FORMAT_B "", dimse1);
      }
    else
      {
        fail ("HEADER.DIMSE1 [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMSE1, dimse1);
        error++;
      }
    dimse1--;
    dwg_dynapi_header_set_value (dwg, "DIMSE1", &dimse1);

  }
  {
    BITCODE_B dimse2;
    if (dwg_dynapi_header_value (dwg, "DIMSE2", &dimse2, NULL)
        && dimse2 == dwg->header_vars.DIMSE2)
      {
        pass ("HEADER.DIMSE2 [B] " FORMAT_B "", dimse2);
      }
    else
      {
        fail ("HEADER.DIMSE2 [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSE2, dimse2);
        error++;
      }
    dimse2++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSE2", &dimse2)
        && dimse2 == dwg->header_vars.DIMSE2)
      {
        pass ("HEADER.DIMSE2 [B] set+1 " FORMAT_B "", dimse2);
      }
    else
      {
        fail ("HEADER.DIMSE2 [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMSE2, dimse2);
        error++;
      }
    dimse2--;
    dwg_dynapi_header_set_value (dwg, "DIMSE2", &dimse2);

  }
  {
    BITCODE_B dimalt;
    if (dwg_dynapi_header_value (dwg, "DIMALT", &dimalt, NULL)
        && dimalt == dwg->header_vars.DIMALT)
      {
        pass ("HEADER.DIMALT [B] " FORMAT_B "", dimalt);
      }
    else
      {
        fail ("HEADER.DIMALT [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMALT, dimalt);
        error++;
      }
    dimalt++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALT", &dimalt)
        && dimalt == dwg->header_vars.DIMALT)
      {
        pass ("HEADER.DIMALT [B] set+1 " FORMAT_B "", dimalt);
      }
    else
      {
        fail ("HEADER.DIMALT [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMALT, dimalt);
        error++;
      }
    dimalt--;
    dwg_dynapi_header_set_value (dwg, "DIMALT", &dimalt);

  }
  {
    BITCODE_B dimtofl;
    if (dwg_dynapi_header_value (dwg, "DIMTOFL", &dimtofl, NULL)
        && dimtofl == dwg->header_vars.DIMTOFL)
      {
        pass ("HEADER.DIMTOFL [B] " FORMAT_B "", dimtofl);
      }
    else
      {
        fail ("HEADER.DIMTOFL [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMTOFL, dimtofl);
        error++;
      }
    dimtofl++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTOFL", &dimtofl)
        && dimtofl == dwg->header_vars.DIMTOFL)
      {
        pass ("HEADER.DIMTOFL [B] set+1 " FORMAT_B "", dimtofl);
      }
    else
      {
        fail ("HEADER.DIMTOFL [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMTOFL, dimtofl);
        error++;
      }
    dimtofl--;
    dwg_dynapi_header_set_value (dwg, "DIMTOFL", &dimtofl);

  }
  {
    BITCODE_B dimsah;
    if (dwg_dynapi_header_value (dwg, "DIMSAH", &dimsah, NULL)
        && dimsah == dwg->header_vars.DIMSAH)
      {
        pass ("HEADER.DIMSAH [B] " FORMAT_B "", dimsah);
      }
    else
      {
        fail ("HEADER.DIMSAH [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSAH, dimsah);
        error++;
      }
    dimsah++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSAH", &dimsah)
        && dimsah == dwg->header_vars.DIMSAH)
      {
        pass ("HEADER.DIMSAH [B] set+1 " FORMAT_B "", dimsah);
      }
    else
      {
        fail ("HEADER.DIMSAH [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMSAH, dimsah);
        error++;
      }
    dimsah--;
    dwg_dynapi_header_set_value (dwg, "DIMSAH", &dimsah);

  }
  {
    BITCODE_B dimtix;
    if (dwg_dynapi_header_value (dwg, "DIMTIX", &dimtix, NULL)
        && dimtix == dwg->header_vars.DIMTIX)
      {
        pass ("HEADER.DIMTIX [B] " FORMAT_B "", dimtix);
      }
    else
      {
        fail ("HEADER.DIMTIX [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMTIX, dimtix);
        error++;
      }
    dimtix++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTIX", &dimtix)
        && dimtix == dwg->header_vars.DIMTIX)
      {
        pass ("HEADER.DIMTIX [B] set+1 " FORMAT_B "", dimtix);
      }
    else
      {
        fail ("HEADER.DIMTIX [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMTIX, dimtix);
        error++;
      }
    dimtix--;
    dwg_dynapi_header_set_value (dwg, "DIMTIX", &dimtix);

  }
  {
    BITCODE_B dimsoxd;
    if (dwg_dynapi_header_value (dwg, "DIMSOXD", &dimsoxd, NULL)
        && dimsoxd == dwg->header_vars.DIMSOXD)
      {
        pass ("HEADER.DIMSOXD [B] " FORMAT_B "", dimsoxd);
      }
    else
      {
        fail ("HEADER.DIMSOXD [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSOXD, dimsoxd);
        error++;
      }
    dimsoxd++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSOXD", &dimsoxd)
        && dimsoxd == dwg->header_vars.DIMSOXD)
      {
        pass ("HEADER.DIMSOXD [B] set+1 " FORMAT_B "", dimsoxd);
      }
    else
      {
        fail ("HEADER.DIMSOXD [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMSOXD, dimsoxd);
        error++;
      }
    dimsoxd--;
    dwg_dynapi_header_set_value (dwg, "DIMSOXD", &dimsoxd);

  }
  {
    BITCODE_BS dimaltd;
    if (dwg_dynapi_header_value (dwg, "DIMALTD", &dimaltd, NULL)
        && dimaltd == dwg->header_vars.DIMALTD)
      {
        pass ("HEADER.DIMALTD [BS] %hu", dimaltd);
      }
    else
      {
        fail ("HEADER.DIMALTD [BS] %hu != %hu", dwg->header_vars.DIMALTD, dimaltd);
        error++;
      }
    dimaltd++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTD", &dimaltd)
        && dimaltd == dwg->header_vars.DIMALTD)
      {
        pass ("HEADER.DIMALTD [BS] set+1 %hu", dimaltd);
      }
    else
      {
        fail ("HEADER.DIMALTD [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMALTD, dimaltd);
        error++;
      }
    dimaltd--;
    dwg_dynapi_header_set_value (dwg, "DIMALTD", &dimaltd);

  }
  {
    BITCODE_BS dimzin;
    if (dwg_dynapi_header_value (dwg, "DIMZIN", &dimzin, NULL)
        && dimzin == dwg->header_vars.DIMZIN)
      {
        pass ("HEADER.DIMZIN [BS] %hu", dimzin);
      }
    else
      {
        fail ("HEADER.DIMZIN [BS] %hu != %hu", dwg->header_vars.DIMZIN, dimzin);
        error++;
      }
    dimzin++;
    if (dwg_dynapi_header_set_value (dwg, "DIMZIN", &dimzin)
        && dimzin == dwg->header_vars.DIMZIN)
      {
        pass ("HEADER.DIMZIN [BS] set+1 %hu", dimzin);
      }
    else
      {
        fail ("HEADER.DIMZIN [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMZIN, dimzin);
        error++;
      }
    dimzin--;
    dwg_dynapi_header_set_value (dwg, "DIMZIN", &dimzin);

  }
  {
    BITCODE_B dimsd1;
    if (dwg_dynapi_header_value (dwg, "DIMSD1", &dimsd1, NULL)
        && dimsd1 == dwg->header_vars.DIMSD1)
      {
        pass ("HEADER.DIMSD1 [B] " FORMAT_B "", dimsd1);
      }
    else
      {
        fail ("HEADER.DIMSD1 [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSD1, dimsd1);
        error++;
      }
    dimsd1++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSD1", &dimsd1)
        && dimsd1 == dwg->header_vars.DIMSD1)
      {
        pass ("HEADER.DIMSD1 [B] set+1 " FORMAT_B "", dimsd1);
      }
    else
      {
        fail ("HEADER.DIMSD1 [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMSD1, dimsd1);
        error++;
      }
    dimsd1--;
    dwg_dynapi_header_set_value (dwg, "DIMSD1", &dimsd1);

  }
  {
    BITCODE_B dimsd2;
    if (dwg_dynapi_header_value (dwg, "DIMSD2", &dimsd2, NULL)
        && dimsd2 == dwg->header_vars.DIMSD2)
      {
        pass ("HEADER.DIMSD2 [B] " FORMAT_B "", dimsd2);
      }
    else
      {
        fail ("HEADER.DIMSD2 [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSD2, dimsd2);
        error++;
      }
    dimsd2++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSD2", &dimsd2)
        && dimsd2 == dwg->header_vars.DIMSD2)
      {
        pass ("HEADER.DIMSD2 [B] set+1 " FORMAT_B "", dimsd2);
      }
    else
      {
        fail ("HEADER.DIMSD2 [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMSD2, dimsd2);
        error++;
      }
    dimsd2--;
    dwg_dynapi_header_set_value (dwg, "DIMSD2", &dimsd2);

  }
  {
    BITCODE_BS dimtolj;
    if (dwg_dynapi_header_value (dwg, "DIMTOLJ", &dimtolj, NULL)
        && dimtolj == dwg->header_vars.DIMTOLJ)
      {
        pass ("HEADER.DIMTOLJ [BS] %hu", dimtolj);
      }
    else
      {
        fail ("HEADER.DIMTOLJ [BS] %hu != %hu", dwg->header_vars.DIMTOLJ, dimtolj);
        error++;
      }
    dimtolj++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTOLJ", &dimtolj)
        && dimtolj == dwg->header_vars.DIMTOLJ)
      {
        pass ("HEADER.DIMTOLJ [BS] set+1 %hu", dimtolj);
      }
    else
      {
        fail ("HEADER.DIMTOLJ [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMTOLJ, dimtolj);
        error++;
      }
    dimtolj--;
    dwg_dynapi_header_set_value (dwg, "DIMTOLJ", &dimtolj);

  }
  {
    BITCODE_BS dimjust;
    if (dwg_dynapi_header_value (dwg, "DIMJUST", &dimjust, NULL)
        && dimjust == dwg->header_vars.DIMJUST)
      {
        pass ("HEADER.DIMJUST [BS] %hu", dimjust);
      }
    else
      {
        fail ("HEADER.DIMJUST [BS] %hu != %hu", dwg->header_vars.DIMJUST, dimjust);
        error++;
      }
    dimjust++;
    if (dwg_dynapi_header_set_value (dwg, "DIMJUST", &dimjust)
        && dimjust == dwg->header_vars.DIMJUST)
      {
        pass ("HEADER.DIMJUST [BS] set+1 %hu", dimjust);
      }
    else
      {
        fail ("HEADER.DIMJUST [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMJUST, dimjust);
        error++;
      }
    dimjust--;
    dwg_dynapi_header_set_value (dwg, "DIMJUST", &dimjust);

  }
  {
    BITCODE_BS dimfit;
    if (dwg_dynapi_header_value (dwg, "DIMFIT", &dimfit, NULL)
        && dimfit == dwg->header_vars.DIMFIT)
      {
        pass ("HEADER.DIMFIT [BS] %hu", dimfit);
      }
    else
      {
        fail ("HEADER.DIMFIT [BS] %hu != %hu", dwg->header_vars.DIMFIT, dimfit);
        error++;
      }
    dimfit++;
    if (dwg_dynapi_header_set_value (dwg, "DIMFIT", &dimfit)
        && dimfit == dwg->header_vars.DIMFIT)
      {
        pass ("HEADER.DIMFIT [BS] set+1 %hu", dimfit);
      }
    else
      {
        fail ("HEADER.DIMFIT [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMFIT, dimfit);
        error++;
      }
    dimfit--;
    dwg_dynapi_header_set_value (dwg, "DIMFIT", &dimfit);

  }
  {
    BITCODE_B dimupt;
    if (dwg_dynapi_header_value (dwg, "DIMUPT", &dimupt, NULL)
        && dimupt == dwg->header_vars.DIMUPT)
      {
        pass ("HEADER.DIMUPT [B] " FORMAT_B "", dimupt);
      }
    else
      {
        fail ("HEADER.DIMUPT [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMUPT, dimupt);
        error++;
      }
    dimupt++;
    if (dwg_dynapi_header_set_value (dwg, "DIMUPT", &dimupt)
        && dimupt == dwg->header_vars.DIMUPT)
      {
        pass ("HEADER.DIMUPT [B] set+1 " FORMAT_B "", dimupt);
      }
    else
      {
        fail ("HEADER.DIMUPT [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMUPT, dimupt);
        error++;
      }
    dimupt--;
    dwg_dynapi_header_set_value (dwg, "DIMUPT", &dimupt);

  }
  {
    BITCODE_BS dimtzin;
    if (dwg_dynapi_header_value (dwg, "DIMTZIN", &dimtzin, NULL)
        && dimtzin == dwg->header_vars.DIMTZIN)
      {
        pass ("HEADER.DIMTZIN [BS] %hu", dimtzin);
      }
    else
      {
        fail ("HEADER.DIMTZIN [BS] %hu != %hu", dwg->header_vars.DIMTZIN, dimtzin);
        error++;
      }
    dimtzin++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTZIN", &dimtzin)
        && dimtzin == dwg->header_vars.DIMTZIN)
      {
        pass ("HEADER.DIMTZIN [BS] set+1 %hu", dimtzin);
      }
    else
      {
        fail ("HEADER.DIMTZIN [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMTZIN, dimtzin);
        error++;
      }
    dimtzin--;
    dwg_dynapi_header_set_value (dwg, "DIMTZIN", &dimtzin);

  }
  {
    BITCODE_BS dimmaltz;
    if (dwg_dynapi_header_value (dwg, "DIMMALTZ", &dimmaltz, NULL)
        && dimmaltz == dwg->header_vars.DIMMALTZ)
      {
        pass ("HEADER.DIMMALTZ [BS] %hu", dimmaltz);
      }
    else
      {
        fail ("HEADER.DIMMALTZ [BS] %hu != %hu", dwg->header_vars.DIMMALTZ, dimmaltz);
        error++;
      }
    dimmaltz++;
    if (dwg_dynapi_header_set_value (dwg, "DIMMALTZ", &dimmaltz)
        && dimmaltz == dwg->header_vars.DIMMALTZ)
      {
        pass ("HEADER.DIMMALTZ [BS] set+1 %hu", dimmaltz);
      }
    else
      {
        fail ("HEADER.DIMMALTZ [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMMALTZ, dimmaltz);
        error++;
      }
    dimmaltz--;
    dwg_dynapi_header_set_value (dwg, "DIMMALTZ", &dimmaltz);

  }
  {
    BITCODE_BS dimmalttz;
    if (dwg_dynapi_header_value (dwg, "DIMMALTTZ", &dimmalttz, NULL)
        && dimmalttz == dwg->header_vars.DIMMALTTZ)
      {
        pass ("HEADER.DIMMALTTZ [BS] %hu", dimmalttz);
      }
    else
      {
        fail ("HEADER.DIMMALTTZ [BS] %hu != %hu", dwg->header_vars.DIMMALTTZ, dimmalttz);
        error++;
      }
    dimmalttz++;
    if (dwg_dynapi_header_set_value (dwg, "DIMMALTTZ", &dimmalttz)
        && dimmalttz == dwg->header_vars.DIMMALTTZ)
      {
        pass ("HEADER.DIMMALTTZ [BS] set+1 %hu", dimmalttz);
      }
    else
      {
        fail ("HEADER.DIMMALTTZ [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMMALTTZ, dimmalttz);
        error++;
      }
    dimmalttz--;
    dwg_dynapi_header_set_value (dwg, "DIMMALTTZ", &dimmalttz);

  }
  {
    BITCODE_BS dimtad;
    if (dwg_dynapi_header_value (dwg, "DIMTAD", &dimtad, NULL)
        && dimtad == dwg->header_vars.DIMTAD)
      {
        pass ("HEADER.DIMTAD [BS] %hu", dimtad);
      }
    else
      {
        fail ("HEADER.DIMTAD [BS] %hu != %hu", dwg->header_vars.DIMTAD, dimtad);
        error++;
      }
    dimtad++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTAD", &dimtad)
        && dimtad == dwg->header_vars.DIMTAD)
      {
        pass ("HEADER.DIMTAD [BS] set+1 %hu", dimtad);
      }
    else
      {
        fail ("HEADER.DIMTAD [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMTAD, dimtad);
        error++;
      }
    dimtad--;
    dwg_dynapi_header_set_value (dwg, "DIMTAD", &dimtad);

  }
  {
    BITCODE_BS dimunit;
    if (dwg_dynapi_header_value (dwg, "DIMUNIT", &dimunit, NULL)
        && dimunit == dwg->header_vars.DIMUNIT)
      {
        pass ("HEADER.DIMUNIT [BS] %hu", dimunit);
      }
    else
      {
        fail ("HEADER.DIMUNIT [BS] %hu != %hu", dwg->header_vars.DIMUNIT, dimunit);
        error++;
      }
    dimunit++;
    if (dwg_dynapi_header_set_value (dwg, "DIMUNIT", &dimunit)
        && dimunit == dwg->header_vars.DIMUNIT)
      {
        pass ("HEADER.DIMUNIT [BS] set+1 %hu", dimunit);
      }
    else
      {
        fail ("HEADER.DIMUNIT [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMUNIT, dimunit);
        error++;
      }
    dimunit--;
    dwg_dynapi_header_set_value (dwg, "DIMUNIT", &dimunit);

  }
  {
    BITCODE_BS dimaunit;
    if (dwg_dynapi_header_value (dwg, "DIMAUNIT", &dimaunit, NULL)
        && dimaunit == dwg->header_vars.DIMAUNIT)
      {
        pass ("HEADER.DIMAUNIT [BS] %hu", dimaunit);
      }
    else
      {
        fail ("HEADER.DIMAUNIT [BS] %hu != %hu", dwg->header_vars.DIMAUNIT, dimaunit);
        error++;
      }
    dimaunit++;
    if (dwg_dynapi_header_set_value (dwg, "DIMAUNIT", &dimaunit)
        && dimaunit == dwg->header_vars.DIMAUNIT)
      {
        pass ("HEADER.DIMAUNIT [BS] set+1 %hu", dimaunit);
      }
    else
      {
        fail ("HEADER.DIMAUNIT [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMAUNIT, dimaunit);
        error++;
      }
    dimaunit--;
    dwg_dynapi_header_set_value (dwg, "DIMAUNIT", &dimaunit);

  }
  {
    BITCODE_BS dimdec;
    if (dwg_dynapi_header_value (dwg, "DIMDEC", &dimdec, NULL)
        && dimdec == dwg->header_vars.DIMDEC)
      {
        pass ("HEADER.DIMDEC [BS] %hu", dimdec);
      }
    else
      {
        fail ("HEADER.DIMDEC [BS] %hu != %hu", dwg->header_vars.DIMDEC, dimdec);
        error++;
      }
    dimdec++;
    if (dwg_dynapi_header_set_value (dwg, "DIMDEC", &dimdec)
        && dimdec == dwg->header_vars.DIMDEC)
      {
        pass ("HEADER.DIMDEC [BS] set+1 %hu", dimdec);
      }
    else
      {
        fail ("HEADER.DIMDEC [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMDEC, dimdec);
        error++;
      }
    dimdec--;
    dwg_dynapi_header_set_value (dwg, "DIMDEC", &dimdec);

  }
  {
    BITCODE_BS dimtdec;
    if (dwg_dynapi_header_value (dwg, "DIMTDEC", &dimtdec, NULL)
        && dimtdec == dwg->header_vars.DIMTDEC)
      {
        pass ("HEADER.DIMTDEC [BS] %hu", dimtdec);
      }
    else
      {
        fail ("HEADER.DIMTDEC [BS] %hu != %hu", dwg->header_vars.DIMTDEC, dimtdec);
        error++;
      }
    dimtdec++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTDEC", &dimtdec)
        && dimtdec == dwg->header_vars.DIMTDEC)
      {
        pass ("HEADER.DIMTDEC [BS] set+1 %hu", dimtdec);
      }
    else
      {
        fail ("HEADER.DIMTDEC [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMTDEC, dimtdec);
        error++;
      }
    dimtdec--;
    dwg_dynapi_header_set_value (dwg, "DIMTDEC", &dimtdec);

  }
  {
    BITCODE_BS dimaltu;
    if (dwg_dynapi_header_value (dwg, "DIMALTU", &dimaltu, NULL)
        && dimaltu == dwg->header_vars.DIMALTU)
      {
        pass ("HEADER.DIMALTU [BS] %hu", dimaltu);
      }
    else
      {
        fail ("HEADER.DIMALTU [BS] %hu != %hu", dwg->header_vars.DIMALTU, dimaltu);
        error++;
      }
    dimaltu++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTU", &dimaltu)
        && dimaltu == dwg->header_vars.DIMALTU)
      {
        pass ("HEADER.DIMALTU [BS] set+1 %hu", dimaltu);
      }
    else
      {
        fail ("HEADER.DIMALTU [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMALTU, dimaltu);
        error++;
      }
    dimaltu--;
    dwg_dynapi_header_set_value (dwg, "DIMALTU", &dimaltu);

  }
  {
    BITCODE_BS dimalttd;
    if (dwg_dynapi_header_value (dwg, "DIMALTTD", &dimalttd, NULL)
        && dimalttd == dwg->header_vars.DIMALTTD)
      {
        pass ("HEADER.DIMALTTD [BS] %hu", dimalttd);
      }
    else
      {
        fail ("HEADER.DIMALTTD [BS] %hu != %hu", dwg->header_vars.DIMALTTD, dimalttd);
        error++;
      }
    dimalttd++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTTD", &dimalttd)
        && dimalttd == dwg->header_vars.DIMALTTD)
      {
        pass ("HEADER.DIMALTTD [BS] set+1 %hu", dimalttd);
      }
    else
      {
        fail ("HEADER.DIMALTTD [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMALTTD, dimalttd);
        error++;
      }
    dimalttd--;
    dwg_dynapi_header_set_value (dwg, "DIMALTTD", &dimalttd);

  }
  {
    BITCODE_H dimtxsty;
    if (dwg_dynapi_header_value (dwg, "DIMTXSTY", &dimtxsty, NULL)
        && !memcmp (&dimtxsty, &dwg->header_vars.DIMTXSTY, sizeof (dwg->header_vars.DIMTXSTY))
       )
      {
        pass ("HEADER.DIMTXSTY [H]");
      }
    else
      {
        fail ("HEADER.DIMTXSTY [H]");
        error++;
      }
  }
  {
    BITCODE_BD dimscale;
    if (dwg_dynapi_header_value (dwg, "DIMSCALE", &dimscale, NULL)
        && dimscale == dwg->header_vars.DIMSCALE)
      {
        pass ("HEADER.DIMSCALE [BD] %g", dimscale);
      }
    else
      {
        fail ("HEADER.DIMSCALE [BD] %g != %g", dwg->header_vars.DIMSCALE, dimscale);
        error++;
      }
    dimscale++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSCALE", &dimscale)
        && dimscale == dwg->header_vars.DIMSCALE)
      {
        pass ("HEADER.DIMSCALE [BD] set+1 %g", dimscale);
      }
    else
      {
        fail ("HEADER.DIMSCALE [BD] set+1 %g != %g",
              dwg->header_vars.DIMSCALE, dimscale);
        error++;
      }
    dimscale--;
    dwg_dynapi_header_set_value (dwg, "DIMSCALE", &dimscale);

  }
  {
    BITCODE_BD dimasz;
    if (dwg_dynapi_header_value (dwg, "DIMASZ", &dimasz, NULL)
        && dimasz == dwg->header_vars.DIMASZ)
      {
        pass ("HEADER.DIMASZ [BD] %g", dimasz);
      }
    else
      {
        fail ("HEADER.DIMASZ [BD] %g != %g", dwg->header_vars.DIMASZ, dimasz);
        error++;
      }
    dimasz++;
    if (dwg_dynapi_header_set_value (dwg, "DIMASZ", &dimasz)
        && dimasz == dwg->header_vars.DIMASZ)
      {
        pass ("HEADER.DIMASZ [BD] set+1 %g", dimasz);
      }
    else
      {
        fail ("HEADER.DIMASZ [BD] set+1 %g != %g",
              dwg->header_vars.DIMASZ, dimasz);
        error++;
      }
    dimasz--;
    dwg_dynapi_header_set_value (dwg, "DIMASZ", &dimasz);

  }
  {
    BITCODE_BD dimexo;
    if (dwg_dynapi_header_value (dwg, "DIMEXO", &dimexo, NULL)
        && dimexo == dwg->header_vars.DIMEXO)
      {
        pass ("HEADER.DIMEXO [BD] %g", dimexo);
      }
    else
      {
        fail ("HEADER.DIMEXO [BD] %g != %g", dwg->header_vars.DIMEXO, dimexo);
        error++;
      }
    dimexo++;
    if (dwg_dynapi_header_set_value (dwg, "DIMEXO", &dimexo)
        && dimexo == dwg->header_vars.DIMEXO)
      {
        pass ("HEADER.DIMEXO [BD] set+1 %g", dimexo);
      }
    else
      {
        fail ("HEADER.DIMEXO [BD] set+1 %g != %g",
              dwg->header_vars.DIMEXO, dimexo);
        error++;
      }
    dimexo--;
    dwg_dynapi_header_set_value (dwg, "DIMEXO", &dimexo);

  }
  {
    BITCODE_BD dimdli;
    if (dwg_dynapi_header_value (dwg, "DIMDLI", &dimdli, NULL)
        && dimdli == dwg->header_vars.DIMDLI)
      {
        pass ("HEADER.DIMDLI [BD] %g", dimdli);
      }
    else
      {
        fail ("HEADER.DIMDLI [BD] %g != %g", dwg->header_vars.DIMDLI, dimdli);
        error++;
      }
    dimdli++;
    if (dwg_dynapi_header_set_value (dwg, "DIMDLI", &dimdli)
        && dimdli == dwg->header_vars.DIMDLI)
      {
        pass ("HEADER.DIMDLI [BD] set+1 %g", dimdli);
      }
    else
      {
        fail ("HEADER.DIMDLI [BD] set+1 %g != %g",
              dwg->header_vars.DIMDLI, dimdli);
        error++;
      }
    dimdli--;
    dwg_dynapi_header_set_value (dwg, "DIMDLI", &dimdli);

  }
  {
    BITCODE_BD dimexe;
    if (dwg_dynapi_header_value (dwg, "DIMEXE", &dimexe, NULL)
        && dimexe == dwg->header_vars.DIMEXE)
      {
        pass ("HEADER.DIMEXE [BD] %g", dimexe);
      }
    else
      {
        fail ("HEADER.DIMEXE [BD] %g != %g", dwg->header_vars.DIMEXE, dimexe);
        error++;
      }
    dimexe++;
    if (dwg_dynapi_header_set_value (dwg, "DIMEXE", &dimexe)
        && dimexe == dwg->header_vars.DIMEXE)
      {
        pass ("HEADER.DIMEXE [BD] set+1 %g", dimexe);
      }
    else
      {
        fail ("HEADER.DIMEXE [BD] set+1 %g != %g",
              dwg->header_vars.DIMEXE, dimexe);
        error++;
      }
    dimexe--;
    dwg_dynapi_header_set_value (dwg, "DIMEXE", &dimexe);

  }
  {
    BITCODE_BD dimrnd;
    if (dwg_dynapi_header_value (dwg, "DIMRND", &dimrnd, NULL)
        && dimrnd == dwg->header_vars.DIMRND)
      {
        pass ("HEADER.DIMRND [BD] %g", dimrnd);
      }
    else
      {
        fail ("HEADER.DIMRND [BD] %g != %g", dwg->header_vars.DIMRND, dimrnd);
        error++;
      }
    dimrnd++;
    if (dwg_dynapi_header_set_value (dwg, "DIMRND", &dimrnd)
        && dimrnd == dwg->header_vars.DIMRND)
      {
        pass ("HEADER.DIMRND [BD] set+1 %g", dimrnd);
      }
    else
      {
        fail ("HEADER.DIMRND [BD] set+1 %g != %g",
              dwg->header_vars.DIMRND, dimrnd);
        error++;
      }
    dimrnd--;
    dwg_dynapi_header_set_value (dwg, "DIMRND", &dimrnd);

  }
  {
    BITCODE_BD dimdle;
    if (dwg_dynapi_header_value (dwg, "DIMDLE", &dimdle, NULL)
        && dimdle == dwg->header_vars.DIMDLE)
      {
        pass ("HEADER.DIMDLE [BD] %g", dimdle);
      }
    else
      {
        fail ("HEADER.DIMDLE [BD] %g != %g", dwg->header_vars.DIMDLE, dimdle);
        error++;
      }
    dimdle++;
    if (dwg_dynapi_header_set_value (dwg, "DIMDLE", &dimdle)
        && dimdle == dwg->header_vars.DIMDLE)
      {
        pass ("HEADER.DIMDLE [BD] set+1 %g", dimdle);
      }
    else
      {
        fail ("HEADER.DIMDLE [BD] set+1 %g != %g",
              dwg->header_vars.DIMDLE, dimdle);
        error++;
      }
    dimdle--;
    dwg_dynapi_header_set_value (dwg, "DIMDLE", &dimdle);

  }
  {
    BITCODE_BD dimtp;
    if (dwg_dynapi_header_value (dwg, "DIMTP", &dimtp, NULL)
        && dimtp == dwg->header_vars.DIMTP)
      {
        pass ("HEADER.DIMTP [BD] %g", dimtp);
      }
    else
      {
        fail ("HEADER.DIMTP [BD] %g != %g", dwg->header_vars.DIMTP, dimtp);
        error++;
      }
    dimtp++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTP", &dimtp)
        && dimtp == dwg->header_vars.DIMTP)
      {
        pass ("HEADER.DIMTP [BD] set+1 %g", dimtp);
      }
    else
      {
        fail ("HEADER.DIMTP [BD] set+1 %g != %g",
              dwg->header_vars.DIMTP, dimtp);
        error++;
      }
    dimtp--;
    dwg_dynapi_header_set_value (dwg, "DIMTP", &dimtp);

  }
  {
    BITCODE_BD dimtm;
    if (dwg_dynapi_header_value (dwg, "DIMTM", &dimtm, NULL)
        && dimtm == dwg->header_vars.DIMTM)
      {
        pass ("HEADER.DIMTM [BD] %g", dimtm);
      }
    else
      {
        fail ("HEADER.DIMTM [BD] %g != %g", dwg->header_vars.DIMTM, dimtm);
        error++;
      }
    dimtm++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTM", &dimtm)
        && dimtm == dwg->header_vars.DIMTM)
      {
        pass ("HEADER.DIMTM [BD] set+1 %g", dimtm);
      }
    else
      {
        fail ("HEADER.DIMTM [BD] set+1 %g != %g",
              dwg->header_vars.DIMTM, dimtm);
        error++;
      }
    dimtm--;
    dwg_dynapi_header_set_value (dwg, "DIMTM", &dimtm);

  }
  {
    BITCODE_BD dimfxl;
    if (dwg_dynapi_header_value (dwg, "DIMFXL", &dimfxl, NULL)
        && dimfxl == dwg->header_vars.DIMFXL)
      {
        pass ("HEADER.DIMFXL [BD] %g", dimfxl);
      }
    else
      {
        fail ("HEADER.DIMFXL [BD] %g != %g", dwg->header_vars.DIMFXL, dimfxl);
        error++;
      }
    dimfxl++;
    if (dwg_dynapi_header_set_value (dwg, "DIMFXL", &dimfxl)
        && dimfxl == dwg->header_vars.DIMFXL)
      {
        pass ("HEADER.DIMFXL [BD] set+1 %g", dimfxl);
      }
    else
      {
        fail ("HEADER.DIMFXL [BD] set+1 %g != %g",
              dwg->header_vars.DIMFXL, dimfxl);
        error++;
      }
    dimfxl--;
    dwg_dynapi_header_set_value (dwg, "DIMFXL", &dimfxl);

  }
  {
    BITCODE_BD dimjogang;
    if (dwg_dynapi_header_value (dwg, "DIMJOGANG", &dimjogang, NULL)
        && dimjogang == dwg->header_vars.DIMJOGANG)
      {
        pass ("HEADER.DIMJOGANG [BD] %g", dimjogang);
      }
    else
      {
        fail ("HEADER.DIMJOGANG [BD] %g != %g", dwg->header_vars.DIMJOGANG, dimjogang);
        error++;
      }
    dimjogang++;
    if (dwg_dynapi_header_set_value (dwg, "DIMJOGANG", &dimjogang)
        && dimjogang == dwg->header_vars.DIMJOGANG)
      {
        pass ("HEADER.DIMJOGANG [BD] set+1 %g", dimjogang);
      }
    else
      {
        fail ("HEADER.DIMJOGANG [BD] set+1 %g != %g",
              dwg->header_vars.DIMJOGANG, dimjogang);
        error++;
      }
    dimjogang--;
    dwg_dynapi_header_set_value (dwg, "DIMJOGANG", &dimjogang);

  }
  {
    BITCODE_BS dimtfill;
    if (dwg_dynapi_header_value (dwg, "DIMTFILL", &dimtfill, NULL)
        && dimtfill == dwg->header_vars.DIMTFILL)
      {
        pass ("HEADER.DIMTFILL [BS] %hu", dimtfill);
      }
    else
      {
        fail ("HEADER.DIMTFILL [BS] %hu != %hu", dwg->header_vars.DIMTFILL, dimtfill);
        error++;
      }
    dimtfill++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTFILL", &dimtfill)
        && dimtfill == dwg->header_vars.DIMTFILL)
      {
        pass ("HEADER.DIMTFILL [BS] set+1 %hu", dimtfill);
      }
    else
      {
        fail ("HEADER.DIMTFILL [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMTFILL, dimtfill);
        error++;
      }
    dimtfill--;
    dwg_dynapi_header_set_value (dwg, "DIMTFILL", &dimtfill);

  }
  {
    BITCODE_CMC dimtfillclr;
    if (dwg_dynapi_header_value (dwg, "DIMTFILLCLR", &dimtfillclr, NULL)
        && !memcmp (&dimtfillclr, &dwg->header_vars.DIMTFILLCLR, sizeof (dwg->header_vars.DIMTFILLCLR))
       )
      {
        pass ("HEADER.DIMTFILLCLR [CMC]");
      }
    else
      {
        fail ("HEADER.DIMTFILLCLR [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS dimazin;
    if (dwg_dynapi_header_value (dwg, "DIMAZIN", &dimazin, NULL)
        && dimazin == dwg->header_vars.DIMAZIN)
      {
        pass ("HEADER.DIMAZIN [BS] %hu", dimazin);
      }
    else
      {
        fail ("HEADER.DIMAZIN [BS] %hu != %hu", dwg->header_vars.DIMAZIN, dimazin);
        error++;
      }
    dimazin++;
    if (dwg_dynapi_header_set_value (dwg, "DIMAZIN", &dimazin)
        && dimazin == dwg->header_vars.DIMAZIN)
      {
        pass ("HEADER.DIMAZIN [BS] set+1 %hu", dimazin);
      }
    else
      {
        fail ("HEADER.DIMAZIN [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMAZIN, dimazin);
        error++;
      }
    dimazin--;
    dwg_dynapi_header_set_value (dwg, "DIMAZIN", &dimazin);

  }
  {
    BITCODE_BS dimarcsym;
    if (dwg_dynapi_header_value (dwg, "DIMARCSYM", &dimarcsym, NULL)
        && dimarcsym == dwg->header_vars.DIMARCSYM)
      {
        pass ("HEADER.DIMARCSYM [BS] %hu", dimarcsym);
      }
    else
      {
        fail ("HEADER.DIMARCSYM [BS] %hu != %hu", dwg->header_vars.DIMARCSYM, dimarcsym);
        error++;
      }
    dimarcsym++;
    if (dwg_dynapi_header_set_value (dwg, "DIMARCSYM", &dimarcsym)
        && dimarcsym == dwg->header_vars.DIMARCSYM)
      {
        pass ("HEADER.DIMARCSYM [BS] set+1 %hu", dimarcsym);
      }
    else
      {
        fail ("HEADER.DIMARCSYM [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMARCSYM, dimarcsym);
        error++;
      }
    dimarcsym--;
    dwg_dynapi_header_set_value (dwg, "DIMARCSYM", &dimarcsym);

  }
  {
    BITCODE_BD dimtxt;
    if (dwg_dynapi_header_value (dwg, "DIMTXT", &dimtxt, NULL)
        && dimtxt == dwg->header_vars.DIMTXT)
      {
        pass ("HEADER.DIMTXT [BD] %g", dimtxt);
      }
    else
      {
        fail ("HEADER.DIMTXT [BD] %g != %g", dwg->header_vars.DIMTXT, dimtxt);
        error++;
      }
    dimtxt++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTXT", &dimtxt)
        && dimtxt == dwg->header_vars.DIMTXT)
      {
        pass ("HEADER.DIMTXT [BD] set+1 %g", dimtxt);
      }
    else
      {
        fail ("HEADER.DIMTXT [BD] set+1 %g != %g",
              dwg->header_vars.DIMTXT, dimtxt);
        error++;
      }
    dimtxt--;
    dwg_dynapi_header_set_value (dwg, "DIMTXT", &dimtxt);

  }
  {
    BITCODE_BD dimcen;
    if (dwg_dynapi_header_value (dwg, "DIMCEN", &dimcen, NULL)
        && dimcen == dwg->header_vars.DIMCEN)
      {
        pass ("HEADER.DIMCEN [BD] %g", dimcen);
      }
    else
      {
        fail ("HEADER.DIMCEN [BD] %g != %g", dwg->header_vars.DIMCEN, dimcen);
        error++;
      }
    dimcen++;
    if (dwg_dynapi_header_set_value (dwg, "DIMCEN", &dimcen)
        && dimcen == dwg->header_vars.DIMCEN)
      {
        pass ("HEADER.DIMCEN [BD] set+1 %g", dimcen);
      }
    else
      {
        fail ("HEADER.DIMCEN [BD] set+1 %g != %g",
              dwg->header_vars.DIMCEN, dimcen);
        error++;
      }
    dimcen--;
    dwg_dynapi_header_set_value (dwg, "DIMCEN", &dimcen);

  }
  {
    BITCODE_BD dimtsz;
    if (dwg_dynapi_header_value (dwg, "DIMTSZ", &dimtsz, NULL)
        && dimtsz == dwg->header_vars.DIMTSZ)
      {
        pass ("HEADER.DIMTSZ [BD] %g", dimtsz);
      }
    else
      {
        fail ("HEADER.DIMTSZ [BD] %g != %g", dwg->header_vars.DIMTSZ, dimtsz);
        error++;
      }
    dimtsz++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTSZ", &dimtsz)
        && dimtsz == dwg->header_vars.DIMTSZ)
      {
        pass ("HEADER.DIMTSZ [BD] set+1 %g", dimtsz);
      }
    else
      {
        fail ("HEADER.DIMTSZ [BD] set+1 %g != %g",
              dwg->header_vars.DIMTSZ, dimtsz);
        error++;
      }
    dimtsz--;
    dwg_dynapi_header_set_value (dwg, "DIMTSZ", &dimtsz);

  }
  {
    BITCODE_BD dimaltf;
    if (dwg_dynapi_header_value (dwg, "DIMALTF", &dimaltf, NULL)
        && dimaltf == dwg->header_vars.DIMALTF)
      {
        pass ("HEADER.DIMALTF [BD] %g", dimaltf);
      }
    else
      {
        fail ("HEADER.DIMALTF [BD] %g != %g", dwg->header_vars.DIMALTF, dimaltf);
        error++;
      }
    dimaltf++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTF", &dimaltf)
        && dimaltf == dwg->header_vars.DIMALTF)
      {
        pass ("HEADER.DIMALTF [BD] set+1 %g", dimaltf);
      }
    else
      {
        fail ("HEADER.DIMALTF [BD] set+1 %g != %g",
              dwg->header_vars.DIMALTF, dimaltf);
        error++;
      }
    dimaltf--;
    dwg_dynapi_header_set_value (dwg, "DIMALTF", &dimaltf);

  }
  {
    BITCODE_BD dimlfac;
    if (dwg_dynapi_header_value (dwg, "DIMLFAC", &dimlfac, NULL)
        && dimlfac == dwg->header_vars.DIMLFAC)
      {
        pass ("HEADER.DIMLFAC [BD] %g", dimlfac);
      }
    else
      {
        fail ("HEADER.DIMLFAC [BD] %g != %g", dwg->header_vars.DIMLFAC, dimlfac);
        error++;
      }
    dimlfac++;
    if (dwg_dynapi_header_set_value (dwg, "DIMLFAC", &dimlfac)
        && dimlfac == dwg->header_vars.DIMLFAC)
      {
        pass ("HEADER.DIMLFAC [BD] set+1 %g", dimlfac);
      }
    else
      {
        fail ("HEADER.DIMLFAC [BD] set+1 %g != %g",
              dwg->header_vars.DIMLFAC, dimlfac);
        error++;
      }
    dimlfac--;
    dwg_dynapi_header_set_value (dwg, "DIMLFAC", &dimlfac);

  }
  {
    BITCODE_BD dimtvp;
    if (dwg_dynapi_header_value (dwg, "DIMTVP", &dimtvp, NULL)
        && dimtvp == dwg->header_vars.DIMTVP)
      {
        pass ("HEADER.DIMTVP [BD] %g", dimtvp);
      }
    else
      {
        fail ("HEADER.DIMTVP [BD] %g != %g", dwg->header_vars.DIMTVP, dimtvp);
        error++;
      }
    dimtvp++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTVP", &dimtvp)
        && dimtvp == dwg->header_vars.DIMTVP)
      {
        pass ("HEADER.DIMTVP [BD] set+1 %g", dimtvp);
      }
    else
      {
        fail ("HEADER.DIMTVP [BD] set+1 %g != %g",
              dwg->header_vars.DIMTVP, dimtvp);
        error++;
      }
    dimtvp--;
    dwg_dynapi_header_set_value (dwg, "DIMTVP", &dimtvp);

  }
  {
    BITCODE_BD dimtfac;
    if (dwg_dynapi_header_value (dwg, "DIMTFAC", &dimtfac, NULL)
        && dimtfac == dwg->header_vars.DIMTFAC)
      {
        pass ("HEADER.DIMTFAC [BD] %g", dimtfac);
      }
    else
      {
        fail ("HEADER.DIMTFAC [BD] %g != %g", dwg->header_vars.DIMTFAC, dimtfac);
        error++;
      }
    dimtfac++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTFAC", &dimtfac)
        && dimtfac == dwg->header_vars.DIMTFAC)
      {
        pass ("HEADER.DIMTFAC [BD] set+1 %g", dimtfac);
      }
    else
      {
        fail ("HEADER.DIMTFAC [BD] set+1 %g != %g",
              dwg->header_vars.DIMTFAC, dimtfac);
        error++;
      }
    dimtfac--;
    dwg_dynapi_header_set_value (dwg, "DIMTFAC", &dimtfac);

  }
  {
    BITCODE_BD dimgap;
    if (dwg_dynapi_header_value (dwg, "DIMGAP", &dimgap, NULL)
        && dimgap == dwg->header_vars.DIMGAP)
      {
        pass ("HEADER.DIMGAP [BD] %g", dimgap);
      }
    else
      {
        fail ("HEADER.DIMGAP [BD] %g != %g", dwg->header_vars.DIMGAP, dimgap);
        error++;
      }
    dimgap++;
    if (dwg_dynapi_header_set_value (dwg, "DIMGAP", &dimgap)
        && dimgap == dwg->header_vars.DIMGAP)
      {
        pass ("HEADER.DIMGAP [BD] set+1 %g", dimgap);
      }
    else
      {
        fail ("HEADER.DIMGAP [BD] set+1 %g != %g",
              dwg->header_vars.DIMGAP, dimgap);
        error++;
      }
    dimgap--;
    dwg_dynapi_header_set_value (dwg, "DIMGAP", &dimgap);

  }
  {
    BITCODE_T dimpost_t;
    if (dwg_dynapi_header_value (dwg, "DIMPOST_T", &dimpost_t, NULL)
        && !memcmp (&dimpost_t, &dwg->header_vars.DIMPOST_T, sizeof (dwg->header_vars.DIMPOST_T))
       )
      {
        pass ("HEADER.DIMPOST_T [T]");
      }
    else
      {
        fail ("HEADER.DIMPOST_T [T]");
        error++;
      }
  }
  {
    BITCODE_T dimapost_t;
    if (dwg_dynapi_header_value (dwg, "DIMAPOST_T", &dimapost_t, NULL)
        && !memcmp (&dimapost_t, &dwg->header_vars.DIMAPOST_T, sizeof (dwg->header_vars.DIMAPOST_T))
       )
      {
        pass ("HEADER.DIMAPOST_T [T]");
      }
    else
      {
        fail ("HEADER.DIMAPOST_T [T]");
        error++;
      }
  }
  {
    BITCODE_T dimblk_t;
    if (dwg_dynapi_header_value (dwg, "DIMBLK_T", &dimblk_t, NULL)
        && !memcmp (&dimblk_t, &dwg->header_vars.DIMBLK_T, sizeof (dwg->header_vars.DIMBLK_T))
       )
      {
        pass ("HEADER.DIMBLK_T [T]");
      }
    else
      {
        fail ("HEADER.DIMBLK_T [T]");
        error++;
      }
  }
  {
    BITCODE_T dimblk1_t;
    if (dwg_dynapi_header_value (dwg, "DIMBLK1_T", &dimblk1_t, NULL)
        && !memcmp (&dimblk1_t, &dwg->header_vars.DIMBLK1_T, sizeof (dwg->header_vars.DIMBLK1_T))
       )
      {
        pass ("HEADER.DIMBLK1_T [T]");
      }
    else
      {
        fail ("HEADER.DIMBLK1_T [T]");
        error++;
      }
  }
  {
    BITCODE_T dimblk2_t;
    if (dwg_dynapi_header_value (dwg, "DIMBLK2_T", &dimblk2_t, NULL)
        && !memcmp (&dimblk2_t, &dwg->header_vars.DIMBLK2_T, sizeof (dwg->header_vars.DIMBLK2_T))
       )
      {
        pass ("HEADER.DIMBLK2_T [T]");
      }
    else
      {
        fail ("HEADER.DIMBLK2_T [T]");
        error++;
      }
  }
  {
    BITCODE_BD dimaltrnd;
    if (dwg_dynapi_header_value (dwg, "DIMALTRND", &dimaltrnd, NULL)
        && dimaltrnd == dwg->header_vars.DIMALTRND)
      {
        pass ("HEADER.DIMALTRND [BD] %g", dimaltrnd);
      }
    else
      {
        fail ("HEADER.DIMALTRND [BD] %g != %g", dwg->header_vars.DIMALTRND, dimaltrnd);
        error++;
      }
    dimaltrnd++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTRND", &dimaltrnd)
        && dimaltrnd == dwg->header_vars.DIMALTRND)
      {
        pass ("HEADER.DIMALTRND [BD] set+1 %g", dimaltrnd);
      }
    else
      {
        fail ("HEADER.DIMALTRND [BD] set+1 %g != %g",
              dwg->header_vars.DIMALTRND, dimaltrnd);
        error++;
      }
    dimaltrnd--;
    dwg_dynapi_header_set_value (dwg, "DIMALTRND", &dimaltrnd);

  }
  {
    BITCODE_RS dimclrd_c;
    if (dwg_dynapi_header_value (dwg, "DIMCLRD_C", &dimclrd_c, NULL)
        && dimclrd_c == dwg->header_vars.DIMCLRD_C)
      {
        pass ("HEADER.DIMCLRD_C [RS] %hu", dimclrd_c);
      }
    else
      {
        fail ("HEADER.DIMCLRD_C [RS] %hu != %hu", dwg->header_vars.DIMCLRD_C, dimclrd_c);
        error++;
      }
    dimclrd_c++;
    if (dwg_dynapi_header_set_value (dwg, "DIMCLRD_C", &dimclrd_c)
        && dimclrd_c == dwg->header_vars.DIMCLRD_C)
      {
        pass ("HEADER.DIMCLRD_C [RS] set+1 %hu", dimclrd_c);
      }
    else
      {
        fail ("HEADER.DIMCLRD_C [RS] set+1 %hu != %hu",
              dwg->header_vars.DIMCLRD_C, dimclrd_c);
        error++;
      }
    dimclrd_c--;
    dwg_dynapi_header_set_value (dwg, "DIMCLRD_C", &dimclrd_c);

  }
  {
    BITCODE_RS dimclre_c;
    if (dwg_dynapi_header_value (dwg, "DIMCLRE_C", &dimclre_c, NULL)
        && dimclre_c == dwg->header_vars.DIMCLRE_C)
      {
        pass ("HEADER.DIMCLRE_C [RS] %hu", dimclre_c);
      }
    else
      {
        fail ("HEADER.DIMCLRE_C [RS] %hu != %hu", dwg->header_vars.DIMCLRE_C, dimclre_c);
        error++;
      }
    dimclre_c++;
    if (dwg_dynapi_header_set_value (dwg, "DIMCLRE_C", &dimclre_c)
        && dimclre_c == dwg->header_vars.DIMCLRE_C)
      {
        pass ("HEADER.DIMCLRE_C [RS] set+1 %hu", dimclre_c);
      }
    else
      {
        fail ("HEADER.DIMCLRE_C [RS] set+1 %hu != %hu",
              dwg->header_vars.DIMCLRE_C, dimclre_c);
        error++;
      }
    dimclre_c--;
    dwg_dynapi_header_set_value (dwg, "DIMCLRE_C", &dimclre_c);

  }
  {
    BITCODE_RS dimclrt_c;
    if (dwg_dynapi_header_value (dwg, "DIMCLRT_C", &dimclrt_c, NULL)
        && dimclrt_c == dwg->header_vars.DIMCLRT_C)
      {
        pass ("HEADER.DIMCLRT_C [RS] %hu", dimclrt_c);
      }
    else
      {
        fail ("HEADER.DIMCLRT_C [RS] %hu != %hu", dwg->header_vars.DIMCLRT_C, dimclrt_c);
        error++;
      }
    dimclrt_c++;
    if (dwg_dynapi_header_set_value (dwg, "DIMCLRT_C", &dimclrt_c)
        && dimclrt_c == dwg->header_vars.DIMCLRT_C)
      {
        pass ("HEADER.DIMCLRT_C [RS] set+1 %hu", dimclrt_c);
      }
    else
      {
        fail ("HEADER.DIMCLRT_C [RS] set+1 %hu != %hu",
              dwg->header_vars.DIMCLRT_C, dimclrt_c);
        error++;
      }
    dimclrt_c--;
    dwg_dynapi_header_set_value (dwg, "DIMCLRT_C", &dimclrt_c);

  }
  {
    BITCODE_CMC dimclrd;
    if (dwg_dynapi_header_value (dwg, "DIMCLRD", &dimclrd, NULL)
        && !memcmp (&dimclrd, &dwg->header_vars.DIMCLRD, sizeof (dwg->header_vars.DIMCLRD))
       )
      {
        pass ("HEADER.DIMCLRD [CMC]");
      }
    else
      {
        fail ("HEADER.DIMCLRD [CMC]");
        error++;
      }
  }
  {
    BITCODE_CMC dimclre;
    if (dwg_dynapi_header_value (dwg, "DIMCLRE", &dimclre, NULL)
        && !memcmp (&dimclre, &dwg->header_vars.DIMCLRE, sizeof (dwg->header_vars.DIMCLRE))
       )
      {
        pass ("HEADER.DIMCLRE [CMC]");
      }
    else
      {
        fail ("HEADER.DIMCLRE [CMC]");
        error++;
      }
  }
  {
    BITCODE_CMC dimclrt;
    if (dwg_dynapi_header_value (dwg, "DIMCLRT", &dimclrt, NULL)
        && !memcmp (&dimclrt, &dwg->header_vars.DIMCLRT, sizeof (dwg->header_vars.DIMCLRT))
       )
      {
        pass ("HEADER.DIMCLRT [CMC]");
      }
    else
      {
        fail ("HEADER.DIMCLRT [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS dimadec;
    if (dwg_dynapi_header_value (dwg, "DIMADEC", &dimadec, NULL)
        && dimadec == dwg->header_vars.DIMADEC)
      {
        pass ("HEADER.DIMADEC [BS] %hu", dimadec);
      }
    else
      {
        fail ("HEADER.DIMADEC [BS] %hu != %hu", dwg->header_vars.DIMADEC, dimadec);
        error++;
      }
    dimadec++;
    if (dwg_dynapi_header_set_value (dwg, "DIMADEC", &dimadec)
        && dimadec == dwg->header_vars.DIMADEC)
      {
        pass ("HEADER.DIMADEC [BS] set+1 %hu", dimadec);
      }
    else
      {
        fail ("HEADER.DIMADEC [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMADEC, dimadec);
        error++;
      }
    dimadec--;
    dwg_dynapi_header_set_value (dwg, "DIMADEC", &dimadec);

  }
  {
    BITCODE_BS dimfrac;
    if (dwg_dynapi_header_value (dwg, "DIMFRAC", &dimfrac, NULL)
        && dimfrac == dwg->header_vars.DIMFRAC)
      {
        pass ("HEADER.DIMFRAC [BS] %hu", dimfrac);
      }
    else
      {
        fail ("HEADER.DIMFRAC [BS] %hu != %hu", dwg->header_vars.DIMFRAC, dimfrac);
        error++;
      }
    dimfrac++;
    if (dwg_dynapi_header_set_value (dwg, "DIMFRAC", &dimfrac)
        && dimfrac == dwg->header_vars.DIMFRAC)
      {
        pass ("HEADER.DIMFRAC [BS] set+1 %hu", dimfrac);
      }
    else
      {
        fail ("HEADER.DIMFRAC [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMFRAC, dimfrac);
        error++;
      }
    dimfrac--;
    dwg_dynapi_header_set_value (dwg, "DIMFRAC", &dimfrac);

  }
  {
    BITCODE_BS dimlunit;
    if (dwg_dynapi_header_value (dwg, "DIMLUNIT", &dimlunit, NULL)
        && dimlunit == dwg->header_vars.DIMLUNIT)
      {
        pass ("HEADER.DIMLUNIT [BS] %hu", dimlunit);
      }
    else
      {
        fail ("HEADER.DIMLUNIT [BS] %hu != %hu", dwg->header_vars.DIMLUNIT, dimlunit);
        error++;
      }
    dimlunit++;
    if (dwg_dynapi_header_set_value (dwg, "DIMLUNIT", &dimlunit)
        && dimlunit == dwg->header_vars.DIMLUNIT)
      {
        pass ("HEADER.DIMLUNIT [BS] set+1 %hu", dimlunit);
      }
    else
      {
        fail ("HEADER.DIMLUNIT [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMLUNIT, dimlunit);
        error++;
      }
    dimlunit--;
    dwg_dynapi_header_set_value (dwg, "DIMLUNIT", &dimlunit);

  }
  {
    BITCODE_BS dimdsep;
    if (dwg_dynapi_header_value (dwg, "DIMDSEP", &dimdsep, NULL)
        && dimdsep == dwg->header_vars.DIMDSEP)
      {
        pass ("HEADER.DIMDSEP [BS] %hu", dimdsep);
      }
    else
      {
        fail ("HEADER.DIMDSEP [BS] %hu != %hu", dwg->header_vars.DIMDSEP, dimdsep);
        error++;
      }
    dimdsep++;
    if (dwg_dynapi_header_set_value (dwg, "DIMDSEP", &dimdsep)
        && dimdsep == dwg->header_vars.DIMDSEP)
      {
        pass ("HEADER.DIMDSEP [BS] set+1 %hu", dimdsep);
      }
    else
      {
        fail ("HEADER.DIMDSEP [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMDSEP, dimdsep);
        error++;
      }
    dimdsep--;
    dwg_dynapi_header_set_value (dwg, "DIMDSEP", &dimdsep);

  }
  {
    BITCODE_BS dimtmove;
    if (dwg_dynapi_header_value (dwg, "DIMTMOVE", &dimtmove, NULL)
        && dimtmove == dwg->header_vars.DIMTMOVE)
      {
        pass ("HEADER.DIMTMOVE [BS] %hu", dimtmove);
      }
    else
      {
        fail ("HEADER.DIMTMOVE [BS] %hu != %hu", dwg->header_vars.DIMTMOVE, dimtmove);
        error++;
      }
    dimtmove++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTMOVE", &dimtmove)
        && dimtmove == dwg->header_vars.DIMTMOVE)
      {
        pass ("HEADER.DIMTMOVE [BS] set+1 %hu", dimtmove);
      }
    else
      {
        fail ("HEADER.DIMTMOVE [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMTMOVE, dimtmove);
        error++;
      }
    dimtmove--;
    dwg_dynapi_header_set_value (dwg, "DIMTMOVE", &dimtmove);

  }
  {
    BITCODE_BS dimaltz;
    if (dwg_dynapi_header_value (dwg, "DIMALTZ", &dimaltz, NULL)
        && dimaltz == dwg->header_vars.DIMALTZ)
      {
        pass ("HEADER.DIMALTZ [BS] %hu", dimaltz);
      }
    else
      {
        fail ("HEADER.DIMALTZ [BS] %hu != %hu", dwg->header_vars.DIMALTZ, dimaltz);
        error++;
      }
    dimaltz++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTZ", &dimaltz)
        && dimaltz == dwg->header_vars.DIMALTZ)
      {
        pass ("HEADER.DIMALTZ [BS] set+1 %hu", dimaltz);
      }
    else
      {
        fail ("HEADER.DIMALTZ [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMALTZ, dimaltz);
        error++;
      }
    dimaltz--;
    dwg_dynapi_header_set_value (dwg, "DIMALTZ", &dimaltz);

  }
  {
    BITCODE_BS dimalttz;
    if (dwg_dynapi_header_value (dwg, "DIMALTTZ", &dimalttz, NULL)
        && dimalttz == dwg->header_vars.DIMALTTZ)
      {
        pass ("HEADER.DIMALTTZ [BS] %hu", dimalttz);
      }
    else
      {
        fail ("HEADER.DIMALTTZ [BS] %hu != %hu", dwg->header_vars.DIMALTTZ, dimalttz);
        error++;
      }
    dimalttz++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTTZ", &dimalttz)
        && dimalttz == dwg->header_vars.DIMALTTZ)
      {
        pass ("HEADER.DIMALTTZ [BS] set+1 %hu", dimalttz);
      }
    else
      {
        fail ("HEADER.DIMALTTZ [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMALTTZ, dimalttz);
        error++;
      }
    dimalttz--;
    dwg_dynapi_header_set_value (dwg, "DIMALTTZ", &dimalttz);

  }
  {
    BITCODE_BS dimatfit;
    if (dwg_dynapi_header_value (dwg, "DIMATFIT", &dimatfit, NULL)
        && dimatfit == dwg->header_vars.DIMATFIT)
      {
        pass ("HEADER.DIMATFIT [BS] %hu", dimatfit);
      }
    else
      {
        fail ("HEADER.DIMATFIT [BS] %hu != %hu", dwg->header_vars.DIMATFIT, dimatfit);
        error++;
      }
    dimatfit++;
    if (dwg_dynapi_header_set_value (dwg, "DIMATFIT", &dimatfit)
        && dimatfit == dwg->header_vars.DIMATFIT)
      {
        pass ("HEADER.DIMATFIT [BS] set+1 %hu", dimatfit);
      }
    else
      {
        fail ("HEADER.DIMATFIT [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMATFIT, dimatfit);
        error++;
      }
    dimatfit--;
    dwg_dynapi_header_set_value (dwg, "DIMATFIT", &dimatfit);

  }
  {
    BITCODE_B dimfxlon;
    if (dwg_dynapi_header_value (dwg, "DIMFXLON", &dimfxlon, NULL)
        && dimfxlon == dwg->header_vars.DIMFXLON)
      {
        pass ("HEADER.DIMFXLON [B] " FORMAT_B "", dimfxlon);
      }
    else
      {
        fail ("HEADER.DIMFXLON [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMFXLON, dimfxlon);
        error++;
      }
    dimfxlon++;
    if (dwg_dynapi_header_set_value (dwg, "DIMFXLON", &dimfxlon)
        && dimfxlon == dwg->header_vars.DIMFXLON)
      {
        pass ("HEADER.DIMFXLON [B] set+1 " FORMAT_B "", dimfxlon);
      }
    else
      {
        fail ("HEADER.DIMFXLON [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMFXLON, dimfxlon);
        error++;
      }
    dimfxlon--;
    dwg_dynapi_header_set_value (dwg, "DIMFXLON", &dimfxlon);

  }
  {
    BITCODE_B dimtxtdirection;
    if (dwg_dynapi_header_value (dwg, "DIMTXTDIRECTION", &dimtxtdirection, NULL)
        && dimtxtdirection == dwg->header_vars.DIMTXTDIRECTION)
      {
        pass ("HEADER.DIMTXTDIRECTION [B] " FORMAT_B "", dimtxtdirection);
      }
    else
      {
        fail ("HEADER.DIMTXTDIRECTION [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMTXTDIRECTION, dimtxtdirection);
        error++;
      }
    dimtxtdirection++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTXTDIRECTION", &dimtxtdirection)
        && dimtxtdirection == dwg->header_vars.DIMTXTDIRECTION)
      {
        pass ("HEADER.DIMTXTDIRECTION [B] set+1 " FORMAT_B "", dimtxtdirection);
      }
    else
      {
        fail ("HEADER.DIMTXTDIRECTION [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.DIMTXTDIRECTION, dimtxtdirection);
        error++;
      }
    dimtxtdirection--;
    dwg_dynapi_header_set_value (dwg, "DIMTXTDIRECTION", &dimtxtdirection);

  }
  {
    BITCODE_BD dimaltmzf;
    if (dwg_dynapi_header_value (dwg, "DIMALTMZF", &dimaltmzf, NULL)
        && dimaltmzf == dwg->header_vars.DIMALTMZF)
      {
        pass ("HEADER.DIMALTMZF [BD] %g", dimaltmzf);
      }
    else
      {
        fail ("HEADER.DIMALTMZF [BD] %g != %g", dwg->header_vars.DIMALTMZF, dimaltmzf);
        error++;
      }
    dimaltmzf++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTMZF", &dimaltmzf)
        && dimaltmzf == dwg->header_vars.DIMALTMZF)
      {
        pass ("HEADER.DIMALTMZF [BD] set+1 %g", dimaltmzf);
      }
    else
      {
        fail ("HEADER.DIMALTMZF [BD] set+1 %g != %g",
              dwg->header_vars.DIMALTMZF, dimaltmzf);
        error++;
      }
    dimaltmzf--;
    dwg_dynapi_header_set_value (dwg, "DIMALTMZF", &dimaltmzf);

  }
  {
    BITCODE_T dimaltmzs;
    if (dwg_dynapi_header_value (dwg, "DIMALTMZS", &dimaltmzs, NULL)
        && !memcmp (&dimaltmzs, &dwg->header_vars.DIMALTMZS, sizeof (dwg->header_vars.DIMALTMZS))
       )
      {
        pass ("HEADER.DIMALTMZS [T]");
      }
    else
      {
        fail ("HEADER.DIMALTMZS [T]");
        error++;
      }
  }
  {
    BITCODE_BD dimmzf;
    if (dwg_dynapi_header_value (dwg, "DIMMZF", &dimmzf, NULL)
        && dimmzf == dwg->header_vars.DIMMZF)
      {
        pass ("HEADER.DIMMZF [BD] %g", dimmzf);
      }
    else
      {
        fail ("HEADER.DIMMZF [BD] %g != %g", dwg->header_vars.DIMMZF, dimmzf);
        error++;
      }
    dimmzf++;
    if (dwg_dynapi_header_set_value (dwg, "DIMMZF", &dimmzf)
        && dimmzf == dwg->header_vars.DIMMZF)
      {
        pass ("HEADER.DIMMZF [BD] set+1 %g", dimmzf);
      }
    else
      {
        fail ("HEADER.DIMMZF [BD] set+1 %g != %g",
              dwg->header_vars.DIMMZF, dimmzf);
        error++;
      }
    dimmzf--;
    dwg_dynapi_header_set_value (dwg, "DIMMZF", &dimmzf);

  }
  {
    BITCODE_T dimmzs;
    if (dwg_dynapi_header_value (dwg, "DIMMZS", &dimmzs, NULL)
        && !memcmp (&dimmzs, &dwg->header_vars.DIMMZS, sizeof (dwg->header_vars.DIMMZS))
       )
      {
        pass ("HEADER.DIMMZS [T]");
      }
    else
      {
        fail ("HEADER.DIMMZS [T]");
        error++;
      }
  }
  {
    BITCODE_H dimldrblk;
    if (dwg_dynapi_header_value (dwg, "DIMLDRBLK", &dimldrblk, NULL)
        && !memcmp (&dimldrblk, &dwg->header_vars.DIMLDRBLK, sizeof (dwg->header_vars.DIMLDRBLK))
       )
      {
        pass ("HEADER.DIMLDRBLK [H]");
      }
    else
      {
        fail ("HEADER.DIMLDRBLK [H]");
        error++;
      }
  }
  {
    BITCODE_H dimblk;
    if (dwg_dynapi_header_value (dwg, "DIMBLK", &dimblk, NULL)
        && !memcmp (&dimblk, &dwg->header_vars.DIMBLK, sizeof (dwg->header_vars.DIMBLK))
       )
      {
        pass ("HEADER.DIMBLK [H]");
      }
    else
      {
        fail ("HEADER.DIMBLK [H]");
        error++;
      }
  }
  {
    BITCODE_H dimblk1;
    if (dwg_dynapi_header_value (dwg, "DIMBLK1", &dimblk1, NULL)
        && !memcmp (&dimblk1, &dwg->header_vars.DIMBLK1, sizeof (dwg->header_vars.DIMBLK1))
       )
      {
        pass ("HEADER.DIMBLK1 [H]");
      }
    else
      {
        fail ("HEADER.DIMBLK1 [H]");
        error++;
      }
  }
  {
    BITCODE_H dimblk2;
    if (dwg_dynapi_header_value (dwg, "DIMBLK2", &dimblk2, NULL)
        && !memcmp (&dimblk2, &dwg->header_vars.DIMBLK2, sizeof (dwg->header_vars.DIMBLK2))
       )
      {
        pass ("HEADER.DIMBLK2 [H]");
      }
    else
      {
        fail ("HEADER.DIMBLK2 [H]");
        error++;
      }
  }
  {
    BITCODE_H dimltype;
    if (dwg_dynapi_header_value (dwg, "DIMLTYPE", &dimltype, NULL)
        && !memcmp (&dimltype, &dwg->header_vars.DIMLTYPE, sizeof (dwg->header_vars.DIMLTYPE))
       )
      {
        pass ("HEADER.DIMLTYPE [H]");
      }
    else
      {
        fail ("HEADER.DIMLTYPE [H]");
        error++;
      }
  }
  {
    BITCODE_H dimltex1;
    if (dwg_dynapi_header_value (dwg, "DIMLTEX1", &dimltex1, NULL)
        && !memcmp (&dimltex1, &dwg->header_vars.DIMLTEX1, sizeof (dwg->header_vars.DIMLTEX1))
       )
      {
        pass ("HEADER.DIMLTEX1 [H]");
      }
    else
      {
        fail ("HEADER.DIMLTEX1 [H]");
        error++;
      }
  }
  {
    BITCODE_H dimltex2;
    if (dwg_dynapi_header_value (dwg, "DIMLTEX2", &dimltex2, NULL)
        && !memcmp (&dimltex2, &dwg->header_vars.DIMLTEX2, sizeof (dwg->header_vars.DIMLTEX2))
       )
      {
        pass ("HEADER.DIMLTEX2 [H]");
      }
    else
      {
        fail ("HEADER.DIMLTEX2 [H]");
        error++;
      }
  }
  {
    BITCODE_BS dimlwd;
    if (dwg_dynapi_header_value (dwg, "DIMLWD", &dimlwd, NULL)
        && dimlwd == dwg->header_vars.DIMLWD)
      {
        pass ("HEADER.DIMLWD [BS] %hu", dimlwd);
      }
    else
      {
        fail ("HEADER.DIMLWD [BS] %hu != %hu", dwg->header_vars.DIMLWD, dimlwd);
        error++;
      }
    dimlwd++;
    if (dwg_dynapi_header_set_value (dwg, "DIMLWD", &dimlwd)
        && dimlwd == dwg->header_vars.DIMLWD)
      {
        pass ("HEADER.DIMLWD [BS] set+1 %hu", dimlwd);
      }
    else
      {
        fail ("HEADER.DIMLWD [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMLWD, dimlwd);
        error++;
      }
    dimlwd--;
    dwg_dynapi_header_set_value (dwg, "DIMLWD", &dimlwd);

  }
  {
    BITCODE_BS dimlwe;
    if (dwg_dynapi_header_value (dwg, "DIMLWE", &dimlwe, NULL)
        && dimlwe == dwg->header_vars.DIMLWE)
      {
        pass ("HEADER.DIMLWE [BS] %hu", dimlwe);
      }
    else
      {
        fail ("HEADER.DIMLWE [BS] %hu != %hu", dwg->header_vars.DIMLWE, dimlwe);
        error++;
      }
    dimlwe++;
    if (dwg_dynapi_header_set_value (dwg, "DIMLWE", &dimlwe)
        && dimlwe == dwg->header_vars.DIMLWE)
      {
        pass ("HEADER.DIMLWE [BS] set+1 %hu", dimlwe);
      }
    else
      {
        fail ("HEADER.DIMLWE [BS] set+1 %hu != %hu",
              dwg->header_vars.DIMLWE, dimlwe);
        error++;
      }
    dimlwe--;
    dwg_dynapi_header_set_value (dwg, "DIMLWE", &dimlwe);

  }
  {
    BITCODE_H block_control_object;
    if (dwg_dynapi_header_value (dwg, "BLOCK_CONTROL_OBJECT", &block_control_object, NULL)
        && !memcmp (&block_control_object, &dwg->header_vars.BLOCK_CONTROL_OBJECT, sizeof (dwg->header_vars.BLOCK_CONTROL_OBJECT))
       )
      {
        pass ("HEADER.BLOCK_CONTROL_OBJECT [H]");
      }
    else
      {
        fail ("HEADER.BLOCK_CONTROL_OBJECT [H]");
        error++;
      }
  }
  {
    BITCODE_H layer_control_object;
    if (dwg_dynapi_header_value (dwg, "LAYER_CONTROL_OBJECT", &layer_control_object, NULL)
        && !memcmp (&layer_control_object, &dwg->header_vars.LAYER_CONTROL_OBJECT, sizeof (dwg->header_vars.LAYER_CONTROL_OBJECT))
       )
      {
        pass ("HEADER.LAYER_CONTROL_OBJECT [H]");
      }
    else
      {
        fail ("HEADER.LAYER_CONTROL_OBJECT [H]");
        error++;
      }
  }
  {
    BITCODE_H style_control_object;
    if (dwg_dynapi_header_value (dwg, "STYLE_CONTROL_OBJECT", &style_control_object, NULL)
        && !memcmp (&style_control_object, &dwg->header_vars.STYLE_CONTROL_OBJECT, sizeof (dwg->header_vars.STYLE_CONTROL_OBJECT))
       )
      {
        pass ("HEADER.STYLE_CONTROL_OBJECT [H]");
      }
    else
      {
        fail ("HEADER.STYLE_CONTROL_OBJECT [H]");
        error++;
      }
  }
  {
    BITCODE_H linetype_control_object;
    if (dwg_dynapi_header_value (dwg, "LINETYPE_CONTROL_OBJECT", &linetype_control_object, NULL)
        && !memcmp (&linetype_control_object, &dwg->header_vars.LINETYPE_CONTROL_OBJECT, sizeof (dwg->header_vars.LINETYPE_CONTROL_OBJECT))
       )
      {
        pass ("HEADER.LINETYPE_CONTROL_OBJECT [H]");
      }
    else
      {
        fail ("HEADER.LINETYPE_CONTROL_OBJECT [H]");
        error++;
      }
  }
  {
    BITCODE_H view_control_object;
    if (dwg_dynapi_header_value (dwg, "VIEW_CONTROL_OBJECT", &view_control_object, NULL)
        && !memcmp (&view_control_object, &dwg->header_vars.VIEW_CONTROL_OBJECT, sizeof (dwg->header_vars.VIEW_CONTROL_OBJECT))
       )
      {
        pass ("HEADER.VIEW_CONTROL_OBJECT [H]");
      }
    else
      {
        fail ("HEADER.VIEW_CONTROL_OBJECT [H]");
        error++;
      }
  }
  {
    BITCODE_H ucs_control_object;
    if (dwg_dynapi_header_value (dwg, "UCS_CONTROL_OBJECT", &ucs_control_object, NULL)
        && !memcmp (&ucs_control_object, &dwg->header_vars.UCS_CONTROL_OBJECT, sizeof (dwg->header_vars.UCS_CONTROL_OBJECT))
       )
      {
        pass ("HEADER.UCS_CONTROL_OBJECT [H]");
      }
    else
      {
        fail ("HEADER.UCS_CONTROL_OBJECT [H]");
        error++;
      }
  }
  {
    BITCODE_H vport_control_object;
    if (dwg_dynapi_header_value (dwg, "VPORT_CONTROL_OBJECT", &vport_control_object, NULL)
        && !memcmp (&vport_control_object, &dwg->header_vars.VPORT_CONTROL_OBJECT, sizeof (dwg->header_vars.VPORT_CONTROL_OBJECT))
       )
      {
        pass ("HEADER.VPORT_CONTROL_OBJECT [H]");
      }
    else
      {
        fail ("HEADER.VPORT_CONTROL_OBJECT [H]");
        error++;
      }
  }
  {
    BITCODE_H appid_control_object;
    if (dwg_dynapi_header_value (dwg, "APPID_CONTROL_OBJECT", &appid_control_object, NULL)
        && !memcmp (&appid_control_object, &dwg->header_vars.APPID_CONTROL_OBJECT, sizeof (dwg->header_vars.APPID_CONTROL_OBJECT))
       )
      {
        pass ("HEADER.APPID_CONTROL_OBJECT [H]");
      }
    else
      {
        fail ("HEADER.APPID_CONTROL_OBJECT [H]");
        error++;
      }
  }
  {
    BITCODE_H dimstyle_control_object;
    if (dwg_dynapi_header_value (dwg, "DIMSTYLE_CONTROL_OBJECT", &dimstyle_control_object, NULL)
        && !memcmp (&dimstyle_control_object, &dwg->header_vars.DIMSTYLE_CONTROL_OBJECT, sizeof (dwg->header_vars.DIMSTYLE_CONTROL_OBJECT))
       )
      {
        pass ("HEADER.DIMSTYLE_CONTROL_OBJECT [H]");
      }
    else
      {
        fail ("HEADER.DIMSTYLE_CONTROL_OBJECT [H]");
        error++;
      }
  }
  {
    BITCODE_H vport_entity_control_object;
    if (dwg_dynapi_header_value (dwg, "VPORT_ENTITY_CONTROL_OBJECT", &vport_entity_control_object, NULL)
        && !memcmp (&vport_entity_control_object, &dwg->header_vars.VPORT_ENTITY_CONTROL_OBJECT, sizeof (dwg->header_vars.VPORT_ENTITY_CONTROL_OBJECT))
       )
      {
        pass ("HEADER.VPORT_ENTITY_CONTROL_OBJECT [H]");
      }
    else
      {
        fail ("HEADER.VPORT_ENTITY_CONTROL_OBJECT [H]");
        error++;
      }
  }
  {
    BITCODE_H dictionary_acad_group;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_ACAD_GROUP", &dictionary_acad_group, NULL)
        && !memcmp (&dictionary_acad_group, &dwg->header_vars.DICTIONARY_ACAD_GROUP, sizeof (dwg->header_vars.DICTIONARY_ACAD_GROUP))
       )
      {
        pass ("HEADER.DICTIONARY_ACAD_GROUP [H]");
      }
    else
      {
        fail ("HEADER.DICTIONARY_ACAD_GROUP [H]");
        error++;
      }
  }
  {
    BITCODE_H dictionary_acad_mlinestyle;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_ACAD_MLINESTYLE", &dictionary_acad_mlinestyle, NULL)
        && !memcmp (&dictionary_acad_mlinestyle, &dwg->header_vars.DICTIONARY_ACAD_MLINESTYLE, sizeof (dwg->header_vars.DICTIONARY_ACAD_MLINESTYLE))
       )
      {
        pass ("HEADER.DICTIONARY_ACAD_MLINESTYLE [H]");
      }
    else
      {
        fail ("HEADER.DICTIONARY_ACAD_MLINESTYLE [H]");
        error++;
      }
  }
  {
    BITCODE_H dictionary_named_objects;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_NAMED_OBJECTS", &dictionary_named_objects, NULL)
        && !memcmp (&dictionary_named_objects, &dwg->header_vars.DICTIONARY_NAMED_OBJECTS, sizeof (dwg->header_vars.DICTIONARY_NAMED_OBJECTS))
       )
      {
        pass ("HEADER.DICTIONARY_NAMED_OBJECTS [H]");
      }
    else
      {
        fail ("HEADER.DICTIONARY_NAMED_OBJECTS [H]");
        error++;
      }
  }
  {
    BITCODE_BS tstackalign;
    if (dwg_dynapi_header_value (dwg, "TSTACKALIGN", &tstackalign, NULL)
        && tstackalign == dwg->header_vars.TSTACKALIGN)
      {
        pass ("HEADER.TSTACKALIGN [BS] %hu", tstackalign);
      }
    else
      {
        fail ("HEADER.TSTACKALIGN [BS] %hu != %hu", dwg->header_vars.TSTACKALIGN, tstackalign);
        error++;
      }
    tstackalign++;
    if (dwg_dynapi_header_set_value (dwg, "TSTACKALIGN", &tstackalign)
        && tstackalign == dwg->header_vars.TSTACKALIGN)
      {
        pass ("HEADER.TSTACKALIGN [BS] set+1 %hu", tstackalign);
      }
    else
      {
        fail ("HEADER.TSTACKALIGN [BS] set+1 %hu != %hu",
              dwg->header_vars.TSTACKALIGN, tstackalign);
        error++;
      }
    tstackalign--;
    dwg_dynapi_header_set_value (dwg, "TSTACKALIGN", &tstackalign);

  }
  {
    BITCODE_BS tstacksize;
    if (dwg_dynapi_header_value (dwg, "TSTACKSIZE", &tstacksize, NULL)
        && tstacksize == dwg->header_vars.TSTACKSIZE)
      {
        pass ("HEADER.TSTACKSIZE [BS] %hu", tstacksize);
      }
    else
      {
        fail ("HEADER.TSTACKSIZE [BS] %hu != %hu", dwg->header_vars.TSTACKSIZE, tstacksize);
        error++;
      }
    tstacksize++;
    if (dwg_dynapi_header_set_value (dwg, "TSTACKSIZE", &tstacksize)
        && tstacksize == dwg->header_vars.TSTACKSIZE)
      {
        pass ("HEADER.TSTACKSIZE [BS] set+1 %hu", tstacksize);
      }
    else
      {
        fail ("HEADER.TSTACKSIZE [BS] set+1 %hu != %hu",
              dwg->header_vars.TSTACKSIZE, tstacksize);
        error++;
      }
    tstacksize--;
    dwg_dynapi_header_set_value (dwg, "TSTACKSIZE", &tstacksize);

  }
  {
    BITCODE_TV hyperlinkbase;
    if (dwg_dynapi_header_value (dwg, "HYPERLINKBASE", &hyperlinkbase, NULL)
        && !memcmp (&hyperlinkbase, &dwg->header_vars.HYPERLINKBASE, sizeof (dwg->header_vars.HYPERLINKBASE))
       )
      {
        pass ("HEADER.HYPERLINKBASE [TV]");
      }
    else
      {
        fail ("HEADER.HYPERLINKBASE [TV]");
        error++;
      }
  }
  {
    BITCODE_TV stylesheet;
    if (dwg_dynapi_header_value (dwg, "STYLESHEET", &stylesheet, NULL)
        && !memcmp (&stylesheet, &dwg->header_vars.STYLESHEET, sizeof (dwg->header_vars.STYLESHEET))
       )
      {
        pass ("HEADER.STYLESHEET [TV]");
      }
    else
      {
        fail ("HEADER.STYLESHEET [TV]");
        error++;
      }
  }
  {
    BITCODE_H dictionary_layouts;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_LAYOUTS", &dictionary_layouts, NULL)
        && !memcmp (&dictionary_layouts, &dwg->header_vars.DICTIONARY_LAYOUTS, sizeof (dwg->header_vars.DICTIONARY_LAYOUTS))
       )
      {
        pass ("HEADER.DICTIONARY_LAYOUTS [H]");
      }
    else
      {
        fail ("HEADER.DICTIONARY_LAYOUTS [H]");
        error++;
      }
  }
  {
    BITCODE_H dictionary_plotsettings;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_PLOTSETTINGS", &dictionary_plotsettings, NULL)
        && !memcmp (&dictionary_plotsettings, &dwg->header_vars.DICTIONARY_PLOTSETTINGS, sizeof (dwg->header_vars.DICTIONARY_PLOTSETTINGS))
       )
      {
        pass ("HEADER.DICTIONARY_PLOTSETTINGS [H]");
      }
    else
      {
        fail ("HEADER.DICTIONARY_PLOTSETTINGS [H]");
        error++;
      }
  }
  {
    BITCODE_H dictionary_plotstyles;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_PLOTSTYLES", &dictionary_plotstyles, NULL)
        && !memcmp (&dictionary_plotstyles, &dwg->header_vars.DICTIONARY_PLOTSTYLES, sizeof (dwg->header_vars.DICTIONARY_PLOTSTYLES))
       )
      {
        pass ("HEADER.DICTIONARY_PLOTSTYLES [H]");
      }
    else
      {
        fail ("HEADER.DICTIONARY_PLOTSTYLES [H]");
        error++;
      }
  }
  {
    BITCODE_H dictionary_materials;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_MATERIALS", &dictionary_materials, NULL)
        && !memcmp (&dictionary_materials, &dwg->header_vars.DICTIONARY_MATERIALS, sizeof (dwg->header_vars.DICTIONARY_MATERIALS))
       )
      {
        pass ("HEADER.DICTIONARY_MATERIALS [H]");
      }
    else
      {
        fail ("HEADER.DICTIONARY_MATERIALS [H]");
        error++;
      }
  }
  {
    BITCODE_H dictionary_colors;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_COLORS", &dictionary_colors, NULL)
        && !memcmp (&dictionary_colors, &dwg->header_vars.DICTIONARY_COLORS, sizeof (dwg->header_vars.DICTIONARY_COLORS))
       )
      {
        pass ("HEADER.DICTIONARY_COLORS [H]");
      }
    else
      {
        fail ("HEADER.DICTIONARY_COLORS [H]");
        error++;
      }
  }
  {
    BITCODE_H dictionary_visualstyle;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_VISUALSTYLE", &dictionary_visualstyle, NULL)
        && !memcmp (&dictionary_visualstyle, &dwg->header_vars.DICTIONARY_VISUALSTYLE, sizeof (dwg->header_vars.DICTIONARY_VISUALSTYLE))
       )
      {
        pass ("HEADER.DICTIONARY_VISUALSTYLE [H]");
      }
    else
      {
        fail ("HEADER.DICTIONARY_VISUALSTYLE [H]");
        error++;
      }
  }
  {
    BITCODE_H dictionary_lightlist;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_LIGHTLIST", &dictionary_lightlist, NULL)
        && !memcmp (&dictionary_lightlist, &dwg->header_vars.DICTIONARY_LIGHTLIST, sizeof (dwg->header_vars.DICTIONARY_LIGHTLIST))
       )
      {
        pass ("HEADER.DICTIONARY_LIGHTLIST [H]");
      }
    else
      {
        fail ("HEADER.DICTIONARY_LIGHTLIST [H]");
        error++;
      }
  }
  {
    BITCODE_H unknown_20;
    if (dwg_dynapi_header_value (dwg, "unknown_20", &unknown_20, NULL)
        && !memcmp (&unknown_20, &dwg->header_vars.unknown_20, sizeof (dwg->header_vars.unknown_20))
       )
      {
        pass ("HEADER.unknown_20 [H]");
      }
    else
      {
        fail ("HEADER.unknown_20 [H]");
        error++;
      }
  }
  {
    BITCODE_BL flags;
    if (dwg_dynapi_header_value (dwg, "FLAGS", &flags, NULL)
        && flags == dwg->header_vars.FLAGS)
      {
        pass ("HEADER.FLAGS [BL] %u", flags);
      }
    else
      {
        fail ("HEADER.FLAGS [BL] %u != %u", dwg->header_vars.FLAGS, flags);
        error++;
      }
    flags++;
    if (dwg_dynapi_header_set_value (dwg, "FLAGS", &flags)
        && flags == dwg->header_vars.FLAGS)
      {
        pass ("HEADER.FLAGS [BL] set+1 %u", flags);
      }
    else
      {
        fail ("HEADER.FLAGS [BL] set+1 %u != %u",
              dwg->header_vars.FLAGS, flags);
        error++;
      }
    flags--;
    dwg_dynapi_header_set_value (dwg, "FLAGS", &flags);

  }
  {
    BITCODE_RC celweight;
    if (dwg_dynapi_header_value (dwg, "CELWEIGHT", &celweight, NULL)
        && celweight == dwg->header_vars.CELWEIGHT)
      {
        pass ("HEADER.CELWEIGHT [RC] %u", celweight);
      }
    else
      {
        fail ("HEADER.CELWEIGHT [RC] %u != %u", dwg->header_vars.CELWEIGHT, celweight);
        error++;
      }
    celweight++;
    if (dwg_dynapi_header_set_value (dwg, "CELWEIGHT", &celweight)
        && celweight == dwg->header_vars.CELWEIGHT)
      {
        pass ("HEADER.CELWEIGHT [RC] set+1 %u", celweight);
      }
    else
      {
        fail ("HEADER.CELWEIGHT [RC] set+1 %u != %u",
              dwg->header_vars.CELWEIGHT, celweight);
        error++;
      }
    celweight--;
    dwg_dynapi_header_set_value (dwg, "CELWEIGHT", &celweight);

  }
  {
    BITCODE_B endcaps;
    if (dwg_dynapi_header_value (dwg, "ENDCAPS", &endcaps, NULL)
        && endcaps == dwg->header_vars.ENDCAPS)
      {
        pass ("HEADER.ENDCAPS [B] " FORMAT_B "", endcaps);
      }
    else
      {
        fail ("HEADER.ENDCAPS [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.ENDCAPS, endcaps);
        error++;
      }
    endcaps++;
    if (dwg_dynapi_header_set_value (dwg, "ENDCAPS", &endcaps)
        && endcaps == dwg->header_vars.ENDCAPS)
      {
        pass ("HEADER.ENDCAPS [B] set+1 " FORMAT_B "", endcaps);
      }
    else
      {
        fail ("HEADER.ENDCAPS [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.ENDCAPS, endcaps);
        error++;
      }
    endcaps--;
    dwg_dynapi_header_set_value (dwg, "ENDCAPS", &endcaps);

  }
  {
    BITCODE_B joinstyle;
    if (dwg_dynapi_header_value (dwg, "JOINSTYLE", &joinstyle, NULL)
        && joinstyle == dwg->header_vars.JOINSTYLE)
      {
        pass ("HEADER.JOINSTYLE [B] " FORMAT_B "", joinstyle);
      }
    else
      {
        fail ("HEADER.JOINSTYLE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.JOINSTYLE, joinstyle);
        error++;
      }
    joinstyle++;
    if (dwg_dynapi_header_set_value (dwg, "JOINSTYLE", &joinstyle)
        && joinstyle == dwg->header_vars.JOINSTYLE)
      {
        pass ("HEADER.JOINSTYLE [B] set+1 " FORMAT_B "", joinstyle);
      }
    else
      {
        fail ("HEADER.JOINSTYLE [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.JOINSTYLE, joinstyle);
        error++;
      }
    joinstyle--;
    dwg_dynapi_header_set_value (dwg, "JOINSTYLE", &joinstyle);

  }
  {
    BITCODE_B lwdisplay;
    if (dwg_dynapi_header_value (dwg, "LWDISPLAY", &lwdisplay, NULL)
        && lwdisplay == dwg->header_vars.LWDISPLAY)
      {
        pass ("HEADER.LWDISPLAY [B] " FORMAT_B "", lwdisplay);
      }
    else
      {
        fail ("HEADER.LWDISPLAY [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.LWDISPLAY, lwdisplay);
        error++;
      }
    lwdisplay++;
    if (dwg_dynapi_header_set_value (dwg, "LWDISPLAY", &lwdisplay)
        && lwdisplay == dwg->header_vars.LWDISPLAY)
      {
        pass ("HEADER.LWDISPLAY [B] set+1 " FORMAT_B "", lwdisplay);
      }
    else
      {
        fail ("HEADER.LWDISPLAY [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.LWDISPLAY, lwdisplay);
        error++;
      }
    lwdisplay--;
    dwg_dynapi_header_set_value (dwg, "LWDISPLAY", &lwdisplay);

  }
  {
    BITCODE_B xedit;
    if (dwg_dynapi_header_value (dwg, "XEDIT", &xedit, NULL)
        && xedit == dwg->header_vars.XEDIT)
      {
        pass ("HEADER.XEDIT [B] " FORMAT_B "", xedit);
      }
    else
      {
        fail ("HEADER.XEDIT [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.XEDIT, xedit);
        error++;
      }
    xedit++;
    if (dwg_dynapi_header_set_value (dwg, "XEDIT", &xedit)
        && xedit == dwg->header_vars.XEDIT)
      {
        pass ("HEADER.XEDIT [B] set+1 " FORMAT_B "", xedit);
      }
    else
      {
        fail ("HEADER.XEDIT [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.XEDIT, xedit);
        error++;
      }
    xedit--;
    dwg_dynapi_header_set_value (dwg, "XEDIT", &xedit);

  }
  {
    BITCODE_B extnames;
    if (dwg_dynapi_header_value (dwg, "EXTNAMES", &extnames, NULL)
        && extnames == dwg->header_vars.EXTNAMES)
      {
        pass ("HEADER.EXTNAMES [B] " FORMAT_B "", extnames);
      }
    else
      {
        fail ("HEADER.EXTNAMES [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.EXTNAMES, extnames);
        error++;
      }
    extnames++;
    if (dwg_dynapi_header_set_value (dwg, "EXTNAMES", &extnames)
        && extnames == dwg->header_vars.EXTNAMES)
      {
        pass ("HEADER.EXTNAMES [B] set+1 " FORMAT_B "", extnames);
      }
    else
      {
        fail ("HEADER.EXTNAMES [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.EXTNAMES, extnames);
        error++;
      }
    extnames--;
    dwg_dynapi_header_set_value (dwg, "EXTNAMES", &extnames);

  }
  {
    BITCODE_B pstylemode;
    if (dwg_dynapi_header_value (dwg, "PSTYLEMODE", &pstylemode, NULL)
        && pstylemode == dwg->header_vars.PSTYLEMODE)
      {
        pass ("HEADER.PSTYLEMODE [B] " FORMAT_B "", pstylemode);
      }
    else
      {
        fail ("HEADER.PSTYLEMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.PSTYLEMODE, pstylemode);
        error++;
      }
    pstylemode++;
    if (dwg_dynapi_header_set_value (dwg, "PSTYLEMODE", &pstylemode)
        && pstylemode == dwg->header_vars.PSTYLEMODE)
      {
        pass ("HEADER.PSTYLEMODE [B] set+1 " FORMAT_B "", pstylemode);
      }
    else
      {
        fail ("HEADER.PSTYLEMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.PSTYLEMODE, pstylemode);
        error++;
      }
    pstylemode--;
    dwg_dynapi_header_set_value (dwg, "PSTYLEMODE", &pstylemode);

  }
  {
    BITCODE_B olestartup;
    if (dwg_dynapi_header_value (dwg, "OLESTARTUP", &olestartup, NULL)
        && olestartup == dwg->header_vars.OLESTARTUP)
      {
        pass ("HEADER.OLESTARTUP [B] " FORMAT_B "", olestartup);
      }
    else
      {
        fail ("HEADER.OLESTARTUP [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.OLESTARTUP, olestartup);
        error++;
      }
    olestartup++;
    if (dwg_dynapi_header_set_value (dwg, "OLESTARTUP", &olestartup)
        && olestartup == dwg->header_vars.OLESTARTUP)
      {
        pass ("HEADER.OLESTARTUP [B] set+1 " FORMAT_B "", olestartup);
      }
    else
      {
        fail ("HEADER.OLESTARTUP [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.OLESTARTUP, olestartup);
        error++;
      }
    olestartup--;
    dwg_dynapi_header_set_value (dwg, "OLESTARTUP", &olestartup);

  }
  {
    BITCODE_BS insunits;
    if (dwg_dynapi_header_value (dwg, "INSUNITS", &insunits, NULL)
        && insunits == dwg->header_vars.INSUNITS)
      {
        pass ("HEADER.INSUNITS [BS] %hu", insunits);
      }
    else
      {
        fail ("HEADER.INSUNITS [BS] %hu != %hu", dwg->header_vars.INSUNITS, insunits);
        error++;
      }
    insunits++;
    if (dwg_dynapi_header_set_value (dwg, "INSUNITS", &insunits)
        && insunits == dwg->header_vars.INSUNITS)
      {
        pass ("HEADER.INSUNITS [BS] set+1 %hu", insunits);
      }
    else
      {
        fail ("HEADER.INSUNITS [BS] set+1 %hu != %hu",
              dwg->header_vars.INSUNITS, insunits);
        error++;
      }
    insunits--;
    dwg_dynapi_header_set_value (dwg, "INSUNITS", &insunits);

  }
  {
    BITCODE_BS cepsntype;
    if (dwg_dynapi_header_value (dwg, "CEPSNTYPE", &cepsntype, NULL)
        && cepsntype == dwg->header_vars.CEPSNTYPE)
      {
        pass ("HEADER.CEPSNTYPE [BS] %hu", cepsntype);
      }
    else
      {
        fail ("HEADER.CEPSNTYPE [BS] %hu != %hu", dwg->header_vars.CEPSNTYPE, cepsntype);
        error++;
      }
    cepsntype++;
    if (dwg_dynapi_header_set_value (dwg, "CEPSNTYPE", &cepsntype)
        && cepsntype == dwg->header_vars.CEPSNTYPE)
      {
        pass ("HEADER.CEPSNTYPE [BS] set+1 %hu", cepsntype);
      }
    else
      {
        fail ("HEADER.CEPSNTYPE [BS] set+1 %hu != %hu",
              dwg->header_vars.CEPSNTYPE, cepsntype);
        error++;
      }
    cepsntype--;
    dwg_dynapi_header_set_value (dwg, "CEPSNTYPE", &cepsntype);

  }
  {
    BITCODE_H cpsnid;
    if (dwg_dynapi_header_value (dwg, "CPSNID", &cpsnid, NULL)
        && !memcmp (&cpsnid, &dwg->header_vars.CPSNID, sizeof (dwg->header_vars.CPSNID))
       )
      {
        pass ("HEADER.CPSNID [H]");
      }
    else
      {
        fail ("HEADER.CPSNID [H]");
        error++;
      }
  }
  {
    BITCODE_TV fingerprintguid;
    if (dwg_dynapi_header_value (dwg, "FINGERPRINTGUID", &fingerprintguid, NULL)
        && !memcmp (&fingerprintguid, &dwg->header_vars.FINGERPRINTGUID, sizeof (dwg->header_vars.FINGERPRINTGUID))
       )
      {
        pass ("HEADER.FINGERPRINTGUID [TV]");
      }
    else
      {
        fail ("HEADER.FINGERPRINTGUID [TV]");
        error++;
      }
  }
  {
    BITCODE_TV versionguid;
    if (dwg_dynapi_header_value (dwg, "VERSIONGUID", &versionguid, NULL)
        && !memcmp (&versionguid, &dwg->header_vars.VERSIONGUID, sizeof (dwg->header_vars.VERSIONGUID))
       )
      {
        pass ("HEADER.VERSIONGUID [TV]");
      }
    else
      {
        fail ("HEADER.VERSIONGUID [TV]");
        error++;
      }
  }
  {
    BITCODE_RC sortents;
    if (dwg_dynapi_header_value (dwg, "SORTENTS", &sortents, NULL)
        && sortents == dwg->header_vars.SORTENTS)
      {
        pass ("HEADER.SORTENTS [RC] %u", sortents);
      }
    else
      {
        fail ("HEADER.SORTENTS [RC] %u != %u", dwg->header_vars.SORTENTS, sortents);
        error++;
      }
    sortents++;
    if (dwg_dynapi_header_set_value (dwg, "SORTENTS", &sortents)
        && sortents == dwg->header_vars.SORTENTS)
      {
        pass ("HEADER.SORTENTS [RC] set+1 %u", sortents);
      }
    else
      {
        fail ("HEADER.SORTENTS [RC] set+1 %u != %u",
              dwg->header_vars.SORTENTS, sortents);
        error++;
      }
    sortents--;
    dwg_dynapi_header_set_value (dwg, "SORTENTS", &sortents);

  }
  {
    BITCODE_RC indexctl;
    if (dwg_dynapi_header_value (dwg, "INDEXCTL", &indexctl, NULL)
        && indexctl == dwg->header_vars.INDEXCTL)
      {
        pass ("HEADER.INDEXCTL [RC] %u", indexctl);
      }
    else
      {
        fail ("HEADER.INDEXCTL [RC] %u != %u", dwg->header_vars.INDEXCTL, indexctl);
        error++;
      }
    indexctl++;
    if (dwg_dynapi_header_set_value (dwg, "INDEXCTL", &indexctl)
        && indexctl == dwg->header_vars.INDEXCTL)
      {
        pass ("HEADER.INDEXCTL [RC] set+1 %u", indexctl);
      }
    else
      {
        fail ("HEADER.INDEXCTL [RC] set+1 %u != %u",
              dwg->header_vars.INDEXCTL, indexctl);
        error++;
      }
    indexctl--;
    dwg_dynapi_header_set_value (dwg, "INDEXCTL", &indexctl);

  }
  {
    BITCODE_RC hidetext;
    if (dwg_dynapi_header_value (dwg, "HIDETEXT", &hidetext, NULL)
        && hidetext == dwg->header_vars.HIDETEXT)
      {
        pass ("HEADER.HIDETEXT [RC] %u", hidetext);
      }
    else
      {
        fail ("HEADER.HIDETEXT [RC] %u != %u", dwg->header_vars.HIDETEXT, hidetext);
        error++;
      }
    hidetext++;
    if (dwg_dynapi_header_set_value (dwg, "HIDETEXT", &hidetext)
        && hidetext == dwg->header_vars.HIDETEXT)
      {
        pass ("HEADER.HIDETEXT [RC] set+1 %u", hidetext);
      }
    else
      {
        fail ("HEADER.HIDETEXT [RC] set+1 %u != %u",
              dwg->header_vars.HIDETEXT, hidetext);
        error++;
      }
    hidetext--;
    dwg_dynapi_header_set_value (dwg, "HIDETEXT", &hidetext);

  }
  {
    BITCODE_RC xclipframe;
    if (dwg_dynapi_header_value (dwg, "XCLIPFRAME", &xclipframe, NULL)
        && xclipframe == dwg->header_vars.XCLIPFRAME)
      {
        pass ("HEADER.XCLIPFRAME [RC] %u", xclipframe);
      }
    else
      {
        fail ("HEADER.XCLIPFRAME [RC] %u != %u", dwg->header_vars.XCLIPFRAME, xclipframe);
        error++;
      }
    xclipframe++;
    if (dwg_dynapi_header_set_value (dwg, "XCLIPFRAME", &xclipframe)
        && xclipframe == dwg->header_vars.XCLIPFRAME)
      {
        pass ("HEADER.XCLIPFRAME [RC] set+1 %u", xclipframe);
      }
    else
      {
        fail ("HEADER.XCLIPFRAME [RC] set+1 %u != %u",
              dwg->header_vars.XCLIPFRAME, xclipframe);
        error++;
      }
    xclipframe--;
    dwg_dynapi_header_set_value (dwg, "XCLIPFRAME", &xclipframe);

  }
  {
    BITCODE_RC dimassoc;
    if (dwg_dynapi_header_value (dwg, "DIMASSOC", &dimassoc, NULL)
        && dimassoc == dwg->header_vars.DIMASSOC)
      {
        pass ("HEADER.DIMASSOC [RC] %u", dimassoc);
      }
    else
      {
        fail ("HEADER.DIMASSOC [RC] %u != %u", dwg->header_vars.DIMASSOC, dimassoc);
        error++;
      }
    dimassoc++;
    if (dwg_dynapi_header_set_value (dwg, "DIMASSOC", &dimassoc)
        && dimassoc == dwg->header_vars.DIMASSOC)
      {
        pass ("HEADER.DIMASSOC [RC] set+1 %u", dimassoc);
      }
    else
      {
        fail ("HEADER.DIMASSOC [RC] set+1 %u != %u",
              dwg->header_vars.DIMASSOC, dimassoc);
        error++;
      }
    dimassoc--;
    dwg_dynapi_header_set_value (dwg, "DIMASSOC", &dimassoc);

  }
  {
    BITCODE_RC halogap;
    if (dwg_dynapi_header_value (dwg, "HALOGAP", &halogap, NULL)
        && halogap == dwg->header_vars.HALOGAP)
      {
        pass ("HEADER.HALOGAP [RC] %u", halogap);
      }
    else
      {
        fail ("HEADER.HALOGAP [RC] %u != %u", dwg->header_vars.HALOGAP, halogap);
        error++;
      }
    halogap++;
    if (dwg_dynapi_header_set_value (dwg, "HALOGAP", &halogap)
        && halogap == dwg->header_vars.HALOGAP)
      {
        pass ("HEADER.HALOGAP [RC] set+1 %u", halogap);
      }
    else
      {
        fail ("HEADER.HALOGAP [RC] set+1 %u != %u",
              dwg->header_vars.HALOGAP, halogap);
        error++;
      }
    halogap--;
    dwg_dynapi_header_set_value (dwg, "HALOGAP", &halogap);

  }
  {
    BITCODE_BS obscolor;
    if (dwg_dynapi_header_value (dwg, "OBSCOLOR", &obscolor, NULL)
        && obscolor == dwg->header_vars.OBSCOLOR)
      {
        pass ("HEADER.OBSCOLOR [BS] %hu", obscolor);
      }
    else
      {
        fail ("HEADER.OBSCOLOR [BS] %hu != %hu", dwg->header_vars.OBSCOLOR, obscolor);
        error++;
      }
    obscolor++;
    if (dwg_dynapi_header_set_value (dwg, "OBSCOLOR", &obscolor)
        && obscolor == dwg->header_vars.OBSCOLOR)
      {
        pass ("HEADER.OBSCOLOR [BS] set+1 %hu", obscolor);
      }
    else
      {
        fail ("HEADER.OBSCOLOR [BS] set+1 %hu != %hu",
              dwg->header_vars.OBSCOLOR, obscolor);
        error++;
      }
    obscolor--;
    dwg_dynapi_header_set_value (dwg, "OBSCOLOR", &obscolor);

  }
  {
    BITCODE_BS intersectioncolor;
    if (dwg_dynapi_header_value (dwg, "INTERSECTIONCOLOR", &intersectioncolor, NULL)
        && intersectioncolor == dwg->header_vars.INTERSECTIONCOLOR)
      {
        pass ("HEADER.INTERSECTIONCOLOR [BS] %hu", intersectioncolor);
      }
    else
      {
        fail ("HEADER.INTERSECTIONCOLOR [BS] %hu != %hu", dwg->header_vars.INTERSECTIONCOLOR, intersectioncolor);
        error++;
      }
    intersectioncolor++;
    if (dwg_dynapi_header_set_value (dwg, "INTERSECTIONCOLOR", &intersectioncolor)
        && intersectioncolor == dwg->header_vars.INTERSECTIONCOLOR)
      {
        pass ("HEADER.INTERSECTIONCOLOR [BS] set+1 %hu", intersectioncolor);
      }
    else
      {
        fail ("HEADER.INTERSECTIONCOLOR [BS] set+1 %hu != %hu",
              dwg->header_vars.INTERSECTIONCOLOR, intersectioncolor);
        error++;
      }
    intersectioncolor--;
    dwg_dynapi_header_set_value (dwg, "INTERSECTIONCOLOR", &intersectioncolor);

  }
  {
    BITCODE_RC obsltype;
    if (dwg_dynapi_header_value (dwg, "OBSLTYPE", &obsltype, NULL)
        && obsltype == dwg->header_vars.OBSLTYPE)
      {
        pass ("HEADER.OBSLTYPE [RC] %u", obsltype);
      }
    else
      {
        fail ("HEADER.OBSLTYPE [RC] %u != %u", dwg->header_vars.OBSLTYPE, obsltype);
        error++;
      }
    obsltype++;
    if (dwg_dynapi_header_set_value (dwg, "OBSLTYPE", &obsltype)
        && obsltype == dwg->header_vars.OBSLTYPE)
      {
        pass ("HEADER.OBSLTYPE [RC] set+1 %u", obsltype);
      }
    else
      {
        fail ("HEADER.OBSLTYPE [RC] set+1 %u != %u",
              dwg->header_vars.OBSLTYPE, obsltype);
        error++;
      }
    obsltype--;
    dwg_dynapi_header_set_value (dwg, "OBSLTYPE", &obsltype);

  }
  {
    BITCODE_RC intersectiondisplay;
    if (dwg_dynapi_header_value (dwg, "INTERSECTIONDISPLAY", &intersectiondisplay, NULL)
        && intersectiondisplay == dwg->header_vars.INTERSECTIONDISPLAY)
      {
        pass ("HEADER.INTERSECTIONDISPLAY [RC] %u", intersectiondisplay);
      }
    else
      {
        fail ("HEADER.INTERSECTIONDISPLAY [RC] %u != %u", dwg->header_vars.INTERSECTIONDISPLAY, intersectiondisplay);
        error++;
      }
    intersectiondisplay++;
    if (dwg_dynapi_header_set_value (dwg, "INTERSECTIONDISPLAY", &intersectiondisplay)
        && intersectiondisplay == dwg->header_vars.INTERSECTIONDISPLAY)
      {
        pass ("HEADER.INTERSECTIONDISPLAY [RC] set+1 %u", intersectiondisplay);
      }
    else
      {
        fail ("HEADER.INTERSECTIONDISPLAY [RC] set+1 %u != %u",
              dwg->header_vars.INTERSECTIONDISPLAY, intersectiondisplay);
        error++;
      }
    intersectiondisplay--;
    dwg_dynapi_header_set_value (dwg, "INTERSECTIONDISPLAY", &intersectiondisplay);

  }
  {
    BITCODE_TV projectname;
    if (dwg_dynapi_header_value (dwg, "PROJECTNAME", &projectname, NULL)
        && !memcmp (&projectname, &dwg->header_vars.PROJECTNAME, sizeof (dwg->header_vars.PROJECTNAME))
       )
      {
        pass ("HEADER.PROJECTNAME [TV]");
      }
    else
      {
        fail ("HEADER.PROJECTNAME [TV]");
        error++;
      }
  }
  {
    BITCODE_H block_record_pspace;
    if (dwg_dynapi_header_value (dwg, "BLOCK_RECORD_PSPACE", &block_record_pspace, NULL)
        && !memcmp (&block_record_pspace, &dwg->header_vars.BLOCK_RECORD_PSPACE, sizeof (dwg->header_vars.BLOCK_RECORD_PSPACE))
       )
      {
        pass ("HEADER.BLOCK_RECORD_PSPACE [H]");
      }
    else
      {
        fail ("HEADER.BLOCK_RECORD_PSPACE [H]");
        error++;
      }
  }
  {
    BITCODE_H block_record_mspace;
    if (dwg_dynapi_header_value (dwg, "BLOCK_RECORD_MSPACE", &block_record_mspace, NULL)
        && !memcmp (&block_record_mspace, &dwg->header_vars.BLOCK_RECORD_MSPACE, sizeof (dwg->header_vars.BLOCK_RECORD_MSPACE))
       )
      {
        pass ("HEADER.BLOCK_RECORD_MSPACE [H]");
      }
    else
      {
        fail ("HEADER.BLOCK_RECORD_MSPACE [H]");
        error++;
      }
  }
  {
    BITCODE_H ltype_bylayer;
    if (dwg_dynapi_header_value (dwg, "LTYPE_BYLAYER", &ltype_bylayer, NULL)
        && !memcmp (&ltype_bylayer, &dwg->header_vars.LTYPE_BYLAYER, sizeof (dwg->header_vars.LTYPE_BYLAYER))
       )
      {
        pass ("HEADER.LTYPE_BYLAYER [H]");
      }
    else
      {
        fail ("HEADER.LTYPE_BYLAYER [H]");
        error++;
      }
  }
  {
    BITCODE_H ltype_byblock;
    if (dwg_dynapi_header_value (dwg, "LTYPE_BYBLOCK", &ltype_byblock, NULL)
        && !memcmp (&ltype_byblock, &dwg->header_vars.LTYPE_BYBLOCK, sizeof (dwg->header_vars.LTYPE_BYBLOCK))
       )
      {
        pass ("HEADER.LTYPE_BYBLOCK [H]");
      }
    else
      {
        fail ("HEADER.LTYPE_BYBLOCK [H]");
        error++;
      }
  }
  {
    BITCODE_H ltype_continuous;
    if (dwg_dynapi_header_value (dwg, "LTYPE_CONTINUOUS", &ltype_continuous, NULL)
        && !memcmp (&ltype_continuous, &dwg->header_vars.LTYPE_CONTINUOUS, sizeof (dwg->header_vars.LTYPE_CONTINUOUS))
       )
      {
        pass ("HEADER.LTYPE_CONTINUOUS [H]");
      }
    else
      {
        fail ("HEADER.LTYPE_CONTINUOUS [H]");
        error++;
      }
  }
  {
    BITCODE_B cameradisplay;
    if (dwg_dynapi_header_value (dwg, "CAMERADISPLAY", &cameradisplay, NULL)
        && cameradisplay == dwg->header_vars.CAMERADISPLAY)
      {
        pass ("HEADER.CAMERADISPLAY [B] " FORMAT_B "", cameradisplay);
      }
    else
      {
        fail ("HEADER.CAMERADISPLAY [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.CAMERADISPLAY, cameradisplay);
        error++;
      }
    cameradisplay++;
    if (dwg_dynapi_header_set_value (dwg, "CAMERADISPLAY", &cameradisplay)
        && cameradisplay == dwg->header_vars.CAMERADISPLAY)
      {
        pass ("HEADER.CAMERADISPLAY [B] set+1 " FORMAT_B "", cameradisplay);
      }
    else
      {
        fail ("HEADER.CAMERADISPLAY [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.CAMERADISPLAY, cameradisplay);
        error++;
      }
    cameradisplay--;
    dwg_dynapi_header_set_value (dwg, "CAMERADISPLAY", &cameradisplay);

  }
  {
    BITCODE_BL unknown_21;
    if (dwg_dynapi_header_value (dwg, "unknown_21", &unknown_21, NULL)
        && unknown_21 == dwg->header_vars.unknown_21)
      {
        pass ("HEADER.unknown_21 [BL] %u", unknown_21);
      }
    else
      {
        fail ("HEADER.unknown_21 [BL] %u != %u", dwg->header_vars.unknown_21, unknown_21);
        error++;
      }
    unknown_21++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_21", &unknown_21)
        && unknown_21 == dwg->header_vars.unknown_21)
      {
        pass ("HEADER.unknown_21 [BL] set+1 %u", unknown_21);
      }
    else
      {
        fail ("HEADER.unknown_21 [BL] set+1 %u != %u",
              dwg->header_vars.unknown_21, unknown_21);
        error++;
      }
    unknown_21--;
    dwg_dynapi_header_set_value (dwg, "unknown_21", &unknown_21);

  }
  {
    BITCODE_BL unknown_22;
    if (dwg_dynapi_header_value (dwg, "unknown_22", &unknown_22, NULL)
        && unknown_22 == dwg->header_vars.unknown_22)
      {
        pass ("HEADER.unknown_22 [BL] %u", unknown_22);
      }
    else
      {
        fail ("HEADER.unknown_22 [BL] %u != %u", dwg->header_vars.unknown_22, unknown_22);
        error++;
      }
    unknown_22++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_22", &unknown_22)
        && unknown_22 == dwg->header_vars.unknown_22)
      {
        pass ("HEADER.unknown_22 [BL] set+1 %u", unknown_22);
      }
    else
      {
        fail ("HEADER.unknown_22 [BL] set+1 %u != %u",
              dwg->header_vars.unknown_22, unknown_22);
        error++;
      }
    unknown_22--;
    dwg_dynapi_header_set_value (dwg, "unknown_22", &unknown_22);

  }
  {
    BITCODE_BD unknown_23;
    if (dwg_dynapi_header_value (dwg, "unknown_23", &unknown_23, NULL)
        && unknown_23 == dwg->header_vars.unknown_23)
      {
        pass ("HEADER.unknown_23 [BD] %g", unknown_23);
      }
    else
      {
        fail ("HEADER.unknown_23 [BD] %g != %g", dwg->header_vars.unknown_23, unknown_23);
        error++;
      }
    unknown_23++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_23", &unknown_23)
        && unknown_23 == dwg->header_vars.unknown_23)
      {
        pass ("HEADER.unknown_23 [BD] set+1 %g", unknown_23);
      }
    else
      {
        fail ("HEADER.unknown_23 [BD] set+1 %g != %g",
              dwg->header_vars.unknown_23, unknown_23);
        error++;
      }
    unknown_23--;
    dwg_dynapi_header_set_value (dwg, "unknown_23", &unknown_23);

  }
  {
    BITCODE_BD stepspersec;
    if (dwg_dynapi_header_value (dwg, "STEPSPERSEC", &stepspersec, NULL)
        && stepspersec == dwg->header_vars.STEPSPERSEC)
      {
        pass ("HEADER.STEPSPERSEC [BD] %g", stepspersec);
      }
    else
      {
        fail ("HEADER.STEPSPERSEC [BD] %g != %g", dwg->header_vars.STEPSPERSEC, stepspersec);
        error++;
      }
    stepspersec++;
    if (dwg_dynapi_header_set_value (dwg, "STEPSPERSEC", &stepspersec)
        && stepspersec == dwg->header_vars.STEPSPERSEC)
      {
        pass ("HEADER.STEPSPERSEC [BD] set+1 %g", stepspersec);
      }
    else
      {
        fail ("HEADER.STEPSPERSEC [BD] set+1 %g != %g",
              dwg->header_vars.STEPSPERSEC, stepspersec);
        error++;
      }
    stepspersec--;
    dwg_dynapi_header_set_value (dwg, "STEPSPERSEC", &stepspersec);

  }
  {
    BITCODE_BD stepsize;
    if (dwg_dynapi_header_value (dwg, "STEPSIZE", &stepsize, NULL)
        && stepsize == dwg->header_vars.STEPSIZE)
      {
        pass ("HEADER.STEPSIZE [BD] %g", stepsize);
      }
    else
      {
        fail ("HEADER.STEPSIZE [BD] %g != %g", dwg->header_vars.STEPSIZE, stepsize);
        error++;
      }
    stepsize++;
    if (dwg_dynapi_header_set_value (dwg, "STEPSIZE", &stepsize)
        && stepsize == dwg->header_vars.STEPSIZE)
      {
        pass ("HEADER.STEPSIZE [BD] set+1 %g", stepsize);
      }
    else
      {
        fail ("HEADER.STEPSIZE [BD] set+1 %g != %g",
              dwg->header_vars.STEPSIZE, stepsize);
        error++;
      }
    stepsize--;
    dwg_dynapi_header_set_value (dwg, "STEPSIZE", &stepsize);

  }
  {
    BITCODE_BD _3ddwfprec;
    if (dwg_dynapi_header_value (dwg, "_3DDWFPREC", &_3ddwfprec, NULL)
        && _3ddwfprec == dwg->header_vars._3DDWFPREC)
      {
        pass ("HEADER._3DDWFPREC [BD] %g", _3ddwfprec);
      }
    else
      {
        fail ("HEADER._3DDWFPREC [BD] %g != %g", dwg->header_vars._3DDWFPREC, _3ddwfprec);
        error++;
      }
    _3ddwfprec++;
    if (dwg_dynapi_header_set_value (dwg, "_3DDWFPREC", &_3ddwfprec)
        && _3ddwfprec == dwg->header_vars._3DDWFPREC)
      {
        pass ("HEADER._3DDWFPREC [BD] set+1 %g", _3ddwfprec);
      }
    else
      {
        fail ("HEADER._3DDWFPREC [BD] set+1 %g != %g",
              dwg->header_vars._3DDWFPREC, _3ddwfprec);
        error++;
      }
    _3ddwfprec--;
    dwg_dynapi_header_set_value (dwg, "_3DDWFPREC", &_3ddwfprec);

  }
  {
    BITCODE_BD lenslength;
    if (dwg_dynapi_header_value (dwg, "LENSLENGTH", &lenslength, NULL)
        && lenslength == dwg->header_vars.LENSLENGTH)
      {
        pass ("HEADER.LENSLENGTH [BD] %g", lenslength);
      }
    else
      {
        fail ("HEADER.LENSLENGTH [BD] %g != %g", dwg->header_vars.LENSLENGTH, lenslength);
        error++;
      }
    lenslength++;
    if (dwg_dynapi_header_set_value (dwg, "LENSLENGTH", &lenslength)
        && lenslength == dwg->header_vars.LENSLENGTH)
      {
        pass ("HEADER.LENSLENGTH [BD] set+1 %g", lenslength);
      }
    else
      {
        fail ("HEADER.LENSLENGTH [BD] set+1 %g != %g",
              dwg->header_vars.LENSLENGTH, lenslength);
        error++;
      }
    lenslength--;
    dwg_dynapi_header_set_value (dwg, "LENSLENGTH", &lenslength);

  }
  {
    BITCODE_BD cameraheight;
    if (dwg_dynapi_header_value (dwg, "CAMERAHEIGHT", &cameraheight, NULL)
        && cameraheight == dwg->header_vars.CAMERAHEIGHT)
      {
        pass ("HEADER.CAMERAHEIGHT [BD] %g", cameraheight);
      }
    else
      {
        fail ("HEADER.CAMERAHEIGHT [BD] %g != %g", dwg->header_vars.CAMERAHEIGHT, cameraheight);
        error++;
      }
    cameraheight++;
    if (dwg_dynapi_header_set_value (dwg, "CAMERAHEIGHT", &cameraheight)
        && cameraheight == dwg->header_vars.CAMERAHEIGHT)
      {
        pass ("HEADER.CAMERAHEIGHT [BD] set+1 %g", cameraheight);
      }
    else
      {
        fail ("HEADER.CAMERAHEIGHT [BD] set+1 %g != %g",
              dwg->header_vars.CAMERAHEIGHT, cameraheight);
        error++;
      }
    cameraheight--;
    dwg_dynapi_header_set_value (dwg, "CAMERAHEIGHT", &cameraheight);

  }
  {
    BITCODE_RC solidhist;
    if (dwg_dynapi_header_value (dwg, "SOLIDHIST", &solidhist, NULL)
        && solidhist == dwg->header_vars.SOLIDHIST)
      {
        pass ("HEADER.SOLIDHIST [RC] %u", solidhist);
      }
    else
      {
        fail ("HEADER.SOLIDHIST [RC] %u != %u", dwg->header_vars.SOLIDHIST, solidhist);
        error++;
      }
    solidhist++;
    if (dwg_dynapi_header_set_value (dwg, "SOLIDHIST", &solidhist)
        && solidhist == dwg->header_vars.SOLIDHIST)
      {
        pass ("HEADER.SOLIDHIST [RC] set+1 %u", solidhist);
      }
    else
      {
        fail ("HEADER.SOLIDHIST [RC] set+1 %u != %u",
              dwg->header_vars.SOLIDHIST, solidhist);
        error++;
      }
    solidhist--;
    dwg_dynapi_header_set_value (dwg, "SOLIDHIST", &solidhist);

  }
  {
    BITCODE_RC showhist;
    if (dwg_dynapi_header_value (dwg, "SHOWHIST", &showhist, NULL)
        && showhist == dwg->header_vars.SHOWHIST)
      {
        pass ("HEADER.SHOWHIST [RC] %u", showhist);
      }
    else
      {
        fail ("HEADER.SHOWHIST [RC] %u != %u", dwg->header_vars.SHOWHIST, showhist);
        error++;
      }
    showhist++;
    if (dwg_dynapi_header_set_value (dwg, "SHOWHIST", &showhist)
        && showhist == dwg->header_vars.SHOWHIST)
      {
        pass ("HEADER.SHOWHIST [RC] set+1 %u", showhist);
      }
    else
      {
        fail ("HEADER.SHOWHIST [RC] set+1 %u != %u",
              dwg->header_vars.SHOWHIST, showhist);
        error++;
      }
    showhist--;
    dwg_dynapi_header_set_value (dwg, "SHOWHIST", &showhist);

  }
  {
    BITCODE_BD psolwidth;
    if (dwg_dynapi_header_value (dwg, "PSOLWIDTH", &psolwidth, NULL)
        && psolwidth == dwg->header_vars.PSOLWIDTH)
      {
        pass ("HEADER.PSOLWIDTH [BD] %g", psolwidth);
      }
    else
      {
        fail ("HEADER.PSOLWIDTH [BD] %g != %g", dwg->header_vars.PSOLWIDTH, psolwidth);
        error++;
      }
    psolwidth++;
    if (dwg_dynapi_header_set_value (dwg, "PSOLWIDTH", &psolwidth)
        && psolwidth == dwg->header_vars.PSOLWIDTH)
      {
        pass ("HEADER.PSOLWIDTH [BD] set+1 %g", psolwidth);
      }
    else
      {
        fail ("HEADER.PSOLWIDTH [BD] set+1 %g != %g",
              dwg->header_vars.PSOLWIDTH, psolwidth);
        error++;
      }
    psolwidth--;
    dwg_dynapi_header_set_value (dwg, "PSOLWIDTH", &psolwidth);

  }
  {
    BITCODE_BD psolheight;
    if (dwg_dynapi_header_value (dwg, "PSOLHEIGHT", &psolheight, NULL)
        && psolheight == dwg->header_vars.PSOLHEIGHT)
      {
        pass ("HEADER.PSOLHEIGHT [BD] %g", psolheight);
      }
    else
      {
        fail ("HEADER.PSOLHEIGHT [BD] %g != %g", dwg->header_vars.PSOLHEIGHT, psolheight);
        error++;
      }
    psolheight++;
    if (dwg_dynapi_header_set_value (dwg, "PSOLHEIGHT", &psolheight)
        && psolheight == dwg->header_vars.PSOLHEIGHT)
      {
        pass ("HEADER.PSOLHEIGHT [BD] set+1 %g", psolheight);
      }
    else
      {
        fail ("HEADER.PSOLHEIGHT [BD] set+1 %g != %g",
              dwg->header_vars.PSOLHEIGHT, psolheight);
        error++;
      }
    psolheight--;
    dwg_dynapi_header_set_value (dwg, "PSOLHEIGHT", &psolheight);

  }
  {
    BITCODE_BD loftang1;
    if (dwg_dynapi_header_value (dwg, "LOFTANG1", &loftang1, NULL)
        && loftang1 == dwg->header_vars.LOFTANG1)
      {
        pass ("HEADER.LOFTANG1 [BD] %g", loftang1);
      }
    else
      {
        fail ("HEADER.LOFTANG1 [BD] %g != %g", dwg->header_vars.LOFTANG1, loftang1);
        error++;
      }
    loftang1++;
    if (dwg_dynapi_header_set_value (dwg, "LOFTANG1", &loftang1)
        && loftang1 == dwg->header_vars.LOFTANG1)
      {
        pass ("HEADER.LOFTANG1 [BD] set+1 %g", loftang1);
      }
    else
      {
        fail ("HEADER.LOFTANG1 [BD] set+1 %g != %g",
              dwg->header_vars.LOFTANG1, loftang1);
        error++;
      }
    loftang1--;
    dwg_dynapi_header_set_value (dwg, "LOFTANG1", &loftang1);

  }
  {
    BITCODE_BD loftang2;
    if (dwg_dynapi_header_value (dwg, "LOFTANG2", &loftang2, NULL)
        && loftang2 == dwg->header_vars.LOFTANG2)
      {
        pass ("HEADER.LOFTANG2 [BD] %g", loftang2);
      }
    else
      {
        fail ("HEADER.LOFTANG2 [BD] %g != %g", dwg->header_vars.LOFTANG2, loftang2);
        error++;
      }
    loftang2++;
    if (dwg_dynapi_header_set_value (dwg, "LOFTANG2", &loftang2)
        && loftang2 == dwg->header_vars.LOFTANG2)
      {
        pass ("HEADER.LOFTANG2 [BD] set+1 %g", loftang2);
      }
    else
      {
        fail ("HEADER.LOFTANG2 [BD] set+1 %g != %g",
              dwg->header_vars.LOFTANG2, loftang2);
        error++;
      }
    loftang2--;
    dwg_dynapi_header_set_value (dwg, "LOFTANG2", &loftang2);

  }
  {
    BITCODE_BD loftmag1;
    if (dwg_dynapi_header_value (dwg, "LOFTMAG1", &loftmag1, NULL)
        && loftmag1 == dwg->header_vars.LOFTMAG1)
      {
        pass ("HEADER.LOFTMAG1 [BD] %g", loftmag1);
      }
    else
      {
        fail ("HEADER.LOFTMAG1 [BD] %g != %g", dwg->header_vars.LOFTMAG1, loftmag1);
        error++;
      }
    loftmag1++;
    if (dwg_dynapi_header_set_value (dwg, "LOFTMAG1", &loftmag1)
        && loftmag1 == dwg->header_vars.LOFTMAG1)
      {
        pass ("HEADER.LOFTMAG1 [BD] set+1 %g", loftmag1);
      }
    else
      {
        fail ("HEADER.LOFTMAG1 [BD] set+1 %g != %g",
              dwg->header_vars.LOFTMAG1, loftmag1);
        error++;
      }
    loftmag1--;
    dwg_dynapi_header_set_value (dwg, "LOFTMAG1", &loftmag1);

  }
  {
    BITCODE_BD loftmag2;
    if (dwg_dynapi_header_value (dwg, "LOFTMAG2", &loftmag2, NULL)
        && loftmag2 == dwg->header_vars.LOFTMAG2)
      {
        pass ("HEADER.LOFTMAG2 [BD] %g", loftmag2);
      }
    else
      {
        fail ("HEADER.LOFTMAG2 [BD] %g != %g", dwg->header_vars.LOFTMAG2, loftmag2);
        error++;
      }
    loftmag2++;
    if (dwg_dynapi_header_set_value (dwg, "LOFTMAG2", &loftmag2)
        && loftmag2 == dwg->header_vars.LOFTMAG2)
      {
        pass ("HEADER.LOFTMAG2 [BD] set+1 %g", loftmag2);
      }
    else
      {
        fail ("HEADER.LOFTMAG2 [BD] set+1 %g != %g",
              dwg->header_vars.LOFTMAG2, loftmag2);
        error++;
      }
    loftmag2--;
    dwg_dynapi_header_set_value (dwg, "LOFTMAG2", &loftmag2);

  }
  {
    BITCODE_BS loftparam;
    if (dwg_dynapi_header_value (dwg, "LOFTPARAM", &loftparam, NULL)
        && loftparam == dwg->header_vars.LOFTPARAM)
      {
        pass ("HEADER.LOFTPARAM [BS] %hu", loftparam);
      }
    else
      {
        fail ("HEADER.LOFTPARAM [BS] %hu != %hu", dwg->header_vars.LOFTPARAM, loftparam);
        error++;
      }
    loftparam++;
    if (dwg_dynapi_header_set_value (dwg, "LOFTPARAM", &loftparam)
        && loftparam == dwg->header_vars.LOFTPARAM)
      {
        pass ("HEADER.LOFTPARAM [BS] set+1 %hu", loftparam);
      }
    else
      {
        fail ("HEADER.LOFTPARAM [BS] set+1 %hu != %hu",
              dwg->header_vars.LOFTPARAM, loftparam);
        error++;
      }
    loftparam--;
    dwg_dynapi_header_set_value (dwg, "LOFTPARAM", &loftparam);

  }
  {
    BITCODE_RC loftnormals;
    if (dwg_dynapi_header_value (dwg, "LOFTNORMALS", &loftnormals, NULL)
        && loftnormals == dwg->header_vars.LOFTNORMALS)
      {
        pass ("HEADER.LOFTNORMALS [RC] %u", loftnormals);
      }
    else
      {
        fail ("HEADER.LOFTNORMALS [RC] %u != %u", dwg->header_vars.LOFTNORMALS, loftnormals);
        error++;
      }
    loftnormals++;
    if (dwg_dynapi_header_set_value (dwg, "LOFTNORMALS", &loftnormals)
        && loftnormals == dwg->header_vars.LOFTNORMALS)
      {
        pass ("HEADER.LOFTNORMALS [RC] set+1 %u", loftnormals);
      }
    else
      {
        fail ("HEADER.LOFTNORMALS [RC] set+1 %u != %u",
              dwg->header_vars.LOFTNORMALS, loftnormals);
        error++;
      }
    loftnormals--;
    dwg_dynapi_header_set_value (dwg, "LOFTNORMALS", &loftnormals);

  }
  {
    BITCODE_BD latitude;
    if (dwg_dynapi_header_value (dwg, "LATITUDE", &latitude, NULL)
        && latitude == dwg->header_vars.LATITUDE)
      {
        pass ("HEADER.LATITUDE [BD] %g", latitude);
      }
    else
      {
        fail ("HEADER.LATITUDE [BD] %g != %g", dwg->header_vars.LATITUDE, latitude);
        error++;
      }
    latitude++;
    if (dwg_dynapi_header_set_value (dwg, "LATITUDE", &latitude)
        && latitude == dwg->header_vars.LATITUDE)
      {
        pass ("HEADER.LATITUDE [BD] set+1 %g", latitude);
      }
    else
      {
        fail ("HEADER.LATITUDE [BD] set+1 %g != %g",
              dwg->header_vars.LATITUDE, latitude);
        error++;
      }
    latitude--;
    dwg_dynapi_header_set_value (dwg, "LATITUDE", &latitude);

  }
  {
    BITCODE_BD longitude;
    if (dwg_dynapi_header_value (dwg, "LONGITUDE", &longitude, NULL)
        && longitude == dwg->header_vars.LONGITUDE)
      {
        pass ("HEADER.LONGITUDE [BD] %g", longitude);
      }
    else
      {
        fail ("HEADER.LONGITUDE [BD] %g != %g", dwg->header_vars.LONGITUDE, longitude);
        error++;
      }
    longitude++;
    if (dwg_dynapi_header_set_value (dwg, "LONGITUDE", &longitude)
        && longitude == dwg->header_vars.LONGITUDE)
      {
        pass ("HEADER.LONGITUDE [BD] set+1 %g", longitude);
      }
    else
      {
        fail ("HEADER.LONGITUDE [BD] set+1 %g != %g",
              dwg->header_vars.LONGITUDE, longitude);
        error++;
      }
    longitude--;
    dwg_dynapi_header_set_value (dwg, "LONGITUDE", &longitude);

  }
  {
    BITCODE_BD northdirection;
    if (dwg_dynapi_header_value (dwg, "NORTHDIRECTION", &northdirection, NULL)
        && northdirection == dwg->header_vars.NORTHDIRECTION)
      {
        pass ("HEADER.NORTHDIRECTION [BD] %g", northdirection);
      }
    else
      {
        fail ("HEADER.NORTHDIRECTION [BD] %g != %g", dwg->header_vars.NORTHDIRECTION, northdirection);
        error++;
      }
    northdirection++;
    if (dwg_dynapi_header_set_value (dwg, "NORTHDIRECTION", &northdirection)
        && northdirection == dwg->header_vars.NORTHDIRECTION)
      {
        pass ("HEADER.NORTHDIRECTION [BD] set+1 %g", northdirection);
      }
    else
      {
        fail ("HEADER.NORTHDIRECTION [BD] set+1 %g != %g",
              dwg->header_vars.NORTHDIRECTION, northdirection);
        error++;
      }
    northdirection--;
    dwg_dynapi_header_set_value (dwg, "NORTHDIRECTION", &northdirection);

  }
  {
    BITCODE_BL timezone;
    if (dwg_dynapi_header_value (dwg, "TIMEZONE", &timezone, NULL)
        && timezone == dwg->header_vars.TIMEZONE)
      {
        pass ("HEADER.TIMEZONE [BL] %u", timezone);
      }
    else
      {
        fail ("HEADER.TIMEZONE [BL] %u != %u", dwg->header_vars.TIMEZONE, timezone);
        error++;
      }
    timezone++;
    if (dwg_dynapi_header_set_value (dwg, "TIMEZONE", &timezone)
        && timezone == dwg->header_vars.TIMEZONE)
      {
        pass ("HEADER.TIMEZONE [BL] set+1 %u", timezone);
      }
    else
      {
        fail ("HEADER.TIMEZONE [BL] set+1 %u != %u",
              dwg->header_vars.TIMEZONE, timezone);
        error++;
      }
    timezone--;
    dwg_dynapi_header_set_value (dwg, "TIMEZONE", &timezone);

  }
  {
    BITCODE_RC lightglyphdisplay;
    if (dwg_dynapi_header_value (dwg, "LIGHTGLYPHDISPLAY", &lightglyphdisplay, NULL)
        && lightglyphdisplay == dwg->header_vars.LIGHTGLYPHDISPLAY)
      {
        pass ("HEADER.LIGHTGLYPHDISPLAY [RC] %u", lightglyphdisplay);
      }
    else
      {
        fail ("HEADER.LIGHTGLYPHDISPLAY [RC] %u != %u", dwg->header_vars.LIGHTGLYPHDISPLAY, lightglyphdisplay);
        error++;
      }
    lightglyphdisplay++;
    if (dwg_dynapi_header_set_value (dwg, "LIGHTGLYPHDISPLAY", &lightglyphdisplay)
        && lightglyphdisplay == dwg->header_vars.LIGHTGLYPHDISPLAY)
      {
        pass ("HEADER.LIGHTGLYPHDISPLAY [RC] set+1 %u", lightglyphdisplay);
      }
    else
      {
        fail ("HEADER.LIGHTGLYPHDISPLAY [RC] set+1 %u != %u",
              dwg->header_vars.LIGHTGLYPHDISPLAY, lightglyphdisplay);
        error++;
      }
    lightglyphdisplay--;
    dwg_dynapi_header_set_value (dwg, "LIGHTGLYPHDISPLAY", &lightglyphdisplay);

  }
  {
    BITCODE_RC tilemodelightsynch;
    if (dwg_dynapi_header_value (dwg, "TILEMODELIGHTSYNCH", &tilemodelightsynch, NULL)
        && tilemodelightsynch == dwg->header_vars.TILEMODELIGHTSYNCH)
      {
        pass ("HEADER.TILEMODELIGHTSYNCH [RC] %u", tilemodelightsynch);
      }
    else
      {
        fail ("HEADER.TILEMODELIGHTSYNCH [RC] %u != %u", dwg->header_vars.TILEMODELIGHTSYNCH, tilemodelightsynch);
        error++;
      }
    tilemodelightsynch++;
    if (dwg_dynapi_header_set_value (dwg, "TILEMODELIGHTSYNCH", &tilemodelightsynch)
        && tilemodelightsynch == dwg->header_vars.TILEMODELIGHTSYNCH)
      {
        pass ("HEADER.TILEMODELIGHTSYNCH [RC] set+1 %u", tilemodelightsynch);
      }
    else
      {
        fail ("HEADER.TILEMODELIGHTSYNCH [RC] set+1 %u != %u",
              dwg->header_vars.TILEMODELIGHTSYNCH, tilemodelightsynch);
        error++;
      }
    tilemodelightsynch--;
    dwg_dynapi_header_set_value (dwg, "TILEMODELIGHTSYNCH", &tilemodelightsynch);

  }
  {
    BITCODE_RC dwfframe;
    if (dwg_dynapi_header_value (dwg, "DWFFRAME", &dwfframe, NULL)
        && dwfframe == dwg->header_vars.DWFFRAME)
      {
        pass ("HEADER.DWFFRAME [RC] %u", dwfframe);
      }
    else
      {
        fail ("HEADER.DWFFRAME [RC] %u != %u", dwg->header_vars.DWFFRAME, dwfframe);
        error++;
      }
    dwfframe++;
    if (dwg_dynapi_header_set_value (dwg, "DWFFRAME", &dwfframe)
        && dwfframe == dwg->header_vars.DWFFRAME)
      {
        pass ("HEADER.DWFFRAME [RC] set+1 %u", dwfframe);
      }
    else
      {
        fail ("HEADER.DWFFRAME [RC] set+1 %u != %u",
              dwg->header_vars.DWFFRAME, dwfframe);
        error++;
      }
    dwfframe--;
    dwg_dynapi_header_set_value (dwg, "DWFFRAME", &dwfframe);

  }
  {
    BITCODE_RC dgnframe;
    if (dwg_dynapi_header_value (dwg, "DGNFRAME", &dgnframe, NULL)
        && dgnframe == dwg->header_vars.DGNFRAME)
      {
        pass ("HEADER.DGNFRAME [RC] %u", dgnframe);
      }
    else
      {
        fail ("HEADER.DGNFRAME [RC] %u != %u", dwg->header_vars.DGNFRAME, dgnframe);
        error++;
      }
    dgnframe++;
    if (dwg_dynapi_header_set_value (dwg, "DGNFRAME", &dgnframe)
        && dgnframe == dwg->header_vars.DGNFRAME)
      {
        pass ("HEADER.DGNFRAME [RC] set+1 %u", dgnframe);
      }
    else
      {
        fail ("HEADER.DGNFRAME [RC] set+1 %u != %u",
              dwg->header_vars.DGNFRAME, dgnframe);
        error++;
      }
    dgnframe--;
    dwg_dynapi_header_set_value (dwg, "DGNFRAME", &dgnframe);

  }
  {
    BITCODE_B realworldscale;
    if (dwg_dynapi_header_value (dwg, "REALWORLDSCALE", &realworldscale, NULL)
        && realworldscale == dwg->header_vars.REALWORLDSCALE)
      {
        pass ("HEADER.REALWORLDSCALE [B] " FORMAT_B "", realworldscale);
      }
    else
      {
        fail ("HEADER.REALWORLDSCALE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.REALWORLDSCALE, realworldscale);
        error++;
      }
    realworldscale++;
    if (dwg_dynapi_header_set_value (dwg, "REALWORLDSCALE", &realworldscale)
        && realworldscale == dwg->header_vars.REALWORLDSCALE)
      {
        pass ("HEADER.REALWORLDSCALE [B] set+1 " FORMAT_B "", realworldscale);
      }
    else
      {
        fail ("HEADER.REALWORLDSCALE [B] set+1 " FORMAT_B " != " FORMAT_B "",
              dwg->header_vars.REALWORLDSCALE, realworldscale);
        error++;
      }
    realworldscale--;
    dwg_dynapi_header_set_value (dwg, "REALWORLDSCALE", &realworldscale);

  }
  {
    BITCODE_CMC interferecolor;
    if (dwg_dynapi_header_value (dwg, "INTERFERECOLOR", &interferecolor, NULL)
        && !memcmp (&interferecolor, &dwg->header_vars.INTERFERECOLOR, sizeof (dwg->header_vars.INTERFERECOLOR))
       )
      {
        pass ("HEADER.INTERFERECOLOR [CMC]");
      }
    else
      {
        fail ("HEADER.INTERFERECOLOR [CMC]");
        error++;
      }
  }
  {
    BITCODE_H interfereobjvs;
    if (dwg_dynapi_header_value (dwg, "INTERFEREOBJVS", &interfereobjvs, NULL)
        && !memcmp (&interfereobjvs, &dwg->header_vars.INTERFEREOBJVS, sizeof (dwg->header_vars.INTERFEREOBJVS))
       )
      {
        pass ("HEADER.INTERFEREOBJVS [H]");
      }
    else
      {
        fail ("HEADER.INTERFEREOBJVS [H]");
        error++;
      }
  }
  {
    BITCODE_H interferevpvs;
    if (dwg_dynapi_header_value (dwg, "INTERFEREVPVS", &interferevpvs, NULL)
        && !memcmp (&interferevpvs, &dwg->header_vars.INTERFEREVPVS, sizeof (dwg->header_vars.INTERFEREVPVS))
       )
      {
        pass ("HEADER.INTERFEREVPVS [H]");
      }
    else
      {
        fail ("HEADER.INTERFEREVPVS [H]");
        error++;
      }
  }
  {
    BITCODE_H dragvs;
    if (dwg_dynapi_header_value (dwg, "DRAGVS", &dragvs, NULL)
        && !memcmp (&dragvs, &dwg->header_vars.DRAGVS, sizeof (dwg->header_vars.DRAGVS))
       )
      {
        pass ("HEADER.DRAGVS [H]");
      }
    else
      {
        fail ("HEADER.DRAGVS [H]");
        error++;
      }
  }
  {
    BITCODE_RC cshadow;
    if (dwg_dynapi_header_value (dwg, "CSHADOW", &cshadow, NULL)
        && cshadow == dwg->header_vars.CSHADOW)
      {
        pass ("HEADER.CSHADOW [RC] %u", cshadow);
      }
    else
      {
        fail ("HEADER.CSHADOW [RC] %u != %u", dwg->header_vars.CSHADOW, cshadow);
        error++;
      }
    cshadow++;
    if (dwg_dynapi_header_set_value (dwg, "CSHADOW", &cshadow)
        && cshadow == dwg->header_vars.CSHADOW)
      {
        pass ("HEADER.CSHADOW [RC] set+1 %u", cshadow);
      }
    else
      {
        fail ("HEADER.CSHADOW [RC] set+1 %u != %u",
              dwg->header_vars.CSHADOW, cshadow);
        error++;
      }
    cshadow--;
    dwg_dynapi_header_set_value (dwg, "CSHADOW", &cshadow);

  }
  {
    BITCODE_BD shadowplanelocation;
    if (dwg_dynapi_header_value (dwg, "SHADOWPLANELOCATION", &shadowplanelocation, NULL)
        && shadowplanelocation == dwg->header_vars.SHADOWPLANELOCATION)
      {
        pass ("HEADER.SHADOWPLANELOCATION [BD] %g", shadowplanelocation);
      }
    else
      {
        fail ("HEADER.SHADOWPLANELOCATION [BD] %g != %g", dwg->header_vars.SHADOWPLANELOCATION, shadowplanelocation);
        error++;
      }
    shadowplanelocation++;
    if (dwg_dynapi_header_set_value (dwg, "SHADOWPLANELOCATION", &shadowplanelocation)
        && shadowplanelocation == dwg->header_vars.SHADOWPLANELOCATION)
      {
        pass ("HEADER.SHADOWPLANELOCATION [BD] set+1 %g", shadowplanelocation);
      }
    else
      {
        fail ("HEADER.SHADOWPLANELOCATION [BD] set+1 %g != %g",
              dwg->header_vars.SHADOWPLANELOCATION, shadowplanelocation);
        error++;
      }
    shadowplanelocation--;
    dwg_dynapi_header_set_value (dwg, "SHADOWPLANELOCATION", &shadowplanelocation);

  }
  {
    BITCODE_BS unknown_54;
    if (dwg_dynapi_header_value (dwg, "unknown_54", &unknown_54, NULL)
        && unknown_54 == dwg->header_vars.unknown_54)
      {
        pass ("HEADER.unknown_54 [BS] %hu", unknown_54);
      }
    else
      {
        fail ("HEADER.unknown_54 [BS] %hu != %hu", dwg->header_vars.unknown_54, unknown_54);
        error++;
      }
    unknown_54++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_54", &unknown_54)
        && unknown_54 == dwg->header_vars.unknown_54)
      {
        pass ("HEADER.unknown_54 [BS] set+1 %hu", unknown_54);
      }
    else
      {
        fail ("HEADER.unknown_54 [BS] set+1 %hu != %hu",
              dwg->header_vars.unknown_54, unknown_54);
        error++;
      }
    unknown_54--;
    dwg_dynapi_header_set_value (dwg, "unknown_54", &unknown_54);

  }
  {
    BITCODE_BS unknown_55;
    if (dwg_dynapi_header_value (dwg, "unknown_55", &unknown_55, NULL)
        && unknown_55 == dwg->header_vars.unknown_55)
      {
        pass ("HEADER.unknown_55 [BS] %hu", unknown_55);
      }
    else
      {
        fail ("HEADER.unknown_55 [BS] %hu != %hu", dwg->header_vars.unknown_55, unknown_55);
        error++;
      }
    unknown_55++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_55", &unknown_55)
        && unknown_55 == dwg->header_vars.unknown_55)
      {
        pass ("HEADER.unknown_55 [BS] set+1 %hu", unknown_55);
      }
    else
      {
        fail ("HEADER.unknown_55 [BS] set+1 %hu != %hu",
              dwg->header_vars.unknown_55, unknown_55);
        error++;
      }
    unknown_55--;
    dwg_dynapi_header_set_value (dwg, "unknown_55", &unknown_55);

  }
  {
    BITCODE_BS unknown_56;
    if (dwg_dynapi_header_value (dwg, "unknown_56", &unknown_56, NULL)
        && unknown_56 == dwg->header_vars.unknown_56)
      {
        pass ("HEADER.unknown_56 [BS] %hu", unknown_56);
      }
    else
      {
        fail ("HEADER.unknown_56 [BS] %hu != %hu", dwg->header_vars.unknown_56, unknown_56);
        error++;
      }
    unknown_56++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_56", &unknown_56)
        && unknown_56 == dwg->header_vars.unknown_56)
      {
        pass ("HEADER.unknown_56 [BS] set+1 %hu", unknown_56);
      }
    else
      {
        fail ("HEADER.unknown_56 [BS] set+1 %hu != %hu",
              dwg->header_vars.unknown_56, unknown_56);
        error++;
      }
    unknown_56--;
    dwg_dynapi_header_set_value (dwg, "unknown_56", &unknown_56);

  }
  {
    BITCODE_BS unknown_57;
    if (dwg_dynapi_header_value (dwg, "unknown_57", &unknown_57, NULL)
        && unknown_57 == dwg->header_vars.unknown_57)
      {
        pass ("HEADER.unknown_57 [BS] %hu", unknown_57);
      }
    else
      {
        fail ("HEADER.unknown_57 [BS] %hu != %hu", dwg->header_vars.unknown_57, unknown_57);
        error++;
      }
    unknown_57++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_57", &unknown_57)
        && unknown_57 == dwg->header_vars.unknown_57)
      {
        pass ("HEADER.unknown_57 [BS] set+1 %hu", unknown_57);
      }
    else
      {
        fail ("HEADER.unknown_57 [BS] set+1 %hu != %hu",
              dwg->header_vars.unknown_57, unknown_57);
        error++;
      }
    unknown_57--;
    dwg_dynapi_header_set_value (dwg, "unknown_57", &unknown_57);

  }
  {
    BITCODE_RS crc;
    if (dwg_dynapi_header_value (dwg, "crc", &crc, NULL)
        && crc == dwg->header_vars.crc)
      {
        pass ("HEADER.crc [RS] %hu", crc);
      }
    else
      {
        fail ("HEADER.crc [RS] %hu != %hu", dwg->header_vars.crc, crc);
        error++;
      }
    crc++;
    if (dwg_dynapi_header_set_value (dwg, "crc", &crc)
        && crc == dwg->header_vars.crc)
      {
        pass ("HEADER.crc [RS] set+1 %hu", crc);
      }
    else
      {
        fail ("HEADER.crc [RS] set+1 %hu != %hu",
              dwg->header_vars.crc, crc);
        error++;
      }
    crc--;
    dwg_dynapi_header_set_value (dwg, "crc", &crc);

  }
#line 49 "dynapi_test.c.in"
  return error;
}

#line 7261 "dynapi_test.c"
/* @@for test_OBJECT@@ */
static int test__3DFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity__3DFACE *restrict _3dface = obj->tio.entity->tio._3DFACE;
  {
    BITCODE_3BD corner1;
    if (dwg_dynapi_entity_value(_3dface, "3DFACE", "corner1", &corner1, NULL)
        && !memcmp (&corner1, &_3dface->corner1, sizeof (_3dface->corner1)))
      {
        pass ("3DFACE.corner1 [3BD]");
      }
    else
      {
        fail ("3DFACE.corner1 [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD corner2;
    if (dwg_dynapi_entity_value(_3dface, "3DFACE", "corner2", &corner2, NULL)
        && !memcmp (&corner2, &_3dface->corner2, sizeof (_3dface->corner2)))
      {
        pass ("3DFACE.corner2 [3BD]");
      }
    else
      {
        fail ("3DFACE.corner2 [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD corner3;
    if (dwg_dynapi_entity_value(_3dface, "3DFACE", "corner3", &corner3, NULL)
        && !memcmp (&corner3, &_3dface->corner3, sizeof (_3dface->corner3)))
      {
        pass ("3DFACE.corner3 [3BD]");
      }
    else
      {
        fail ("3DFACE.corner3 [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD corner4;
    if (dwg_dynapi_entity_value(_3dface, "3DFACE", "corner4", &corner4, NULL)
        && !memcmp (&corner4, &_3dface->corner4, sizeof (_3dface->corner4)))
      {
        pass ("3DFACE.corner4 [3BD]");
      }
    else
      {
        fail ("3DFACE.corner4 [3BD]");
        error++;
      }
  }
  {
    BITCODE_B has_no_flags;
    if (dwg_dynapi_entity_value(_3dface, "3DFACE", "has_no_flags", &has_no_flags, NULL)
        && has_no_flags == _3dface->has_no_flags)
      {
        pass ("3DFACE.has_no_flags [B] " FORMAT_B "", has_no_flags);
      }
    else
      {
        fail ("3DFACE.has_no_flags [B] " FORMAT_B " != " FORMAT_B "", _3dface->has_no_flags, has_no_flags);
        error++;
      }
    has_no_flags++;
    if (dwg_dynapi_entity_set_value (_3dface, "3DFACE", "has_no_flags", &has_no_flags)
        && has_no_flags == _3dface->has_no_flags)
      {
        pass ("3DFACE.has_no_flags [B] set+1 " FORMAT_B "", has_no_flags);
      }
    else
      {
        fail ("3DFACE.has_no_flags [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dface->has_no_flags, has_no_flags);
        error++;
      }
    _3dface->has_no_flags--;

  }
  {
    BITCODE_BS invis_flags;
    if (dwg_dynapi_entity_value(_3dface, "3DFACE", "invis_flags", &invis_flags, NULL)
        && invis_flags == _3dface->invis_flags)
      {
        pass ("3DFACE.invis_flags [BS] %hu", invis_flags);
      }
    else
      {
        fail ("3DFACE.invis_flags [BS] %hu != %hu", _3dface->invis_flags, invis_flags);
        error++;
      }
    invis_flags++;
    if (dwg_dynapi_entity_set_value (_3dface, "3DFACE", "invis_flags", &invis_flags)
        && invis_flags == _3dface->invis_flags)
      {
        pass ("3DFACE.invis_flags [BS] set+1 %hu", invis_flags);
      }
    else
      {
        fail ("3DFACE.invis_flags [BS] set+1 %hu != %hu", _3dface->invis_flags, invis_flags);
        error++;
      }
    _3dface->invis_flags--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(_3dface, "3DFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &_3dface->parent, sizeof (_3dface->parent)))
      {
        pass ("3DFACE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("3DFACE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_B z_is_zero;
    if (dwg_dynapi_entity_value(_3dface, "3DFACE", "z_is_zero", &z_is_zero, NULL)
        && z_is_zero == _3dface->z_is_zero)
      {
        pass ("3DFACE.z_is_zero [B] " FORMAT_B "", z_is_zero);
      }
    else
      {
        fail ("3DFACE.z_is_zero [B] " FORMAT_B " != " FORMAT_B "", _3dface->z_is_zero, z_is_zero);
        error++;
      }
    z_is_zero++;
    if (dwg_dynapi_entity_set_value (_3dface, "3DFACE", "z_is_zero", &z_is_zero)
        && z_is_zero == _3dface->z_is_zero)
      {
        pass ("3DFACE.z_is_zero [B] set+1 " FORMAT_B "", z_is_zero);
      }
    else
      {
        fail ("3DFACE.z_is_zero [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dface->z_is_zero, z_is_zero);
        error++;
      }
    _3dface->z_is_zero--;

  }
  return error;
}
static int test__3DSOLID (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity__3DSOLID *restrict _3dsolid = obj->tio.entity->tio._3DSOLID;
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "acis_data", &acis_data, NULL)
        && !strcmp ((char *)acis_data, (char *)_3dsolid->acis_data))
      {
        pass ("3DSOLID.acis_data [RC*] '%s' <> '%s'", acis_data, _3dsolid->acis_data);
      }
    else
      {
        fail ("3DSOLID.acis_data [RC*] '%s' <> '%s'", acis_data, _3dsolid->acis_data);
        error++;
      }
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "acis_empty", &acis_empty, NULL)
        && acis_empty == _3dsolid->acis_empty)
      {
        pass ("3DSOLID.acis_empty [B] " FORMAT_B "", acis_empty);
      }
    else
      {
        fail ("3DSOLID.acis_empty [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->acis_empty, acis_empty);
        error++;
      }
    acis_empty++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "acis_empty", &acis_empty)
        && acis_empty == _3dsolid->acis_empty)
      {
        pass ("3DSOLID.acis_empty [B] set+1 " FORMAT_B "", acis_empty);
      }
    else
      {
        fail ("3DSOLID.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->acis_empty, acis_empty);
        error++;
      }
    _3dsolid->acis_empty--;

  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == _3dsolid->acis_empty2)
      {
        pass ("3DSOLID.acis_empty2 [B] " FORMAT_B "", acis_empty2);
      }
    else
      {
        fail ("3DSOLID.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->acis_empty2, acis_empty2);
        error++;
      }
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "acis_empty2", &acis_empty2)
        && acis_empty2 == _3dsolid->acis_empty2)
      {
        pass ("3DSOLID.acis_empty2 [B] set+1 " FORMAT_B "", acis_empty2);
      }
    else
      {
        fail ("3DSOLID.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->acis_empty2, acis_empty2);
        error++;
      }
    _3dsolid->acis_empty2--;

  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == _3dsolid->acis_empty_bit)
      {
        pass ("3DSOLID.acis_empty_bit [B] " FORMAT_B "", acis_empty_bit);
      }
    else
      {
        fail ("3DSOLID.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->acis_empty_bit, acis_empty_bit);
        error++;
      }
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "acis_empty_bit", &acis_empty_bit)
        && acis_empty_bit == _3dsolid->acis_empty_bit)
      {
        pass ("3DSOLID.acis_empty_bit [B] set+1 " FORMAT_B "", acis_empty_bit);
      }
    else
      {
        fail ("3DSOLID.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->acis_empty_bit, acis_empty_bit);
        error++;
      }
    _3dsolid->acis_empty_bit--;

  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &_3dsolid->block_size, sizeof (_3dsolid->block_size)))
      {
        pass ("3DSOLID.block_size [BL*]");
      }
    else
      {
        fail ("3DSOLID.block_size [BL*]");
        error++;
      }
  }
  {
    char ** encr_sat_data;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "num_encr_sat_data", &count, NULL)
        && dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "encr_sat_data", &encr_sat_data, NULL)
)
      {
        pass ("3DSOLID.encr_sat_data [char **] * %u num_encr_sat_data", count);
      }
    else
      {
        fail ("3DSOLID.encr_sat_data [char **] * %u num_encr_sat_data", count);
        error++;
      }
  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &_3dsolid->extra_acis_data, sizeof (_3dsolid->extra_acis_data)))
      {
        pass ("3DSOLID.extra_acis_data [struct _dwg_entity_3DSOLID*]");
      }
    else
      {
        fail ("3DSOLID.extra_acis_data [struct _dwg_entity_3DSOLID*]");
        error++;
      }
  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &_3dsolid->history_id, sizeof (_3dsolid->history_id)))
      {
        pass ("3DSOLID.history_id [H]");
      }
    else
      {
        fail ("3DSOLID.history_id [H]");
        error++;
      }
  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "isoline_present", &isoline_present, NULL)
        && isoline_present == _3dsolid->isoline_present)
      {
        pass ("3DSOLID.isoline_present [B] " FORMAT_B "", isoline_present);
      }
    else
      {
        fail ("3DSOLID.isoline_present [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->isoline_present, isoline_present);
        error++;
      }
    isoline_present++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "isoline_present", &isoline_present)
        && isoline_present == _3dsolid->isoline_present)
      {
        pass ("3DSOLID.isoline_present [B] set+1 " FORMAT_B "", isoline_present);
      }
    else
      {
        fail ("3DSOLID.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->isoline_present, isoline_present);
        error++;
      }
    _3dsolid->isoline_present--;

  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "num_blocks", &num_blocks, NULL)
        && num_blocks == _3dsolid->num_blocks)
      {
        pass ("3DSOLID.num_blocks [BL] %u", num_blocks);
      }
    else
      {
        fail ("3DSOLID.num_blocks [BL] %u != %u", _3dsolid->num_blocks, num_blocks);
        error++;
      }
    num_blocks++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "num_blocks", &num_blocks)
        && num_blocks == _3dsolid->num_blocks)
      {
        pass ("3DSOLID.num_blocks [BL] set+1 %u", num_blocks);
      }
    else
      {
        fail ("3DSOLID.num_blocks [BL] set+1 %u != %u", _3dsolid->num_blocks, num_blocks);
        error++;
      }
    _3dsolid->num_blocks--;

  }
  {
    BITCODE_BL num_isolines;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "num_isolines", &num_isolines, NULL)
        && num_isolines == _3dsolid->num_isolines)
      {
        pass ("3DSOLID.num_isolines [BL] %u", num_isolines);
      }
    else
      {
        fail ("3DSOLID.num_isolines [BL] %u != %u", _3dsolid->num_isolines, num_isolines);
        error++;
      }
    num_isolines++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "num_isolines", &num_isolines)
        && num_isolines == _3dsolid->num_isolines)
      {
        pass ("3DSOLID.num_isolines [BL] set+1 %u", num_isolines);
      }
    else
      {
        fail ("3DSOLID.num_isolines [BL] set+1 %u != %u", _3dsolid->num_isolines, num_isolines);
        error++;
      }
    _3dsolid->num_isolines--;

  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == _3dsolid->num_silhouettes)
      {
        pass ("3DSOLID.num_silhouettes [BL] %u", num_silhouettes);
      }
    else
      {
        fail ("3DSOLID.num_silhouettes [BL] %u != %u", _3dsolid->num_silhouettes, num_silhouettes);
        error++;
      }
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "num_silhouettes", &num_silhouettes)
        && num_silhouettes == _3dsolid->num_silhouettes)
      {
        pass ("3DSOLID.num_silhouettes [BL] set+1 %u", num_silhouettes);
      }
    else
      {
        fail ("3DSOLID.num_silhouettes [BL] set+1 %u != %u", _3dsolid->num_silhouettes, num_silhouettes);
        error++;
      }
    _3dsolid->num_silhouettes--;

  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "num_wires", &num_wires, NULL)
        && num_wires == _3dsolid->num_wires)
      {
        pass ("3DSOLID.num_wires [BL] %u", num_wires);
      }
    else
      {
        fail ("3DSOLID.num_wires [BL] %u != %u", _3dsolid->num_wires, num_wires);
        error++;
      }
    num_wires++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "num_wires", &num_wires)
        && num_wires == _3dsolid->num_wires)
      {
        pass ("3DSOLID.num_wires [BL] set+1 %u", num_wires);
      }
    else
      {
        fail ("3DSOLID.num_wires [BL] set+1 %u != %u", _3dsolid->num_wires, num_wires);
        error++;
      }
    _3dsolid->num_wires--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "parent", &parent, NULL)
        && !memcmp (&parent, &_3dsolid->parent, sizeof (_3dsolid->parent)))
      {
        pass ("3DSOLID.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("3DSOLID.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "point", &point, NULL)
        && !memcmp (&point, &_3dsolid->point, sizeof (_3dsolid->point)))
      {
        pass ("3DSOLID.point [3BD]");
      }
    else
      {
        fail ("3DSOLID.point [3BD]");
        error++;
      }
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "point_present", &point_present, NULL)
        && point_present == _3dsolid->point_present)
      {
        pass ("3DSOLID.point_present [B] " FORMAT_B "", point_present);
      }
    else
      {
        fail ("3DSOLID.point_present [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->point_present, point_present);
        error++;
      }
    point_present++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "point_present", &point_present)
        && point_present == _3dsolid->point_present)
      {
        pass ("3DSOLID.point_present [B] set+1 " FORMAT_B "", point_present);
      }
    else
      {
        fail ("3DSOLID.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->point_present, point_present);
        error++;
      }
    _3dsolid->point_present--;

  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "silhouettes", &silhouettes, NULL)
        && silhouettes == _3dsolid->silhouettes)
      {
        pass ("3DSOLID.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
      }
    else
      {
        fail ("3DSOLID.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
        error++;
      }
  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "unknown", &unknown, NULL)
        && unknown == _3dsolid->unknown)
      {
        pass ("3DSOLID.unknown [B] " FORMAT_B "", unknown);
      }
    else
      {
        fail ("3DSOLID.unknown [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->unknown, unknown);
        error++;
      }
    unknown++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "unknown", &unknown)
        && unknown == _3dsolid->unknown)
      {
        pass ("3DSOLID.unknown [B] set+1 " FORMAT_B "", unknown);
      }
    else
      {
        fail ("3DSOLID.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->unknown, unknown);
        error++;
      }
    _3dsolid->unknown--;

  }
  {
    BITCODE_BL unknown_2007;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "unknown_2007", &unknown_2007, NULL)
        && unknown_2007 == _3dsolid->unknown_2007)
      {
        pass ("3DSOLID.unknown_2007 [BL] %u", unknown_2007);
      }
    else
      {
        fail ("3DSOLID.unknown_2007 [BL] %u != %u", _3dsolid->unknown_2007, unknown_2007);
        error++;
      }
    unknown_2007++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "unknown_2007", &unknown_2007)
        && unknown_2007 == _3dsolid->unknown_2007)
      {
        pass ("3DSOLID.unknown_2007 [BL] set+1 %u", unknown_2007);
      }
    else
      {
        fail ("3DSOLID.unknown_2007 [BL] set+1 %u != %u", _3dsolid->unknown_2007, unknown_2007);
        error++;
      }
    _3dsolid->unknown_2007--;

  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "version", &version, NULL)
        && version == _3dsolid->version)
      {
        pass ("3DSOLID.version [BS] %hu", version);
      }
    else
      {
        fail ("3DSOLID.version [BS] %hu != %hu", _3dsolid->version, version);
        error++;
      }
    version++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "version", &version)
        && version == _3dsolid->version)
      {
        pass ("3DSOLID.version [BS] set+1 %hu", version);
      }
    else
      {
        fail ("3DSOLID.version [BS] set+1 %hu != %hu", _3dsolid->version, version);
        error++;
      }
    _3dsolid->version--;

  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value(_3dsolid, "3DSOLID", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == _3dsolid->wireframe_data_present)
      {
        pass ("3DSOLID.wireframe_data_present [B] " FORMAT_B "", wireframe_data_present);
      }
    else
      {
        fail ("3DSOLID.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->wireframe_data_present, wireframe_data_present);
        error++;
      }
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "wireframe_data_present", &wireframe_data_present)
        && wireframe_data_present == _3dsolid->wireframe_data_present)
      {
        pass ("3DSOLID.wireframe_data_present [B] set+1 " FORMAT_B "", wireframe_data_present);
      }
    else
      {
        fail ("3DSOLID.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->wireframe_data_present, wireframe_data_present);
        error++;
      }
    _3dsolid->wireframe_data_present--;

  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "wires", &wires, NULL)
        && wires == _3dsolid->wires)
      {
        pass ("3DSOLID.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
      }
    else
      {
        fail ("3DSOLID.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
        error++;
      }
  }
  return error;
}
static int test_ARC (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ARC *restrict arc = obj->tio.entity->tio.ARC;
  {
    BITCODE_3BD center;
    if (dwg_dynapi_entity_value(arc, "ARC", "center", &center, NULL)
        && !memcmp (&center, &arc->center, sizeof (arc->center)))
      {
        pass ("ARC.center [3BD]");
      }
    else
      {
        fail ("ARC.center [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD end_angle;
    if (dwg_dynapi_entity_value(arc, "ARC", "end_angle", &end_angle, NULL)
        && end_angle == arc->end_angle)
      {
        pass ("ARC.end_angle [BD] %g", end_angle);
      }
    else
      {
        fail ("ARC.end_angle [BD] %g != %g", arc->end_angle, end_angle);
        error++;
      }
    end_angle++;
    if (dwg_dynapi_entity_set_value (arc, "ARC", "end_angle", &end_angle)
        && end_angle == arc->end_angle)
      {
        pass ("ARC.end_angle [BD] set+1 %g", end_angle);
      }
    else
      {
        fail ("ARC.end_angle [BD] set+1 %g != %g", arc->end_angle, end_angle);
        error++;
      }
    arc->end_angle--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value(arc, "ARC", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &arc->extrusion, sizeof (arc->extrusion)))
      {
        pass ("ARC.extrusion [BE]");
      }
    else
      {
        fail ("ARC.extrusion [BE]");
        error++;
      }
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(arc, "ARC", "parent", &parent, NULL)
        && !memcmp (&parent, &arc->parent, sizeof (arc->parent)))
      {
        pass ("ARC.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("ARC.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_BD radius;
    if (dwg_dynapi_entity_value(arc, "ARC", "radius", &radius, NULL)
        && radius == arc->radius)
      {
        pass ("ARC.radius [BD] %g", radius);
      }
    else
      {
        fail ("ARC.radius [BD] %g != %g", arc->radius, radius);
        error++;
      }
    radius++;
    if (dwg_dynapi_entity_set_value (arc, "ARC", "radius", &radius)
        && radius == arc->radius)
      {
        pass ("ARC.radius [BD] set+1 %g", radius);
      }
    else
      {
        fail ("ARC.radius [BD] set+1 %g != %g", arc->radius, radius);
        error++;
      }
    arc->radius--;

  }
  {
    BITCODE_BD start_angle;
    if (dwg_dynapi_entity_value(arc, "ARC", "start_angle", &start_angle, NULL)
        && start_angle == arc->start_angle)
      {
        pass ("ARC.start_angle [BD] %g", start_angle);
      }
    else
      {
        fail ("ARC.start_angle [BD] %g != %g", arc->start_angle, start_angle);
        error++;
      }
    start_angle++;
    if (dwg_dynapi_entity_set_value (arc, "ARC", "start_angle", &start_angle)
        && start_angle == arc->start_angle)
      {
        pass ("ARC.start_angle [BD] set+1 %g", start_angle);
      }
    else
      {
        fail ("ARC.start_angle [BD] set+1 %g != %g", arc->start_angle, start_angle);
        error++;
      }
    arc->start_angle--;

  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value(arc, "ARC", "thickness", &thickness, NULL)
        && thickness == arc->thickness)
      {
        pass ("ARC.thickness [BT] " FORMAT_BT "", thickness);
      }
    else
      {
        fail ("ARC.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", arc->thickness, thickness);
        error++;
      }
    if (dwg_dynapi_entity_set_value (arc, "ARC", "thickness", &thickness)
        && thickness == arc->thickness)
      {
        pass ("ARC.thickness [BT] set+1 " FORMAT_BT "", thickness);
      }
    else
      {
        fail ("ARC.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", arc->thickness, thickness);
        error++;
      }
    arc->thickness--;

  }
  return error;
}
static int test_ARC_DIMENSION (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ARC_DIMENSION *restrict arc_dimension = obj->tio.entity->tio.ARC_DIMENSION;
  {
    BITCODE_3BD _13_pt;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "_13_pt", &_13_pt, NULL)
        && !memcmp (&_13_pt, &arc_dimension->_13_pt, sizeof (arc_dimension->_13_pt)))
      {
        pass ("ARC_DIMENSION._13_pt [3BD]");
      }
    else
      {
        fail ("ARC_DIMENSION._13_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD _14_pt;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "_14_pt", &_14_pt, NULL)
        && !memcmp (&_14_pt, &arc_dimension->_14_pt, sizeof (arc_dimension->_14_pt)))
      {
        pass ("ARC_DIMENSION._14_pt [3BD]");
      }
    else
      {
        fail ("ARC_DIMENSION._14_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD _15_pt;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "_15_pt", &_15_pt, NULL)
        && !memcmp (&_15_pt, &arc_dimension->_15_pt, sizeof (arc_dimension->_15_pt)))
      {
        pass ("ARC_DIMENSION._15_pt [3BD]");
      }
    else
      {
        fail ("ARC_DIMENSION._15_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD _16_pt;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "_16_pt", &_16_pt, NULL)
        && !memcmp (&_16_pt, &arc_dimension->_16_pt, sizeof (arc_dimension->_16_pt)))
      {
        pass ("ARC_DIMENSION._16_pt [3BD]");
      }
    else
      {
        fail ("ARC_DIMENSION._16_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD _17_pt;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "_17_pt", &_17_pt, NULL)
        && !memcmp (&_17_pt, &arc_dimension->_17_pt, sizeof (arc_dimension->_17_pt)))
      {
        pass ("ARC_DIMENSION._17_pt [3BD]");
      }
    else
      {
        fail ("ARC_DIMENSION._17_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "act_measurement", &act_measurement, NULL)
        && act_measurement == arc_dimension->act_measurement)
      {
        pass ("ARC_DIMENSION.act_measurement [BD] %g", act_measurement);
      }
    else
      {
        fail ("ARC_DIMENSION.act_measurement [BD] %g != %g", arc_dimension->act_measurement, act_measurement);
        error++;
      }
    act_measurement++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "act_measurement", &act_measurement)
        && act_measurement == arc_dimension->act_measurement)
      {
        pass ("ARC_DIMENSION.act_measurement [BD] set+1 %g", act_measurement);
      }
    else
      {
        fail ("ARC_DIMENSION.act_measurement [BD] set+1 %g != %g", arc_dimension->act_measurement, act_measurement);
        error++;
      }
    arc_dimension->act_measurement--;

  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "attachment", &attachment, NULL)
        && attachment == arc_dimension->attachment)
      {
        pass ("ARC_DIMENSION.attachment [BS] %hu", attachment);
      }
    else
      {
        fail ("ARC_DIMENSION.attachment [BS] %hu != %hu", arc_dimension->attachment, attachment);
        error++;
      }
    attachment++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "attachment", &attachment)
        && attachment == arc_dimension->attachment)
      {
        pass ("ARC_DIMENSION.attachment [BS] set+1 %hu", attachment);
      }
    else
      {
        fail ("ARC_DIMENSION.attachment [BS] set+1 %hu != %hu", arc_dimension->attachment, attachment);
        error++;
      }
    arc_dimension->attachment--;

  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "block", &block, NULL)
        && !memcmp (&block, &arc_dimension->block, sizeof (arc_dimension->block)))
      {
        pass ("ARC_DIMENSION.block [H]");
      }
    else
      {
        fail ("ARC_DIMENSION.block [H]");
        error++;
      }
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "blockname", &blockname, NULL)
        && !strcmp ((char *)blockname, (char *)arc_dimension->blockname))
      {
        pass ("ARC_DIMENSION.blockname [TV] '%s' <> '%s'", blockname, arc_dimension->blockname);
      }
    else
      {
        fail ("ARC_DIMENSION.blockname [TV] '%s' <> '%s'", blockname, arc_dimension->blockname);
        error++;
      }
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "class_version", &class_version, NULL)
        && class_version == arc_dimension->class_version)
      {
        pass ("ARC_DIMENSION.class_version [RC] %u", class_version);
      }
    else
      {
        fail ("ARC_DIMENSION.class_version [RC] %u != %u", arc_dimension->class_version, class_version);
        error++;
      }
    class_version++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "class_version", &class_version)
        && class_version == arc_dimension->class_version)
      {
        pass ("ARC_DIMENSION.class_version [RC] set+1 %u", class_version);
      }
    else
      {
        fail ("ARC_DIMENSION.class_version [RC] set+1 %u != %u", arc_dimension->class_version, class_version);
        error++;
      }
    arc_dimension->class_version--;

  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &arc_dimension->clone_ins_pt, sizeof (arc_dimension->clone_ins_pt)))
      {
        pass ("ARC_DIMENSION.clone_ins_pt [2RD]");
      }
    else
      {
        fail ("ARC_DIMENSION.clone_ins_pt [2RD]");
        error++;
      }
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &arc_dimension->def_pt, sizeof (arc_dimension->def_pt)))
      {
        pass ("ARC_DIMENSION.def_pt [3BD]");
      }
    else
      {
        fail ("ARC_DIMENSION.def_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &arc_dimension->dimstyle, sizeof (arc_dimension->dimstyle)))
      {
        pass ("ARC_DIMENSION.dimstyle [H]");
      }
    else
      {
        fail ("ARC_DIMENSION.dimstyle [H]");
        error++;
      }
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "elevation", &elevation, NULL)
        && elevation == arc_dimension->elevation)
      {
        pass ("ARC_DIMENSION.elevation [BD] %g", elevation);
      }
    else
      {
        fail ("ARC_DIMENSION.elevation [BD] %g != %g", arc_dimension->elevation, elevation);
        error++;
      }
    elevation++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "elevation", &elevation)
        && elevation == arc_dimension->elevation)
      {
        pass ("ARC_DIMENSION.elevation [BD] set+1 %g", elevation);
      }
    else
      {
        fail ("ARC_DIMENSION.elevation [BD] set+1 %g != %g", arc_dimension->elevation, elevation);
        error++;
      }
    arc_dimension->elevation--;

  }
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &arc_dimension->extrusion, sizeof (arc_dimension->extrusion)))
      {
        pass ("ARC_DIMENSION.extrusion [3BD]");
      }
    else
      {
        fail ("ARC_DIMENSION.extrusion [3BD]");
        error++;
      }
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "flag", &flag, NULL)
        && flag == arc_dimension->flag)
      {
        pass ("ARC_DIMENSION.flag [RC] %u", flag);
      }
    else
      {
        fail ("ARC_DIMENSION.flag [RC] %u != %u", arc_dimension->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "flag", &flag)
        && flag == arc_dimension->flag)
      {
        pass ("ARC_DIMENSION.flag [RC] set+1 %u", flag);
      }
    else
      {
        fail ("ARC_DIMENSION.flag [RC] set+1 %u != %u", arc_dimension->flag, flag);
        error++;
      }
    arc_dimension->flag--;

  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "flag1", &flag1, NULL)
        && flag1 == arc_dimension->flag1)
      {
        pass ("ARC_DIMENSION.flag1 [RC] %u", flag1);
      }
    else
      {
        fail ("ARC_DIMENSION.flag1 [RC] %u != %u", arc_dimension->flag1, flag1);
        error++;
      }
    flag1++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "flag1", &flag1)
        && flag1 == arc_dimension->flag1)
      {
        pass ("ARC_DIMENSION.flag1 [RC] set+1 %u", flag1);
      }
    else
      {
        fail ("ARC_DIMENSION.flag1 [RC] set+1 %u != %u", arc_dimension->flag1, flag1);
        error++;
      }
    arc_dimension->flag1--;

  }
  {
    BITCODE_RC flag2;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "flag2", &flag2, NULL)
        && flag2 == arc_dimension->flag2)
      {
        pass ("ARC_DIMENSION.flag2 [RC] %u", flag2);
      }
    else
      {
        fail ("ARC_DIMENSION.flag2 [RC] %u != %u", arc_dimension->flag2, flag2);
        error++;
      }
    flag2++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "flag2", &flag2)
        && flag2 == arc_dimension->flag2)
      {
        pass ("ARC_DIMENSION.flag2 [RC] set+1 %u", flag2);
      }
    else
      {
        fail ("ARC_DIMENSION.flag2 [RC] set+1 %u != %u", arc_dimension->flag2, flag2);
        error++;
      }
    arc_dimension->flag2--;

  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == arc_dimension->flip_arrow1)
      {
        pass ("ARC_DIMENSION.flip_arrow1 [B] " FORMAT_B "", flip_arrow1);
      }
    else
      {
        fail ("ARC_DIMENSION.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", arc_dimension->flip_arrow1, flip_arrow1);
        error++;
      }
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "flip_arrow1", &flip_arrow1)
        && flip_arrow1 == arc_dimension->flip_arrow1)
      {
        pass ("ARC_DIMENSION.flip_arrow1 [B] set+1 " FORMAT_B "", flip_arrow1);
      }
    else
      {
        fail ("ARC_DIMENSION.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", arc_dimension->flip_arrow1, flip_arrow1);
        error++;
      }
    arc_dimension->flip_arrow1--;

  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == arc_dimension->flip_arrow2)
      {
        pass ("ARC_DIMENSION.flip_arrow2 [B] " FORMAT_B "", flip_arrow2);
      }
    else
      {
        fail ("ARC_DIMENSION.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", arc_dimension->flip_arrow2, flip_arrow2);
        error++;
      }
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "flip_arrow2", &flip_arrow2)
        && flip_arrow2 == arc_dimension->flip_arrow2)
      {
        pass ("ARC_DIMENSION.flip_arrow2 [B] set+1 " FORMAT_B "", flip_arrow2);
      }
    else
      {
        fail ("ARC_DIMENSION.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", arc_dimension->flip_arrow2, flip_arrow2);
        error++;
      }
    arc_dimension->flip_arrow2--;

  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == arc_dimension->horiz_dir)
      {
        pass ("ARC_DIMENSION.horiz_dir [BD] %g", horiz_dir);
      }
    else
      {
        fail ("ARC_DIMENSION.horiz_dir [BD] %g != %g", arc_dimension->horiz_dir, horiz_dir);
        error++;
      }
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "horiz_dir", &horiz_dir)
        && horiz_dir == arc_dimension->horiz_dir)
      {
        pass ("ARC_DIMENSION.horiz_dir [BD] set+1 %g", horiz_dir);
      }
    else
      {
        fail ("ARC_DIMENSION.horiz_dir [BD] set+1 %g != %g", arc_dimension->horiz_dir, horiz_dir);
        error++;
      }
    arc_dimension->horiz_dir--;

  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == arc_dimension->ins_rotation)
      {
        pass ("ARC_DIMENSION.ins_rotation [BD] %g", ins_rotation);
      }
    else
      {
        fail ("ARC_DIMENSION.ins_rotation [BD] %g != %g", arc_dimension->ins_rotation, ins_rotation);
        error++;
      }
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "ins_rotation", &ins_rotation)
        && ins_rotation == arc_dimension->ins_rotation)
      {
        pass ("ARC_DIMENSION.ins_rotation [BD] set+1 %g", ins_rotation);
      }
    else
      {
        fail ("ARC_DIMENSION.ins_rotation [BD] set+1 %g != %g", arc_dimension->ins_rotation, ins_rotation);
        error++;
      }
    arc_dimension->ins_rotation--;

  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &arc_dimension->ins_scale, sizeof (arc_dimension->ins_scale)))
      {
        pass ("ARC_DIMENSION.ins_scale [3BD]");
      }
    else
      {
        fail ("ARC_DIMENSION.ins_scale [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD leader_len;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "leader_len", &leader_len, NULL)
        && leader_len == arc_dimension->leader_len)
      {
        pass ("ARC_DIMENSION.leader_len [BD] %g", leader_len);
      }
    else
      {
        fail ("ARC_DIMENSION.leader_len [BD] %g != %g", arc_dimension->leader_len, leader_len);
        error++;
      }
    leader_len++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "leader_len", &leader_len)
        && leader_len == arc_dimension->leader_len)
      {
        pass ("ARC_DIMENSION.leader_len [BD] set+1 %g", leader_len);
      }
    else
      {
        fail ("ARC_DIMENSION.leader_len [BD] set+1 %g != %g", arc_dimension->leader_len, leader_len);
        error++;
      }
    arc_dimension->leader_len--;

  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == arc_dimension->lspace_factor)
      {
        pass ("ARC_DIMENSION.lspace_factor [BD] %g", lspace_factor);
      }
    else
      {
        fail ("ARC_DIMENSION.lspace_factor [BD] %g != %g", arc_dimension->lspace_factor, lspace_factor);
        error++;
      }
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "lspace_factor", &lspace_factor)
        && lspace_factor == arc_dimension->lspace_factor)
      {
        pass ("ARC_DIMENSION.lspace_factor [BD] set+1 %g", lspace_factor);
      }
    else
      {
        fail ("ARC_DIMENSION.lspace_factor [BD] set+1 %g != %g", arc_dimension->lspace_factor, lspace_factor);
        error++;
      }
    arc_dimension->lspace_factor--;

  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "lspace_style", &lspace_style, NULL)
        && lspace_style == arc_dimension->lspace_style)
      {
        pass ("ARC_DIMENSION.lspace_style [BS] %hu", lspace_style);
      }
    else
      {
        fail ("ARC_DIMENSION.lspace_style [BS] %hu != %hu", arc_dimension->lspace_style, lspace_style);
        error++;
      }
    lspace_style++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "lspace_style", &lspace_style)
        && lspace_style == arc_dimension->lspace_style)
      {
        pass ("ARC_DIMENSION.lspace_style [BS] set+1 %hu", lspace_style);
      }
    else
      {
        fail ("ARC_DIMENSION.lspace_style [BS] set+1 %hu != %hu", arc_dimension->lspace_style, lspace_style);
        error++;
      }
    arc_dimension->lspace_style--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "parent", &parent, NULL)
        && !memcmp (&parent, &arc_dimension->parent, sizeof (arc_dimension->parent)))
      {
        pass ("ARC_DIMENSION.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("ARC_DIMENSION.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &arc_dimension->text_midpt, sizeof (arc_dimension->text_midpt)))
      {
        pass ("ARC_DIMENSION.text_midpt [2RD]");
      }
    else
      {
        fail ("ARC_DIMENSION.text_midpt [2RD]");
        error++;
      }
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "text_rotation", &text_rotation, NULL)
        && text_rotation == arc_dimension->text_rotation)
      {
        pass ("ARC_DIMENSION.text_rotation [BD] %g", text_rotation);
      }
    else
      {
        fail ("ARC_DIMENSION.text_rotation [BD] %g != %g", arc_dimension->text_rotation, text_rotation);
        error++;
      }
    text_rotation++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "text_rotation", &text_rotation)
        && text_rotation == arc_dimension->text_rotation)
      {
        pass ("ARC_DIMENSION.text_rotation [BD] set+1 %g", text_rotation);
      }
    else
      {
        fail ("ARC_DIMENSION.text_rotation [BD] set+1 %g != %g", arc_dimension->text_rotation, text_rotation);
        error++;
      }
    arc_dimension->text_rotation--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "unknown", &unknown, NULL)
        && unknown == arc_dimension->unknown)
      {
        pass ("ARC_DIMENSION.unknown [B] " FORMAT_B "", unknown);
      }
    else
      {
        fail ("ARC_DIMENSION.unknown [B] " FORMAT_B " != " FORMAT_B "", arc_dimension->unknown, unknown);
        error++;
      }
    unknown++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "unknown", &unknown)
        && unknown == arc_dimension->unknown)
      {
        pass ("ARC_DIMENSION.unknown [B] set+1 " FORMAT_B "", unknown);
      }
    else
      {
        fail ("ARC_DIMENSION.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", arc_dimension->unknown, unknown);
        error++;
      }
    arc_dimension->unknown--;

  }
  {
    BITCODE_3BD unknown_pt;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "unknown_pt", &unknown_pt, NULL)
        && !memcmp (&unknown_pt, &arc_dimension->unknown_pt, sizeof (arc_dimension->unknown_pt)))
      {
        pass ("ARC_DIMENSION.unknown_pt [3BD]");
      }
    else
      {
        fail ("ARC_DIMENSION.unknown_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value(arc_dimension, "ARC_DIMENSION", "user_text", &user_text, NULL)
        && !strcmp ((char *)user_text, (char *)arc_dimension->user_text))
      {
        pass ("ARC_DIMENSION.user_text [TV] '%s' <> '%s'", user_text, arc_dimension->user_text);
      }
    else
      {
        fail ("ARC_DIMENSION.user_text [TV] '%s' <> '%s'", user_text, arc_dimension->user_text);
        error++;
      }
  }
  return error;
}
static int test_ATTDEF (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ATTDEF *restrict attdef = obj->tio.entity->tio.ATTDEF;
  {
    BITCODE_2DPOINT alignment_pt;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "alignment_pt", &alignment_pt, NULL)
        && !memcmp (&alignment_pt, &attdef->alignment_pt, sizeof (attdef->alignment_pt)))
      {
        pass ("ATTDEF.alignment_pt [2DPOINT]");
      }
    else
      {
        fail ("ATTDEF.alignment_pt [2DPOINT]");
        error++;
      }
  }
  {
    BITCODE_H annotative_app;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "annotative_app", &annotative_app, NULL)
        && !memcmp (&annotative_app, &attdef->annotative_app, sizeof (attdef->annotative_app)))
      {
        pass ("ATTDEF.annotative_app [H]");
      }
    else
      {
        fail ("ATTDEF.annotative_app [H]");
        error++;
      }
  }
  {
    BITCODE_RC annotative_data_bytes;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "annotative_data_bytes", &annotative_data_bytes, NULL)
        && annotative_data_bytes == attdef->annotative_data_bytes)
      {
        pass ("ATTDEF.annotative_data_bytes [RC] %u", annotative_data_bytes);
      }
    else
      {
        fail ("ATTDEF.annotative_data_bytes [RC] %u != %u", attdef->annotative_data_bytes, annotative_data_bytes);
        error++;
      }
    annotative_data_bytes++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "annotative_data_bytes", &annotative_data_bytes)
        && annotative_data_bytes == attdef->annotative_data_bytes)
      {
        pass ("ATTDEF.annotative_data_bytes [RC] set+1 %u", annotative_data_bytes);
      }
    else
      {
        fail ("ATTDEF.annotative_data_bytes [RC] set+1 %u != %u", attdef->annotative_data_bytes, annotative_data_bytes);
        error++;
      }
    attdef->annotative_data_bytes--;

  }
  {
    BITCODE_BS annotative_data_size;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "annotative_data_size", &annotative_data_size, NULL)
        && annotative_data_size == attdef->annotative_data_size)
      {
        pass ("ATTDEF.annotative_data_size [BS] %hu", annotative_data_size);
      }
    else
      {
        fail ("ATTDEF.annotative_data_size [BS] %hu != %hu", attdef->annotative_data_size, annotative_data_size);
        error++;
      }
    annotative_data_size++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "annotative_data_size", &annotative_data_size)
        && annotative_data_size == attdef->annotative_data_size)
      {
        pass ("ATTDEF.annotative_data_size [BS] set+1 %hu", annotative_data_size);
      }
    else
      {
        fail ("ATTDEF.annotative_data_size [BS] set+1 %hu != %hu", attdef->annotative_data_size, annotative_data_size);
        error++;
      }
    attdef->annotative_data_size--;

  }
  {
    BITCODE_BS annotative_short;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "annotative_short", &annotative_short, NULL)
        && annotative_short == attdef->annotative_short)
      {
        pass ("ATTDEF.annotative_short [BS] %hu", annotative_short);
      }
    else
      {
        fail ("ATTDEF.annotative_short [BS] %hu != %hu", attdef->annotative_short, annotative_short);
        error++;
      }
    annotative_short++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "annotative_short", &annotative_short)
        && annotative_short == attdef->annotative_short)
      {
        pass ("ATTDEF.annotative_short [BS] set+1 %hu", annotative_short);
      }
    else
      {
        fail ("ATTDEF.annotative_short [BS] set+1 %hu != %hu", attdef->annotative_short, annotative_short);
        error++;
      }
    attdef->annotative_short--;

  }
  {
    BITCODE_RC attdef_class_version;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "attdef_class_version", &attdef_class_version, NULL)
        && attdef_class_version == attdef->attdef_class_version)
      {
        pass ("ATTDEF.attdef_class_version [RC] %u", attdef_class_version);
      }
    else
      {
        fail ("ATTDEF.attdef_class_version [RC] %u != %u", attdef->attdef_class_version, attdef_class_version);
        error++;
      }
    attdef_class_version++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "attdef_class_version", &attdef_class_version)
        && attdef_class_version == attdef->attdef_class_version)
      {
        pass ("ATTDEF.attdef_class_version [RC] set+1 %u", attdef_class_version);
      }
    else
      {
        fail ("ATTDEF.attdef_class_version [RC] set+1 %u != %u", attdef->attdef_class_version, attdef_class_version);
        error++;
      }
    attdef->attdef_class_version--;

  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "class_version", &class_version, NULL)
        && class_version == attdef->class_version)
      {
        pass ("ATTDEF.class_version [RC] %u", class_version);
      }
    else
      {
        fail ("ATTDEF.class_version [RC] %u != %u", attdef->class_version, class_version);
        error++;
      }
    class_version++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "class_version", &class_version)
        && class_version == attdef->class_version)
      {
        pass ("ATTDEF.class_version [RC] set+1 %u", class_version);
      }
    else
      {
        fail ("ATTDEF.class_version [RC] set+1 %u != %u", attdef->class_version, class_version);
        error++;
      }
    attdef->class_version--;

  }
  {
    BITCODE_RC dataflags;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "dataflags", &dataflags, NULL)
        && dataflags == attdef->dataflags)
      {
        pass ("ATTDEF.dataflags [RC] %u", dataflags);
      }
    else
      {
        fail ("ATTDEF.dataflags [RC] %u != %u", attdef->dataflags, dataflags);
        error++;
      }
    dataflags++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "dataflags", &dataflags)
        && dataflags == attdef->dataflags)
      {
        pass ("ATTDEF.dataflags [RC] set+1 %u", dataflags);
      }
    else
      {
        fail ("ATTDEF.dataflags [RC] set+1 %u != %u", attdef->dataflags, dataflags);
        error++;
      }
    attdef->dataflags--;

  }
  {
    BITCODE_TV default_value;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "default_value", &default_value, NULL)
        && !strcmp ((char *)default_value, (char *)attdef->default_value))
      {
        pass ("ATTDEF.default_value [TV] '%s' <> '%s'", default_value, attdef->default_value);
      }
    else
      {
        fail ("ATTDEF.default_value [TV] '%s' <> '%s'", default_value, attdef->default_value);
        error++;
      }
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "elevation", &elevation, NULL)
        && elevation == attdef->elevation)
      {
        pass ("ATTDEF.elevation [BD] %g", elevation);
      }
    else
      {
        fail ("ATTDEF.elevation [BD] %g != %g", attdef->elevation, elevation);
        error++;
      }
    elevation++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "elevation", &elevation)
        && elevation == attdef->elevation)
      {
        pass ("ATTDEF.elevation [BD] set+1 %g", elevation);
      }
    else
      {
        fail ("ATTDEF.elevation [BD] set+1 %g != %g", attdef->elevation, elevation);
        error++;
      }
    attdef->elevation--;

  }
  {
    BITCODE_3DPOINT extrusion;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &attdef->extrusion, sizeof (attdef->extrusion)))
      {
        pass ("ATTDEF.extrusion [3DPOINT]");
      }
    else
      {
        fail ("ATTDEF.extrusion [3DPOINT]");
        error++;
      }
  }
  {
    BITCODE_BS field_length;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "field_length", &field_length, NULL)
        && field_length == attdef->field_length)
      {
        pass ("ATTDEF.field_length [BS] %hu", field_length);
      }
    else
      {
        fail ("ATTDEF.field_length [BS] %hu != %hu", attdef->field_length, field_length);
        error++;
      }
    field_length++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "field_length", &field_length)
        && field_length == attdef->field_length)
      {
        pass ("ATTDEF.field_length [BS] set+1 %hu", field_length);
      }
    else
      {
        fail ("ATTDEF.field_length [BS] set+1 %hu != %hu", attdef->field_length, field_length);
        error++;
      }
    attdef->field_length--;

  }
  {
    BITCODE_RC flags;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "flags", &flags, NULL)
        && flags == attdef->flags)
      {
        pass ("ATTDEF.flags [RC] %u", flags);
      }
    else
      {
        fail ("ATTDEF.flags [RC] %u != %u", attdef->flags, flags);
        error++;
      }
    flags++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "flags", &flags)
        && flags == attdef->flags)
      {
        pass ("ATTDEF.flags [RC] set+1 %u", flags);
      }
    else
      {
        fail ("ATTDEF.flags [RC] set+1 %u != %u", attdef->flags, flags);
        error++;
      }
    attdef->flags--;

  }
  {
    BITCODE_BS generation;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "generation", &generation, NULL)
        && generation == attdef->generation)
      {
        pass ("ATTDEF.generation [BS] %hu", generation);
      }
    else
      {
        fail ("ATTDEF.generation [BS] %hu != %hu", attdef->generation, generation);
        error++;
      }
    generation++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "generation", &generation)
        && generation == attdef->generation)
      {
        pass ("ATTDEF.generation [BS] set+1 %hu", generation);
      }
    else
      {
        fail ("ATTDEF.generation [BS] set+1 %hu != %hu", attdef->generation, generation);
        error++;
      }
    attdef->generation--;

  }
  {
    BITCODE_RD height;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "height", &height, NULL)
        && height == attdef->height)
      {
        pass ("ATTDEF.height [RD] %g", height);
      }
    else
      {
        fail ("ATTDEF.height [RD] %g != %g", attdef->height, height);
        error++;
      }
    height++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "height", &height)
        && height == attdef->height)
      {
        pass ("ATTDEF.height [RD] set+1 %g", height);
      }
    else
      {
        fail ("ATTDEF.height [RD] set+1 %g != %g", attdef->height, height);
        error++;
      }
    attdef->height--;

  }
  {
    BITCODE_BS horiz_alignment;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "horiz_alignment", &horiz_alignment, NULL)
        && horiz_alignment == attdef->horiz_alignment)
      {
        pass ("ATTDEF.horiz_alignment [BS] %hu", horiz_alignment);
      }
    else
      {
        fail ("ATTDEF.horiz_alignment [BS] %hu != %hu", attdef->horiz_alignment, horiz_alignment);
        error++;
      }
    horiz_alignment++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "horiz_alignment", &horiz_alignment)
        && horiz_alignment == attdef->horiz_alignment)
      {
        pass ("ATTDEF.horiz_alignment [BS] set+1 %hu", horiz_alignment);
      }
    else
      {
        fail ("ATTDEF.horiz_alignment [BS] set+1 %hu != %hu", attdef->horiz_alignment, horiz_alignment);
        error++;
      }
    attdef->horiz_alignment--;

  }
  {
    BITCODE_2DPOINT insertion_pt;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "insertion_pt", &insertion_pt, NULL)
        && !memcmp (&insertion_pt, &attdef->insertion_pt, sizeof (attdef->insertion_pt)))
      {
        pass ("ATTDEF.insertion_pt [2DPOINT]");
      }
    else
      {
        fail ("ATTDEF.insertion_pt [2DPOINT]");
        error++;
      }
  }
  {
    BITCODE_B lock_position_flag;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "lock_position_flag", &lock_position_flag, NULL)
        && lock_position_flag == attdef->lock_position_flag)
      {
        pass ("ATTDEF.lock_position_flag [B] " FORMAT_B "", lock_position_flag);
      }
    else
      {
        fail ("ATTDEF.lock_position_flag [B] " FORMAT_B " != " FORMAT_B "", attdef->lock_position_flag, lock_position_flag);
        error++;
      }
    lock_position_flag++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "lock_position_flag", &lock_position_flag)
        && lock_position_flag == attdef->lock_position_flag)
      {
        pass ("ATTDEF.lock_position_flag [B] set+1 " FORMAT_B "", lock_position_flag);
      }
    else
      {
        fail ("ATTDEF.lock_position_flag [B] set+1 " FORMAT_B " != " FORMAT_B "", attdef->lock_position_flag, lock_position_flag);
        error++;
      }
    attdef->lock_position_flag--;

  }
  {
    BITCODE_H mtext_handles;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "mtext_handles", &mtext_handles, NULL)
        && !memcmp (&mtext_handles, &attdef->mtext_handles, sizeof (attdef->mtext_handles)))
      {
        pass ("ATTDEF.mtext_handles [H]");
      }
    else
      {
        fail ("ATTDEF.mtext_handles [H]");
        error++;
      }
  }
  {
    BITCODE_RD oblique_ang;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "oblique_ang", &oblique_ang, NULL)
        && oblique_ang == attdef->oblique_ang)
      {
        pass ("ATTDEF.oblique_ang [RD] %g", oblique_ang);
      }
    else
      {
        fail ("ATTDEF.oblique_ang [RD] %g != %g", attdef->oblique_ang, oblique_ang);
        error++;
      }
    oblique_ang++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "oblique_ang", &oblique_ang)
        && oblique_ang == attdef->oblique_ang)
      {
        pass ("ATTDEF.oblique_ang [RD] set+1 %g", oblique_ang);
      }
    else
      {
        fail ("ATTDEF.oblique_ang [RD] set+1 %g != %g", attdef->oblique_ang, oblique_ang);
        error++;
      }
    attdef->oblique_ang--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "parent", &parent, NULL)
        && !memcmp (&parent, &attdef->parent, sizeof (attdef->parent)))
      {
        pass ("ATTDEF.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("ATTDEF.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_TV prompt;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "prompt", &prompt, NULL)
        && !strcmp ((char *)prompt, (char *)attdef->prompt))
      {
        pass ("ATTDEF.prompt [TV] '%s' <> '%s'", prompt, attdef->prompt);
      }
    else
      {
        fail ("ATTDEF.prompt [TV] '%s' <> '%s'", prompt, attdef->prompt);
        error++;
      }
  }
  {
    BITCODE_RD rotation;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "rotation", &rotation, NULL)
        && rotation == attdef->rotation)
      {
        pass ("ATTDEF.rotation [RD] %g", rotation);
      }
    else
      {
        fail ("ATTDEF.rotation [RD] %g != %g", attdef->rotation, rotation);
        error++;
      }
    rotation++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "rotation", &rotation)
        && rotation == attdef->rotation)
      {
        pass ("ATTDEF.rotation [RD] set+1 %g", rotation);
      }
    else
      {
        fail ("ATTDEF.rotation [RD] set+1 %g != %g", attdef->rotation, rotation);
        error++;
      }
    attdef->rotation--;

  }
  {
    BITCODE_H style;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "style", &style, NULL)
        && !memcmp (&style, &attdef->style, sizeof (attdef->style)))
      {
        pass ("ATTDEF.style [H]");
      }
    else
      {
        fail ("ATTDEF.style [H]");
        error++;
      }
  }
  {
    BITCODE_TV tag;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "tag", &tag, NULL)
        && !strcmp ((char *)tag, (char *)attdef->tag))
      {
        pass ("ATTDEF.tag [TV] '%s' <> '%s'", tag, attdef->tag);
      }
    else
      {
        fail ("ATTDEF.tag [TV] '%s' <> '%s'", tag, attdef->tag);
        error++;
      }
  }
  {
    BITCODE_RD thickness;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "thickness", &thickness, NULL)
        && thickness == attdef->thickness)
      {
        pass ("ATTDEF.thickness [RD] %g", thickness);
      }
    else
      {
        fail ("ATTDEF.thickness [RD] %g != %g", attdef->thickness, thickness);
        error++;
      }
    thickness++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "thickness", &thickness)
        && thickness == attdef->thickness)
      {
        pass ("ATTDEF.thickness [RD] set+1 %g", thickness);
      }
    else
      {
        fail ("ATTDEF.thickness [RD] set+1 %g != %g", attdef->thickness, thickness);
        error++;
      }
    attdef->thickness--;

  }
  {
    BITCODE_RC type;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "type", &type, NULL)
        && type == attdef->type)
      {
        pass ("ATTDEF.type [RC] %u", type);
      }
    else
      {
        fail ("ATTDEF.type [RC] %u != %u", attdef->type, type);
        error++;
      }
    type++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "type", &type)
        && type == attdef->type)
      {
        pass ("ATTDEF.type [RC] set+1 %u", type);
      }
    else
      {
        fail ("ATTDEF.type [RC] set+1 %u != %u", attdef->type, type);
        error++;
      }
    attdef->type--;

  }
  {
    BITCODE_BS vert_alignment;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "vert_alignment", &vert_alignment, NULL)
        && vert_alignment == attdef->vert_alignment)
      {
        pass ("ATTDEF.vert_alignment [BS] %hu", vert_alignment);
      }
    else
      {
        fail ("ATTDEF.vert_alignment [BS] %hu != %hu", attdef->vert_alignment, vert_alignment);
        error++;
      }
    vert_alignment++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "vert_alignment", &vert_alignment)
        && vert_alignment == attdef->vert_alignment)
      {
        pass ("ATTDEF.vert_alignment [BS] set+1 %hu", vert_alignment);
      }
    else
      {
        fail ("ATTDEF.vert_alignment [BS] set+1 %hu != %hu", attdef->vert_alignment, vert_alignment);
        error++;
      }
    attdef->vert_alignment--;

  }
  {
    BITCODE_RD width_factor;
    if (dwg_dynapi_entity_value(attdef, "ATTDEF", "width_factor", &width_factor, NULL)
        && width_factor == attdef->width_factor)
      {
        pass ("ATTDEF.width_factor [RD] %g", width_factor);
      }
    else
      {
        fail ("ATTDEF.width_factor [RD] %g != %g", attdef->width_factor, width_factor);
        error++;
      }
    width_factor++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "width_factor", &width_factor)
        && width_factor == attdef->width_factor)
      {
        pass ("ATTDEF.width_factor [RD] set+1 %g", width_factor);
      }
    else
      {
        fail ("ATTDEF.width_factor [RD] set+1 %g != %g", attdef->width_factor, width_factor);
        error++;
      }
    attdef->width_factor--;

  }
  return error;
}
static int test_ATTRIB (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ATTRIB *restrict attrib = obj->tio.entity->tio.ATTRIB;
  {
    BITCODE_2DPOINT alignment_pt;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "alignment_pt", &alignment_pt, NULL)
        && !memcmp (&alignment_pt, &attrib->alignment_pt, sizeof (attrib->alignment_pt)))
      {
        pass ("ATTRIB.alignment_pt [2DPOINT]");
      }
    else
      {
        fail ("ATTRIB.alignment_pt [2DPOINT]");
        error++;
      }
  }
  {
    BITCODE_H annotative_app;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "annotative_app", &annotative_app, NULL)
        && !memcmp (&annotative_app, &attrib->annotative_app, sizeof (attrib->annotative_app)))
      {
        pass ("ATTRIB.annotative_app [H]");
      }
    else
      {
        fail ("ATTRIB.annotative_app [H]");
        error++;
      }
  }
  {
    BITCODE_RC annotative_data_bytes;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "annotative_data_bytes", &annotative_data_bytes, NULL)
        && annotative_data_bytes == attrib->annotative_data_bytes)
      {
        pass ("ATTRIB.annotative_data_bytes [RC] %u", annotative_data_bytes);
      }
    else
      {
        fail ("ATTRIB.annotative_data_bytes [RC] %u != %u", attrib->annotative_data_bytes, annotative_data_bytes);
        error++;
      }
    annotative_data_bytes++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "annotative_data_bytes", &annotative_data_bytes)
        && annotative_data_bytes == attrib->annotative_data_bytes)
      {
        pass ("ATTRIB.annotative_data_bytes [RC] set+1 %u", annotative_data_bytes);
      }
    else
      {
        fail ("ATTRIB.annotative_data_bytes [RC] set+1 %u != %u", attrib->annotative_data_bytes, annotative_data_bytes);
        error++;
      }
    attrib->annotative_data_bytes--;

  }
  {
    BITCODE_BS annotative_data_size;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "annotative_data_size", &annotative_data_size, NULL)
        && annotative_data_size == attrib->annotative_data_size)
      {
        pass ("ATTRIB.annotative_data_size [BS] %hu", annotative_data_size);
      }
    else
      {
        fail ("ATTRIB.annotative_data_size [BS] %hu != %hu", attrib->annotative_data_size, annotative_data_size);
        error++;
      }
    annotative_data_size++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "annotative_data_size", &annotative_data_size)
        && annotative_data_size == attrib->annotative_data_size)
      {
        pass ("ATTRIB.annotative_data_size [BS] set+1 %hu", annotative_data_size);
      }
    else
      {
        fail ("ATTRIB.annotative_data_size [BS] set+1 %hu != %hu", attrib->annotative_data_size, annotative_data_size);
        error++;
      }
    attrib->annotative_data_size--;

  }
  {
    BITCODE_BS annotative_short;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "annotative_short", &annotative_short, NULL)
        && annotative_short == attrib->annotative_short)
      {
        pass ("ATTRIB.annotative_short [BS] %hu", annotative_short);
      }
    else
      {
        fail ("ATTRIB.annotative_short [BS] %hu != %hu", attrib->annotative_short, annotative_short);
        error++;
      }
    annotative_short++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "annotative_short", &annotative_short)
        && annotative_short == attrib->annotative_short)
      {
        pass ("ATTRIB.annotative_short [BS] set+1 %hu", annotative_short);
      }
    else
      {
        fail ("ATTRIB.annotative_short [BS] set+1 %hu != %hu", attrib->annotative_short, annotative_short);
        error++;
      }
    attrib->annotative_short--;

  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "class_version", &class_version, NULL)
        && class_version == attrib->class_version)
      {
        pass ("ATTRIB.class_version [RC] %u", class_version);
      }
    else
      {
        fail ("ATTRIB.class_version [RC] %u != %u", attrib->class_version, class_version);
        error++;
      }
    class_version++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "class_version", &class_version)
        && class_version == attrib->class_version)
      {
        pass ("ATTRIB.class_version [RC] set+1 %u", class_version);
      }
    else
      {
        fail ("ATTRIB.class_version [RC] set+1 %u != %u", attrib->class_version, class_version);
        error++;
      }
    attrib->class_version--;

  }
  {
    BITCODE_RC dataflags;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "dataflags", &dataflags, NULL)
        && dataflags == attrib->dataflags)
      {
        pass ("ATTRIB.dataflags [RC] %u", dataflags);
      }
    else
      {
        fail ("ATTRIB.dataflags [RC] %u != %u", attrib->dataflags, dataflags);
        error++;
      }
    dataflags++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "dataflags", &dataflags)
        && dataflags == attrib->dataflags)
      {
        pass ("ATTRIB.dataflags [RC] set+1 %u", dataflags);
      }
    else
      {
        fail ("ATTRIB.dataflags [RC] set+1 %u != %u", attrib->dataflags, dataflags);
        error++;
      }
    attrib->dataflags--;

  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "elevation", &elevation, NULL)
        && elevation == attrib->elevation)
      {
        pass ("ATTRIB.elevation [BD] %g", elevation);
      }
    else
      {
        fail ("ATTRIB.elevation [BD] %g != %g", attrib->elevation, elevation);
        error++;
      }
    elevation++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "elevation", &elevation)
        && elevation == attrib->elevation)
      {
        pass ("ATTRIB.elevation [BD] set+1 %g", elevation);
      }
    else
      {
        fail ("ATTRIB.elevation [BD] set+1 %g != %g", attrib->elevation, elevation);
        error++;
      }
    attrib->elevation--;

  }
  {
    BITCODE_3DPOINT extrusion;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &attrib->extrusion, sizeof (attrib->extrusion)))
      {
        pass ("ATTRIB.extrusion [3DPOINT]");
      }
    else
      {
        fail ("ATTRIB.extrusion [3DPOINT]");
        error++;
      }
  }
  {
    BITCODE_BS field_length;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "field_length", &field_length, NULL)
        && field_length == attrib->field_length)
      {
        pass ("ATTRIB.field_length [BS] %hu", field_length);
      }
    else
      {
        fail ("ATTRIB.field_length [BS] %hu != %hu", attrib->field_length, field_length);
        error++;
      }
    field_length++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "field_length", &field_length)
        && field_length == attrib->field_length)
      {
        pass ("ATTRIB.field_length [BS] set+1 %hu", field_length);
      }
    else
      {
        fail ("ATTRIB.field_length [BS] set+1 %hu != %hu", attrib->field_length, field_length);
        error++;
      }
    attrib->field_length--;

  }
  {
    BITCODE_RC flags;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "flags", &flags, NULL)
        && flags == attrib->flags)
      {
        pass ("ATTRIB.flags [RC] %u", flags);
      }
    else
      {
        fail ("ATTRIB.flags [RC] %u != %u", attrib->flags, flags);
        error++;
      }
    flags++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "flags", &flags)
        && flags == attrib->flags)
      {
        pass ("ATTRIB.flags [RC] set+1 %u", flags);
      }
    else
      {
        fail ("ATTRIB.flags [RC] set+1 %u != %u", attrib->flags, flags);
        error++;
      }
    attrib->flags--;

  }
  {
    BITCODE_BS generation;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "generation", &generation, NULL)
        && generation == attrib->generation)
      {
        pass ("ATTRIB.generation [BS] %hu", generation);
      }
    else
      {
        fail ("ATTRIB.generation [BS] %hu != %hu", attrib->generation, generation);
        error++;
      }
    generation++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "generation", &generation)
        && generation == attrib->generation)
      {
        pass ("ATTRIB.generation [BS] set+1 %hu", generation);
      }
    else
      {
        fail ("ATTRIB.generation [BS] set+1 %hu != %hu", attrib->generation, generation);
        error++;
      }
    attrib->generation--;

  }
  {
    BITCODE_RD height;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "height", &height, NULL)
        && height == attrib->height)
      {
        pass ("ATTRIB.height [RD] %g", height);
      }
    else
      {
        fail ("ATTRIB.height [RD] %g != %g", attrib->height, height);
        error++;
      }
    height++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "height", &height)
        && height == attrib->height)
      {
        pass ("ATTRIB.height [RD] set+1 %g", height);
      }
    else
      {
        fail ("ATTRIB.height [RD] set+1 %g != %g", attrib->height, height);
        error++;
      }
    attrib->height--;

  }
  {
    BITCODE_BS horiz_alignment;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "horiz_alignment", &horiz_alignment, NULL)
        && horiz_alignment == attrib->horiz_alignment)
      {
        pass ("ATTRIB.horiz_alignment [BS] %hu", horiz_alignment);
      }
    else
      {
        fail ("ATTRIB.horiz_alignment [BS] %hu != %hu", attrib->horiz_alignment, horiz_alignment);
        error++;
      }
    horiz_alignment++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "horiz_alignment", &horiz_alignment)
        && horiz_alignment == attrib->horiz_alignment)
      {
        pass ("ATTRIB.horiz_alignment [BS] set+1 %hu", horiz_alignment);
      }
    else
      {
        fail ("ATTRIB.horiz_alignment [BS] set+1 %hu != %hu", attrib->horiz_alignment, horiz_alignment);
        error++;
      }
    attrib->horiz_alignment--;

  }
  {
    BITCODE_2DPOINT insertion_pt;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "insertion_pt", &insertion_pt, NULL)
        && !memcmp (&insertion_pt, &attrib->insertion_pt, sizeof (attrib->insertion_pt)))
      {
        pass ("ATTRIB.insertion_pt [2DPOINT]");
      }
    else
      {
        fail ("ATTRIB.insertion_pt [2DPOINT]");
        error++;
      }
  }
  {
    BITCODE_B lock_position_flag;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "lock_position_flag", &lock_position_flag, NULL)
        && lock_position_flag == attrib->lock_position_flag)
      {
        pass ("ATTRIB.lock_position_flag [B] " FORMAT_B "", lock_position_flag);
      }
    else
      {
        fail ("ATTRIB.lock_position_flag [B] " FORMAT_B " != " FORMAT_B "", attrib->lock_position_flag, lock_position_flag);
        error++;
      }
    lock_position_flag++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "lock_position_flag", &lock_position_flag)
        && lock_position_flag == attrib->lock_position_flag)
      {
        pass ("ATTRIB.lock_position_flag [B] set+1 " FORMAT_B "", lock_position_flag);
      }
    else
      {
        fail ("ATTRIB.lock_position_flag [B] set+1 " FORMAT_B " != " FORMAT_B "", attrib->lock_position_flag, lock_position_flag);
        error++;
      }
    attrib->lock_position_flag--;

  }
  {
    BITCODE_H mtext_handles;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "mtext_handles", &mtext_handles, NULL)
        && !memcmp (&mtext_handles, &attrib->mtext_handles, sizeof (attrib->mtext_handles)))
      {
        pass ("ATTRIB.mtext_handles [H]");
      }
    else
      {
        fail ("ATTRIB.mtext_handles [H]");
        error++;
      }
  }
  {
    BITCODE_RD oblique_ang;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "oblique_ang", &oblique_ang, NULL)
        && oblique_ang == attrib->oblique_ang)
      {
        pass ("ATTRIB.oblique_ang [RD] %g", oblique_ang);
      }
    else
      {
        fail ("ATTRIB.oblique_ang [RD] %g != %g", attrib->oblique_ang, oblique_ang);
        error++;
      }
    oblique_ang++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "oblique_ang", &oblique_ang)
        && oblique_ang == attrib->oblique_ang)
      {
        pass ("ATTRIB.oblique_ang [RD] set+1 %g", oblique_ang);
      }
    else
      {
        fail ("ATTRIB.oblique_ang [RD] set+1 %g != %g", attrib->oblique_ang, oblique_ang);
        error++;
      }
    attrib->oblique_ang--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "parent", &parent, NULL)
        && !memcmp (&parent, &attrib->parent, sizeof (attrib->parent)))
      {
        pass ("ATTRIB.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("ATTRIB.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_RD rotation;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "rotation", &rotation, NULL)
        && rotation == attrib->rotation)
      {
        pass ("ATTRIB.rotation [RD] %g", rotation);
      }
    else
      {
        fail ("ATTRIB.rotation [RD] %g != %g", attrib->rotation, rotation);
        error++;
      }
    rotation++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "rotation", &rotation)
        && rotation == attrib->rotation)
      {
        pass ("ATTRIB.rotation [RD] set+1 %g", rotation);
      }
    else
      {
        fail ("ATTRIB.rotation [RD] set+1 %g != %g", attrib->rotation, rotation);
        error++;
      }
    attrib->rotation--;

  }
  {
    BITCODE_H style;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "style", &style, NULL)
        && !memcmp (&style, &attrib->style, sizeof (attrib->style)))
      {
        pass ("ATTRIB.style [H]");
      }
    else
      {
        fail ("ATTRIB.style [H]");
        error++;
      }
  }
  {
    BITCODE_TV tag;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "tag", &tag, NULL)
        && !strcmp ((char *)tag, (char *)attrib->tag))
      {
        pass ("ATTRIB.tag [TV] '%s' <> '%s'", tag, attrib->tag);
      }
    else
      {
        fail ("ATTRIB.tag [TV] '%s' <> '%s'", tag, attrib->tag);
        error++;
      }
  }
  {
    BITCODE_TV text_value;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "text_value", &text_value, NULL)
        && !strcmp ((char *)text_value, (char *)attrib->text_value))
      {
        pass ("ATTRIB.text_value [TV] '%s' <> '%s'", text_value, attrib->text_value);
      }
    else
      {
        fail ("ATTRIB.text_value [TV] '%s' <> '%s'", text_value, attrib->text_value);
        error++;
      }
  }
  {
    BITCODE_RD thickness;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "thickness", &thickness, NULL)
        && thickness == attrib->thickness)
      {
        pass ("ATTRIB.thickness [RD] %g", thickness);
      }
    else
      {
        fail ("ATTRIB.thickness [RD] %g != %g", attrib->thickness, thickness);
        error++;
      }
    thickness++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "thickness", &thickness)
        && thickness == attrib->thickness)
      {
        pass ("ATTRIB.thickness [RD] set+1 %g", thickness);
      }
    else
      {
        fail ("ATTRIB.thickness [RD] set+1 %g != %g", attrib->thickness, thickness);
        error++;
      }
    attrib->thickness--;

  }
  {
    BITCODE_RC type;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "type", &type, NULL)
        && type == attrib->type)
      {
        pass ("ATTRIB.type [RC] %u", type);
      }
    else
      {
        fail ("ATTRIB.type [RC] %u != %u", attrib->type, type);
        error++;
      }
    type++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "type", &type)
        && type == attrib->type)
      {
        pass ("ATTRIB.type [RC] set+1 %u", type);
      }
    else
      {
        fail ("ATTRIB.type [RC] set+1 %u != %u", attrib->type, type);
        error++;
      }
    attrib->type--;

  }
  {
    BITCODE_BS vert_alignment;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "vert_alignment", &vert_alignment, NULL)
        && vert_alignment == attrib->vert_alignment)
      {
        pass ("ATTRIB.vert_alignment [BS] %hu", vert_alignment);
      }
    else
      {
        fail ("ATTRIB.vert_alignment [BS] %hu != %hu", attrib->vert_alignment, vert_alignment);
        error++;
      }
    vert_alignment++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "vert_alignment", &vert_alignment)
        && vert_alignment == attrib->vert_alignment)
      {
        pass ("ATTRIB.vert_alignment [BS] set+1 %hu", vert_alignment);
      }
    else
      {
        fail ("ATTRIB.vert_alignment [BS] set+1 %hu != %hu", attrib->vert_alignment, vert_alignment);
        error++;
      }
    attrib->vert_alignment--;

  }
  {
    BITCODE_RD width_factor;
    if (dwg_dynapi_entity_value(attrib, "ATTRIB", "width_factor", &width_factor, NULL)
        && width_factor == attrib->width_factor)
      {
        pass ("ATTRIB.width_factor [RD] %g", width_factor);
      }
    else
      {
        fail ("ATTRIB.width_factor [RD] %g != %g", attrib->width_factor, width_factor);
        error++;
      }
    width_factor++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "width_factor", &width_factor)
        && width_factor == attrib->width_factor)
      {
        pass ("ATTRIB.width_factor [RD] set+1 %g", width_factor);
      }
    else
      {
        fail ("ATTRIB.width_factor [RD] set+1 %g != %g", attrib->width_factor, width_factor);
        error++;
      }
    attrib->width_factor--;

  }
  return error;
}
static int test_BLOCK (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_BLOCK *restrict block = obj->tio.entity->tio.BLOCK;
  {
    BITCODE_TV name;
    if (dwg_dynapi_entity_value(block, "BLOCK", "name", &name, NULL)
        && !strcmp ((char *)name, (char *)block->name))
      {
        pass ("BLOCK.name [TV] '%s' <> '%s'", name, block->name);
      }
    else
      {
        fail ("BLOCK.name [TV] '%s' <> '%s'", name, block->name);
        error++;
      }
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(block, "BLOCK", "parent", &parent, NULL)
        && !memcmp (&parent, &block->parent, sizeof (block->parent)))
      {
        pass ("BLOCK.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("BLOCK.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  return error;
}
static int test_CAMERA (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_CAMERA *restrict camera = obj->tio.entity->tio.CAMERA;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(camera, "CAMERA", "parent", &parent, NULL)
        && !memcmp (&parent, &camera->parent, sizeof (camera->parent)))
      {
        pass ("CAMERA.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("CAMERA.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_H view;
    if (dwg_dynapi_entity_value(camera, "CAMERA", "view", &view, NULL)
        && !memcmp (&view, &camera->view, sizeof (camera->view)))
      {
        pass ("CAMERA.view [H]");
      }
    else
      {
        fail ("CAMERA.view [H]");
        error++;
      }
  }
  return error;
}
static int test_CIRCLE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_CIRCLE *restrict circle = obj->tio.entity->tio.CIRCLE;
  {
    BITCODE_3BD center;
    if (dwg_dynapi_entity_value(circle, "CIRCLE", "center", &center, NULL)
        && !memcmp (&center, &circle->center, sizeof (circle->center)))
      {
        pass ("CIRCLE.center [3BD]");
      }
    else
      {
        fail ("CIRCLE.center [3BD]");
        error++;
      }
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value(circle, "CIRCLE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &circle->extrusion, sizeof (circle->extrusion)))
      {
        pass ("CIRCLE.extrusion [BE]");
      }
    else
      {
        fail ("CIRCLE.extrusion [BE]");
        error++;
      }
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(circle, "CIRCLE", "parent", &parent, NULL)
        && !memcmp (&parent, &circle->parent, sizeof (circle->parent)))
      {
        pass ("CIRCLE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("CIRCLE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_BD radius;
    if (dwg_dynapi_entity_value(circle, "CIRCLE", "radius", &radius, NULL)
        && radius == circle->radius)
      {
        pass ("CIRCLE.radius [BD] %g", radius);
      }
    else
      {
        fail ("CIRCLE.radius [BD] %g != %g", circle->radius, radius);
        error++;
      }
    radius++;
    if (dwg_dynapi_entity_set_value (circle, "CIRCLE", "radius", &radius)
        && radius == circle->radius)
      {
        pass ("CIRCLE.radius [BD] set+1 %g", radius);
      }
    else
      {
        fail ("CIRCLE.radius [BD] set+1 %g != %g", circle->radius, radius);
        error++;
      }
    circle->radius--;

  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value(circle, "CIRCLE", "thickness", &thickness, NULL)
        && thickness == circle->thickness)
      {
        pass ("CIRCLE.thickness [BT] " FORMAT_BT "", thickness);
      }
    else
      {
        fail ("CIRCLE.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", circle->thickness, thickness);
        error++;
      }
    if (dwg_dynapi_entity_set_value (circle, "CIRCLE", "thickness", &thickness)
        && thickness == circle->thickness)
      {
        pass ("CIRCLE.thickness [BT] set+1 " FORMAT_BT "", thickness);
      }
    else
      {
        fail ("CIRCLE.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", circle->thickness, thickness);
        error++;
      }
    circle->thickness--;

  }
  return error;
}
static int test_DIMENSION_ALIGNED (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_ALIGNED *restrict dimension_aligned = obj->tio.entity->tio.DIMENSION_ALIGNED;
  {
    BITCODE_3BD _13_pt;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "_13_pt", &_13_pt, NULL)
        && !memcmp (&_13_pt, &dimension_aligned->_13_pt, sizeof (dimension_aligned->_13_pt)))
      {
        pass ("DIMENSION_ALIGNED._13_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_ALIGNED._13_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD _14_pt;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "_14_pt", &_14_pt, NULL)
        && !memcmp (&_14_pt, &dimension_aligned->_14_pt, sizeof (dimension_aligned->_14_pt)))
      {
        pass ("DIMENSION_ALIGNED._14_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_ALIGNED._14_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_aligned->act_measurement)
      {
        pass ("DIMENSION_ALIGNED.act_measurement [BD] %g", act_measurement);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.act_measurement [BD] %g != %g", dimension_aligned->act_measurement, act_measurement);
        error++;
      }
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "act_measurement", &act_measurement)
        && act_measurement == dimension_aligned->act_measurement)
      {
        pass ("DIMENSION_ALIGNED.act_measurement [BD] set+1 %g", act_measurement);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.act_measurement [BD] set+1 %g != %g", dimension_aligned->act_measurement, act_measurement);
        error++;
      }
    dimension_aligned->act_measurement--;

  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "attachment", &attachment, NULL)
        && attachment == dimension_aligned->attachment)
      {
        pass ("DIMENSION_ALIGNED.attachment [BS] %hu", attachment);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.attachment [BS] %hu != %hu", dimension_aligned->attachment, attachment);
        error++;
      }
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "attachment", &attachment)
        && attachment == dimension_aligned->attachment)
      {
        pass ("DIMENSION_ALIGNED.attachment [BS] set+1 %hu", attachment);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.attachment [BS] set+1 %hu != %hu", dimension_aligned->attachment, attachment);
        error++;
      }
    dimension_aligned->attachment--;

  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "block", &block, NULL)
        && !memcmp (&block, &dimension_aligned->block, sizeof (dimension_aligned->block)))
      {
        pass ("DIMENSION_ALIGNED.block [H]");
      }
    else
      {
        fail ("DIMENSION_ALIGNED.block [H]");
        error++;
      }
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "blockname", &blockname, NULL)
        && !strcmp ((char *)blockname, (char *)dimension_aligned->blockname))
      {
        pass ("DIMENSION_ALIGNED.blockname [TV] '%s' <> '%s'", blockname, dimension_aligned->blockname);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.blockname [TV] '%s' <> '%s'", blockname, dimension_aligned->blockname);
        error++;
      }
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "class_version", &class_version, NULL)
        && class_version == dimension_aligned->class_version)
      {
        pass ("DIMENSION_ALIGNED.class_version [RC] %u", class_version);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.class_version [RC] %u != %u", dimension_aligned->class_version, class_version);
        error++;
      }
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "class_version", &class_version)
        && class_version == dimension_aligned->class_version)
      {
        pass ("DIMENSION_ALIGNED.class_version [RC] set+1 %u", class_version);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.class_version [RC] set+1 %u != %u", dimension_aligned->class_version, class_version);
        error++;
      }
    dimension_aligned->class_version--;

  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_aligned->clone_ins_pt, sizeof (dimension_aligned->clone_ins_pt)))
      {
        pass ("DIMENSION_ALIGNED.clone_ins_pt [2RD]");
      }
    else
      {
        fail ("DIMENSION_ALIGNED.clone_ins_pt [2RD]");
        error++;
      }
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_aligned->def_pt, sizeof (dimension_aligned->def_pt)))
      {
        pass ("DIMENSION_ALIGNED.def_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_ALIGNED.def_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_aligned->dimstyle, sizeof (dimension_aligned->dimstyle)))
      {
        pass ("DIMENSION_ALIGNED.dimstyle [H]");
      }
    else
      {
        fail ("DIMENSION_ALIGNED.dimstyle [H]");
        error++;
      }
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "elevation", &elevation, NULL)
        && elevation == dimension_aligned->elevation)
      {
        pass ("DIMENSION_ALIGNED.elevation [BD] %g", elevation);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.elevation [BD] %g != %g", dimension_aligned->elevation, elevation);
        error++;
      }
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "elevation", &elevation)
        && elevation == dimension_aligned->elevation)
      {
        pass ("DIMENSION_ALIGNED.elevation [BD] set+1 %g", elevation);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.elevation [BD] set+1 %g != %g", dimension_aligned->elevation, elevation);
        error++;
      }
    dimension_aligned->elevation--;

  }
  {
    BITCODE_BD ext_line_rotation;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "ext_line_rotation", &ext_line_rotation, NULL)
        && ext_line_rotation == dimension_aligned->ext_line_rotation)
      {
        pass ("DIMENSION_ALIGNED.ext_line_rotation [BD] %g", ext_line_rotation);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.ext_line_rotation [BD] %g != %g", dimension_aligned->ext_line_rotation, ext_line_rotation);
        error++;
      }
    ext_line_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "ext_line_rotation", &ext_line_rotation)
        && ext_line_rotation == dimension_aligned->ext_line_rotation)
      {
        pass ("DIMENSION_ALIGNED.ext_line_rotation [BD] set+1 %g", ext_line_rotation);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.ext_line_rotation [BD] set+1 %g != %g", dimension_aligned->ext_line_rotation, ext_line_rotation);
        error++;
      }
    dimension_aligned->ext_line_rotation--;

  }
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_aligned->extrusion, sizeof (dimension_aligned->extrusion)))
      {
        pass ("DIMENSION_ALIGNED.extrusion [3BD]");
      }
    else
      {
        fail ("DIMENSION_ALIGNED.extrusion [3BD]");
        error++;
      }
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "flag", &flag, NULL)
        && flag == dimension_aligned->flag)
      {
        pass ("DIMENSION_ALIGNED.flag [RC] %u", flag);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.flag [RC] %u != %u", dimension_aligned->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "flag", &flag)
        && flag == dimension_aligned->flag)
      {
        pass ("DIMENSION_ALIGNED.flag [RC] set+1 %u", flag);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.flag [RC] set+1 %u != %u", dimension_aligned->flag, flag);
        error++;
      }
    dimension_aligned->flag--;

  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "flag1", &flag1, NULL)
        && flag1 == dimension_aligned->flag1)
      {
        pass ("DIMENSION_ALIGNED.flag1 [RC] %u", flag1);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.flag1 [RC] %u != %u", dimension_aligned->flag1, flag1);
        error++;
      }
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "flag1", &flag1)
        && flag1 == dimension_aligned->flag1)
      {
        pass ("DIMENSION_ALIGNED.flag1 [RC] set+1 %u", flag1);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.flag1 [RC] set+1 %u != %u", dimension_aligned->flag1, flag1);
        error++;
      }
    dimension_aligned->flag1--;

  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_aligned->flip_arrow1)
      {
        pass ("DIMENSION_ALIGNED.flip_arrow1 [B] " FORMAT_B "", flip_arrow1);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_aligned->flip_arrow1, flip_arrow1);
        error++;
      }
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "flip_arrow1", &flip_arrow1)
        && flip_arrow1 == dimension_aligned->flip_arrow1)
      {
        pass ("DIMENSION_ALIGNED.flip_arrow1 [B] set+1 " FORMAT_B "", flip_arrow1);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_aligned->flip_arrow1, flip_arrow1);
        error++;
      }
    dimension_aligned->flip_arrow1--;

  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_aligned->flip_arrow2)
      {
        pass ("DIMENSION_ALIGNED.flip_arrow2 [B] " FORMAT_B "", flip_arrow2);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_aligned->flip_arrow2, flip_arrow2);
        error++;
      }
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "flip_arrow2", &flip_arrow2)
        && flip_arrow2 == dimension_aligned->flip_arrow2)
      {
        pass ("DIMENSION_ALIGNED.flip_arrow2 [B] set+1 " FORMAT_B "", flip_arrow2);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_aligned->flip_arrow2, flip_arrow2);
        error++;
      }
    dimension_aligned->flip_arrow2--;

  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_aligned->horiz_dir)
      {
        pass ("DIMENSION_ALIGNED.horiz_dir [BD] %g", horiz_dir);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.horiz_dir [BD] %g != %g", dimension_aligned->horiz_dir, horiz_dir);
        error++;
      }
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "horiz_dir", &horiz_dir)
        && horiz_dir == dimension_aligned->horiz_dir)
      {
        pass ("DIMENSION_ALIGNED.horiz_dir [BD] set+1 %g", horiz_dir);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.horiz_dir [BD] set+1 %g != %g", dimension_aligned->horiz_dir, horiz_dir);
        error++;
      }
    dimension_aligned->horiz_dir--;

  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_aligned->ins_rotation)
      {
        pass ("DIMENSION_ALIGNED.ins_rotation [BD] %g", ins_rotation);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.ins_rotation [BD] %g != %g", dimension_aligned->ins_rotation, ins_rotation);
        error++;
      }
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "ins_rotation", &ins_rotation)
        && ins_rotation == dimension_aligned->ins_rotation)
      {
        pass ("DIMENSION_ALIGNED.ins_rotation [BD] set+1 %g", ins_rotation);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.ins_rotation [BD] set+1 %g != %g", dimension_aligned->ins_rotation, ins_rotation);
        error++;
      }
    dimension_aligned->ins_rotation--;

  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_aligned->ins_scale, sizeof (dimension_aligned->ins_scale)))
      {
        pass ("DIMENSION_ALIGNED.ins_scale [3BD]");
      }
    else
      {
        fail ("DIMENSION_ALIGNED.ins_scale [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_aligned->lspace_factor)
      {
        pass ("DIMENSION_ALIGNED.lspace_factor [BD] %g", lspace_factor);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.lspace_factor [BD] %g != %g", dimension_aligned->lspace_factor, lspace_factor);
        error++;
      }
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "lspace_factor", &lspace_factor)
        && lspace_factor == dimension_aligned->lspace_factor)
      {
        pass ("DIMENSION_ALIGNED.lspace_factor [BD] set+1 %g", lspace_factor);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.lspace_factor [BD] set+1 %g != %g", dimension_aligned->lspace_factor, lspace_factor);
        error++;
      }
    dimension_aligned->lspace_factor--;

  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_aligned->lspace_style)
      {
        pass ("DIMENSION_ALIGNED.lspace_style [BS] %hu", lspace_style);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.lspace_style [BS] %hu != %hu", dimension_aligned->lspace_style, lspace_style);
        error++;
      }
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "lspace_style", &lspace_style)
        && lspace_style == dimension_aligned->lspace_style)
      {
        pass ("DIMENSION_ALIGNED.lspace_style [BS] set+1 %hu", lspace_style);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.lspace_style [BS] set+1 %hu != %hu", dimension_aligned->lspace_style, lspace_style);
        error++;
      }
    dimension_aligned->lspace_style--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_aligned->parent, sizeof (dimension_aligned->parent)))
      {
        pass ("DIMENSION_ALIGNED.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("DIMENSION_ALIGNED.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_aligned->text_midpt, sizeof (dimension_aligned->text_midpt)))
      {
        pass ("DIMENSION_ALIGNED.text_midpt [2RD]");
      }
    else
      {
        fail ("DIMENSION_ALIGNED.text_midpt [2RD]");
        error++;
      }
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_aligned->text_rotation)
      {
        pass ("DIMENSION_ALIGNED.text_rotation [BD] %g", text_rotation);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.text_rotation [BD] %g != %g", dimension_aligned->text_rotation, text_rotation);
        error++;
      }
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "text_rotation", &text_rotation)
        && text_rotation == dimension_aligned->text_rotation)
      {
        pass ("DIMENSION_ALIGNED.text_rotation [BD] set+1 %g", text_rotation);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.text_rotation [BD] set+1 %g != %g", dimension_aligned->text_rotation, text_rotation);
        error++;
      }
    dimension_aligned->text_rotation--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "unknown", &unknown, NULL)
        && unknown == dimension_aligned->unknown)
      {
        pass ("DIMENSION_ALIGNED.unknown [B] " FORMAT_B "", unknown);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_aligned->unknown, unknown);
        error++;
      }
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "unknown", &unknown)
        && unknown == dimension_aligned->unknown)
      {
        pass ("DIMENSION_ALIGNED.unknown [B] set+1 " FORMAT_B "", unknown);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_aligned->unknown, unknown);
        error++;
      }
    dimension_aligned->unknown--;

  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value(dimension_aligned, "DIMENSION_ALIGNED", "user_text", &user_text, NULL)
        && !strcmp ((char *)user_text, (char *)dimension_aligned->user_text))
      {
        pass ("DIMENSION_ALIGNED.user_text [TV] '%s' <> '%s'", user_text, dimension_aligned->user_text);
      }
    else
      {
        fail ("DIMENSION_ALIGNED.user_text [TV] '%s' <> '%s'", user_text, dimension_aligned->user_text);
        error++;
      }
  }
  return error;
}
static int test_DIMENSION_ANG2LN (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_ANG2LN *restrict dimension_ang2ln = obj->tio.entity->tio.DIMENSION_ANG2LN;
  {
    BITCODE_3BD _13_pt;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "_13_pt", &_13_pt, NULL)
        && !memcmp (&_13_pt, &dimension_ang2ln->_13_pt, sizeof (dimension_ang2ln->_13_pt)))
      {
        pass ("DIMENSION_ANG2LN._13_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_ANG2LN._13_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD _14_pt;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "_14_pt", &_14_pt, NULL)
        && !memcmp (&_14_pt, &dimension_ang2ln->_14_pt, sizeof (dimension_ang2ln->_14_pt)))
      {
        pass ("DIMENSION_ANG2LN._14_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_ANG2LN._14_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_2RD _16_pt;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "_16_pt", &_16_pt, NULL)
        && !memcmp (&_16_pt, &dimension_ang2ln->_16_pt, sizeof (dimension_ang2ln->_16_pt)))
      {
        pass ("DIMENSION_ANG2LN._16_pt [2RD]");
      }
    else
      {
        fail ("DIMENSION_ANG2LN._16_pt [2RD]");
        error++;
      }
  }
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_ang2ln->act_measurement)
      {
        pass ("DIMENSION_ANG2LN.act_measurement [BD] %g", act_measurement);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.act_measurement [BD] %g != %g", dimension_ang2ln->act_measurement, act_measurement);
        error++;
      }
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "act_measurement", &act_measurement)
        && act_measurement == dimension_ang2ln->act_measurement)
      {
        pass ("DIMENSION_ANG2LN.act_measurement [BD] set+1 %g", act_measurement);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.act_measurement [BD] set+1 %g != %g", dimension_ang2ln->act_measurement, act_measurement);
        error++;
      }
    dimension_ang2ln->act_measurement--;

  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "attachment", &attachment, NULL)
        && attachment == dimension_ang2ln->attachment)
      {
        pass ("DIMENSION_ANG2LN.attachment [BS] %hu", attachment);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.attachment [BS] %hu != %hu", dimension_ang2ln->attachment, attachment);
        error++;
      }
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "attachment", &attachment)
        && attachment == dimension_ang2ln->attachment)
      {
        pass ("DIMENSION_ANG2LN.attachment [BS] set+1 %hu", attachment);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.attachment [BS] set+1 %hu != %hu", dimension_ang2ln->attachment, attachment);
        error++;
      }
    dimension_ang2ln->attachment--;

  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "block", &block, NULL)
        && !memcmp (&block, &dimension_ang2ln->block, sizeof (dimension_ang2ln->block)))
      {
        pass ("DIMENSION_ANG2LN.block [H]");
      }
    else
      {
        fail ("DIMENSION_ANG2LN.block [H]");
        error++;
      }
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "blockname", &blockname, NULL)
        && !strcmp ((char *)blockname, (char *)dimension_ang2ln->blockname))
      {
        pass ("DIMENSION_ANG2LN.blockname [TV] '%s' <> '%s'", blockname, dimension_ang2ln->blockname);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.blockname [TV] '%s' <> '%s'", blockname, dimension_ang2ln->blockname);
        error++;
      }
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "class_version", &class_version, NULL)
        && class_version == dimension_ang2ln->class_version)
      {
        pass ("DIMENSION_ANG2LN.class_version [RC] %u", class_version);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.class_version [RC] %u != %u", dimension_ang2ln->class_version, class_version);
        error++;
      }
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "class_version", &class_version)
        && class_version == dimension_ang2ln->class_version)
      {
        pass ("DIMENSION_ANG2LN.class_version [RC] set+1 %u", class_version);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.class_version [RC] set+1 %u != %u", dimension_ang2ln->class_version, class_version);
        error++;
      }
    dimension_ang2ln->class_version--;

  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_ang2ln->clone_ins_pt, sizeof (dimension_ang2ln->clone_ins_pt)))
      {
        pass ("DIMENSION_ANG2LN.clone_ins_pt [2RD]");
      }
    else
      {
        fail ("DIMENSION_ANG2LN.clone_ins_pt [2RD]");
        error++;
      }
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_ang2ln->def_pt, sizeof (dimension_ang2ln->def_pt)))
      {
        pass ("DIMENSION_ANG2LN.def_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_ANG2LN.def_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_ang2ln->dimstyle, sizeof (dimension_ang2ln->dimstyle)))
      {
        pass ("DIMENSION_ANG2LN.dimstyle [H]");
      }
    else
      {
        fail ("DIMENSION_ANG2LN.dimstyle [H]");
        error++;
      }
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "elevation", &elevation, NULL)
        && elevation == dimension_ang2ln->elevation)
      {
        pass ("DIMENSION_ANG2LN.elevation [BD] %g", elevation);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.elevation [BD] %g != %g", dimension_ang2ln->elevation, elevation);
        error++;
      }
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "elevation", &elevation)
        && elevation == dimension_ang2ln->elevation)
      {
        pass ("DIMENSION_ANG2LN.elevation [BD] set+1 %g", elevation);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.elevation [BD] set+1 %g != %g", dimension_ang2ln->elevation, elevation);
        error++;
      }
    dimension_ang2ln->elevation--;

  }
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_ang2ln->extrusion, sizeof (dimension_ang2ln->extrusion)))
      {
        pass ("DIMENSION_ANG2LN.extrusion [3BD]");
      }
    else
      {
        fail ("DIMENSION_ANG2LN.extrusion [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD first_arc_pt;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "first_arc_pt", &first_arc_pt, NULL)
        && !memcmp (&first_arc_pt, &dimension_ang2ln->first_arc_pt, sizeof (dimension_ang2ln->first_arc_pt)))
      {
        pass ("DIMENSION_ANG2LN.first_arc_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_ANG2LN.first_arc_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "flag", &flag, NULL)
        && flag == dimension_ang2ln->flag)
      {
        pass ("DIMENSION_ANG2LN.flag [RC] %u", flag);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.flag [RC] %u != %u", dimension_ang2ln->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flag", &flag)
        && flag == dimension_ang2ln->flag)
      {
        pass ("DIMENSION_ANG2LN.flag [RC] set+1 %u", flag);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.flag [RC] set+1 %u != %u", dimension_ang2ln->flag, flag);
        error++;
      }
    dimension_ang2ln->flag--;

  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "flag1", &flag1, NULL)
        && flag1 == dimension_ang2ln->flag1)
      {
        pass ("DIMENSION_ANG2LN.flag1 [RC] %u", flag1);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.flag1 [RC] %u != %u", dimension_ang2ln->flag1, flag1);
        error++;
      }
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flag1", &flag1)
        && flag1 == dimension_ang2ln->flag1)
      {
        pass ("DIMENSION_ANG2LN.flag1 [RC] set+1 %u", flag1);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.flag1 [RC] set+1 %u != %u", dimension_ang2ln->flag1, flag1);
        error++;
      }
    dimension_ang2ln->flag1--;

  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_ang2ln->flip_arrow1)
      {
        pass ("DIMENSION_ANG2LN.flip_arrow1 [B] " FORMAT_B "", flip_arrow1);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_ang2ln->flip_arrow1, flip_arrow1);
        error++;
      }
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flip_arrow1", &flip_arrow1)
        && flip_arrow1 == dimension_ang2ln->flip_arrow1)
      {
        pass ("DIMENSION_ANG2LN.flip_arrow1 [B] set+1 " FORMAT_B "", flip_arrow1);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ang2ln->flip_arrow1, flip_arrow1);
        error++;
      }
    dimension_ang2ln->flip_arrow1--;

  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_ang2ln->flip_arrow2)
      {
        pass ("DIMENSION_ANG2LN.flip_arrow2 [B] " FORMAT_B "", flip_arrow2);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_ang2ln->flip_arrow2, flip_arrow2);
        error++;
      }
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flip_arrow2", &flip_arrow2)
        && flip_arrow2 == dimension_ang2ln->flip_arrow2)
      {
        pass ("DIMENSION_ANG2LN.flip_arrow2 [B] set+1 " FORMAT_B "", flip_arrow2);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ang2ln->flip_arrow2, flip_arrow2);
        error++;
      }
    dimension_ang2ln->flip_arrow2--;

  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_ang2ln->horiz_dir)
      {
        pass ("DIMENSION_ANG2LN.horiz_dir [BD] %g", horiz_dir);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.horiz_dir [BD] %g != %g", dimension_ang2ln->horiz_dir, horiz_dir);
        error++;
      }
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "horiz_dir", &horiz_dir)
        && horiz_dir == dimension_ang2ln->horiz_dir)
      {
        pass ("DIMENSION_ANG2LN.horiz_dir [BD] set+1 %g", horiz_dir);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.horiz_dir [BD] set+1 %g != %g", dimension_ang2ln->horiz_dir, horiz_dir);
        error++;
      }
    dimension_ang2ln->horiz_dir--;

  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_ang2ln->ins_rotation)
      {
        pass ("DIMENSION_ANG2LN.ins_rotation [BD] %g", ins_rotation);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.ins_rotation [BD] %g != %g", dimension_ang2ln->ins_rotation, ins_rotation);
        error++;
      }
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "ins_rotation", &ins_rotation)
        && ins_rotation == dimension_ang2ln->ins_rotation)
      {
        pass ("DIMENSION_ANG2LN.ins_rotation [BD] set+1 %g", ins_rotation);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.ins_rotation [BD] set+1 %g != %g", dimension_ang2ln->ins_rotation, ins_rotation);
        error++;
      }
    dimension_ang2ln->ins_rotation--;

  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_ang2ln->ins_scale, sizeof (dimension_ang2ln->ins_scale)))
      {
        pass ("DIMENSION_ANG2LN.ins_scale [3BD]");
      }
    else
      {
        fail ("DIMENSION_ANG2LN.ins_scale [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_ang2ln->lspace_factor)
      {
        pass ("DIMENSION_ANG2LN.lspace_factor [BD] %g", lspace_factor);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.lspace_factor [BD] %g != %g", dimension_ang2ln->lspace_factor, lspace_factor);
        error++;
      }
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "lspace_factor", &lspace_factor)
        && lspace_factor == dimension_ang2ln->lspace_factor)
      {
        pass ("DIMENSION_ANG2LN.lspace_factor [BD] set+1 %g", lspace_factor);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.lspace_factor [BD] set+1 %g != %g", dimension_ang2ln->lspace_factor, lspace_factor);
        error++;
      }
    dimension_ang2ln->lspace_factor--;

  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_ang2ln->lspace_style)
      {
        pass ("DIMENSION_ANG2LN.lspace_style [BS] %hu", lspace_style);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.lspace_style [BS] %hu != %hu", dimension_ang2ln->lspace_style, lspace_style);
        error++;
      }
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "lspace_style", &lspace_style)
        && lspace_style == dimension_ang2ln->lspace_style)
      {
        pass ("DIMENSION_ANG2LN.lspace_style [BS] set+1 %hu", lspace_style);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.lspace_style [BS] set+1 %hu != %hu", dimension_ang2ln->lspace_style, lspace_style);
        error++;
      }
    dimension_ang2ln->lspace_style--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_ang2ln->parent, sizeof (dimension_ang2ln->parent)))
      {
        pass ("DIMENSION_ANG2LN.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("DIMENSION_ANG2LN.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_ang2ln->text_midpt, sizeof (dimension_ang2ln->text_midpt)))
      {
        pass ("DIMENSION_ANG2LN.text_midpt [2RD]");
      }
    else
      {
        fail ("DIMENSION_ANG2LN.text_midpt [2RD]");
        error++;
      }
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_ang2ln->text_rotation)
      {
        pass ("DIMENSION_ANG2LN.text_rotation [BD] %g", text_rotation);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.text_rotation [BD] %g != %g", dimension_ang2ln->text_rotation, text_rotation);
        error++;
      }
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "text_rotation", &text_rotation)
        && text_rotation == dimension_ang2ln->text_rotation)
      {
        pass ("DIMENSION_ANG2LN.text_rotation [BD] set+1 %g", text_rotation);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.text_rotation [BD] set+1 %g != %g", dimension_ang2ln->text_rotation, text_rotation);
        error++;
      }
    dimension_ang2ln->text_rotation--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "unknown", &unknown, NULL)
        && unknown == dimension_ang2ln->unknown)
      {
        pass ("DIMENSION_ANG2LN.unknown [B] " FORMAT_B "", unknown);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_ang2ln->unknown, unknown);
        error++;
      }
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "unknown", &unknown)
        && unknown == dimension_ang2ln->unknown)
      {
        pass ("DIMENSION_ANG2LN.unknown [B] set+1 " FORMAT_B "", unknown);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ang2ln->unknown, unknown);
        error++;
      }
    dimension_ang2ln->unknown--;

  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value(dimension_ang2ln, "DIMENSION_ANG2LN", "user_text", &user_text, NULL)
        && !strcmp ((char *)user_text, (char *)dimension_ang2ln->user_text))
      {
        pass ("DIMENSION_ANG2LN.user_text [TV] '%s' <> '%s'", user_text, dimension_ang2ln->user_text);
      }
    else
      {
        fail ("DIMENSION_ANG2LN.user_text [TV] '%s' <> '%s'", user_text, dimension_ang2ln->user_text);
        error++;
      }
  }
  return error;
}
static int test_DIMENSION_ANG3PT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_ANG3PT *restrict dimension_ang3pt = obj->tio.entity->tio.DIMENSION_ANG3PT;
  {
    BITCODE_3BD _13_pt;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "_13_pt", &_13_pt, NULL)
        && !memcmp (&_13_pt, &dimension_ang3pt->_13_pt, sizeof (dimension_ang3pt->_13_pt)))
      {
        pass ("DIMENSION_ANG3PT._13_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_ANG3PT._13_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD _14_pt;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "_14_pt", &_14_pt, NULL)
        && !memcmp (&_14_pt, &dimension_ang3pt->_14_pt, sizeof (dimension_ang3pt->_14_pt)))
      {
        pass ("DIMENSION_ANG3PT._14_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_ANG3PT._14_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_ang3pt->act_measurement)
      {
        pass ("DIMENSION_ANG3PT.act_measurement [BD] %g", act_measurement);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.act_measurement [BD] %g != %g", dimension_ang3pt->act_measurement, act_measurement);
        error++;
      }
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "act_measurement", &act_measurement)
        && act_measurement == dimension_ang3pt->act_measurement)
      {
        pass ("DIMENSION_ANG3PT.act_measurement [BD] set+1 %g", act_measurement);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.act_measurement [BD] set+1 %g != %g", dimension_ang3pt->act_measurement, act_measurement);
        error++;
      }
    dimension_ang3pt->act_measurement--;

  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "attachment", &attachment, NULL)
        && attachment == dimension_ang3pt->attachment)
      {
        pass ("DIMENSION_ANG3PT.attachment [BS] %hu", attachment);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.attachment [BS] %hu != %hu", dimension_ang3pt->attachment, attachment);
        error++;
      }
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "attachment", &attachment)
        && attachment == dimension_ang3pt->attachment)
      {
        pass ("DIMENSION_ANG3PT.attachment [BS] set+1 %hu", attachment);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.attachment [BS] set+1 %hu != %hu", dimension_ang3pt->attachment, attachment);
        error++;
      }
    dimension_ang3pt->attachment--;

  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "block", &block, NULL)
        && !memcmp (&block, &dimension_ang3pt->block, sizeof (dimension_ang3pt->block)))
      {
        pass ("DIMENSION_ANG3PT.block [H]");
      }
    else
      {
        fail ("DIMENSION_ANG3PT.block [H]");
        error++;
      }
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "blockname", &blockname, NULL)
        && !strcmp ((char *)blockname, (char *)dimension_ang3pt->blockname))
      {
        pass ("DIMENSION_ANG3PT.blockname [TV] '%s' <> '%s'", blockname, dimension_ang3pt->blockname);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.blockname [TV] '%s' <> '%s'", blockname, dimension_ang3pt->blockname);
        error++;
      }
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "class_version", &class_version, NULL)
        && class_version == dimension_ang3pt->class_version)
      {
        pass ("DIMENSION_ANG3PT.class_version [RC] %u", class_version);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.class_version [RC] %u != %u", dimension_ang3pt->class_version, class_version);
        error++;
      }
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "class_version", &class_version)
        && class_version == dimension_ang3pt->class_version)
      {
        pass ("DIMENSION_ANG3PT.class_version [RC] set+1 %u", class_version);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.class_version [RC] set+1 %u != %u", dimension_ang3pt->class_version, class_version);
        error++;
      }
    dimension_ang3pt->class_version--;

  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_ang3pt->clone_ins_pt, sizeof (dimension_ang3pt->clone_ins_pt)))
      {
        pass ("DIMENSION_ANG3PT.clone_ins_pt [2RD]");
      }
    else
      {
        fail ("DIMENSION_ANG3PT.clone_ins_pt [2RD]");
        error++;
      }
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_ang3pt->def_pt, sizeof (dimension_ang3pt->def_pt)))
      {
        pass ("DIMENSION_ANG3PT.def_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_ANG3PT.def_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_ang3pt->dimstyle, sizeof (dimension_ang3pt->dimstyle)))
      {
        pass ("DIMENSION_ANG3PT.dimstyle [H]");
      }
    else
      {
        fail ("DIMENSION_ANG3PT.dimstyle [H]");
        error++;
      }
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "elevation", &elevation, NULL)
        && elevation == dimension_ang3pt->elevation)
      {
        pass ("DIMENSION_ANG3PT.elevation [BD] %g", elevation);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.elevation [BD] %g != %g", dimension_ang3pt->elevation, elevation);
        error++;
      }
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "elevation", &elevation)
        && elevation == dimension_ang3pt->elevation)
      {
        pass ("DIMENSION_ANG3PT.elevation [BD] set+1 %g", elevation);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.elevation [BD] set+1 %g != %g", dimension_ang3pt->elevation, elevation);
        error++;
      }
    dimension_ang3pt->elevation--;

  }
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_ang3pt->extrusion, sizeof (dimension_ang3pt->extrusion)))
      {
        pass ("DIMENSION_ANG3PT.extrusion [3BD]");
      }
    else
      {
        fail ("DIMENSION_ANG3PT.extrusion [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD first_arc_pt;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "first_arc_pt", &first_arc_pt, NULL)
        && !memcmp (&first_arc_pt, &dimension_ang3pt->first_arc_pt, sizeof (dimension_ang3pt->first_arc_pt)))
      {
        pass ("DIMENSION_ANG3PT.first_arc_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_ANG3PT.first_arc_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "flag", &flag, NULL)
        && flag == dimension_ang3pt->flag)
      {
        pass ("DIMENSION_ANG3PT.flag [RC] %u", flag);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.flag [RC] %u != %u", dimension_ang3pt->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flag", &flag)
        && flag == dimension_ang3pt->flag)
      {
        pass ("DIMENSION_ANG3PT.flag [RC] set+1 %u", flag);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.flag [RC] set+1 %u != %u", dimension_ang3pt->flag, flag);
        error++;
      }
    dimension_ang3pt->flag--;

  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "flag1", &flag1, NULL)
        && flag1 == dimension_ang3pt->flag1)
      {
        pass ("DIMENSION_ANG3PT.flag1 [RC] %u", flag1);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.flag1 [RC] %u != %u", dimension_ang3pt->flag1, flag1);
        error++;
      }
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flag1", &flag1)
        && flag1 == dimension_ang3pt->flag1)
      {
        pass ("DIMENSION_ANG3PT.flag1 [RC] set+1 %u", flag1);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.flag1 [RC] set+1 %u != %u", dimension_ang3pt->flag1, flag1);
        error++;
      }
    dimension_ang3pt->flag1--;

  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_ang3pt->flip_arrow1)
      {
        pass ("DIMENSION_ANG3PT.flip_arrow1 [B] " FORMAT_B "", flip_arrow1);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_ang3pt->flip_arrow1, flip_arrow1);
        error++;
      }
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flip_arrow1", &flip_arrow1)
        && flip_arrow1 == dimension_ang3pt->flip_arrow1)
      {
        pass ("DIMENSION_ANG3PT.flip_arrow1 [B] set+1 " FORMAT_B "", flip_arrow1);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ang3pt->flip_arrow1, flip_arrow1);
        error++;
      }
    dimension_ang3pt->flip_arrow1--;

  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_ang3pt->flip_arrow2)
      {
        pass ("DIMENSION_ANG3PT.flip_arrow2 [B] " FORMAT_B "", flip_arrow2);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_ang3pt->flip_arrow2, flip_arrow2);
        error++;
      }
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flip_arrow2", &flip_arrow2)
        && flip_arrow2 == dimension_ang3pt->flip_arrow2)
      {
        pass ("DIMENSION_ANG3PT.flip_arrow2 [B] set+1 " FORMAT_B "", flip_arrow2);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ang3pt->flip_arrow2, flip_arrow2);
        error++;
      }
    dimension_ang3pt->flip_arrow2--;

  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_ang3pt->horiz_dir)
      {
        pass ("DIMENSION_ANG3PT.horiz_dir [BD] %g", horiz_dir);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.horiz_dir [BD] %g != %g", dimension_ang3pt->horiz_dir, horiz_dir);
        error++;
      }
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "horiz_dir", &horiz_dir)
        && horiz_dir == dimension_ang3pt->horiz_dir)
      {
        pass ("DIMENSION_ANG3PT.horiz_dir [BD] set+1 %g", horiz_dir);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.horiz_dir [BD] set+1 %g != %g", dimension_ang3pt->horiz_dir, horiz_dir);
        error++;
      }
    dimension_ang3pt->horiz_dir--;

  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_ang3pt->ins_rotation)
      {
        pass ("DIMENSION_ANG3PT.ins_rotation [BD] %g", ins_rotation);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.ins_rotation [BD] %g != %g", dimension_ang3pt->ins_rotation, ins_rotation);
        error++;
      }
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "ins_rotation", &ins_rotation)
        && ins_rotation == dimension_ang3pt->ins_rotation)
      {
        pass ("DIMENSION_ANG3PT.ins_rotation [BD] set+1 %g", ins_rotation);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.ins_rotation [BD] set+1 %g != %g", dimension_ang3pt->ins_rotation, ins_rotation);
        error++;
      }
    dimension_ang3pt->ins_rotation--;

  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_ang3pt->ins_scale, sizeof (dimension_ang3pt->ins_scale)))
      {
        pass ("DIMENSION_ANG3PT.ins_scale [3BD]");
      }
    else
      {
        fail ("DIMENSION_ANG3PT.ins_scale [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_ang3pt->lspace_factor)
      {
        pass ("DIMENSION_ANG3PT.lspace_factor [BD] %g", lspace_factor);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.lspace_factor [BD] %g != %g", dimension_ang3pt->lspace_factor, lspace_factor);
        error++;
      }
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "lspace_factor", &lspace_factor)
        && lspace_factor == dimension_ang3pt->lspace_factor)
      {
        pass ("DIMENSION_ANG3PT.lspace_factor [BD] set+1 %g", lspace_factor);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.lspace_factor [BD] set+1 %g != %g", dimension_ang3pt->lspace_factor, lspace_factor);
        error++;
      }
    dimension_ang3pt->lspace_factor--;

  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_ang3pt->lspace_style)
      {
        pass ("DIMENSION_ANG3PT.lspace_style [BS] %hu", lspace_style);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.lspace_style [BS] %hu != %hu", dimension_ang3pt->lspace_style, lspace_style);
        error++;
      }
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "lspace_style", &lspace_style)
        && lspace_style == dimension_ang3pt->lspace_style)
      {
        pass ("DIMENSION_ANG3PT.lspace_style [BS] set+1 %hu", lspace_style);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.lspace_style [BS] set+1 %hu != %hu", dimension_ang3pt->lspace_style, lspace_style);
        error++;
      }
    dimension_ang3pt->lspace_style--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_ang3pt->parent, sizeof (dimension_ang3pt->parent)))
      {
        pass ("DIMENSION_ANG3PT.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("DIMENSION_ANG3PT.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_ang3pt->text_midpt, sizeof (dimension_ang3pt->text_midpt)))
      {
        pass ("DIMENSION_ANG3PT.text_midpt [2RD]");
      }
    else
      {
        fail ("DIMENSION_ANG3PT.text_midpt [2RD]");
        error++;
      }
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_ang3pt->text_rotation)
      {
        pass ("DIMENSION_ANG3PT.text_rotation [BD] %g", text_rotation);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.text_rotation [BD] %g != %g", dimension_ang3pt->text_rotation, text_rotation);
        error++;
      }
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "text_rotation", &text_rotation)
        && text_rotation == dimension_ang3pt->text_rotation)
      {
        pass ("DIMENSION_ANG3PT.text_rotation [BD] set+1 %g", text_rotation);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.text_rotation [BD] set+1 %g != %g", dimension_ang3pt->text_rotation, text_rotation);
        error++;
      }
    dimension_ang3pt->text_rotation--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "unknown", &unknown, NULL)
        && unknown == dimension_ang3pt->unknown)
      {
        pass ("DIMENSION_ANG3PT.unknown [B] " FORMAT_B "", unknown);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_ang3pt->unknown, unknown);
        error++;
      }
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "unknown", &unknown)
        && unknown == dimension_ang3pt->unknown)
      {
        pass ("DIMENSION_ANG3PT.unknown [B] set+1 " FORMAT_B "", unknown);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ang3pt->unknown, unknown);
        error++;
      }
    dimension_ang3pt->unknown--;

  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value(dimension_ang3pt, "DIMENSION_ANG3PT", "user_text", &user_text, NULL)
        && !strcmp ((char *)user_text, (char *)dimension_ang3pt->user_text))
      {
        pass ("DIMENSION_ANG3PT.user_text [TV] '%s' <> '%s'", user_text, dimension_ang3pt->user_text);
      }
    else
      {
        fail ("DIMENSION_ANG3PT.user_text [TV] '%s' <> '%s'", user_text, dimension_ang3pt->user_text);
        error++;
      }
  }
  return error;
}
static int test_DIMENSION_DIAMETER (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_DIAMETER *restrict dimension_diameter = obj->tio.entity->tio.DIMENSION_DIAMETER;
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_diameter->act_measurement)
      {
        pass ("DIMENSION_DIAMETER.act_measurement [BD] %g", act_measurement);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.act_measurement [BD] %g != %g", dimension_diameter->act_measurement, act_measurement);
        error++;
      }
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "act_measurement", &act_measurement)
        && act_measurement == dimension_diameter->act_measurement)
      {
        pass ("DIMENSION_DIAMETER.act_measurement [BD] set+1 %g", act_measurement);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.act_measurement [BD] set+1 %g != %g", dimension_diameter->act_measurement, act_measurement);
        error++;
      }
    dimension_diameter->act_measurement--;

  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "attachment", &attachment, NULL)
        && attachment == dimension_diameter->attachment)
      {
        pass ("DIMENSION_DIAMETER.attachment [BS] %hu", attachment);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.attachment [BS] %hu != %hu", dimension_diameter->attachment, attachment);
        error++;
      }
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "attachment", &attachment)
        && attachment == dimension_diameter->attachment)
      {
        pass ("DIMENSION_DIAMETER.attachment [BS] set+1 %hu", attachment);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.attachment [BS] set+1 %hu != %hu", dimension_diameter->attachment, attachment);
        error++;
      }
    dimension_diameter->attachment--;

  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "block", &block, NULL)
        && !memcmp (&block, &dimension_diameter->block, sizeof (dimension_diameter->block)))
      {
        pass ("DIMENSION_DIAMETER.block [H]");
      }
    else
      {
        fail ("DIMENSION_DIAMETER.block [H]");
        error++;
      }
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "blockname", &blockname, NULL)
        && !strcmp ((char *)blockname, (char *)dimension_diameter->blockname))
      {
        pass ("DIMENSION_DIAMETER.blockname [TV] '%s' <> '%s'", blockname, dimension_diameter->blockname);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.blockname [TV] '%s' <> '%s'", blockname, dimension_diameter->blockname);
        error++;
      }
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "class_version", &class_version, NULL)
        && class_version == dimension_diameter->class_version)
      {
        pass ("DIMENSION_DIAMETER.class_version [RC] %u", class_version);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.class_version [RC] %u != %u", dimension_diameter->class_version, class_version);
        error++;
      }
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "class_version", &class_version)
        && class_version == dimension_diameter->class_version)
      {
        pass ("DIMENSION_DIAMETER.class_version [RC] set+1 %u", class_version);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.class_version [RC] set+1 %u != %u", dimension_diameter->class_version, class_version);
        error++;
      }
    dimension_diameter->class_version--;

  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_diameter->clone_ins_pt, sizeof (dimension_diameter->clone_ins_pt)))
      {
        pass ("DIMENSION_DIAMETER.clone_ins_pt [2RD]");
      }
    else
      {
        fail ("DIMENSION_DIAMETER.clone_ins_pt [2RD]");
        error++;
      }
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_diameter->def_pt, sizeof (dimension_diameter->def_pt)))
      {
        pass ("DIMENSION_DIAMETER.def_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_DIAMETER.def_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_diameter->dimstyle, sizeof (dimension_diameter->dimstyle)))
      {
        pass ("DIMENSION_DIAMETER.dimstyle [H]");
      }
    else
      {
        fail ("DIMENSION_DIAMETER.dimstyle [H]");
        error++;
      }
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "elevation", &elevation, NULL)
        && elevation == dimension_diameter->elevation)
      {
        pass ("DIMENSION_DIAMETER.elevation [BD] %g", elevation);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.elevation [BD] %g != %g", dimension_diameter->elevation, elevation);
        error++;
      }
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "elevation", &elevation)
        && elevation == dimension_diameter->elevation)
      {
        pass ("DIMENSION_DIAMETER.elevation [BD] set+1 %g", elevation);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.elevation [BD] set+1 %g != %g", dimension_diameter->elevation, elevation);
        error++;
      }
    dimension_diameter->elevation--;

  }
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_diameter->extrusion, sizeof (dimension_diameter->extrusion)))
      {
        pass ("DIMENSION_DIAMETER.extrusion [3BD]");
      }
    else
      {
        fail ("DIMENSION_DIAMETER.extrusion [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD first_arc_pt;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "first_arc_pt", &first_arc_pt, NULL)
        && !memcmp (&first_arc_pt, &dimension_diameter->first_arc_pt, sizeof (dimension_diameter->first_arc_pt)))
      {
        pass ("DIMENSION_DIAMETER.first_arc_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_DIAMETER.first_arc_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "flag", &flag, NULL)
        && flag == dimension_diameter->flag)
      {
        pass ("DIMENSION_DIAMETER.flag [RC] %u", flag);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.flag [RC] %u != %u", dimension_diameter->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "flag", &flag)
        && flag == dimension_diameter->flag)
      {
        pass ("DIMENSION_DIAMETER.flag [RC] set+1 %u", flag);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.flag [RC] set+1 %u != %u", dimension_diameter->flag, flag);
        error++;
      }
    dimension_diameter->flag--;

  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "flag1", &flag1, NULL)
        && flag1 == dimension_diameter->flag1)
      {
        pass ("DIMENSION_DIAMETER.flag1 [RC] %u", flag1);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.flag1 [RC] %u != %u", dimension_diameter->flag1, flag1);
        error++;
      }
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "flag1", &flag1)
        && flag1 == dimension_diameter->flag1)
      {
        pass ("DIMENSION_DIAMETER.flag1 [RC] set+1 %u", flag1);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.flag1 [RC] set+1 %u != %u", dimension_diameter->flag1, flag1);
        error++;
      }
    dimension_diameter->flag1--;

  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_diameter->flip_arrow1)
      {
        pass ("DIMENSION_DIAMETER.flip_arrow1 [B] " FORMAT_B "", flip_arrow1);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_diameter->flip_arrow1, flip_arrow1);
        error++;
      }
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "flip_arrow1", &flip_arrow1)
        && flip_arrow1 == dimension_diameter->flip_arrow1)
      {
        pass ("DIMENSION_DIAMETER.flip_arrow1 [B] set+1 " FORMAT_B "", flip_arrow1);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_diameter->flip_arrow1, flip_arrow1);
        error++;
      }
    dimension_diameter->flip_arrow1--;

  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_diameter->flip_arrow2)
      {
        pass ("DIMENSION_DIAMETER.flip_arrow2 [B] " FORMAT_B "", flip_arrow2);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_diameter->flip_arrow2, flip_arrow2);
        error++;
      }
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "flip_arrow2", &flip_arrow2)
        && flip_arrow2 == dimension_diameter->flip_arrow2)
      {
        pass ("DIMENSION_DIAMETER.flip_arrow2 [B] set+1 " FORMAT_B "", flip_arrow2);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_diameter->flip_arrow2, flip_arrow2);
        error++;
      }
    dimension_diameter->flip_arrow2--;

  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_diameter->horiz_dir)
      {
        pass ("DIMENSION_DIAMETER.horiz_dir [BD] %g", horiz_dir);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.horiz_dir [BD] %g != %g", dimension_diameter->horiz_dir, horiz_dir);
        error++;
      }
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "horiz_dir", &horiz_dir)
        && horiz_dir == dimension_diameter->horiz_dir)
      {
        pass ("DIMENSION_DIAMETER.horiz_dir [BD] set+1 %g", horiz_dir);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.horiz_dir [BD] set+1 %g != %g", dimension_diameter->horiz_dir, horiz_dir);
        error++;
      }
    dimension_diameter->horiz_dir--;

  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_diameter->ins_rotation)
      {
        pass ("DIMENSION_DIAMETER.ins_rotation [BD] %g", ins_rotation);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.ins_rotation [BD] %g != %g", dimension_diameter->ins_rotation, ins_rotation);
        error++;
      }
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "ins_rotation", &ins_rotation)
        && ins_rotation == dimension_diameter->ins_rotation)
      {
        pass ("DIMENSION_DIAMETER.ins_rotation [BD] set+1 %g", ins_rotation);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.ins_rotation [BD] set+1 %g != %g", dimension_diameter->ins_rotation, ins_rotation);
        error++;
      }
    dimension_diameter->ins_rotation--;

  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_diameter->ins_scale, sizeof (dimension_diameter->ins_scale)))
      {
        pass ("DIMENSION_DIAMETER.ins_scale [3BD]");
      }
    else
      {
        fail ("DIMENSION_DIAMETER.ins_scale [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD leader_len;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "leader_len", &leader_len, NULL)
        && leader_len == dimension_diameter->leader_len)
      {
        pass ("DIMENSION_DIAMETER.leader_len [BD] %g", leader_len);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.leader_len [BD] %g != %g", dimension_diameter->leader_len, leader_len);
        error++;
      }
    leader_len++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "leader_len", &leader_len)
        && leader_len == dimension_diameter->leader_len)
      {
        pass ("DIMENSION_DIAMETER.leader_len [BD] set+1 %g", leader_len);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.leader_len [BD] set+1 %g != %g", dimension_diameter->leader_len, leader_len);
        error++;
      }
    dimension_diameter->leader_len--;

  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_diameter->lspace_factor)
      {
        pass ("DIMENSION_DIAMETER.lspace_factor [BD] %g", lspace_factor);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.lspace_factor [BD] %g != %g", dimension_diameter->lspace_factor, lspace_factor);
        error++;
      }
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "lspace_factor", &lspace_factor)
        && lspace_factor == dimension_diameter->lspace_factor)
      {
        pass ("DIMENSION_DIAMETER.lspace_factor [BD] set+1 %g", lspace_factor);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.lspace_factor [BD] set+1 %g != %g", dimension_diameter->lspace_factor, lspace_factor);
        error++;
      }
    dimension_diameter->lspace_factor--;

  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_diameter->lspace_style)
      {
        pass ("DIMENSION_DIAMETER.lspace_style [BS] %hu", lspace_style);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.lspace_style [BS] %hu != %hu", dimension_diameter->lspace_style, lspace_style);
        error++;
      }
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "lspace_style", &lspace_style)
        && lspace_style == dimension_diameter->lspace_style)
      {
        pass ("DIMENSION_DIAMETER.lspace_style [BS] set+1 %hu", lspace_style);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.lspace_style [BS] set+1 %hu != %hu", dimension_diameter->lspace_style, lspace_style);
        error++;
      }
    dimension_diameter->lspace_style--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_diameter->parent, sizeof (dimension_diameter->parent)))
      {
        pass ("DIMENSION_DIAMETER.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("DIMENSION_DIAMETER.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_diameter->text_midpt, sizeof (dimension_diameter->text_midpt)))
      {
        pass ("DIMENSION_DIAMETER.text_midpt [2RD]");
      }
    else
      {
        fail ("DIMENSION_DIAMETER.text_midpt [2RD]");
        error++;
      }
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_diameter->text_rotation)
      {
        pass ("DIMENSION_DIAMETER.text_rotation [BD] %g", text_rotation);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.text_rotation [BD] %g != %g", dimension_diameter->text_rotation, text_rotation);
        error++;
      }
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "text_rotation", &text_rotation)
        && text_rotation == dimension_diameter->text_rotation)
      {
        pass ("DIMENSION_DIAMETER.text_rotation [BD] set+1 %g", text_rotation);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.text_rotation [BD] set+1 %g != %g", dimension_diameter->text_rotation, text_rotation);
        error++;
      }
    dimension_diameter->text_rotation--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "unknown", &unknown, NULL)
        && unknown == dimension_diameter->unknown)
      {
        pass ("DIMENSION_DIAMETER.unknown [B] " FORMAT_B "", unknown);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_diameter->unknown, unknown);
        error++;
      }
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "unknown", &unknown)
        && unknown == dimension_diameter->unknown)
      {
        pass ("DIMENSION_DIAMETER.unknown [B] set+1 " FORMAT_B "", unknown);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_diameter->unknown, unknown);
        error++;
      }
    dimension_diameter->unknown--;

  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value(dimension_diameter, "DIMENSION_DIAMETER", "user_text", &user_text, NULL)
        && !strcmp ((char *)user_text, (char *)dimension_diameter->user_text))
      {
        pass ("DIMENSION_DIAMETER.user_text [TV] '%s' <> '%s'", user_text, dimension_diameter->user_text);
      }
    else
      {
        fail ("DIMENSION_DIAMETER.user_text [TV] '%s' <> '%s'", user_text, dimension_diameter->user_text);
        error++;
      }
  }
  return error;
}
static int test_DIMENSION_LINEAR (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_LINEAR *restrict dimension_linear = obj->tio.entity->tio.DIMENSION_LINEAR;
  {
    BITCODE_3BD _13_pt;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "_13_pt", &_13_pt, NULL)
        && !memcmp (&_13_pt, &dimension_linear->_13_pt, sizeof (dimension_linear->_13_pt)))
      {
        pass ("DIMENSION_LINEAR._13_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_LINEAR._13_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD _14_pt;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "_14_pt", &_14_pt, NULL)
        && !memcmp (&_14_pt, &dimension_linear->_14_pt, sizeof (dimension_linear->_14_pt)))
      {
        pass ("DIMENSION_LINEAR._14_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_LINEAR._14_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_linear->act_measurement)
      {
        pass ("DIMENSION_LINEAR.act_measurement [BD] %g", act_measurement);
      }
    else
      {
        fail ("DIMENSION_LINEAR.act_measurement [BD] %g != %g", dimension_linear->act_measurement, act_measurement);
        error++;
      }
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "act_measurement", &act_measurement)
        && act_measurement == dimension_linear->act_measurement)
      {
        pass ("DIMENSION_LINEAR.act_measurement [BD] set+1 %g", act_measurement);
      }
    else
      {
        fail ("DIMENSION_LINEAR.act_measurement [BD] set+1 %g != %g", dimension_linear->act_measurement, act_measurement);
        error++;
      }
    dimension_linear->act_measurement--;

  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "attachment", &attachment, NULL)
        && attachment == dimension_linear->attachment)
      {
        pass ("DIMENSION_LINEAR.attachment [BS] %hu", attachment);
      }
    else
      {
        fail ("DIMENSION_LINEAR.attachment [BS] %hu != %hu", dimension_linear->attachment, attachment);
        error++;
      }
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "attachment", &attachment)
        && attachment == dimension_linear->attachment)
      {
        pass ("DIMENSION_LINEAR.attachment [BS] set+1 %hu", attachment);
      }
    else
      {
        fail ("DIMENSION_LINEAR.attachment [BS] set+1 %hu != %hu", dimension_linear->attachment, attachment);
        error++;
      }
    dimension_linear->attachment--;

  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "block", &block, NULL)
        && !memcmp (&block, &dimension_linear->block, sizeof (dimension_linear->block)))
      {
        pass ("DIMENSION_LINEAR.block [H]");
      }
    else
      {
        fail ("DIMENSION_LINEAR.block [H]");
        error++;
      }
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "blockname", &blockname, NULL)
        && !strcmp ((char *)blockname, (char *)dimension_linear->blockname))
      {
        pass ("DIMENSION_LINEAR.blockname [TV] '%s' <> '%s'", blockname, dimension_linear->blockname);
      }
    else
      {
        fail ("DIMENSION_LINEAR.blockname [TV] '%s' <> '%s'", blockname, dimension_linear->blockname);
        error++;
      }
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "class_version", &class_version, NULL)
        && class_version == dimension_linear->class_version)
      {
        pass ("DIMENSION_LINEAR.class_version [RC] %u", class_version);
      }
    else
      {
        fail ("DIMENSION_LINEAR.class_version [RC] %u != %u", dimension_linear->class_version, class_version);
        error++;
      }
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "class_version", &class_version)
        && class_version == dimension_linear->class_version)
      {
        pass ("DIMENSION_LINEAR.class_version [RC] set+1 %u", class_version);
      }
    else
      {
        fail ("DIMENSION_LINEAR.class_version [RC] set+1 %u != %u", dimension_linear->class_version, class_version);
        error++;
      }
    dimension_linear->class_version--;

  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_linear->clone_ins_pt, sizeof (dimension_linear->clone_ins_pt)))
      {
        pass ("DIMENSION_LINEAR.clone_ins_pt [2RD]");
      }
    else
      {
        fail ("DIMENSION_LINEAR.clone_ins_pt [2RD]");
        error++;
      }
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_linear->def_pt, sizeof (dimension_linear->def_pt)))
      {
        pass ("DIMENSION_LINEAR.def_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_LINEAR.def_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD dim_rotation;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "dim_rotation", &dim_rotation, NULL)
        && dim_rotation == dimension_linear->dim_rotation)
      {
        pass ("DIMENSION_LINEAR.dim_rotation [BD] %g", dim_rotation);
      }
    else
      {
        fail ("DIMENSION_LINEAR.dim_rotation [BD] %g != %g", dimension_linear->dim_rotation, dim_rotation);
        error++;
      }
    dim_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "dim_rotation", &dim_rotation)
        && dim_rotation == dimension_linear->dim_rotation)
      {
        pass ("DIMENSION_LINEAR.dim_rotation [BD] set+1 %g", dim_rotation);
      }
    else
      {
        fail ("DIMENSION_LINEAR.dim_rotation [BD] set+1 %g != %g", dimension_linear->dim_rotation, dim_rotation);
        error++;
      }
    dimension_linear->dim_rotation--;

  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_linear->dimstyle, sizeof (dimension_linear->dimstyle)))
      {
        pass ("DIMENSION_LINEAR.dimstyle [H]");
      }
    else
      {
        fail ("DIMENSION_LINEAR.dimstyle [H]");
        error++;
      }
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "elevation", &elevation, NULL)
        && elevation == dimension_linear->elevation)
      {
        pass ("DIMENSION_LINEAR.elevation [BD] %g", elevation);
      }
    else
      {
        fail ("DIMENSION_LINEAR.elevation [BD] %g != %g", dimension_linear->elevation, elevation);
        error++;
      }
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "elevation", &elevation)
        && elevation == dimension_linear->elevation)
      {
        pass ("DIMENSION_LINEAR.elevation [BD] set+1 %g", elevation);
      }
    else
      {
        fail ("DIMENSION_LINEAR.elevation [BD] set+1 %g != %g", dimension_linear->elevation, elevation);
        error++;
      }
    dimension_linear->elevation--;

  }
  {
    BITCODE_BD ext_line_rotation;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "ext_line_rotation", &ext_line_rotation, NULL)
        && ext_line_rotation == dimension_linear->ext_line_rotation)
      {
        pass ("DIMENSION_LINEAR.ext_line_rotation [BD] %g", ext_line_rotation);
      }
    else
      {
        fail ("DIMENSION_LINEAR.ext_line_rotation [BD] %g != %g", dimension_linear->ext_line_rotation, ext_line_rotation);
        error++;
      }
    ext_line_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "ext_line_rotation", &ext_line_rotation)
        && ext_line_rotation == dimension_linear->ext_line_rotation)
      {
        pass ("DIMENSION_LINEAR.ext_line_rotation [BD] set+1 %g", ext_line_rotation);
      }
    else
      {
        fail ("DIMENSION_LINEAR.ext_line_rotation [BD] set+1 %g != %g", dimension_linear->ext_line_rotation, ext_line_rotation);
        error++;
      }
    dimension_linear->ext_line_rotation--;

  }
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_linear->extrusion, sizeof (dimension_linear->extrusion)))
      {
        pass ("DIMENSION_LINEAR.extrusion [3BD]");
      }
    else
      {
        fail ("DIMENSION_LINEAR.extrusion [3BD]");
        error++;
      }
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "flag", &flag, NULL)
        && flag == dimension_linear->flag)
      {
        pass ("DIMENSION_LINEAR.flag [RC] %u", flag);
      }
    else
      {
        fail ("DIMENSION_LINEAR.flag [RC] %u != %u", dimension_linear->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "flag", &flag)
        && flag == dimension_linear->flag)
      {
        pass ("DIMENSION_LINEAR.flag [RC] set+1 %u", flag);
      }
    else
      {
        fail ("DIMENSION_LINEAR.flag [RC] set+1 %u != %u", dimension_linear->flag, flag);
        error++;
      }
    dimension_linear->flag--;

  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "flag1", &flag1, NULL)
        && flag1 == dimension_linear->flag1)
      {
        pass ("DIMENSION_LINEAR.flag1 [RC] %u", flag1);
      }
    else
      {
        fail ("DIMENSION_LINEAR.flag1 [RC] %u != %u", dimension_linear->flag1, flag1);
        error++;
      }
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "flag1", &flag1)
        && flag1 == dimension_linear->flag1)
      {
        pass ("DIMENSION_LINEAR.flag1 [RC] set+1 %u", flag1);
      }
    else
      {
        fail ("DIMENSION_LINEAR.flag1 [RC] set+1 %u != %u", dimension_linear->flag1, flag1);
        error++;
      }
    dimension_linear->flag1--;

  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_linear->flip_arrow1)
      {
        pass ("DIMENSION_LINEAR.flip_arrow1 [B] " FORMAT_B "", flip_arrow1);
      }
    else
      {
        fail ("DIMENSION_LINEAR.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_linear->flip_arrow1, flip_arrow1);
        error++;
      }
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "flip_arrow1", &flip_arrow1)
        && flip_arrow1 == dimension_linear->flip_arrow1)
      {
        pass ("DIMENSION_LINEAR.flip_arrow1 [B] set+1 " FORMAT_B "", flip_arrow1);
      }
    else
      {
        fail ("DIMENSION_LINEAR.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_linear->flip_arrow1, flip_arrow1);
        error++;
      }
    dimension_linear->flip_arrow1--;

  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_linear->flip_arrow2)
      {
        pass ("DIMENSION_LINEAR.flip_arrow2 [B] " FORMAT_B "", flip_arrow2);
      }
    else
      {
        fail ("DIMENSION_LINEAR.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_linear->flip_arrow2, flip_arrow2);
        error++;
      }
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "flip_arrow2", &flip_arrow2)
        && flip_arrow2 == dimension_linear->flip_arrow2)
      {
        pass ("DIMENSION_LINEAR.flip_arrow2 [B] set+1 " FORMAT_B "", flip_arrow2);
      }
    else
      {
        fail ("DIMENSION_LINEAR.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_linear->flip_arrow2, flip_arrow2);
        error++;
      }
    dimension_linear->flip_arrow2--;

  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_linear->horiz_dir)
      {
        pass ("DIMENSION_LINEAR.horiz_dir [BD] %g", horiz_dir);
      }
    else
      {
        fail ("DIMENSION_LINEAR.horiz_dir [BD] %g != %g", dimension_linear->horiz_dir, horiz_dir);
        error++;
      }
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "horiz_dir", &horiz_dir)
        && horiz_dir == dimension_linear->horiz_dir)
      {
        pass ("DIMENSION_LINEAR.horiz_dir [BD] set+1 %g", horiz_dir);
      }
    else
      {
        fail ("DIMENSION_LINEAR.horiz_dir [BD] set+1 %g != %g", dimension_linear->horiz_dir, horiz_dir);
        error++;
      }
    dimension_linear->horiz_dir--;

  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_linear->ins_rotation)
      {
        pass ("DIMENSION_LINEAR.ins_rotation [BD] %g", ins_rotation);
      }
    else
      {
        fail ("DIMENSION_LINEAR.ins_rotation [BD] %g != %g", dimension_linear->ins_rotation, ins_rotation);
        error++;
      }
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "ins_rotation", &ins_rotation)
        && ins_rotation == dimension_linear->ins_rotation)
      {
        pass ("DIMENSION_LINEAR.ins_rotation [BD] set+1 %g", ins_rotation);
      }
    else
      {
        fail ("DIMENSION_LINEAR.ins_rotation [BD] set+1 %g != %g", dimension_linear->ins_rotation, ins_rotation);
        error++;
      }
    dimension_linear->ins_rotation--;

  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_linear->ins_scale, sizeof (dimension_linear->ins_scale)))
      {
        pass ("DIMENSION_LINEAR.ins_scale [3BD]");
      }
    else
      {
        fail ("DIMENSION_LINEAR.ins_scale [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_linear->lspace_factor)
      {
        pass ("DIMENSION_LINEAR.lspace_factor [BD] %g", lspace_factor);
      }
    else
      {
        fail ("DIMENSION_LINEAR.lspace_factor [BD] %g != %g", dimension_linear->lspace_factor, lspace_factor);
        error++;
      }
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "lspace_factor", &lspace_factor)
        && lspace_factor == dimension_linear->lspace_factor)
      {
        pass ("DIMENSION_LINEAR.lspace_factor [BD] set+1 %g", lspace_factor);
      }
    else
      {
        fail ("DIMENSION_LINEAR.lspace_factor [BD] set+1 %g != %g", dimension_linear->lspace_factor, lspace_factor);
        error++;
      }
    dimension_linear->lspace_factor--;

  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_linear->lspace_style)
      {
        pass ("DIMENSION_LINEAR.lspace_style [BS] %hu", lspace_style);
      }
    else
      {
        fail ("DIMENSION_LINEAR.lspace_style [BS] %hu != %hu", dimension_linear->lspace_style, lspace_style);
        error++;
      }
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "lspace_style", &lspace_style)
        && lspace_style == dimension_linear->lspace_style)
      {
        pass ("DIMENSION_LINEAR.lspace_style [BS] set+1 %hu", lspace_style);
      }
    else
      {
        fail ("DIMENSION_LINEAR.lspace_style [BS] set+1 %hu != %hu", dimension_linear->lspace_style, lspace_style);
        error++;
      }
    dimension_linear->lspace_style--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_linear->parent, sizeof (dimension_linear->parent)))
      {
        pass ("DIMENSION_LINEAR.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("DIMENSION_LINEAR.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_linear->text_midpt, sizeof (dimension_linear->text_midpt)))
      {
        pass ("DIMENSION_LINEAR.text_midpt [2RD]");
      }
    else
      {
        fail ("DIMENSION_LINEAR.text_midpt [2RD]");
        error++;
      }
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_linear->text_rotation)
      {
        pass ("DIMENSION_LINEAR.text_rotation [BD] %g", text_rotation);
      }
    else
      {
        fail ("DIMENSION_LINEAR.text_rotation [BD] %g != %g", dimension_linear->text_rotation, text_rotation);
        error++;
      }
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "text_rotation", &text_rotation)
        && text_rotation == dimension_linear->text_rotation)
      {
        pass ("DIMENSION_LINEAR.text_rotation [BD] set+1 %g", text_rotation);
      }
    else
      {
        fail ("DIMENSION_LINEAR.text_rotation [BD] set+1 %g != %g", dimension_linear->text_rotation, text_rotation);
        error++;
      }
    dimension_linear->text_rotation--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "unknown", &unknown, NULL)
        && unknown == dimension_linear->unknown)
      {
        pass ("DIMENSION_LINEAR.unknown [B] " FORMAT_B "", unknown);
      }
    else
      {
        fail ("DIMENSION_LINEAR.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_linear->unknown, unknown);
        error++;
      }
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "unknown", &unknown)
        && unknown == dimension_linear->unknown)
      {
        pass ("DIMENSION_LINEAR.unknown [B] set+1 " FORMAT_B "", unknown);
      }
    else
      {
        fail ("DIMENSION_LINEAR.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_linear->unknown, unknown);
        error++;
      }
    dimension_linear->unknown--;

  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value(dimension_linear, "DIMENSION_LINEAR", "user_text", &user_text, NULL)
        && !strcmp ((char *)user_text, (char *)dimension_linear->user_text))
      {
        pass ("DIMENSION_LINEAR.user_text [TV] '%s' <> '%s'", user_text, dimension_linear->user_text);
      }
    else
      {
        fail ("DIMENSION_LINEAR.user_text [TV] '%s' <> '%s'", user_text, dimension_linear->user_text);
        error++;
      }
  }
  return error;
}
static int test_DIMENSION_ORDINATE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_ORDINATE *restrict dimension_ordinate = obj->tio.entity->tio.DIMENSION_ORDINATE;
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_ordinate->act_measurement)
      {
        pass ("DIMENSION_ORDINATE.act_measurement [BD] %g", act_measurement);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.act_measurement [BD] %g != %g", dimension_ordinate->act_measurement, act_measurement);
        error++;
      }
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "act_measurement", &act_measurement)
        && act_measurement == dimension_ordinate->act_measurement)
      {
        pass ("DIMENSION_ORDINATE.act_measurement [BD] set+1 %g", act_measurement);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.act_measurement [BD] set+1 %g != %g", dimension_ordinate->act_measurement, act_measurement);
        error++;
      }
    dimension_ordinate->act_measurement--;

  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "attachment", &attachment, NULL)
        && attachment == dimension_ordinate->attachment)
      {
        pass ("DIMENSION_ORDINATE.attachment [BS] %hu", attachment);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.attachment [BS] %hu != %hu", dimension_ordinate->attachment, attachment);
        error++;
      }
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "attachment", &attachment)
        && attachment == dimension_ordinate->attachment)
      {
        pass ("DIMENSION_ORDINATE.attachment [BS] set+1 %hu", attachment);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.attachment [BS] set+1 %hu != %hu", dimension_ordinate->attachment, attachment);
        error++;
      }
    dimension_ordinate->attachment--;

  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "block", &block, NULL)
        && !memcmp (&block, &dimension_ordinate->block, sizeof (dimension_ordinate->block)))
      {
        pass ("DIMENSION_ORDINATE.block [H]");
      }
    else
      {
        fail ("DIMENSION_ORDINATE.block [H]");
        error++;
      }
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "blockname", &blockname, NULL)
        && !strcmp ((char *)blockname, (char *)dimension_ordinate->blockname))
      {
        pass ("DIMENSION_ORDINATE.blockname [TV] '%s' <> '%s'", blockname, dimension_ordinate->blockname);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.blockname [TV] '%s' <> '%s'", blockname, dimension_ordinate->blockname);
        error++;
      }
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "class_version", &class_version, NULL)
        && class_version == dimension_ordinate->class_version)
      {
        pass ("DIMENSION_ORDINATE.class_version [RC] %u", class_version);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.class_version [RC] %u != %u", dimension_ordinate->class_version, class_version);
        error++;
      }
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "class_version", &class_version)
        && class_version == dimension_ordinate->class_version)
      {
        pass ("DIMENSION_ORDINATE.class_version [RC] set+1 %u", class_version);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.class_version [RC] set+1 %u != %u", dimension_ordinate->class_version, class_version);
        error++;
      }
    dimension_ordinate->class_version--;

  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_ordinate->clone_ins_pt, sizeof (dimension_ordinate->clone_ins_pt)))
      {
        pass ("DIMENSION_ORDINATE.clone_ins_pt [2RD]");
      }
    else
      {
        fail ("DIMENSION_ORDINATE.clone_ins_pt [2RD]");
        error++;
      }
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_ordinate->def_pt, sizeof (dimension_ordinate->def_pt)))
      {
        pass ("DIMENSION_ORDINATE.def_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_ORDINATE.def_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_ordinate->dimstyle, sizeof (dimension_ordinate->dimstyle)))
      {
        pass ("DIMENSION_ORDINATE.dimstyle [H]");
      }
    else
      {
        fail ("DIMENSION_ORDINATE.dimstyle [H]");
        error++;
      }
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "elevation", &elevation, NULL)
        && elevation == dimension_ordinate->elevation)
      {
        pass ("DIMENSION_ORDINATE.elevation [BD] %g", elevation);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.elevation [BD] %g != %g", dimension_ordinate->elevation, elevation);
        error++;
      }
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "elevation", &elevation)
        && elevation == dimension_ordinate->elevation)
      {
        pass ("DIMENSION_ORDINATE.elevation [BD] set+1 %g", elevation);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.elevation [BD] set+1 %g != %g", dimension_ordinate->elevation, elevation);
        error++;
      }
    dimension_ordinate->elevation--;

  }
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_ordinate->extrusion, sizeof (dimension_ordinate->extrusion)))
      {
        pass ("DIMENSION_ORDINATE.extrusion [3BD]");
      }
    else
      {
        fail ("DIMENSION_ORDINATE.extrusion [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD feature_location_pt;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "feature_location_pt", &feature_location_pt, NULL)
        && !memcmp (&feature_location_pt, &dimension_ordinate->feature_location_pt, sizeof (dimension_ordinate->feature_location_pt)))
      {
        pass ("DIMENSION_ORDINATE.feature_location_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_ORDINATE.feature_location_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "flag", &flag, NULL)
        && flag == dimension_ordinate->flag)
      {
        pass ("DIMENSION_ORDINATE.flag [RC] %u", flag);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.flag [RC] %u != %u", dimension_ordinate->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "flag", &flag)
        && flag == dimension_ordinate->flag)
      {
        pass ("DIMENSION_ORDINATE.flag [RC] set+1 %u", flag);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.flag [RC] set+1 %u != %u", dimension_ordinate->flag, flag);
        error++;
      }
    dimension_ordinate->flag--;

  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "flag1", &flag1, NULL)
        && flag1 == dimension_ordinate->flag1)
      {
        pass ("DIMENSION_ORDINATE.flag1 [RC] %u", flag1);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.flag1 [RC] %u != %u", dimension_ordinate->flag1, flag1);
        error++;
      }
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "flag1", &flag1)
        && flag1 == dimension_ordinate->flag1)
      {
        pass ("DIMENSION_ORDINATE.flag1 [RC] set+1 %u", flag1);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.flag1 [RC] set+1 %u != %u", dimension_ordinate->flag1, flag1);
        error++;
      }
    dimension_ordinate->flag1--;

  }
  {
    BITCODE_RC flag2;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "flag2", &flag2, NULL)
        && flag2 == dimension_ordinate->flag2)
      {
        pass ("DIMENSION_ORDINATE.flag2 [RC] %u", flag2);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.flag2 [RC] %u != %u", dimension_ordinate->flag2, flag2);
        error++;
      }
    flag2++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "flag2", &flag2)
        && flag2 == dimension_ordinate->flag2)
      {
        pass ("DIMENSION_ORDINATE.flag2 [RC] set+1 %u", flag2);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.flag2 [RC] set+1 %u != %u", dimension_ordinate->flag2, flag2);
        error++;
      }
    dimension_ordinate->flag2--;

  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_ordinate->flip_arrow1)
      {
        pass ("DIMENSION_ORDINATE.flip_arrow1 [B] " FORMAT_B "", flip_arrow1);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_ordinate->flip_arrow1, flip_arrow1);
        error++;
      }
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "flip_arrow1", &flip_arrow1)
        && flip_arrow1 == dimension_ordinate->flip_arrow1)
      {
        pass ("DIMENSION_ORDINATE.flip_arrow1 [B] set+1 " FORMAT_B "", flip_arrow1);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ordinate->flip_arrow1, flip_arrow1);
        error++;
      }
    dimension_ordinate->flip_arrow1--;

  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_ordinate->flip_arrow2)
      {
        pass ("DIMENSION_ORDINATE.flip_arrow2 [B] " FORMAT_B "", flip_arrow2);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_ordinate->flip_arrow2, flip_arrow2);
        error++;
      }
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "flip_arrow2", &flip_arrow2)
        && flip_arrow2 == dimension_ordinate->flip_arrow2)
      {
        pass ("DIMENSION_ORDINATE.flip_arrow2 [B] set+1 " FORMAT_B "", flip_arrow2);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ordinate->flip_arrow2, flip_arrow2);
        error++;
      }
    dimension_ordinate->flip_arrow2--;

  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_ordinate->horiz_dir)
      {
        pass ("DIMENSION_ORDINATE.horiz_dir [BD] %g", horiz_dir);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.horiz_dir [BD] %g != %g", dimension_ordinate->horiz_dir, horiz_dir);
        error++;
      }
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "horiz_dir", &horiz_dir)
        && horiz_dir == dimension_ordinate->horiz_dir)
      {
        pass ("DIMENSION_ORDINATE.horiz_dir [BD] set+1 %g", horiz_dir);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.horiz_dir [BD] set+1 %g != %g", dimension_ordinate->horiz_dir, horiz_dir);
        error++;
      }
    dimension_ordinate->horiz_dir--;

  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_ordinate->ins_rotation)
      {
        pass ("DIMENSION_ORDINATE.ins_rotation [BD] %g", ins_rotation);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.ins_rotation [BD] %g != %g", dimension_ordinate->ins_rotation, ins_rotation);
        error++;
      }
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "ins_rotation", &ins_rotation)
        && ins_rotation == dimension_ordinate->ins_rotation)
      {
        pass ("DIMENSION_ORDINATE.ins_rotation [BD] set+1 %g", ins_rotation);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.ins_rotation [BD] set+1 %g != %g", dimension_ordinate->ins_rotation, ins_rotation);
        error++;
      }
    dimension_ordinate->ins_rotation--;

  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_ordinate->ins_scale, sizeof (dimension_ordinate->ins_scale)))
      {
        pass ("DIMENSION_ORDINATE.ins_scale [3BD]");
      }
    else
      {
        fail ("DIMENSION_ORDINATE.ins_scale [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD leader_endpt;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "leader_endpt", &leader_endpt, NULL)
        && !memcmp (&leader_endpt, &dimension_ordinate->leader_endpt, sizeof (dimension_ordinate->leader_endpt)))
      {
        pass ("DIMENSION_ORDINATE.leader_endpt [3BD]");
      }
    else
      {
        fail ("DIMENSION_ORDINATE.leader_endpt [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_ordinate->lspace_factor)
      {
        pass ("DIMENSION_ORDINATE.lspace_factor [BD] %g", lspace_factor);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.lspace_factor [BD] %g != %g", dimension_ordinate->lspace_factor, lspace_factor);
        error++;
      }
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "lspace_factor", &lspace_factor)
        && lspace_factor == dimension_ordinate->lspace_factor)
      {
        pass ("DIMENSION_ORDINATE.lspace_factor [BD] set+1 %g", lspace_factor);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.lspace_factor [BD] set+1 %g != %g", dimension_ordinate->lspace_factor, lspace_factor);
        error++;
      }
    dimension_ordinate->lspace_factor--;

  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_ordinate->lspace_style)
      {
        pass ("DIMENSION_ORDINATE.lspace_style [BS] %hu", lspace_style);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.lspace_style [BS] %hu != %hu", dimension_ordinate->lspace_style, lspace_style);
        error++;
      }
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "lspace_style", &lspace_style)
        && lspace_style == dimension_ordinate->lspace_style)
      {
        pass ("DIMENSION_ORDINATE.lspace_style [BS] set+1 %hu", lspace_style);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.lspace_style [BS] set+1 %hu != %hu", dimension_ordinate->lspace_style, lspace_style);
        error++;
      }
    dimension_ordinate->lspace_style--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_ordinate->parent, sizeof (dimension_ordinate->parent)))
      {
        pass ("DIMENSION_ORDINATE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("DIMENSION_ORDINATE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_ordinate->text_midpt, sizeof (dimension_ordinate->text_midpt)))
      {
        pass ("DIMENSION_ORDINATE.text_midpt [2RD]");
      }
    else
      {
        fail ("DIMENSION_ORDINATE.text_midpt [2RD]");
        error++;
      }
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_ordinate->text_rotation)
      {
        pass ("DIMENSION_ORDINATE.text_rotation [BD] %g", text_rotation);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.text_rotation [BD] %g != %g", dimension_ordinate->text_rotation, text_rotation);
        error++;
      }
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "text_rotation", &text_rotation)
        && text_rotation == dimension_ordinate->text_rotation)
      {
        pass ("DIMENSION_ORDINATE.text_rotation [BD] set+1 %g", text_rotation);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.text_rotation [BD] set+1 %g != %g", dimension_ordinate->text_rotation, text_rotation);
        error++;
      }
    dimension_ordinate->text_rotation--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "unknown", &unknown, NULL)
        && unknown == dimension_ordinate->unknown)
      {
        pass ("DIMENSION_ORDINATE.unknown [B] " FORMAT_B "", unknown);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_ordinate->unknown, unknown);
        error++;
      }
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "unknown", &unknown)
        && unknown == dimension_ordinate->unknown)
      {
        pass ("DIMENSION_ORDINATE.unknown [B] set+1 " FORMAT_B "", unknown);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ordinate->unknown, unknown);
        error++;
      }
    dimension_ordinate->unknown--;

  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value(dimension_ordinate, "DIMENSION_ORDINATE", "user_text", &user_text, NULL)
        && !strcmp ((char *)user_text, (char *)dimension_ordinate->user_text))
      {
        pass ("DIMENSION_ORDINATE.user_text [TV] '%s' <> '%s'", user_text, dimension_ordinate->user_text);
      }
    else
      {
        fail ("DIMENSION_ORDINATE.user_text [TV] '%s' <> '%s'", user_text, dimension_ordinate->user_text);
        error++;
      }
  }
  return error;
}
static int test_DIMENSION_RADIUS (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_RADIUS *restrict dimension_radius = obj->tio.entity->tio.DIMENSION_RADIUS;
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_radius->act_measurement)
      {
        pass ("DIMENSION_RADIUS.act_measurement [BD] %g", act_measurement);
      }
    else
      {
        fail ("DIMENSION_RADIUS.act_measurement [BD] %g != %g", dimension_radius->act_measurement, act_measurement);
        error++;
      }
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "act_measurement", &act_measurement)
        && act_measurement == dimension_radius->act_measurement)
      {
        pass ("DIMENSION_RADIUS.act_measurement [BD] set+1 %g", act_measurement);
      }
    else
      {
        fail ("DIMENSION_RADIUS.act_measurement [BD] set+1 %g != %g", dimension_radius->act_measurement, act_measurement);
        error++;
      }
    dimension_radius->act_measurement--;

  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "attachment", &attachment, NULL)
        && attachment == dimension_radius->attachment)
      {
        pass ("DIMENSION_RADIUS.attachment [BS] %hu", attachment);
      }
    else
      {
        fail ("DIMENSION_RADIUS.attachment [BS] %hu != %hu", dimension_radius->attachment, attachment);
        error++;
      }
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "attachment", &attachment)
        && attachment == dimension_radius->attachment)
      {
        pass ("DIMENSION_RADIUS.attachment [BS] set+1 %hu", attachment);
      }
    else
      {
        fail ("DIMENSION_RADIUS.attachment [BS] set+1 %hu != %hu", dimension_radius->attachment, attachment);
        error++;
      }
    dimension_radius->attachment--;

  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "block", &block, NULL)
        && !memcmp (&block, &dimension_radius->block, sizeof (dimension_radius->block)))
      {
        pass ("DIMENSION_RADIUS.block [H]");
      }
    else
      {
        fail ("DIMENSION_RADIUS.block [H]");
        error++;
      }
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "blockname", &blockname, NULL)
        && !strcmp ((char *)blockname, (char *)dimension_radius->blockname))
      {
        pass ("DIMENSION_RADIUS.blockname [TV] '%s' <> '%s'", blockname, dimension_radius->blockname);
      }
    else
      {
        fail ("DIMENSION_RADIUS.blockname [TV] '%s' <> '%s'", blockname, dimension_radius->blockname);
        error++;
      }
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "class_version", &class_version, NULL)
        && class_version == dimension_radius->class_version)
      {
        pass ("DIMENSION_RADIUS.class_version [RC] %u", class_version);
      }
    else
      {
        fail ("DIMENSION_RADIUS.class_version [RC] %u != %u", dimension_radius->class_version, class_version);
        error++;
      }
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "class_version", &class_version)
        && class_version == dimension_radius->class_version)
      {
        pass ("DIMENSION_RADIUS.class_version [RC] set+1 %u", class_version);
      }
    else
      {
        fail ("DIMENSION_RADIUS.class_version [RC] set+1 %u != %u", dimension_radius->class_version, class_version);
        error++;
      }
    dimension_radius->class_version--;

  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_radius->clone_ins_pt, sizeof (dimension_radius->clone_ins_pt)))
      {
        pass ("DIMENSION_RADIUS.clone_ins_pt [2RD]");
      }
    else
      {
        fail ("DIMENSION_RADIUS.clone_ins_pt [2RD]");
        error++;
      }
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_radius->def_pt, sizeof (dimension_radius->def_pt)))
      {
        pass ("DIMENSION_RADIUS.def_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_RADIUS.def_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_radius->dimstyle, sizeof (dimension_radius->dimstyle)))
      {
        pass ("DIMENSION_RADIUS.dimstyle [H]");
      }
    else
      {
        fail ("DIMENSION_RADIUS.dimstyle [H]");
        error++;
      }
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "elevation", &elevation, NULL)
        && elevation == dimension_radius->elevation)
      {
        pass ("DIMENSION_RADIUS.elevation [BD] %g", elevation);
      }
    else
      {
        fail ("DIMENSION_RADIUS.elevation [BD] %g != %g", dimension_radius->elevation, elevation);
        error++;
      }
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "elevation", &elevation)
        && elevation == dimension_radius->elevation)
      {
        pass ("DIMENSION_RADIUS.elevation [BD] set+1 %g", elevation);
      }
    else
      {
        fail ("DIMENSION_RADIUS.elevation [BD] set+1 %g != %g", dimension_radius->elevation, elevation);
        error++;
      }
    dimension_radius->elevation--;

  }
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_radius->extrusion, sizeof (dimension_radius->extrusion)))
      {
        pass ("DIMENSION_RADIUS.extrusion [3BD]");
      }
    else
      {
        fail ("DIMENSION_RADIUS.extrusion [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD first_arc_pt;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "first_arc_pt", &first_arc_pt, NULL)
        && !memcmp (&first_arc_pt, &dimension_radius->first_arc_pt, sizeof (dimension_radius->first_arc_pt)))
      {
        pass ("DIMENSION_RADIUS.first_arc_pt [3BD]");
      }
    else
      {
        fail ("DIMENSION_RADIUS.first_arc_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "flag", &flag, NULL)
        && flag == dimension_radius->flag)
      {
        pass ("DIMENSION_RADIUS.flag [RC] %u", flag);
      }
    else
      {
        fail ("DIMENSION_RADIUS.flag [RC] %u != %u", dimension_radius->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "flag", &flag)
        && flag == dimension_radius->flag)
      {
        pass ("DIMENSION_RADIUS.flag [RC] set+1 %u", flag);
      }
    else
      {
        fail ("DIMENSION_RADIUS.flag [RC] set+1 %u != %u", dimension_radius->flag, flag);
        error++;
      }
    dimension_radius->flag--;

  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "flag1", &flag1, NULL)
        && flag1 == dimension_radius->flag1)
      {
        pass ("DIMENSION_RADIUS.flag1 [RC] %u", flag1);
      }
    else
      {
        fail ("DIMENSION_RADIUS.flag1 [RC] %u != %u", dimension_radius->flag1, flag1);
        error++;
      }
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "flag1", &flag1)
        && flag1 == dimension_radius->flag1)
      {
        pass ("DIMENSION_RADIUS.flag1 [RC] set+1 %u", flag1);
      }
    else
      {
        fail ("DIMENSION_RADIUS.flag1 [RC] set+1 %u != %u", dimension_radius->flag1, flag1);
        error++;
      }
    dimension_radius->flag1--;

  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_radius->flip_arrow1)
      {
        pass ("DIMENSION_RADIUS.flip_arrow1 [B] " FORMAT_B "", flip_arrow1);
      }
    else
      {
        fail ("DIMENSION_RADIUS.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_radius->flip_arrow1, flip_arrow1);
        error++;
      }
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "flip_arrow1", &flip_arrow1)
        && flip_arrow1 == dimension_radius->flip_arrow1)
      {
        pass ("DIMENSION_RADIUS.flip_arrow1 [B] set+1 " FORMAT_B "", flip_arrow1);
      }
    else
      {
        fail ("DIMENSION_RADIUS.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_radius->flip_arrow1, flip_arrow1);
        error++;
      }
    dimension_radius->flip_arrow1--;

  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_radius->flip_arrow2)
      {
        pass ("DIMENSION_RADIUS.flip_arrow2 [B] " FORMAT_B "", flip_arrow2);
      }
    else
      {
        fail ("DIMENSION_RADIUS.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_radius->flip_arrow2, flip_arrow2);
        error++;
      }
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "flip_arrow2", &flip_arrow2)
        && flip_arrow2 == dimension_radius->flip_arrow2)
      {
        pass ("DIMENSION_RADIUS.flip_arrow2 [B] set+1 " FORMAT_B "", flip_arrow2);
      }
    else
      {
        fail ("DIMENSION_RADIUS.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_radius->flip_arrow2, flip_arrow2);
        error++;
      }
    dimension_radius->flip_arrow2--;

  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_radius->horiz_dir)
      {
        pass ("DIMENSION_RADIUS.horiz_dir [BD] %g", horiz_dir);
      }
    else
      {
        fail ("DIMENSION_RADIUS.horiz_dir [BD] %g != %g", dimension_radius->horiz_dir, horiz_dir);
        error++;
      }
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "horiz_dir", &horiz_dir)
        && horiz_dir == dimension_radius->horiz_dir)
      {
        pass ("DIMENSION_RADIUS.horiz_dir [BD] set+1 %g", horiz_dir);
      }
    else
      {
        fail ("DIMENSION_RADIUS.horiz_dir [BD] set+1 %g != %g", dimension_radius->horiz_dir, horiz_dir);
        error++;
      }
    dimension_radius->horiz_dir--;

  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_radius->ins_rotation)
      {
        pass ("DIMENSION_RADIUS.ins_rotation [BD] %g", ins_rotation);
      }
    else
      {
        fail ("DIMENSION_RADIUS.ins_rotation [BD] %g != %g", dimension_radius->ins_rotation, ins_rotation);
        error++;
      }
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "ins_rotation", &ins_rotation)
        && ins_rotation == dimension_radius->ins_rotation)
      {
        pass ("DIMENSION_RADIUS.ins_rotation [BD] set+1 %g", ins_rotation);
      }
    else
      {
        fail ("DIMENSION_RADIUS.ins_rotation [BD] set+1 %g != %g", dimension_radius->ins_rotation, ins_rotation);
        error++;
      }
    dimension_radius->ins_rotation--;

  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_radius->ins_scale, sizeof (dimension_radius->ins_scale)))
      {
        pass ("DIMENSION_RADIUS.ins_scale [3BD]");
      }
    else
      {
        fail ("DIMENSION_RADIUS.ins_scale [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD leader_len;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "leader_len", &leader_len, NULL)
        && leader_len == dimension_radius->leader_len)
      {
        pass ("DIMENSION_RADIUS.leader_len [BD] %g", leader_len);
      }
    else
      {
        fail ("DIMENSION_RADIUS.leader_len [BD] %g != %g", dimension_radius->leader_len, leader_len);
        error++;
      }
    leader_len++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "leader_len", &leader_len)
        && leader_len == dimension_radius->leader_len)
      {
        pass ("DIMENSION_RADIUS.leader_len [BD] set+1 %g", leader_len);
      }
    else
      {
        fail ("DIMENSION_RADIUS.leader_len [BD] set+1 %g != %g", dimension_radius->leader_len, leader_len);
        error++;
      }
    dimension_radius->leader_len--;

  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_radius->lspace_factor)
      {
        pass ("DIMENSION_RADIUS.lspace_factor [BD] %g", lspace_factor);
      }
    else
      {
        fail ("DIMENSION_RADIUS.lspace_factor [BD] %g != %g", dimension_radius->lspace_factor, lspace_factor);
        error++;
      }
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "lspace_factor", &lspace_factor)
        && lspace_factor == dimension_radius->lspace_factor)
      {
        pass ("DIMENSION_RADIUS.lspace_factor [BD] set+1 %g", lspace_factor);
      }
    else
      {
        fail ("DIMENSION_RADIUS.lspace_factor [BD] set+1 %g != %g", dimension_radius->lspace_factor, lspace_factor);
        error++;
      }
    dimension_radius->lspace_factor--;

  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_radius->lspace_style)
      {
        pass ("DIMENSION_RADIUS.lspace_style [BS] %hu", lspace_style);
      }
    else
      {
        fail ("DIMENSION_RADIUS.lspace_style [BS] %hu != %hu", dimension_radius->lspace_style, lspace_style);
        error++;
      }
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "lspace_style", &lspace_style)
        && lspace_style == dimension_radius->lspace_style)
      {
        pass ("DIMENSION_RADIUS.lspace_style [BS] set+1 %hu", lspace_style);
      }
    else
      {
        fail ("DIMENSION_RADIUS.lspace_style [BS] set+1 %hu != %hu", dimension_radius->lspace_style, lspace_style);
        error++;
      }
    dimension_radius->lspace_style--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_radius->parent, sizeof (dimension_radius->parent)))
      {
        pass ("DIMENSION_RADIUS.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("DIMENSION_RADIUS.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_radius->text_midpt, sizeof (dimension_radius->text_midpt)))
      {
        pass ("DIMENSION_RADIUS.text_midpt [2RD]");
      }
    else
      {
        fail ("DIMENSION_RADIUS.text_midpt [2RD]");
        error++;
      }
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_radius->text_rotation)
      {
        pass ("DIMENSION_RADIUS.text_rotation [BD] %g", text_rotation);
      }
    else
      {
        fail ("DIMENSION_RADIUS.text_rotation [BD] %g != %g", dimension_radius->text_rotation, text_rotation);
        error++;
      }
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "text_rotation", &text_rotation)
        && text_rotation == dimension_radius->text_rotation)
      {
        pass ("DIMENSION_RADIUS.text_rotation [BD] set+1 %g", text_rotation);
      }
    else
      {
        fail ("DIMENSION_RADIUS.text_rotation [BD] set+1 %g != %g", dimension_radius->text_rotation, text_rotation);
        error++;
      }
    dimension_radius->text_rotation--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "unknown", &unknown, NULL)
        && unknown == dimension_radius->unknown)
      {
        pass ("DIMENSION_RADIUS.unknown [B] " FORMAT_B "", unknown);
      }
    else
      {
        fail ("DIMENSION_RADIUS.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_radius->unknown, unknown);
        error++;
      }
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "unknown", &unknown)
        && unknown == dimension_radius->unknown)
      {
        pass ("DIMENSION_RADIUS.unknown [B] set+1 " FORMAT_B "", unknown);
      }
    else
      {
        fail ("DIMENSION_RADIUS.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_radius->unknown, unknown);
        error++;
      }
    dimension_radius->unknown--;

  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value(dimension_radius, "DIMENSION_RADIUS", "user_text", &user_text, NULL)
        && !strcmp ((char *)user_text, (char *)dimension_radius->user_text))
      {
        pass ("DIMENSION_RADIUS.user_text [TV] '%s' <> '%s'", user_text, dimension_radius->user_text);
      }
    else
      {
        fail ("DIMENSION_RADIUS.user_text [TV] '%s' <> '%s'", user_text, dimension_radius->user_text);
        error++;
      }
  }
  return error;
}
static int test_ELLIPSE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ELLIPSE *restrict ellipse = obj->tio.entity->tio.ELLIPSE;
  {
    BITCODE_BD axis_ratio;
    if (dwg_dynapi_entity_value(ellipse, "ELLIPSE", "axis_ratio", &axis_ratio, NULL)
        && axis_ratio == ellipse->axis_ratio)
      {
        pass ("ELLIPSE.axis_ratio [BD] %g", axis_ratio);
      }
    else
      {
        fail ("ELLIPSE.axis_ratio [BD] %g != %g", ellipse->axis_ratio, axis_ratio);
        error++;
      }
    axis_ratio++;
    if (dwg_dynapi_entity_set_value (ellipse, "ELLIPSE", "axis_ratio", &axis_ratio)
        && axis_ratio == ellipse->axis_ratio)
      {
        pass ("ELLIPSE.axis_ratio [BD] set+1 %g", axis_ratio);
      }
    else
      {
        fail ("ELLIPSE.axis_ratio [BD] set+1 %g != %g", ellipse->axis_ratio, axis_ratio);
        error++;
      }
    ellipse->axis_ratio--;

  }
  {
    BITCODE_3BD center;
    if (dwg_dynapi_entity_value(ellipse, "ELLIPSE", "center", &center, NULL)
        && !memcmp (&center, &ellipse->center, sizeof (ellipse->center)))
      {
        pass ("ELLIPSE.center [3BD]");
      }
    else
      {
        fail ("ELLIPSE.center [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD end_angle;
    if (dwg_dynapi_entity_value(ellipse, "ELLIPSE", "end_angle", &end_angle, NULL)
        && end_angle == ellipse->end_angle)
      {
        pass ("ELLIPSE.end_angle [BD] %g", end_angle);
      }
    else
      {
        fail ("ELLIPSE.end_angle [BD] %g != %g", ellipse->end_angle, end_angle);
        error++;
      }
    end_angle++;
    if (dwg_dynapi_entity_set_value (ellipse, "ELLIPSE", "end_angle", &end_angle)
        && end_angle == ellipse->end_angle)
      {
        pass ("ELLIPSE.end_angle [BD] set+1 %g", end_angle);
      }
    else
      {
        fail ("ELLIPSE.end_angle [BD] set+1 %g != %g", ellipse->end_angle, end_angle);
        error++;
      }
    ellipse->end_angle--;

  }
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value(ellipse, "ELLIPSE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &ellipse->extrusion, sizeof (ellipse->extrusion)))
      {
        pass ("ELLIPSE.extrusion [3BD]");
      }
    else
      {
        fail ("ELLIPSE.extrusion [3BD]");
        error++;
      }
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(ellipse, "ELLIPSE", "parent", &parent, NULL)
        && !memcmp (&parent, &ellipse->parent, sizeof (ellipse->parent)))
      {
        pass ("ELLIPSE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("ELLIPSE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_3BD sm_axis;
    if (dwg_dynapi_entity_value(ellipse, "ELLIPSE", "sm_axis", &sm_axis, NULL)
        && !memcmp (&sm_axis, &ellipse->sm_axis, sizeof (ellipse->sm_axis)))
      {
        pass ("ELLIPSE.sm_axis [3BD]");
      }
    else
      {
        fail ("ELLIPSE.sm_axis [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD start_angle;
    if (dwg_dynapi_entity_value(ellipse, "ELLIPSE", "start_angle", &start_angle, NULL)
        && start_angle == ellipse->start_angle)
      {
        pass ("ELLIPSE.start_angle [BD] %g", start_angle);
      }
    else
      {
        fail ("ELLIPSE.start_angle [BD] %g != %g", ellipse->start_angle, start_angle);
        error++;
      }
    start_angle++;
    if (dwg_dynapi_entity_set_value (ellipse, "ELLIPSE", "start_angle", &start_angle)
        && start_angle == ellipse->start_angle)
      {
        pass ("ELLIPSE.start_angle [BD] set+1 %g", start_angle);
      }
    else
      {
        fail ("ELLIPSE.start_angle [BD] set+1 %g != %g", ellipse->start_angle, start_angle);
        error++;
      }
    ellipse->start_angle--;

  }
  return error;
}
static int test_ENDBLK (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ENDBLK *restrict endblk = obj->tio.entity->tio.ENDBLK;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(endblk, "ENDBLK", "parent", &parent, NULL)
        && !memcmp (&parent, &endblk->parent, sizeof (endblk->parent)))
      {
        pass ("ENDBLK.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("ENDBLK.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  return error;
}
static int test_EXTRUDEDSURFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_EXTRUDEDSURFACE *restrict extrudedsurface = obj->tio.entity->tio.EXTRUDEDSURFACE;
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "acis_data", &acis_data, NULL)
        && !strcmp ((char *)acis_data, (char *)extrudedsurface->acis_data))
      {
        pass ("EXTRUDEDSURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, extrudedsurface->acis_data);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, extrudedsurface->acis_data);
        error++;
      }
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "acis_empty", &acis_empty, NULL)
        && acis_empty == extrudedsurface->acis_empty)
      {
        pass ("EXTRUDEDSURFACE.acis_empty [B] " FORMAT_B "", acis_empty);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.acis_empty [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->acis_empty, acis_empty);
        error++;
      }
    acis_empty++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "acis_empty", &acis_empty)
        && acis_empty == extrudedsurface->acis_empty)
      {
        pass ("EXTRUDEDSURFACE.acis_empty [B] set+1 " FORMAT_B "", acis_empty);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->acis_empty, acis_empty);
        error++;
      }
    extrudedsurface->acis_empty--;

  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == extrudedsurface->acis_empty2)
      {
        pass ("EXTRUDEDSURFACE.acis_empty2 [B] " FORMAT_B "", acis_empty2);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->acis_empty2, acis_empty2);
        error++;
      }
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "acis_empty2", &acis_empty2)
        && acis_empty2 == extrudedsurface->acis_empty2)
      {
        pass ("EXTRUDEDSURFACE.acis_empty2 [B] set+1 " FORMAT_B "", acis_empty2);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->acis_empty2, acis_empty2);
        error++;
      }
    extrudedsurface->acis_empty2--;

  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == extrudedsurface->acis_empty_bit)
      {
        pass ("EXTRUDEDSURFACE.acis_empty_bit [B] " FORMAT_B "", acis_empty_bit);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->acis_empty_bit, acis_empty_bit);
        error++;
      }
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "acis_empty_bit", &acis_empty_bit)
        && acis_empty_bit == extrudedsurface->acis_empty_bit)
      {
        pass ("EXTRUDEDSURFACE.acis_empty_bit [B] set+1 " FORMAT_B "", acis_empty_bit);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->acis_empty_bit, acis_empty_bit);
        error++;
      }
    extrudedsurface->acis_empty_bit--;

  }
  {
    BITCODE_BD align_angle;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "align_angle", &align_angle, NULL)
        && align_angle == extrudedsurface->align_angle)
      {
        pass ("EXTRUDEDSURFACE.align_angle [BD] %g", align_angle);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.align_angle [BD] %g != %g", extrudedsurface->align_angle, align_angle);
        error++;
      }
    align_angle++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "align_angle", &align_angle)
        && align_angle == extrudedsurface->align_angle)
      {
        pass ("EXTRUDEDSURFACE.align_angle [BD] set+1 %g", align_angle);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.align_angle [BD] set+1 %g != %g", extrudedsurface->align_angle, align_angle);
        error++;
      }
    extrudedsurface->align_angle--;

  }
  {
    BITCODE_B align_start;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "align_start", &align_start, NULL)
        && align_start == extrudedsurface->align_start)
      {
        pass ("EXTRUDEDSURFACE.align_start [B] " FORMAT_B "", align_start);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.align_start [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->align_start, align_start);
        error++;
      }
    align_start++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "align_start", &align_start)
        && align_start == extrudedsurface->align_start)
      {
        pass ("EXTRUDEDSURFACE.align_start [B] set+1 " FORMAT_B "", align_start);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.align_start [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->align_start, align_start);
        error++;
      }
    extrudedsurface->align_start--;

  }
  {
    BITCODE_B bank;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "bank", &bank, NULL)
        && bank == extrudedsurface->bank)
      {
        pass ("EXTRUDEDSURFACE.bank [B] " FORMAT_B "", bank);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.bank [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->bank, bank);
        error++;
      }
    bank++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "bank", &bank)
        && bank == extrudedsurface->bank)
      {
        pass ("EXTRUDEDSURFACE.bank [B] set+1 " FORMAT_B "", bank);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.bank [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->bank, bank);
        error++;
      }
    extrudedsurface->bank--;

  }
  {
    BITCODE_B base_point_set;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "base_point_set", &base_point_set, NULL)
        && base_point_set == extrudedsurface->base_point_set)
      {
        pass ("EXTRUDEDSURFACE.base_point_set [B] " FORMAT_B "", base_point_set);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.base_point_set [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->base_point_set, base_point_set);
        error++;
      }
    base_point_set++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "base_point_set", &base_point_set)
        && base_point_set == extrudedsurface->base_point_set)
      {
        pass ("EXTRUDEDSURFACE.base_point_set [B] set+1 " FORMAT_B "", base_point_set);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.base_point_set [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->base_point_set, base_point_set);
        error++;
      }
    extrudedsurface->base_point_set--;

  }
  {
    BITCODE_TF bindata;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "bindata", &bindata, NULL)
        && !memcmp (&bindata, &extrudedsurface->bindata, sizeof (extrudedsurface->bindata)))
      {
        pass ("EXTRUDEDSURFACE.bindata [TF]");
      }
    else
      {
        fail ("EXTRUDEDSURFACE.bindata [TF]");
        error++;
      }
  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &extrudedsurface->block_size, sizeof (extrudedsurface->block_size)))
      {
        pass ("EXTRUDEDSURFACE.block_size [BL*]");
      }
    else
      {
        fail ("EXTRUDEDSURFACE.block_size [BL*]");
        error++;
      }
  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "class_version", &class_version, NULL)
        && class_version == extrudedsurface->class_version)
      {
        pass ("EXTRUDEDSURFACE.class_version [BL] %u", class_version);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.class_version [BL] %u != %u", extrudedsurface->class_version, class_version);
        error++;
      }
    class_version++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "class_version", &class_version)
        && class_version == extrudedsurface->class_version)
      {
        pass ("EXTRUDEDSURFACE.class_version [BL] set+1 %u", class_version);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.class_version [BL] set+1 %u != %u", extrudedsurface->class_version, class_version);
        error++;
      }
    extrudedsurface->class_version--;

  }
  {
    BITCODE_BD draft_angle;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "draft_angle", &draft_angle, NULL)
        && draft_angle == extrudedsurface->draft_angle)
      {
        pass ("EXTRUDEDSURFACE.draft_angle [BD] %g", draft_angle);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.draft_angle [BD] %g != %g", extrudedsurface->draft_angle, draft_angle);
        error++;
      }
    draft_angle++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "draft_angle", &draft_angle)
        && draft_angle == extrudedsurface->draft_angle)
      {
        pass ("EXTRUDEDSURFACE.draft_angle [BD] set+1 %g", draft_angle);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.draft_angle [BD] set+1 %g != %g", extrudedsurface->draft_angle, draft_angle);
        error++;
      }
    extrudedsurface->draft_angle--;

  }
  {
    BITCODE_BD draft_end_distance;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "draft_end_distance", &draft_end_distance, NULL)
        && draft_end_distance == extrudedsurface->draft_end_distance)
      {
        pass ("EXTRUDEDSURFACE.draft_end_distance [BD] %g", draft_end_distance);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.draft_end_distance [BD] %g != %g", extrudedsurface->draft_end_distance, draft_end_distance);
        error++;
      }
    draft_end_distance++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "draft_end_distance", &draft_end_distance)
        && draft_end_distance == extrudedsurface->draft_end_distance)
      {
        pass ("EXTRUDEDSURFACE.draft_end_distance [BD] set+1 %g", draft_end_distance);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.draft_end_distance [BD] set+1 %g != %g", extrudedsurface->draft_end_distance, draft_end_distance);
        error++;
      }
    extrudedsurface->draft_end_distance--;

  }
  {
    BITCODE_BD draft_start_distance;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "draft_start_distance", &draft_start_distance, NULL)
        && draft_start_distance == extrudedsurface->draft_start_distance)
      {
        pass ("EXTRUDEDSURFACE.draft_start_distance [BD] %g", draft_start_distance);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.draft_start_distance [BD] %g != %g", extrudedsurface->draft_start_distance, draft_start_distance);
        error++;
      }
    draft_start_distance++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "draft_start_distance", &draft_start_distance)
        && draft_start_distance == extrudedsurface->draft_start_distance)
      {
        pass ("EXTRUDEDSURFACE.draft_start_distance [BD] set+1 %g", draft_start_distance);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.draft_start_distance [BD] set+1 %g != %g", extrudedsurface->draft_start_distance, draft_start_distance);
        error++;
      }
    extrudedsurface->draft_start_distance--;

  }
  {
    char ** encr_sat_data;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "num_encr_sat_data", &count, NULL)
        && dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "encr_sat_data", &encr_sat_data, NULL)
)
      {
        pass ("EXTRUDEDSURFACE.encr_sat_data [char **] * %u num_encr_sat_data", count);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.encr_sat_data [char **] * %u num_encr_sat_data", count);
        error++;
      }
  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &extrudedsurface->extra_acis_data, sizeof (extrudedsurface->extra_acis_data)))
      {
        pass ("EXTRUDEDSURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
      }
    else
      {
        fail ("EXTRUDEDSURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
        error++;
      }
  }
  {
    BITCODE_BD height;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "height", &height, NULL)
        && height == extrudedsurface->height)
      {
        pass ("EXTRUDEDSURFACE.height [BD] %g", height);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.height [BD] %g != %g", extrudedsurface->height, height);
        error++;
      }
    height++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "height", &height)
        && height == extrudedsurface->height)
      {
        pass ("EXTRUDEDSURFACE.height [BD] set+1 %g", height);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.height [BD] set+1 %g != %g", extrudedsurface->height, height);
        error++;
      }
    extrudedsurface->height--;

  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &extrudedsurface->history_id, sizeof (extrudedsurface->history_id)))
      {
        pass ("EXTRUDEDSURFACE.history_id [H]");
      }
    else
      {
        fail ("EXTRUDEDSURFACE.history_id [H]");
        error++;
      }
  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "isoline_present", &isoline_present, NULL)
        && isoline_present == extrudedsurface->isoline_present)
      {
        pass ("EXTRUDEDSURFACE.isoline_present [B] " FORMAT_B "", isoline_present);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.isoline_present [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->isoline_present, isoline_present);
        error++;
      }
    isoline_present++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "isoline_present", &isoline_present)
        && isoline_present == extrudedsurface->isoline_present)
      {
        pass ("EXTRUDEDSURFACE.isoline_present [B] set+1 " FORMAT_B "", isoline_present);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->isoline_present, isoline_present);
        error++;
      }
    extrudedsurface->isoline_present--;

  }
  {
    BITCODE_BS modeler_format_version;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "modeler_format_version", &modeler_format_version, NULL)
        && modeler_format_version == extrudedsurface->modeler_format_version)
      {
        pass ("EXTRUDEDSURFACE.modeler_format_version [BS] %hu", modeler_format_version);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.modeler_format_version [BS] %hu != %hu", extrudedsurface->modeler_format_version, modeler_format_version);
        error++;
      }
    modeler_format_version++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "modeler_format_version", &modeler_format_version)
        && modeler_format_version == extrudedsurface->modeler_format_version)
      {
        pass ("EXTRUDEDSURFACE.modeler_format_version [BS] set+1 %hu", modeler_format_version);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.modeler_format_version [BS] set+1 %hu != %hu", extrudedsurface->modeler_format_version, modeler_format_version);
        error++;
      }
    extrudedsurface->modeler_format_version--;

  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "num_blocks", &num_blocks, NULL)
        && num_blocks == extrudedsurface->num_blocks)
      {
        pass ("EXTRUDEDSURFACE.num_blocks [BL] %u", num_blocks);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.num_blocks [BL] %u != %u", extrudedsurface->num_blocks, num_blocks);
        error++;
      }
    num_blocks++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "num_blocks", &num_blocks)
        && num_blocks == extrudedsurface->num_blocks)
      {
        pass ("EXTRUDEDSURFACE.num_blocks [BL] set+1 %u", num_blocks);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.num_blocks [BL] set+1 %u != %u", extrudedsurface->num_blocks, num_blocks);
        error++;
      }
    extrudedsurface->num_blocks--;

  }
  {
    BITCODE_BL num_isolines;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "num_isolines", &num_isolines, NULL)
        && num_isolines == extrudedsurface->num_isolines)
      {
        pass ("EXTRUDEDSURFACE.num_isolines [BL] %u", num_isolines);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.num_isolines [BL] %u != %u", extrudedsurface->num_isolines, num_isolines);
        error++;
      }
    num_isolines++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "num_isolines", &num_isolines)
        && num_isolines == extrudedsurface->num_isolines)
      {
        pass ("EXTRUDEDSURFACE.num_isolines [BL] set+1 %u", num_isolines);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.num_isolines [BL] set+1 %u != %u", extrudedsurface->num_isolines, num_isolines);
        error++;
      }
    extrudedsurface->num_isolines--;

  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == extrudedsurface->num_silhouettes)
      {
        pass ("EXTRUDEDSURFACE.num_silhouettes [BL] %u", num_silhouettes);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.num_silhouettes [BL] %u != %u", extrudedsurface->num_silhouettes, num_silhouettes);
        error++;
      }
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "num_silhouettes", &num_silhouettes)
        && num_silhouettes == extrudedsurface->num_silhouettes)
      {
        pass ("EXTRUDEDSURFACE.num_silhouettes [BL] set+1 %u", num_silhouettes);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.num_silhouettes [BL] set+1 %u != %u", extrudedsurface->num_silhouettes, num_silhouettes);
        error++;
      }
    extrudedsurface->num_silhouettes--;

  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "num_wires", &num_wires, NULL)
        && num_wires == extrudedsurface->num_wires)
      {
        pass ("EXTRUDEDSURFACE.num_wires [BL] %u", num_wires);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.num_wires [BL] %u != %u", extrudedsurface->num_wires, num_wires);
        error++;
      }
    num_wires++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "num_wires", &num_wires)
        && num_wires == extrudedsurface->num_wires)
      {
        pass ("EXTRUDEDSURFACE.num_wires [BL] set+1 %u", num_wires);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.num_wires [BL] set+1 %u != %u", extrudedsurface->num_wires, num_wires);
        error++;
      }
    extrudedsurface->num_wires--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &extrudedsurface->parent, sizeof (extrudedsurface->parent)))
      {
        pass ("EXTRUDEDSURFACE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("EXTRUDEDSURFACE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_H path_entity;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "path_entity", &path_entity, NULL)
        && !memcmp (&path_entity, &extrudedsurface->path_entity, sizeof (extrudedsurface->path_entity)))
      {
        pass ("EXTRUDEDSURFACE.path_entity [H]");
      }
    else
      {
        fail ("EXTRUDEDSURFACE.path_entity [H]");
        error++;
      }
  }
  {
    BITCODE_B path_entity_transform_computed;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "path_entity_transform_computed", &path_entity_transform_computed, NULL)
        && path_entity_transform_computed == extrudedsurface->path_entity_transform_computed)
      {
        pass ("EXTRUDEDSURFACE.path_entity_transform_computed [B] " FORMAT_B "", path_entity_transform_computed);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.path_entity_transform_computed [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->path_entity_transform_computed, path_entity_transform_computed);
        error++;
      }
    path_entity_transform_computed++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "path_entity_transform_computed", &path_entity_transform_computed)
        && path_entity_transform_computed == extrudedsurface->path_entity_transform_computed)
      {
        pass ("EXTRUDEDSURFACE.path_entity_transform_computed [B] set+1 " FORMAT_B "", path_entity_transform_computed);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.path_entity_transform_computed [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->path_entity_transform_computed, path_entity_transform_computed);
        error++;
      }
    extrudedsurface->path_entity_transform_computed--;

  }
  {
    BITCODE_BD* path_entity_transmatrix;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "path_entity_transmatrix", &path_entity_transmatrix, NULL)
        && !memcmp (&path_entity_transmatrix, &extrudedsurface->path_entity_transmatrix, sizeof (extrudedsurface->path_entity_transmatrix)))
      {
        pass ("EXTRUDEDSURFACE.path_entity_transmatrix [BD*]");
      }
    else
      {
        fail ("EXTRUDEDSURFACE.path_entity_transmatrix [BD*]");
        error++;
      }
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "point", &point, NULL)
        && !memcmp (&point, &extrudedsurface->point, sizeof (extrudedsurface->point)))
      {
        pass ("EXTRUDEDSURFACE.point [3BD]");
      }
    else
      {
        fail ("EXTRUDEDSURFACE.point [3BD]");
        error++;
      }
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "point_present", &point_present, NULL)
        && point_present == extrudedsurface->point_present)
      {
        pass ("EXTRUDEDSURFACE.point_present [B] " FORMAT_B "", point_present);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.point_present [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->point_present, point_present);
        error++;
      }
    point_present++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "point_present", &point_present)
        && point_present == extrudedsurface->point_present)
      {
        pass ("EXTRUDEDSURFACE.point_present [B] set+1 " FORMAT_B "", point_present);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->point_present, point_present);
        error++;
      }
    extrudedsurface->point_present--;

  }
  {
    BITCODE_3BD reference_vector_for_controlling_twist;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "reference_vector_for_controlling_twist", &reference_vector_for_controlling_twist, NULL)
        && !memcmp (&reference_vector_for_controlling_twist, &extrudedsurface->reference_vector_for_controlling_twist, sizeof (extrudedsurface->reference_vector_for_controlling_twist)))
      {
        pass ("EXTRUDEDSURFACE.reference_vector_for_controlling_twist [3BD]");
      }
    else
      {
        fail ("EXTRUDEDSURFACE.reference_vector_for_controlling_twist [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD scale_factor;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "scale_factor", &scale_factor, NULL)
        && scale_factor == extrudedsurface->scale_factor)
      {
        pass ("EXTRUDEDSURFACE.scale_factor [BD] %g", scale_factor);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.scale_factor [BD] %g != %g", extrudedsurface->scale_factor, scale_factor);
        error++;
      }
    scale_factor++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "scale_factor", &scale_factor)
        && scale_factor == extrudedsurface->scale_factor)
      {
        pass ("EXTRUDEDSURFACE.scale_factor [BD] set+1 %g", scale_factor);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.scale_factor [BD] set+1 %g != %g", extrudedsurface->scale_factor, scale_factor);
        error++;
      }
    extrudedsurface->scale_factor--;

  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "silhouettes", &silhouettes, NULL)
        && silhouettes == extrudedsurface->silhouettes)
      {
        pass ("EXTRUDEDSURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
        error++;
      }
  }
  {
    BITCODE_BL size_bindata;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "size_bindata", &size_bindata, NULL)
        && size_bindata == extrudedsurface->size_bindata)
      {
        pass ("EXTRUDEDSURFACE.size_bindata [BL] %u", size_bindata);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.size_bindata [BL] %u != %u", extrudedsurface->size_bindata, size_bindata);
        error++;
      }
    size_bindata++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "size_bindata", &size_bindata)
        && size_bindata == extrudedsurface->size_bindata)
      {
        pass ("EXTRUDEDSURFACE.size_bindata [BL] set+1 %u", size_bindata);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.size_bindata [BL] set+1 %u != %u", extrudedsurface->size_bindata, size_bindata);
        error++;
      }
    extrudedsurface->size_bindata--;

  }
  {
    BITCODE_B solid;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "solid", &solid, NULL)
        && solid == extrudedsurface->solid)
      {
        pass ("EXTRUDEDSURFACE.solid [B] " FORMAT_B "", solid);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.solid [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->solid, solid);
        error++;
      }
    solid++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "solid", &solid)
        && solid == extrudedsurface->solid)
      {
        pass ("EXTRUDEDSURFACE.solid [B] set+1 " FORMAT_B "", solid);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.solid [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->solid, solid);
        error++;
      }
    extrudedsurface->solid--;

  }
  {
    BITCODE_BS sweep_alignment_flags;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "sweep_alignment_flags", &sweep_alignment_flags, NULL)
        && sweep_alignment_flags == extrudedsurface->sweep_alignment_flags)
      {
        pass ("EXTRUDEDSURFACE.sweep_alignment_flags [BS] %hu", sweep_alignment_flags);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.sweep_alignment_flags [BS] %hu != %hu", extrudedsurface->sweep_alignment_flags, sweep_alignment_flags);
        error++;
      }
    sweep_alignment_flags++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "sweep_alignment_flags", &sweep_alignment_flags)
        && sweep_alignment_flags == extrudedsurface->sweep_alignment_flags)
      {
        pass ("EXTRUDEDSURFACE.sweep_alignment_flags [BS] set+1 %hu", sweep_alignment_flags);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.sweep_alignment_flags [BS] set+1 %hu != %hu", extrudedsurface->sweep_alignment_flags, sweep_alignment_flags);
        error++;
      }
    extrudedsurface->sweep_alignment_flags--;

  }
  {
    BITCODE_H sweep_entity;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "sweep_entity", &sweep_entity, NULL)
        && !memcmp (&sweep_entity, &extrudedsurface->sweep_entity, sizeof (extrudedsurface->sweep_entity)))
      {
        pass ("EXTRUDEDSURFACE.sweep_entity [H]");
      }
    else
      {
        fail ("EXTRUDEDSURFACE.sweep_entity [H]");
        error++;
      }
  }
  {
    BITCODE_B sweep_entity_transform_computed;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "sweep_entity_transform_computed", &sweep_entity_transform_computed, NULL)
        && sweep_entity_transform_computed == extrudedsurface->sweep_entity_transform_computed)
      {
        pass ("EXTRUDEDSURFACE.sweep_entity_transform_computed [B] " FORMAT_B "", sweep_entity_transform_computed);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.sweep_entity_transform_computed [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->sweep_entity_transform_computed, sweep_entity_transform_computed);
        error++;
      }
    sweep_entity_transform_computed++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "sweep_entity_transform_computed", &sweep_entity_transform_computed)
        && sweep_entity_transform_computed == extrudedsurface->sweep_entity_transform_computed)
      {
        pass ("EXTRUDEDSURFACE.sweep_entity_transform_computed [B] set+1 " FORMAT_B "", sweep_entity_transform_computed);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.sweep_entity_transform_computed [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->sweep_entity_transform_computed, sweep_entity_transform_computed);
        error++;
      }
    extrudedsurface->sweep_entity_transform_computed--;

  }
  {
    BITCODE_BD* sweep_entity_transmatrix;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "sweep_entity_transmatrix", &sweep_entity_transmatrix, NULL)
        && !memcmp (&sweep_entity_transmatrix, &extrudedsurface->sweep_entity_transmatrix, sizeof (extrudedsurface->sweep_entity_transmatrix)))
      {
        pass ("EXTRUDEDSURFACE.sweep_entity_transmatrix [BD*]");
      }
    else
      {
        fail ("EXTRUDEDSURFACE.sweep_entity_transmatrix [BD*]");
        error++;
      }
  }
  {
    BITCODE_BD* sweep_transmatrix;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "sweep_transmatrix", &sweep_transmatrix, NULL)
        && !memcmp (&sweep_transmatrix, &extrudedsurface->sweep_transmatrix, sizeof (extrudedsurface->sweep_transmatrix)))
      {
        pass ("EXTRUDEDSURFACE.sweep_transmatrix [BD*]");
      }
    else
      {
        fail ("EXTRUDEDSURFACE.sweep_transmatrix [BD*]");
        error++;
      }
  }
  {
    BITCODE_3BD sweep_vector;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "sweep_vector", &sweep_vector, NULL)
        && !memcmp (&sweep_vector, &extrudedsurface->sweep_vector, sizeof (extrudedsurface->sweep_vector)))
      {
        pass ("EXTRUDEDSURFACE.sweep_vector [3BD]");
      }
    else
      {
        fail ("EXTRUDEDSURFACE.sweep_vector [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD twist_angle;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "twist_angle", &twist_angle, NULL)
        && twist_angle == extrudedsurface->twist_angle)
      {
        pass ("EXTRUDEDSURFACE.twist_angle [BD] %g", twist_angle);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.twist_angle [BD] %g != %g", extrudedsurface->twist_angle, twist_angle);
        error++;
      }
    twist_angle++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "twist_angle", &twist_angle)
        && twist_angle == extrudedsurface->twist_angle)
      {
        pass ("EXTRUDEDSURFACE.twist_angle [BD] set+1 %g", twist_angle);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.twist_angle [BD] set+1 %g != %g", extrudedsurface->twist_angle, twist_angle);
        error++;
      }
    extrudedsurface->twist_angle--;

  }
  {
    BITCODE_BS u_isolines;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "u_isolines", &u_isolines, NULL)
        && u_isolines == extrudedsurface->u_isolines)
      {
        pass ("EXTRUDEDSURFACE.u_isolines [BS] %hu", u_isolines);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.u_isolines [BS] %hu != %hu", extrudedsurface->u_isolines, u_isolines);
        error++;
      }
    u_isolines++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "u_isolines", &u_isolines)
        && u_isolines == extrudedsurface->u_isolines)
      {
        pass ("EXTRUDEDSURFACE.u_isolines [BS] set+1 %hu", u_isolines);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.u_isolines [BS] set+1 %hu != %hu", extrudedsurface->u_isolines, u_isolines);
        error++;
      }
    extrudedsurface->u_isolines--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "unknown", &unknown, NULL)
        && unknown == extrudedsurface->unknown)
      {
        pass ("EXTRUDEDSURFACE.unknown [B] " FORMAT_B "", unknown);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.unknown [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->unknown, unknown);
        error++;
      }
    unknown++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "unknown", &unknown)
        && unknown == extrudedsurface->unknown)
      {
        pass ("EXTRUDEDSURFACE.unknown [B] set+1 " FORMAT_B "", unknown);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->unknown, unknown);
        error++;
      }
    extrudedsurface->unknown--;

  }
  {
    BITCODE_BL unknown_2007;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "unknown_2007", &unknown_2007, NULL)
        && unknown_2007 == extrudedsurface->unknown_2007)
      {
        pass ("EXTRUDEDSURFACE.unknown_2007 [BL] %u", unknown_2007);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.unknown_2007 [BL] %u != %u", extrudedsurface->unknown_2007, unknown_2007);
        error++;
      }
    unknown_2007++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "unknown_2007", &unknown_2007)
        && unknown_2007 == extrudedsurface->unknown_2007)
      {
        pass ("EXTRUDEDSURFACE.unknown_2007 [BL] set+1 %u", unknown_2007);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.unknown_2007 [BL] set+1 %u != %u", extrudedsurface->unknown_2007, unknown_2007);
        error++;
      }
    extrudedsurface->unknown_2007--;

  }
  {
    BITCODE_BS v_isolines;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "v_isolines", &v_isolines, NULL)
        && v_isolines == extrudedsurface->v_isolines)
      {
        pass ("EXTRUDEDSURFACE.v_isolines [BS] %hu", v_isolines);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.v_isolines [BS] %hu != %hu", extrudedsurface->v_isolines, v_isolines);
        error++;
      }
    v_isolines++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "v_isolines", &v_isolines)
        && v_isolines == extrudedsurface->v_isolines)
      {
        pass ("EXTRUDEDSURFACE.v_isolines [BS] set+1 %hu", v_isolines);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.v_isolines [BS] set+1 %hu != %hu", extrudedsurface->v_isolines, v_isolines);
        error++;
      }
    extrudedsurface->v_isolines--;

  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "version", &version, NULL)
        && version == extrudedsurface->version)
      {
        pass ("EXTRUDEDSURFACE.version [BS] %hu", version);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.version [BS] %hu != %hu", extrudedsurface->version, version);
        error++;
      }
    version++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "version", &version)
        && version == extrudedsurface->version)
      {
        pass ("EXTRUDEDSURFACE.version [BS] set+1 %hu", version);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.version [BS] set+1 %hu != %hu", extrudedsurface->version, version);
        error++;
      }
    extrudedsurface->version--;

  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value(extrudedsurface, "EXTRUDEDSURFACE", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == extrudedsurface->wireframe_data_present)
      {
        pass ("EXTRUDEDSURFACE.wireframe_data_present [B] " FORMAT_B "", wireframe_data_present);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->wireframe_data_present, wireframe_data_present);
        error++;
      }
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "wireframe_data_present", &wireframe_data_present)
        && wireframe_data_present == extrudedsurface->wireframe_data_present)
      {
        pass ("EXTRUDEDSURFACE.wireframe_data_present [B] set+1 " FORMAT_B "", wireframe_data_present);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->wireframe_data_present, wireframe_data_present);
        error++;
      }
    extrudedsurface->wireframe_data_present--;

  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "wires", &wires, NULL)
        && wires == extrudedsurface->wires)
      {
        pass ("EXTRUDEDSURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
      }
    else
      {
        fail ("EXTRUDEDSURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
        error++;
      }
  }
  return error;
}
static int test_GEOPOSITIONMARKER (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_GEOPOSITIONMARKER *restrict geopositionmarker = obj->tio.entity->tio.GEOPOSITIONMARKER;
  {
    BITCODE_B enable_frame_text;
    if (dwg_dynapi_entity_value(geopositionmarker, "GEOPOSITIONMARKER", "enable_frame_text", &enable_frame_text, NULL)
        && enable_frame_text == geopositionmarker->enable_frame_text)
      {
        pass ("GEOPOSITIONMARKER.enable_frame_text [B] " FORMAT_B "", enable_frame_text);
      }
    else
      {
        fail ("GEOPOSITIONMARKER.enable_frame_text [B] " FORMAT_B " != " FORMAT_B "", geopositionmarker->enable_frame_text, enable_frame_text);
        error++;
      }
    enable_frame_text++;
    if (dwg_dynapi_entity_set_value (geopositionmarker, "GEOPOSITIONMARKER", "enable_frame_text", &enable_frame_text)
        && enable_frame_text == geopositionmarker->enable_frame_text)
      {
        pass ("GEOPOSITIONMARKER.enable_frame_text [B] set+1 " FORMAT_B "", enable_frame_text);
      }
    else
      {
        fail ("GEOPOSITIONMARKER.enable_frame_text [B] set+1 " FORMAT_B " != " FORMAT_B "", geopositionmarker->enable_frame_text, enable_frame_text);
        error++;
      }
    geopositionmarker->enable_frame_text--;

  }
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value(geopositionmarker, "GEOPOSITIONMARKER", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &geopositionmarker->extrusion, sizeof (geopositionmarker->extrusion)))
      {
        pass ("GEOPOSITIONMARKER.extrusion [3BD]");
      }
    else
      {
        fail ("GEOPOSITIONMARKER.extrusion [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD landing_gap;
    if (dwg_dynapi_entity_value(geopositionmarker, "GEOPOSITIONMARKER", "landing_gap", &landing_gap, NULL)
        && landing_gap == geopositionmarker->landing_gap)
      {
        pass ("GEOPOSITIONMARKER.landing_gap [BD] %g", landing_gap);
      }
    else
      {
        fail ("GEOPOSITIONMARKER.landing_gap [BD] %g != %g", geopositionmarker->landing_gap, landing_gap);
        error++;
      }
    landing_gap++;
    if (dwg_dynapi_entity_set_value (geopositionmarker, "GEOPOSITIONMARKER", "landing_gap", &landing_gap)
        && landing_gap == geopositionmarker->landing_gap)
      {
        pass ("GEOPOSITIONMARKER.landing_gap [BD] set+1 %g", landing_gap);
      }
    else
      {
        fail ("GEOPOSITIONMARKER.landing_gap [BD] set+1 %g != %g", geopositionmarker->landing_gap, landing_gap);
        error++;
      }
    geopositionmarker->landing_gap--;

  }
  {
    BITCODE_H mtext_handle;
    if (dwg_dynapi_entity_value(geopositionmarker, "GEOPOSITIONMARKER", "mtext_handle", &mtext_handle, NULL)
        && !memcmp (&mtext_handle, &geopositionmarker->mtext_handle, sizeof (geopositionmarker->mtext_handle)))
      {
        pass ("GEOPOSITIONMARKER.mtext_handle [H]");
      }
    else
      {
        fail ("GEOPOSITIONMARKER.mtext_handle [H]");
        error++;
      }
  }
  {
    BITCODE_B mtext_visible;
    if (dwg_dynapi_entity_value(geopositionmarker, "GEOPOSITIONMARKER", "mtext_visible", &mtext_visible, NULL)
        && mtext_visible == geopositionmarker->mtext_visible)
      {
        pass ("GEOPOSITIONMARKER.mtext_visible [B] " FORMAT_B "", mtext_visible);
      }
    else
      {
        fail ("GEOPOSITIONMARKER.mtext_visible [B] " FORMAT_B " != " FORMAT_B "", geopositionmarker->mtext_visible, mtext_visible);
        error++;
      }
    mtext_visible++;
    if (dwg_dynapi_entity_set_value (geopositionmarker, "GEOPOSITIONMARKER", "mtext_visible", &mtext_visible)
        && mtext_visible == geopositionmarker->mtext_visible)
      {
        pass ("GEOPOSITIONMARKER.mtext_visible [B] set+1 " FORMAT_B "", mtext_visible);
      }
    else
      {
        fail ("GEOPOSITIONMARKER.mtext_visible [B] set+1 " FORMAT_B " != " FORMAT_B "", geopositionmarker->mtext_visible, mtext_visible);
        error++;
      }
    geopositionmarker->mtext_visible--;

  }
  {
    BITCODE_T notes;
    if (dwg_dynapi_entity_value(geopositionmarker, "GEOPOSITIONMARKER", "notes", &notes, NULL)
        && !memcmp (&notes, &geopositionmarker->notes, sizeof (geopositionmarker->notes)))
      {
        pass ("GEOPOSITIONMARKER.notes [T]");
      }
    else
      {
        fail ("GEOPOSITIONMARKER.notes [T]");
        error++;
      }
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(geopositionmarker, "GEOPOSITIONMARKER", "parent", &parent, NULL)
        && !memcmp (&parent, &geopositionmarker->parent, sizeof (geopositionmarker->parent)))
      {
        pass ("GEOPOSITIONMARKER.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("GEOPOSITIONMARKER.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_3BD position;
    if (dwg_dynapi_entity_value(geopositionmarker, "GEOPOSITIONMARKER", "position", &position, NULL)
        && !memcmp (&position, &geopositionmarker->position, sizeof (geopositionmarker->position)))
      {
        pass ("GEOPOSITIONMARKER.position [3BD]");
      }
    else
      {
        fail ("GEOPOSITIONMARKER.position [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD radius;
    if (dwg_dynapi_entity_value(geopositionmarker, "GEOPOSITIONMARKER", "radius", &radius, NULL)
        && radius == geopositionmarker->radius)
      {
        pass ("GEOPOSITIONMARKER.radius [BD] %g", radius);
      }
    else
      {
        fail ("GEOPOSITIONMARKER.radius [BD] %g != %g", geopositionmarker->radius, radius);
        error++;
      }
    radius++;
    if (dwg_dynapi_entity_set_value (geopositionmarker, "GEOPOSITIONMARKER", "radius", &radius)
        && radius == geopositionmarker->radius)
      {
        pass ("GEOPOSITIONMARKER.radius [BD] set+1 %g", radius);
      }
    else
      {
        fail ("GEOPOSITIONMARKER.radius [BD] set+1 %g != %g", geopositionmarker->radius, radius);
        error++;
      }
    geopositionmarker->radius--;

  }
  {
    BITCODE_T text;
    if (dwg_dynapi_entity_value(geopositionmarker, "GEOPOSITIONMARKER", "text", &text, NULL)
        && !memcmp (&text, &geopositionmarker->text, sizeof (geopositionmarker->text)))
      {
        pass ("GEOPOSITIONMARKER.text [T]");
      }
    else
      {
        fail ("GEOPOSITIONMARKER.text [T]");
        error++;
      }
  }
  {
    BITCODE_BS text_alignment;
    if (dwg_dynapi_entity_value(geopositionmarker, "GEOPOSITIONMARKER", "text_alignment", &text_alignment, NULL)
        && text_alignment == geopositionmarker->text_alignment)
      {
        pass ("GEOPOSITIONMARKER.text_alignment [BS] %hu", text_alignment);
      }
    else
      {
        fail ("GEOPOSITIONMARKER.text_alignment [BS] %hu != %hu", geopositionmarker->text_alignment, text_alignment);
        error++;
      }
    text_alignment++;
    if (dwg_dynapi_entity_set_value (geopositionmarker, "GEOPOSITIONMARKER", "text_alignment", &text_alignment)
        && text_alignment == geopositionmarker->text_alignment)
      {
        pass ("GEOPOSITIONMARKER.text_alignment [BS] set+1 %hu", text_alignment);
      }
    else
      {
        fail ("GEOPOSITIONMARKER.text_alignment [BS] set+1 %hu != %hu", geopositionmarker->text_alignment, text_alignment);
        error++;
      }
    geopositionmarker->text_alignment--;

  }
  {
    BITCODE_H text_style;
    if (dwg_dynapi_entity_value(geopositionmarker, "GEOPOSITIONMARKER", "text_style", &text_style, NULL)
        && !memcmp (&text_style, &geopositionmarker->text_style, sizeof (geopositionmarker->text_style)))
      {
        pass ("GEOPOSITIONMARKER.text_style [H]");
      }
    else
      {
        fail ("GEOPOSITIONMARKER.text_style [H]");
        error++;
      }
  }
  {
    BITCODE_BS type;
    if (dwg_dynapi_entity_value(geopositionmarker, "GEOPOSITIONMARKER", "type", &type, NULL)
        && type == geopositionmarker->type)
      {
        pass ("GEOPOSITIONMARKER.type [BS] %hu", type);
      }
    else
      {
        fail ("GEOPOSITIONMARKER.type [BS] %hu != %hu", geopositionmarker->type, type);
        error++;
      }
    type++;
    if (dwg_dynapi_entity_set_value (geopositionmarker, "GEOPOSITIONMARKER", "type", &type)
        && type == geopositionmarker->type)
      {
        pass ("GEOPOSITIONMARKER.type [BS] set+1 %hu", type);
      }
    else
      {
        fail ("GEOPOSITIONMARKER.type [BS] set+1 %hu != %hu", geopositionmarker->type, type);
        error++;
      }
    geopositionmarker->type--;

  }
  return error;
}
static int test_HATCH (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_HATCH *restrict hatch = obj->tio.entity->tio.HATCH;
  {
    BITCODE_BD angle;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "angle", &angle, NULL)
        && angle == hatch->angle)
      {
        pass ("HATCH.angle [BD] %g", angle);
      }
    else
      {
        fail ("HATCH.angle [BD] %g != %g", hatch->angle, angle);
        error++;
      }
    angle++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "angle", &angle)
        && angle == hatch->angle)
      {
        pass ("HATCH.angle [BD] set+1 %g", angle);
      }
    else
      {
        fail ("HATCH.angle [BD] set+1 %g != %g", hatch->angle, angle);
        error++;
      }
    hatch->angle--;

  }
  {
    BITCODE_B associative;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "associative", &associative, NULL)
        && associative == hatch->associative)
      {
        pass ("HATCH.associative [B] " FORMAT_B "", associative);
      }
    else
      {
        fail ("HATCH.associative [B] " FORMAT_B " != " FORMAT_B "", hatch->associative, associative);
        error++;
      }
    associative++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "associative", &associative)
        && associative == hatch->associative)
      {
        pass ("HATCH.associative [B] set+1 " FORMAT_B "", associative);
      }
    else
      {
        fail ("HATCH.associative [B] set+1 " FORMAT_B " != " FORMAT_B "", hatch->associative, associative);
        error++;
      }
    hatch->associative--;

  }
  {
    BITCODE_H* boundary_handles;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_boundary_handles", &count, NULL)
        && dwg_dynapi_entity_value (hatch, "HATCH", "boundary_handles", &boundary_handles, NULL)
        && boundary_handles == hatch->boundary_handles)
      {
        pass ("HATCH.boundary_handles [H*] * %u num_boundary_handles", count);
      }
    else
      {
        fail ("HATCH.boundary_handles [H*] * %u num_boundary_handles", count);
        error++;
      }
  }
  {
    Dwg_HATCH_Color* colors;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_colors", &count, NULL)
        && dwg_dynapi_entity_value (hatch, "HATCH", "colors", &colors, NULL)
        && colors == hatch->colors)
      {
        pass ("HATCH.colors [Dwg_HATCH_Color*] * %u num_colors", count);
      }
    else
      {
        fail ("HATCH.colors [Dwg_HATCH_Color*] * %u num_colors", count);
        error++;
      }
  }
  {
    Dwg_HATCH_DefLine* deflines;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_deflines", &count, NULL)
        && dwg_dynapi_entity_value (hatch, "HATCH", "deflines", &deflines, NULL)
        && deflines == hatch->deflines)
      {
        pass ("HATCH.deflines [Dwg_HATCH_DefLine*] * %u num_deflines", count);
      }
    else
      {
        fail ("HATCH.deflines [Dwg_HATCH_DefLine*] * %u num_deflines", count);
        error++;
      }
  }
  {
    BITCODE_B double_flag;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "double_flag", &double_flag, NULL)
        && double_flag == hatch->double_flag)
      {
        pass ("HATCH.double_flag [B] " FORMAT_B "", double_flag);
      }
    else
      {
        fail ("HATCH.double_flag [B] " FORMAT_B " != " FORMAT_B "", hatch->double_flag, double_flag);
        error++;
      }
    double_flag++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "double_flag", &double_flag)
        && double_flag == hatch->double_flag)
      {
        pass ("HATCH.double_flag [B] set+1 " FORMAT_B "", double_flag);
      }
    else
      {
        fail ("HATCH.double_flag [B] set+1 " FORMAT_B " != " FORMAT_B "", hatch->double_flag, double_flag);
        error++;
      }
    hatch->double_flag--;

  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "elevation", &elevation, NULL)
        && elevation == hatch->elevation)
      {
        pass ("HATCH.elevation [BD] %g", elevation);
      }
    else
      {
        fail ("HATCH.elevation [BD] %g != %g", hatch->elevation, elevation);
        error++;
      }
    elevation++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "elevation", &elevation)
        && elevation == hatch->elevation)
      {
        pass ("HATCH.elevation [BD] set+1 %g", elevation);
      }
    else
      {
        fail ("HATCH.elevation [BD] set+1 %g != %g", hatch->elevation, elevation);
        error++;
      }
    hatch->elevation--;

  }
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &hatch->extrusion, sizeof (hatch->extrusion)))
      {
        pass ("HATCH.extrusion [3BD]");
      }
    else
      {
        fail ("HATCH.extrusion [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD gradient_angle;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "gradient_angle", &gradient_angle, NULL)
        && gradient_angle == hatch->gradient_angle)
      {
        pass ("HATCH.gradient_angle [BD] %g", gradient_angle);
      }
    else
      {
        fail ("HATCH.gradient_angle [BD] %g != %g", hatch->gradient_angle, gradient_angle);
        error++;
      }
    gradient_angle++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "gradient_angle", &gradient_angle)
        && gradient_angle == hatch->gradient_angle)
      {
        pass ("HATCH.gradient_angle [BD] set+1 %g", gradient_angle);
      }
    else
      {
        fail ("HATCH.gradient_angle [BD] set+1 %g != %g", hatch->gradient_angle, gradient_angle);
        error++;
      }
    hatch->gradient_angle--;

  }
  {
    BITCODE_TV gradient_name;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "gradient_name", &gradient_name, NULL)
        && !strcmp ((char *)gradient_name, (char *)hatch->gradient_name))
      {
        pass ("HATCH.gradient_name [TV] '%s' <> '%s'", gradient_name, hatch->gradient_name);
      }
    else
      {
        fail ("HATCH.gradient_name [TV] '%s' <> '%s'", gradient_name, hatch->gradient_name);
        error++;
      }
  }
  {
    BITCODE_BD gradient_shift;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "gradient_shift", &gradient_shift, NULL)
        && gradient_shift == hatch->gradient_shift)
      {
        pass ("HATCH.gradient_shift [BD] %g", gradient_shift);
      }
    else
      {
        fail ("HATCH.gradient_shift [BD] %g != %g", hatch->gradient_shift, gradient_shift);
        error++;
      }
    gradient_shift++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "gradient_shift", &gradient_shift)
        && gradient_shift == hatch->gradient_shift)
      {
        pass ("HATCH.gradient_shift [BD] set+1 %g", gradient_shift);
      }
    else
      {
        fail ("HATCH.gradient_shift [BD] set+1 %g != %g", hatch->gradient_shift, gradient_shift);
        error++;
      }
    hatch->gradient_shift--;

  }
  {
    BITCODE_BD gradient_tint;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "gradient_tint", &gradient_tint, NULL)
        && gradient_tint == hatch->gradient_tint)
      {
        pass ("HATCH.gradient_tint [BD] %g", gradient_tint);
      }
    else
      {
        fail ("HATCH.gradient_tint [BD] %g != %g", hatch->gradient_tint, gradient_tint);
        error++;
      }
    gradient_tint++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "gradient_tint", &gradient_tint)
        && gradient_tint == hatch->gradient_tint)
      {
        pass ("HATCH.gradient_tint [BD] set+1 %g", gradient_tint);
      }
    else
      {
        fail ("HATCH.gradient_tint [BD] set+1 %g != %g", hatch->gradient_tint, gradient_tint);
        error++;
      }
    hatch->gradient_tint--;

  }
  {
    BITCODE_B has_derived;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "has_derived", &has_derived, NULL)
        && has_derived == hatch->has_derived)
      {
        pass ("HATCH.has_derived [B] " FORMAT_B "", has_derived);
      }
    else
      {
        fail ("HATCH.has_derived [B] " FORMAT_B " != " FORMAT_B "", hatch->has_derived, has_derived);
        error++;
      }
    has_derived++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "has_derived", &has_derived)
        && has_derived == hatch->has_derived)
      {
        pass ("HATCH.has_derived [B] set+1 " FORMAT_B "", has_derived);
      }
    else
      {
        fail ("HATCH.has_derived [B] set+1 " FORMAT_B " != " FORMAT_B "", hatch->has_derived, has_derived);
        error++;
      }
    hatch->has_derived--;

  }
  {
    BITCODE_BL is_gradient_fill;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "is_gradient_fill", &is_gradient_fill, NULL)
        && is_gradient_fill == hatch->is_gradient_fill)
      {
        pass ("HATCH.is_gradient_fill [BL] %u", is_gradient_fill);
      }
    else
      {
        fail ("HATCH.is_gradient_fill [BL] %u != %u", hatch->is_gradient_fill, is_gradient_fill);
        error++;
      }
    is_gradient_fill++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "is_gradient_fill", &is_gradient_fill)
        && is_gradient_fill == hatch->is_gradient_fill)
      {
        pass ("HATCH.is_gradient_fill [BL] set+1 %u", is_gradient_fill);
      }
    else
      {
        fail ("HATCH.is_gradient_fill [BL] set+1 %u != %u", hatch->is_gradient_fill, is_gradient_fill);
        error++;
      }
    hatch->is_gradient_fill--;

  }
  {
    BITCODE_TV name;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "name", &name, NULL)
        && !strcmp ((char *)name, (char *)hatch->name))
      {
        pass ("HATCH.name [TV] '%s' <> '%s'", name, hatch->name);
      }
    else
      {
        fail ("HATCH.name [TV] '%s' <> '%s'", name, hatch->name);
        error++;
      }
  }
  {
    BITCODE_BL num_boundary_handles;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "num_boundary_handles", &num_boundary_handles, NULL)
        && num_boundary_handles == hatch->num_boundary_handles)
      {
        pass ("HATCH.num_boundary_handles [BL] %u", num_boundary_handles);
      }
    else
      {
        fail ("HATCH.num_boundary_handles [BL] %u != %u", hatch->num_boundary_handles, num_boundary_handles);
        error++;
      }
    num_boundary_handles++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "num_boundary_handles", &num_boundary_handles)
        && num_boundary_handles == hatch->num_boundary_handles)
      {
        pass ("HATCH.num_boundary_handles [BL] set+1 %u", num_boundary_handles);
      }
    else
      {
        fail ("HATCH.num_boundary_handles [BL] set+1 %u != %u", hatch->num_boundary_handles, num_boundary_handles);
        error++;
      }
    hatch->num_boundary_handles--;

  }
  {
    BITCODE_BL num_colors;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "num_colors", &num_colors, NULL)
        && num_colors == hatch->num_colors)
      {
        pass ("HATCH.num_colors [BL] %u", num_colors);
      }
    else
      {
        fail ("HATCH.num_colors [BL] %u != %u", hatch->num_colors, num_colors);
        error++;
      }
    num_colors++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "num_colors", &num_colors)
        && num_colors == hatch->num_colors)
      {
        pass ("HATCH.num_colors [BL] set+1 %u", num_colors);
      }
    else
      {
        fail ("HATCH.num_colors [BL] set+1 %u != %u", hatch->num_colors, num_colors);
        error++;
      }
    hatch->num_colors--;

  }
  {
    BITCODE_BS num_deflines;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "num_deflines", &num_deflines, NULL)
        && num_deflines == hatch->num_deflines)
      {
        pass ("HATCH.num_deflines [BS] %hu", num_deflines);
      }
    else
      {
        fail ("HATCH.num_deflines [BS] %hu != %hu", hatch->num_deflines, num_deflines);
        error++;
      }
    num_deflines++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "num_deflines", &num_deflines)
        && num_deflines == hatch->num_deflines)
      {
        pass ("HATCH.num_deflines [BS] set+1 %hu", num_deflines);
      }
    else
      {
        fail ("HATCH.num_deflines [BS] set+1 %hu != %hu", hatch->num_deflines, num_deflines);
        error++;
      }
    hatch->num_deflines--;

  }
  {
    BITCODE_BL num_paths;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "num_paths", &num_paths, NULL)
        && num_paths == hatch->num_paths)
      {
        pass ("HATCH.num_paths [BL] %u", num_paths);
      }
    else
      {
        fail ("HATCH.num_paths [BL] %u != %u", hatch->num_paths, num_paths);
        error++;
      }
    num_paths++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "num_paths", &num_paths)
        && num_paths == hatch->num_paths)
      {
        pass ("HATCH.num_paths [BL] set+1 %u", num_paths);
      }
    else
      {
        fail ("HATCH.num_paths [BL] set+1 %u != %u", hatch->num_paths, num_paths);
        error++;
      }
    hatch->num_paths--;

  }
  {
    BITCODE_BL num_seeds;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "num_seeds", &num_seeds, NULL)
        && num_seeds == hatch->num_seeds)
      {
        pass ("HATCH.num_seeds [BL] %u", num_seeds);
      }
    else
      {
        fail ("HATCH.num_seeds [BL] %u != %u", hatch->num_seeds, num_seeds);
        error++;
      }
    num_seeds++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "num_seeds", &num_seeds)
        && num_seeds == hatch->num_seeds)
      {
        pass ("HATCH.num_seeds [BL] set+1 %u", num_seeds);
      }
    else
      {
        fail ("HATCH.num_seeds [BL] set+1 %u != %u", hatch->num_seeds, num_seeds);
        error++;
      }
    hatch->num_seeds--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "parent", &parent, NULL)
        && !memcmp (&parent, &hatch->parent, sizeof (hatch->parent)))
      {
        pass ("HATCH.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("HATCH.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    Dwg_HATCH_Path* paths;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_paths", &count, NULL)
        && dwg_dynapi_entity_value (hatch, "HATCH", "paths", &paths, NULL)
        && paths == hatch->paths)
      {
        pass ("HATCH.paths [Dwg_HATCH_Path*] * %u num_paths", count);
      }
    else
      {
        fail ("HATCH.paths [Dwg_HATCH_Path*] * %u num_paths", count);
        error++;
      }
  }
  {
    BITCODE_BS pattern_type;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "pattern_type", &pattern_type, NULL)
        && pattern_type == hatch->pattern_type)
      {
        pass ("HATCH.pattern_type [BS] %hu", pattern_type);
      }
    else
      {
        fail ("HATCH.pattern_type [BS] %hu != %hu", hatch->pattern_type, pattern_type);
        error++;
      }
    pattern_type++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "pattern_type", &pattern_type)
        && pattern_type == hatch->pattern_type)
      {
        pass ("HATCH.pattern_type [BS] set+1 %hu", pattern_type);
      }
    else
      {
        fail ("HATCH.pattern_type [BS] set+1 %hu != %hu", hatch->pattern_type, pattern_type);
        error++;
      }
    hatch->pattern_type--;

  }
  {
    BITCODE_BD pixel_size;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "pixel_size", &pixel_size, NULL)
        && pixel_size == hatch->pixel_size)
      {
        pass ("HATCH.pixel_size [BD] %g", pixel_size);
      }
    else
      {
        fail ("HATCH.pixel_size [BD] %g != %g", hatch->pixel_size, pixel_size);
        error++;
      }
    pixel_size++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "pixel_size", &pixel_size)
        && pixel_size == hatch->pixel_size)
      {
        pass ("HATCH.pixel_size [BD] set+1 %g", pixel_size);
      }
    else
      {
        fail ("HATCH.pixel_size [BD] set+1 %g != %g", hatch->pixel_size, pixel_size);
        error++;
      }
    hatch->pixel_size--;

  }
  {
    BITCODE_BL reserved;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "reserved", &reserved, NULL)
        && reserved == hatch->reserved)
      {
        pass ("HATCH.reserved [BL] %u", reserved);
      }
    else
      {
        fail ("HATCH.reserved [BL] %u != %u", hatch->reserved, reserved);
        error++;
      }
    reserved++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "reserved", &reserved)
        && reserved == hatch->reserved)
      {
        pass ("HATCH.reserved [BL] set+1 %u", reserved);
      }
    else
      {
        fail ("HATCH.reserved [BL] set+1 %u != %u", hatch->reserved, reserved);
        error++;
      }
    hatch->reserved--;

  }
  {
    BITCODE_BD scale_spacing;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "scale_spacing", &scale_spacing, NULL)
        && scale_spacing == hatch->scale_spacing)
      {
        pass ("HATCH.scale_spacing [BD] %g", scale_spacing);
      }
    else
      {
        fail ("HATCH.scale_spacing [BD] %g != %g", hatch->scale_spacing, scale_spacing);
        error++;
      }
    scale_spacing++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "scale_spacing", &scale_spacing)
        && scale_spacing == hatch->scale_spacing)
      {
        pass ("HATCH.scale_spacing [BD] set+1 %g", scale_spacing);
      }
    else
      {
        fail ("HATCH.scale_spacing [BD] set+1 %g != %g", hatch->scale_spacing, scale_spacing);
        error++;
      }
    hatch->scale_spacing--;

  }
  {
    BITCODE_2RD* seeds;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_seeds", &count, NULL)
        && dwg_dynapi_entity_value (hatch, "HATCH", "seeds", &seeds, NULL)
        && seeds == hatch->seeds)
      {
        pass ("HATCH.seeds [2RD*] * %u num_seeds", count);
      }
    else
      {
        fail ("HATCH.seeds [2RD*] * %u num_seeds", count);
        error++;
      }
  }
  {
    BITCODE_BL single_color_gradient;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "single_color_gradient", &single_color_gradient, NULL)
        && single_color_gradient == hatch->single_color_gradient)
      {
        pass ("HATCH.single_color_gradient [BL] %u", single_color_gradient);
      }
    else
      {
        fail ("HATCH.single_color_gradient [BL] %u != %u", hatch->single_color_gradient, single_color_gradient);
        error++;
      }
    single_color_gradient++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "single_color_gradient", &single_color_gradient)
        && single_color_gradient == hatch->single_color_gradient)
      {
        pass ("HATCH.single_color_gradient [BL] set+1 %u", single_color_gradient);
      }
    else
      {
        fail ("HATCH.single_color_gradient [BL] set+1 %u != %u", hatch->single_color_gradient, single_color_gradient);
        error++;
      }
    hatch->single_color_gradient--;

  }
  {
    BITCODE_B solid_fill;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "solid_fill", &solid_fill, NULL)
        && solid_fill == hatch->solid_fill)
      {
        pass ("HATCH.solid_fill [B] " FORMAT_B "", solid_fill);
      }
    else
      {
        fail ("HATCH.solid_fill [B] " FORMAT_B " != " FORMAT_B "", hatch->solid_fill, solid_fill);
        error++;
      }
    solid_fill++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "solid_fill", &solid_fill)
        && solid_fill == hatch->solid_fill)
      {
        pass ("HATCH.solid_fill [B] set+1 " FORMAT_B "", solid_fill);
      }
    else
      {
        fail ("HATCH.solid_fill [B] set+1 " FORMAT_B " != " FORMAT_B "", hatch->solid_fill, solid_fill);
        error++;
      }
    hatch->solid_fill--;

  }
  {
    BITCODE_BS style;
    if (dwg_dynapi_entity_value(hatch, "HATCH", "style", &style, NULL)
        && style == hatch->style)
      {
        pass ("HATCH.style [BS] %hu", style);
      }
    else
      {
        fail ("HATCH.style [BS] %hu != %hu", hatch->style, style);
        error++;
      }
    style++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "style", &style)
        && style == hatch->style)
      {
        pass ("HATCH.style [BS] set+1 %hu", style);
      }
    else
      {
        fail ("HATCH.style [BS] set+1 %hu != %hu", hatch->style, style);
        error++;
      }
    hatch->style--;

  }
  return error;
}
static int test_HELIX (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_HELIX *restrict helix = obj->tio.entity->tio.HELIX;
  {
    BITCODE_3BD axis_base_pt;
    if (dwg_dynapi_entity_value(helix, "HELIX", "axis_base_pt", &axis_base_pt, NULL)
        && !memcmp (&axis_base_pt, &helix->axis_base_pt, sizeof (helix->axis_base_pt)))
      {
        pass ("HELIX.axis_base_pt [3BD]");
      }
    else
      {
        fail ("HELIX.axis_base_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD axis_vector;
    if (dwg_dynapi_entity_value(helix, "HELIX", "axis_vector", &axis_vector, NULL)
        && !memcmp (&axis_vector, &helix->axis_vector, sizeof (helix->axis_vector)))
      {
        pass ("HELIX.axis_vector [3BD]");
      }
    else
      {
        fail ("HELIX.axis_vector [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD beg_tan_vec;
    if (dwg_dynapi_entity_value(helix, "HELIX", "beg_tan_vec", &beg_tan_vec, NULL)
        && !memcmp (&beg_tan_vec, &helix->beg_tan_vec, sizeof (helix->beg_tan_vec)))
      {
        pass ("HELIX.beg_tan_vec [3BD]");
      }
    else
      {
        fail ("HELIX.beg_tan_vec [3BD]");
        error++;
      }
  }
  {
    BITCODE_B closed_b;
    if (dwg_dynapi_entity_value(helix, "HELIX", "closed_b", &closed_b, NULL)
        && closed_b == helix->closed_b)
      {
        pass ("HELIX.closed_b [B] " FORMAT_B "", closed_b);
      }
    else
      {
        fail ("HELIX.closed_b [B] " FORMAT_B " != " FORMAT_B "", helix->closed_b, closed_b);
        error++;
      }
    closed_b++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "closed_b", &closed_b)
        && closed_b == helix->closed_b)
      {
        pass ("HELIX.closed_b [B] set+1 " FORMAT_B "", closed_b);
      }
    else
      {
        fail ("HELIX.closed_b [B] set+1 " FORMAT_B " != " FORMAT_B "", helix->closed_b, closed_b);
        error++;
      }
    helix->closed_b--;

  }
  {
    BITCODE_BS constraint_type;
    if (dwg_dynapi_entity_value(helix, "HELIX", "constraint_type", &constraint_type, NULL)
        && constraint_type == helix->constraint_type)
      {
        pass ("HELIX.constraint_type [BS] %hu", constraint_type);
      }
    else
      {
        fail ("HELIX.constraint_type [BS] %hu != %hu", helix->constraint_type, constraint_type);
        error++;
      }
    constraint_type++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "constraint_type", &constraint_type)
        && constraint_type == helix->constraint_type)
      {
        pass ("HELIX.constraint_type [BS] set+1 %hu", constraint_type);
      }
    else
      {
        fail ("HELIX.constraint_type [BS] set+1 %hu != %hu", helix->constraint_type, constraint_type);
        error++;
      }
    helix->constraint_type--;

  }
  {
    Dwg_SPLINE_control_point* ctrl_pts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (helix, "HELIX", "num_ctrl_pts", &count, NULL)
        && dwg_dynapi_entity_value (helix, "HELIX", "ctrl_pts", &ctrl_pts, NULL)
        && ctrl_pts == helix->ctrl_pts)
      {
        pass ("HELIX.ctrl_pts [Dwg_SPLINE_control_point*] * %u num_ctrl_pts", count);
      }
    else
      {
        fail ("HELIX.ctrl_pts [Dwg_SPLINE_control_point*] * %u num_ctrl_pts", count);
        error++;
      }
  }
  {
    BITCODE_BD ctrl_tol;
    if (dwg_dynapi_entity_value(helix, "HELIX", "ctrl_tol", &ctrl_tol, NULL)
        && ctrl_tol == helix->ctrl_tol)
      {
        pass ("HELIX.ctrl_tol [BD] %g", ctrl_tol);
      }
    else
      {
        fail ("HELIX.ctrl_tol [BD] %g != %g", helix->ctrl_tol, ctrl_tol);
        error++;
      }
    ctrl_tol++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "ctrl_tol", &ctrl_tol)
        && ctrl_tol == helix->ctrl_tol)
      {
        pass ("HELIX.ctrl_tol [BD] set+1 %g", ctrl_tol);
      }
    else
      {
        fail ("HELIX.ctrl_tol [BD] set+1 %g != %g", helix->ctrl_tol, ctrl_tol);
        error++;
      }
    helix->ctrl_tol--;

  }
  {
    BITCODE_BS degree;
    if (dwg_dynapi_entity_value(helix, "HELIX", "degree", &degree, NULL)
        && degree == helix->degree)
      {
        pass ("HELIX.degree [BS] %hu", degree);
      }
    else
      {
        fail ("HELIX.degree [BS] %hu != %hu", helix->degree, degree);
        error++;
      }
    degree++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "degree", &degree)
        && degree == helix->degree)
      {
        pass ("HELIX.degree [BS] set+1 %hu", degree);
      }
    else
      {
        fail ("HELIX.degree [BS] set+1 %hu != %hu", helix->degree, degree);
        error++;
      }
    helix->degree--;

  }
  {
    BITCODE_3BD end_tan_vec;
    if (dwg_dynapi_entity_value(helix, "HELIX", "end_tan_vec", &end_tan_vec, NULL)
        && !memcmp (&end_tan_vec, &helix->end_tan_vec, sizeof (helix->end_tan_vec)))
      {
        pass ("HELIX.end_tan_vec [3BD]");
      }
    else
      {
        fail ("HELIX.end_tan_vec [3BD]");
        error++;
      }
  }
  {
    Dwg_SPLINE_point* fit_pts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (helix, "HELIX", "num_fit_pts", &count, NULL)
        && dwg_dynapi_entity_value (helix, "HELIX", "fit_pts", &fit_pts, NULL)
        && fit_pts == helix->fit_pts)
      {
        pass ("HELIX.fit_pts [Dwg_SPLINE_point*] * %u num_fit_pts", count);
      }
    else
      {
        fail ("HELIX.fit_pts [Dwg_SPLINE_point*] * %u num_fit_pts", count);
        error++;
      }
  }
  {
    BITCODE_BD fit_tol;
    if (dwg_dynapi_entity_value(helix, "HELIX", "fit_tol", &fit_tol, NULL)
        && fit_tol == helix->fit_tol)
      {
        pass ("HELIX.fit_tol [BD] %g", fit_tol);
      }
    else
      {
        fail ("HELIX.fit_tol [BD] %g != %g", helix->fit_tol, fit_tol);
        error++;
      }
    fit_tol++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "fit_tol", &fit_tol)
        && fit_tol == helix->fit_tol)
      {
        pass ("HELIX.fit_tol [BD] set+1 %g", fit_tol);
      }
    else
      {
        fail ("HELIX.fit_tol [BD] set+1 %g != %g", helix->fit_tol, fit_tol);
        error++;
      }
    helix->fit_tol--;

  }
  {
    BITCODE_BS flag;
    if (dwg_dynapi_entity_value(helix, "HELIX", "flag", &flag, NULL)
        && flag == helix->flag)
      {
        pass ("HELIX.flag [BS] %hu", flag);
      }
    else
      {
        fail ("HELIX.flag [BS] %hu != %hu", helix->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "flag", &flag)
        && flag == helix->flag)
      {
        pass ("HELIX.flag [BS] set+1 %hu", flag);
      }
    else
      {
        fail ("HELIX.flag [BS] set+1 %hu != %hu", helix->flag, flag);
        error++;
      }
    helix->flag--;

  }
  {
    BITCODE_B handedness;
    if (dwg_dynapi_entity_value(helix, "HELIX", "handedness", &handedness, NULL)
        && handedness == helix->handedness)
      {
        pass ("HELIX.handedness [B] " FORMAT_B "", handedness);
      }
    else
      {
        fail ("HELIX.handedness [B] " FORMAT_B " != " FORMAT_B "", helix->handedness, handedness);
        error++;
      }
    handedness++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "handedness", &handedness)
        && handedness == helix->handedness)
      {
        pass ("HELIX.handedness [B] set+1 " FORMAT_B "", handedness);
      }
    else
      {
        fail ("HELIX.handedness [B] set+1 " FORMAT_B " != " FORMAT_B "", helix->handedness, handedness);
        error++;
      }
    helix->handedness--;

  }
  {
    BITCODE_BD knot_tol;
    if (dwg_dynapi_entity_value(helix, "HELIX", "knot_tol", &knot_tol, NULL)
        && knot_tol == helix->knot_tol)
      {
        pass ("HELIX.knot_tol [BD] %g", knot_tol);
      }
    else
      {
        fail ("HELIX.knot_tol [BD] %g != %g", helix->knot_tol, knot_tol);
        error++;
      }
    knot_tol++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "knot_tol", &knot_tol)
        && knot_tol == helix->knot_tol)
      {
        pass ("HELIX.knot_tol [BD] set+1 %g", knot_tol);
      }
    else
      {
        fail ("HELIX.knot_tol [BD] set+1 %g != %g", helix->knot_tol, knot_tol);
        error++;
      }
    helix->knot_tol--;

  }
  {
    BITCODE_BL knotparam;
    if (dwg_dynapi_entity_value(helix, "HELIX", "knotparam", &knotparam, NULL)
        && knotparam == helix->knotparam)
      {
        pass ("HELIX.knotparam [BL] %u", knotparam);
      }
    else
      {
        fail ("HELIX.knotparam [BL] %u != %u", helix->knotparam, knotparam);
        error++;
      }
    knotparam++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "knotparam", &knotparam)
        && knotparam == helix->knotparam)
      {
        pass ("HELIX.knotparam [BL] set+1 %u", knotparam);
      }
    else
      {
        fail ("HELIX.knotparam [BL] set+1 %u != %u", helix->knotparam, knotparam);
        error++;
      }
    helix->knotparam--;

  }
  {
    BITCODE_BD* knots;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (helix, "HELIX", "num_knots", &count, NULL)
        && dwg_dynapi_entity_value (helix, "HELIX", "knots", &knots, NULL)
        && knots == helix->knots)
      {
        pass ("HELIX.knots [BD*] * %u num_knots", count);
      }
    else
      {
        fail ("HELIX.knots [BD*] * %u num_knots", count);
        error++;
      }
  }
  {
    BITCODE_BS maint_version;
    if (dwg_dynapi_entity_value(helix, "HELIX", "maint_version", &maint_version, NULL)
        && maint_version == helix->maint_version)
      {
        pass ("HELIX.maint_version [BS] %hu", maint_version);
      }
    else
      {
        fail ("HELIX.maint_version [BS] %hu != %hu", helix->maint_version, maint_version);
        error++;
      }
    maint_version++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "maint_version", &maint_version)
        && maint_version == helix->maint_version)
      {
        pass ("HELIX.maint_version [BS] set+1 %hu", maint_version);
      }
    else
      {
        fail ("HELIX.maint_version [BS] set+1 %hu != %hu", helix->maint_version, maint_version);
        error++;
      }
    helix->maint_version--;

  }
  {
    BITCODE_BS major_version;
    if (dwg_dynapi_entity_value(helix, "HELIX", "major_version", &major_version, NULL)
        && major_version == helix->major_version)
      {
        pass ("HELIX.major_version [BS] %hu", major_version);
      }
    else
      {
        fail ("HELIX.major_version [BS] %hu != %hu", helix->major_version, major_version);
        error++;
      }
    major_version++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "major_version", &major_version)
        && major_version == helix->major_version)
      {
        pass ("HELIX.major_version [BS] set+1 %hu", major_version);
      }
    else
      {
        fail ("HELIX.major_version [BS] set+1 %hu != %hu", helix->major_version, major_version);
        error++;
      }
    helix->major_version--;

  }
  {
    BITCODE_BL num_ctrl_pts;
    if (dwg_dynapi_entity_value(helix, "HELIX", "num_ctrl_pts", &num_ctrl_pts, NULL)
        && num_ctrl_pts == helix->num_ctrl_pts)
      {
        pass ("HELIX.num_ctrl_pts [BL] %u", num_ctrl_pts);
      }
    else
      {
        fail ("HELIX.num_ctrl_pts [BL] %u != %u", helix->num_ctrl_pts, num_ctrl_pts);
        error++;
      }
    num_ctrl_pts++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "num_ctrl_pts", &num_ctrl_pts)
        && num_ctrl_pts == helix->num_ctrl_pts)
      {
        pass ("HELIX.num_ctrl_pts [BL] set+1 %u", num_ctrl_pts);
      }
    else
      {
        fail ("HELIX.num_ctrl_pts [BL] set+1 %u != %u", helix->num_ctrl_pts, num_ctrl_pts);
        error++;
      }
    helix->num_ctrl_pts--;

  }
  {
    BITCODE_BS num_fit_pts;
    if (dwg_dynapi_entity_value(helix, "HELIX", "num_fit_pts", &num_fit_pts, NULL)
        && num_fit_pts == helix->num_fit_pts)
      {
        pass ("HELIX.num_fit_pts [BS] %hu", num_fit_pts);
      }
    else
      {
        fail ("HELIX.num_fit_pts [BS] %hu != %hu", helix->num_fit_pts, num_fit_pts);
        error++;
      }
    num_fit_pts++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "num_fit_pts", &num_fit_pts)
        && num_fit_pts == helix->num_fit_pts)
      {
        pass ("HELIX.num_fit_pts [BS] set+1 %hu", num_fit_pts);
      }
    else
      {
        fail ("HELIX.num_fit_pts [BS] set+1 %hu != %hu", helix->num_fit_pts, num_fit_pts);
        error++;
      }
    helix->num_fit_pts--;

  }
  {
    BITCODE_BL num_knots;
    if (dwg_dynapi_entity_value(helix, "HELIX", "num_knots", &num_knots, NULL)
        && num_knots == helix->num_knots)
      {
        pass ("HELIX.num_knots [BL] %u", num_knots);
      }
    else
      {
        fail ("HELIX.num_knots [BL] %u != %u", helix->num_knots, num_knots);
        error++;
      }
    num_knots++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "num_knots", &num_knots)
        && num_knots == helix->num_knots)
      {
        pass ("HELIX.num_knots [BL] set+1 %u", num_knots);
      }
    else
      {
        fail ("HELIX.num_knots [BL] set+1 %u != %u", helix->num_knots, num_knots);
        error++;
      }
    helix->num_knots--;

  }
  {
    BITCODE_BD num_turns;
    if (dwg_dynapi_entity_value(helix, "HELIX", "num_turns", &num_turns, NULL)
        && num_turns == helix->num_turns)
      {
        pass ("HELIX.num_turns [BD] %g", num_turns);
      }
    else
      {
        fail ("HELIX.num_turns [BD] %g != %g", helix->num_turns, num_turns);
        error++;
      }
    num_turns++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "num_turns", &num_turns)
        && num_turns == helix->num_turns)
      {
        pass ("HELIX.num_turns [BD] set+1 %g", num_turns);
      }
    else
      {
        fail ("HELIX.num_turns [BD] set+1 %g != %g", helix->num_turns, num_turns);
        error++;
      }
    helix->num_turns--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(helix, "HELIX", "parent", &parent, NULL)
        && !memcmp (&parent, &helix->parent, sizeof (helix->parent)))
      {
        pass ("HELIX.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("HELIX.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_B periodic;
    if (dwg_dynapi_entity_value(helix, "HELIX", "periodic", &periodic, NULL)
        && periodic == helix->periodic)
      {
        pass ("HELIX.periodic [B] " FORMAT_B "", periodic);
      }
    else
      {
        fail ("HELIX.periodic [B] " FORMAT_B " != " FORMAT_B "", helix->periodic, periodic);
        error++;
      }
    periodic++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "periodic", &periodic)
        && periodic == helix->periodic)
      {
        pass ("HELIX.periodic [B] set+1 " FORMAT_B "", periodic);
      }
    else
      {
        fail ("HELIX.periodic [B] set+1 " FORMAT_B " != " FORMAT_B "", helix->periodic, periodic);
        error++;
      }
    helix->periodic--;

  }
  {
    BITCODE_BD radius;
    if (dwg_dynapi_entity_value(helix, "HELIX", "radius", &radius, NULL)
        && radius == helix->radius)
      {
        pass ("HELIX.radius [BD] %g", radius);
      }
    else
      {
        fail ("HELIX.radius [BD] %g != %g", helix->radius, radius);
        error++;
      }
    radius++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "radius", &radius)
        && radius == helix->radius)
      {
        pass ("HELIX.radius [BD] set+1 %g", radius);
      }
    else
      {
        fail ("HELIX.radius [BD] set+1 %g != %g", helix->radius, radius);
        error++;
      }
    helix->radius--;

  }
  {
    BITCODE_B rational;
    if (dwg_dynapi_entity_value(helix, "HELIX", "rational", &rational, NULL)
        && rational == helix->rational)
      {
        pass ("HELIX.rational [B] " FORMAT_B "", rational);
      }
    else
      {
        fail ("HELIX.rational [B] " FORMAT_B " != " FORMAT_B "", helix->rational, rational);
        error++;
      }
    rational++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "rational", &rational)
        && rational == helix->rational)
      {
        pass ("HELIX.rational [B] set+1 " FORMAT_B "", rational);
      }
    else
      {
        fail ("HELIX.rational [B] set+1 " FORMAT_B " != " FORMAT_B "", helix->rational, rational);
        error++;
      }
    helix->rational--;

  }
  {
    BITCODE_BS scenario;
    if (dwg_dynapi_entity_value(helix, "HELIX", "scenario", &scenario, NULL)
        && scenario == helix->scenario)
      {
        pass ("HELIX.scenario [BS] %hu", scenario);
      }
    else
      {
        fail ("HELIX.scenario [BS] %hu != %hu", helix->scenario, scenario);
        error++;
      }
    scenario++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "scenario", &scenario)
        && scenario == helix->scenario)
      {
        pass ("HELIX.scenario [BS] set+1 %hu", scenario);
      }
    else
      {
        fail ("HELIX.scenario [BS] set+1 %hu != %hu", helix->scenario, scenario);
        error++;
      }
    helix->scenario--;

  }
  {
    BITCODE_BL splineflags1;
    if (dwg_dynapi_entity_value(helix, "HELIX", "splineflags1", &splineflags1, NULL)
        && splineflags1 == helix->splineflags1)
      {
        pass ("HELIX.splineflags1 [BL] %u", splineflags1);
      }
    else
      {
        fail ("HELIX.splineflags1 [BL] %u != %u", helix->splineflags1, splineflags1);
        error++;
      }
    splineflags1++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "splineflags1", &splineflags1)
        && splineflags1 == helix->splineflags1)
      {
        pass ("HELIX.splineflags1 [BL] set+1 %u", splineflags1);
      }
    else
      {
        fail ("HELIX.splineflags1 [BL] set+1 %u != %u", helix->splineflags1, splineflags1);
        error++;
      }
    helix->splineflags1--;

  }
  {
    BITCODE_3BD start_pt;
    if (dwg_dynapi_entity_value(helix, "HELIX", "start_pt", &start_pt, NULL)
        && !memcmp (&start_pt, &helix->start_pt, sizeof (helix->start_pt)))
      {
        pass ("HELIX.start_pt [3BD]");
      }
    else
      {
        fail ("HELIX.start_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD turn_height;
    if (dwg_dynapi_entity_value(helix, "HELIX", "turn_height", &turn_height, NULL)
        && turn_height == helix->turn_height)
      {
        pass ("HELIX.turn_height [BD] %g", turn_height);
      }
    else
      {
        fail ("HELIX.turn_height [BD] %g != %g", helix->turn_height, turn_height);
        error++;
      }
    turn_height++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "turn_height", &turn_height)
        && turn_height == helix->turn_height)
      {
        pass ("HELIX.turn_height [BD] set+1 %g", turn_height);
      }
    else
      {
        fail ("HELIX.turn_height [BD] set+1 %g != %g", helix->turn_height, turn_height);
        error++;
      }
    helix->turn_height--;

  }
  {
    BITCODE_B weighted;
    if (dwg_dynapi_entity_value(helix, "HELIX", "weighted", &weighted, NULL)
        && weighted == helix->weighted)
      {
        pass ("HELIX.weighted [B] " FORMAT_B "", weighted);
      }
    else
      {
        fail ("HELIX.weighted [B] " FORMAT_B " != " FORMAT_B "", helix->weighted, weighted);
        error++;
      }
    weighted++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "weighted", &weighted)
        && weighted == helix->weighted)
      {
        pass ("HELIX.weighted [B] set+1 " FORMAT_B "", weighted);
      }
    else
      {
        fail ("HELIX.weighted [B] set+1 " FORMAT_B " != " FORMAT_B "", helix->weighted, weighted);
        error++;
      }
    helix->weighted--;

  }
  return error;
}
static int test_IMAGE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_IMAGE *restrict image = obj->tio.entity->tio.IMAGE;
  {
    BITCODE_2RD boundary_pt0;
    if (dwg_dynapi_entity_value(image, "IMAGE", "boundary_pt0", &boundary_pt0, NULL)
        && !memcmp (&boundary_pt0, &image->boundary_pt0, sizeof (image->boundary_pt0)))
      {
        pass ("IMAGE.boundary_pt0 [2RD]");
      }
    else
      {
        fail ("IMAGE.boundary_pt0 [2RD]");
        error++;
      }
  }
  {
    BITCODE_2RD boundary_pt1;
    if (dwg_dynapi_entity_value(image, "IMAGE", "boundary_pt1", &boundary_pt1, NULL)
        && !memcmp (&boundary_pt1, &image->boundary_pt1, sizeof (image->boundary_pt1)))
      {
        pass ("IMAGE.boundary_pt1 [2RD]");
      }
    else
      {
        fail ("IMAGE.boundary_pt1 [2RD]");
        error++;
      }
  }
  {
    BITCODE_RC brightness;
    if (dwg_dynapi_entity_value(image, "IMAGE", "brightness", &brightness, NULL)
        && brightness == image->brightness)
      {
        pass ("IMAGE.brightness [RC] %u", brightness);
      }
    else
      {
        fail ("IMAGE.brightness [RC] %u != %u", image->brightness, brightness);
        error++;
      }
    brightness++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "brightness", &brightness)
        && brightness == image->brightness)
      {
        pass ("IMAGE.brightness [RC] set+1 %u", brightness);
      }
    else
      {
        fail ("IMAGE.brightness [RC] set+1 %u != %u", image->brightness, brightness);
        error++;
      }
    image->brightness--;

  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value(image, "IMAGE", "class_version", &class_version, NULL)
        && class_version == image->class_version)
      {
        pass ("IMAGE.class_version [BL] %u", class_version);
      }
    else
      {
        fail ("IMAGE.class_version [BL] %u != %u", image->class_version, class_version);
        error++;
      }
    class_version++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "class_version", &class_version)
        && class_version == image->class_version)
      {
        pass ("IMAGE.class_version [BL] set+1 %u", class_version);
      }
    else
      {
        fail ("IMAGE.class_version [BL] set+1 %u != %u", image->class_version, class_version);
        error++;
      }
    image->class_version--;

  }
  {
    BITCODE_BS clip_boundary_type;
    if (dwg_dynapi_entity_value(image, "IMAGE", "clip_boundary_type", &clip_boundary_type, NULL)
        && clip_boundary_type == image->clip_boundary_type)
      {
        pass ("IMAGE.clip_boundary_type [BS] %hu", clip_boundary_type);
      }
    else
      {
        fail ("IMAGE.clip_boundary_type [BS] %hu != %hu", image->clip_boundary_type, clip_boundary_type);
        error++;
      }
    clip_boundary_type++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "clip_boundary_type", &clip_boundary_type)
        && clip_boundary_type == image->clip_boundary_type)
      {
        pass ("IMAGE.clip_boundary_type [BS] set+1 %hu", clip_boundary_type);
      }
    else
      {
        fail ("IMAGE.clip_boundary_type [BS] set+1 %hu != %hu", image->clip_boundary_type, clip_boundary_type);
        error++;
      }
    image->clip_boundary_type--;

  }
  {
    BITCODE_B clip_mode;
    if (dwg_dynapi_entity_value(image, "IMAGE", "clip_mode", &clip_mode, NULL)
        && clip_mode == image->clip_mode)
      {
        pass ("IMAGE.clip_mode [B] " FORMAT_B "", clip_mode);
      }
    else
      {
        fail ("IMAGE.clip_mode [B] " FORMAT_B " != " FORMAT_B "", image->clip_mode, clip_mode);
        error++;
      }
    clip_mode++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "clip_mode", &clip_mode)
        && clip_mode == image->clip_mode)
      {
        pass ("IMAGE.clip_mode [B] set+1 " FORMAT_B "", clip_mode);
      }
    else
      {
        fail ("IMAGE.clip_mode [B] set+1 " FORMAT_B " != " FORMAT_B "", image->clip_mode, clip_mode);
        error++;
      }
    image->clip_mode--;

  }
  {
    BITCODE_2RD* clip_verts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (image, "IMAGE", "num_clip_verts", &count, NULL)
        && dwg_dynapi_entity_value (image, "IMAGE", "clip_verts", &clip_verts, NULL)
        && clip_verts == image->clip_verts)
      {
        pass ("IMAGE.clip_verts [2RD*] * %u num_clip_verts", count);
      }
    else
      {
        fail ("IMAGE.clip_verts [2RD*] * %u num_clip_verts", count);
        error++;
      }
  }
  {
    BITCODE_B clipping;
    if (dwg_dynapi_entity_value(image, "IMAGE", "clipping", &clipping, NULL)
        && clipping == image->clipping)
      {
        pass ("IMAGE.clipping [B] " FORMAT_B "", clipping);
      }
    else
      {
        fail ("IMAGE.clipping [B] " FORMAT_B " != " FORMAT_B "", image->clipping, clipping);
        error++;
      }
    clipping++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "clipping", &clipping)
        && clipping == image->clipping)
      {
        pass ("IMAGE.clipping [B] set+1 " FORMAT_B "", clipping);
      }
    else
      {
        fail ("IMAGE.clipping [B] set+1 " FORMAT_B " != " FORMAT_B "", image->clipping, clipping);
        error++;
      }
    image->clipping--;

  }
  {
    BITCODE_RC contrast;
    if (dwg_dynapi_entity_value(image, "IMAGE", "contrast", &contrast, NULL)
        && contrast == image->contrast)
      {
        pass ("IMAGE.contrast [RC] %u", contrast);
      }
    else
      {
        fail ("IMAGE.contrast [RC] %u != %u", image->contrast, contrast);
        error++;
      }
    contrast++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "contrast", &contrast)
        && contrast == image->contrast)
      {
        pass ("IMAGE.contrast [RC] set+1 %u", contrast);
      }
    else
      {
        fail ("IMAGE.contrast [RC] set+1 %u != %u", image->contrast, contrast);
        error++;
      }
    image->contrast--;

  }
  {
    BITCODE_BS display_props;
    if (dwg_dynapi_entity_value(image, "IMAGE", "display_props", &display_props, NULL)
        && display_props == image->display_props)
      {
        pass ("IMAGE.display_props [BS] %hu", display_props);
      }
    else
      {
        fail ("IMAGE.display_props [BS] %hu != %hu", image->display_props, display_props);
        error++;
      }
    display_props++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "display_props", &display_props)
        && display_props == image->display_props)
      {
        pass ("IMAGE.display_props [BS] set+1 %hu", display_props);
      }
    else
      {
        fail ("IMAGE.display_props [BS] set+1 %hu != %hu", image->display_props, display_props);
        error++;
      }
    image->display_props--;

  }
  {
    BITCODE_RC fade;
    if (dwg_dynapi_entity_value(image, "IMAGE", "fade", &fade, NULL)
        && fade == image->fade)
      {
        pass ("IMAGE.fade [RC] %u", fade);
      }
    else
      {
        fail ("IMAGE.fade [RC] %u != %u", image->fade, fade);
        error++;
      }
    fade++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "fade", &fade)
        && fade == image->fade)
      {
        pass ("IMAGE.fade [RC] set+1 %u", fade);
      }
    else
      {
        fail ("IMAGE.fade [RC] set+1 %u != %u", image->fade, fade);
        error++;
      }
    image->fade--;

  }
  {
    BITCODE_H imagedef;
    if (dwg_dynapi_entity_value(image, "IMAGE", "imagedef", &imagedef, NULL)
        && !memcmp (&imagedef, &image->imagedef, sizeof (image->imagedef)))
      {
        pass ("IMAGE.imagedef [H]");
      }
    else
      {
        fail ("IMAGE.imagedef [H]");
        error++;
      }
  }
  {
    BITCODE_H imagedefreactor;
    if (dwg_dynapi_entity_value(image, "IMAGE", "imagedefreactor", &imagedefreactor, NULL)
        && !memcmp (&imagedefreactor, &image->imagedefreactor, sizeof (image->imagedefreactor)))
      {
        pass ("IMAGE.imagedefreactor [H]");
      }
    else
      {
        fail ("IMAGE.imagedefreactor [H]");
        error++;
      }
  }
  {
    BITCODE_BL num_clip_verts;
    if (dwg_dynapi_entity_value(image, "IMAGE", "num_clip_verts", &num_clip_verts, NULL)
        && num_clip_verts == image->num_clip_verts)
      {
        pass ("IMAGE.num_clip_verts [BL] %u", num_clip_verts);
      }
    else
      {
        fail ("IMAGE.num_clip_verts [BL] %u != %u", image->num_clip_verts, num_clip_verts);
        error++;
      }
    num_clip_verts++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "num_clip_verts", &num_clip_verts)
        && num_clip_verts == image->num_clip_verts)
      {
        pass ("IMAGE.num_clip_verts [BL] set+1 %u", num_clip_verts);
      }
    else
      {
        fail ("IMAGE.num_clip_verts [BL] set+1 %u != %u", image->num_clip_verts, num_clip_verts);
        error++;
      }
    image->num_clip_verts--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(image, "IMAGE", "parent", &parent, NULL)
        && !memcmp (&parent, &image->parent, sizeof (image->parent)))
      {
        pass ("IMAGE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("IMAGE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_3BD pt0;
    if (dwg_dynapi_entity_value(image, "IMAGE", "pt0", &pt0, NULL)
        && !memcmp (&pt0, &image->pt0, sizeof (image->pt0)))
      {
        pass ("IMAGE.pt0 [3BD]");
      }
    else
      {
        fail ("IMAGE.pt0 [3BD]");
        error++;
      }
  }
  {
    BITCODE_2RD size;
    if (dwg_dynapi_entity_value(image, "IMAGE", "size", &size, NULL)
        && !memcmp (&size, &image->size, sizeof (image->size)))
      {
        pass ("IMAGE.size [2RD]");
      }
    else
      {
        fail ("IMAGE.size [2RD]");
        error++;
      }
  }
  {
    BITCODE_3BD uvec;
    if (dwg_dynapi_entity_value(image, "IMAGE", "uvec", &uvec, NULL)
        && !memcmp (&uvec, &image->uvec, sizeof (image->uvec)))
      {
        pass ("IMAGE.uvec [3BD]");
      }
    else
      {
        fail ("IMAGE.uvec [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD vvec;
    if (dwg_dynapi_entity_value(image, "IMAGE", "vvec", &vvec, NULL)
        && !memcmp (&vvec, &image->vvec, sizeof (image->vvec)))
      {
        pass ("IMAGE.vvec [3BD]");
      }
    else
      {
        fail ("IMAGE.vvec [3BD]");
        error++;
      }
  }
  return error;
}
static int test_INSERT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_INSERT *restrict insert = obj->tio.entity->tio.INSERT;
  {
    BITCODE_H* attrib_handles;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (insert, "INSERT", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (insert, "INSERT", "attrib_handles", &attrib_handles, NULL)
        && attrib_handles == insert->attrib_handles)
      {
        pass ("INSERT.attrib_handles [H*] * %u num_owned", count);
      }
    else
      {
        fail ("INSERT.attrib_handles [H*] * %u num_owned", count);
        error++;
      }
  }
  {
    BITCODE_H block_header;
    if (dwg_dynapi_entity_value(insert, "INSERT", "block_header", &block_header, NULL)
        && !memcmp (&block_header, &insert->block_header, sizeof (insert->block_header)))
      {
        pass ("INSERT.block_header [H]");
      }
    else
      {
        fail ("INSERT.block_header [H]");
        error++;
      }
  }
  {
    BITCODE_3DPOINT extrusion;
    if (dwg_dynapi_entity_value(insert, "INSERT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &insert->extrusion, sizeof (insert->extrusion)))
      {
        pass ("INSERT.extrusion [3DPOINT]");
      }
    else
      {
        fail ("INSERT.extrusion [3DPOINT]");
        error++;
      }
  }
  {
    BITCODE_H first_attrib;
    if (dwg_dynapi_entity_value(insert, "INSERT", "first_attrib", &first_attrib, NULL)
        && !memcmp (&first_attrib, &insert->first_attrib, sizeof (insert->first_attrib)))
      {
        pass ("INSERT.first_attrib [H]");
      }
    else
      {
        fail ("INSERT.first_attrib [H]");
        error++;
      }
  }
  {
    BITCODE_B has_attribs;
    if (dwg_dynapi_entity_value(insert, "INSERT", "has_attribs", &has_attribs, NULL)
        && has_attribs == insert->has_attribs)
      {
        pass ("INSERT.has_attribs [B] " FORMAT_B "", has_attribs);
      }
    else
      {
        fail ("INSERT.has_attribs [B] " FORMAT_B " != " FORMAT_B "", insert->has_attribs, has_attribs);
        error++;
      }
    has_attribs++;
    if (dwg_dynapi_entity_set_value (insert, "INSERT", "has_attribs", &has_attribs)
        && has_attribs == insert->has_attribs)
      {
        pass ("INSERT.has_attribs [B] set+1 " FORMAT_B "", has_attribs);
      }
    else
      {
        fail ("INSERT.has_attribs [B] set+1 " FORMAT_B " != " FORMAT_B "", insert->has_attribs, has_attribs);
        error++;
      }
    insert->has_attribs--;

  }
  {
    BITCODE_3DPOINT ins_pt;
    if (dwg_dynapi_entity_value(insert, "INSERT", "ins_pt", &ins_pt, NULL)
        && !memcmp (&ins_pt, &insert->ins_pt, sizeof (insert->ins_pt)))
      {
        pass ("INSERT.ins_pt [3DPOINT]");
      }
    else
      {
        fail ("INSERT.ins_pt [3DPOINT]");
        error++;
      }
  }
  {
    BITCODE_H last_attrib;
    if (dwg_dynapi_entity_value(insert, "INSERT", "last_attrib", &last_attrib, NULL)
        && !memcmp (&last_attrib, &insert->last_attrib, sizeof (insert->last_attrib)))
      {
        pass ("INSERT.last_attrib [H]");
      }
    else
      {
        fail ("INSERT.last_attrib [H]");
        error++;
      }
  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value(insert, "INSERT", "num_owned", &num_owned, NULL)
        && num_owned == insert->num_owned)
      {
        pass ("INSERT.num_owned [BL] %u", num_owned);
      }
    else
      {
        fail ("INSERT.num_owned [BL] %u != %u", insert->num_owned, num_owned);
        error++;
      }
    num_owned++;
    if (dwg_dynapi_entity_set_value (insert, "INSERT", "num_owned", &num_owned)
        && num_owned == insert->num_owned)
      {
        pass ("INSERT.num_owned [BL] set+1 %u", num_owned);
      }
    else
      {
        fail ("INSERT.num_owned [BL] set+1 %u != %u", insert->num_owned, num_owned);
        error++;
      }
    insert->num_owned--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(insert, "INSERT", "parent", &parent, NULL)
        && !memcmp (&parent, &insert->parent, sizeof (insert->parent)))
      {
        pass ("INSERT.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("INSERT.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_BD rotation;
    if (dwg_dynapi_entity_value(insert, "INSERT", "rotation", &rotation, NULL)
        && rotation == insert->rotation)
      {
        pass ("INSERT.rotation [BD] %g", rotation);
      }
    else
      {
        fail ("INSERT.rotation [BD] %g != %g", insert->rotation, rotation);
        error++;
      }
    rotation++;
    if (dwg_dynapi_entity_set_value (insert, "INSERT", "rotation", &rotation)
        && rotation == insert->rotation)
      {
        pass ("INSERT.rotation [BD] set+1 %g", rotation);
      }
    else
      {
        fail ("INSERT.rotation [BD] set+1 %g != %g", insert->rotation, rotation);
        error++;
      }
    insert->rotation--;

  }
  {
    BITCODE_3DPOINT scale;
    if (dwg_dynapi_entity_value(insert, "INSERT", "scale", &scale, NULL)
        && !memcmp (&scale, &insert->scale, sizeof (insert->scale)))
      {
        pass ("INSERT.scale [3DPOINT]");
      }
    else
      {
        fail ("INSERT.scale [3DPOINT]");
        error++;
      }
  }
  {
    BITCODE_BB scale_flag;
    if (dwg_dynapi_entity_value(insert, "INSERT", "scale_flag", &scale_flag, NULL)
        && scale_flag == insert->scale_flag)
      {
        pass ("INSERT.scale_flag [BB] " FORMAT_BB "", scale_flag);
      }
    else
      {
        fail ("INSERT.scale_flag [BB] " FORMAT_BB " != " FORMAT_BB "", insert->scale_flag, scale_flag);
        error++;
      }
    scale_flag++;
    if (dwg_dynapi_entity_set_value (insert, "INSERT", "scale_flag", &scale_flag)
        && scale_flag == insert->scale_flag)
      {
        pass ("INSERT.scale_flag [BB] set+1 " FORMAT_BB "", scale_flag);
      }
    else
      {
        fail ("INSERT.scale_flag [BB] set+1 " FORMAT_BB " != " FORMAT_BB "", insert->scale_flag, scale_flag);
        error++;
      }
    insert->scale_flag--;

  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value(insert, "INSERT", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &insert->seqend, sizeof (insert->seqend)))
      {
        pass ("INSERT.seqend [H]");
      }
    else
      {
        fail ("INSERT.seqend [H]");
        error++;
      }
  }
  return error;
}
static int test_LEADER (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_LEADER *restrict leader = obj->tio.entity->tio.LEADER;
  {
    BITCODE_BS annot_type;
    if (dwg_dynapi_entity_value(leader, "LEADER", "annot_type", &annot_type, NULL)
        && annot_type == leader->annot_type)
      {
        pass ("LEADER.annot_type [BS] %hu", annot_type);
      }
    else
      {
        fail ("LEADER.annot_type [BS] %hu != %hu", leader->annot_type, annot_type);
        error++;
      }
    annot_type++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "annot_type", &annot_type)
        && annot_type == leader->annot_type)
      {
        pass ("LEADER.annot_type [BS] set+1 %hu", annot_type);
      }
    else
      {
        fail ("LEADER.annot_type [BS] set+1 %hu != %hu", leader->annot_type, annot_type);
        error++;
      }
    leader->annot_type--;

  }
  {
    BITCODE_B arrowhead_on;
    if (dwg_dynapi_entity_value(leader, "LEADER", "arrowhead_on", &arrowhead_on, NULL)
        && arrowhead_on == leader->arrowhead_on)
      {
        pass ("LEADER.arrowhead_on [B] " FORMAT_B "", arrowhead_on);
      }
    else
      {
        fail ("LEADER.arrowhead_on [B] " FORMAT_B " != " FORMAT_B "", leader->arrowhead_on, arrowhead_on);
        error++;
      }
    arrowhead_on++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "arrowhead_on", &arrowhead_on)
        && arrowhead_on == leader->arrowhead_on)
      {
        pass ("LEADER.arrowhead_on [B] set+1 " FORMAT_B "", arrowhead_on);
      }
    else
      {
        fail ("LEADER.arrowhead_on [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->arrowhead_on, arrowhead_on);
        error++;
      }
    leader->arrowhead_on--;

  }
  {
    BITCODE_BS arrowhead_type;
    if (dwg_dynapi_entity_value(leader, "LEADER", "arrowhead_type", &arrowhead_type, NULL)
        && arrowhead_type == leader->arrowhead_type)
      {
        pass ("LEADER.arrowhead_type [BS] %hu", arrowhead_type);
      }
    else
      {
        fail ("LEADER.arrowhead_type [BS] %hu != %hu", leader->arrowhead_type, arrowhead_type);
        error++;
      }
    arrowhead_type++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "arrowhead_type", &arrowhead_type)
        && arrowhead_type == leader->arrowhead_type)
      {
        pass ("LEADER.arrowhead_type [BS] set+1 %hu", arrowhead_type);
      }
    else
      {
        fail ("LEADER.arrowhead_type [BS] set+1 %hu != %hu", leader->arrowhead_type, arrowhead_type);
        error++;
      }
    leader->arrowhead_type--;

  }
  {
    BITCODE_H associated_annotation;
    if (dwg_dynapi_entity_value(leader, "LEADER", "associated_annotation", &associated_annotation, NULL)
        && !memcmp (&associated_annotation, &leader->associated_annotation, sizeof (leader->associated_annotation)))
      {
        pass ("LEADER.associated_annotation [H]");
      }
    else
      {
        fail ("LEADER.associated_annotation [H]");
        error++;
      }
  }
  {
    BITCODE_BD box_height;
    if (dwg_dynapi_entity_value(leader, "LEADER", "box_height", &box_height, NULL)
        && box_height == leader->box_height)
      {
        pass ("LEADER.box_height [BD] %g", box_height);
      }
    else
      {
        fail ("LEADER.box_height [BD] %g != %g", leader->box_height, box_height);
        error++;
      }
    box_height++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "box_height", &box_height)
        && box_height == leader->box_height)
      {
        pass ("LEADER.box_height [BD] set+1 %g", box_height);
      }
    else
      {
        fail ("LEADER.box_height [BD] set+1 %g != %g", leader->box_height, box_height);
        error++;
      }
    leader->box_height--;

  }
  {
    BITCODE_BD box_width;
    if (dwg_dynapi_entity_value(leader, "LEADER", "box_width", &box_width, NULL)
        && box_width == leader->box_width)
      {
        pass ("LEADER.box_width [BD] %g", box_width);
      }
    else
      {
        fail ("LEADER.box_width [BD] %g != %g", leader->box_width, box_width);
        error++;
      }
    box_width++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "box_width", &box_width)
        && box_width == leader->box_width)
      {
        pass ("LEADER.box_width [BD] set+1 %g", box_width);
      }
    else
      {
        fail ("LEADER.box_width [BD] set+1 %g != %g", leader->box_width, box_width);
        error++;
      }
    leader->box_width--;

  }
  {
    BITCODE_BS byblock_color;
    if (dwg_dynapi_entity_value(leader, "LEADER", "byblock_color", &byblock_color, NULL)
        && byblock_color == leader->byblock_color)
      {
        pass ("LEADER.byblock_color [BS] %hu", byblock_color);
      }
    else
      {
        fail ("LEADER.byblock_color [BS] %hu != %hu", leader->byblock_color, byblock_color);
        error++;
      }
    byblock_color++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "byblock_color", &byblock_color)
        && byblock_color == leader->byblock_color)
      {
        pass ("LEADER.byblock_color [BS] set+1 %hu", byblock_color);
      }
    else
      {
        fail ("LEADER.byblock_color [BS] set+1 %hu != %hu", leader->byblock_color, byblock_color);
        error++;
      }
    leader->byblock_color--;

  }
  {
    BITCODE_BD dimasz;
    if (dwg_dynapi_entity_value(leader, "LEADER", "dimasz", &dimasz, NULL)
        && dimasz == leader->dimasz)
      {
        pass ("LEADER.dimasz [BD] %g", dimasz);
      }
    else
      {
        fail ("LEADER.dimasz [BD] %g != %g", leader->dimasz, dimasz);
        error++;
      }
    dimasz++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "dimasz", &dimasz)
        && dimasz == leader->dimasz)
      {
        pass ("LEADER.dimasz [BD] set+1 %g", dimasz);
      }
    else
      {
        fail ("LEADER.dimasz [BD] set+1 %g != %g", leader->dimasz, dimasz);
        error++;
      }
    leader->dimasz--;

  }
  {
    BITCODE_BD dimgap;
    if (dwg_dynapi_entity_value(leader, "LEADER", "dimgap", &dimgap, NULL)
        && dimgap == leader->dimgap)
      {
        pass ("LEADER.dimgap [BD] %g", dimgap);
      }
    else
      {
        fail ("LEADER.dimgap [BD] %g != %g", leader->dimgap, dimgap);
        error++;
      }
    dimgap++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "dimgap", &dimgap)
        && dimgap == leader->dimgap)
      {
        pass ("LEADER.dimgap [BD] set+1 %g", dimgap);
      }
    else
      {
        fail ("LEADER.dimgap [BD] set+1 %g != %g", leader->dimgap, dimgap);
        error++;
      }
    leader->dimgap--;

  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value(leader, "LEADER", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &leader->dimstyle, sizeof (leader->dimstyle)))
      {
        pass ("LEADER.dimstyle [H]");
      }
    else
      {
        fail ("LEADER.dimstyle [H]");
        error++;
      }
  }
  {
    BITCODE_3DPOINT endptproj;
    if (dwg_dynapi_entity_value(leader, "LEADER", "endptproj", &endptproj, NULL)
        && !memcmp (&endptproj, &leader->endptproj, sizeof (leader->endptproj)))
      {
        pass ("LEADER.endptproj [3DPOINT]");
      }
    else
      {
        fail ("LEADER.endptproj [3DPOINT]");
        error++;
      }
  }
  {
    BITCODE_3DPOINT extrusion;
    if (dwg_dynapi_entity_value(leader, "LEADER", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &leader->extrusion, sizeof (leader->extrusion)))
      {
        pass ("LEADER.extrusion [3DPOINT]");
      }
    else
      {
        fail ("LEADER.extrusion [3DPOINT]");
        error++;
      }
  }
  {
    BITCODE_B hookline_dir;
    if (dwg_dynapi_entity_value(leader, "LEADER", "hookline_dir", &hookline_dir, NULL)
        && hookline_dir == leader->hookline_dir)
      {
        pass ("LEADER.hookline_dir [B] " FORMAT_B "", hookline_dir);
      }
    else
      {
        fail ("LEADER.hookline_dir [B] " FORMAT_B " != " FORMAT_B "", leader->hookline_dir, hookline_dir);
        error++;
      }
    hookline_dir++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "hookline_dir", &hookline_dir)
        && hookline_dir == leader->hookline_dir)
      {
        pass ("LEADER.hookline_dir [B] set+1 " FORMAT_B "", hookline_dir);
      }
    else
      {
        fail ("LEADER.hookline_dir [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->hookline_dir, hookline_dir);
        error++;
      }
    leader->hookline_dir--;

  }
  {
    BITCODE_B hookline_on;
    if (dwg_dynapi_entity_value(leader, "LEADER", "hookline_on", &hookline_on, NULL)
        && hookline_on == leader->hookline_on)
      {
        pass ("LEADER.hookline_on [B] " FORMAT_B "", hookline_on);
      }
    else
      {
        fail ("LEADER.hookline_on [B] " FORMAT_B " != " FORMAT_B "", leader->hookline_on, hookline_on);
        error++;
      }
    hookline_on++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "hookline_on", &hookline_on)
        && hookline_on == leader->hookline_on)
      {
        pass ("LEADER.hookline_on [B] set+1 " FORMAT_B "", hookline_on);
      }
    else
      {
        fail ("LEADER.hookline_on [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->hookline_on, hookline_on);
        error++;
      }
    leader->hookline_on--;

  }
  {
    BITCODE_BL num_points;
    if (dwg_dynapi_entity_value(leader, "LEADER", "num_points", &num_points, NULL)
        && num_points == leader->num_points)
      {
        pass ("LEADER.num_points [BL] %u", num_points);
      }
    else
      {
        fail ("LEADER.num_points [BL] %u != %u", leader->num_points, num_points);
        error++;
      }
    num_points++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "num_points", &num_points)
        && num_points == leader->num_points)
      {
        pass ("LEADER.num_points [BL] set+1 %u", num_points);
      }
    else
      {
        fail ("LEADER.num_points [BL] set+1 %u != %u", leader->num_points, num_points);
        error++;
      }
    leader->num_points--;

  }
  {
    BITCODE_3DPOINT offset_to_block_ins_pt;
    if (dwg_dynapi_entity_value(leader, "LEADER", "offset_to_block_ins_pt", &offset_to_block_ins_pt, NULL)
        && !memcmp (&offset_to_block_ins_pt, &leader->offset_to_block_ins_pt, sizeof (leader->offset_to_block_ins_pt)))
      {
        pass ("LEADER.offset_to_block_ins_pt [3DPOINT]");
      }
    else
      {
        fail ("LEADER.offset_to_block_ins_pt [3DPOINT]");
        error++;
      }
  }
  {
    BITCODE_3DPOINT origin;
    if (dwg_dynapi_entity_value(leader, "LEADER", "origin", &origin, NULL)
        && !memcmp (&origin, &leader->origin, sizeof (leader->origin)))
      {
        pass ("LEADER.origin [3DPOINT]");
      }
    else
      {
        fail ("LEADER.origin [3DPOINT]");
        error++;
      }
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(leader, "LEADER", "parent", &parent, NULL)
        && !memcmp (&parent, &leader->parent, sizeof (leader->parent)))
      {
        pass ("LEADER.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("LEADER.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_BS path_type;
    if (dwg_dynapi_entity_value(leader, "LEADER", "path_type", &path_type, NULL)
        && path_type == leader->path_type)
      {
        pass ("LEADER.path_type [BS] %hu", path_type);
      }
    else
      {
        fail ("LEADER.path_type [BS] %hu != %hu", leader->path_type, path_type);
        error++;
      }
    path_type++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "path_type", &path_type)
        && path_type == leader->path_type)
      {
        pass ("LEADER.path_type [BS] set+1 %hu", path_type);
      }
    else
      {
        fail ("LEADER.path_type [BS] set+1 %hu != %hu", leader->path_type, path_type);
        error++;
      }
    leader->path_type--;

  }
  {
    BITCODE_3DPOINT* points;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (leader, "LEADER", "num_points", &count, NULL)
        && dwg_dynapi_entity_value (leader, "LEADER", "points", &points, NULL)
        && points == leader->points)
      {
        pass ("LEADER.points [3DPOINT*] * %u num_points", count);
      }
    else
      {
        fail ("LEADER.points [3DPOINT*] * %u num_points", count);
        error++;
      }
  }
  {
    BITCODE_B unknown_bit_1;
    if (dwg_dynapi_entity_value(leader, "LEADER", "unknown_bit_1", &unknown_bit_1, NULL)
        && unknown_bit_1 == leader->unknown_bit_1)
      {
        pass ("LEADER.unknown_bit_1 [B] " FORMAT_B "", unknown_bit_1);
      }
    else
      {
        fail ("LEADER.unknown_bit_1 [B] " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_1, unknown_bit_1);
        error++;
      }
    unknown_bit_1++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "unknown_bit_1", &unknown_bit_1)
        && unknown_bit_1 == leader->unknown_bit_1)
      {
        pass ("LEADER.unknown_bit_1 [B] set+1 " FORMAT_B "", unknown_bit_1);
      }
    else
      {
        fail ("LEADER.unknown_bit_1 [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_1, unknown_bit_1);
        error++;
      }
    leader->unknown_bit_1--;

  }
  {
    BITCODE_B unknown_bit_2;
    if (dwg_dynapi_entity_value(leader, "LEADER", "unknown_bit_2", &unknown_bit_2, NULL)
        && unknown_bit_2 == leader->unknown_bit_2)
      {
        pass ("LEADER.unknown_bit_2 [B] " FORMAT_B "", unknown_bit_2);
      }
    else
      {
        fail ("LEADER.unknown_bit_2 [B] " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_2, unknown_bit_2);
        error++;
      }
    unknown_bit_2++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "unknown_bit_2", &unknown_bit_2)
        && unknown_bit_2 == leader->unknown_bit_2)
      {
        pass ("LEADER.unknown_bit_2 [B] set+1 " FORMAT_B "", unknown_bit_2);
      }
    else
      {
        fail ("LEADER.unknown_bit_2 [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_2, unknown_bit_2);
        error++;
      }
    leader->unknown_bit_2--;

  }
  {
    BITCODE_B unknown_bit_3;
    if (dwg_dynapi_entity_value(leader, "LEADER", "unknown_bit_3", &unknown_bit_3, NULL)
        && unknown_bit_3 == leader->unknown_bit_3)
      {
        pass ("LEADER.unknown_bit_3 [B] " FORMAT_B "", unknown_bit_3);
      }
    else
      {
        fail ("LEADER.unknown_bit_3 [B] " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_3, unknown_bit_3);
        error++;
      }
    unknown_bit_3++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "unknown_bit_3", &unknown_bit_3)
        && unknown_bit_3 == leader->unknown_bit_3)
      {
        pass ("LEADER.unknown_bit_3 [B] set+1 " FORMAT_B "", unknown_bit_3);
      }
    else
      {
        fail ("LEADER.unknown_bit_3 [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_3, unknown_bit_3);
        error++;
      }
    leader->unknown_bit_3--;

  }
  {
    BITCODE_B unknown_bit_5;
    if (dwg_dynapi_entity_value(leader, "LEADER", "unknown_bit_5", &unknown_bit_5, NULL)
        && unknown_bit_5 == leader->unknown_bit_5)
      {
        pass ("LEADER.unknown_bit_5 [B] " FORMAT_B "", unknown_bit_5);
      }
    else
      {
        fail ("LEADER.unknown_bit_5 [B] " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_5, unknown_bit_5);
        error++;
      }
    unknown_bit_5++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "unknown_bit_5", &unknown_bit_5)
        && unknown_bit_5 == leader->unknown_bit_5)
      {
        pass ("LEADER.unknown_bit_5 [B] set+1 " FORMAT_B "", unknown_bit_5);
      }
    else
      {
        fail ("LEADER.unknown_bit_5 [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_5, unknown_bit_5);
        error++;
      }
    leader->unknown_bit_5--;

  }
  {
    BITCODE_BS unknown_short_1;
    if (dwg_dynapi_entity_value(leader, "LEADER", "unknown_short_1", &unknown_short_1, NULL)
        && unknown_short_1 == leader->unknown_short_1)
      {
        pass ("LEADER.unknown_short_1 [BS] %hu", unknown_short_1);
      }
    else
      {
        fail ("LEADER.unknown_short_1 [BS] %hu != %hu", leader->unknown_short_1, unknown_short_1);
        error++;
      }
    unknown_short_1++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "unknown_short_1", &unknown_short_1)
        && unknown_short_1 == leader->unknown_short_1)
      {
        pass ("LEADER.unknown_short_1 [BS] set+1 %hu", unknown_short_1);
      }
    else
      {
        fail ("LEADER.unknown_short_1 [BS] set+1 %hu != %hu", leader->unknown_short_1, unknown_short_1);
        error++;
      }
    leader->unknown_short_1--;

  }
  {
    BITCODE_3DPOINT x_direction;
    if (dwg_dynapi_entity_value(leader, "LEADER", "x_direction", &x_direction, NULL)
        && !memcmp (&x_direction, &leader->x_direction, sizeof (leader->x_direction)))
      {
        pass ("LEADER.x_direction [3DPOINT]");
      }
    else
      {
        fail ("LEADER.x_direction [3DPOINT]");
        error++;
      }
  }
  return error;
}
static int test_LIGHT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_LIGHT *restrict light = obj->tio.entity->tio.LIGHT;
  {
    BITCODE_BD attenuation_end_limit;
    if (dwg_dynapi_entity_value(light, "LIGHT", "attenuation_end_limit", &attenuation_end_limit, NULL)
        && attenuation_end_limit == light->attenuation_end_limit)
      {
        pass ("LIGHT.attenuation_end_limit [BD] %g", attenuation_end_limit);
      }
    else
      {
        fail ("LIGHT.attenuation_end_limit [BD] %g != %g", light->attenuation_end_limit, attenuation_end_limit);
        error++;
      }
    attenuation_end_limit++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "attenuation_end_limit", &attenuation_end_limit)
        && attenuation_end_limit == light->attenuation_end_limit)
      {
        pass ("LIGHT.attenuation_end_limit [BD] set+1 %g", attenuation_end_limit);
      }
    else
      {
        fail ("LIGHT.attenuation_end_limit [BD] set+1 %g != %g", light->attenuation_end_limit, attenuation_end_limit);
        error++;
      }
    light->attenuation_end_limit--;

  }
  {
    BITCODE_BD attenuation_start_limit;
    if (dwg_dynapi_entity_value(light, "LIGHT", "attenuation_start_limit", &attenuation_start_limit, NULL)
        && attenuation_start_limit == light->attenuation_start_limit)
      {
        pass ("LIGHT.attenuation_start_limit [BD] %g", attenuation_start_limit);
      }
    else
      {
        fail ("LIGHT.attenuation_start_limit [BD] %g != %g", light->attenuation_start_limit, attenuation_start_limit);
        error++;
      }
    attenuation_start_limit++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "attenuation_start_limit", &attenuation_start_limit)
        && attenuation_start_limit == light->attenuation_start_limit)
      {
        pass ("LIGHT.attenuation_start_limit [BD] set+1 %g", attenuation_start_limit);
      }
    else
      {
        fail ("LIGHT.attenuation_start_limit [BD] set+1 %g != %g", light->attenuation_start_limit, attenuation_start_limit);
        error++;
      }
    light->attenuation_start_limit--;

  }
  {
    BITCODE_BS attenuation_type;
    if (dwg_dynapi_entity_value(light, "LIGHT", "attenuation_type", &attenuation_type, NULL)
        && attenuation_type == light->attenuation_type)
      {
        pass ("LIGHT.attenuation_type [BS] %hu", attenuation_type);
      }
    else
      {
        fail ("LIGHT.attenuation_type [BS] %hu != %hu", light->attenuation_type, attenuation_type);
        error++;
      }
    attenuation_type++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "attenuation_type", &attenuation_type)
        && attenuation_type == light->attenuation_type)
      {
        pass ("LIGHT.attenuation_type [BS] set+1 %hu", attenuation_type);
      }
    else
      {
        fail ("LIGHT.attenuation_type [BS] set+1 %hu != %hu", light->attenuation_type, attenuation_type);
        error++;
      }
    light->attenuation_type--;

  }
  {
    BITCODE_B cast_shadows;
    if (dwg_dynapi_entity_value(light, "LIGHT", "cast_shadows", &cast_shadows, NULL)
        && cast_shadows == light->cast_shadows)
      {
        pass ("LIGHT.cast_shadows [B] " FORMAT_B "", cast_shadows);
      }
    else
      {
        fail ("LIGHT.cast_shadows [B] " FORMAT_B " != " FORMAT_B "", light->cast_shadows, cast_shadows);
        error++;
      }
    cast_shadows++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "cast_shadows", &cast_shadows)
        && cast_shadows == light->cast_shadows)
      {
        pass ("LIGHT.cast_shadows [B] set+1 " FORMAT_B "", cast_shadows);
      }
    else
      {
        fail ("LIGHT.cast_shadows [B] set+1 " FORMAT_B " != " FORMAT_B "", light->cast_shadows, cast_shadows);
        error++;
      }
    light->cast_shadows--;

  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value(light, "LIGHT", "class_version", &class_version, NULL)
        && class_version == light->class_version)
      {
        pass ("LIGHT.class_version [BL] %u", class_version);
      }
    else
      {
        fail ("LIGHT.class_version [BL] %u != %u", light->class_version, class_version);
        error++;
      }
    class_version++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "class_version", &class_version)
        && class_version == light->class_version)
      {
        pass ("LIGHT.class_version [BL] set+1 %u", class_version);
      }
    else
      {
        fail ("LIGHT.class_version [BL] set+1 %u != %u", light->class_version, class_version);
        error++;
      }
    light->class_version--;

  }
  {
    BITCODE_CMC color;
    if (dwg_dynapi_entity_value(light, "LIGHT", "color", &color, NULL)
        && !memcmp (&color, &light->color, sizeof (light->color)))
      {
        pass ("LIGHT.color [CMC]");
      }
    else
      {
        fail ("LIGHT.color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BD falloff_angle;
    if (dwg_dynapi_entity_value(light, "LIGHT", "falloff_angle", &falloff_angle, NULL)
        && falloff_angle == light->falloff_angle)
      {
        pass ("LIGHT.falloff_angle [BD] %g", falloff_angle);
      }
    else
      {
        fail ("LIGHT.falloff_angle [BD] %g != %g", light->falloff_angle, falloff_angle);
        error++;
      }
    falloff_angle++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "falloff_angle", &falloff_angle)
        && falloff_angle == light->falloff_angle)
      {
        pass ("LIGHT.falloff_angle [BD] set+1 %g", falloff_angle);
      }
    else
      {
        fail ("LIGHT.falloff_angle [BD] set+1 %g != %g", light->falloff_angle, falloff_angle);
        error++;
      }
    light->falloff_angle--;

  }
  {
    BITCODE_BD hotspot_angle;
    if (dwg_dynapi_entity_value(light, "LIGHT", "hotspot_angle", &hotspot_angle, NULL)
        && hotspot_angle == light->hotspot_angle)
      {
        pass ("LIGHT.hotspot_angle [BD] %g", hotspot_angle);
      }
    else
      {
        fail ("LIGHT.hotspot_angle [BD] %g != %g", light->hotspot_angle, hotspot_angle);
        error++;
      }
    hotspot_angle++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "hotspot_angle", &hotspot_angle)
        && hotspot_angle == light->hotspot_angle)
      {
        pass ("LIGHT.hotspot_angle [BD] set+1 %g", hotspot_angle);
      }
    else
      {
        fail ("LIGHT.hotspot_angle [BD] set+1 %g != %g", light->hotspot_angle, hotspot_angle);
        error++;
      }
    light->hotspot_angle--;

  }
  {
    BITCODE_BD intensity;
    if (dwg_dynapi_entity_value(light, "LIGHT", "intensity", &intensity, NULL)
        && intensity == light->intensity)
      {
        pass ("LIGHT.intensity [BD] %g", intensity);
      }
    else
      {
        fail ("LIGHT.intensity [BD] %g != %g", light->intensity, intensity);
        error++;
      }
    intensity++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "intensity", &intensity)
        && intensity == light->intensity)
      {
        pass ("LIGHT.intensity [BD] set+1 %g", intensity);
      }
    else
      {
        fail ("LIGHT.intensity [BD] set+1 %g != %g", light->intensity, intensity);
        error++;
      }
    light->intensity--;

  }
  {
    BITCODE_H lights_layer;
    if (dwg_dynapi_entity_value(light, "LIGHT", "lights_layer", &lights_layer, NULL)
        && !memcmp (&lights_layer, &light->lights_layer, sizeof (light->lights_layer)))
      {
        pass ("LIGHT.lights_layer [H]");
      }
    else
      {
        fail ("LIGHT.lights_layer [H]");
        error++;
      }
  }
  {
    BITCODE_T name;
    if (dwg_dynapi_entity_value(light, "LIGHT", "name", &name, NULL)
        && !memcmp (&name, &light->name, sizeof (light->name)))
      {
        pass ("LIGHT.name [T]");
      }
    else
      {
        fail ("LIGHT.name [T]");
        error++;
      }
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(light, "LIGHT", "parent", &parent, NULL)
        && !memcmp (&parent, &light->parent, sizeof (light->parent)))
      {
        pass ("LIGHT.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("LIGHT.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_B plot_glyph;
    if (dwg_dynapi_entity_value(light, "LIGHT", "plot_glyph", &plot_glyph, NULL)
        && plot_glyph == light->plot_glyph)
      {
        pass ("LIGHT.plot_glyph [B] " FORMAT_B "", plot_glyph);
      }
    else
      {
        fail ("LIGHT.plot_glyph [B] " FORMAT_B " != " FORMAT_B "", light->plot_glyph, plot_glyph);
        error++;
      }
    plot_glyph++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "plot_glyph", &plot_glyph)
        && plot_glyph == light->plot_glyph)
      {
        pass ("LIGHT.plot_glyph [B] set+1 " FORMAT_B "", plot_glyph);
      }
    else
      {
        fail ("LIGHT.plot_glyph [B] set+1 " FORMAT_B " != " FORMAT_B "", light->plot_glyph, plot_glyph);
        error++;
      }
    light->plot_glyph--;

  }
  {
    BITCODE_3BD position;
    if (dwg_dynapi_entity_value(light, "LIGHT", "position", &position, NULL)
        && !memcmp (&position, &light->position, sizeof (light->position)))
      {
        pass ("LIGHT.position [3BD]");
      }
    else
      {
        fail ("LIGHT.position [3BD]");
        error++;
      }
  }
  {
    BITCODE_BS shadow_map_size;
    if (dwg_dynapi_entity_value(light, "LIGHT", "shadow_map_size", &shadow_map_size, NULL)
        && shadow_map_size == light->shadow_map_size)
      {
        pass ("LIGHT.shadow_map_size [BS] %hu", shadow_map_size);
      }
    else
      {
        fail ("LIGHT.shadow_map_size [BS] %hu != %hu", light->shadow_map_size, shadow_map_size);
        error++;
      }
    shadow_map_size++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "shadow_map_size", &shadow_map_size)
        && shadow_map_size == light->shadow_map_size)
      {
        pass ("LIGHT.shadow_map_size [BS] set+1 %hu", shadow_map_size);
      }
    else
      {
        fail ("LIGHT.shadow_map_size [BS] set+1 %hu != %hu", light->shadow_map_size, shadow_map_size);
        error++;
      }
    light->shadow_map_size--;

  }
  {
    BITCODE_RC shadow_map_softness;
    if (dwg_dynapi_entity_value(light, "LIGHT", "shadow_map_softness", &shadow_map_softness, NULL)
        && shadow_map_softness == light->shadow_map_softness)
      {
        pass ("LIGHT.shadow_map_softness [RC] %u", shadow_map_softness);
      }
    else
      {
        fail ("LIGHT.shadow_map_softness [RC] %u != %u", light->shadow_map_softness, shadow_map_softness);
        error++;
      }
    shadow_map_softness++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "shadow_map_softness", &shadow_map_softness)
        && shadow_map_softness == light->shadow_map_softness)
      {
        pass ("LIGHT.shadow_map_softness [RC] set+1 %u", shadow_map_softness);
      }
    else
      {
        fail ("LIGHT.shadow_map_softness [RC] set+1 %u != %u", light->shadow_map_softness, shadow_map_softness);
        error++;
      }
    light->shadow_map_softness--;

  }
  {
    BITCODE_BS shadow_type;
    if (dwg_dynapi_entity_value(light, "LIGHT", "shadow_type", &shadow_type, NULL)
        && shadow_type == light->shadow_type)
      {
        pass ("LIGHT.shadow_type [BS] %hu", shadow_type);
      }
    else
      {
        fail ("LIGHT.shadow_type [BS] %hu != %hu", light->shadow_type, shadow_type);
        error++;
      }
    shadow_type++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "shadow_type", &shadow_type)
        && shadow_type == light->shadow_type)
      {
        pass ("LIGHT.shadow_type [BS] set+1 %hu", shadow_type);
      }
    else
      {
        fail ("LIGHT.shadow_type [BS] set+1 %hu != %hu", light->shadow_type, shadow_type);
        error++;
      }
    light->shadow_type--;

  }
  {
    BITCODE_B status;
    if (dwg_dynapi_entity_value(light, "LIGHT", "status", &status, NULL)
        && status == light->status)
      {
        pass ("LIGHT.status [B] " FORMAT_B "", status);
      }
    else
      {
        fail ("LIGHT.status [B] " FORMAT_B " != " FORMAT_B "", light->status, status);
        error++;
      }
    status++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "status", &status)
        && status == light->status)
      {
        pass ("LIGHT.status [B] set+1 " FORMAT_B "", status);
      }
    else
      {
        fail ("LIGHT.status [B] set+1 " FORMAT_B " != " FORMAT_B "", light->status, status);
        error++;
      }
    light->status--;

  }
  {
    BITCODE_3BD target;
    if (dwg_dynapi_entity_value(light, "LIGHT", "target", &target, NULL)
        && !memcmp (&target, &light->target, sizeof (light->target)))
      {
        pass ("LIGHT.target [3BD]");
      }
    else
      {
        fail ("LIGHT.target [3BD]");
        error++;
      }
  }
  {
    BITCODE_BS type;
    if (dwg_dynapi_entity_value(light, "LIGHT", "type", &type, NULL)
        && type == light->type)
      {
        pass ("LIGHT.type [BS] %hu", type);
      }
    else
      {
        fail ("LIGHT.type [BS] %hu != %hu", light->type, type);
        error++;
      }
    type++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "type", &type)
        && type == light->type)
      {
        pass ("LIGHT.type [BS] set+1 %hu", type);
      }
    else
      {
        fail ("LIGHT.type [BS] set+1 %hu != %hu", light->type, type);
        error++;
      }
    light->type--;

  }
  {
    BITCODE_B use_attenuation_limits;
    if (dwg_dynapi_entity_value(light, "LIGHT", "use_attenuation_limits", &use_attenuation_limits, NULL)
        && use_attenuation_limits == light->use_attenuation_limits)
      {
        pass ("LIGHT.use_attenuation_limits [B] " FORMAT_B "", use_attenuation_limits);
      }
    else
      {
        fail ("LIGHT.use_attenuation_limits [B] " FORMAT_B " != " FORMAT_B "", light->use_attenuation_limits, use_attenuation_limits);
        error++;
      }
    use_attenuation_limits++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "use_attenuation_limits", &use_attenuation_limits)
        && use_attenuation_limits == light->use_attenuation_limits)
      {
        pass ("LIGHT.use_attenuation_limits [B] set+1 " FORMAT_B "", use_attenuation_limits);
      }
    else
      {
        fail ("LIGHT.use_attenuation_limits [B] set+1 " FORMAT_B " != " FORMAT_B "", light->use_attenuation_limits, use_attenuation_limits);
        error++;
      }
    light->use_attenuation_limits--;

  }
  return error;
}
static int test_LINE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_LINE *restrict line = obj->tio.entity->tio.LINE;
  {
    BITCODE_RC Zs_are_zero;
    if (dwg_dynapi_entity_value(line, "LINE", "Zs_are_zero", &Zs_are_zero, NULL)
        && Zs_are_zero == line->Zs_are_zero)
      {
        pass ("LINE.Zs_are_zero [RC] %u", Zs_are_zero);
      }
    else
      {
        fail ("LINE.Zs_are_zero [RC] %u != %u", line->Zs_are_zero, Zs_are_zero);
        error++;
      }
    Zs_are_zero++;
    if (dwg_dynapi_entity_set_value (line, "LINE", "Zs_are_zero", &Zs_are_zero)
        && Zs_are_zero == line->Zs_are_zero)
      {
        pass ("LINE.Zs_are_zero [RC] set+1 %u", Zs_are_zero);
      }
    else
      {
        fail ("LINE.Zs_are_zero [RC] set+1 %u != %u", line->Zs_are_zero, Zs_are_zero);
        error++;
      }
    line->Zs_are_zero--;

  }
  {
    BITCODE_3BD end;
    if (dwg_dynapi_entity_value(line, "LINE", "end", &end, NULL)
        && !memcmp (&end, &line->end, sizeof (line->end)))
      {
        pass ("LINE.end [3BD]");
      }
    else
      {
        fail ("LINE.end [3BD]");
        error++;
      }
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value(line, "LINE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &line->extrusion, sizeof (line->extrusion)))
      {
        pass ("LINE.extrusion [BE]");
      }
    else
      {
        fail ("LINE.extrusion [BE]");
        error++;
      }
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(line, "LINE", "parent", &parent, NULL)
        && !memcmp (&parent, &line->parent, sizeof (line->parent)))
      {
        pass ("LINE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("LINE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_3BD start;
    if (dwg_dynapi_entity_value(line, "LINE", "start", &start, NULL)
        && !memcmp (&start, &line->start, sizeof (line->start)))
      {
        pass ("LINE.start [3BD]");
      }
    else
      {
        fail ("LINE.start [3BD]");
        error++;
      }
  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value(line, "LINE", "thickness", &thickness, NULL)
        && thickness == line->thickness)
      {
        pass ("LINE.thickness [BT] " FORMAT_BT "", thickness);
      }
    else
      {
        fail ("LINE.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", line->thickness, thickness);
        error++;
      }
    if (dwg_dynapi_entity_set_value (line, "LINE", "thickness", &thickness)
        && thickness == line->thickness)
      {
        pass ("LINE.thickness [BT] set+1 " FORMAT_BT "", thickness);
      }
    else
      {
        fail ("LINE.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", line->thickness, thickness);
        error++;
      }
    line->thickness--;

  }
  return error;
}
static int test_LOFTEDSURFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_LOFTEDSURFACE *restrict loftedsurface = obj->tio.entity->tio.LOFTEDSURFACE;
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "acis_data", &acis_data, NULL)
        && !strcmp ((char *)acis_data, (char *)loftedsurface->acis_data))
      {
        pass ("LOFTEDSURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, loftedsurface->acis_data);
      }
    else
      {
        fail ("LOFTEDSURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, loftedsurface->acis_data);
        error++;
      }
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "acis_empty", &acis_empty, NULL)
        && acis_empty == loftedsurface->acis_empty)
      {
        pass ("LOFTEDSURFACE.acis_empty [B] " FORMAT_B "", acis_empty);
      }
    else
      {
        fail ("LOFTEDSURFACE.acis_empty [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->acis_empty, acis_empty);
        error++;
      }
    acis_empty++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "acis_empty", &acis_empty)
        && acis_empty == loftedsurface->acis_empty)
      {
        pass ("LOFTEDSURFACE.acis_empty [B] set+1 " FORMAT_B "", acis_empty);
      }
    else
      {
        fail ("LOFTEDSURFACE.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->acis_empty, acis_empty);
        error++;
      }
    loftedsurface->acis_empty--;

  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == loftedsurface->acis_empty2)
      {
        pass ("LOFTEDSURFACE.acis_empty2 [B] " FORMAT_B "", acis_empty2);
      }
    else
      {
        fail ("LOFTEDSURFACE.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->acis_empty2, acis_empty2);
        error++;
      }
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "acis_empty2", &acis_empty2)
        && acis_empty2 == loftedsurface->acis_empty2)
      {
        pass ("LOFTEDSURFACE.acis_empty2 [B] set+1 " FORMAT_B "", acis_empty2);
      }
    else
      {
        fail ("LOFTEDSURFACE.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->acis_empty2, acis_empty2);
        error++;
      }
    loftedsurface->acis_empty2--;

  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == loftedsurface->acis_empty_bit)
      {
        pass ("LOFTEDSURFACE.acis_empty_bit [B] " FORMAT_B "", acis_empty_bit);
      }
    else
      {
        fail ("LOFTEDSURFACE.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->acis_empty_bit, acis_empty_bit);
        error++;
      }
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "acis_empty_bit", &acis_empty_bit)
        && acis_empty_bit == loftedsurface->acis_empty_bit)
      {
        pass ("LOFTEDSURFACE.acis_empty_bit [B] set+1 " FORMAT_B "", acis_empty_bit);
      }
    else
      {
        fail ("LOFTEDSURFACE.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->acis_empty_bit, acis_empty_bit);
        error++;
      }
    loftedsurface->acis_empty_bit--;

  }
  {
    BITCODE_B align_direction;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "align_direction", &align_direction, NULL)
        && align_direction == loftedsurface->align_direction)
      {
        pass ("LOFTEDSURFACE.align_direction [B] " FORMAT_B "", align_direction);
      }
    else
      {
        fail ("LOFTEDSURFACE.align_direction [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->align_direction, align_direction);
        error++;
      }
    align_direction++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "align_direction", &align_direction)
        && align_direction == loftedsurface->align_direction)
      {
        pass ("LOFTEDSURFACE.align_direction [B] set+1 " FORMAT_B "", align_direction);
      }
    else
      {
        fail ("LOFTEDSURFACE.align_direction [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->align_direction, align_direction);
        error++;
      }
    loftedsurface->align_direction--;

  }
  {
    BITCODE_B arc_length_parameterization;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "arc_length_parameterization", &arc_length_parameterization, NULL)
        && arc_length_parameterization == loftedsurface->arc_length_parameterization)
      {
        pass ("LOFTEDSURFACE.arc_length_parameterization [B] " FORMAT_B "", arc_length_parameterization);
      }
    else
      {
        fail ("LOFTEDSURFACE.arc_length_parameterization [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->arc_length_parameterization, arc_length_parameterization);
        error++;
      }
    arc_length_parameterization++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "arc_length_parameterization", &arc_length_parameterization)
        && arc_length_parameterization == loftedsurface->arc_length_parameterization)
      {
        pass ("LOFTEDSURFACE.arc_length_parameterization [B] set+1 " FORMAT_B "", arc_length_parameterization);
      }
    else
      {
        fail ("LOFTEDSURFACE.arc_length_parameterization [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->arc_length_parameterization, arc_length_parameterization);
        error++;
      }
    loftedsurface->arc_length_parameterization--;

  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &loftedsurface->block_size, sizeof (loftedsurface->block_size)))
      {
        pass ("LOFTEDSURFACE.block_size [BL*]");
      }
    else
      {
        fail ("LOFTEDSURFACE.block_size [BL*]");
        error++;
      }
  }
  {
    BITCODE_B closed_surfaces;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "closed_surfaces", &closed_surfaces, NULL)
        && closed_surfaces == loftedsurface->closed_surfaces)
      {
        pass ("LOFTEDSURFACE.closed_surfaces [B] " FORMAT_B "", closed_surfaces);
      }
    else
      {
        fail ("LOFTEDSURFACE.closed_surfaces [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->closed_surfaces, closed_surfaces);
        error++;
      }
    closed_surfaces++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "closed_surfaces", &closed_surfaces)
        && closed_surfaces == loftedsurface->closed_surfaces)
      {
        pass ("LOFTEDSURFACE.closed_surfaces [B] set+1 " FORMAT_B "", closed_surfaces);
      }
    else
      {
        fail ("LOFTEDSURFACE.closed_surfaces [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->closed_surfaces, closed_surfaces);
        error++;
      }
    loftedsurface->closed_surfaces--;

  }
  {
    BITCODE_H* cross_sections;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_cross_sections", &count, NULL)
        && dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "cross_sections", &cross_sections, NULL)
        && cross_sections == loftedsurface->cross_sections)
      {
        pass ("LOFTEDSURFACE.cross_sections [H*] * %u num_cross_sections", count);
      }
    else
      {
        fail ("LOFTEDSURFACE.cross_sections [H*] * %u num_cross_sections", count);
        error++;
      }
  }
  {
    char ** encr_sat_data;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_encr_sat_data", &count, NULL)
        && dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "encr_sat_data", &encr_sat_data, NULL)
)
      {
        pass ("LOFTEDSURFACE.encr_sat_data [char **] * %u num_encr_sat_data", count);
      }
    else
      {
        fail ("LOFTEDSURFACE.encr_sat_data [char **] * %u num_encr_sat_data", count);
        error++;
      }
  }
  {
    BITCODE_BD end_draft_angle;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "end_draft_angle", &end_draft_angle, NULL)
        && end_draft_angle == loftedsurface->end_draft_angle)
      {
        pass ("LOFTEDSURFACE.end_draft_angle [BD] %g", end_draft_angle);
      }
    else
      {
        fail ("LOFTEDSURFACE.end_draft_angle [BD] %g != %g", loftedsurface->end_draft_angle, end_draft_angle);
        error++;
      }
    end_draft_angle++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "end_draft_angle", &end_draft_angle)
        && end_draft_angle == loftedsurface->end_draft_angle)
      {
        pass ("LOFTEDSURFACE.end_draft_angle [BD] set+1 %g", end_draft_angle);
      }
    else
      {
        fail ("LOFTEDSURFACE.end_draft_angle [BD] set+1 %g != %g", loftedsurface->end_draft_angle, end_draft_angle);
        error++;
      }
    loftedsurface->end_draft_angle--;

  }
  {
    BITCODE_BD end_draft_magnitude;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "end_draft_magnitude", &end_draft_magnitude, NULL)
        && end_draft_magnitude == loftedsurface->end_draft_magnitude)
      {
        pass ("LOFTEDSURFACE.end_draft_magnitude [BD] %g", end_draft_magnitude);
      }
    else
      {
        fail ("LOFTEDSURFACE.end_draft_magnitude [BD] %g != %g", loftedsurface->end_draft_magnitude, end_draft_magnitude);
        error++;
      }
    end_draft_magnitude++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "end_draft_magnitude", &end_draft_magnitude)
        && end_draft_magnitude == loftedsurface->end_draft_magnitude)
      {
        pass ("LOFTEDSURFACE.end_draft_magnitude [BD] set+1 %g", end_draft_magnitude);
      }
    else
      {
        fail ("LOFTEDSURFACE.end_draft_magnitude [BD] set+1 %g != %g", loftedsurface->end_draft_magnitude, end_draft_magnitude);
        error++;
      }
    loftedsurface->end_draft_magnitude--;

  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &loftedsurface->extra_acis_data, sizeof (loftedsurface->extra_acis_data)))
      {
        pass ("LOFTEDSURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
      }
    else
      {
        fail ("LOFTEDSURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
        error++;
      }
  }
  {
    BITCODE_H* guide_curves;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_guide_curves", &count, NULL)
        && dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "guide_curves", &guide_curves, NULL)
        && guide_curves == loftedsurface->guide_curves)
      {
        pass ("LOFTEDSURFACE.guide_curves [H*] * %u num_guide_curves", count);
      }
    else
      {
        fail ("LOFTEDSURFACE.guide_curves [H*] * %u num_guide_curves", count);
        error++;
      }
  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &loftedsurface->history_id, sizeof (loftedsurface->history_id)))
      {
        pass ("LOFTEDSURFACE.history_id [H]");
      }
    else
      {
        fail ("LOFTEDSURFACE.history_id [H]");
        error++;
      }
  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "isoline_present", &isoline_present, NULL)
        && isoline_present == loftedsurface->isoline_present)
      {
        pass ("LOFTEDSURFACE.isoline_present [B] " FORMAT_B "", isoline_present);
      }
    else
      {
        fail ("LOFTEDSURFACE.isoline_present [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->isoline_present, isoline_present);
        error++;
      }
    isoline_present++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "isoline_present", &isoline_present)
        && isoline_present == loftedsurface->isoline_present)
      {
        pass ("LOFTEDSURFACE.isoline_present [B] set+1 " FORMAT_B "", isoline_present);
      }
    else
      {
        fail ("LOFTEDSURFACE.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->isoline_present, isoline_present);
        error++;
      }
    loftedsurface->isoline_present--;

  }
  {
    BITCODE_BD* loft_entity_transmatrix;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "loft_entity_transmatrix", &loft_entity_transmatrix, NULL)
        && !memcmp (&loft_entity_transmatrix, &loftedsurface->loft_entity_transmatrix, sizeof (loftedsurface->loft_entity_transmatrix)))
      {
        pass ("LOFTEDSURFACE.loft_entity_transmatrix [BD*]");
      }
    else
      {
        fail ("LOFTEDSURFACE.loft_entity_transmatrix [BD*]");
        error++;
      }
  }
  {
    BITCODE_BS modeler_format_version;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "modeler_format_version", &modeler_format_version, NULL)
        && modeler_format_version == loftedsurface->modeler_format_version)
      {
        pass ("LOFTEDSURFACE.modeler_format_version [BS] %hu", modeler_format_version);
      }
    else
      {
        fail ("LOFTEDSURFACE.modeler_format_version [BS] %hu != %hu", loftedsurface->modeler_format_version, modeler_format_version);
        error++;
      }
    modeler_format_version++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "modeler_format_version", &modeler_format_version)
        && modeler_format_version == loftedsurface->modeler_format_version)
      {
        pass ("LOFTEDSURFACE.modeler_format_version [BS] set+1 %hu", modeler_format_version);
      }
    else
      {
        fail ("LOFTEDSURFACE.modeler_format_version [BS] set+1 %hu != %hu", loftedsurface->modeler_format_version, modeler_format_version);
        error++;
      }
    loftedsurface->modeler_format_version--;

  }
  {
    BITCODE_B no_twist;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "no_twist", &no_twist, NULL)
        && no_twist == loftedsurface->no_twist)
      {
        pass ("LOFTEDSURFACE.no_twist [B] " FORMAT_B "", no_twist);
      }
    else
      {
        fail ("LOFTEDSURFACE.no_twist [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->no_twist, no_twist);
        error++;
      }
    no_twist++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "no_twist", &no_twist)
        && no_twist == loftedsurface->no_twist)
      {
        pass ("LOFTEDSURFACE.no_twist [B] set+1 " FORMAT_B "", no_twist);
      }
    else
      {
        fail ("LOFTEDSURFACE.no_twist [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->no_twist, no_twist);
        error++;
      }
    loftedsurface->no_twist--;

  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "num_blocks", &num_blocks, NULL)
        && num_blocks == loftedsurface->num_blocks)
      {
        pass ("LOFTEDSURFACE.num_blocks [BL] %u", num_blocks);
      }
    else
      {
        fail ("LOFTEDSURFACE.num_blocks [BL] %u != %u", loftedsurface->num_blocks, num_blocks);
        error++;
      }
    num_blocks++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "num_blocks", &num_blocks)
        && num_blocks == loftedsurface->num_blocks)
      {
        pass ("LOFTEDSURFACE.num_blocks [BL] set+1 %u", num_blocks);
      }
    else
      {
        fail ("LOFTEDSURFACE.num_blocks [BL] set+1 %u != %u", loftedsurface->num_blocks, num_blocks);
        error++;
      }
    loftedsurface->num_blocks--;

  }
  {
    BITCODE_BS num_cross_sections;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "num_cross_sections", &num_cross_sections, NULL)
        && num_cross_sections == loftedsurface->num_cross_sections)
      {
        pass ("LOFTEDSURFACE.num_cross_sections [BS] %hu", num_cross_sections);
      }
    else
      {
        fail ("LOFTEDSURFACE.num_cross_sections [BS] %hu != %hu", loftedsurface->num_cross_sections, num_cross_sections);
        error++;
      }
    num_cross_sections++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "num_cross_sections", &num_cross_sections)
        && num_cross_sections == loftedsurface->num_cross_sections)
      {
        pass ("LOFTEDSURFACE.num_cross_sections [BS] set+1 %hu", num_cross_sections);
      }
    else
      {
        fail ("LOFTEDSURFACE.num_cross_sections [BS] set+1 %hu != %hu", loftedsurface->num_cross_sections, num_cross_sections);
        error++;
      }
    loftedsurface->num_cross_sections--;

  }
  {
    BITCODE_BS num_guide_curves;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "num_guide_curves", &num_guide_curves, NULL)
        && num_guide_curves == loftedsurface->num_guide_curves)
      {
        pass ("LOFTEDSURFACE.num_guide_curves [BS] %hu", num_guide_curves);
      }
    else
      {
        fail ("LOFTEDSURFACE.num_guide_curves [BS] %hu != %hu", loftedsurface->num_guide_curves, num_guide_curves);
        error++;
      }
    num_guide_curves++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "num_guide_curves", &num_guide_curves)
        && num_guide_curves == loftedsurface->num_guide_curves)
      {
        pass ("LOFTEDSURFACE.num_guide_curves [BS] set+1 %hu", num_guide_curves);
      }
    else
      {
        fail ("LOFTEDSURFACE.num_guide_curves [BS] set+1 %hu != %hu", loftedsurface->num_guide_curves, num_guide_curves);
        error++;
      }
    loftedsurface->num_guide_curves--;

  }
  {
    BITCODE_BL num_isolines;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "num_isolines", &num_isolines, NULL)
        && num_isolines == loftedsurface->num_isolines)
      {
        pass ("LOFTEDSURFACE.num_isolines [BL] %u", num_isolines);
      }
    else
      {
        fail ("LOFTEDSURFACE.num_isolines [BL] %u != %u", loftedsurface->num_isolines, num_isolines);
        error++;
      }
    num_isolines++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "num_isolines", &num_isolines)
        && num_isolines == loftedsurface->num_isolines)
      {
        pass ("LOFTEDSURFACE.num_isolines [BL] set+1 %u", num_isolines);
      }
    else
      {
        fail ("LOFTEDSURFACE.num_isolines [BL] set+1 %u != %u", loftedsurface->num_isolines, num_isolines);
        error++;
      }
    loftedsurface->num_isolines--;

  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == loftedsurface->num_silhouettes)
      {
        pass ("LOFTEDSURFACE.num_silhouettes [BL] %u", num_silhouettes);
      }
    else
      {
        fail ("LOFTEDSURFACE.num_silhouettes [BL] %u != %u", loftedsurface->num_silhouettes, num_silhouettes);
        error++;
      }
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "num_silhouettes", &num_silhouettes)
        && num_silhouettes == loftedsurface->num_silhouettes)
      {
        pass ("LOFTEDSURFACE.num_silhouettes [BL] set+1 %u", num_silhouettes);
      }
    else
      {
        fail ("LOFTEDSURFACE.num_silhouettes [BL] set+1 %u != %u", loftedsurface->num_silhouettes, num_silhouettes);
        error++;
      }
    loftedsurface->num_silhouettes--;

  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "num_wires", &num_wires, NULL)
        && num_wires == loftedsurface->num_wires)
      {
        pass ("LOFTEDSURFACE.num_wires [BL] %u", num_wires);
      }
    else
      {
        fail ("LOFTEDSURFACE.num_wires [BL] %u != %u", loftedsurface->num_wires, num_wires);
        error++;
      }
    num_wires++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "num_wires", &num_wires)
        && num_wires == loftedsurface->num_wires)
      {
        pass ("LOFTEDSURFACE.num_wires [BL] set+1 %u", num_wires);
      }
    else
      {
        fail ("LOFTEDSURFACE.num_wires [BL] set+1 %u != %u", loftedsurface->num_wires, num_wires);
        error++;
      }
    loftedsurface->num_wires--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &loftedsurface->parent, sizeof (loftedsurface->parent)))
      {
        pass ("LOFTEDSURFACE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("LOFTEDSURFACE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_H path_curve;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "path_curve", &path_curve, NULL)
        && !memcmp (&path_curve, &loftedsurface->path_curve, sizeof (loftedsurface->path_curve)))
      {
        pass ("LOFTEDSURFACE.path_curve [H]");
      }
    else
      {
        fail ("LOFTEDSURFACE.path_curve [H]");
        error++;
      }
  }
  {
    BITCODE_BL plane_normal_lofting_type;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "plane_normal_lofting_type", &plane_normal_lofting_type, NULL)
        && plane_normal_lofting_type == loftedsurface->plane_normal_lofting_type)
      {
        pass ("LOFTEDSURFACE.plane_normal_lofting_type [BL] %u", plane_normal_lofting_type);
      }
    else
      {
        fail ("LOFTEDSURFACE.plane_normal_lofting_type [BL] %u != %u", loftedsurface->plane_normal_lofting_type, plane_normal_lofting_type);
        error++;
      }
    plane_normal_lofting_type++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "plane_normal_lofting_type", &plane_normal_lofting_type)
        && plane_normal_lofting_type == loftedsurface->plane_normal_lofting_type)
      {
        pass ("LOFTEDSURFACE.plane_normal_lofting_type [BL] set+1 %u", plane_normal_lofting_type);
      }
    else
      {
        fail ("LOFTEDSURFACE.plane_normal_lofting_type [BL] set+1 %u != %u", loftedsurface->plane_normal_lofting_type, plane_normal_lofting_type);
        error++;
      }
    loftedsurface->plane_normal_lofting_type--;

  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "point", &point, NULL)
        && !memcmp (&point, &loftedsurface->point, sizeof (loftedsurface->point)))
      {
        pass ("LOFTEDSURFACE.point [3BD]");
      }
    else
      {
        fail ("LOFTEDSURFACE.point [3BD]");
        error++;
      }
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "point_present", &point_present, NULL)
        && point_present == loftedsurface->point_present)
      {
        pass ("LOFTEDSURFACE.point_present [B] " FORMAT_B "", point_present);
      }
    else
      {
        fail ("LOFTEDSURFACE.point_present [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->point_present, point_present);
        error++;
      }
    point_present++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "point_present", &point_present)
        && point_present == loftedsurface->point_present)
      {
        pass ("LOFTEDSURFACE.point_present [B] set+1 " FORMAT_B "", point_present);
      }
    else
      {
        fail ("LOFTEDSURFACE.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->point_present, point_present);
        error++;
      }
    loftedsurface->point_present--;

  }
  {
    BITCODE_B ruled_surface;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "ruled_surface", &ruled_surface, NULL)
        && ruled_surface == loftedsurface->ruled_surface)
      {
        pass ("LOFTEDSURFACE.ruled_surface [B] " FORMAT_B "", ruled_surface);
      }
    else
      {
        fail ("LOFTEDSURFACE.ruled_surface [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->ruled_surface, ruled_surface);
        error++;
      }
    ruled_surface++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "ruled_surface", &ruled_surface)
        && ruled_surface == loftedsurface->ruled_surface)
      {
        pass ("LOFTEDSURFACE.ruled_surface [B] set+1 " FORMAT_B "", ruled_surface);
      }
    else
      {
        fail ("LOFTEDSURFACE.ruled_surface [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->ruled_surface, ruled_surface);
        error++;
      }
    loftedsurface->ruled_surface--;

  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "silhouettes", &silhouettes, NULL)
        && silhouettes == loftedsurface->silhouettes)
      {
        pass ("LOFTEDSURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
      }
    else
      {
        fail ("LOFTEDSURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
        error++;
      }
  }
  {
    BITCODE_B simple_surfaces;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "simple_surfaces", &simple_surfaces, NULL)
        && simple_surfaces == loftedsurface->simple_surfaces)
      {
        pass ("LOFTEDSURFACE.simple_surfaces [B] " FORMAT_B "", simple_surfaces);
      }
    else
      {
        fail ("LOFTEDSURFACE.simple_surfaces [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->simple_surfaces, simple_surfaces);
        error++;
      }
    simple_surfaces++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "simple_surfaces", &simple_surfaces)
        && simple_surfaces == loftedsurface->simple_surfaces)
      {
        pass ("LOFTEDSURFACE.simple_surfaces [B] set+1 " FORMAT_B "", simple_surfaces);
      }
    else
      {
        fail ("LOFTEDSURFACE.simple_surfaces [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->simple_surfaces, simple_surfaces);
        error++;
      }
    loftedsurface->simple_surfaces--;

  }
  {
    BITCODE_B solid;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "solid", &solid, NULL)
        && solid == loftedsurface->solid)
      {
        pass ("LOFTEDSURFACE.solid [B] " FORMAT_B "", solid);
      }
    else
      {
        fail ("LOFTEDSURFACE.solid [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->solid, solid);
        error++;
      }
    solid++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "solid", &solid)
        && solid == loftedsurface->solid)
      {
        pass ("LOFTEDSURFACE.solid [B] set+1 " FORMAT_B "", solid);
      }
    else
      {
        fail ("LOFTEDSURFACE.solid [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->solid, solid);
        error++;
      }
    loftedsurface->solid--;

  }
  {
    BITCODE_BD start_draft_angle;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "start_draft_angle", &start_draft_angle, NULL)
        && start_draft_angle == loftedsurface->start_draft_angle)
      {
        pass ("LOFTEDSURFACE.start_draft_angle [BD] %g", start_draft_angle);
      }
    else
      {
        fail ("LOFTEDSURFACE.start_draft_angle [BD] %g != %g", loftedsurface->start_draft_angle, start_draft_angle);
        error++;
      }
    start_draft_angle++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "start_draft_angle", &start_draft_angle)
        && start_draft_angle == loftedsurface->start_draft_angle)
      {
        pass ("LOFTEDSURFACE.start_draft_angle [BD] set+1 %g", start_draft_angle);
      }
    else
      {
        fail ("LOFTEDSURFACE.start_draft_angle [BD] set+1 %g != %g", loftedsurface->start_draft_angle, start_draft_angle);
        error++;
      }
    loftedsurface->start_draft_angle--;

  }
  {
    BITCODE_BD start_draft_magnitude;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "start_draft_magnitude", &start_draft_magnitude, NULL)
        && start_draft_magnitude == loftedsurface->start_draft_magnitude)
      {
        pass ("LOFTEDSURFACE.start_draft_magnitude [BD] %g", start_draft_magnitude);
      }
    else
      {
        fail ("LOFTEDSURFACE.start_draft_magnitude [BD] %g != %g", loftedsurface->start_draft_magnitude, start_draft_magnitude);
        error++;
      }
    start_draft_magnitude++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "start_draft_magnitude", &start_draft_magnitude)
        && start_draft_magnitude == loftedsurface->start_draft_magnitude)
      {
        pass ("LOFTEDSURFACE.start_draft_magnitude [BD] set+1 %g", start_draft_magnitude);
      }
    else
      {
        fail ("LOFTEDSURFACE.start_draft_magnitude [BD] set+1 %g != %g", loftedsurface->start_draft_magnitude, start_draft_magnitude);
        error++;
      }
    loftedsurface->start_draft_magnitude--;

  }
  {
    BITCODE_BS u_isolines;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "u_isolines", &u_isolines, NULL)
        && u_isolines == loftedsurface->u_isolines)
      {
        pass ("LOFTEDSURFACE.u_isolines [BS] %hu", u_isolines);
      }
    else
      {
        fail ("LOFTEDSURFACE.u_isolines [BS] %hu != %hu", loftedsurface->u_isolines, u_isolines);
        error++;
      }
    u_isolines++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "u_isolines", &u_isolines)
        && u_isolines == loftedsurface->u_isolines)
      {
        pass ("LOFTEDSURFACE.u_isolines [BS] set+1 %hu", u_isolines);
      }
    else
      {
        fail ("LOFTEDSURFACE.u_isolines [BS] set+1 %hu != %hu", loftedsurface->u_isolines, u_isolines);
        error++;
      }
    loftedsurface->u_isolines--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "unknown", &unknown, NULL)
        && unknown == loftedsurface->unknown)
      {
        pass ("LOFTEDSURFACE.unknown [B] " FORMAT_B "", unknown);
      }
    else
      {
        fail ("LOFTEDSURFACE.unknown [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->unknown, unknown);
        error++;
      }
    unknown++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "unknown", &unknown)
        && unknown == loftedsurface->unknown)
      {
        pass ("LOFTEDSURFACE.unknown [B] set+1 " FORMAT_B "", unknown);
      }
    else
      {
        fail ("LOFTEDSURFACE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->unknown, unknown);
        error++;
      }
    loftedsurface->unknown--;

  }
  {
    BITCODE_BL unknown_2007;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "unknown_2007", &unknown_2007, NULL)
        && unknown_2007 == loftedsurface->unknown_2007)
      {
        pass ("LOFTEDSURFACE.unknown_2007 [BL] %u", unknown_2007);
      }
    else
      {
        fail ("LOFTEDSURFACE.unknown_2007 [BL] %u != %u", loftedsurface->unknown_2007, unknown_2007);
        error++;
      }
    unknown_2007++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "unknown_2007", &unknown_2007)
        && unknown_2007 == loftedsurface->unknown_2007)
      {
        pass ("LOFTEDSURFACE.unknown_2007 [BL] set+1 %u", unknown_2007);
      }
    else
      {
        fail ("LOFTEDSURFACE.unknown_2007 [BL] set+1 %u != %u", loftedsurface->unknown_2007, unknown_2007);
        error++;
      }
    loftedsurface->unknown_2007--;

  }
  {
    BITCODE_BS v_isolines;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "v_isolines", &v_isolines, NULL)
        && v_isolines == loftedsurface->v_isolines)
      {
        pass ("LOFTEDSURFACE.v_isolines [BS] %hu", v_isolines);
      }
    else
      {
        fail ("LOFTEDSURFACE.v_isolines [BS] %hu != %hu", loftedsurface->v_isolines, v_isolines);
        error++;
      }
    v_isolines++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "v_isolines", &v_isolines)
        && v_isolines == loftedsurface->v_isolines)
      {
        pass ("LOFTEDSURFACE.v_isolines [BS] set+1 %hu", v_isolines);
      }
    else
      {
        fail ("LOFTEDSURFACE.v_isolines [BS] set+1 %hu != %hu", loftedsurface->v_isolines, v_isolines);
        error++;
      }
    loftedsurface->v_isolines--;

  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "version", &version, NULL)
        && version == loftedsurface->version)
      {
        pass ("LOFTEDSURFACE.version [BS] %hu", version);
      }
    else
      {
        fail ("LOFTEDSURFACE.version [BS] %hu != %hu", loftedsurface->version, version);
        error++;
      }
    version++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "version", &version)
        && version == loftedsurface->version)
      {
        pass ("LOFTEDSURFACE.version [BS] set+1 %hu", version);
      }
    else
      {
        fail ("LOFTEDSURFACE.version [BS] set+1 %hu != %hu", loftedsurface->version, version);
        error++;
      }
    loftedsurface->version--;

  }
  {
    BITCODE_B virtual_guide;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "virtual_guide", &virtual_guide, NULL)
        && virtual_guide == loftedsurface->virtual_guide)
      {
        pass ("LOFTEDSURFACE.virtual_guide [B] " FORMAT_B "", virtual_guide);
      }
    else
      {
        fail ("LOFTEDSURFACE.virtual_guide [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->virtual_guide, virtual_guide);
        error++;
      }
    virtual_guide++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "virtual_guide", &virtual_guide)
        && virtual_guide == loftedsurface->virtual_guide)
      {
        pass ("LOFTEDSURFACE.virtual_guide [B] set+1 " FORMAT_B "", virtual_guide);
      }
    else
      {
        fail ("LOFTEDSURFACE.virtual_guide [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->virtual_guide, virtual_guide);
        error++;
      }
    loftedsurface->virtual_guide--;

  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value(loftedsurface, "LOFTEDSURFACE", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == loftedsurface->wireframe_data_present)
      {
        pass ("LOFTEDSURFACE.wireframe_data_present [B] " FORMAT_B "", wireframe_data_present);
      }
    else
      {
        fail ("LOFTEDSURFACE.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->wireframe_data_present, wireframe_data_present);
        error++;
      }
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "wireframe_data_present", &wireframe_data_present)
        && wireframe_data_present == loftedsurface->wireframe_data_present)
      {
        pass ("LOFTEDSURFACE.wireframe_data_present [B] set+1 " FORMAT_B "", wireframe_data_present);
      }
    else
      {
        fail ("LOFTEDSURFACE.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->wireframe_data_present, wireframe_data_present);
        error++;
      }
    loftedsurface->wireframe_data_present--;

  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "wires", &wires, NULL)
        && wires == loftedsurface->wires)
      {
        pass ("LOFTEDSURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
      }
    else
      {
        fail ("LOFTEDSURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
        error++;
      }
  }
  return error;
}
static int test_LWPOLYLINE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_LWPOLYLINE *restrict lwpolyline = obj->tio.entity->tio.LWPOLYLINE;
  {
    BITCODE_BD* bulges;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_bulges", &count, NULL)
        && dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "bulges", &bulges, NULL)
        && bulges == lwpolyline->bulges)
      {
        pass ("LWPOLYLINE.bulges [BD*] * %u num_bulges", count);
      }
    else
      {
        fail ("LWPOLYLINE.bulges [BD*] * %u num_bulges", count);
        error++;
      }
  }
  {
    BITCODE_BD const_width;
    if (dwg_dynapi_entity_value(lwpolyline, "LWPOLYLINE", "const_width", &const_width, NULL)
        && const_width == lwpolyline->const_width)
      {
        pass ("LWPOLYLINE.const_width [BD] %g", const_width);
      }
    else
      {
        fail ("LWPOLYLINE.const_width [BD] %g != %g", lwpolyline->const_width, const_width);
        error++;
      }
    const_width++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "const_width", &const_width)
        && const_width == lwpolyline->const_width)
      {
        pass ("LWPOLYLINE.const_width [BD] set+1 %g", const_width);
      }
    else
      {
        fail ("LWPOLYLINE.const_width [BD] set+1 %g != %g", lwpolyline->const_width, const_width);
        error++;
      }
    lwpolyline->const_width--;

  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value(lwpolyline, "LWPOLYLINE", "elevation", &elevation, NULL)
        && elevation == lwpolyline->elevation)
      {
        pass ("LWPOLYLINE.elevation [BD] %g", elevation);
      }
    else
      {
        fail ("LWPOLYLINE.elevation [BD] %g != %g", lwpolyline->elevation, elevation);
        error++;
      }
    elevation++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "elevation", &elevation)
        && elevation == lwpolyline->elevation)
      {
        pass ("LWPOLYLINE.elevation [BD] set+1 %g", elevation);
      }
    else
      {
        fail ("LWPOLYLINE.elevation [BD] set+1 %g != %g", lwpolyline->elevation, elevation);
        error++;
      }
    lwpolyline->elevation--;

  }
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value(lwpolyline, "LWPOLYLINE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &lwpolyline->extrusion, sizeof (lwpolyline->extrusion)))
      {
        pass ("LWPOLYLINE.extrusion [3BD]");
      }
    else
      {
        fail ("LWPOLYLINE.extrusion [3BD]");
        error++;
      }
  }
  {
    BITCODE_BS flag;
    if (dwg_dynapi_entity_value(lwpolyline, "LWPOLYLINE", "flag", &flag, NULL)
        && flag == lwpolyline->flag)
      {
        pass ("LWPOLYLINE.flag [BS] %hu", flag);
      }
    else
      {
        fail ("LWPOLYLINE.flag [BS] %hu != %hu", lwpolyline->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "flag", &flag)
        && flag == lwpolyline->flag)
      {
        pass ("LWPOLYLINE.flag [BS] set+1 %hu", flag);
      }
    else
      {
        fail ("LWPOLYLINE.flag [BS] set+1 %hu != %hu", lwpolyline->flag, flag);
        error++;
      }
    lwpolyline->flag--;

  }
  {
    BITCODE_BL num_bulges;
    if (dwg_dynapi_entity_value(lwpolyline, "LWPOLYLINE", "num_bulges", &num_bulges, NULL)
        && num_bulges == lwpolyline->num_bulges)
      {
        pass ("LWPOLYLINE.num_bulges [BL] %u", num_bulges);
      }
    else
      {
        fail ("LWPOLYLINE.num_bulges [BL] %u != %u", lwpolyline->num_bulges, num_bulges);
        error++;
      }
    num_bulges++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "num_bulges", &num_bulges)
        && num_bulges == lwpolyline->num_bulges)
      {
        pass ("LWPOLYLINE.num_bulges [BL] set+1 %u", num_bulges);
      }
    else
      {
        fail ("LWPOLYLINE.num_bulges [BL] set+1 %u != %u", lwpolyline->num_bulges, num_bulges);
        error++;
      }
    lwpolyline->num_bulges--;

  }
  {
    BITCODE_BL num_points;
    if (dwg_dynapi_entity_value(lwpolyline, "LWPOLYLINE", "num_points", &num_points, NULL)
        && num_points == lwpolyline->num_points)
      {
        pass ("LWPOLYLINE.num_points [BL] %u", num_points);
      }
    else
      {
        fail ("LWPOLYLINE.num_points [BL] %u != %u", lwpolyline->num_points, num_points);
        error++;
      }
    num_points++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "num_points", &num_points)
        && num_points == lwpolyline->num_points)
      {
        pass ("LWPOLYLINE.num_points [BL] set+1 %u", num_points);
      }
    else
      {
        fail ("LWPOLYLINE.num_points [BL] set+1 %u != %u", lwpolyline->num_points, num_points);
        error++;
      }
    lwpolyline->num_points--;

  }
  {
    BITCODE_BL num_vertexids;
    if (dwg_dynapi_entity_value(lwpolyline, "LWPOLYLINE", "num_vertexids", &num_vertexids, NULL)
        && num_vertexids == lwpolyline->num_vertexids)
      {
        pass ("LWPOLYLINE.num_vertexids [BL] %u", num_vertexids);
      }
    else
      {
        fail ("LWPOLYLINE.num_vertexids [BL] %u != %u", lwpolyline->num_vertexids, num_vertexids);
        error++;
      }
    num_vertexids++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "num_vertexids", &num_vertexids)
        && num_vertexids == lwpolyline->num_vertexids)
      {
        pass ("LWPOLYLINE.num_vertexids [BL] set+1 %u", num_vertexids);
      }
    else
      {
        fail ("LWPOLYLINE.num_vertexids [BL] set+1 %u != %u", lwpolyline->num_vertexids, num_vertexids);
        error++;
      }
    lwpolyline->num_vertexids--;

  }
  {
    BITCODE_BL num_widths;
    if (dwg_dynapi_entity_value(lwpolyline, "LWPOLYLINE", "num_widths", &num_widths, NULL)
        && num_widths == lwpolyline->num_widths)
      {
        pass ("LWPOLYLINE.num_widths [BL] %u", num_widths);
      }
    else
      {
        fail ("LWPOLYLINE.num_widths [BL] %u != %u", lwpolyline->num_widths, num_widths);
        error++;
      }
    num_widths++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "num_widths", &num_widths)
        && num_widths == lwpolyline->num_widths)
      {
        pass ("LWPOLYLINE.num_widths [BL] set+1 %u", num_widths);
      }
    else
      {
        fail ("LWPOLYLINE.num_widths [BL] set+1 %u != %u", lwpolyline->num_widths, num_widths);
        error++;
      }
    lwpolyline->num_widths--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(lwpolyline, "LWPOLYLINE", "parent", &parent, NULL)
        && !memcmp (&parent, &lwpolyline->parent, sizeof (lwpolyline->parent)))
      {
        pass ("LWPOLYLINE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("LWPOLYLINE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_2RD* points;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_points", &count, NULL)
        && dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "points", &points, NULL)
        && points == lwpolyline->points)
      {
        pass ("LWPOLYLINE.points [2RD*] * %u num_points", count);
      }
    else
      {
        fail ("LWPOLYLINE.points [2RD*] * %u num_points", count);
        error++;
      }
  }
  {
    BITCODE_BD thickness;
    if (dwg_dynapi_entity_value(lwpolyline, "LWPOLYLINE", "thickness", &thickness, NULL)
        && thickness == lwpolyline->thickness)
      {
        pass ("LWPOLYLINE.thickness [BD] %g", thickness);
      }
    else
      {
        fail ("LWPOLYLINE.thickness [BD] %g != %g", lwpolyline->thickness, thickness);
        error++;
      }
    thickness++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "thickness", &thickness)
        && thickness == lwpolyline->thickness)
      {
        pass ("LWPOLYLINE.thickness [BD] set+1 %g", thickness);
      }
    else
      {
        fail ("LWPOLYLINE.thickness [BD] set+1 %g != %g", lwpolyline->thickness, thickness);
        error++;
      }
    lwpolyline->thickness--;

  }
  {
    BITCODE_BL* vertexids;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_vertexids", &count, NULL)
        && dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "vertexids", &vertexids, NULL)
        && vertexids == lwpolyline->vertexids)
      {
        pass ("LWPOLYLINE.vertexids [BL*] * %u num_vertexids", count);
      }
    else
      {
        fail ("LWPOLYLINE.vertexids [BL*] * %u num_vertexids", count);
        error++;
      }
  }
  {
    Dwg_LWPOLYLINE_width* widths;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_widths", &count, NULL)
        && dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "widths", &widths, NULL)
        && widths == lwpolyline->widths)
      {
        pass ("LWPOLYLINE.widths [Dwg_LWPOLYLINE_width*] * %u num_widths", count);
      }
    else
      {
        fail ("LWPOLYLINE.widths [Dwg_LWPOLYLINE_width*] * %u num_widths", count);
        error++;
      }
  }
  return error;
}
static int test_MINSERT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_MINSERT *restrict minsert = obj->tio.entity->tio.MINSERT;
  {
    BITCODE_H* attrib_handles;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (minsert, "MINSERT", "attrib_handles", &attrib_handles, NULL)
        && attrib_handles == minsert->attrib_handles)
      {
        pass ("MINSERT.attrib_handles [H*] * %u num_owned", count);
      }
    else
      {
        fail ("MINSERT.attrib_handles [H*] * %u num_owned", count);
        error++;
      }
  }
  {
    BITCODE_H block_header;
    if (dwg_dynapi_entity_value(minsert, "MINSERT", "block_header", &block_header, NULL)
        && !memcmp (&block_header, &minsert->block_header, sizeof (minsert->block_header)))
      {
        pass ("MINSERT.block_header [H]");
      }
    else
      {
        fail ("MINSERT.block_header [H]");
        error++;
      }
  }
  {
    BITCODE_BD col_spacing;
    if (dwg_dynapi_entity_value(minsert, "MINSERT", "col_spacing", &col_spacing, NULL)
        && col_spacing == minsert->col_spacing)
      {
        pass ("MINSERT.col_spacing [BD] %g", col_spacing);
      }
    else
      {
        fail ("MINSERT.col_spacing [BD] %g != %g", minsert->col_spacing, col_spacing);
        error++;
      }
    col_spacing++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "col_spacing", &col_spacing)
        && col_spacing == minsert->col_spacing)
      {
        pass ("MINSERT.col_spacing [BD] set+1 %g", col_spacing);
      }
    else
      {
        fail ("MINSERT.col_spacing [BD] set+1 %g != %g", minsert->col_spacing, col_spacing);
        error++;
      }
    minsert->col_spacing--;

  }
  {
    BITCODE_3DPOINT extrusion;
    if (dwg_dynapi_entity_value(minsert, "MINSERT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &minsert->extrusion, sizeof (minsert->extrusion)))
      {
        pass ("MINSERT.extrusion [3DPOINT]");
      }
    else
      {
        fail ("MINSERT.extrusion [3DPOINT]");
        error++;
      }
  }
  {
    BITCODE_H first_attrib;
    if (dwg_dynapi_entity_value(minsert, "MINSERT", "first_attrib", &first_attrib, NULL)
        && !memcmp (&first_attrib, &minsert->first_attrib, sizeof (minsert->first_attrib)))
      {
        pass ("MINSERT.first_attrib [H]");
      }
    else
      {
        fail ("MINSERT.first_attrib [H]");
        error++;
      }
  }
  {
    BITCODE_B has_attribs;
    if (dwg_dynapi_entity_value(minsert, "MINSERT", "has_attribs", &has_attribs, NULL)
        && has_attribs == minsert->has_attribs)
      {
        pass ("MINSERT.has_attribs [B] " FORMAT_B "", has_attribs);
      }
    else
      {
        fail ("MINSERT.has_attribs [B] " FORMAT_B " != " FORMAT_B "", minsert->has_attribs, has_attribs);
        error++;
      }
    has_attribs++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "has_attribs", &has_attribs)
        && has_attribs == minsert->has_attribs)
      {
        pass ("MINSERT.has_attribs [B] set+1 " FORMAT_B "", has_attribs);
      }
    else
      {
        fail ("MINSERT.has_attribs [B] set+1 " FORMAT_B " != " FORMAT_B "", minsert->has_attribs, has_attribs);
        error++;
      }
    minsert->has_attribs--;

  }
  {
    BITCODE_3DPOINT ins_pt;
    if (dwg_dynapi_entity_value(minsert, "MINSERT", "ins_pt", &ins_pt, NULL)
        && !memcmp (&ins_pt, &minsert->ins_pt, sizeof (minsert->ins_pt)))
      {
        pass ("MINSERT.ins_pt [3DPOINT]");
      }
    else
      {
        fail ("MINSERT.ins_pt [3DPOINT]");
        error++;
      }
  }
  {
    BITCODE_H last_attrib;
    if (dwg_dynapi_entity_value(minsert, "MINSERT", "last_attrib", &last_attrib, NULL)
        && !memcmp (&last_attrib, &minsert->last_attrib, sizeof (minsert->last_attrib)))
      {
        pass ("MINSERT.last_attrib [H]");
      }
    else
      {
        fail ("MINSERT.last_attrib [H]");
        error++;
      }
  }
  {
    BITCODE_BS num_cols;
    if (dwg_dynapi_entity_value(minsert, "MINSERT", "num_cols", &num_cols, NULL)
        && num_cols == minsert->num_cols)
      {
        pass ("MINSERT.num_cols [BS] %hu", num_cols);
      }
    else
      {
        fail ("MINSERT.num_cols [BS] %hu != %hu", minsert->num_cols, num_cols);
        error++;
      }
    num_cols++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "num_cols", &num_cols)
        && num_cols == minsert->num_cols)
      {
        pass ("MINSERT.num_cols [BS] set+1 %hu", num_cols);
      }
    else
      {
        fail ("MINSERT.num_cols [BS] set+1 %hu != %hu", minsert->num_cols, num_cols);
        error++;
      }
    minsert->num_cols--;

  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value(minsert, "MINSERT", "num_owned", &num_owned, NULL)
        && num_owned == minsert->num_owned)
      {
        pass ("MINSERT.num_owned [BL] %u", num_owned);
      }
    else
      {
        fail ("MINSERT.num_owned [BL] %u != %u", minsert->num_owned, num_owned);
        error++;
      }
    num_owned++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "num_owned", &num_owned)
        && num_owned == minsert->num_owned)
      {
        pass ("MINSERT.num_owned [BL] set+1 %u", num_owned);
      }
    else
      {
        fail ("MINSERT.num_owned [BL] set+1 %u != %u", minsert->num_owned, num_owned);
        error++;
      }
    minsert->num_owned--;

  }
  {
    BITCODE_BS num_rows;
    if (dwg_dynapi_entity_value(minsert, "MINSERT", "num_rows", &num_rows, NULL)
        && num_rows == minsert->num_rows)
      {
        pass ("MINSERT.num_rows [BS] %hu", num_rows);
      }
    else
      {
        fail ("MINSERT.num_rows [BS] %hu != %hu", minsert->num_rows, num_rows);
        error++;
      }
    num_rows++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "num_rows", &num_rows)
        && num_rows == minsert->num_rows)
      {
        pass ("MINSERT.num_rows [BS] set+1 %hu", num_rows);
      }
    else
      {
        fail ("MINSERT.num_rows [BS] set+1 %hu != %hu", minsert->num_rows, num_rows);
        error++;
      }
    minsert->num_rows--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(minsert, "MINSERT", "parent", &parent, NULL)
        && !memcmp (&parent, &minsert->parent, sizeof (minsert->parent)))
      {
        pass ("MINSERT.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("MINSERT.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_BD rotation;
    if (dwg_dynapi_entity_value(minsert, "MINSERT", "rotation", &rotation, NULL)
        && rotation == minsert->rotation)
      {
        pass ("MINSERT.rotation [BD] %g", rotation);
      }
    else
      {
        fail ("MINSERT.rotation [BD] %g != %g", minsert->rotation, rotation);
        error++;
      }
    rotation++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "rotation", &rotation)
        && rotation == minsert->rotation)
      {
        pass ("MINSERT.rotation [BD] set+1 %g", rotation);
      }
    else
      {
        fail ("MINSERT.rotation [BD] set+1 %g != %g", minsert->rotation, rotation);
        error++;
      }
    minsert->rotation--;

  }
  {
    BITCODE_BD row_spacing;
    if (dwg_dynapi_entity_value(minsert, "MINSERT", "row_spacing", &row_spacing, NULL)
        && row_spacing == minsert->row_spacing)
      {
        pass ("MINSERT.row_spacing [BD] %g", row_spacing);
      }
    else
      {
        fail ("MINSERT.row_spacing [BD] %g != %g", minsert->row_spacing, row_spacing);
        error++;
      }
    row_spacing++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "row_spacing", &row_spacing)
        && row_spacing == minsert->row_spacing)
      {
        pass ("MINSERT.row_spacing [BD] set+1 %g", row_spacing);
      }
    else
      {
        fail ("MINSERT.row_spacing [BD] set+1 %g != %g", minsert->row_spacing, row_spacing);
        error++;
      }
    minsert->row_spacing--;

  }
  {
    BITCODE_3DPOINT scale;
    if (dwg_dynapi_entity_value(minsert, "MINSERT", "scale", &scale, NULL)
        && !memcmp (&scale, &minsert->scale, sizeof (minsert->scale)))
      {
        pass ("MINSERT.scale [3DPOINT]");
      }
    else
      {
        fail ("MINSERT.scale [3DPOINT]");
        error++;
      }
  }
  {
    BITCODE_BB scale_flag;
    if (dwg_dynapi_entity_value(minsert, "MINSERT", "scale_flag", &scale_flag, NULL)
        && scale_flag == minsert->scale_flag)
      {
        pass ("MINSERT.scale_flag [BB] " FORMAT_BB "", scale_flag);
      }
    else
      {
        fail ("MINSERT.scale_flag [BB] " FORMAT_BB " != " FORMAT_BB "", minsert->scale_flag, scale_flag);
        error++;
      }
    scale_flag++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "scale_flag", &scale_flag)
        && scale_flag == minsert->scale_flag)
      {
        pass ("MINSERT.scale_flag [BB] set+1 " FORMAT_BB "", scale_flag);
      }
    else
      {
        fail ("MINSERT.scale_flag [BB] set+1 " FORMAT_BB " != " FORMAT_BB "", minsert->scale_flag, scale_flag);
        error++;
      }
    minsert->scale_flag--;

  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value(minsert, "MINSERT", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &minsert->seqend, sizeof (minsert->seqend)))
      {
        pass ("MINSERT.seqend [H]");
      }
    else
      {
        fail ("MINSERT.seqend [H]");
        error++;
      }
  }
  return error;
}
static int test_MLINE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_MLINE *restrict mline = obj->tio.entity->tio.MLINE;
  {
    BITCODE_3BD base_point;
    if (dwg_dynapi_entity_value(mline, "MLINE", "base_point", &base_point, NULL)
        && !memcmp (&base_point, &mline->base_point, sizeof (mline->base_point)))
      {
        pass ("MLINE.base_point [3BD]");
      }
    else
      {
        fail ("MLINE.base_point [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value(mline, "MLINE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &mline->extrusion, sizeof (mline->extrusion)))
      {
        pass ("MLINE.extrusion [3BD]");
      }
    else
      {
        fail ("MLINE.extrusion [3BD]");
        error++;
      }
  }
  {
    BITCODE_BS flags;
    if (dwg_dynapi_entity_value(mline, "MLINE", "flags", &flags, NULL)
        && flags == mline->flags)
      {
        pass ("MLINE.flags [BS] %hu", flags);
      }
    else
      {
        fail ("MLINE.flags [BS] %hu != %hu", mline->flags, flags);
        error++;
      }
    flags++;
    if (dwg_dynapi_entity_set_value (mline, "MLINE", "flags", &flags)
        && flags == mline->flags)
      {
        pass ("MLINE.flags [BS] set+1 %hu", flags);
      }
    else
      {
        fail ("MLINE.flags [BS] set+1 %hu != %hu", mline->flags, flags);
        error++;
      }
    mline->flags--;

  }
  {
    BITCODE_RC justification;
    if (dwg_dynapi_entity_value(mline, "MLINE", "justification", &justification, NULL)
        && justification == mline->justification)
      {
        pass ("MLINE.justification [RC] %u", justification);
      }
    else
      {
        fail ("MLINE.justification [RC] %u != %u", mline->justification, justification);
        error++;
      }
    justification++;
    if (dwg_dynapi_entity_set_value (mline, "MLINE", "justification", &justification)
        && justification == mline->justification)
      {
        pass ("MLINE.justification [RC] set+1 %u", justification);
      }
    else
      {
        fail ("MLINE.justification [RC] set+1 %u != %u", mline->justification, justification);
        error++;
      }
    mline->justification--;

  }
  {
    BITCODE_H mlinestyle;
    if (dwg_dynapi_entity_value(mline, "MLINE", "mlinestyle", &mlinestyle, NULL)
        && !memcmp (&mlinestyle, &mline->mlinestyle, sizeof (mline->mlinestyle)))
      {
        pass ("MLINE.mlinestyle [H]");
      }
    else
      {
        fail ("MLINE.mlinestyle [H]");
        error++;
      }
  }
  {
    BITCODE_RC num_lines;
    if (dwg_dynapi_entity_value(mline, "MLINE", "num_lines", &num_lines, NULL)
        && num_lines == mline->num_lines)
      {
        pass ("MLINE.num_lines [RC] %u", num_lines);
      }
    else
      {
        fail ("MLINE.num_lines [RC] %u != %u", mline->num_lines, num_lines);
        error++;
      }
    num_lines++;
    if (dwg_dynapi_entity_set_value (mline, "MLINE", "num_lines", &num_lines)
        && num_lines == mline->num_lines)
      {
        pass ("MLINE.num_lines [RC] set+1 %u", num_lines);
      }
    else
      {
        fail ("MLINE.num_lines [RC] set+1 %u != %u", mline->num_lines, num_lines);
        error++;
      }
    mline->num_lines--;

  }
  {
    BITCODE_BS num_verts;
    if (dwg_dynapi_entity_value(mline, "MLINE", "num_verts", &num_verts, NULL)
        && num_verts == mline->num_verts)
      {
        pass ("MLINE.num_verts [BS] %hu", num_verts);
      }
    else
      {
        fail ("MLINE.num_verts [BS] %hu != %hu", mline->num_verts, num_verts);
        error++;
      }
    num_verts++;
    if (dwg_dynapi_entity_set_value (mline, "MLINE", "num_verts", &num_verts)
        && num_verts == mline->num_verts)
      {
        pass ("MLINE.num_verts [BS] set+1 %hu", num_verts);
      }
    else
      {
        fail ("MLINE.num_verts [BS] set+1 %hu != %hu", mline->num_verts, num_verts);
        error++;
      }
    mline->num_verts--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(mline, "MLINE", "parent", &parent, NULL)
        && !memcmp (&parent, &mline->parent, sizeof (mline->parent)))
      {
        pass ("MLINE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("MLINE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_BD scale;
    if (dwg_dynapi_entity_value(mline, "MLINE", "scale", &scale, NULL)
        && scale == mline->scale)
      {
        pass ("MLINE.scale [BD] %g", scale);
      }
    else
      {
        fail ("MLINE.scale [BD] %g != %g", mline->scale, scale);
        error++;
      }
    scale++;
    if (dwg_dynapi_entity_set_value (mline, "MLINE", "scale", &scale)
        && scale == mline->scale)
      {
        pass ("MLINE.scale [BD] set+1 %g", scale);
      }
    else
      {
        fail ("MLINE.scale [BD] set+1 %g != %g", mline->scale, scale);
        error++;
      }
    mline->scale--;

  }
  {
    Dwg_MLINE_vertex* verts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mline, "MLINE", "num_verts", &count, NULL)
        && dwg_dynapi_entity_value (mline, "MLINE", "verts", &verts, NULL)
        && verts == mline->verts)
      {
        pass ("MLINE.verts [Dwg_MLINE_vertex*] * %u num_verts", count);
      }
    else
      {
        fail ("MLINE.verts [Dwg_MLINE_vertex*] * %u num_verts", count);
        error++;
      }
  }
  return error;
}
static int test_MTEXT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_MTEXT *restrict mtext = obj->tio.entity->tio.MTEXT;
  {
    BITCODE_B annotative;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "annotative", &annotative, NULL)
        && annotative == mtext->annotative)
      {
        pass ("MTEXT.annotative [B] " FORMAT_B "", annotative);
      }
    else
      {
        fail ("MTEXT.annotative [B] " FORMAT_B " != " FORMAT_B "", mtext->annotative, annotative);
        error++;
      }
    annotative++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "annotative", &annotative)
        && annotative == mtext->annotative)
      {
        pass ("MTEXT.annotative [B] set+1 " FORMAT_B "", annotative);
      }
    else
      {
        fail ("MTEXT.annotative [B] set+1 " FORMAT_B " != " FORMAT_B "", mtext->annotative, annotative);
        error++;
      }
    mtext->annotative--;

  }
  {
    BITCODE_H appid;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "appid", &appid, NULL)
        && !memcmp (&appid, &mtext->appid, sizeof (mtext->appid)))
      {
        pass ("MTEXT.appid [H]");
      }
    else
      {
        fail ("MTEXT.appid [H]");
        error++;
      }
  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "attachment", &attachment, NULL)
        && attachment == mtext->attachment)
      {
        pass ("MTEXT.attachment [BS] %hu", attachment);
      }
    else
      {
        fail ("MTEXT.attachment [BS] %hu != %hu", mtext->attachment, attachment);
        error++;
      }
    attachment++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "attachment", &attachment)
        && attachment == mtext->attachment)
      {
        pass ("MTEXT.attachment [BS] set+1 %hu", attachment);
      }
    else
      {
        fail ("MTEXT.attachment [BS] set+1 %hu != %hu", mtext->attachment, attachment);
        error++;
      }
    mtext->attachment--;

  }
  {
    BITCODE_B auto_height;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "auto_height", &auto_height, NULL)
        && auto_height == mtext->auto_height)
      {
        pass ("MTEXT.auto_height [B] " FORMAT_B "", auto_height);
      }
    else
      {
        fail ("MTEXT.auto_height [B] " FORMAT_B " != " FORMAT_B "", mtext->auto_height, auto_height);
        error++;
      }
    auto_height++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "auto_height", &auto_height)
        && auto_height == mtext->auto_height)
      {
        pass ("MTEXT.auto_height [B] set+1 " FORMAT_B "", auto_height);
      }
    else
      {
        fail ("MTEXT.auto_height [B] set+1 " FORMAT_B " != " FORMAT_B "", mtext->auto_height, auto_height);
        error++;
      }
    mtext->auto_height--;

  }
  {
    BITCODE_CMC bg_fill_color;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "bg_fill_color", &bg_fill_color, NULL)
        && !memcmp (&bg_fill_color, &mtext->bg_fill_color, sizeof (mtext->bg_fill_color)))
      {
        pass ("MTEXT.bg_fill_color [CMC]");
      }
    else
      {
        fail ("MTEXT.bg_fill_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BL bg_fill_flag;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "bg_fill_flag", &bg_fill_flag, NULL)
        && bg_fill_flag == mtext->bg_fill_flag)
      {
        pass ("MTEXT.bg_fill_flag [BL] %u", bg_fill_flag);
      }
    else
      {
        fail ("MTEXT.bg_fill_flag [BL] %u != %u", mtext->bg_fill_flag, bg_fill_flag);
        error++;
      }
    bg_fill_flag++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "bg_fill_flag", &bg_fill_flag)
        && bg_fill_flag == mtext->bg_fill_flag)
      {
        pass ("MTEXT.bg_fill_flag [BL] set+1 %u", bg_fill_flag);
      }
    else
      {
        fail ("MTEXT.bg_fill_flag [BL] set+1 %u != %u", mtext->bg_fill_flag, bg_fill_flag);
        error++;
      }
    mtext->bg_fill_flag--;

  }
  {
    BITCODE_BL bg_fill_scale;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "bg_fill_scale", &bg_fill_scale, NULL)
        && bg_fill_scale == mtext->bg_fill_scale)
      {
        pass ("MTEXT.bg_fill_scale [BL] %u", bg_fill_scale);
      }
    else
      {
        fail ("MTEXT.bg_fill_scale [BL] %u != %u", mtext->bg_fill_scale, bg_fill_scale);
        error++;
      }
    bg_fill_scale++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "bg_fill_scale", &bg_fill_scale)
        && bg_fill_scale == mtext->bg_fill_scale)
      {
        pass ("MTEXT.bg_fill_scale [BL] set+1 %u", bg_fill_scale);
      }
    else
      {
        fail ("MTEXT.bg_fill_scale [BL] set+1 %u != %u", mtext->bg_fill_scale, bg_fill_scale);
        error++;
      }
    mtext->bg_fill_scale--;

  }
  {
    BITCODE_BL bg_fill_trans;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "bg_fill_trans", &bg_fill_trans, NULL)
        && bg_fill_trans == mtext->bg_fill_trans)
      {
        pass ("MTEXT.bg_fill_trans [BL] %u", bg_fill_trans);
      }
    else
      {
        fail ("MTEXT.bg_fill_trans [BL] %u != %u", mtext->bg_fill_trans, bg_fill_trans);
        error++;
      }
    bg_fill_trans++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "bg_fill_trans", &bg_fill_trans)
        && bg_fill_trans == mtext->bg_fill_trans)
      {
        pass ("MTEXT.bg_fill_trans [BL] set+1 %u", bg_fill_trans);
      }
    else
      {
        fail ("MTEXT.bg_fill_trans [BL] set+1 %u != %u", mtext->bg_fill_trans, bg_fill_trans);
        error++;
      }
    mtext->bg_fill_trans--;

  }
  {
    BITCODE_BS class_version;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "class_version", &class_version, NULL)
        && class_version == mtext->class_version)
      {
        pass ("MTEXT.class_version [BS] %hu", class_version);
      }
    else
      {
        fail ("MTEXT.class_version [BS] %hu != %hu", mtext->class_version, class_version);
        error++;
      }
    class_version++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "class_version", &class_version)
        && class_version == mtext->class_version)
      {
        pass ("MTEXT.class_version [BS] set+1 %hu", class_version);
      }
    else
      {
        fail ("MTEXT.class_version [BS] set+1 %hu != %hu", mtext->class_version, class_version);
        error++;
      }
    mtext->class_version--;

  }
  {
    BITCODE_BD* column_heights;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "num_column_heights", &count, NULL)
        && dwg_dynapi_entity_value (mtext, "MTEXT", "column_heights", &column_heights, NULL)
        && column_heights == mtext->column_heights)
      {
        pass ("MTEXT.column_heights [BD*] * %u num_column_heights", count);
      }
    else
      {
        fail ("MTEXT.column_heights [BD*] * %u num_column_heights", count);
        error++;
      }
  }
  {
    BITCODE_BL column_type;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "column_type", &column_type, NULL)
        && column_type == mtext->column_type)
      {
        pass ("MTEXT.column_type [BL] %u", column_type);
      }
    else
      {
        fail ("MTEXT.column_type [BL] %u != %u", mtext->column_type, column_type);
        error++;
      }
    column_type++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "column_type", &column_type)
        && column_type == mtext->column_type)
      {
        pass ("MTEXT.column_type [BL] set+1 %u", column_type);
      }
    else
      {
        fail ("MTEXT.column_type [BL] set+1 %u != %u", mtext->column_type, column_type);
        error++;
      }
    mtext->column_type--;

  }
  {
    BITCODE_BD column_width;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "column_width", &column_width, NULL)
        && column_width == mtext->column_width)
      {
        pass ("MTEXT.column_width [BD] %g", column_width);
      }
    else
      {
        fail ("MTEXT.column_width [BD] %g != %g", mtext->column_width, column_width);
        error++;
      }
    column_width++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "column_width", &column_width)
        && column_width == mtext->column_width)
      {
        pass ("MTEXT.column_width [BD] set+1 %g", column_width);
      }
    else
      {
        fail ("MTEXT.column_width [BD] set+1 %g != %g", mtext->column_width, column_width);
        error++;
      }
    mtext->column_width--;

  }
  {
    BITCODE_B default_flag;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "default_flag", &default_flag, NULL)
        && default_flag == mtext->default_flag)
      {
        pass ("MTEXT.default_flag [B] " FORMAT_B "", default_flag);
      }
    else
      {
        fail ("MTEXT.default_flag [B] " FORMAT_B " != " FORMAT_B "", mtext->default_flag, default_flag);
        error++;
      }
    default_flag++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "default_flag", &default_flag)
        && default_flag == mtext->default_flag)
      {
        pass ("MTEXT.default_flag [B] set+1 " FORMAT_B "", default_flag);
      }
    else
      {
        fail ("MTEXT.default_flag [B] set+1 " FORMAT_B " != " FORMAT_B "", mtext->default_flag, default_flag);
        error++;
      }
    mtext->default_flag--;

  }
  {
    BITCODE_BS drawing_dir;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "drawing_dir", &drawing_dir, NULL)
        && drawing_dir == mtext->drawing_dir)
      {
        pass ("MTEXT.drawing_dir [BS] %hu", drawing_dir);
      }
    else
      {
        fail ("MTEXT.drawing_dir [BS] %hu != %hu", mtext->drawing_dir, drawing_dir);
        error++;
      }
    drawing_dir++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "drawing_dir", &drawing_dir)
        && drawing_dir == mtext->drawing_dir)
      {
        pass ("MTEXT.drawing_dir [BS] set+1 %hu", drawing_dir);
      }
    else
      {
        fail ("MTEXT.drawing_dir [BS] set+1 %hu != %hu", mtext->drawing_dir, drawing_dir);
        error++;
      }
    mtext->drawing_dir--;

  }
  {
    BITCODE_BD extents_height;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "extents_height", &extents_height, NULL)
        && extents_height == mtext->extents_height)
      {
        pass ("MTEXT.extents_height [BD] %g", extents_height);
      }
    else
      {
        fail ("MTEXT.extents_height [BD] %g != %g", mtext->extents_height, extents_height);
        error++;
      }
    extents_height++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "extents_height", &extents_height)
        && extents_height == mtext->extents_height)
      {
        pass ("MTEXT.extents_height [BD] set+1 %g", extents_height);
      }
    else
      {
        fail ("MTEXT.extents_height [BD] set+1 %g != %g", mtext->extents_height, extents_height);
        error++;
      }
    mtext->extents_height--;

  }
  {
    BITCODE_BD extents_width;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "extents_width", &extents_width, NULL)
        && extents_width == mtext->extents_width)
      {
        pass ("MTEXT.extents_width [BD] %g", extents_width);
      }
    else
      {
        fail ("MTEXT.extents_width [BD] %g != %g", mtext->extents_width, extents_width);
        error++;
      }
    extents_width++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "extents_width", &extents_width)
        && extents_width == mtext->extents_width)
      {
        pass ("MTEXT.extents_width [BD] set+1 %g", extents_width);
      }
    else
      {
        fail ("MTEXT.extents_width [BD] set+1 %g != %g", mtext->extents_width, extents_width);
        error++;
      }
    mtext->extents_width--;

  }
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &mtext->extrusion, sizeof (mtext->extrusion)))
      {
        pass ("MTEXT.extrusion [3BD]");
      }
    else
      {
        fail ("MTEXT.extrusion [3BD]");
        error++;
      }
  }
  {
    BITCODE_B flow_reversed;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "flow_reversed", &flow_reversed, NULL)
        && flow_reversed == mtext->flow_reversed)
      {
        pass ("MTEXT.flow_reversed [B] " FORMAT_B "", flow_reversed);
      }
    else
      {
        fail ("MTEXT.flow_reversed [B] " FORMAT_B " != " FORMAT_B "", mtext->flow_reversed, flow_reversed);
        error++;
      }
    flow_reversed++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "flow_reversed", &flow_reversed)
        && flow_reversed == mtext->flow_reversed)
      {
        pass ("MTEXT.flow_reversed [B] set+1 " FORMAT_B "", flow_reversed);
      }
    else
      {
        fail ("MTEXT.flow_reversed [B] set+1 " FORMAT_B " != " FORMAT_B "", mtext->flow_reversed, flow_reversed);
        error++;
      }
    mtext->flow_reversed--;

  }
  {
    BITCODE_BD gutter;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "gutter", &gutter, NULL)
        && gutter == mtext->gutter)
      {
        pass ("MTEXT.gutter [BD] %g", gutter);
      }
    else
      {
        fail ("MTEXT.gutter [BD] %g != %g", mtext->gutter, gutter);
        error++;
      }
    gutter++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "gutter", &gutter)
        && gutter == mtext->gutter)
      {
        pass ("MTEXT.gutter [BD] set+1 %g", gutter);
      }
    else
      {
        fail ("MTEXT.gutter [BD] set+1 %g != %g", mtext->gutter, gutter);
        error++;
      }
    mtext->gutter--;

  }
  {
    BITCODE_3BD insertion_pt;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "insertion_pt", &insertion_pt, NULL)
        && !memcmp (&insertion_pt, &mtext->insertion_pt, sizeof (mtext->insertion_pt)))
      {
        pass ("MTEXT.insertion_pt [3BD]");
      }
    else
      {
        fail ("MTEXT.insertion_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD linespace_factor;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "linespace_factor", &linespace_factor, NULL)
        && linespace_factor == mtext->linespace_factor)
      {
        pass ("MTEXT.linespace_factor [BD] %g", linespace_factor);
      }
    else
      {
        fail ("MTEXT.linespace_factor [BD] %g != %g", mtext->linespace_factor, linespace_factor);
        error++;
      }
    linespace_factor++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "linespace_factor", &linespace_factor)
        && linespace_factor == mtext->linespace_factor)
      {
        pass ("MTEXT.linespace_factor [BD] set+1 %g", linespace_factor);
      }
    else
      {
        fail ("MTEXT.linespace_factor [BD] set+1 %g != %g", mtext->linespace_factor, linespace_factor);
        error++;
      }
    mtext->linespace_factor--;

  }
  {
    BITCODE_BS linespace_style;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "linespace_style", &linespace_style, NULL)
        && linespace_style == mtext->linespace_style)
      {
        pass ("MTEXT.linespace_style [BS] %hu", linespace_style);
      }
    else
      {
        fail ("MTEXT.linespace_style [BS] %hu != %hu", mtext->linespace_style, linespace_style);
        error++;
      }
    linespace_style++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "linespace_style", &linespace_style)
        && linespace_style == mtext->linespace_style)
      {
        pass ("MTEXT.linespace_style [BS] set+1 %hu", linespace_style);
      }
    else
      {
        fail ("MTEXT.linespace_style [BS] set+1 %hu != %hu", mtext->linespace_style, linespace_style);
        error++;
      }
    mtext->linespace_style--;

  }
  {
    BITCODE_BL num_column_heights;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "num_column_heights", &num_column_heights, NULL)
        && num_column_heights == mtext->num_column_heights)
      {
        pass ("MTEXT.num_column_heights [BL] %u", num_column_heights);
      }
    else
      {
        fail ("MTEXT.num_column_heights [BL] %u != %u", mtext->num_column_heights, num_column_heights);
        error++;
      }
    num_column_heights++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "num_column_heights", &num_column_heights)
        && num_column_heights == mtext->num_column_heights)
      {
        pass ("MTEXT.num_column_heights [BL] set+1 %u", num_column_heights);
      }
    else
      {
        fail ("MTEXT.num_column_heights [BL] set+1 %u != %u", mtext->num_column_heights, num_column_heights);
        error++;
      }
    mtext->num_column_heights--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "parent", &parent, NULL)
        && !memcmp (&parent, &mtext->parent, sizeof (mtext->parent)))
      {
        pass ("MTEXT.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("MTEXT.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_BD rect_height;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "rect_height", &rect_height, NULL)
        && rect_height == mtext->rect_height)
      {
        pass ("MTEXT.rect_height [BD] %g", rect_height);
      }
    else
      {
        fail ("MTEXT.rect_height [BD] %g != %g", mtext->rect_height, rect_height);
        error++;
      }
    rect_height++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "rect_height", &rect_height)
        && rect_height == mtext->rect_height)
      {
        pass ("MTEXT.rect_height [BD] set+1 %g", rect_height);
      }
    else
      {
        fail ("MTEXT.rect_height [BD] set+1 %g != %g", mtext->rect_height, rect_height);
        error++;
      }
    mtext->rect_height--;

  }
  {
    BITCODE_BD rect_width;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "rect_width", &rect_width, NULL)
        && rect_width == mtext->rect_width)
      {
        pass ("MTEXT.rect_width [BD] %g", rect_width);
      }
    else
      {
        fail ("MTEXT.rect_width [BD] %g != %g", mtext->rect_width, rect_width);
        error++;
      }
    rect_width++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "rect_width", &rect_width)
        && rect_width == mtext->rect_width)
      {
        pass ("MTEXT.rect_width [BD] set+1 %g", rect_width);
      }
    else
      {
        fail ("MTEXT.rect_width [BD] set+1 %g != %g", mtext->rect_width, rect_width);
        error++;
      }
    mtext->rect_width--;

  }
  {
    BITCODE_H style;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "style", &style, NULL)
        && !memcmp (&style, &mtext->style, sizeof (mtext->style)))
      {
        pass ("MTEXT.style [H]");
      }
    else
      {
        fail ("MTEXT.style [H]");
        error++;
      }
  }
  {
    BITCODE_TV text;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "text", &text, NULL)
        && !strcmp ((char *)text, (char *)mtext->text))
      {
        pass ("MTEXT.text [TV] '%s' <> '%s'", text, mtext->text);
      }
    else
      {
        fail ("MTEXT.text [TV] '%s' <> '%s'", text, mtext->text);
        error++;
      }
  }
  {
    BITCODE_BD text_height;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "text_height", &text_height, NULL)
        && text_height == mtext->text_height)
      {
        pass ("MTEXT.text_height [BD] %g", text_height);
      }
    else
      {
        fail ("MTEXT.text_height [BD] %g != %g", mtext->text_height, text_height);
        error++;
      }
    text_height++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "text_height", &text_height)
        && text_height == mtext->text_height)
      {
        pass ("MTEXT.text_height [BD] set+1 %g", text_height);
      }
    else
      {
        fail ("MTEXT.text_height [BD] set+1 %g != %g", mtext->text_height, text_height);
        error++;
      }
    mtext->text_height--;

  }
  {
    BITCODE_B unknown_bit;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "unknown_bit", &unknown_bit, NULL)
        && unknown_bit == mtext->unknown_bit)
      {
        pass ("MTEXT.unknown_bit [B] " FORMAT_B "", unknown_bit);
      }
    else
      {
        fail ("MTEXT.unknown_bit [B] " FORMAT_B " != " FORMAT_B "", mtext->unknown_bit, unknown_bit);
        error++;
      }
    unknown_bit++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "unknown_bit", &unknown_bit)
        && unknown_bit == mtext->unknown_bit)
      {
        pass ("MTEXT.unknown_bit [B] set+1 " FORMAT_B "", unknown_bit);
      }
    else
      {
        fail ("MTEXT.unknown_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", mtext->unknown_bit, unknown_bit);
        error++;
      }
    mtext->unknown_bit--;

  }
  {
    BITCODE_3BD x_axis_dir;
    if (dwg_dynapi_entity_value(mtext, "MTEXT", "x_axis_dir", &x_axis_dir, NULL)
        && !memcmp (&x_axis_dir, &mtext->x_axis_dir, sizeof (mtext->x_axis_dir)))
      {
        pass ("MTEXT.x_axis_dir [3BD]");
      }
    else
      {
        fail ("MTEXT.x_axis_dir [3BD]");
        error++;
      }
  }
  return error;
}
static int test_MULTILEADER (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_MULTILEADER *restrict multileader = obj->tio.entity->tio.MULTILEADER;
  {
    BITCODE_H arrow_handle;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "arrow_handle", &arrow_handle, NULL)
        && !memcmp (&arrow_handle, &multileader->arrow_handle, sizeof (multileader->arrow_handle)))
      {
        pass ("MULTILEADER.arrow_handle [H]");
      }
    else
      {
        fail ("MULTILEADER.arrow_handle [H]");
        error++;
      }
  }
  {
    BITCODE_BD arrow_size;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "arrow_size", &arrow_size, NULL)
        && arrow_size == multileader->arrow_size)
      {
        pass ("MULTILEADER.arrow_size [BD] %g", arrow_size);
      }
    else
      {
        fail ("MULTILEADER.arrow_size [BD] %g != %g", multileader->arrow_size, arrow_size);
        error++;
      }
    arrow_size++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "arrow_size", &arrow_size)
        && arrow_size == multileader->arrow_size)
      {
        pass ("MULTILEADER.arrow_size [BD] set+1 %g", arrow_size);
      }
    else
      {
        fail ("MULTILEADER.arrow_size [BD] set+1 %g != %g", multileader->arrow_size, arrow_size);
        error++;
      }
    multileader->arrow_size--;

  }
  {
    Dwg_LEADER_ArrowHead* arrowheads;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "num_arrowheads", &count, NULL)
        && dwg_dynapi_entity_value (multileader, "MULTILEADER", "arrowheads", &arrowheads, NULL)
        && arrowheads == multileader->arrowheads)
      {
        pass ("MULTILEADER.arrowheads [Dwg_LEADER_ArrowHead*] * %u num_arrowheads", count);
      }
    else
      {
        fail ("MULTILEADER.arrowheads [Dwg_LEADER_ArrowHead*] * %u num_arrowheads", count);
        error++;
      }
  }
  {
    BITCODE_BS attach_bottom;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "attach_bottom", &attach_bottom, NULL)
        && attach_bottom == multileader->attach_bottom)
      {
        pass ("MULTILEADER.attach_bottom [BS] %hu", attach_bottom);
      }
    else
      {
        fail ("MULTILEADER.attach_bottom [BS] %hu != %hu", multileader->attach_bottom, attach_bottom);
        error++;
      }
    attach_bottom++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "attach_bottom", &attach_bottom)
        && attach_bottom == multileader->attach_bottom)
      {
        pass ("MULTILEADER.attach_bottom [BS] set+1 %hu", attach_bottom);
      }
    else
      {
        fail ("MULTILEADER.attach_bottom [BS] set+1 %hu != %hu", multileader->attach_bottom, attach_bottom);
        error++;
      }
    multileader->attach_bottom--;

  }
  {
    BITCODE_BS attach_dir;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "attach_dir", &attach_dir, NULL)
        && attach_dir == multileader->attach_dir)
      {
        pass ("MULTILEADER.attach_dir [BS] %hu", attach_dir);
      }
    else
      {
        fail ("MULTILEADER.attach_dir [BS] %hu != %hu", multileader->attach_dir, attach_dir);
        error++;
      }
    attach_dir++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "attach_dir", &attach_dir)
        && attach_dir == multileader->attach_dir)
      {
        pass ("MULTILEADER.attach_dir [BS] set+1 %hu", attach_dir);
      }
    else
      {
        fail ("MULTILEADER.attach_dir [BS] set+1 %hu != %hu", multileader->attach_dir, attach_dir);
        error++;
      }
    multileader->attach_dir--;

  }
  {
    BITCODE_BS attach_top;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "attach_top", &attach_top, NULL)
        && attach_top == multileader->attach_top)
      {
        pass ("MULTILEADER.attach_top [BS] %hu", attach_top);
      }
    else
      {
        fail ("MULTILEADER.attach_top [BS] %hu != %hu", multileader->attach_top, attach_top);
        error++;
      }
    attach_top++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "attach_top", &attach_top)
        && attach_top == multileader->attach_top)
      {
        pass ("MULTILEADER.attach_top [BS] set+1 %hu", attach_top);
      }
    else
      {
        fail ("MULTILEADER.attach_top [BS] set+1 %hu != %hu", multileader->attach_top, attach_top);
        error++;
      }
    multileader->attach_top--;

  }
  {
    BITCODE_BS attach_type;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "attach_type", &attach_type, NULL)
        && attach_type == multileader->attach_type)
      {
        pass ("MULTILEADER.attach_type [BS] %hu", attach_type);
      }
    else
      {
        fail ("MULTILEADER.attach_type [BS] %hu != %hu", multileader->attach_type, attach_type);
        error++;
      }
    attach_type++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "attach_type", &attach_type)
        && attach_type == multileader->attach_type)
      {
        pass ("MULTILEADER.attach_type [BS] set+1 %hu", attach_type);
      }
    else
      {
        fail ("MULTILEADER.attach_type [BS] set+1 %hu != %hu", multileader->attach_type, attach_type);
        error++;
      }
    multileader->attach_type--;

  }
  {
    BITCODE_CMC block_color;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "block_color", &block_color, NULL)
        && !memcmp (&block_color, &multileader->block_color, sizeof (multileader->block_color)))
      {
        pass ("MULTILEADER.block_color [CMC]");
      }
    else
      {
        fail ("MULTILEADER.block_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BD block_rotation;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "block_rotation", &block_rotation, NULL)
        && block_rotation == multileader->block_rotation)
      {
        pass ("MULTILEADER.block_rotation [BD] %g", block_rotation);
      }
    else
      {
        fail ("MULTILEADER.block_rotation [BD] %g != %g", multileader->block_rotation, block_rotation);
        error++;
      }
    block_rotation++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "block_rotation", &block_rotation)
        && block_rotation == multileader->block_rotation)
      {
        pass ("MULTILEADER.block_rotation [BD] set+1 %g", block_rotation);
      }
    else
      {
        fail ("MULTILEADER.block_rotation [BD] set+1 %g != %g", multileader->block_rotation, block_rotation);
        error++;
      }
    multileader->block_rotation--;

  }
  {
    BITCODE_3BD block_scale;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "block_scale", &block_scale, NULL)
        && !memcmp (&block_scale, &multileader->block_scale, sizeof (multileader->block_scale)))
      {
        pass ("MULTILEADER.block_scale [3BD]");
      }
    else
      {
        fail ("MULTILEADER.block_scale [3BD]");
        error++;
      }
  }
  {
    BITCODE_H block_style;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "block_style", &block_style, NULL)
        && !memcmp (&block_style, &multileader->block_style, sizeof (multileader->block_style)))
      {
        pass ("MULTILEADER.block_style [H]");
      }
    else
      {
        fail ("MULTILEADER.block_style [H]");
        error++;
      }
  }
  {
    Dwg_LEADER_BlockLabel* blocklabels;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "num_blocklabels", &count, NULL)
        && dwg_dynapi_entity_value (multileader, "MULTILEADER", "blocklabels", &blocklabels, NULL)
        && blocklabels == multileader->blocklabels)
      {
        pass ("MULTILEADER.blocklabels [Dwg_LEADER_BlockLabel*] * %u num_blocklabels", count);
      }
    else
      {
        fail ("MULTILEADER.blocklabels [Dwg_LEADER_BlockLabel*] * %u num_blocklabels", count);
        error++;
      }
  }
  {
    BITCODE_BS class_version;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "class_version", &class_version, NULL)
        && class_version == multileader->class_version)
      {
        pass ("MULTILEADER.class_version [BS] %hu", class_version);
      }
    else
      {
        fail ("MULTILEADER.class_version [BS] %hu != %hu", multileader->class_version, class_version);
        error++;
      }
    class_version++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "class_version", &class_version)
        && class_version == multileader->class_version)
      {
        pass ("MULTILEADER.class_version [BS] set+1 %hu", class_version);
      }
    else
      {
        fail ("MULTILEADER.class_version [BS] set+1 %hu != %hu", multileader->class_version, class_version);
        error++;
      }
    multileader->class_version--;

  }
  {
    BITCODE_CMC color;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "color", &color, NULL)
        && !memcmp (&color, &multileader->color, sizeof (multileader->color)))
      {
        pass ("MULTILEADER.color [CMC]");
      }
    else
      {
        fail ("MULTILEADER.color [CMC]");
        error++;
      }
  }
  {
    Dwg_MLEADER_AnnotContext ctx;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "ctx", &ctx, NULL)
        && !memcmp (&ctx, &multileader->ctx, sizeof (multileader->ctx)))
      {
        pass ("MULTILEADER.ctx [Dwg_MLEADER_AnnotContext]");
      }
    else
      {
        fail ("MULTILEADER.ctx [Dwg_MLEADER_AnnotContext]");
        error++;
      }
  }
  {
    BITCODE_BL flags;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "flags", &flags, NULL)
        && flags == multileader->flags)
      {
        pass ("MULTILEADER.flags [BL] %u", flags);
      }
    else
      {
        fail ("MULTILEADER.flags [BL] %u != %u", multileader->flags, flags);
        error++;
      }
    flags++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "flags", &flags)
        && flags == multileader->flags)
      {
        pass ("MULTILEADER.flags [BL] set+1 %u", flags);
      }
    else
      {
        fail ("MULTILEADER.flags [BL] set+1 %u != %u", multileader->flags, flags);
        error++;
      }
    multileader->flags--;

  }
  {
    BITCODE_B has_dogleg;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "has_dogleg", &has_dogleg, NULL)
        && has_dogleg == multileader->has_dogleg)
      {
        pass ("MULTILEADER.has_dogleg [B] " FORMAT_B "", has_dogleg);
      }
    else
      {
        fail ("MULTILEADER.has_dogleg [B] " FORMAT_B " != " FORMAT_B "", multileader->has_dogleg, has_dogleg);
        error++;
      }
    has_dogleg++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "has_dogleg", &has_dogleg)
        && has_dogleg == multileader->has_dogleg)
      {
        pass ("MULTILEADER.has_dogleg [B] set+1 " FORMAT_B "", has_dogleg);
      }
    else
      {
        fail ("MULTILEADER.has_dogleg [B] set+1 " FORMAT_B " != " FORMAT_B "", multileader->has_dogleg, has_dogleg);
        error++;
      }
    multileader->has_dogleg--;

  }
  {
    BITCODE_B has_landing;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "has_landing", &has_landing, NULL)
        && has_landing == multileader->has_landing)
      {
        pass ("MULTILEADER.has_landing [B] " FORMAT_B "", has_landing);
      }
    else
      {
        fail ("MULTILEADER.has_landing [B] " FORMAT_B " != " FORMAT_B "", multileader->has_landing, has_landing);
        error++;
      }
    has_landing++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "has_landing", &has_landing)
        && has_landing == multileader->has_landing)
      {
        pass ("MULTILEADER.has_landing [B] set+1 " FORMAT_B "", has_landing);
      }
    else
      {
        fail ("MULTILEADER.has_landing [B] set+1 " FORMAT_B " != " FORMAT_B "", multileader->has_landing, has_landing);
        error++;
      }
    multileader->has_landing--;

  }
  {
    BITCODE_B has_text_frame;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "has_text_frame", &has_text_frame, NULL)
        && has_text_frame == multileader->has_text_frame)
      {
        pass ("MULTILEADER.has_text_frame [B] " FORMAT_B "", has_text_frame);
      }
    else
      {
        fail ("MULTILEADER.has_text_frame [B] " FORMAT_B " != " FORMAT_B "", multileader->has_text_frame, has_text_frame);
        error++;
      }
    has_text_frame++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "has_text_frame", &has_text_frame)
        && has_text_frame == multileader->has_text_frame)
      {
        pass ("MULTILEADER.has_text_frame [B] set+1 " FORMAT_B "", has_text_frame);
      }
    else
      {
        fail ("MULTILEADER.has_text_frame [B] set+1 " FORMAT_B " != " FORMAT_B "", multileader->has_text_frame, has_text_frame);
        error++;
      }
    multileader->has_text_frame--;

  }
  {
    BITCODE_BS ipe_alignment;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "ipe_alignment", &ipe_alignment, NULL)
        && ipe_alignment == multileader->ipe_alignment)
      {
        pass ("MULTILEADER.ipe_alignment [BS] %hu", ipe_alignment);
      }
    else
      {
        fail ("MULTILEADER.ipe_alignment [BS] %hu != %hu", multileader->ipe_alignment, ipe_alignment);
        error++;
      }
    ipe_alignment++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "ipe_alignment", &ipe_alignment)
        && ipe_alignment == multileader->ipe_alignment)
      {
        pass ("MULTILEADER.ipe_alignment [BS] set+1 %hu", ipe_alignment);
      }
    else
      {
        fail ("MULTILEADER.ipe_alignment [BS] set+1 %hu != %hu", multileader->ipe_alignment, ipe_alignment);
        error++;
      }
    multileader->ipe_alignment--;

  }
  {
    BITCODE_B is_annotative;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "is_annotative", &is_annotative, NULL)
        && is_annotative == multileader->is_annotative)
      {
        pass ("MULTILEADER.is_annotative [B] " FORMAT_B "", is_annotative);
      }
    else
      {
        fail ("MULTILEADER.is_annotative [B] " FORMAT_B " != " FORMAT_B "", multileader->is_annotative, is_annotative);
        error++;
      }
    is_annotative++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "is_annotative", &is_annotative)
        && is_annotative == multileader->is_annotative)
      {
        pass ("MULTILEADER.is_annotative [B] set+1 " FORMAT_B "", is_annotative);
      }
    else
      {
        fail ("MULTILEADER.is_annotative [B] set+1 " FORMAT_B " != " FORMAT_B "", multileader->is_annotative, is_annotative);
        error++;
      }
    multileader->is_annotative--;

  }
  {
    BITCODE_BS justification;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "justification", &justification, NULL)
        && justification == multileader->justification)
      {
        pass ("MULTILEADER.justification [BS] %hu", justification);
      }
    else
      {
        fail ("MULTILEADER.justification [BS] %hu != %hu", multileader->justification, justification);
        error++;
      }
    justification++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "justification", &justification)
        && justification == multileader->justification)
      {
        pass ("MULTILEADER.justification [BS] set+1 %hu", justification);
      }
    else
      {
        fail ("MULTILEADER.justification [BS] set+1 %hu != %hu", multileader->justification, justification);
        error++;
      }
    multileader->justification--;

  }
  {
    BITCODE_BD landing_dist;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "landing_dist", &landing_dist, NULL)
        && landing_dist == multileader->landing_dist)
      {
        pass ("MULTILEADER.landing_dist [BD] %g", landing_dist);
      }
    else
      {
        fail ("MULTILEADER.landing_dist [BD] %g != %g", multileader->landing_dist, landing_dist);
        error++;
      }
    landing_dist++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "landing_dist", &landing_dist)
        && landing_dist == multileader->landing_dist)
      {
        pass ("MULTILEADER.landing_dist [BD] set+1 %g", landing_dist);
      }
    else
      {
        fail ("MULTILEADER.landing_dist [BD] set+1 %g != %g", multileader->landing_dist, landing_dist);
        error++;
      }
    multileader->landing_dist--;

  }
  {
    BITCODE_BL linewt;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "linewt", &linewt, NULL)
        && linewt == multileader->linewt)
      {
        pass ("MULTILEADER.linewt [BL] %u", linewt);
      }
    else
      {
        fail ("MULTILEADER.linewt [BL] %u != %u", multileader->linewt, linewt);
        error++;
      }
    linewt++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "linewt", &linewt)
        && linewt == multileader->linewt)
      {
        pass ("MULTILEADER.linewt [BL] set+1 %u", linewt);
      }
    else
      {
        fail ("MULTILEADER.linewt [BL] set+1 %u != %u", multileader->linewt, linewt);
        error++;
      }
    multileader->linewt--;

  }
  {
    BITCODE_H ltype;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "ltype", &ltype, NULL)
        && !memcmp (&ltype, &multileader->ltype, sizeof (multileader->ltype)))
      {
        pass ("MULTILEADER.ltype [H]");
      }
    else
      {
        fail ("MULTILEADER.ltype [H]");
        error++;
      }
  }
  {
    BITCODE_H mleaderstyle;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "mleaderstyle", &mleaderstyle, NULL)
        && !memcmp (&mleaderstyle, &multileader->mleaderstyle, sizeof (multileader->mleaderstyle)))
      {
        pass ("MULTILEADER.mleaderstyle [H]");
      }
    else
      {
        fail ("MULTILEADER.mleaderstyle [H]");
        error++;
      }
  }
  {
    BITCODE_B neg_textdir;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "neg_textdir", &neg_textdir, NULL)
        && neg_textdir == multileader->neg_textdir)
      {
        pass ("MULTILEADER.neg_textdir [B] " FORMAT_B "", neg_textdir);
      }
    else
      {
        fail ("MULTILEADER.neg_textdir [B] " FORMAT_B " != " FORMAT_B "", multileader->neg_textdir, neg_textdir);
        error++;
      }
    neg_textdir++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "neg_textdir", &neg_textdir)
        && neg_textdir == multileader->neg_textdir)
      {
        pass ("MULTILEADER.neg_textdir [B] set+1 " FORMAT_B "", neg_textdir);
      }
    else
      {
        fail ("MULTILEADER.neg_textdir [B] set+1 " FORMAT_B " != " FORMAT_B "", multileader->neg_textdir, neg_textdir);
        error++;
      }
    multileader->neg_textdir--;

  }
  {
    BITCODE_BL num_arrowheads;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "num_arrowheads", &num_arrowheads, NULL)
        && num_arrowheads == multileader->num_arrowheads)
      {
        pass ("MULTILEADER.num_arrowheads [BL] %u", num_arrowheads);
      }
    else
      {
        fail ("MULTILEADER.num_arrowheads [BL] %u != %u", multileader->num_arrowheads, num_arrowheads);
        error++;
      }
    num_arrowheads++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "num_arrowheads", &num_arrowheads)
        && num_arrowheads == multileader->num_arrowheads)
      {
        pass ("MULTILEADER.num_arrowheads [BL] set+1 %u", num_arrowheads);
      }
    else
      {
        fail ("MULTILEADER.num_arrowheads [BL] set+1 %u != %u", multileader->num_arrowheads, num_arrowheads);
        error++;
      }
    multileader->num_arrowheads--;

  }
  {
    BITCODE_BL num_blocklabels;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "num_blocklabels", &num_blocklabels, NULL)
        && num_blocklabels == multileader->num_blocklabels)
      {
        pass ("MULTILEADER.num_blocklabels [BL] %u", num_blocklabels);
      }
    else
      {
        fail ("MULTILEADER.num_blocklabels [BL] %u != %u", multileader->num_blocklabels, num_blocklabels);
        error++;
      }
    num_blocklabels++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "num_blocklabels", &num_blocklabels)
        && num_blocklabels == multileader->num_blocklabels)
      {
        pass ("MULTILEADER.num_blocklabels [BL] set+1 %u", num_blocklabels);
      }
    else
      {
        fail ("MULTILEADER.num_blocklabels [BL] set+1 %u != %u", multileader->num_blocklabels, num_blocklabels);
        error++;
      }
    multileader->num_blocklabels--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "parent", &parent, NULL)
        && !memcmp (&parent, &multileader->parent, sizeof (multileader->parent)))
      {
        pass ("MULTILEADER.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("MULTILEADER.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_BD scale_factor;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "scale_factor", &scale_factor, NULL)
        && scale_factor == multileader->scale_factor)
      {
        pass ("MULTILEADER.scale_factor [BD] %g", scale_factor);
      }
    else
      {
        fail ("MULTILEADER.scale_factor [BD] %g != %g", multileader->scale_factor, scale_factor);
        error++;
      }
    scale_factor++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "scale_factor", &scale_factor)
        && scale_factor == multileader->scale_factor)
      {
        pass ("MULTILEADER.scale_factor [BD] set+1 %g", scale_factor);
      }
    else
      {
        fail ("MULTILEADER.scale_factor [BD] set+1 %g != %g", multileader->scale_factor, scale_factor);
        error++;
      }
    multileader->scale_factor--;

  }
  {
    BITCODE_BS style_attachment;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "style_attachment", &style_attachment, NULL)
        && style_attachment == multileader->style_attachment)
      {
        pass ("MULTILEADER.style_attachment [BS] %hu", style_attachment);
      }
    else
      {
        fail ("MULTILEADER.style_attachment [BS] %hu != %hu", multileader->style_attachment, style_attachment);
        error++;
      }
    style_attachment++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "style_attachment", &style_attachment)
        && style_attachment == multileader->style_attachment)
      {
        pass ("MULTILEADER.style_attachment [BS] set+1 %hu", style_attachment);
      }
    else
      {
        fail ("MULTILEADER.style_attachment [BS] set+1 %hu != %hu", multileader->style_attachment, style_attachment);
        error++;
      }
    multileader->style_attachment--;

  }
  {
    BITCODE_BS style_content;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "style_content", &style_content, NULL)
        && style_content == multileader->style_content)
      {
        pass ("MULTILEADER.style_content [BS] %hu", style_content);
      }
    else
      {
        fail ("MULTILEADER.style_content [BS] %hu != %hu", multileader->style_content, style_content);
        error++;
      }
    style_content++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "style_content", &style_content)
        && style_content == multileader->style_content)
      {
        pass ("MULTILEADER.style_content [BS] set+1 %hu", style_content);
      }
    else
      {
        fail ("MULTILEADER.style_content [BS] set+1 %hu != %hu", multileader->style_content, style_content);
        error++;
      }
    multileader->style_content--;

  }
  {
    BITCODE_BS text_angletype;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "text_angletype", &text_angletype, NULL)
        && text_angletype == multileader->text_angletype)
      {
        pass ("MULTILEADER.text_angletype [BS] %hu", text_angletype);
      }
    else
      {
        fail ("MULTILEADER.text_angletype [BS] %hu != %hu", multileader->text_angletype, text_angletype);
        error++;
      }
    text_angletype++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "text_angletype", &text_angletype)
        && text_angletype == multileader->text_angletype)
      {
        pass ("MULTILEADER.text_angletype [BS] set+1 %hu", text_angletype);
      }
    else
      {
        fail ("MULTILEADER.text_angletype [BS] set+1 %hu != %hu", multileader->text_angletype, text_angletype);
        error++;
      }
    multileader->text_angletype--;

  }
  {
    BITCODE_CMC text_color;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "text_color", &text_color, NULL)
        && !memcmp (&text_color, &multileader->text_color, sizeof (multileader->text_color)))
      {
        pass ("MULTILEADER.text_color [CMC]");
      }
    else
      {
        fail ("MULTILEADER.text_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_B text_extended;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "text_extended", &text_extended, NULL)
        && text_extended == multileader->text_extended)
      {
        pass ("MULTILEADER.text_extended [B] " FORMAT_B "", text_extended);
      }
    else
      {
        fail ("MULTILEADER.text_extended [B] " FORMAT_B " != " FORMAT_B "", multileader->text_extended, text_extended);
        error++;
      }
    text_extended++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "text_extended", &text_extended)
        && text_extended == multileader->text_extended)
      {
        pass ("MULTILEADER.text_extended [B] set+1 " FORMAT_B "", text_extended);
      }
    else
      {
        fail ("MULTILEADER.text_extended [B] set+1 " FORMAT_B " != " FORMAT_B "", multileader->text_extended, text_extended);
        error++;
      }
    multileader->text_extended--;

  }
  {
    BITCODE_BS text_left;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "text_left", &text_left, NULL)
        && text_left == multileader->text_left)
      {
        pass ("MULTILEADER.text_left [BS] %hu", text_left);
      }
    else
      {
        fail ("MULTILEADER.text_left [BS] %hu != %hu", multileader->text_left, text_left);
        error++;
      }
    text_left++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "text_left", &text_left)
        && text_left == multileader->text_left)
      {
        pass ("MULTILEADER.text_left [BS] set+1 %hu", text_left);
      }
    else
      {
        fail ("MULTILEADER.text_left [BS] set+1 %hu != %hu", multileader->text_left, text_left);
        error++;
      }
    multileader->text_left--;

  }
  {
    BITCODE_BS text_right;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "text_right", &text_right, NULL)
        && text_right == multileader->text_right)
      {
        pass ("MULTILEADER.text_right [BS] %hu", text_right);
      }
    else
      {
        fail ("MULTILEADER.text_right [BS] %hu != %hu", multileader->text_right, text_right);
        error++;
      }
    text_right++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "text_right", &text_right)
        && text_right == multileader->text_right)
      {
        pass ("MULTILEADER.text_right [BS] set+1 %hu", text_right);
      }
    else
      {
        fail ("MULTILEADER.text_right [BS] set+1 %hu != %hu", multileader->text_right, text_right);
        error++;
      }
    multileader->text_right--;

  }
  {
    BITCODE_H text_style;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "text_style", &text_style, NULL)
        && !memcmp (&text_style, &multileader->text_style, sizeof (multileader->text_style)))
      {
        pass ("MULTILEADER.text_style [H]");
      }
    else
      {
        fail ("MULTILEADER.text_style [H]");
        error++;
      }
  }
  {
    BITCODE_BS type;
    if (dwg_dynapi_entity_value(multileader, "MULTILEADER", "type", &type, NULL)
        && type == multileader->type)
      {
        pass ("MULTILEADER.type [BS] %hu", type);
      }
    else
      {
        fail ("MULTILEADER.type [BS] %hu != %hu", multileader->type, type);
        error++;
      }
    type++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "type", &type)
        && type == multileader->type)
      {
        pass ("MULTILEADER.type [BS] set+1 %hu", type);
      }
    else
      {
        fail ("MULTILEADER.type [BS] set+1 %hu != %hu", multileader->type, type);
        error++;
      }
    multileader->type--;

  }
  return error;
}
static int test_OLE2FRAME (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_OLE2FRAME *restrict ole2frame = obj->tio.entity->tio.OLE2FRAME;
  {
    BITCODE_TV data;
    if (dwg_dynapi_entity_value(ole2frame, "OLE2FRAME", "data", &data, NULL)
        && !strcmp ((char *)data, (char *)ole2frame->data))
      {
        pass ("OLE2FRAME.data [TV] '%s' <> '%s'", data, ole2frame->data);
      }
    else
      {
        fail ("OLE2FRAME.data [TV] '%s' <> '%s'", data, ole2frame->data);
        error++;
      }
  }
  {
    BITCODE_BL data_length;
    if (dwg_dynapi_entity_value(ole2frame, "OLE2FRAME", "data_length", &data_length, NULL)
        && data_length == ole2frame->data_length)
      {
        pass ("OLE2FRAME.data_length [BL] %u", data_length);
      }
    else
      {
        fail ("OLE2FRAME.data_length [BL] %u != %u", ole2frame->data_length, data_length);
        error++;
      }
    data_length++;
    if (dwg_dynapi_entity_set_value (ole2frame, "OLE2FRAME", "data_length", &data_length)
        && data_length == ole2frame->data_length)
      {
        pass ("OLE2FRAME.data_length [BL] set+1 %u", data_length);
      }
    else
      {
        fail ("OLE2FRAME.data_length [BL] set+1 %u != %u", ole2frame->data_length, data_length);
        error++;
      }
    ole2frame->data_length--;

  }
  {
    BITCODE_BS flag;
    if (dwg_dynapi_entity_value(ole2frame, "OLE2FRAME", "flag", &flag, NULL)
        && flag == ole2frame->flag)
      {
        pass ("OLE2FRAME.flag [BS] %hu", flag);
      }
    else
      {
        fail ("OLE2FRAME.flag [BS] %hu != %hu", ole2frame->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (ole2frame, "OLE2FRAME", "flag", &flag)
        && flag == ole2frame->flag)
      {
        pass ("OLE2FRAME.flag [BS] set+1 %hu", flag);
      }
    else
      {
        fail ("OLE2FRAME.flag [BS] set+1 %hu != %hu", ole2frame->flag, flag);
        error++;
      }
    ole2frame->flag--;

  }
  {
    BITCODE_BS mode;
    if (dwg_dynapi_entity_value(ole2frame, "OLE2FRAME", "mode", &mode, NULL)
        && mode == ole2frame->mode)
      {
        pass ("OLE2FRAME.mode [BS] %hu", mode);
      }
    else
      {
        fail ("OLE2FRAME.mode [BS] %hu != %hu", ole2frame->mode, mode);
        error++;
      }
    mode++;
    if (dwg_dynapi_entity_set_value (ole2frame, "OLE2FRAME", "mode", &mode)
        && mode == ole2frame->mode)
      {
        pass ("OLE2FRAME.mode [BS] set+1 %hu", mode);
      }
    else
      {
        fail ("OLE2FRAME.mode [BS] set+1 %hu != %hu", ole2frame->mode, mode);
        error++;
      }
    ole2frame->mode--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(ole2frame, "OLE2FRAME", "parent", &parent, NULL)
        && !memcmp (&parent, &ole2frame->parent, sizeof (ole2frame->parent)))
      {
        pass ("OLE2FRAME.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("OLE2FRAME.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_RC unknown;
    if (dwg_dynapi_entity_value(ole2frame, "OLE2FRAME", "unknown", &unknown, NULL)
        && unknown == ole2frame->unknown)
      {
        pass ("OLE2FRAME.unknown [RC] %u", unknown);
      }
    else
      {
        fail ("OLE2FRAME.unknown [RC] %u != %u", ole2frame->unknown, unknown);
        error++;
      }
    unknown++;
    if (dwg_dynapi_entity_set_value (ole2frame, "OLE2FRAME", "unknown", &unknown)
        && unknown == ole2frame->unknown)
      {
        pass ("OLE2FRAME.unknown [RC] set+1 %u", unknown);
      }
    else
      {
        fail ("OLE2FRAME.unknown [RC] set+1 %u != %u", ole2frame->unknown, unknown);
        error++;
      }
    ole2frame->unknown--;

  }
  return error;
}
static int test_OLEFRAME (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_OLEFRAME *restrict oleframe = obj->tio.entity->tio.OLEFRAME;
  {
    BITCODE_TV data;
    if (dwg_dynapi_entity_value(oleframe, "OLEFRAME", "data", &data, NULL)
        && !strcmp ((char *)data, (char *)oleframe->data))
      {
        pass ("OLEFRAME.data [TV] '%s' <> '%s'", data, oleframe->data);
      }
    else
      {
        fail ("OLEFRAME.data [TV] '%s' <> '%s'", data, oleframe->data);
        error++;
      }
  }
  {
    BITCODE_BL data_length;
    if (dwg_dynapi_entity_value(oleframe, "OLEFRAME", "data_length", &data_length, NULL)
        && data_length == oleframe->data_length)
      {
        pass ("OLEFRAME.data_length [BL] %u", data_length);
      }
    else
      {
        fail ("OLEFRAME.data_length [BL] %u != %u", oleframe->data_length, data_length);
        error++;
      }
    data_length++;
    if (dwg_dynapi_entity_set_value (oleframe, "OLEFRAME", "data_length", &data_length)
        && data_length == oleframe->data_length)
      {
        pass ("OLEFRAME.data_length [BL] set+1 %u", data_length);
      }
    else
      {
        fail ("OLEFRAME.data_length [BL] set+1 %u != %u", oleframe->data_length, data_length);
        error++;
      }
    oleframe->data_length--;

  }
  {
    BITCODE_BS flag;
    if (dwg_dynapi_entity_value(oleframe, "OLEFRAME", "flag", &flag, NULL)
        && flag == oleframe->flag)
      {
        pass ("OLEFRAME.flag [BS] %hu", flag);
      }
    else
      {
        fail ("OLEFRAME.flag [BS] %hu != %hu", oleframe->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (oleframe, "OLEFRAME", "flag", &flag)
        && flag == oleframe->flag)
      {
        pass ("OLEFRAME.flag [BS] set+1 %hu", flag);
      }
    else
      {
        fail ("OLEFRAME.flag [BS] set+1 %hu != %hu", oleframe->flag, flag);
        error++;
      }
    oleframe->flag--;

  }
  {
    BITCODE_BS mode;
    if (dwg_dynapi_entity_value(oleframe, "OLEFRAME", "mode", &mode, NULL)
        && mode == oleframe->mode)
      {
        pass ("OLEFRAME.mode [BS] %hu", mode);
      }
    else
      {
        fail ("OLEFRAME.mode [BS] %hu != %hu", oleframe->mode, mode);
        error++;
      }
    mode++;
    if (dwg_dynapi_entity_set_value (oleframe, "OLEFRAME", "mode", &mode)
        && mode == oleframe->mode)
      {
        pass ("OLEFRAME.mode [BS] set+1 %hu", mode);
      }
    else
      {
        fail ("OLEFRAME.mode [BS] set+1 %hu != %hu", oleframe->mode, mode);
        error++;
      }
    oleframe->mode--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(oleframe, "OLEFRAME", "parent", &parent, NULL)
        && !memcmp (&parent, &oleframe->parent, sizeof (oleframe->parent)))
      {
        pass ("OLEFRAME.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("OLEFRAME.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  return error;
}
static int test_PLANESURFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_PLANESURFACE *restrict planesurface = obj->tio.entity->tio.PLANESURFACE;
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "acis_data", &acis_data, NULL)
        && !strcmp ((char *)acis_data, (char *)planesurface->acis_data))
      {
        pass ("PLANESURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, planesurface->acis_data);
      }
    else
      {
        fail ("PLANESURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, planesurface->acis_data);
        error++;
      }
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "acis_empty", &acis_empty, NULL)
        && acis_empty == planesurface->acis_empty)
      {
        pass ("PLANESURFACE.acis_empty [B] " FORMAT_B "", acis_empty);
      }
    else
      {
        fail ("PLANESURFACE.acis_empty [B] " FORMAT_B " != " FORMAT_B "", planesurface->acis_empty, acis_empty);
        error++;
      }
    acis_empty++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "acis_empty", &acis_empty)
        && acis_empty == planesurface->acis_empty)
      {
        pass ("PLANESURFACE.acis_empty [B] set+1 " FORMAT_B "", acis_empty);
      }
    else
      {
        fail ("PLANESURFACE.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->acis_empty, acis_empty);
        error++;
      }
    planesurface->acis_empty--;

  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == planesurface->acis_empty2)
      {
        pass ("PLANESURFACE.acis_empty2 [B] " FORMAT_B "", acis_empty2);
      }
    else
      {
        fail ("PLANESURFACE.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", planesurface->acis_empty2, acis_empty2);
        error++;
      }
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "acis_empty2", &acis_empty2)
        && acis_empty2 == planesurface->acis_empty2)
      {
        pass ("PLANESURFACE.acis_empty2 [B] set+1 " FORMAT_B "", acis_empty2);
      }
    else
      {
        fail ("PLANESURFACE.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->acis_empty2, acis_empty2);
        error++;
      }
    planesurface->acis_empty2--;

  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == planesurface->acis_empty_bit)
      {
        pass ("PLANESURFACE.acis_empty_bit [B] " FORMAT_B "", acis_empty_bit);
      }
    else
      {
        fail ("PLANESURFACE.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", planesurface->acis_empty_bit, acis_empty_bit);
        error++;
      }
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "acis_empty_bit", &acis_empty_bit)
        && acis_empty_bit == planesurface->acis_empty_bit)
      {
        pass ("PLANESURFACE.acis_empty_bit [B] set+1 " FORMAT_B "", acis_empty_bit);
      }
    else
      {
        fail ("PLANESURFACE.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->acis_empty_bit, acis_empty_bit);
        error++;
      }
    planesurface->acis_empty_bit--;

  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &planesurface->block_size, sizeof (planesurface->block_size)))
      {
        pass ("PLANESURFACE.block_size [BL*]");
      }
    else
      {
        fail ("PLANESURFACE.block_size [BL*]");
        error++;
      }
  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "class_version", &class_version, NULL)
        && class_version == planesurface->class_version)
      {
        pass ("PLANESURFACE.class_version [BL] %u", class_version);
      }
    else
      {
        fail ("PLANESURFACE.class_version [BL] %u != %u", planesurface->class_version, class_version);
        error++;
      }
    class_version++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "class_version", &class_version)
        && class_version == planesurface->class_version)
      {
        pass ("PLANESURFACE.class_version [BL] set+1 %u", class_version);
      }
    else
      {
        fail ("PLANESURFACE.class_version [BL] set+1 %u != %u", planesurface->class_version, class_version);
        error++;
      }
    planesurface->class_version--;

  }
  {
    char ** encr_sat_data;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "num_encr_sat_data", &count, NULL)
        && dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "encr_sat_data", &encr_sat_data, NULL)
)
      {
        pass ("PLANESURFACE.encr_sat_data [char **] * %u num_encr_sat_data", count);
      }
    else
      {
        fail ("PLANESURFACE.encr_sat_data [char **] * %u num_encr_sat_data", count);
        error++;
      }
  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &planesurface->extra_acis_data, sizeof (planesurface->extra_acis_data)))
      {
        pass ("PLANESURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
      }
    else
      {
        fail ("PLANESURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
        error++;
      }
  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &planesurface->history_id, sizeof (planesurface->history_id)))
      {
        pass ("PLANESURFACE.history_id [H]");
      }
    else
      {
        fail ("PLANESURFACE.history_id [H]");
        error++;
      }
  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "isoline_present", &isoline_present, NULL)
        && isoline_present == planesurface->isoline_present)
      {
        pass ("PLANESURFACE.isoline_present [B] " FORMAT_B "", isoline_present);
      }
    else
      {
        fail ("PLANESURFACE.isoline_present [B] " FORMAT_B " != " FORMAT_B "", planesurface->isoline_present, isoline_present);
        error++;
      }
    isoline_present++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "isoline_present", &isoline_present)
        && isoline_present == planesurface->isoline_present)
      {
        pass ("PLANESURFACE.isoline_present [B] set+1 " FORMAT_B "", isoline_present);
      }
    else
      {
        fail ("PLANESURFACE.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->isoline_present, isoline_present);
        error++;
      }
    planesurface->isoline_present--;

  }
  {
    BITCODE_BS modeler_format_version;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "modeler_format_version", &modeler_format_version, NULL)
        && modeler_format_version == planesurface->modeler_format_version)
      {
        pass ("PLANESURFACE.modeler_format_version [BS] %hu", modeler_format_version);
      }
    else
      {
        fail ("PLANESURFACE.modeler_format_version [BS] %hu != %hu", planesurface->modeler_format_version, modeler_format_version);
        error++;
      }
    modeler_format_version++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "modeler_format_version", &modeler_format_version)
        && modeler_format_version == planesurface->modeler_format_version)
      {
        pass ("PLANESURFACE.modeler_format_version [BS] set+1 %hu", modeler_format_version);
      }
    else
      {
        fail ("PLANESURFACE.modeler_format_version [BS] set+1 %hu != %hu", planesurface->modeler_format_version, modeler_format_version);
        error++;
      }
    planesurface->modeler_format_version--;

  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "num_blocks", &num_blocks, NULL)
        && num_blocks == planesurface->num_blocks)
      {
        pass ("PLANESURFACE.num_blocks [BL] %u", num_blocks);
      }
    else
      {
        fail ("PLANESURFACE.num_blocks [BL] %u != %u", planesurface->num_blocks, num_blocks);
        error++;
      }
    num_blocks++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "num_blocks", &num_blocks)
        && num_blocks == planesurface->num_blocks)
      {
        pass ("PLANESURFACE.num_blocks [BL] set+1 %u", num_blocks);
      }
    else
      {
        fail ("PLANESURFACE.num_blocks [BL] set+1 %u != %u", planesurface->num_blocks, num_blocks);
        error++;
      }
    planesurface->num_blocks--;

  }
  {
    BITCODE_BL num_isolines;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "num_isolines", &num_isolines, NULL)
        && num_isolines == planesurface->num_isolines)
      {
        pass ("PLANESURFACE.num_isolines [BL] %u", num_isolines);
      }
    else
      {
        fail ("PLANESURFACE.num_isolines [BL] %u != %u", planesurface->num_isolines, num_isolines);
        error++;
      }
    num_isolines++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "num_isolines", &num_isolines)
        && num_isolines == planesurface->num_isolines)
      {
        pass ("PLANESURFACE.num_isolines [BL] set+1 %u", num_isolines);
      }
    else
      {
        fail ("PLANESURFACE.num_isolines [BL] set+1 %u != %u", planesurface->num_isolines, num_isolines);
        error++;
      }
    planesurface->num_isolines--;

  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == planesurface->num_silhouettes)
      {
        pass ("PLANESURFACE.num_silhouettes [BL] %u", num_silhouettes);
      }
    else
      {
        fail ("PLANESURFACE.num_silhouettes [BL] %u != %u", planesurface->num_silhouettes, num_silhouettes);
        error++;
      }
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "num_silhouettes", &num_silhouettes)
        && num_silhouettes == planesurface->num_silhouettes)
      {
        pass ("PLANESURFACE.num_silhouettes [BL] set+1 %u", num_silhouettes);
      }
    else
      {
        fail ("PLANESURFACE.num_silhouettes [BL] set+1 %u != %u", planesurface->num_silhouettes, num_silhouettes);
        error++;
      }
    planesurface->num_silhouettes--;

  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "num_wires", &num_wires, NULL)
        && num_wires == planesurface->num_wires)
      {
        pass ("PLANESURFACE.num_wires [BL] %u", num_wires);
      }
    else
      {
        fail ("PLANESURFACE.num_wires [BL] %u != %u", planesurface->num_wires, num_wires);
        error++;
      }
    num_wires++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "num_wires", &num_wires)
        && num_wires == planesurface->num_wires)
      {
        pass ("PLANESURFACE.num_wires [BL] set+1 %u", num_wires);
      }
    else
      {
        fail ("PLANESURFACE.num_wires [BL] set+1 %u != %u", planesurface->num_wires, num_wires);
        error++;
      }
    planesurface->num_wires--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &planesurface->parent, sizeof (planesurface->parent)))
      {
        pass ("PLANESURFACE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("PLANESURFACE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "point", &point, NULL)
        && !memcmp (&point, &planesurface->point, sizeof (planesurface->point)))
      {
        pass ("PLANESURFACE.point [3BD]");
      }
    else
      {
        fail ("PLANESURFACE.point [3BD]");
        error++;
      }
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "point_present", &point_present, NULL)
        && point_present == planesurface->point_present)
      {
        pass ("PLANESURFACE.point_present [B] " FORMAT_B "", point_present);
      }
    else
      {
        fail ("PLANESURFACE.point_present [B] " FORMAT_B " != " FORMAT_B "", planesurface->point_present, point_present);
        error++;
      }
    point_present++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "point_present", &point_present)
        && point_present == planesurface->point_present)
      {
        pass ("PLANESURFACE.point_present [B] set+1 " FORMAT_B "", point_present);
      }
    else
      {
        fail ("PLANESURFACE.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->point_present, point_present);
        error++;
      }
    planesurface->point_present--;

  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "silhouettes", &silhouettes, NULL)
        && silhouettes == planesurface->silhouettes)
      {
        pass ("PLANESURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
      }
    else
      {
        fail ("PLANESURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
        error++;
      }
  }
  {
    BITCODE_BS u_isolines;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "u_isolines", &u_isolines, NULL)
        && u_isolines == planesurface->u_isolines)
      {
        pass ("PLANESURFACE.u_isolines [BS] %hu", u_isolines);
      }
    else
      {
        fail ("PLANESURFACE.u_isolines [BS] %hu != %hu", planesurface->u_isolines, u_isolines);
        error++;
      }
    u_isolines++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "u_isolines", &u_isolines)
        && u_isolines == planesurface->u_isolines)
      {
        pass ("PLANESURFACE.u_isolines [BS] set+1 %hu", u_isolines);
      }
    else
      {
        fail ("PLANESURFACE.u_isolines [BS] set+1 %hu != %hu", planesurface->u_isolines, u_isolines);
        error++;
      }
    planesurface->u_isolines--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "unknown", &unknown, NULL)
        && unknown == planesurface->unknown)
      {
        pass ("PLANESURFACE.unknown [B] " FORMAT_B "", unknown);
      }
    else
      {
        fail ("PLANESURFACE.unknown [B] " FORMAT_B " != " FORMAT_B "", planesurface->unknown, unknown);
        error++;
      }
    unknown++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "unknown", &unknown)
        && unknown == planesurface->unknown)
      {
        pass ("PLANESURFACE.unknown [B] set+1 " FORMAT_B "", unknown);
      }
    else
      {
        fail ("PLANESURFACE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->unknown, unknown);
        error++;
      }
    planesurface->unknown--;

  }
  {
    BITCODE_BL unknown_2007;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "unknown_2007", &unknown_2007, NULL)
        && unknown_2007 == planesurface->unknown_2007)
      {
        pass ("PLANESURFACE.unknown_2007 [BL] %u", unknown_2007);
      }
    else
      {
        fail ("PLANESURFACE.unknown_2007 [BL] %u != %u", planesurface->unknown_2007, unknown_2007);
        error++;
      }
    unknown_2007++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "unknown_2007", &unknown_2007)
        && unknown_2007 == planesurface->unknown_2007)
      {
        pass ("PLANESURFACE.unknown_2007 [BL] set+1 %u", unknown_2007);
      }
    else
      {
        fail ("PLANESURFACE.unknown_2007 [BL] set+1 %u != %u", planesurface->unknown_2007, unknown_2007);
        error++;
      }
    planesurface->unknown_2007--;

  }
  {
    BITCODE_BS v_isolines;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "v_isolines", &v_isolines, NULL)
        && v_isolines == planesurface->v_isolines)
      {
        pass ("PLANESURFACE.v_isolines [BS] %hu", v_isolines);
      }
    else
      {
        fail ("PLANESURFACE.v_isolines [BS] %hu != %hu", planesurface->v_isolines, v_isolines);
        error++;
      }
    v_isolines++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "v_isolines", &v_isolines)
        && v_isolines == planesurface->v_isolines)
      {
        pass ("PLANESURFACE.v_isolines [BS] set+1 %hu", v_isolines);
      }
    else
      {
        fail ("PLANESURFACE.v_isolines [BS] set+1 %hu != %hu", planesurface->v_isolines, v_isolines);
        error++;
      }
    planesurface->v_isolines--;

  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "version", &version, NULL)
        && version == planesurface->version)
      {
        pass ("PLANESURFACE.version [BS] %hu", version);
      }
    else
      {
        fail ("PLANESURFACE.version [BS] %hu != %hu", planesurface->version, version);
        error++;
      }
    version++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "version", &version)
        && version == planesurface->version)
      {
        pass ("PLANESURFACE.version [BS] set+1 %hu", version);
      }
    else
      {
        fail ("PLANESURFACE.version [BS] set+1 %hu != %hu", planesurface->version, version);
        error++;
      }
    planesurface->version--;

  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value(planesurface, "PLANESURFACE", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == planesurface->wireframe_data_present)
      {
        pass ("PLANESURFACE.wireframe_data_present [B] " FORMAT_B "", wireframe_data_present);
      }
    else
      {
        fail ("PLANESURFACE.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", planesurface->wireframe_data_present, wireframe_data_present);
        error++;
      }
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "wireframe_data_present", &wireframe_data_present)
        && wireframe_data_present == planesurface->wireframe_data_present)
      {
        pass ("PLANESURFACE.wireframe_data_present [B] set+1 " FORMAT_B "", wireframe_data_present);
      }
    else
      {
        fail ("PLANESURFACE.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->wireframe_data_present, wireframe_data_present);
        error++;
      }
    planesurface->wireframe_data_present--;

  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "wires", &wires, NULL)
        && wires == planesurface->wires)
      {
        pass ("PLANESURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
      }
    else
      {
        fail ("PLANESURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
        error++;
      }
  }
  return error;
}
static int test_POINT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_POINT *restrict point = obj->tio.entity->tio.POINT;
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value(point, "POINT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &point->extrusion, sizeof (point->extrusion)))
      {
        pass ("POINT.extrusion [BE]");
      }
    else
      {
        fail ("POINT.extrusion [BE]");
        error++;
      }
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(point, "POINT", "parent", &parent, NULL)
        && !memcmp (&parent, &point->parent, sizeof (point->parent)))
      {
        pass ("POINT.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("POINT.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value(point, "POINT", "thickness", &thickness, NULL)
        && thickness == point->thickness)
      {
        pass ("POINT.thickness [BT] " FORMAT_BT "", thickness);
      }
    else
      {
        fail ("POINT.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", point->thickness, thickness);
        error++;
      }
    if (dwg_dynapi_entity_set_value (point, "POINT", "thickness", &thickness)
        && thickness == point->thickness)
      {
        pass ("POINT.thickness [BT] set+1 " FORMAT_BT "", thickness);
      }
    else
      {
        fail ("POINT.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", point->thickness, thickness);
        error++;
      }
    point->thickness--;

  }
  {
    BITCODE_BD x;
    if (dwg_dynapi_entity_value(point, "POINT", "x", &x, NULL)
        && x == point->x)
      {
        pass ("POINT.x [BD] %g", x);
      }
    else
      {
        fail ("POINT.x [BD] %g != %g", point->x, x);
        error++;
      }
    x++;
    if (dwg_dynapi_entity_set_value (point, "POINT", "x", &x)
        && x == point->x)
      {
        pass ("POINT.x [BD] set+1 %g", x);
      }
    else
      {
        fail ("POINT.x [BD] set+1 %g != %g", point->x, x);
        error++;
      }
    point->x--;

  }
  {
    BITCODE_BD x_ang;
    if (dwg_dynapi_entity_value(point, "POINT", "x_ang", &x_ang, NULL)
        && x_ang == point->x_ang)
      {
        pass ("POINT.x_ang [BD] %g", x_ang);
      }
    else
      {
        fail ("POINT.x_ang [BD] %g != %g", point->x_ang, x_ang);
        error++;
      }
    x_ang++;
    if (dwg_dynapi_entity_set_value (point, "POINT", "x_ang", &x_ang)
        && x_ang == point->x_ang)
      {
        pass ("POINT.x_ang [BD] set+1 %g", x_ang);
      }
    else
      {
        fail ("POINT.x_ang [BD] set+1 %g != %g", point->x_ang, x_ang);
        error++;
      }
    point->x_ang--;

  }
  {
    BITCODE_BD y;
    if (dwg_dynapi_entity_value(point, "POINT", "y", &y, NULL)
        && y == point->y)
      {
        pass ("POINT.y [BD] %g", y);
      }
    else
      {
        fail ("POINT.y [BD] %g != %g", point->y, y);
        error++;
      }
    y++;
    if (dwg_dynapi_entity_set_value (point, "POINT", "y", &y)
        && y == point->y)
      {
        pass ("POINT.y [BD] set+1 %g", y);
      }
    else
      {
        fail ("POINT.y [BD] set+1 %g != %g", point->y, y);
        error++;
      }
    point->y--;

  }
  {
    BITCODE_BD z;
    if (dwg_dynapi_entity_value(point, "POINT", "z", &z, NULL)
        && z == point->z)
      {
        pass ("POINT.z [BD] %g", z);
      }
    else
      {
        fail ("POINT.z [BD] %g != %g", point->z, z);
        error++;
      }
    z++;
    if (dwg_dynapi_entity_set_value (point, "POINT", "z", &z)
        && z == point->z)
      {
        pass ("POINT.z [BD] set+1 %g", z);
      }
    else
      {
        fail ("POINT.z [BD] set+1 %g != %g", point->z, z);
        error++;
      }
    point->z--;

  }
  return error;
}
static int test_POLYLINE_2D (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_POLYLINE_2D *restrict polyline_2d = obj->tio.entity->tio.POLYLINE_2D;
  {
    BITCODE_BS curve_type;
    if (dwg_dynapi_entity_value(polyline_2d, "POLYLINE_2D", "curve_type", &curve_type, NULL)
        && curve_type == polyline_2d->curve_type)
      {
        pass ("POLYLINE_2D.curve_type [BS] %hu", curve_type);
      }
    else
      {
        fail ("POLYLINE_2D.curve_type [BS] %hu != %hu", polyline_2d->curve_type, curve_type);
        error++;
      }
    curve_type++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "curve_type", &curve_type)
        && curve_type == polyline_2d->curve_type)
      {
        pass ("POLYLINE_2D.curve_type [BS] set+1 %hu", curve_type);
      }
    else
      {
        fail ("POLYLINE_2D.curve_type [BS] set+1 %hu != %hu", polyline_2d->curve_type, curve_type);
        error++;
      }
    polyline_2d->curve_type--;

  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value(polyline_2d, "POLYLINE_2D", "elevation", &elevation, NULL)
        && elevation == polyline_2d->elevation)
      {
        pass ("POLYLINE_2D.elevation [BD] %g", elevation);
      }
    else
      {
        fail ("POLYLINE_2D.elevation [BD] %g != %g", polyline_2d->elevation, elevation);
        error++;
      }
    elevation++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "elevation", &elevation)
        && elevation == polyline_2d->elevation)
      {
        pass ("POLYLINE_2D.elevation [BD] set+1 %g", elevation);
      }
    else
      {
        fail ("POLYLINE_2D.elevation [BD] set+1 %g != %g", polyline_2d->elevation, elevation);
        error++;
      }
    polyline_2d->elevation--;

  }
  {
    BITCODE_BD end_width;
    if (dwg_dynapi_entity_value(polyline_2d, "POLYLINE_2D", "end_width", &end_width, NULL)
        && end_width == polyline_2d->end_width)
      {
        pass ("POLYLINE_2D.end_width [BD] %g", end_width);
      }
    else
      {
        fail ("POLYLINE_2D.end_width [BD] %g != %g", polyline_2d->end_width, end_width);
        error++;
      }
    end_width++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "end_width", &end_width)
        && end_width == polyline_2d->end_width)
      {
        pass ("POLYLINE_2D.end_width [BD] set+1 %g", end_width);
      }
    else
      {
        fail ("POLYLINE_2D.end_width [BD] set+1 %g != %g", polyline_2d->end_width, end_width);
        error++;
      }
    polyline_2d->end_width--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value(polyline_2d, "POLYLINE_2D", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &polyline_2d->extrusion, sizeof (polyline_2d->extrusion)))
      {
        pass ("POLYLINE_2D.extrusion [BE]");
      }
    else
      {
        fail ("POLYLINE_2D.extrusion [BE]");
        error++;
      }
  }
  {
    BITCODE_H first_vertex;
    if (dwg_dynapi_entity_value(polyline_2d, "POLYLINE_2D", "first_vertex", &first_vertex, NULL)
        && !memcmp (&first_vertex, &polyline_2d->first_vertex, sizeof (polyline_2d->first_vertex)))
      {
        pass ("POLYLINE_2D.first_vertex [H]");
      }
    else
      {
        fail ("POLYLINE_2D.first_vertex [H]");
        error++;
      }
  }
  {
    BITCODE_BS flag;
    if (dwg_dynapi_entity_value(polyline_2d, "POLYLINE_2D", "flag", &flag, NULL)
        && flag == polyline_2d->flag)
      {
        pass ("POLYLINE_2D.flag [BS] %hu", flag);
      }
    else
      {
        fail ("POLYLINE_2D.flag [BS] %hu != %hu", polyline_2d->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "flag", &flag)
        && flag == polyline_2d->flag)
      {
        pass ("POLYLINE_2D.flag [BS] set+1 %hu", flag);
      }
    else
      {
        fail ("POLYLINE_2D.flag [BS] set+1 %hu != %hu", polyline_2d->flag, flag);
        error++;
      }
    polyline_2d->flag--;

  }
  {
    BITCODE_H last_vertex;
    if (dwg_dynapi_entity_value(polyline_2d, "POLYLINE_2D", "last_vertex", &last_vertex, NULL)
        && !memcmp (&last_vertex, &polyline_2d->last_vertex, sizeof (polyline_2d->last_vertex)))
      {
        pass ("POLYLINE_2D.last_vertex [H]");
      }
    else
      {
        fail ("POLYLINE_2D.last_vertex [H]");
        error++;
      }
  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value(polyline_2d, "POLYLINE_2D", "num_owned", &num_owned, NULL)
        && num_owned == polyline_2d->num_owned)
      {
        pass ("POLYLINE_2D.num_owned [BL] %u", num_owned);
      }
    else
      {
        fail ("POLYLINE_2D.num_owned [BL] %u != %u", polyline_2d->num_owned, num_owned);
        error++;
      }
    num_owned++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "num_owned", &num_owned)
        && num_owned == polyline_2d->num_owned)
      {
        pass ("POLYLINE_2D.num_owned [BL] set+1 %u", num_owned);
      }
    else
      {
        fail ("POLYLINE_2D.num_owned [BL] set+1 %u != %u", polyline_2d->num_owned, num_owned);
        error++;
      }
    polyline_2d->num_owned--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(polyline_2d, "POLYLINE_2D", "parent", &parent, NULL)
        && !memcmp (&parent, &polyline_2d->parent, sizeof (polyline_2d->parent)))
      {
        pass ("POLYLINE_2D.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("POLYLINE_2D.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value(polyline_2d, "POLYLINE_2D", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &polyline_2d->seqend, sizeof (polyline_2d->seqend)))
      {
        pass ("POLYLINE_2D.seqend [H]");
      }
    else
      {
        fail ("POLYLINE_2D.seqend [H]");
        error++;
      }
  }
  {
    BITCODE_BD start_width;
    if (dwg_dynapi_entity_value(polyline_2d, "POLYLINE_2D", "start_width", &start_width, NULL)
        && start_width == polyline_2d->start_width)
      {
        pass ("POLYLINE_2D.start_width [BD] %g", start_width);
      }
    else
      {
        fail ("POLYLINE_2D.start_width [BD] %g != %g", polyline_2d->start_width, start_width);
        error++;
      }
    start_width++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "start_width", &start_width)
        && start_width == polyline_2d->start_width)
      {
        pass ("POLYLINE_2D.start_width [BD] set+1 %g", start_width);
      }
    else
      {
        fail ("POLYLINE_2D.start_width [BD] set+1 %g != %g", polyline_2d->start_width, start_width);
        error++;
      }
    polyline_2d->start_width--;

  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value(polyline_2d, "POLYLINE_2D", "thickness", &thickness, NULL)
        && thickness == polyline_2d->thickness)
      {
        pass ("POLYLINE_2D.thickness [BT] " FORMAT_BT "", thickness);
      }
    else
      {
        fail ("POLYLINE_2D.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", polyline_2d->thickness, thickness);
        error++;
      }
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "thickness", &thickness)
        && thickness == polyline_2d->thickness)
      {
        pass ("POLYLINE_2D.thickness [BT] set+1 " FORMAT_BT "", thickness);
      }
    else
      {
        fail ("POLYLINE_2D.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", polyline_2d->thickness, thickness);
        error++;
      }
    polyline_2d->thickness--;

  }
  {
    BITCODE_H* vertex;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "vertex", &vertex, NULL)
        && vertex == polyline_2d->vertex)
      {
        pass ("POLYLINE_2D.vertex [H*] * %u num_owned", count);
      }
    else
      {
        fail ("POLYLINE_2D.vertex [H*] * %u num_owned", count);
        error++;
      }
  }
  return error;
}
static int test_POLYLINE_3D (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_POLYLINE_3D *restrict polyline_3d = obj->tio.entity->tio.POLYLINE_3D;
  {
    BITCODE_RC curve_type;
    if (dwg_dynapi_entity_value(polyline_3d, "POLYLINE_3D", "curve_type", &curve_type, NULL)
        && curve_type == polyline_3d->curve_type)
      {
        pass ("POLYLINE_3D.curve_type [RC] %u", curve_type);
      }
    else
      {
        fail ("POLYLINE_3D.curve_type [RC] %u != %u", polyline_3d->curve_type, curve_type);
        error++;
      }
    curve_type++;
    if (dwg_dynapi_entity_set_value (polyline_3d, "POLYLINE_3D", "curve_type", &curve_type)
        && curve_type == polyline_3d->curve_type)
      {
        pass ("POLYLINE_3D.curve_type [RC] set+1 %u", curve_type);
      }
    else
      {
        fail ("POLYLINE_3D.curve_type [RC] set+1 %u != %u", polyline_3d->curve_type, curve_type);
        error++;
      }
    polyline_3d->curve_type--;

  }
  {
    BITCODE_H first_vertex;
    if (dwg_dynapi_entity_value(polyline_3d, "POLYLINE_3D", "first_vertex", &first_vertex, NULL)
        && !memcmp (&first_vertex, &polyline_3d->first_vertex, sizeof (polyline_3d->first_vertex)))
      {
        pass ("POLYLINE_3D.first_vertex [H]");
      }
    else
      {
        fail ("POLYLINE_3D.first_vertex [H]");
        error++;
      }
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value(polyline_3d, "POLYLINE_3D", "flag", &flag, NULL)
        && flag == polyline_3d->flag)
      {
        pass ("POLYLINE_3D.flag [RC] %u", flag);
      }
    else
      {
        fail ("POLYLINE_3D.flag [RC] %u != %u", polyline_3d->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (polyline_3d, "POLYLINE_3D", "flag", &flag)
        && flag == polyline_3d->flag)
      {
        pass ("POLYLINE_3D.flag [RC] set+1 %u", flag);
      }
    else
      {
        fail ("POLYLINE_3D.flag [RC] set+1 %u != %u", polyline_3d->flag, flag);
        error++;
      }
    polyline_3d->flag--;

  }
  {
    BITCODE_H last_vertex;
    if (dwg_dynapi_entity_value(polyline_3d, "POLYLINE_3D", "last_vertex", &last_vertex, NULL)
        && !memcmp (&last_vertex, &polyline_3d->last_vertex, sizeof (polyline_3d->last_vertex)))
      {
        pass ("POLYLINE_3D.last_vertex [H]");
      }
    else
      {
        fail ("POLYLINE_3D.last_vertex [H]");
        error++;
      }
  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value(polyline_3d, "POLYLINE_3D", "num_owned", &num_owned, NULL)
        && num_owned == polyline_3d->num_owned)
      {
        pass ("POLYLINE_3D.num_owned [BL] %u", num_owned);
      }
    else
      {
        fail ("POLYLINE_3D.num_owned [BL] %u != %u", polyline_3d->num_owned, num_owned);
        error++;
      }
    num_owned++;
    if (dwg_dynapi_entity_set_value (polyline_3d, "POLYLINE_3D", "num_owned", &num_owned)
        && num_owned == polyline_3d->num_owned)
      {
        pass ("POLYLINE_3D.num_owned [BL] set+1 %u", num_owned);
      }
    else
      {
        fail ("POLYLINE_3D.num_owned [BL] set+1 %u != %u", polyline_3d->num_owned, num_owned);
        error++;
      }
    polyline_3d->num_owned--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(polyline_3d, "POLYLINE_3D", "parent", &parent, NULL)
        && !memcmp (&parent, &polyline_3d->parent, sizeof (polyline_3d->parent)))
      {
        pass ("POLYLINE_3D.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("POLYLINE_3D.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value(polyline_3d, "POLYLINE_3D", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &polyline_3d->seqend, sizeof (polyline_3d->seqend)))
      {
        pass ("POLYLINE_3D.seqend [H]");
      }
    else
      {
        fail ("POLYLINE_3D.seqend [H]");
        error++;
      }
  }
  {
    BITCODE_H* vertex;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "vertex", &vertex, NULL)
        && vertex == polyline_3d->vertex)
      {
        pass ("POLYLINE_3D.vertex [H*] * %u num_owned", count);
      }
    else
      {
        fail ("POLYLINE_3D.vertex [H*] * %u num_owned", count);
        error++;
      }
  }
  return error;
}
static int test_POLYLINE_MESH (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_POLYLINE_MESH *restrict polyline_mesh = obj->tio.entity->tio.POLYLINE_MESH;
  {
    BITCODE_BS curve_type;
    if (dwg_dynapi_entity_value(polyline_mesh, "POLYLINE_MESH", "curve_type", &curve_type, NULL)
        && curve_type == polyline_mesh->curve_type)
      {
        pass ("POLYLINE_MESH.curve_type [BS] %hu", curve_type);
      }
    else
      {
        fail ("POLYLINE_MESH.curve_type [BS] %hu != %hu", polyline_mesh->curve_type, curve_type);
        error++;
      }
    curve_type++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "curve_type", &curve_type)
        && curve_type == polyline_mesh->curve_type)
      {
        pass ("POLYLINE_MESH.curve_type [BS] set+1 %hu", curve_type);
      }
    else
      {
        fail ("POLYLINE_MESH.curve_type [BS] set+1 %hu != %hu", polyline_mesh->curve_type, curve_type);
        error++;
      }
    polyline_mesh->curve_type--;

  }
  {
    BITCODE_H first_vertex;
    if (dwg_dynapi_entity_value(polyline_mesh, "POLYLINE_MESH", "first_vertex", &first_vertex, NULL)
        && !memcmp (&first_vertex, &polyline_mesh->first_vertex, sizeof (polyline_mesh->first_vertex)))
      {
        pass ("POLYLINE_MESH.first_vertex [H]");
      }
    else
      {
        fail ("POLYLINE_MESH.first_vertex [H]");
        error++;
      }
  }
  {
    BITCODE_BS flag;
    if (dwg_dynapi_entity_value(polyline_mesh, "POLYLINE_MESH", "flag", &flag, NULL)
        && flag == polyline_mesh->flag)
      {
        pass ("POLYLINE_MESH.flag [BS] %hu", flag);
      }
    else
      {
        fail ("POLYLINE_MESH.flag [BS] %hu != %hu", polyline_mesh->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "flag", &flag)
        && flag == polyline_mesh->flag)
      {
        pass ("POLYLINE_MESH.flag [BS] set+1 %hu", flag);
      }
    else
      {
        fail ("POLYLINE_MESH.flag [BS] set+1 %hu != %hu", polyline_mesh->flag, flag);
        error++;
      }
    polyline_mesh->flag--;

  }
  {
    BITCODE_H last_vertex;
    if (dwg_dynapi_entity_value(polyline_mesh, "POLYLINE_MESH", "last_vertex", &last_vertex, NULL)
        && !memcmp (&last_vertex, &polyline_mesh->last_vertex, sizeof (polyline_mesh->last_vertex)))
      {
        pass ("POLYLINE_MESH.last_vertex [H]");
      }
    else
      {
        fail ("POLYLINE_MESH.last_vertex [H]");
        error++;
      }
  }
  {
    BITCODE_BS m_density;
    if (dwg_dynapi_entity_value(polyline_mesh, "POLYLINE_MESH", "m_density", &m_density, NULL)
        && m_density == polyline_mesh->m_density)
      {
        pass ("POLYLINE_MESH.m_density [BS] %hu", m_density);
      }
    else
      {
        fail ("POLYLINE_MESH.m_density [BS] %hu != %hu", polyline_mesh->m_density, m_density);
        error++;
      }
    m_density++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "m_density", &m_density)
        && m_density == polyline_mesh->m_density)
      {
        pass ("POLYLINE_MESH.m_density [BS] set+1 %hu", m_density);
      }
    else
      {
        fail ("POLYLINE_MESH.m_density [BS] set+1 %hu != %hu", polyline_mesh->m_density, m_density);
        error++;
      }
    polyline_mesh->m_density--;

  }
  {
    BITCODE_BS n_density;
    if (dwg_dynapi_entity_value(polyline_mesh, "POLYLINE_MESH", "n_density", &n_density, NULL)
        && n_density == polyline_mesh->n_density)
      {
        pass ("POLYLINE_MESH.n_density [BS] %hu", n_density);
      }
    else
      {
        fail ("POLYLINE_MESH.n_density [BS] %hu != %hu", polyline_mesh->n_density, n_density);
        error++;
      }
    n_density++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "n_density", &n_density)
        && n_density == polyline_mesh->n_density)
      {
        pass ("POLYLINE_MESH.n_density [BS] set+1 %hu", n_density);
      }
    else
      {
        fail ("POLYLINE_MESH.n_density [BS] set+1 %hu != %hu", polyline_mesh->n_density, n_density);
        error++;
      }
    polyline_mesh->n_density--;

  }
  {
    BITCODE_BS num_m_verts;
    if (dwg_dynapi_entity_value(polyline_mesh, "POLYLINE_MESH", "num_m_verts", &num_m_verts, NULL)
        && num_m_verts == polyline_mesh->num_m_verts)
      {
        pass ("POLYLINE_MESH.num_m_verts [BS] %hu", num_m_verts);
      }
    else
      {
        fail ("POLYLINE_MESH.num_m_verts [BS] %hu != %hu", polyline_mesh->num_m_verts, num_m_verts);
        error++;
      }
    num_m_verts++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "num_m_verts", &num_m_verts)
        && num_m_verts == polyline_mesh->num_m_verts)
      {
        pass ("POLYLINE_MESH.num_m_verts [BS] set+1 %hu", num_m_verts);
      }
    else
      {
        fail ("POLYLINE_MESH.num_m_verts [BS] set+1 %hu != %hu", polyline_mesh->num_m_verts, num_m_verts);
        error++;
      }
    polyline_mesh->num_m_verts--;

  }
  {
    BITCODE_BS num_n_verts;
    if (dwg_dynapi_entity_value(polyline_mesh, "POLYLINE_MESH", "num_n_verts", &num_n_verts, NULL)
        && num_n_verts == polyline_mesh->num_n_verts)
      {
        pass ("POLYLINE_MESH.num_n_verts [BS] %hu", num_n_verts);
      }
    else
      {
        fail ("POLYLINE_MESH.num_n_verts [BS] %hu != %hu", polyline_mesh->num_n_verts, num_n_verts);
        error++;
      }
    num_n_verts++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "num_n_verts", &num_n_verts)
        && num_n_verts == polyline_mesh->num_n_verts)
      {
        pass ("POLYLINE_MESH.num_n_verts [BS] set+1 %hu", num_n_verts);
      }
    else
      {
        fail ("POLYLINE_MESH.num_n_verts [BS] set+1 %hu != %hu", polyline_mesh->num_n_verts, num_n_verts);
        error++;
      }
    polyline_mesh->num_n_verts--;

  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value(polyline_mesh, "POLYLINE_MESH", "num_owned", &num_owned, NULL)
        && num_owned == polyline_mesh->num_owned)
      {
        pass ("POLYLINE_MESH.num_owned [BL] %u", num_owned);
      }
    else
      {
        fail ("POLYLINE_MESH.num_owned [BL] %u != %u", polyline_mesh->num_owned, num_owned);
        error++;
      }
    num_owned++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "num_owned", &num_owned)
        && num_owned == polyline_mesh->num_owned)
      {
        pass ("POLYLINE_MESH.num_owned [BL] set+1 %u", num_owned);
      }
    else
      {
        fail ("POLYLINE_MESH.num_owned [BL] set+1 %u != %u", polyline_mesh->num_owned, num_owned);
        error++;
      }
    polyline_mesh->num_owned--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(polyline_mesh, "POLYLINE_MESH", "parent", &parent, NULL)
        && !memcmp (&parent, &polyline_mesh->parent, sizeof (polyline_mesh->parent)))
      {
        pass ("POLYLINE_MESH.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("POLYLINE_MESH.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value(polyline_mesh, "POLYLINE_MESH", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &polyline_mesh->seqend, sizeof (polyline_mesh->seqend)))
      {
        pass ("POLYLINE_MESH.seqend [H]");
      }
    else
      {
        fail ("POLYLINE_MESH.seqend [H]");
        error++;
      }
  }
  {
    BITCODE_H* vertex;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "vertex", &vertex, NULL)
        && vertex == polyline_mesh->vertex)
      {
        pass ("POLYLINE_MESH.vertex [H*] * %u num_owned", count);
      }
    else
      {
        fail ("POLYLINE_MESH.vertex [H*] * %u num_owned", count);
        error++;
      }
  }
  return error;
}
static int test_POLYLINE_PFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_POLYLINE_PFACE *restrict polyline_pface = obj->tio.entity->tio.POLYLINE_PFACE;
  {
    BITCODE_H first_vertex;
    if (dwg_dynapi_entity_value(polyline_pface, "POLYLINE_PFACE", "first_vertex", &first_vertex, NULL)
        && !memcmp (&first_vertex, &polyline_pface->first_vertex, sizeof (polyline_pface->first_vertex)))
      {
        pass ("POLYLINE_PFACE.first_vertex [H]");
      }
    else
      {
        fail ("POLYLINE_PFACE.first_vertex [H]");
        error++;
      }
  }
  {
    BITCODE_H last_vertex;
    if (dwg_dynapi_entity_value(polyline_pface, "POLYLINE_PFACE", "last_vertex", &last_vertex, NULL)
        && !memcmp (&last_vertex, &polyline_pface->last_vertex, sizeof (polyline_pface->last_vertex)))
      {
        pass ("POLYLINE_PFACE.last_vertex [H]");
      }
    else
      {
        fail ("POLYLINE_PFACE.last_vertex [H]");
        error++;
      }
  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value(polyline_pface, "POLYLINE_PFACE", "num_owned", &num_owned, NULL)
        && num_owned == polyline_pface->num_owned)
      {
        pass ("POLYLINE_PFACE.num_owned [BL] %u", num_owned);
      }
    else
      {
        fail ("POLYLINE_PFACE.num_owned [BL] %u != %u", polyline_pface->num_owned, num_owned);
        error++;
      }
    num_owned++;
    if (dwg_dynapi_entity_set_value (polyline_pface, "POLYLINE_PFACE", "num_owned", &num_owned)
        && num_owned == polyline_pface->num_owned)
      {
        pass ("POLYLINE_PFACE.num_owned [BL] set+1 %u", num_owned);
      }
    else
      {
        fail ("POLYLINE_PFACE.num_owned [BL] set+1 %u != %u", polyline_pface->num_owned, num_owned);
        error++;
      }
    polyline_pface->num_owned--;

  }
  {
    BITCODE_BS numfaces;
    if (dwg_dynapi_entity_value(polyline_pface, "POLYLINE_PFACE", "numfaces", &numfaces, NULL)
        && numfaces == polyline_pface->numfaces)
      {
        pass ("POLYLINE_PFACE.numfaces [BS] %hu", numfaces);
      }
    else
      {
        fail ("POLYLINE_PFACE.numfaces [BS] %hu != %hu", polyline_pface->numfaces, numfaces);
        error++;
      }
    numfaces++;
    if (dwg_dynapi_entity_set_value (polyline_pface, "POLYLINE_PFACE", "numfaces", &numfaces)
        && numfaces == polyline_pface->numfaces)
      {
        pass ("POLYLINE_PFACE.numfaces [BS] set+1 %hu", numfaces);
      }
    else
      {
        fail ("POLYLINE_PFACE.numfaces [BS] set+1 %hu != %hu", polyline_pface->numfaces, numfaces);
        error++;
      }
    polyline_pface->numfaces--;

  }
  {
    BITCODE_BS numverts;
    if (dwg_dynapi_entity_value(polyline_pface, "POLYLINE_PFACE", "numverts", &numverts, NULL)
        && numverts == polyline_pface->numverts)
      {
        pass ("POLYLINE_PFACE.numverts [BS] %hu", numverts);
      }
    else
      {
        fail ("POLYLINE_PFACE.numverts [BS] %hu != %hu", polyline_pface->numverts, numverts);
        error++;
      }
    numverts++;
    if (dwg_dynapi_entity_set_value (polyline_pface, "POLYLINE_PFACE", "numverts", &numverts)
        && numverts == polyline_pface->numverts)
      {
        pass ("POLYLINE_PFACE.numverts [BS] set+1 %hu", numverts);
      }
    else
      {
        fail ("POLYLINE_PFACE.numverts [BS] set+1 %hu != %hu", polyline_pface->numverts, numverts);
        error++;
      }
    polyline_pface->numverts--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(polyline_pface, "POLYLINE_PFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &polyline_pface->parent, sizeof (polyline_pface->parent)))
      {
        pass ("POLYLINE_PFACE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("POLYLINE_PFACE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value(polyline_pface, "POLYLINE_PFACE", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &polyline_pface->seqend, sizeof (polyline_pface->seqend)))
      {
        pass ("POLYLINE_PFACE.seqend [H]");
      }
    else
      {
        fail ("POLYLINE_PFACE.seqend [H]");
        error++;
      }
  }
  {
    BITCODE_H* vertex;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "vertex", &vertex, NULL)
        && vertex == polyline_pface->vertex)
      {
        pass ("POLYLINE_PFACE.vertex [H*] * %u num_owned", count);
      }
    else
      {
        fail ("POLYLINE_PFACE.vertex [H*] * %u num_owned", count);
        error++;
      }
  }
  return error;
}
static int test_PROXY_ENTITY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_PROXY_ENTITY *restrict proxy_entity = obj->tio.entity->tio.PROXY_ENTITY;
  {
    BITCODE_BL class_id;
    if (dwg_dynapi_entity_value(proxy_entity, "PROXY_ENTITY", "class_id", &class_id, NULL)
        && class_id == proxy_entity->class_id)
      {
        pass ("PROXY_ENTITY.class_id [BL] %u", class_id);
      }
    else
      {
        fail ("PROXY_ENTITY.class_id [BL] %u != %u", proxy_entity->class_id, class_id);
        error++;
      }
    class_id++;
    if (dwg_dynapi_entity_set_value (proxy_entity, "PROXY_ENTITY", "class_id", &class_id)
        && class_id == proxy_entity->class_id)
      {
        pass ("PROXY_ENTITY.class_id [BL] set+1 %u", class_id);
      }
    else
      {
        fail ("PROXY_ENTITY.class_id [BL] set+1 %u != %u", proxy_entity->class_id, class_id);
        error++;
      }
    proxy_entity->class_id--;

  }
  {
    BITCODE_TV data;
    if (dwg_dynapi_entity_value(proxy_entity, "PROXY_ENTITY", "data", &data, NULL)
        && !strcmp ((char *)data, (char *)proxy_entity->data))
      {
        pass ("PROXY_ENTITY.data [TV] '%s' <> '%s'", data, proxy_entity->data);
      }
    else
      {
        fail ("PROXY_ENTITY.data [TV] '%s' <> '%s'", data, proxy_entity->data);
        error++;
      }
  }
  {
    BITCODE_B from_dxf;
    if (dwg_dynapi_entity_value(proxy_entity, "PROXY_ENTITY", "from_dxf", &from_dxf, NULL)
        && from_dxf == proxy_entity->from_dxf)
      {
        pass ("PROXY_ENTITY.from_dxf [B] " FORMAT_B "", from_dxf);
      }
    else
      {
        fail ("PROXY_ENTITY.from_dxf [B] " FORMAT_B " != " FORMAT_B "", proxy_entity->from_dxf, from_dxf);
        error++;
      }
    from_dxf++;
    if (dwg_dynapi_entity_set_value (proxy_entity, "PROXY_ENTITY", "from_dxf", &from_dxf)
        && from_dxf == proxy_entity->from_dxf)
      {
        pass ("PROXY_ENTITY.from_dxf [B] set+1 " FORMAT_B "", from_dxf);
      }
    else
      {
        fail ("PROXY_ENTITY.from_dxf [B] set+1 " FORMAT_B " != " FORMAT_B "", proxy_entity->from_dxf, from_dxf);
        error++;
      }
    proxy_entity->from_dxf--;

  }
  {
    BITCODE_BL maint_version;
    if (dwg_dynapi_entity_value(proxy_entity, "PROXY_ENTITY", "maint_version", &maint_version, NULL)
        && maint_version == proxy_entity->maint_version)
      {
        pass ("PROXY_ENTITY.maint_version [BL] %u", maint_version);
      }
    else
      {
        fail ("PROXY_ENTITY.maint_version [BL] %u != %u", proxy_entity->maint_version, maint_version);
        error++;
      }
    maint_version++;
    if (dwg_dynapi_entity_set_value (proxy_entity, "PROXY_ENTITY", "maint_version", &maint_version)
        && maint_version == proxy_entity->maint_version)
      {
        pass ("PROXY_ENTITY.maint_version [BL] set+1 %u", maint_version);
      }
    else
      {
        fail ("PROXY_ENTITY.maint_version [BL] set+1 %u != %u", proxy_entity->maint_version, maint_version);
        error++;
      }
    proxy_entity->maint_version--;

  }
  {
    BITCODE_H* objid_object_handles;
    if (dwg_dynapi_entity_value(proxy_entity, "PROXY_ENTITY", "objid_object_handles", &objid_object_handles, NULL)
        && !memcmp (&objid_object_handles, &proxy_entity->objid_object_handles, sizeof (proxy_entity->objid_object_handles)))
      {
        pass ("PROXY_ENTITY.objid_object_handles [H*]");
      }
    else
      {
        fail ("PROXY_ENTITY.objid_object_handles [H*]");
        error++;
      }
  }
  {
    BITCODE_H ownerhandle;
    if (dwg_dynapi_entity_value(proxy_entity, "PROXY_ENTITY", "ownerhandle", &ownerhandle, NULL)
        && !memcmp (&ownerhandle, &proxy_entity->ownerhandle, sizeof (proxy_entity->ownerhandle)))
      {
        pass ("PROXY_ENTITY.ownerhandle [H]");
      }
    else
      {
        fail ("PROXY_ENTITY.ownerhandle [H]");
        error++;
      }
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(proxy_entity, "PROXY_ENTITY", "parent", &parent, NULL)
        && !memcmp (&parent, &proxy_entity->parent, sizeof (proxy_entity->parent)))
      {
        pass ("PROXY_ENTITY.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("PROXY_ENTITY.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_MS size;
    if (dwg_dynapi_entity_value(proxy_entity, "PROXY_ENTITY", "size", &size, NULL)
        && size == proxy_entity->size)
      {
        pass ("PROXY_ENTITY.size [MS] " FORMAT_MS "", size);
      }
    else
      {
        fail ("PROXY_ENTITY.size [MS] " FORMAT_MS " != " FORMAT_MS "", proxy_entity->size, size);
        error++;
      }
    if (dwg_dynapi_entity_set_value (proxy_entity, "PROXY_ENTITY", "size", &size)
        && size == proxy_entity->size)
      {
        pass ("PROXY_ENTITY.size [MS] set+1 " FORMAT_MS "", size);
      }
    else
      {
        fail ("PROXY_ENTITY.size [MS] set+1 " FORMAT_MS " != " FORMAT_MS "", proxy_entity->size, size);
        error++;
      }
    proxy_entity->size--;

  }
  {
    BITCODE_BL version;
    if (dwg_dynapi_entity_value(proxy_entity, "PROXY_ENTITY", "version", &version, NULL)
        && version == proxy_entity->version)
      {
        pass ("PROXY_ENTITY.version [BL] %u", version);
      }
    else
      {
        fail ("PROXY_ENTITY.version [BL] %u != %u", proxy_entity->version, version);
        error++;
      }
    version++;
    if (dwg_dynapi_entity_set_value (proxy_entity, "PROXY_ENTITY", "version", &version)
        && version == proxy_entity->version)
      {
        pass ("PROXY_ENTITY.version [BL] set+1 %u", version);
      }
    else
      {
        fail ("PROXY_ENTITY.version [BL] set+1 %u != %u", proxy_entity->version, version);
        error++;
      }
    proxy_entity->version--;

  }
  return error;
}
static int test_RAY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_RAY *restrict ray = obj->tio.entity->tio.RAY;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(ray, "RAY", "parent", &parent, NULL)
        && !memcmp (&parent, &ray->parent, sizeof (ray->parent)))
      {
        pass ("RAY.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("RAY.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value(ray, "RAY", "point", &point, NULL)
        && !memcmp (&point, &ray->point, sizeof (ray->point)))
      {
        pass ("RAY.point [3BD]");
      }
    else
      {
        fail ("RAY.point [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD vector;
    if (dwg_dynapi_entity_value(ray, "RAY", "vector", &vector, NULL)
        && !memcmp (&vector, &ray->vector, sizeof (ray->vector)))
      {
        pass ("RAY.vector [3BD]");
      }
    else
      {
        fail ("RAY.vector [3BD]");
        error++;
      }
  }
  return error;
}
static int test_REVOLVEDSURFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_REVOLVEDSURFACE *restrict revolvedsurface = obj->tio.entity->tio.REVOLVEDSURFACE;
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "acis_data", &acis_data, NULL)
        && !strcmp ((char *)acis_data, (char *)revolvedsurface->acis_data))
      {
        pass ("REVOLVEDSURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, revolvedsurface->acis_data);
      }
    else
      {
        fail ("REVOLVEDSURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, revolvedsurface->acis_data);
        error++;
      }
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "acis_empty", &acis_empty, NULL)
        && acis_empty == revolvedsurface->acis_empty)
      {
        pass ("REVOLVEDSURFACE.acis_empty [B] " FORMAT_B "", acis_empty);
      }
    else
      {
        fail ("REVOLVEDSURFACE.acis_empty [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->acis_empty, acis_empty);
        error++;
      }
    acis_empty++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "acis_empty", &acis_empty)
        && acis_empty == revolvedsurface->acis_empty)
      {
        pass ("REVOLVEDSURFACE.acis_empty [B] set+1 " FORMAT_B "", acis_empty);
      }
    else
      {
        fail ("REVOLVEDSURFACE.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->acis_empty, acis_empty);
        error++;
      }
    revolvedsurface->acis_empty--;

  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == revolvedsurface->acis_empty2)
      {
        pass ("REVOLVEDSURFACE.acis_empty2 [B] " FORMAT_B "", acis_empty2);
      }
    else
      {
        fail ("REVOLVEDSURFACE.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->acis_empty2, acis_empty2);
        error++;
      }
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "acis_empty2", &acis_empty2)
        && acis_empty2 == revolvedsurface->acis_empty2)
      {
        pass ("REVOLVEDSURFACE.acis_empty2 [B] set+1 " FORMAT_B "", acis_empty2);
      }
    else
      {
        fail ("REVOLVEDSURFACE.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->acis_empty2, acis_empty2);
        error++;
      }
    revolvedsurface->acis_empty2--;

  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == revolvedsurface->acis_empty_bit)
      {
        pass ("REVOLVEDSURFACE.acis_empty_bit [B] " FORMAT_B "", acis_empty_bit);
      }
    else
      {
        fail ("REVOLVEDSURFACE.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->acis_empty_bit, acis_empty_bit);
        error++;
      }
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "acis_empty_bit", &acis_empty_bit)
        && acis_empty_bit == revolvedsurface->acis_empty_bit)
      {
        pass ("REVOLVEDSURFACE.acis_empty_bit [B] set+1 " FORMAT_B "", acis_empty_bit);
      }
    else
      {
        fail ("REVOLVEDSURFACE.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->acis_empty_bit, acis_empty_bit);
        error++;
      }
    revolvedsurface->acis_empty_bit--;

  }
  {
    BITCODE_3BD axis_point;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "axis_point", &axis_point, NULL)
        && !memcmp (&axis_point, &revolvedsurface->axis_point, sizeof (revolvedsurface->axis_point)))
      {
        pass ("REVOLVEDSURFACE.axis_point [3BD]");
      }
    else
      {
        fail ("REVOLVEDSURFACE.axis_point [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD axis_vector;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "axis_vector", &axis_vector, NULL)
        && !memcmp (&axis_vector, &revolvedsurface->axis_vector, sizeof (revolvedsurface->axis_vector)))
      {
        pass ("REVOLVEDSURFACE.axis_vector [3BD]");
      }
    else
      {
        fail ("REVOLVEDSURFACE.axis_vector [3BD]");
        error++;
      }
  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &revolvedsurface->block_size, sizeof (revolvedsurface->block_size)))
      {
        pass ("REVOLVEDSURFACE.block_size [BL*]");
      }
    else
      {
        fail ("REVOLVEDSURFACE.block_size [BL*]");
        error++;
      }
  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "class_version", &class_version, NULL)
        && class_version == revolvedsurface->class_version)
      {
        pass ("REVOLVEDSURFACE.class_version [BL] %u", class_version);
      }
    else
      {
        fail ("REVOLVEDSURFACE.class_version [BL] %u != %u", revolvedsurface->class_version, class_version);
        error++;
      }
    class_version++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "class_version", &class_version)
        && class_version == revolvedsurface->class_version)
      {
        pass ("REVOLVEDSURFACE.class_version [BL] set+1 %u", class_version);
      }
    else
      {
        fail ("REVOLVEDSURFACE.class_version [BL] set+1 %u != %u", revolvedsurface->class_version, class_version);
        error++;
      }
    revolvedsurface->class_version--;

  }
  {
    BITCODE_B close_to_axis;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "close_to_axis", &close_to_axis, NULL)
        && close_to_axis == revolvedsurface->close_to_axis)
      {
        pass ("REVOLVEDSURFACE.close_to_axis [B] " FORMAT_B "", close_to_axis);
      }
    else
      {
        fail ("REVOLVEDSURFACE.close_to_axis [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->close_to_axis, close_to_axis);
        error++;
      }
    close_to_axis++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "close_to_axis", &close_to_axis)
        && close_to_axis == revolvedsurface->close_to_axis)
      {
        pass ("REVOLVEDSURFACE.close_to_axis [B] set+1 " FORMAT_B "", close_to_axis);
      }
    else
      {
        fail ("REVOLVEDSURFACE.close_to_axis [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->close_to_axis, close_to_axis);
        error++;
      }
    revolvedsurface->close_to_axis--;

  }
  {
    BITCODE_BD draft_angle;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "draft_angle", &draft_angle, NULL)
        && draft_angle == revolvedsurface->draft_angle)
      {
        pass ("REVOLVEDSURFACE.draft_angle [BD] %g", draft_angle);
      }
    else
      {
        fail ("REVOLVEDSURFACE.draft_angle [BD] %g != %g", revolvedsurface->draft_angle, draft_angle);
        error++;
      }
    draft_angle++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "draft_angle", &draft_angle)
        && draft_angle == revolvedsurface->draft_angle)
      {
        pass ("REVOLVEDSURFACE.draft_angle [BD] set+1 %g", draft_angle);
      }
    else
      {
        fail ("REVOLVEDSURFACE.draft_angle [BD] set+1 %g != %g", revolvedsurface->draft_angle, draft_angle);
        error++;
      }
    revolvedsurface->draft_angle--;

  }
  {
    BITCODE_BD draft_end_distance;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "draft_end_distance", &draft_end_distance, NULL)
        && draft_end_distance == revolvedsurface->draft_end_distance)
      {
        pass ("REVOLVEDSURFACE.draft_end_distance [BD] %g", draft_end_distance);
      }
    else
      {
        fail ("REVOLVEDSURFACE.draft_end_distance [BD] %g != %g", revolvedsurface->draft_end_distance, draft_end_distance);
        error++;
      }
    draft_end_distance++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "draft_end_distance", &draft_end_distance)
        && draft_end_distance == revolvedsurface->draft_end_distance)
      {
        pass ("REVOLVEDSURFACE.draft_end_distance [BD] set+1 %g", draft_end_distance);
      }
    else
      {
        fail ("REVOLVEDSURFACE.draft_end_distance [BD] set+1 %g != %g", revolvedsurface->draft_end_distance, draft_end_distance);
        error++;
      }
    revolvedsurface->draft_end_distance--;

  }
  {
    BITCODE_BD draft_start_distance;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "draft_start_distance", &draft_start_distance, NULL)
        && draft_start_distance == revolvedsurface->draft_start_distance)
      {
        pass ("REVOLVEDSURFACE.draft_start_distance [BD] %g", draft_start_distance);
      }
    else
      {
        fail ("REVOLVEDSURFACE.draft_start_distance [BD] %g != %g", revolvedsurface->draft_start_distance, draft_start_distance);
        error++;
      }
    draft_start_distance++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "draft_start_distance", &draft_start_distance)
        && draft_start_distance == revolvedsurface->draft_start_distance)
      {
        pass ("REVOLVEDSURFACE.draft_start_distance [BD] set+1 %g", draft_start_distance);
      }
    else
      {
        fail ("REVOLVEDSURFACE.draft_start_distance [BD] set+1 %g != %g", revolvedsurface->draft_start_distance, draft_start_distance);
        error++;
      }
    revolvedsurface->draft_start_distance--;

  }
  {
    char ** encr_sat_data;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "num_encr_sat_data", &count, NULL)
        && dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "encr_sat_data", &encr_sat_data, NULL)
)
      {
        pass ("REVOLVEDSURFACE.encr_sat_data [char **] * %u num_encr_sat_data", count);
      }
    else
      {
        fail ("REVOLVEDSURFACE.encr_sat_data [char **] * %u num_encr_sat_data", count);
        error++;
      }
  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &revolvedsurface->extra_acis_data, sizeof (revolvedsurface->extra_acis_data)))
      {
        pass ("REVOLVEDSURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
      }
    else
      {
        fail ("REVOLVEDSURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
        error++;
      }
  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &revolvedsurface->history_id, sizeof (revolvedsurface->history_id)))
      {
        pass ("REVOLVEDSURFACE.history_id [H]");
      }
    else
      {
        fail ("REVOLVEDSURFACE.history_id [H]");
        error++;
      }
  }
  {
    BITCODE_BL id;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "id", &id, NULL)
        && id == revolvedsurface->id)
      {
        pass ("REVOLVEDSURFACE.id [BL] %u", id);
      }
    else
      {
        fail ("REVOLVEDSURFACE.id [BL] %u != %u", revolvedsurface->id, id);
        error++;
      }
    id++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "id", &id)
        && id == revolvedsurface->id)
      {
        pass ("REVOLVEDSURFACE.id [BL] set+1 %u", id);
      }
    else
      {
        fail ("REVOLVEDSURFACE.id [BL] set+1 %u != %u", revolvedsurface->id, id);
        error++;
      }
    revolvedsurface->id--;

  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "isoline_present", &isoline_present, NULL)
        && isoline_present == revolvedsurface->isoline_present)
      {
        pass ("REVOLVEDSURFACE.isoline_present [B] " FORMAT_B "", isoline_present);
      }
    else
      {
        fail ("REVOLVEDSURFACE.isoline_present [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->isoline_present, isoline_present);
        error++;
      }
    isoline_present++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "isoline_present", &isoline_present)
        && isoline_present == revolvedsurface->isoline_present)
      {
        pass ("REVOLVEDSURFACE.isoline_present [B] set+1 " FORMAT_B "", isoline_present);
      }
    else
      {
        fail ("REVOLVEDSURFACE.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->isoline_present, isoline_present);
        error++;
      }
    revolvedsurface->isoline_present--;

  }
  {
    BITCODE_BS modeler_format_version;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "modeler_format_version", &modeler_format_version, NULL)
        && modeler_format_version == revolvedsurface->modeler_format_version)
      {
        pass ("REVOLVEDSURFACE.modeler_format_version [BS] %hu", modeler_format_version);
      }
    else
      {
        fail ("REVOLVEDSURFACE.modeler_format_version [BS] %hu != %hu", revolvedsurface->modeler_format_version, modeler_format_version);
        error++;
      }
    modeler_format_version++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "modeler_format_version", &modeler_format_version)
        && modeler_format_version == revolvedsurface->modeler_format_version)
      {
        pass ("REVOLVEDSURFACE.modeler_format_version [BS] set+1 %hu", modeler_format_version);
      }
    else
      {
        fail ("REVOLVEDSURFACE.modeler_format_version [BS] set+1 %hu != %hu", revolvedsurface->modeler_format_version, modeler_format_version);
        error++;
      }
    revolvedsurface->modeler_format_version--;

  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "num_blocks", &num_blocks, NULL)
        && num_blocks == revolvedsurface->num_blocks)
      {
        pass ("REVOLVEDSURFACE.num_blocks [BL] %u", num_blocks);
      }
    else
      {
        fail ("REVOLVEDSURFACE.num_blocks [BL] %u != %u", revolvedsurface->num_blocks, num_blocks);
        error++;
      }
    num_blocks++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "num_blocks", &num_blocks)
        && num_blocks == revolvedsurface->num_blocks)
      {
        pass ("REVOLVEDSURFACE.num_blocks [BL] set+1 %u", num_blocks);
      }
    else
      {
        fail ("REVOLVEDSURFACE.num_blocks [BL] set+1 %u != %u", revolvedsurface->num_blocks, num_blocks);
        error++;
      }
    revolvedsurface->num_blocks--;

  }
  {
    BITCODE_BL num_isolines;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "num_isolines", &num_isolines, NULL)
        && num_isolines == revolvedsurface->num_isolines)
      {
        pass ("REVOLVEDSURFACE.num_isolines [BL] %u", num_isolines);
      }
    else
      {
        fail ("REVOLVEDSURFACE.num_isolines [BL] %u != %u", revolvedsurface->num_isolines, num_isolines);
        error++;
      }
    num_isolines++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "num_isolines", &num_isolines)
        && num_isolines == revolvedsurface->num_isolines)
      {
        pass ("REVOLVEDSURFACE.num_isolines [BL] set+1 %u", num_isolines);
      }
    else
      {
        fail ("REVOLVEDSURFACE.num_isolines [BL] set+1 %u != %u", revolvedsurface->num_isolines, num_isolines);
        error++;
      }
    revolvedsurface->num_isolines--;

  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == revolvedsurface->num_silhouettes)
      {
        pass ("REVOLVEDSURFACE.num_silhouettes [BL] %u", num_silhouettes);
      }
    else
      {
        fail ("REVOLVEDSURFACE.num_silhouettes [BL] %u != %u", revolvedsurface->num_silhouettes, num_silhouettes);
        error++;
      }
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "num_silhouettes", &num_silhouettes)
        && num_silhouettes == revolvedsurface->num_silhouettes)
      {
        pass ("REVOLVEDSURFACE.num_silhouettes [BL] set+1 %u", num_silhouettes);
      }
    else
      {
        fail ("REVOLVEDSURFACE.num_silhouettes [BL] set+1 %u != %u", revolvedsurface->num_silhouettes, num_silhouettes);
        error++;
      }
    revolvedsurface->num_silhouettes--;

  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "num_wires", &num_wires, NULL)
        && num_wires == revolvedsurface->num_wires)
      {
        pass ("REVOLVEDSURFACE.num_wires [BL] %u", num_wires);
      }
    else
      {
        fail ("REVOLVEDSURFACE.num_wires [BL] %u != %u", revolvedsurface->num_wires, num_wires);
        error++;
      }
    num_wires++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "num_wires", &num_wires)
        && num_wires == revolvedsurface->num_wires)
      {
        pass ("REVOLVEDSURFACE.num_wires [BL] set+1 %u", num_wires);
      }
    else
      {
        fail ("REVOLVEDSURFACE.num_wires [BL] set+1 %u != %u", revolvedsurface->num_wires, num_wires);
        error++;
      }
    revolvedsurface->num_wires--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &revolvedsurface->parent, sizeof (revolvedsurface->parent)))
      {
        pass ("REVOLVEDSURFACE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("REVOLVEDSURFACE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "point", &point, NULL)
        && !memcmp (&point, &revolvedsurface->point, sizeof (revolvedsurface->point)))
      {
        pass ("REVOLVEDSURFACE.point [3BD]");
      }
    else
      {
        fail ("REVOLVEDSURFACE.point [3BD]");
        error++;
      }
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "point_present", &point_present, NULL)
        && point_present == revolvedsurface->point_present)
      {
        pass ("REVOLVEDSURFACE.point_present [B] " FORMAT_B "", point_present);
      }
    else
      {
        fail ("REVOLVEDSURFACE.point_present [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->point_present, point_present);
        error++;
      }
    point_present++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "point_present", &point_present)
        && point_present == revolvedsurface->point_present)
      {
        pass ("REVOLVEDSURFACE.point_present [B] set+1 " FORMAT_B "", point_present);
      }
    else
      {
        fail ("REVOLVEDSURFACE.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->point_present, point_present);
        error++;
      }
    revolvedsurface->point_present--;

  }
  {
    BITCODE_BD revolve_angle;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "revolve_angle", &revolve_angle, NULL)
        && revolve_angle == revolvedsurface->revolve_angle)
      {
        pass ("REVOLVEDSURFACE.revolve_angle [BD] %g", revolve_angle);
      }
    else
      {
        fail ("REVOLVEDSURFACE.revolve_angle [BD] %g != %g", revolvedsurface->revolve_angle, revolve_angle);
        error++;
      }
    revolve_angle++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "revolve_angle", &revolve_angle)
        && revolve_angle == revolvedsurface->revolve_angle)
      {
        pass ("REVOLVEDSURFACE.revolve_angle [BD] set+1 %g", revolve_angle);
      }
    else
      {
        fail ("REVOLVEDSURFACE.revolve_angle [BD] set+1 %g != %g", revolvedsurface->revolve_angle, revolve_angle);
        error++;
      }
    revolvedsurface->revolve_angle--;

  }
  {
    BITCODE_BD* revolved_entity_transmatrix;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "revolved_entity_transmatrix", &revolved_entity_transmatrix, NULL)
        && !memcmp (&revolved_entity_transmatrix, &revolvedsurface->revolved_entity_transmatrix, sizeof (revolvedsurface->revolved_entity_transmatrix)))
      {
        pass ("REVOLVEDSURFACE.revolved_entity_transmatrix [BD*]");
      }
    else
      {
        fail ("REVOLVEDSURFACE.revolved_entity_transmatrix [BD*]");
        error++;
      }
  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "silhouettes", &silhouettes, NULL)
        && silhouettes == revolvedsurface->silhouettes)
      {
        pass ("REVOLVEDSURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
      }
    else
      {
        fail ("REVOLVEDSURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
        error++;
      }
  }
  {
    BITCODE_B solid;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "solid", &solid, NULL)
        && solid == revolvedsurface->solid)
      {
        pass ("REVOLVEDSURFACE.solid [B] " FORMAT_B "", solid);
      }
    else
      {
        fail ("REVOLVEDSURFACE.solid [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->solid, solid);
        error++;
      }
    solid++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "solid", &solid)
        && solid == revolvedsurface->solid)
      {
        pass ("REVOLVEDSURFACE.solid [B] set+1 " FORMAT_B "", solid);
      }
    else
      {
        fail ("REVOLVEDSURFACE.solid [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->solid, solid);
        error++;
      }
    revolvedsurface->solid--;

  }
  {
    BITCODE_BD start_angle;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "start_angle", &start_angle, NULL)
        && start_angle == revolvedsurface->start_angle)
      {
        pass ("REVOLVEDSURFACE.start_angle [BD] %g", start_angle);
      }
    else
      {
        fail ("REVOLVEDSURFACE.start_angle [BD] %g != %g", revolvedsurface->start_angle, start_angle);
        error++;
      }
    start_angle++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "start_angle", &start_angle)
        && start_angle == revolvedsurface->start_angle)
      {
        pass ("REVOLVEDSURFACE.start_angle [BD] set+1 %g", start_angle);
      }
    else
      {
        fail ("REVOLVEDSURFACE.start_angle [BD] set+1 %g != %g", revolvedsurface->start_angle, start_angle);
        error++;
      }
    revolvedsurface->start_angle--;

  }
  {
    BITCODE_BD twist_angle;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "twist_angle", &twist_angle, NULL)
        && twist_angle == revolvedsurface->twist_angle)
      {
        pass ("REVOLVEDSURFACE.twist_angle [BD] %g", twist_angle);
      }
    else
      {
        fail ("REVOLVEDSURFACE.twist_angle [BD] %g != %g", revolvedsurface->twist_angle, twist_angle);
        error++;
      }
    twist_angle++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "twist_angle", &twist_angle)
        && twist_angle == revolvedsurface->twist_angle)
      {
        pass ("REVOLVEDSURFACE.twist_angle [BD] set+1 %g", twist_angle);
      }
    else
      {
        fail ("REVOLVEDSURFACE.twist_angle [BD] set+1 %g != %g", revolvedsurface->twist_angle, twist_angle);
        error++;
      }
    revolvedsurface->twist_angle--;

  }
  {
    BITCODE_BS u_isolines;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "u_isolines", &u_isolines, NULL)
        && u_isolines == revolvedsurface->u_isolines)
      {
        pass ("REVOLVEDSURFACE.u_isolines [BS] %hu", u_isolines);
      }
    else
      {
        fail ("REVOLVEDSURFACE.u_isolines [BS] %hu != %hu", revolvedsurface->u_isolines, u_isolines);
        error++;
      }
    u_isolines++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "u_isolines", &u_isolines)
        && u_isolines == revolvedsurface->u_isolines)
      {
        pass ("REVOLVEDSURFACE.u_isolines [BS] set+1 %hu", u_isolines);
      }
    else
      {
        fail ("REVOLVEDSURFACE.u_isolines [BS] set+1 %hu != %hu", revolvedsurface->u_isolines, u_isolines);
        error++;
      }
    revolvedsurface->u_isolines--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "unknown", &unknown, NULL)
        && unknown == revolvedsurface->unknown)
      {
        pass ("REVOLVEDSURFACE.unknown [B] " FORMAT_B "", unknown);
      }
    else
      {
        fail ("REVOLVEDSURFACE.unknown [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->unknown, unknown);
        error++;
      }
    unknown++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "unknown", &unknown)
        && unknown == revolvedsurface->unknown)
      {
        pass ("REVOLVEDSURFACE.unknown [B] set+1 " FORMAT_B "", unknown);
      }
    else
      {
        fail ("REVOLVEDSURFACE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->unknown, unknown);
        error++;
      }
    revolvedsurface->unknown--;

  }
  {
    BITCODE_BL unknown_2007;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "unknown_2007", &unknown_2007, NULL)
        && unknown_2007 == revolvedsurface->unknown_2007)
      {
        pass ("REVOLVEDSURFACE.unknown_2007 [BL] %u", unknown_2007);
      }
    else
      {
        fail ("REVOLVEDSURFACE.unknown_2007 [BL] %u != %u", revolvedsurface->unknown_2007, unknown_2007);
        error++;
      }
    unknown_2007++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "unknown_2007", &unknown_2007)
        && unknown_2007 == revolvedsurface->unknown_2007)
      {
        pass ("REVOLVEDSURFACE.unknown_2007 [BL] set+1 %u", unknown_2007);
      }
    else
      {
        fail ("REVOLVEDSURFACE.unknown_2007 [BL] set+1 %u != %u", revolvedsurface->unknown_2007, unknown_2007);
        error++;
      }
    revolvedsurface->unknown_2007--;

  }
  {
    BITCODE_BS v_isolines;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "v_isolines", &v_isolines, NULL)
        && v_isolines == revolvedsurface->v_isolines)
      {
        pass ("REVOLVEDSURFACE.v_isolines [BS] %hu", v_isolines);
      }
    else
      {
        fail ("REVOLVEDSURFACE.v_isolines [BS] %hu != %hu", revolvedsurface->v_isolines, v_isolines);
        error++;
      }
    v_isolines++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "v_isolines", &v_isolines)
        && v_isolines == revolvedsurface->v_isolines)
      {
        pass ("REVOLVEDSURFACE.v_isolines [BS] set+1 %hu", v_isolines);
      }
    else
      {
        fail ("REVOLVEDSURFACE.v_isolines [BS] set+1 %hu != %hu", revolvedsurface->v_isolines, v_isolines);
        error++;
      }
    revolvedsurface->v_isolines--;

  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "version", &version, NULL)
        && version == revolvedsurface->version)
      {
        pass ("REVOLVEDSURFACE.version [BS] %hu", version);
      }
    else
      {
        fail ("REVOLVEDSURFACE.version [BS] %hu != %hu", revolvedsurface->version, version);
        error++;
      }
    version++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "version", &version)
        && version == revolvedsurface->version)
      {
        pass ("REVOLVEDSURFACE.version [BS] set+1 %hu", version);
      }
    else
      {
        fail ("REVOLVEDSURFACE.version [BS] set+1 %hu != %hu", revolvedsurface->version, version);
        error++;
      }
    revolvedsurface->version--;

  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value(revolvedsurface, "REVOLVEDSURFACE", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == revolvedsurface->wireframe_data_present)
      {
        pass ("REVOLVEDSURFACE.wireframe_data_present [B] " FORMAT_B "", wireframe_data_present);
      }
    else
      {
        fail ("REVOLVEDSURFACE.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->wireframe_data_present, wireframe_data_present);
        error++;
      }
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "wireframe_data_present", &wireframe_data_present)
        && wireframe_data_present == revolvedsurface->wireframe_data_present)
      {
        pass ("REVOLVEDSURFACE.wireframe_data_present [B] set+1 " FORMAT_B "", wireframe_data_present);
      }
    else
      {
        fail ("REVOLVEDSURFACE.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->wireframe_data_present, wireframe_data_present);
        error++;
      }
    revolvedsurface->wireframe_data_present--;

  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "wires", &wires, NULL)
        && wires == revolvedsurface->wires)
      {
        pass ("REVOLVEDSURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
      }
    else
      {
        fail ("REVOLVEDSURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
        error++;
      }
  }
  return error;
}
static int test_SEQEND (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_SEQEND *restrict seqend = obj->tio.entity->tio.SEQEND;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(seqend, "SEQEND", "parent", &parent, NULL)
        && !memcmp (&parent, &seqend->parent, sizeof (seqend->parent)))
      {
        pass ("SEQEND.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("SEQEND.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  return error;
}
static int test_SHAPE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_SHAPE *restrict shape = obj->tio.entity->tio.SHAPE;
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value(shape, "SHAPE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &shape->extrusion, sizeof (shape->extrusion)))
      {
        pass ("SHAPE.extrusion [3BD]");
      }
    else
      {
        fail ("SHAPE.extrusion [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD ins_pt;
    if (dwg_dynapi_entity_value(shape, "SHAPE", "ins_pt", &ins_pt, NULL)
        && !memcmp (&ins_pt, &shape->ins_pt, sizeof (shape->ins_pt)))
      {
        pass ("SHAPE.ins_pt [3BD]");
      }
    else
      {
        fail ("SHAPE.ins_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD oblique;
    if (dwg_dynapi_entity_value(shape, "SHAPE", "oblique", &oblique, NULL)
        && oblique == shape->oblique)
      {
        pass ("SHAPE.oblique [BD] %g", oblique);
      }
    else
      {
        fail ("SHAPE.oblique [BD] %g != %g", shape->oblique, oblique);
        error++;
      }
    oblique++;
    if (dwg_dynapi_entity_set_value (shape, "SHAPE", "oblique", &oblique)
        && oblique == shape->oblique)
      {
        pass ("SHAPE.oblique [BD] set+1 %g", oblique);
      }
    else
      {
        fail ("SHAPE.oblique [BD] set+1 %g != %g", shape->oblique, oblique);
        error++;
      }
    shape->oblique--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(shape, "SHAPE", "parent", &parent, NULL)
        && !memcmp (&parent, &shape->parent, sizeof (shape->parent)))
      {
        pass ("SHAPE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("SHAPE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_BD rotation;
    if (dwg_dynapi_entity_value(shape, "SHAPE", "rotation", &rotation, NULL)
        && rotation == shape->rotation)
      {
        pass ("SHAPE.rotation [BD] %g", rotation);
      }
    else
      {
        fail ("SHAPE.rotation [BD] %g != %g", shape->rotation, rotation);
        error++;
      }
    rotation++;
    if (dwg_dynapi_entity_set_value (shape, "SHAPE", "rotation", &rotation)
        && rotation == shape->rotation)
      {
        pass ("SHAPE.rotation [BD] set+1 %g", rotation);
      }
    else
      {
        fail ("SHAPE.rotation [BD] set+1 %g != %g", shape->rotation, rotation);
        error++;
      }
    shape->rotation--;

  }
  {
    BITCODE_BD scale;
    if (dwg_dynapi_entity_value(shape, "SHAPE", "scale", &scale, NULL)
        && scale == shape->scale)
      {
        pass ("SHAPE.scale [BD] %g", scale);
      }
    else
      {
        fail ("SHAPE.scale [BD] %g != %g", shape->scale, scale);
        error++;
      }
    scale++;
    if (dwg_dynapi_entity_set_value (shape, "SHAPE", "scale", &scale)
        && scale == shape->scale)
      {
        pass ("SHAPE.scale [BD] set+1 %g", scale);
      }
    else
      {
        fail ("SHAPE.scale [BD] set+1 %g != %g", shape->scale, scale);
        error++;
      }
    shape->scale--;

  }
  {
    BITCODE_BS shape_no;
    if (dwg_dynapi_entity_value(shape, "SHAPE", "shape_no", &shape_no, NULL)
        && shape_no == shape->shape_no)
      {
        pass ("SHAPE.shape_no [BS] %hu", shape_no);
      }
    else
      {
        fail ("SHAPE.shape_no [BS] %hu != %hu", shape->shape_no, shape_no);
        error++;
      }
    shape_no++;
    if (dwg_dynapi_entity_set_value (shape, "SHAPE", "shape_no", &shape_no)
        && shape_no == shape->shape_no)
      {
        pass ("SHAPE.shape_no [BS] set+1 %hu", shape_no);
      }
    else
      {
        fail ("SHAPE.shape_no [BS] set+1 %hu != %hu", shape->shape_no, shape_no);
        error++;
      }
    shape->shape_no--;

  }
  {
    BITCODE_H style;
    if (dwg_dynapi_entity_value(shape, "SHAPE", "style", &style, NULL)
        && !memcmp (&style, &shape->style, sizeof (shape->style)))
      {
        pass ("SHAPE.style [H]");
      }
    else
      {
        fail ("SHAPE.style [H]");
        error++;
      }
  }
  {
    BITCODE_BD thickness;
    if (dwg_dynapi_entity_value(shape, "SHAPE", "thickness", &thickness, NULL)
        && thickness == shape->thickness)
      {
        pass ("SHAPE.thickness [BD] %g", thickness);
      }
    else
      {
        fail ("SHAPE.thickness [BD] %g != %g", shape->thickness, thickness);
        error++;
      }
    thickness++;
    if (dwg_dynapi_entity_set_value (shape, "SHAPE", "thickness", &thickness)
        && thickness == shape->thickness)
      {
        pass ("SHAPE.thickness [BD] set+1 %g", thickness);
      }
    else
      {
        fail ("SHAPE.thickness [BD] set+1 %g != %g", shape->thickness, thickness);
        error++;
      }
    shape->thickness--;

  }
  {
    BITCODE_BD width_factor;
    if (dwg_dynapi_entity_value(shape, "SHAPE", "width_factor", &width_factor, NULL)
        && width_factor == shape->width_factor)
      {
        pass ("SHAPE.width_factor [BD] %g", width_factor);
      }
    else
      {
        fail ("SHAPE.width_factor [BD] %g != %g", shape->width_factor, width_factor);
        error++;
      }
    width_factor++;
    if (dwg_dynapi_entity_set_value (shape, "SHAPE", "width_factor", &width_factor)
        && width_factor == shape->width_factor)
      {
        pass ("SHAPE.width_factor [BD] set+1 %g", width_factor);
      }
    else
      {
        fail ("SHAPE.width_factor [BD] set+1 %g != %g", shape->width_factor, width_factor);
        error++;
      }
    shape->width_factor--;

  }
  return error;
}
static int test_SOLID (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_SOLID *restrict solid = obj->tio.entity->tio.SOLID;
  {
    BITCODE_2RD corner1;
    if (dwg_dynapi_entity_value(solid, "SOLID", "corner1", &corner1, NULL)
        && !memcmp (&corner1, &solid->corner1, sizeof (solid->corner1)))
      {
        pass ("SOLID.corner1 [2RD]");
      }
    else
      {
        fail ("SOLID.corner1 [2RD]");
        error++;
      }
  }
  {
    BITCODE_2RD corner2;
    if (dwg_dynapi_entity_value(solid, "SOLID", "corner2", &corner2, NULL)
        && !memcmp (&corner2, &solid->corner2, sizeof (solid->corner2)))
      {
        pass ("SOLID.corner2 [2RD]");
      }
    else
      {
        fail ("SOLID.corner2 [2RD]");
        error++;
      }
  }
  {
    BITCODE_2RD corner3;
    if (dwg_dynapi_entity_value(solid, "SOLID", "corner3", &corner3, NULL)
        && !memcmp (&corner3, &solid->corner3, sizeof (solid->corner3)))
      {
        pass ("SOLID.corner3 [2RD]");
      }
    else
      {
        fail ("SOLID.corner3 [2RD]");
        error++;
      }
  }
  {
    BITCODE_2RD corner4;
    if (dwg_dynapi_entity_value(solid, "SOLID", "corner4", &corner4, NULL)
        && !memcmp (&corner4, &solid->corner4, sizeof (solid->corner4)))
      {
        pass ("SOLID.corner4 [2RD]");
      }
    else
      {
        fail ("SOLID.corner4 [2RD]");
        error++;
      }
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value(solid, "SOLID", "elevation", &elevation, NULL)
        && elevation == solid->elevation)
      {
        pass ("SOLID.elevation [BD] %g", elevation);
      }
    else
      {
        fail ("SOLID.elevation [BD] %g != %g", solid->elevation, elevation);
        error++;
      }
    elevation++;
    if (dwg_dynapi_entity_set_value (solid, "SOLID", "elevation", &elevation)
        && elevation == solid->elevation)
      {
        pass ("SOLID.elevation [BD] set+1 %g", elevation);
      }
    else
      {
        fail ("SOLID.elevation [BD] set+1 %g != %g", solid->elevation, elevation);
        error++;
      }
    solid->elevation--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value(solid, "SOLID", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &solid->extrusion, sizeof (solid->extrusion)))
      {
        pass ("SOLID.extrusion [BE]");
      }
    else
      {
        fail ("SOLID.extrusion [BE]");
        error++;
      }
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(solid, "SOLID", "parent", &parent, NULL)
        && !memcmp (&parent, &solid->parent, sizeof (solid->parent)))
      {
        pass ("SOLID.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("SOLID.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value(solid, "SOLID", "thickness", &thickness, NULL)
        && thickness == solid->thickness)
      {
        pass ("SOLID.thickness [BT] " FORMAT_BT "", thickness);
      }
    else
      {
        fail ("SOLID.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", solid->thickness, thickness);
        error++;
      }
    if (dwg_dynapi_entity_set_value (solid, "SOLID", "thickness", &thickness)
        && thickness == solid->thickness)
      {
        pass ("SOLID.thickness [BT] set+1 " FORMAT_BT "", thickness);
      }
    else
      {
        fail ("SOLID.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", solid->thickness, thickness);
        error++;
      }
    solid->thickness--;

  }
  return error;
}
static int test_SPLINE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_SPLINE *restrict spline = obj->tio.entity->tio.SPLINE;
  {
    BITCODE_3BD beg_tan_vec;
    if (dwg_dynapi_entity_value(spline, "SPLINE", "beg_tan_vec", &beg_tan_vec, NULL)
        && !memcmp (&beg_tan_vec, &spline->beg_tan_vec, sizeof (spline->beg_tan_vec)))
      {
        pass ("SPLINE.beg_tan_vec [3BD]");
      }
    else
      {
        fail ("SPLINE.beg_tan_vec [3BD]");
        error++;
      }
  }
  {
    BITCODE_B closed_b;
    if (dwg_dynapi_entity_value(spline, "SPLINE", "closed_b", &closed_b, NULL)
        && closed_b == spline->closed_b)
      {
        pass ("SPLINE.closed_b [B] " FORMAT_B "", closed_b);
      }
    else
      {
        fail ("SPLINE.closed_b [B] " FORMAT_B " != " FORMAT_B "", spline->closed_b, closed_b);
        error++;
      }
    closed_b++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "closed_b", &closed_b)
        && closed_b == spline->closed_b)
      {
        pass ("SPLINE.closed_b [B] set+1 " FORMAT_B "", closed_b);
      }
    else
      {
        fail ("SPLINE.closed_b [B] set+1 " FORMAT_B " != " FORMAT_B "", spline->closed_b, closed_b);
        error++;
      }
    spline->closed_b--;

  }
  {
    Dwg_SPLINE_control_point* ctrl_pts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "num_ctrl_pts", &count, NULL)
        && dwg_dynapi_entity_value (spline, "SPLINE", "ctrl_pts", &ctrl_pts, NULL)
        && ctrl_pts == spline->ctrl_pts)
      {
        pass ("SPLINE.ctrl_pts [Dwg_SPLINE_control_point*] * %u num_ctrl_pts", count);
      }
    else
      {
        fail ("SPLINE.ctrl_pts [Dwg_SPLINE_control_point*] * %u num_ctrl_pts", count);
        error++;
      }
  }
  {
    BITCODE_BD ctrl_tol;
    if (dwg_dynapi_entity_value(spline, "SPLINE", "ctrl_tol", &ctrl_tol, NULL)
        && ctrl_tol == spline->ctrl_tol)
      {
        pass ("SPLINE.ctrl_tol [BD] %g", ctrl_tol);
      }
    else
      {
        fail ("SPLINE.ctrl_tol [BD] %g != %g", spline->ctrl_tol, ctrl_tol);
        error++;
      }
    ctrl_tol++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "ctrl_tol", &ctrl_tol)
        && ctrl_tol == spline->ctrl_tol)
      {
        pass ("SPLINE.ctrl_tol [BD] set+1 %g", ctrl_tol);
      }
    else
      {
        fail ("SPLINE.ctrl_tol [BD] set+1 %g != %g", spline->ctrl_tol, ctrl_tol);
        error++;
      }
    spline->ctrl_tol--;

  }
  {
    BITCODE_BS degree;
    if (dwg_dynapi_entity_value(spline, "SPLINE", "degree", &degree, NULL)
        && degree == spline->degree)
      {
        pass ("SPLINE.degree [BS] %hu", degree);
      }
    else
      {
        fail ("SPLINE.degree [BS] %hu != %hu", spline->degree, degree);
        error++;
      }
    degree++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "degree", &degree)
        && degree == spline->degree)
      {
        pass ("SPLINE.degree [BS] set+1 %hu", degree);
      }
    else
      {
        fail ("SPLINE.degree [BS] set+1 %hu != %hu", spline->degree, degree);
        error++;
      }
    spline->degree--;

  }
  {
    BITCODE_3BD end_tan_vec;
    if (dwg_dynapi_entity_value(spline, "SPLINE", "end_tan_vec", &end_tan_vec, NULL)
        && !memcmp (&end_tan_vec, &spline->end_tan_vec, sizeof (spline->end_tan_vec)))
      {
        pass ("SPLINE.end_tan_vec [3BD]");
      }
    else
      {
        fail ("SPLINE.end_tan_vec [3BD]");
        error++;
      }
  }
  {
    Dwg_SPLINE_point* fit_pts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "num_fit_pts", &count, NULL)
        && dwg_dynapi_entity_value (spline, "SPLINE", "fit_pts", &fit_pts, NULL)
        && fit_pts == spline->fit_pts)
      {
        pass ("SPLINE.fit_pts [Dwg_SPLINE_point*] * %u num_fit_pts", count);
      }
    else
      {
        fail ("SPLINE.fit_pts [Dwg_SPLINE_point*] * %u num_fit_pts", count);
        error++;
      }
  }
  {
    BITCODE_BD fit_tol;
    if (dwg_dynapi_entity_value(spline, "SPLINE", "fit_tol", &fit_tol, NULL)
        && fit_tol == spline->fit_tol)
      {
        pass ("SPLINE.fit_tol [BD] %g", fit_tol);
      }
    else
      {
        fail ("SPLINE.fit_tol [BD] %g != %g", spline->fit_tol, fit_tol);
        error++;
      }
    fit_tol++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "fit_tol", &fit_tol)
        && fit_tol == spline->fit_tol)
      {
        pass ("SPLINE.fit_tol [BD] set+1 %g", fit_tol);
      }
    else
      {
        fail ("SPLINE.fit_tol [BD] set+1 %g != %g", spline->fit_tol, fit_tol);
        error++;
      }
    spline->fit_tol--;

  }
  {
    BITCODE_RS flag;
    if (dwg_dynapi_entity_value(spline, "SPLINE", "flag", &flag, NULL)
        && flag == spline->flag)
      {
        pass ("SPLINE.flag [RS] %hu", flag);
      }
    else
      {
        fail ("SPLINE.flag [RS] %hu != %hu", spline->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "flag", &flag)
        && flag == spline->flag)
      {
        pass ("SPLINE.flag [RS] set+1 %hu", flag);
      }
    else
      {
        fail ("SPLINE.flag [RS] set+1 %hu != %hu", spline->flag, flag);
        error++;
      }
    spline->flag--;

  }
  {
    BITCODE_BD knot_tol;
    if (dwg_dynapi_entity_value(spline, "SPLINE", "knot_tol", &knot_tol, NULL)
        && knot_tol == spline->knot_tol)
      {
        pass ("SPLINE.knot_tol [BD] %g", knot_tol);
      }
    else
      {
        fail ("SPLINE.knot_tol [BD] %g != %g", spline->knot_tol, knot_tol);
        error++;
      }
    knot_tol++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "knot_tol", &knot_tol)
        && knot_tol == spline->knot_tol)
      {
        pass ("SPLINE.knot_tol [BD] set+1 %g", knot_tol);
      }
    else
      {
        fail ("SPLINE.knot_tol [BD] set+1 %g != %g", spline->knot_tol, knot_tol);
        error++;
      }
    spline->knot_tol--;

  }
  {
    BITCODE_BL knotparam;
    if (dwg_dynapi_entity_value(spline, "SPLINE", "knotparam", &knotparam, NULL)
        && knotparam == spline->knotparam)
      {
        pass ("SPLINE.knotparam [BL] %u", knotparam);
      }
    else
      {
        fail ("SPLINE.knotparam [BL] %u != %u", spline->knotparam, knotparam);
        error++;
      }
    knotparam++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "knotparam", &knotparam)
        && knotparam == spline->knotparam)
      {
        pass ("SPLINE.knotparam [BL] set+1 %u", knotparam);
      }
    else
      {
        fail ("SPLINE.knotparam [BL] set+1 %u != %u", spline->knotparam, knotparam);
        error++;
      }
    spline->knotparam--;

  }
  {
    BITCODE_BD* knots;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "num_knots", &count, NULL)
        && dwg_dynapi_entity_value (spline, "SPLINE", "knots", &knots, NULL)
        && knots == spline->knots)
      {
        pass ("SPLINE.knots [BD*] * %u num_knots", count);
      }
    else
      {
        fail ("SPLINE.knots [BD*] * %u num_knots", count);
        error++;
      }
  }
  {
    BITCODE_BL num_ctrl_pts;
    if (dwg_dynapi_entity_value(spline, "SPLINE", "num_ctrl_pts", &num_ctrl_pts, NULL)
        && num_ctrl_pts == spline->num_ctrl_pts)
      {
        pass ("SPLINE.num_ctrl_pts [BL] %u", num_ctrl_pts);
      }
    else
      {
        fail ("SPLINE.num_ctrl_pts [BL] %u != %u", spline->num_ctrl_pts, num_ctrl_pts);
        error++;
      }
    num_ctrl_pts++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "num_ctrl_pts", &num_ctrl_pts)
        && num_ctrl_pts == spline->num_ctrl_pts)
      {
        pass ("SPLINE.num_ctrl_pts [BL] set+1 %u", num_ctrl_pts);
      }
    else
      {
        fail ("SPLINE.num_ctrl_pts [BL] set+1 %u != %u", spline->num_ctrl_pts, num_ctrl_pts);
        error++;
      }
    spline->num_ctrl_pts--;

  }
  {
    BITCODE_BS num_fit_pts;
    if (dwg_dynapi_entity_value(spline, "SPLINE", "num_fit_pts", &num_fit_pts, NULL)
        && num_fit_pts == spline->num_fit_pts)
      {
        pass ("SPLINE.num_fit_pts [BS] %hu", num_fit_pts);
      }
    else
      {
        fail ("SPLINE.num_fit_pts [BS] %hu != %hu", spline->num_fit_pts, num_fit_pts);
        error++;
      }
    num_fit_pts++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "num_fit_pts", &num_fit_pts)
        && num_fit_pts == spline->num_fit_pts)
      {
        pass ("SPLINE.num_fit_pts [BS] set+1 %hu", num_fit_pts);
      }
    else
      {
        fail ("SPLINE.num_fit_pts [BS] set+1 %hu != %hu", spline->num_fit_pts, num_fit_pts);
        error++;
      }
    spline->num_fit_pts--;

  }
  {
    BITCODE_BL num_knots;
    if (dwg_dynapi_entity_value(spline, "SPLINE", "num_knots", &num_knots, NULL)
        && num_knots == spline->num_knots)
      {
        pass ("SPLINE.num_knots [BL] %u", num_knots);
      }
    else
      {
        fail ("SPLINE.num_knots [BL] %u != %u", spline->num_knots, num_knots);
        error++;
      }
    num_knots++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "num_knots", &num_knots)
        && num_knots == spline->num_knots)
      {
        pass ("SPLINE.num_knots [BL] set+1 %u", num_knots);
      }
    else
      {
        fail ("SPLINE.num_knots [BL] set+1 %u != %u", spline->num_knots, num_knots);
        error++;
      }
    spline->num_knots--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(spline, "SPLINE", "parent", &parent, NULL)
        && !memcmp (&parent, &spline->parent, sizeof (spline->parent)))
      {
        pass ("SPLINE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("SPLINE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_B periodic;
    if (dwg_dynapi_entity_value(spline, "SPLINE", "periodic", &periodic, NULL)
        && periodic == spline->periodic)
      {
        pass ("SPLINE.periodic [B] " FORMAT_B "", periodic);
      }
    else
      {
        fail ("SPLINE.periodic [B] " FORMAT_B " != " FORMAT_B "", spline->periodic, periodic);
        error++;
      }
    periodic++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "periodic", &periodic)
        && periodic == spline->periodic)
      {
        pass ("SPLINE.periodic [B] set+1 " FORMAT_B "", periodic);
      }
    else
      {
        fail ("SPLINE.periodic [B] set+1 " FORMAT_B " != " FORMAT_B "", spline->periodic, periodic);
        error++;
      }
    spline->periodic--;

  }
  {
    BITCODE_B rational;
    if (dwg_dynapi_entity_value(spline, "SPLINE", "rational", &rational, NULL)
        && rational == spline->rational)
      {
        pass ("SPLINE.rational [B] " FORMAT_B "", rational);
      }
    else
      {
        fail ("SPLINE.rational [B] " FORMAT_B " != " FORMAT_B "", spline->rational, rational);
        error++;
      }
    rational++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "rational", &rational)
        && rational == spline->rational)
      {
        pass ("SPLINE.rational [B] set+1 " FORMAT_B "", rational);
      }
    else
      {
        fail ("SPLINE.rational [B] set+1 " FORMAT_B " != " FORMAT_B "", spline->rational, rational);
        error++;
      }
    spline->rational--;

  }
  {
    BITCODE_BS scenario;
    if (dwg_dynapi_entity_value(spline, "SPLINE", "scenario", &scenario, NULL)
        && scenario == spline->scenario)
      {
        pass ("SPLINE.scenario [BS] %hu", scenario);
      }
    else
      {
        fail ("SPLINE.scenario [BS] %hu != %hu", spline->scenario, scenario);
        error++;
      }
    scenario++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "scenario", &scenario)
        && scenario == spline->scenario)
      {
        pass ("SPLINE.scenario [BS] set+1 %hu", scenario);
      }
    else
      {
        fail ("SPLINE.scenario [BS] set+1 %hu != %hu", spline->scenario, scenario);
        error++;
      }
    spline->scenario--;

  }
  {
    BITCODE_BL splineflags1;
    if (dwg_dynapi_entity_value(spline, "SPLINE", "splineflags1", &splineflags1, NULL)
        && splineflags1 == spline->splineflags1)
      {
        pass ("SPLINE.splineflags1 [BL] %u", splineflags1);
      }
    else
      {
        fail ("SPLINE.splineflags1 [BL] %u != %u", spline->splineflags1, splineflags1);
        error++;
      }
    splineflags1++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "splineflags1", &splineflags1)
        && splineflags1 == spline->splineflags1)
      {
        pass ("SPLINE.splineflags1 [BL] set+1 %u", splineflags1);
      }
    else
      {
        fail ("SPLINE.splineflags1 [BL] set+1 %u != %u", spline->splineflags1, splineflags1);
        error++;
      }
    spline->splineflags1--;

  }
  {
    BITCODE_B weighted;
    if (dwg_dynapi_entity_value(spline, "SPLINE", "weighted", &weighted, NULL)
        && weighted == spline->weighted)
      {
        pass ("SPLINE.weighted [B] " FORMAT_B "", weighted);
      }
    else
      {
        fail ("SPLINE.weighted [B] " FORMAT_B " != " FORMAT_B "", spline->weighted, weighted);
        error++;
      }
    weighted++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "weighted", &weighted)
        && weighted == spline->weighted)
      {
        pass ("SPLINE.weighted [B] set+1 " FORMAT_B "", weighted);
      }
    else
      {
        fail ("SPLINE.weighted [B] set+1 " FORMAT_B " != " FORMAT_B "", spline->weighted, weighted);
        error++;
      }
    spline->weighted--;

  }
  return error;
}
static int test_SWEPTSURFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_SWEPTSURFACE *restrict sweptsurface = obj->tio.entity->tio.SWEPTSURFACE;
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "acis_data", &acis_data, NULL)
        && !strcmp ((char *)acis_data, (char *)sweptsurface->acis_data))
      {
        pass ("SWEPTSURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, sweptsurface->acis_data);
      }
    else
      {
        fail ("SWEPTSURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, sweptsurface->acis_data);
        error++;
      }
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "acis_empty", &acis_empty, NULL)
        && acis_empty == sweptsurface->acis_empty)
      {
        pass ("SWEPTSURFACE.acis_empty [B] " FORMAT_B "", acis_empty);
      }
    else
      {
        fail ("SWEPTSURFACE.acis_empty [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->acis_empty, acis_empty);
        error++;
      }
    acis_empty++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "acis_empty", &acis_empty)
        && acis_empty == sweptsurface->acis_empty)
      {
        pass ("SWEPTSURFACE.acis_empty [B] set+1 " FORMAT_B "", acis_empty);
      }
    else
      {
        fail ("SWEPTSURFACE.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->acis_empty, acis_empty);
        error++;
      }
    sweptsurface->acis_empty--;

  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == sweptsurface->acis_empty2)
      {
        pass ("SWEPTSURFACE.acis_empty2 [B] " FORMAT_B "", acis_empty2);
      }
    else
      {
        fail ("SWEPTSURFACE.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->acis_empty2, acis_empty2);
        error++;
      }
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "acis_empty2", &acis_empty2)
        && acis_empty2 == sweptsurface->acis_empty2)
      {
        pass ("SWEPTSURFACE.acis_empty2 [B] set+1 " FORMAT_B "", acis_empty2);
      }
    else
      {
        fail ("SWEPTSURFACE.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->acis_empty2, acis_empty2);
        error++;
      }
    sweptsurface->acis_empty2--;

  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == sweptsurface->acis_empty_bit)
      {
        pass ("SWEPTSURFACE.acis_empty_bit [B] " FORMAT_B "", acis_empty_bit);
      }
    else
      {
        fail ("SWEPTSURFACE.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->acis_empty_bit, acis_empty_bit);
        error++;
      }
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "acis_empty_bit", &acis_empty_bit)
        && acis_empty_bit == sweptsurface->acis_empty_bit)
      {
        pass ("SWEPTSURFACE.acis_empty_bit [B] set+1 " FORMAT_B "", acis_empty_bit);
      }
    else
      {
        fail ("SWEPTSURFACE.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->acis_empty_bit, acis_empty_bit);
        error++;
      }
    sweptsurface->acis_empty_bit--;

  }
  {
    BITCODE_BD align_angle;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "align_angle", &align_angle, NULL)
        && align_angle == sweptsurface->align_angle)
      {
        pass ("SWEPTSURFACE.align_angle [BD] %g", align_angle);
      }
    else
      {
        fail ("SWEPTSURFACE.align_angle [BD] %g != %g", sweptsurface->align_angle, align_angle);
        error++;
      }
    align_angle++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "align_angle", &align_angle)
        && align_angle == sweptsurface->align_angle)
      {
        pass ("SWEPTSURFACE.align_angle [BD] set+1 %g", align_angle);
      }
    else
      {
        fail ("SWEPTSURFACE.align_angle [BD] set+1 %g != %g", sweptsurface->align_angle, align_angle);
        error++;
      }
    sweptsurface->align_angle--;

  }
  {
    BITCODE_B align_start;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "align_start", &align_start, NULL)
        && align_start == sweptsurface->align_start)
      {
        pass ("SWEPTSURFACE.align_start [B] " FORMAT_B "", align_start);
      }
    else
      {
        fail ("SWEPTSURFACE.align_start [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->align_start, align_start);
        error++;
      }
    align_start++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "align_start", &align_start)
        && align_start == sweptsurface->align_start)
      {
        pass ("SWEPTSURFACE.align_start [B] set+1 " FORMAT_B "", align_start);
      }
    else
      {
        fail ("SWEPTSURFACE.align_start [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->align_start, align_start);
        error++;
      }
    sweptsurface->align_start--;

  }
  {
    BITCODE_B bank;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "bank", &bank, NULL)
        && bank == sweptsurface->bank)
      {
        pass ("SWEPTSURFACE.bank [B] " FORMAT_B "", bank);
      }
    else
      {
        fail ("SWEPTSURFACE.bank [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->bank, bank);
        error++;
      }
    bank++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "bank", &bank)
        && bank == sweptsurface->bank)
      {
        pass ("SWEPTSURFACE.bank [B] set+1 " FORMAT_B "", bank);
      }
    else
      {
        fail ("SWEPTSURFACE.bank [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->bank, bank);
        error++;
      }
    sweptsurface->bank--;

  }
  {
    BITCODE_B base_point_set;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "base_point_set", &base_point_set, NULL)
        && base_point_set == sweptsurface->base_point_set)
      {
        pass ("SWEPTSURFACE.base_point_set [B] " FORMAT_B "", base_point_set);
      }
    else
      {
        fail ("SWEPTSURFACE.base_point_set [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->base_point_set, base_point_set);
        error++;
      }
    base_point_set++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "base_point_set", &base_point_set)
        && base_point_set == sweptsurface->base_point_set)
      {
        pass ("SWEPTSURFACE.base_point_set [B] set+1 " FORMAT_B "", base_point_set);
      }
    else
      {
        fail ("SWEPTSURFACE.base_point_set [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->base_point_set, base_point_set);
        error++;
      }
    sweptsurface->base_point_set--;

  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &sweptsurface->block_size, sizeof (sweptsurface->block_size)))
      {
        pass ("SWEPTSURFACE.block_size [BL*]");
      }
    else
      {
        fail ("SWEPTSURFACE.block_size [BL*]");
        error++;
      }
  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "class_version", &class_version, NULL)
        && class_version == sweptsurface->class_version)
      {
        pass ("SWEPTSURFACE.class_version [BL] %u", class_version);
      }
    else
      {
        fail ("SWEPTSURFACE.class_version [BL] %u != %u", sweptsurface->class_version, class_version);
        error++;
      }
    class_version++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "class_version", &class_version)
        && class_version == sweptsurface->class_version)
      {
        pass ("SWEPTSURFACE.class_version [BL] set+1 %u", class_version);
      }
    else
      {
        fail ("SWEPTSURFACE.class_version [BL] set+1 %u != %u", sweptsurface->class_version, class_version);
        error++;
      }
    sweptsurface->class_version--;

  }
  {
    BITCODE_BD draft_angle;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "draft_angle", &draft_angle, NULL)
        && draft_angle == sweptsurface->draft_angle)
      {
        pass ("SWEPTSURFACE.draft_angle [BD] %g", draft_angle);
      }
    else
      {
        fail ("SWEPTSURFACE.draft_angle [BD] %g != %g", sweptsurface->draft_angle, draft_angle);
        error++;
      }
    draft_angle++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "draft_angle", &draft_angle)
        && draft_angle == sweptsurface->draft_angle)
      {
        pass ("SWEPTSURFACE.draft_angle [BD] set+1 %g", draft_angle);
      }
    else
      {
        fail ("SWEPTSURFACE.draft_angle [BD] set+1 %g != %g", sweptsurface->draft_angle, draft_angle);
        error++;
      }
    sweptsurface->draft_angle--;

  }
  {
    BITCODE_BD draft_end_distance;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "draft_end_distance", &draft_end_distance, NULL)
        && draft_end_distance == sweptsurface->draft_end_distance)
      {
        pass ("SWEPTSURFACE.draft_end_distance [BD] %g", draft_end_distance);
      }
    else
      {
        fail ("SWEPTSURFACE.draft_end_distance [BD] %g != %g", sweptsurface->draft_end_distance, draft_end_distance);
        error++;
      }
    draft_end_distance++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "draft_end_distance", &draft_end_distance)
        && draft_end_distance == sweptsurface->draft_end_distance)
      {
        pass ("SWEPTSURFACE.draft_end_distance [BD] set+1 %g", draft_end_distance);
      }
    else
      {
        fail ("SWEPTSURFACE.draft_end_distance [BD] set+1 %g != %g", sweptsurface->draft_end_distance, draft_end_distance);
        error++;
      }
    sweptsurface->draft_end_distance--;

  }
  {
    BITCODE_BD draft_start_distance;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "draft_start_distance", &draft_start_distance, NULL)
        && draft_start_distance == sweptsurface->draft_start_distance)
      {
        pass ("SWEPTSURFACE.draft_start_distance [BD] %g", draft_start_distance);
      }
    else
      {
        fail ("SWEPTSURFACE.draft_start_distance [BD] %g != %g", sweptsurface->draft_start_distance, draft_start_distance);
        error++;
      }
    draft_start_distance++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "draft_start_distance", &draft_start_distance)
        && draft_start_distance == sweptsurface->draft_start_distance)
      {
        pass ("SWEPTSURFACE.draft_start_distance [BD] set+1 %g", draft_start_distance);
      }
    else
      {
        fail ("SWEPTSURFACE.draft_start_distance [BD] set+1 %g != %g", sweptsurface->draft_start_distance, draft_start_distance);
        error++;
      }
    sweptsurface->draft_start_distance--;

  }
  {
    char ** encr_sat_data;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "num_encr_sat_data", &count, NULL)
        && dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "encr_sat_data", &encr_sat_data, NULL)
)
      {
        pass ("SWEPTSURFACE.encr_sat_data [char **] * %u num_encr_sat_data", count);
      }
    else
      {
        fail ("SWEPTSURFACE.encr_sat_data [char **] * %u num_encr_sat_data", count);
        error++;
      }
  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &sweptsurface->extra_acis_data, sizeof (sweptsurface->extra_acis_data)))
      {
        pass ("SWEPTSURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
      }
    else
      {
        fail ("SWEPTSURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
        error++;
      }
  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &sweptsurface->history_id, sizeof (sweptsurface->history_id)))
      {
        pass ("SWEPTSURFACE.history_id [H]");
      }
    else
      {
        fail ("SWEPTSURFACE.history_id [H]");
        error++;
      }
  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "isoline_present", &isoline_present, NULL)
        && isoline_present == sweptsurface->isoline_present)
      {
        pass ("SWEPTSURFACE.isoline_present [B] " FORMAT_B "", isoline_present);
      }
    else
      {
        fail ("SWEPTSURFACE.isoline_present [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->isoline_present, isoline_present);
        error++;
      }
    isoline_present++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "isoline_present", &isoline_present)
        && isoline_present == sweptsurface->isoline_present)
      {
        pass ("SWEPTSURFACE.isoline_present [B] set+1 " FORMAT_B "", isoline_present);
      }
    else
      {
        fail ("SWEPTSURFACE.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->isoline_present, isoline_present);
        error++;
      }
    sweptsurface->isoline_present--;

  }
  {
    BITCODE_BS modeler_format_version;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "modeler_format_version", &modeler_format_version, NULL)
        && modeler_format_version == sweptsurface->modeler_format_version)
      {
        pass ("SWEPTSURFACE.modeler_format_version [BS] %hu", modeler_format_version);
      }
    else
      {
        fail ("SWEPTSURFACE.modeler_format_version [BS] %hu != %hu", sweptsurface->modeler_format_version, modeler_format_version);
        error++;
      }
    modeler_format_version++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "modeler_format_version", &modeler_format_version)
        && modeler_format_version == sweptsurface->modeler_format_version)
      {
        pass ("SWEPTSURFACE.modeler_format_version [BS] set+1 %hu", modeler_format_version);
      }
    else
      {
        fail ("SWEPTSURFACE.modeler_format_version [BS] set+1 %hu != %hu", sweptsurface->modeler_format_version, modeler_format_version);
        error++;
      }
    sweptsurface->modeler_format_version--;

  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "num_blocks", &num_blocks, NULL)
        && num_blocks == sweptsurface->num_blocks)
      {
        pass ("SWEPTSURFACE.num_blocks [BL] %u", num_blocks);
      }
    else
      {
        fail ("SWEPTSURFACE.num_blocks [BL] %u != %u", sweptsurface->num_blocks, num_blocks);
        error++;
      }
    num_blocks++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "num_blocks", &num_blocks)
        && num_blocks == sweptsurface->num_blocks)
      {
        pass ("SWEPTSURFACE.num_blocks [BL] set+1 %u", num_blocks);
      }
    else
      {
        fail ("SWEPTSURFACE.num_blocks [BL] set+1 %u != %u", sweptsurface->num_blocks, num_blocks);
        error++;
      }
    sweptsurface->num_blocks--;

  }
  {
    BITCODE_BL num_isolines;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "num_isolines", &num_isolines, NULL)
        && num_isolines == sweptsurface->num_isolines)
      {
        pass ("SWEPTSURFACE.num_isolines [BL] %u", num_isolines);
      }
    else
      {
        fail ("SWEPTSURFACE.num_isolines [BL] %u != %u", sweptsurface->num_isolines, num_isolines);
        error++;
      }
    num_isolines++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "num_isolines", &num_isolines)
        && num_isolines == sweptsurface->num_isolines)
      {
        pass ("SWEPTSURFACE.num_isolines [BL] set+1 %u", num_isolines);
      }
    else
      {
        fail ("SWEPTSURFACE.num_isolines [BL] set+1 %u != %u", sweptsurface->num_isolines, num_isolines);
        error++;
      }
    sweptsurface->num_isolines--;

  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == sweptsurface->num_silhouettes)
      {
        pass ("SWEPTSURFACE.num_silhouettes [BL] %u", num_silhouettes);
      }
    else
      {
        fail ("SWEPTSURFACE.num_silhouettes [BL] %u != %u", sweptsurface->num_silhouettes, num_silhouettes);
        error++;
      }
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "num_silhouettes", &num_silhouettes)
        && num_silhouettes == sweptsurface->num_silhouettes)
      {
        pass ("SWEPTSURFACE.num_silhouettes [BL] set+1 %u", num_silhouettes);
      }
    else
      {
        fail ("SWEPTSURFACE.num_silhouettes [BL] set+1 %u != %u", sweptsurface->num_silhouettes, num_silhouettes);
        error++;
      }
    sweptsurface->num_silhouettes--;

  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "num_wires", &num_wires, NULL)
        && num_wires == sweptsurface->num_wires)
      {
        pass ("SWEPTSURFACE.num_wires [BL] %u", num_wires);
      }
    else
      {
        fail ("SWEPTSURFACE.num_wires [BL] %u != %u", sweptsurface->num_wires, num_wires);
        error++;
      }
    num_wires++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "num_wires", &num_wires)
        && num_wires == sweptsurface->num_wires)
      {
        pass ("SWEPTSURFACE.num_wires [BL] set+1 %u", num_wires);
      }
    else
      {
        fail ("SWEPTSURFACE.num_wires [BL] set+1 %u != %u", sweptsurface->num_wires, num_wires);
        error++;
      }
    sweptsurface->num_wires--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &sweptsurface->parent, sizeof (sweptsurface->parent)))
      {
        pass ("SWEPTSURFACE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("SWEPTSURFACE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_BL path_entity_id;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "path_entity_id", &path_entity_id, NULL)
        && path_entity_id == sweptsurface->path_entity_id)
      {
        pass ("SWEPTSURFACE.path_entity_id [BL] %u", path_entity_id);
      }
    else
      {
        fail ("SWEPTSURFACE.path_entity_id [BL] %u != %u", sweptsurface->path_entity_id, path_entity_id);
        error++;
      }
    path_entity_id++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "path_entity_id", &path_entity_id)
        && path_entity_id == sweptsurface->path_entity_id)
      {
        pass ("SWEPTSURFACE.path_entity_id [BL] set+1 %u", path_entity_id);
      }
    else
      {
        fail ("SWEPTSURFACE.path_entity_id [BL] set+1 %u != %u", sweptsurface->path_entity_id, path_entity_id);
        error++;
      }
    sweptsurface->path_entity_id--;

  }
  {
    BITCODE_B path_entity_transform_computed;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "path_entity_transform_computed", &path_entity_transform_computed, NULL)
        && path_entity_transform_computed == sweptsurface->path_entity_transform_computed)
      {
        pass ("SWEPTSURFACE.path_entity_transform_computed [B] " FORMAT_B "", path_entity_transform_computed);
      }
    else
      {
        fail ("SWEPTSURFACE.path_entity_transform_computed [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->path_entity_transform_computed, path_entity_transform_computed);
        error++;
      }
    path_entity_transform_computed++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "path_entity_transform_computed", &path_entity_transform_computed)
        && path_entity_transform_computed == sweptsurface->path_entity_transform_computed)
      {
        pass ("SWEPTSURFACE.path_entity_transform_computed [B] set+1 " FORMAT_B "", path_entity_transform_computed);
      }
    else
      {
        fail ("SWEPTSURFACE.path_entity_transform_computed [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->path_entity_transform_computed, path_entity_transform_computed);
        error++;
      }
    sweptsurface->path_entity_transform_computed--;

  }
  {
    BITCODE_BD* path_entity_transmatrix;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "path_entity_transmatrix", &path_entity_transmatrix, NULL)
        && !memcmp (&path_entity_transmatrix, &sweptsurface->path_entity_transmatrix, sizeof (sweptsurface->path_entity_transmatrix)))
      {
        pass ("SWEPTSURFACE.path_entity_transmatrix [BD*]");
      }
    else
      {
        fail ("SWEPTSURFACE.path_entity_transmatrix [BD*]");
        error++;
      }
  }
  {
    BITCODE_BD* path_entity_transmatrix1;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "path_entity_transmatrix1", &path_entity_transmatrix1, NULL)
        && !memcmp (&path_entity_transmatrix1, &sweptsurface->path_entity_transmatrix1, sizeof (sweptsurface->path_entity_transmatrix1)))
      {
        pass ("SWEPTSURFACE.path_entity_transmatrix1 [BD*]");
      }
    else
      {
        fail ("SWEPTSURFACE.path_entity_transmatrix1 [BD*]");
        error++;
      }
  }
  {
    BITCODE_TF pathdata;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "pathdata", &pathdata, NULL)
        && !memcmp (&pathdata, &sweptsurface->pathdata, sizeof (sweptsurface->pathdata)))
      {
        pass ("SWEPTSURFACE.pathdata [TF]");
      }
    else
      {
        fail ("SWEPTSURFACE.pathdata [TF]");
        error++;
      }
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "point", &point, NULL)
        && !memcmp (&point, &sweptsurface->point, sizeof (sweptsurface->point)))
      {
        pass ("SWEPTSURFACE.point [3BD]");
      }
    else
      {
        fail ("SWEPTSURFACE.point [3BD]");
        error++;
      }
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "point_present", &point_present, NULL)
        && point_present == sweptsurface->point_present)
      {
        pass ("SWEPTSURFACE.point_present [B] " FORMAT_B "", point_present);
      }
    else
      {
        fail ("SWEPTSURFACE.point_present [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->point_present, point_present);
        error++;
      }
    point_present++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "point_present", &point_present)
        && point_present == sweptsurface->point_present)
      {
        pass ("SWEPTSURFACE.point_present [B] set+1 " FORMAT_B "", point_present);
      }
    else
      {
        fail ("SWEPTSURFACE.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->point_present, point_present);
        error++;
      }
    sweptsurface->point_present--;

  }
  {
    BITCODE_3BD reference_vector_for_controlling_twist;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "reference_vector_for_controlling_twist", &reference_vector_for_controlling_twist, NULL)
        && !memcmp (&reference_vector_for_controlling_twist, &sweptsurface->reference_vector_for_controlling_twist, sizeof (sweptsurface->reference_vector_for_controlling_twist)))
      {
        pass ("SWEPTSURFACE.reference_vector_for_controlling_twist [3BD]");
      }
    else
      {
        fail ("SWEPTSURFACE.reference_vector_for_controlling_twist [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD scale_factor;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "scale_factor", &scale_factor, NULL)
        && scale_factor == sweptsurface->scale_factor)
      {
        pass ("SWEPTSURFACE.scale_factor [BD] %g", scale_factor);
      }
    else
      {
        fail ("SWEPTSURFACE.scale_factor [BD] %g != %g", sweptsurface->scale_factor, scale_factor);
        error++;
      }
    scale_factor++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "scale_factor", &scale_factor)
        && scale_factor == sweptsurface->scale_factor)
      {
        pass ("SWEPTSURFACE.scale_factor [BD] set+1 %g", scale_factor);
      }
    else
      {
        fail ("SWEPTSURFACE.scale_factor [BD] set+1 %g != %g", sweptsurface->scale_factor, scale_factor);
        error++;
      }
    sweptsurface->scale_factor--;

  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "silhouettes", &silhouettes, NULL)
        && silhouettes == sweptsurface->silhouettes)
      {
        pass ("SWEPTSURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
      }
    else
      {
        fail ("SWEPTSURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
        error++;
      }
  }
  {
    BITCODE_BL size_pathdata;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "size_pathdata", &size_pathdata, NULL)
        && size_pathdata == sweptsurface->size_pathdata)
      {
        pass ("SWEPTSURFACE.size_pathdata [BL] %u", size_pathdata);
      }
    else
      {
        fail ("SWEPTSURFACE.size_pathdata [BL] %u != %u", sweptsurface->size_pathdata, size_pathdata);
        error++;
      }
    size_pathdata++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "size_pathdata", &size_pathdata)
        && size_pathdata == sweptsurface->size_pathdata)
      {
        pass ("SWEPTSURFACE.size_pathdata [BL] set+1 %u", size_pathdata);
      }
    else
      {
        fail ("SWEPTSURFACE.size_pathdata [BL] set+1 %u != %u", sweptsurface->size_pathdata, size_pathdata);
        error++;
      }
    sweptsurface->size_pathdata--;

  }
  {
    BITCODE_BL size_sweepdata;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "size_sweepdata", &size_sweepdata, NULL)
        && size_sweepdata == sweptsurface->size_sweepdata)
      {
        pass ("SWEPTSURFACE.size_sweepdata [BL] %u", size_sweepdata);
      }
    else
      {
        fail ("SWEPTSURFACE.size_sweepdata [BL] %u != %u", sweptsurface->size_sweepdata, size_sweepdata);
        error++;
      }
    size_sweepdata++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "size_sweepdata", &size_sweepdata)
        && size_sweepdata == sweptsurface->size_sweepdata)
      {
        pass ("SWEPTSURFACE.size_sweepdata [BL] set+1 %u", size_sweepdata);
      }
    else
      {
        fail ("SWEPTSURFACE.size_sweepdata [BL] set+1 %u != %u", sweptsurface->size_sweepdata, size_sweepdata);
        error++;
      }
    sweptsurface->size_sweepdata--;

  }
  {
    BITCODE_B solid;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "solid", &solid, NULL)
        && solid == sweptsurface->solid)
      {
        pass ("SWEPTSURFACE.solid [B] " FORMAT_B "", solid);
      }
    else
      {
        fail ("SWEPTSURFACE.solid [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->solid, solid);
        error++;
      }
    solid++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "solid", &solid)
        && solid == sweptsurface->solid)
      {
        pass ("SWEPTSURFACE.solid [B] set+1 " FORMAT_B "", solid);
      }
    else
      {
        fail ("SWEPTSURFACE.solid [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->solid, solid);
        error++;
      }
    sweptsurface->solid--;

  }
  {
    BITCODE_RC sweep_alignment;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "sweep_alignment", &sweep_alignment, NULL)
        && sweep_alignment == sweptsurface->sweep_alignment)
      {
        pass ("SWEPTSURFACE.sweep_alignment [RC] %u", sweep_alignment);
      }
    else
      {
        fail ("SWEPTSURFACE.sweep_alignment [RC] %u != %u", sweptsurface->sweep_alignment, sweep_alignment);
        error++;
      }
    sweep_alignment++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "sweep_alignment", &sweep_alignment)
        && sweep_alignment == sweptsurface->sweep_alignment)
      {
        pass ("SWEPTSURFACE.sweep_alignment [RC] set+1 %u", sweep_alignment);
      }
    else
      {
        fail ("SWEPTSURFACE.sweep_alignment [RC] set+1 %u != %u", sweptsurface->sweep_alignment, sweep_alignment);
        error++;
      }
    sweptsurface->sweep_alignment--;

  }
  {
    BITCODE_BL sweep_entity_id;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "sweep_entity_id", &sweep_entity_id, NULL)
        && sweep_entity_id == sweptsurface->sweep_entity_id)
      {
        pass ("SWEPTSURFACE.sweep_entity_id [BL] %u", sweep_entity_id);
      }
    else
      {
        fail ("SWEPTSURFACE.sweep_entity_id [BL] %u != %u", sweptsurface->sweep_entity_id, sweep_entity_id);
        error++;
      }
    sweep_entity_id++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "sweep_entity_id", &sweep_entity_id)
        && sweep_entity_id == sweptsurface->sweep_entity_id)
      {
        pass ("SWEPTSURFACE.sweep_entity_id [BL] set+1 %u", sweep_entity_id);
      }
    else
      {
        fail ("SWEPTSURFACE.sweep_entity_id [BL] set+1 %u != %u", sweptsurface->sweep_entity_id, sweep_entity_id);
        error++;
      }
    sweptsurface->sweep_entity_id--;

  }
  {
    BITCODE_B sweep_entity_transform_computed;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "sweep_entity_transform_computed", &sweep_entity_transform_computed, NULL)
        && sweep_entity_transform_computed == sweptsurface->sweep_entity_transform_computed)
      {
        pass ("SWEPTSURFACE.sweep_entity_transform_computed [B] " FORMAT_B "", sweep_entity_transform_computed);
      }
    else
      {
        fail ("SWEPTSURFACE.sweep_entity_transform_computed [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->sweep_entity_transform_computed, sweep_entity_transform_computed);
        error++;
      }
    sweep_entity_transform_computed++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "sweep_entity_transform_computed", &sweep_entity_transform_computed)
        && sweep_entity_transform_computed == sweptsurface->sweep_entity_transform_computed)
      {
        pass ("SWEPTSURFACE.sweep_entity_transform_computed [B] set+1 " FORMAT_B "", sweep_entity_transform_computed);
      }
    else
      {
        fail ("SWEPTSURFACE.sweep_entity_transform_computed [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->sweep_entity_transform_computed, sweep_entity_transform_computed);
        error++;
      }
    sweptsurface->sweep_entity_transform_computed--;

  }
  {
    BITCODE_BD* sweep_entity_transmatrix;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "sweep_entity_transmatrix", &sweep_entity_transmatrix, NULL)
        && !memcmp (&sweep_entity_transmatrix, &sweptsurface->sweep_entity_transmatrix, sizeof (sweptsurface->sweep_entity_transmatrix)))
      {
        pass ("SWEPTSURFACE.sweep_entity_transmatrix [BD*]");
      }
    else
      {
        fail ("SWEPTSURFACE.sweep_entity_transmatrix [BD*]");
        error++;
      }
  }
  {
    BITCODE_BD* sweep_entity_transmatrix1;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "sweep_entity_transmatrix1", &sweep_entity_transmatrix1, NULL)
        && !memcmp (&sweep_entity_transmatrix1, &sweptsurface->sweep_entity_transmatrix1, sizeof (sweptsurface->sweep_entity_transmatrix1)))
      {
        pass ("SWEPTSURFACE.sweep_entity_transmatrix1 [BD*]");
      }
    else
      {
        fail ("SWEPTSURFACE.sweep_entity_transmatrix1 [BD*]");
        error++;
      }
  }
  {
    BITCODE_TF sweepdata;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "sweepdata", &sweepdata, NULL)
        && !memcmp (&sweepdata, &sweptsurface->sweepdata, sizeof (sweptsurface->sweepdata)))
      {
        pass ("SWEPTSURFACE.sweepdata [TF]");
      }
    else
      {
        fail ("SWEPTSURFACE.sweepdata [TF]");
        error++;
      }
  }
  {
    BITCODE_BD twist_angle;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "twist_angle", &twist_angle, NULL)
        && twist_angle == sweptsurface->twist_angle)
      {
        pass ("SWEPTSURFACE.twist_angle [BD] %g", twist_angle);
      }
    else
      {
        fail ("SWEPTSURFACE.twist_angle [BD] %g != %g", sweptsurface->twist_angle, twist_angle);
        error++;
      }
    twist_angle++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "twist_angle", &twist_angle)
        && twist_angle == sweptsurface->twist_angle)
      {
        pass ("SWEPTSURFACE.twist_angle [BD] set+1 %g", twist_angle);
      }
    else
      {
        fail ("SWEPTSURFACE.twist_angle [BD] set+1 %g != %g", sweptsurface->twist_angle, twist_angle);
        error++;
      }
    sweptsurface->twist_angle--;

  }
  {
    BITCODE_BS u_isolines;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "u_isolines", &u_isolines, NULL)
        && u_isolines == sweptsurface->u_isolines)
      {
        pass ("SWEPTSURFACE.u_isolines [BS] %hu", u_isolines);
      }
    else
      {
        fail ("SWEPTSURFACE.u_isolines [BS] %hu != %hu", sweptsurface->u_isolines, u_isolines);
        error++;
      }
    u_isolines++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "u_isolines", &u_isolines)
        && u_isolines == sweptsurface->u_isolines)
      {
        pass ("SWEPTSURFACE.u_isolines [BS] set+1 %hu", u_isolines);
      }
    else
      {
        fail ("SWEPTSURFACE.u_isolines [BS] set+1 %hu != %hu", sweptsurface->u_isolines, u_isolines);
        error++;
      }
    sweptsurface->u_isolines--;

  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "unknown", &unknown, NULL)
        && unknown == sweptsurface->unknown)
      {
        pass ("SWEPTSURFACE.unknown [B] " FORMAT_B "", unknown);
      }
    else
      {
        fail ("SWEPTSURFACE.unknown [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->unknown, unknown);
        error++;
      }
    unknown++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "unknown", &unknown)
        && unknown == sweptsurface->unknown)
      {
        pass ("SWEPTSURFACE.unknown [B] set+1 " FORMAT_B "", unknown);
      }
    else
      {
        fail ("SWEPTSURFACE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->unknown, unknown);
        error++;
      }
    sweptsurface->unknown--;

  }
  {
    BITCODE_BL unknown_2007;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "unknown_2007", &unknown_2007, NULL)
        && unknown_2007 == sweptsurface->unknown_2007)
      {
        pass ("SWEPTSURFACE.unknown_2007 [BL] %u", unknown_2007);
      }
    else
      {
        fail ("SWEPTSURFACE.unknown_2007 [BL] %u != %u", sweptsurface->unknown_2007, unknown_2007);
        error++;
      }
    unknown_2007++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "unknown_2007", &unknown_2007)
        && unknown_2007 == sweptsurface->unknown_2007)
      {
        pass ("SWEPTSURFACE.unknown_2007 [BL] set+1 %u", unknown_2007);
      }
    else
      {
        fail ("SWEPTSURFACE.unknown_2007 [BL] set+1 %u != %u", sweptsurface->unknown_2007, unknown_2007);
        error++;
      }
    sweptsurface->unknown_2007--;

  }
  {
    BITCODE_BS v_isolines;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "v_isolines", &v_isolines, NULL)
        && v_isolines == sweptsurface->v_isolines)
      {
        pass ("SWEPTSURFACE.v_isolines [BS] %hu", v_isolines);
      }
    else
      {
        fail ("SWEPTSURFACE.v_isolines [BS] %hu != %hu", sweptsurface->v_isolines, v_isolines);
        error++;
      }
    v_isolines++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "v_isolines", &v_isolines)
        && v_isolines == sweptsurface->v_isolines)
      {
        pass ("SWEPTSURFACE.v_isolines [BS] set+1 %hu", v_isolines);
      }
    else
      {
        fail ("SWEPTSURFACE.v_isolines [BS] set+1 %hu != %hu", sweptsurface->v_isolines, v_isolines);
        error++;
      }
    sweptsurface->v_isolines--;

  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "version", &version, NULL)
        && version == sweptsurface->version)
      {
        pass ("SWEPTSURFACE.version [BS] %hu", version);
      }
    else
      {
        fail ("SWEPTSURFACE.version [BS] %hu != %hu", sweptsurface->version, version);
        error++;
      }
    version++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "version", &version)
        && version == sweptsurface->version)
      {
        pass ("SWEPTSURFACE.version [BS] set+1 %hu", version);
      }
    else
      {
        fail ("SWEPTSURFACE.version [BS] set+1 %hu != %hu", sweptsurface->version, version);
        error++;
      }
    sweptsurface->version--;

  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value(sweptsurface, "SWEPTSURFACE", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == sweptsurface->wireframe_data_present)
      {
        pass ("SWEPTSURFACE.wireframe_data_present [B] " FORMAT_B "", wireframe_data_present);
      }
    else
      {
        fail ("SWEPTSURFACE.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->wireframe_data_present, wireframe_data_present);
        error++;
      }
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "wireframe_data_present", &wireframe_data_present)
        && wireframe_data_present == sweptsurface->wireframe_data_present)
      {
        pass ("SWEPTSURFACE.wireframe_data_present [B] set+1 " FORMAT_B "", wireframe_data_present);
      }
    else
      {
        fail ("SWEPTSURFACE.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->wireframe_data_present, wireframe_data_present);
        error++;
      }
    sweptsurface->wireframe_data_present--;

  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "wires", &wires, NULL)
        && wires == sweptsurface->wires)
      {
        pass ("SWEPTSURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
      }
    else
      {
        fail ("SWEPTSURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
        error++;
      }
  }
  return error;
}
static int test_TABLE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_TABLE *restrict table = obj->tio.entity->tio.TABLE;
  {
    BITCODE_H* attrib_handles;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (table, "TABLE", "attrib_handles", &attrib_handles, NULL)
        && attrib_handles == table->attrib_handles)
      {
        pass ("TABLE.attrib_handles [H*] * %u num_owned", count);
      }
    else
      {
        fail ("TABLE.attrib_handles [H*] * %u num_owned", count);
        error++;
      }
  }
  {
    BITCODE_H block_header;
    if (dwg_dynapi_entity_value(table, "TABLE", "block_header", &block_header, NULL)
        && !memcmp (&block_header, &table->block_header, sizeof (table->block_header)))
      {
        pass ("TABLE.block_header [H]");
      }
    else
      {
        fail ("TABLE.block_header [H]");
        error++;
      }
  }
  {
    BITCODE_BL border_color_overrides_flag;
    if (dwg_dynapi_entity_value(table, "TABLE", "border_color_overrides_flag", &border_color_overrides_flag, NULL)
        && border_color_overrides_flag == table->border_color_overrides_flag)
      {
        pass ("TABLE.border_color_overrides_flag [BL] %u", border_color_overrides_flag);
      }
    else
      {
        fail ("TABLE.border_color_overrides_flag [BL] %u != %u", table->border_color_overrides_flag, border_color_overrides_flag);
        error++;
      }
    border_color_overrides_flag++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "border_color_overrides_flag", &border_color_overrides_flag)
        && border_color_overrides_flag == table->border_color_overrides_flag)
      {
        pass ("TABLE.border_color_overrides_flag [BL] set+1 %u", border_color_overrides_flag);
      }
    else
      {
        fail ("TABLE.border_color_overrides_flag [BL] set+1 %u != %u", table->border_color_overrides_flag, border_color_overrides_flag);
        error++;
      }
    table->border_color_overrides_flag--;

  }
  {
    BITCODE_BL border_lineweight_overrides_flag;
    if (dwg_dynapi_entity_value(table, "TABLE", "border_lineweight_overrides_flag", &border_lineweight_overrides_flag, NULL)
        && border_lineweight_overrides_flag == table->border_lineweight_overrides_flag)
      {
        pass ("TABLE.border_lineweight_overrides_flag [BL] %u", border_lineweight_overrides_flag);
      }
    else
      {
        fail ("TABLE.border_lineweight_overrides_flag [BL] %u != %u", table->border_lineweight_overrides_flag, border_lineweight_overrides_flag);
        error++;
      }
    border_lineweight_overrides_flag++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "border_lineweight_overrides_flag", &border_lineweight_overrides_flag)
        && border_lineweight_overrides_flag == table->border_lineweight_overrides_flag)
      {
        pass ("TABLE.border_lineweight_overrides_flag [BL] set+1 %u", border_lineweight_overrides_flag);
      }
    else
      {
        fail ("TABLE.border_lineweight_overrides_flag [BL] set+1 %u != %u", table->border_lineweight_overrides_flag, border_lineweight_overrides_flag);
        error++;
      }
    table->border_lineweight_overrides_flag--;

  }
  {
    BITCODE_BL border_visibility_overrides_flag;
    if (dwg_dynapi_entity_value(table, "TABLE", "border_visibility_overrides_flag", &border_visibility_overrides_flag, NULL)
        && border_visibility_overrides_flag == table->border_visibility_overrides_flag)
      {
        pass ("TABLE.border_visibility_overrides_flag [BL] %u", border_visibility_overrides_flag);
      }
    else
      {
        fail ("TABLE.border_visibility_overrides_flag [BL] %u != %u", table->border_visibility_overrides_flag, border_visibility_overrides_flag);
        error++;
      }
    border_visibility_overrides_flag++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "border_visibility_overrides_flag", &border_visibility_overrides_flag)
        && border_visibility_overrides_flag == table->border_visibility_overrides_flag)
      {
        pass ("TABLE.border_visibility_overrides_flag [BL] set+1 %u", border_visibility_overrides_flag);
      }
    else
      {
        fail ("TABLE.border_visibility_overrides_flag [BL] set+1 %u != %u", table->border_visibility_overrides_flag, border_visibility_overrides_flag);
        error++;
      }
    table->border_visibility_overrides_flag--;

  }
  {
    BITCODE_BL break_flag;
    if (dwg_dynapi_entity_value(table, "TABLE", "break_flag", &break_flag, NULL)
        && break_flag == table->break_flag)
      {
        pass ("TABLE.break_flag [BL] %u", break_flag);
      }
    else
      {
        fail ("TABLE.break_flag [BL] %u != %u", table->break_flag, break_flag);
        error++;
      }
    break_flag++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "break_flag", &break_flag)
        && break_flag == table->break_flag)
      {
        pass ("TABLE.break_flag [BL] set+1 %u", break_flag);
      }
    else
      {
        fail ("TABLE.break_flag [BL] set+1 %u != %u", table->break_flag, break_flag);
        error++;
      }
    table->break_flag--;

  }
  {
    BITCODE_BL break_flow_direction;
    if (dwg_dynapi_entity_value(table, "TABLE", "break_flow_direction", &break_flow_direction, NULL)
        && break_flow_direction == table->break_flow_direction)
      {
        pass ("TABLE.break_flow_direction [BL] %u", break_flow_direction);
      }
    else
      {
        fail ("TABLE.break_flow_direction [BL] %u != %u", table->break_flow_direction, break_flow_direction);
        error++;
      }
    break_flow_direction++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "break_flow_direction", &break_flow_direction)
        && break_flow_direction == table->break_flow_direction)
      {
        pass ("TABLE.break_flow_direction [BL] set+1 %u", break_flow_direction);
      }
    else
      {
        fail ("TABLE.break_flow_direction [BL] set+1 %u != %u", table->break_flow_direction, break_flow_direction);
        error++;
      }
    table->break_flow_direction--;

  }
  {
    Dwg_TABLE_BreakHeight* break_heights;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_break_heights", &count, NULL)
        && dwg_dynapi_entity_value (table, "TABLE", "break_heights", &break_heights, NULL)
        && break_heights == table->break_heights)
      {
        pass ("TABLE.break_heights [Dwg_TABLE_BreakHeight*] * %u num_break_heights", count);
      }
    else
      {
        fail ("TABLE.break_heights [Dwg_TABLE_BreakHeight*] * %u num_break_heights", count);
        error++;
      }
  }
  {
    Dwg_TABLE_BreakRow* break_rows;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_break_rows", &count, NULL)
        && dwg_dynapi_entity_value (table, "TABLE", "break_rows", &break_rows, NULL)
        && break_rows == table->break_rows)
      {
        pass ("TABLE.break_rows [Dwg_TABLE_BreakRow*] * %u num_break_rows", count);
      }
    else
      {
        fail ("TABLE.break_rows [Dwg_TABLE_BreakRow*] * %u num_break_rows", count);
        error++;
      }
  }
  {
    BITCODE_BD break_spacing;
    if (dwg_dynapi_entity_value(table, "TABLE", "break_spacing", &break_spacing, NULL)
        && break_spacing == table->break_spacing)
      {
        pass ("TABLE.break_spacing [BD] %g", break_spacing);
      }
    else
      {
        fail ("TABLE.break_spacing [BD] %g != %g", table->break_spacing, break_spacing);
        error++;
      }
    break_spacing++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "break_spacing", &break_spacing)
        && break_spacing == table->break_spacing)
      {
        pass ("TABLE.break_spacing [BD] set+1 %g", break_spacing);
      }
    else
      {
        fail ("TABLE.break_spacing [BD] set+1 %g != %g", table->break_spacing, break_spacing);
        error++;
      }
    table->break_spacing--;

  }
  {
    BITCODE_BL break_unknown1;
    if (dwg_dynapi_entity_value(table, "TABLE", "break_unknown1", &break_unknown1, NULL)
        && break_unknown1 == table->break_unknown1)
      {
        pass ("TABLE.break_unknown1 [BL] %u", break_unknown1);
      }
    else
      {
        fail ("TABLE.break_unknown1 [BL] %u != %u", table->break_unknown1, break_unknown1);
        error++;
      }
    break_unknown1++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "break_unknown1", &break_unknown1)
        && break_unknown1 == table->break_unknown1)
      {
        pass ("TABLE.break_unknown1 [BL] set+1 %u", break_unknown1);
      }
    else
      {
        fail ("TABLE.break_unknown1 [BL] set+1 %u != %u", table->break_unknown1, break_unknown1);
        error++;
      }
    table->break_unknown1--;

  }
  {
    BITCODE_BL break_unknown2;
    if (dwg_dynapi_entity_value(table, "TABLE", "break_unknown2", &break_unknown2, NULL)
        && break_unknown2 == table->break_unknown2)
      {
        pass ("TABLE.break_unknown2 [BL] %u", break_unknown2);
      }
    else
      {
        fail ("TABLE.break_unknown2 [BL] %u != %u", table->break_unknown2, break_unknown2);
        error++;
      }
    break_unknown2++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "break_unknown2", &break_unknown2)
        && break_unknown2 == table->break_unknown2)
      {
        pass ("TABLE.break_unknown2 [BL] set+1 %u", break_unknown2);
      }
    else
      {
        fail ("TABLE.break_unknown2 [BL] set+1 %u != %u", table->break_unknown2, break_unknown2);
        error++;
      }
    table->break_unknown2--;

  }
  {
    Dwg_TABLE_Cell* cells;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_cells", &count, NULL)
        && dwg_dynapi_entity_value (table, "TABLE", "cells", &cells, NULL)
        && cells == table->cells)
      {
        pass ("TABLE.cells [Dwg_TABLE_Cell*] * %u num_cells", count);
      }
    else
      {
        fail ("TABLE.cells [Dwg_TABLE_Cell*] * %u num_cells", count);
        error++;
      }
  }
  {
    BITCODE_BD* col_widths;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_col_widths", &count, NULL)
        && dwg_dynapi_entity_value (table, "TABLE", "col_widths", &col_widths, NULL)
        && col_widths == table->col_widths)
      {
        pass ("TABLE.col_widths [BD*] * %u num_col_widths", count);
      }
    else
      {
        fail ("TABLE.col_widths [BD*] * %u num_col_widths", count);
        error++;
      }
  }
  {
    BITCODE_BB data_flags;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_flags", &data_flags, NULL)
        && data_flags == table->data_flags)
      {
        pass ("TABLE.data_flags [BB] " FORMAT_BB "", data_flags);
      }
    else
      {
        fail ("TABLE.data_flags [BB] " FORMAT_BB " != " FORMAT_BB "", table->data_flags, data_flags);
        error++;
      }
    data_flags++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_flags", &data_flags)
        && data_flags == table->data_flags)
      {
        pass ("TABLE.data_flags [BB] set+1 " FORMAT_BB "", data_flags);
      }
    else
      {
        fail ("TABLE.data_flags [BB] set+1 " FORMAT_BB " != " FORMAT_BB "", table->data_flags, data_flags);
        error++;
      }
    table->data_flags--;

  }
  {
    BITCODE_CMC data_horiz_bottom_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_horiz_bottom_color", &data_horiz_bottom_color, NULL)
        && !memcmp (&data_horiz_bottom_color, &table->data_horiz_bottom_color, sizeof (table->data_horiz_bottom_color)))
      {
        pass ("TABLE.data_horiz_bottom_color [CMC]");
      }
    else
      {
        fail ("TABLE.data_horiz_bottom_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS data_horiz_bottom_linewt;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_horiz_bottom_linewt", &data_horiz_bottom_linewt, NULL)
        && data_horiz_bottom_linewt == table->data_horiz_bottom_linewt)
      {
        pass ("TABLE.data_horiz_bottom_linewt [BS] %hu", data_horiz_bottom_linewt);
      }
    else
      {
        fail ("TABLE.data_horiz_bottom_linewt [BS] %hu != %hu", table->data_horiz_bottom_linewt, data_horiz_bottom_linewt);
        error++;
      }
    data_horiz_bottom_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_horiz_bottom_linewt", &data_horiz_bottom_linewt)
        && data_horiz_bottom_linewt == table->data_horiz_bottom_linewt)
      {
        pass ("TABLE.data_horiz_bottom_linewt [BS] set+1 %hu", data_horiz_bottom_linewt);
      }
    else
      {
        fail ("TABLE.data_horiz_bottom_linewt [BS] set+1 %hu != %hu", table->data_horiz_bottom_linewt, data_horiz_bottom_linewt);
        error++;
      }
    table->data_horiz_bottom_linewt--;

  }
  {
    BITCODE_BS data_horiz_bottom_visibility;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_horiz_bottom_visibility", &data_horiz_bottom_visibility, NULL)
        && data_horiz_bottom_visibility == table->data_horiz_bottom_visibility)
      {
        pass ("TABLE.data_horiz_bottom_visibility [BS] %hu", data_horiz_bottom_visibility);
      }
    else
      {
        fail ("TABLE.data_horiz_bottom_visibility [BS] %hu != %hu", table->data_horiz_bottom_visibility, data_horiz_bottom_visibility);
        error++;
      }
    data_horiz_bottom_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_horiz_bottom_visibility", &data_horiz_bottom_visibility)
        && data_horiz_bottom_visibility == table->data_horiz_bottom_visibility)
      {
        pass ("TABLE.data_horiz_bottom_visibility [BS] set+1 %hu", data_horiz_bottom_visibility);
      }
    else
      {
        fail ("TABLE.data_horiz_bottom_visibility [BS] set+1 %hu != %hu", table->data_horiz_bottom_visibility, data_horiz_bottom_visibility);
        error++;
      }
    table->data_horiz_bottom_visibility--;

  }
  {
    BITCODE_CMC data_horiz_ins_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_horiz_ins_color", &data_horiz_ins_color, NULL)
        && !memcmp (&data_horiz_ins_color, &table->data_horiz_ins_color, sizeof (table->data_horiz_ins_color)))
      {
        pass ("TABLE.data_horiz_ins_color [CMC]");
      }
    else
      {
        fail ("TABLE.data_horiz_ins_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS data_horiz_ins_linewt;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_horiz_ins_linewt", &data_horiz_ins_linewt, NULL)
        && data_horiz_ins_linewt == table->data_horiz_ins_linewt)
      {
        pass ("TABLE.data_horiz_ins_linewt [BS] %hu", data_horiz_ins_linewt);
      }
    else
      {
        fail ("TABLE.data_horiz_ins_linewt [BS] %hu != %hu", table->data_horiz_ins_linewt, data_horiz_ins_linewt);
        error++;
      }
    data_horiz_ins_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_horiz_ins_linewt", &data_horiz_ins_linewt)
        && data_horiz_ins_linewt == table->data_horiz_ins_linewt)
      {
        pass ("TABLE.data_horiz_ins_linewt [BS] set+1 %hu", data_horiz_ins_linewt);
      }
    else
      {
        fail ("TABLE.data_horiz_ins_linewt [BS] set+1 %hu != %hu", table->data_horiz_ins_linewt, data_horiz_ins_linewt);
        error++;
      }
    table->data_horiz_ins_linewt--;

  }
  {
    BITCODE_BS data_horiz_ins_visibility;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_horiz_ins_visibility", &data_horiz_ins_visibility, NULL)
        && data_horiz_ins_visibility == table->data_horiz_ins_visibility)
      {
        pass ("TABLE.data_horiz_ins_visibility [BS] %hu", data_horiz_ins_visibility);
      }
    else
      {
        fail ("TABLE.data_horiz_ins_visibility [BS] %hu != %hu", table->data_horiz_ins_visibility, data_horiz_ins_visibility);
        error++;
      }
    data_horiz_ins_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_horiz_ins_visibility", &data_horiz_ins_visibility)
        && data_horiz_ins_visibility == table->data_horiz_ins_visibility)
      {
        pass ("TABLE.data_horiz_ins_visibility [BS] set+1 %hu", data_horiz_ins_visibility);
      }
    else
      {
        fail ("TABLE.data_horiz_ins_visibility [BS] set+1 %hu != %hu", table->data_horiz_ins_visibility, data_horiz_ins_visibility);
        error++;
      }
    table->data_horiz_ins_visibility--;

  }
  {
    BITCODE_CMC data_horiz_top_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_horiz_top_color", &data_horiz_top_color, NULL)
        && !memcmp (&data_horiz_top_color, &table->data_horiz_top_color, sizeof (table->data_horiz_top_color)))
      {
        pass ("TABLE.data_horiz_top_color [CMC]");
      }
    else
      {
        fail ("TABLE.data_horiz_top_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS data_horiz_top_linewt;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_horiz_top_linewt", &data_horiz_top_linewt, NULL)
        && data_horiz_top_linewt == table->data_horiz_top_linewt)
      {
        pass ("TABLE.data_horiz_top_linewt [BS] %hu", data_horiz_top_linewt);
      }
    else
      {
        fail ("TABLE.data_horiz_top_linewt [BS] %hu != %hu", table->data_horiz_top_linewt, data_horiz_top_linewt);
        error++;
      }
    data_horiz_top_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_horiz_top_linewt", &data_horiz_top_linewt)
        && data_horiz_top_linewt == table->data_horiz_top_linewt)
      {
        pass ("TABLE.data_horiz_top_linewt [BS] set+1 %hu", data_horiz_top_linewt);
      }
    else
      {
        fail ("TABLE.data_horiz_top_linewt [BS] set+1 %hu != %hu", table->data_horiz_top_linewt, data_horiz_top_linewt);
        error++;
      }
    table->data_horiz_top_linewt--;

  }
  {
    BITCODE_BS data_horiz_top_visibility;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_horiz_top_visibility", &data_horiz_top_visibility, NULL)
        && data_horiz_top_visibility == table->data_horiz_top_visibility)
      {
        pass ("TABLE.data_horiz_top_visibility [BS] %hu", data_horiz_top_visibility);
      }
    else
      {
        fail ("TABLE.data_horiz_top_visibility [BS] %hu != %hu", table->data_horiz_top_visibility, data_horiz_top_visibility);
        error++;
      }
    data_horiz_top_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_horiz_top_visibility", &data_horiz_top_visibility)
        && data_horiz_top_visibility == table->data_horiz_top_visibility)
      {
        pass ("TABLE.data_horiz_top_visibility [BS] set+1 %hu", data_horiz_top_visibility);
      }
    else
      {
        fail ("TABLE.data_horiz_top_visibility [BS] set+1 %hu != %hu", table->data_horiz_top_visibility, data_horiz_top_visibility);
        error++;
      }
    table->data_horiz_top_visibility--;

  }
  {
    BITCODE_BS data_row_alignment;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_row_alignment", &data_row_alignment, NULL)
        && data_row_alignment == table->data_row_alignment)
      {
        pass ("TABLE.data_row_alignment [BS] %hu", data_row_alignment);
      }
    else
      {
        fail ("TABLE.data_row_alignment [BS] %hu != %hu", table->data_row_alignment, data_row_alignment);
        error++;
      }
    data_row_alignment++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_row_alignment", &data_row_alignment)
        && data_row_alignment == table->data_row_alignment)
      {
        pass ("TABLE.data_row_alignment [BS] set+1 %hu", data_row_alignment);
      }
    else
      {
        fail ("TABLE.data_row_alignment [BS] set+1 %hu != %hu", table->data_row_alignment, data_row_alignment);
        error++;
      }
    table->data_row_alignment--;

  }
  {
    BITCODE_CMC data_row_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_row_color", &data_row_color, NULL)
        && !memcmp (&data_row_color, &table->data_row_color, sizeof (table->data_row_color)))
      {
        pass ("TABLE.data_row_color [CMC]");
      }
    else
      {
        fail ("TABLE.data_row_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_CMC data_row_fill_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_row_fill_color", &data_row_fill_color, NULL)
        && !memcmp (&data_row_fill_color, &table->data_row_fill_color, sizeof (table->data_row_fill_color)))
      {
        pass ("TABLE.data_row_fill_color [CMC]");
      }
    else
      {
        fail ("TABLE.data_row_fill_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_B data_row_fill_none;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_row_fill_none", &data_row_fill_none, NULL)
        && data_row_fill_none == table->data_row_fill_none)
      {
        pass ("TABLE.data_row_fill_none [B] " FORMAT_B "", data_row_fill_none);
      }
    else
      {
        fail ("TABLE.data_row_fill_none [B] " FORMAT_B " != " FORMAT_B "", table->data_row_fill_none, data_row_fill_none);
        error++;
      }
    data_row_fill_none++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_row_fill_none", &data_row_fill_none)
        && data_row_fill_none == table->data_row_fill_none)
      {
        pass ("TABLE.data_row_fill_none [B] set+1 " FORMAT_B "", data_row_fill_none);
      }
    else
      {
        fail ("TABLE.data_row_fill_none [B] set+1 " FORMAT_B " != " FORMAT_B "", table->data_row_fill_none, data_row_fill_none);
        error++;
      }
    table->data_row_fill_none--;

  }
  {
    BITCODE_BD data_row_height;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_row_height", &data_row_height, NULL)
        && data_row_height == table->data_row_height)
      {
        pass ("TABLE.data_row_height [BD] %g", data_row_height);
      }
    else
      {
        fail ("TABLE.data_row_height [BD] %g != %g", table->data_row_height, data_row_height);
        error++;
      }
    data_row_height++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_row_height", &data_row_height)
        && data_row_height == table->data_row_height)
      {
        pass ("TABLE.data_row_height [BD] set+1 %g", data_row_height);
      }
    else
      {
        fail ("TABLE.data_row_height [BD] set+1 %g != %g", table->data_row_height, data_row_height);
        error++;
      }
    table->data_row_height--;

  }
  {
    BITCODE_H data_row_style_override;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_row_style_override", &data_row_style_override, NULL)
        && !memcmp (&data_row_style_override, &table->data_row_style_override, sizeof (table->data_row_style_override)))
      {
        pass ("TABLE.data_row_style_override [H]");
      }
    else
      {
        fail ("TABLE.data_row_style_override [H]");
        error++;
      }
  }
  {
    BITCODE_H data_text_style;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_text_style", &data_text_style, NULL)
        && !memcmp (&data_text_style, &table->data_text_style, sizeof (table->data_text_style)))
      {
        pass ("TABLE.data_text_style [H]");
      }
    else
      {
        fail ("TABLE.data_text_style [H]");
        error++;
      }
  }
  {
    BITCODE_CMC data_vert_ins_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_vert_ins_color", &data_vert_ins_color, NULL)
        && !memcmp (&data_vert_ins_color, &table->data_vert_ins_color, sizeof (table->data_vert_ins_color)))
      {
        pass ("TABLE.data_vert_ins_color [CMC]");
      }
    else
      {
        fail ("TABLE.data_vert_ins_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS data_vert_ins_linewt;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_vert_ins_linewt", &data_vert_ins_linewt, NULL)
        && data_vert_ins_linewt == table->data_vert_ins_linewt)
      {
        pass ("TABLE.data_vert_ins_linewt [BS] %hu", data_vert_ins_linewt);
      }
    else
      {
        fail ("TABLE.data_vert_ins_linewt [BS] %hu != %hu", table->data_vert_ins_linewt, data_vert_ins_linewt);
        error++;
      }
    data_vert_ins_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_vert_ins_linewt", &data_vert_ins_linewt)
        && data_vert_ins_linewt == table->data_vert_ins_linewt)
      {
        pass ("TABLE.data_vert_ins_linewt [BS] set+1 %hu", data_vert_ins_linewt);
      }
    else
      {
        fail ("TABLE.data_vert_ins_linewt [BS] set+1 %hu != %hu", table->data_vert_ins_linewt, data_vert_ins_linewt);
        error++;
      }
    table->data_vert_ins_linewt--;

  }
  {
    BITCODE_BS data_vert_ins_visibility;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_vert_ins_visibility", &data_vert_ins_visibility, NULL)
        && data_vert_ins_visibility == table->data_vert_ins_visibility)
      {
        pass ("TABLE.data_vert_ins_visibility [BS] %hu", data_vert_ins_visibility);
      }
    else
      {
        fail ("TABLE.data_vert_ins_visibility [BS] %hu != %hu", table->data_vert_ins_visibility, data_vert_ins_visibility);
        error++;
      }
    data_vert_ins_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_vert_ins_visibility", &data_vert_ins_visibility)
        && data_vert_ins_visibility == table->data_vert_ins_visibility)
      {
        pass ("TABLE.data_vert_ins_visibility [BS] set+1 %hu", data_vert_ins_visibility);
      }
    else
      {
        fail ("TABLE.data_vert_ins_visibility [BS] set+1 %hu != %hu", table->data_vert_ins_visibility, data_vert_ins_visibility);
        error++;
      }
    table->data_vert_ins_visibility--;

  }
  {
    BITCODE_CMC data_vert_left_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_vert_left_color", &data_vert_left_color, NULL)
        && !memcmp (&data_vert_left_color, &table->data_vert_left_color, sizeof (table->data_vert_left_color)))
      {
        pass ("TABLE.data_vert_left_color [CMC]");
      }
    else
      {
        fail ("TABLE.data_vert_left_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS data_vert_left_linewt;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_vert_left_linewt", &data_vert_left_linewt, NULL)
        && data_vert_left_linewt == table->data_vert_left_linewt)
      {
        pass ("TABLE.data_vert_left_linewt [BS] %hu", data_vert_left_linewt);
      }
    else
      {
        fail ("TABLE.data_vert_left_linewt [BS] %hu != %hu", table->data_vert_left_linewt, data_vert_left_linewt);
        error++;
      }
    data_vert_left_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_vert_left_linewt", &data_vert_left_linewt)
        && data_vert_left_linewt == table->data_vert_left_linewt)
      {
        pass ("TABLE.data_vert_left_linewt [BS] set+1 %hu", data_vert_left_linewt);
      }
    else
      {
        fail ("TABLE.data_vert_left_linewt [BS] set+1 %hu != %hu", table->data_vert_left_linewt, data_vert_left_linewt);
        error++;
      }
    table->data_vert_left_linewt--;

  }
  {
    BITCODE_BS data_vert_left_visibility;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_vert_left_visibility", &data_vert_left_visibility, NULL)
        && data_vert_left_visibility == table->data_vert_left_visibility)
      {
        pass ("TABLE.data_vert_left_visibility [BS] %hu", data_vert_left_visibility);
      }
    else
      {
        fail ("TABLE.data_vert_left_visibility [BS] %hu != %hu", table->data_vert_left_visibility, data_vert_left_visibility);
        error++;
      }
    data_vert_left_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_vert_left_visibility", &data_vert_left_visibility)
        && data_vert_left_visibility == table->data_vert_left_visibility)
      {
        pass ("TABLE.data_vert_left_visibility [BS] set+1 %hu", data_vert_left_visibility);
      }
    else
      {
        fail ("TABLE.data_vert_left_visibility [BS] set+1 %hu != %hu", table->data_vert_left_visibility, data_vert_left_visibility);
        error++;
      }
    table->data_vert_left_visibility--;

  }
  {
    BITCODE_CMC data_vert_right_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_vert_right_color", &data_vert_right_color, NULL)
        && !memcmp (&data_vert_right_color, &table->data_vert_right_color, sizeof (table->data_vert_right_color)))
      {
        pass ("TABLE.data_vert_right_color [CMC]");
      }
    else
      {
        fail ("TABLE.data_vert_right_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS data_vert_right_linewt;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_vert_right_linewt", &data_vert_right_linewt, NULL)
        && data_vert_right_linewt == table->data_vert_right_linewt)
      {
        pass ("TABLE.data_vert_right_linewt [BS] %hu", data_vert_right_linewt);
      }
    else
      {
        fail ("TABLE.data_vert_right_linewt [BS] %hu != %hu", table->data_vert_right_linewt, data_vert_right_linewt);
        error++;
      }
    data_vert_right_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_vert_right_linewt", &data_vert_right_linewt)
        && data_vert_right_linewt == table->data_vert_right_linewt)
      {
        pass ("TABLE.data_vert_right_linewt [BS] set+1 %hu", data_vert_right_linewt);
      }
    else
      {
        fail ("TABLE.data_vert_right_linewt [BS] set+1 %hu != %hu", table->data_vert_right_linewt, data_vert_right_linewt);
        error++;
      }
    table->data_vert_right_linewt--;

  }
  {
    BITCODE_BS data_vert_right_visibility;
    if (dwg_dynapi_entity_value(table, "TABLE", "data_vert_right_visibility", &data_vert_right_visibility, NULL)
        && data_vert_right_visibility == table->data_vert_right_visibility)
      {
        pass ("TABLE.data_vert_right_visibility [BS] %hu", data_vert_right_visibility);
      }
    else
      {
        fail ("TABLE.data_vert_right_visibility [BS] %hu != %hu", table->data_vert_right_visibility, data_vert_right_visibility);
        error++;
      }
    data_vert_right_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_vert_right_visibility", &data_vert_right_visibility)
        && data_vert_right_visibility == table->data_vert_right_visibility)
      {
        pass ("TABLE.data_vert_right_visibility [BS] set+1 %hu", data_vert_right_visibility);
      }
    else
      {
        fail ("TABLE.data_vert_right_visibility [BS] set+1 %hu != %hu", table->data_vert_right_visibility, data_vert_right_visibility);
        error++;
      }
    table->data_vert_right_visibility--;

  }
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value(table, "TABLE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &table->extrusion, sizeof (table->extrusion)))
      {
        pass ("TABLE.extrusion [3BD]");
      }
    else
      {
        fail ("TABLE.extrusion [3BD]");
        error++;
      }
  }
  {
    BITCODE_H first_attrib;
    if (dwg_dynapi_entity_value(table, "TABLE", "first_attrib", &first_attrib, NULL)
        && !memcmp (&first_attrib, &table->first_attrib, sizeof (table->first_attrib)))
      {
        pass ("TABLE.first_attrib [H]");
      }
    else
      {
        fail ("TABLE.first_attrib [H]");
        error++;
      }
  }
  {
    BITCODE_BS flag_for_table_value;
    if (dwg_dynapi_entity_value(table, "TABLE", "flag_for_table_value", &flag_for_table_value, NULL)
        && flag_for_table_value == table->flag_for_table_value)
      {
        pass ("TABLE.flag_for_table_value [BS] %hu", flag_for_table_value);
      }
    else
      {
        fail ("TABLE.flag_for_table_value [BS] %hu != %hu", table->flag_for_table_value, flag_for_table_value);
        error++;
      }
    flag_for_table_value++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "flag_for_table_value", &flag_for_table_value)
        && flag_for_table_value == table->flag_for_table_value)
      {
        pass ("TABLE.flag_for_table_value [BS] set+1 %hu", flag_for_table_value);
      }
    else
      {
        fail ("TABLE.flag_for_table_value [BS] set+1 %hu != %hu", table->flag_for_table_value, flag_for_table_value);
        error++;
      }
    table->flag_for_table_value--;

  }
  {
    BITCODE_BS flow_direction;
    if (dwg_dynapi_entity_value(table, "TABLE", "flow_direction", &flow_direction, NULL)
        && flow_direction == table->flow_direction)
      {
        pass ("TABLE.flow_direction [BS] %hu", flow_direction);
      }
    else
      {
        fail ("TABLE.flow_direction [BS] %hu != %hu", table->flow_direction, flow_direction);
        error++;
      }
    flow_direction++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "flow_direction", &flow_direction)
        && flow_direction == table->flow_direction)
      {
        pass ("TABLE.flow_direction [BS] set+1 %hu", flow_direction);
      }
    else
      {
        fail ("TABLE.flow_direction [BS] set+1 %hu != %hu", table->flow_direction, flow_direction);
        error++;
      }
    table->flow_direction--;

  }
  {
    BITCODE_B has_attribs;
    if (dwg_dynapi_entity_value(table, "TABLE", "has_attribs", &has_attribs, NULL)
        && has_attribs == table->has_attribs)
      {
        pass ("TABLE.has_attribs [B] " FORMAT_B "", has_attribs);
      }
    else
      {
        fail ("TABLE.has_attribs [B] " FORMAT_B " != " FORMAT_B "", table->has_attribs, has_attribs);
        error++;
      }
    has_attribs++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "has_attribs", &has_attribs)
        && has_attribs == table->has_attribs)
      {
        pass ("TABLE.has_attribs [B] set+1 " FORMAT_B "", has_attribs);
      }
    else
      {
        fail ("TABLE.has_attribs [B] set+1 " FORMAT_B " != " FORMAT_B "", table->has_attribs, has_attribs);
        error++;
      }
    table->has_attribs--;

  }
  {
    BITCODE_B has_border_color_overrides;
    if (dwg_dynapi_entity_value(table, "TABLE", "has_border_color_overrides", &has_border_color_overrides, NULL)
        && has_border_color_overrides == table->has_border_color_overrides)
      {
        pass ("TABLE.has_border_color_overrides [B] " FORMAT_B "", has_border_color_overrides);
      }
    else
      {
        fail ("TABLE.has_border_color_overrides [B] " FORMAT_B " != " FORMAT_B "", table->has_border_color_overrides, has_border_color_overrides);
        error++;
      }
    has_border_color_overrides++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "has_border_color_overrides", &has_border_color_overrides)
        && has_border_color_overrides == table->has_border_color_overrides)
      {
        pass ("TABLE.has_border_color_overrides [B] set+1 " FORMAT_B "", has_border_color_overrides);
      }
    else
      {
        fail ("TABLE.has_border_color_overrides [B] set+1 " FORMAT_B " != " FORMAT_B "", table->has_border_color_overrides, has_border_color_overrides);
        error++;
      }
    table->has_border_color_overrides--;

  }
  {
    BITCODE_B has_border_lineweight_overrides;
    if (dwg_dynapi_entity_value(table, "TABLE", "has_border_lineweight_overrides", &has_border_lineweight_overrides, NULL)
        && has_border_lineweight_overrides == table->has_border_lineweight_overrides)
      {
        pass ("TABLE.has_border_lineweight_overrides [B] " FORMAT_B "", has_border_lineweight_overrides);
      }
    else
      {
        fail ("TABLE.has_border_lineweight_overrides [B] " FORMAT_B " != " FORMAT_B "", table->has_border_lineweight_overrides, has_border_lineweight_overrides);
        error++;
      }
    has_border_lineweight_overrides++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "has_border_lineweight_overrides", &has_border_lineweight_overrides)
        && has_border_lineweight_overrides == table->has_border_lineweight_overrides)
      {
        pass ("TABLE.has_border_lineweight_overrides [B] set+1 " FORMAT_B "", has_border_lineweight_overrides);
      }
    else
      {
        fail ("TABLE.has_border_lineweight_overrides [B] set+1 " FORMAT_B " != " FORMAT_B "", table->has_border_lineweight_overrides, has_border_lineweight_overrides);
        error++;
      }
    table->has_border_lineweight_overrides--;

  }
  {
    BITCODE_B has_border_visibility_overrides;
    if (dwg_dynapi_entity_value(table, "TABLE", "has_border_visibility_overrides", &has_border_visibility_overrides, NULL)
        && has_border_visibility_overrides == table->has_border_visibility_overrides)
      {
        pass ("TABLE.has_border_visibility_overrides [B] " FORMAT_B "", has_border_visibility_overrides);
      }
    else
      {
        fail ("TABLE.has_border_visibility_overrides [B] " FORMAT_B " != " FORMAT_B "", table->has_border_visibility_overrides, has_border_visibility_overrides);
        error++;
      }
    has_border_visibility_overrides++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "has_border_visibility_overrides", &has_border_visibility_overrides)
        && has_border_visibility_overrides == table->has_border_visibility_overrides)
      {
        pass ("TABLE.has_border_visibility_overrides [B] set+1 " FORMAT_B "", has_border_visibility_overrides);
      }
    else
      {
        fail ("TABLE.has_border_visibility_overrides [B] set+1 " FORMAT_B " != " FORMAT_B "", table->has_border_visibility_overrides, has_border_visibility_overrides);
        error++;
      }
    table->has_border_visibility_overrides--;

  }
  {
    BITCODE_BL has_break_data;
    if (dwg_dynapi_entity_value(table, "TABLE", "has_break_data", &has_break_data, NULL)
        && has_break_data == table->has_break_data)
      {
        pass ("TABLE.has_break_data [BL] %u", has_break_data);
      }
    else
      {
        fail ("TABLE.has_break_data [BL] %u != %u", table->has_break_data, has_break_data);
        error++;
      }
    has_break_data++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "has_break_data", &has_break_data)
        && has_break_data == table->has_break_data)
      {
        pass ("TABLE.has_break_data [BL] set+1 %u", has_break_data);
      }
    else
      {
        fail ("TABLE.has_break_data [BL] set+1 %u != %u", table->has_break_data, has_break_data);
        error++;
      }
    table->has_break_data--;

  }
  {
    BITCODE_B has_table_overrides;
    if (dwg_dynapi_entity_value(table, "TABLE", "has_table_overrides", &has_table_overrides, NULL)
        && has_table_overrides == table->has_table_overrides)
      {
        pass ("TABLE.has_table_overrides [B] " FORMAT_B "", has_table_overrides);
      }
    else
      {
        fail ("TABLE.has_table_overrides [B] " FORMAT_B " != " FORMAT_B "", table->has_table_overrides, has_table_overrides);
        error++;
      }
    has_table_overrides++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "has_table_overrides", &has_table_overrides)
        && has_table_overrides == table->has_table_overrides)
      {
        pass ("TABLE.has_table_overrides [B] set+1 " FORMAT_B "", has_table_overrides);
      }
    else
      {
        fail ("TABLE.has_table_overrides [B] set+1 " FORMAT_B " != " FORMAT_B "", table->has_table_overrides, has_table_overrides);
        error++;
      }
    table->has_table_overrides--;

  }
  {
    BITCODE_CMC header_horiz_bottom_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_horiz_bottom_color", &header_horiz_bottom_color, NULL)
        && !memcmp (&header_horiz_bottom_color, &table->header_horiz_bottom_color, sizeof (table->header_horiz_bottom_color)))
      {
        pass ("TABLE.header_horiz_bottom_color [CMC]");
      }
    else
      {
        fail ("TABLE.header_horiz_bottom_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS header_horiz_bottom_linewt;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_horiz_bottom_linewt", &header_horiz_bottom_linewt, NULL)
        && header_horiz_bottom_linewt == table->header_horiz_bottom_linewt)
      {
        pass ("TABLE.header_horiz_bottom_linewt [BS] %hu", header_horiz_bottom_linewt);
      }
    else
      {
        fail ("TABLE.header_horiz_bottom_linewt [BS] %hu != %hu", table->header_horiz_bottom_linewt, header_horiz_bottom_linewt);
        error++;
      }
    header_horiz_bottom_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_horiz_bottom_linewt", &header_horiz_bottom_linewt)
        && header_horiz_bottom_linewt == table->header_horiz_bottom_linewt)
      {
        pass ("TABLE.header_horiz_bottom_linewt [BS] set+1 %hu", header_horiz_bottom_linewt);
      }
    else
      {
        fail ("TABLE.header_horiz_bottom_linewt [BS] set+1 %hu != %hu", table->header_horiz_bottom_linewt, header_horiz_bottom_linewt);
        error++;
      }
    table->header_horiz_bottom_linewt--;

  }
  {
    BITCODE_BS header_horiz_bottom_visibility;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_horiz_bottom_visibility", &header_horiz_bottom_visibility, NULL)
        && header_horiz_bottom_visibility == table->header_horiz_bottom_visibility)
      {
        pass ("TABLE.header_horiz_bottom_visibility [BS] %hu", header_horiz_bottom_visibility);
      }
    else
      {
        fail ("TABLE.header_horiz_bottom_visibility [BS] %hu != %hu", table->header_horiz_bottom_visibility, header_horiz_bottom_visibility);
        error++;
      }
    header_horiz_bottom_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_horiz_bottom_visibility", &header_horiz_bottom_visibility)
        && header_horiz_bottom_visibility == table->header_horiz_bottom_visibility)
      {
        pass ("TABLE.header_horiz_bottom_visibility [BS] set+1 %hu", header_horiz_bottom_visibility);
      }
    else
      {
        fail ("TABLE.header_horiz_bottom_visibility [BS] set+1 %hu != %hu", table->header_horiz_bottom_visibility, header_horiz_bottom_visibility);
        error++;
      }
    table->header_horiz_bottom_visibility--;

  }
  {
    BITCODE_CMC header_horiz_ins_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_horiz_ins_color", &header_horiz_ins_color, NULL)
        && !memcmp (&header_horiz_ins_color, &table->header_horiz_ins_color, sizeof (table->header_horiz_ins_color)))
      {
        pass ("TABLE.header_horiz_ins_color [CMC]");
      }
    else
      {
        fail ("TABLE.header_horiz_ins_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS header_horiz_ins_linewt;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_horiz_ins_linewt", &header_horiz_ins_linewt, NULL)
        && header_horiz_ins_linewt == table->header_horiz_ins_linewt)
      {
        pass ("TABLE.header_horiz_ins_linewt [BS] %hu", header_horiz_ins_linewt);
      }
    else
      {
        fail ("TABLE.header_horiz_ins_linewt [BS] %hu != %hu", table->header_horiz_ins_linewt, header_horiz_ins_linewt);
        error++;
      }
    header_horiz_ins_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_horiz_ins_linewt", &header_horiz_ins_linewt)
        && header_horiz_ins_linewt == table->header_horiz_ins_linewt)
      {
        pass ("TABLE.header_horiz_ins_linewt [BS] set+1 %hu", header_horiz_ins_linewt);
      }
    else
      {
        fail ("TABLE.header_horiz_ins_linewt [BS] set+1 %hu != %hu", table->header_horiz_ins_linewt, header_horiz_ins_linewt);
        error++;
      }
    table->header_horiz_ins_linewt--;

  }
  {
    BITCODE_BS header_horiz_ins_visibility;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_horiz_ins_visibility", &header_horiz_ins_visibility, NULL)
        && header_horiz_ins_visibility == table->header_horiz_ins_visibility)
      {
        pass ("TABLE.header_horiz_ins_visibility [BS] %hu", header_horiz_ins_visibility);
      }
    else
      {
        fail ("TABLE.header_horiz_ins_visibility [BS] %hu != %hu", table->header_horiz_ins_visibility, header_horiz_ins_visibility);
        error++;
      }
    header_horiz_ins_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_horiz_ins_visibility", &header_horiz_ins_visibility)
        && header_horiz_ins_visibility == table->header_horiz_ins_visibility)
      {
        pass ("TABLE.header_horiz_ins_visibility [BS] set+1 %hu", header_horiz_ins_visibility);
      }
    else
      {
        fail ("TABLE.header_horiz_ins_visibility [BS] set+1 %hu != %hu", table->header_horiz_ins_visibility, header_horiz_ins_visibility);
        error++;
      }
    table->header_horiz_ins_visibility--;

  }
  {
    BITCODE_CMC header_horiz_top_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_horiz_top_color", &header_horiz_top_color, NULL)
        && !memcmp (&header_horiz_top_color, &table->header_horiz_top_color, sizeof (table->header_horiz_top_color)))
      {
        pass ("TABLE.header_horiz_top_color [CMC]");
      }
    else
      {
        fail ("TABLE.header_horiz_top_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS header_horiz_top_linewt;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_horiz_top_linewt", &header_horiz_top_linewt, NULL)
        && header_horiz_top_linewt == table->header_horiz_top_linewt)
      {
        pass ("TABLE.header_horiz_top_linewt [BS] %hu", header_horiz_top_linewt);
      }
    else
      {
        fail ("TABLE.header_horiz_top_linewt [BS] %hu != %hu", table->header_horiz_top_linewt, header_horiz_top_linewt);
        error++;
      }
    header_horiz_top_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_horiz_top_linewt", &header_horiz_top_linewt)
        && header_horiz_top_linewt == table->header_horiz_top_linewt)
      {
        pass ("TABLE.header_horiz_top_linewt [BS] set+1 %hu", header_horiz_top_linewt);
      }
    else
      {
        fail ("TABLE.header_horiz_top_linewt [BS] set+1 %hu != %hu", table->header_horiz_top_linewt, header_horiz_top_linewt);
        error++;
      }
    table->header_horiz_top_linewt--;

  }
  {
    BITCODE_BS header_horiz_top_visibility;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_horiz_top_visibility", &header_horiz_top_visibility, NULL)
        && header_horiz_top_visibility == table->header_horiz_top_visibility)
      {
        pass ("TABLE.header_horiz_top_visibility [BS] %hu", header_horiz_top_visibility);
      }
    else
      {
        fail ("TABLE.header_horiz_top_visibility [BS] %hu != %hu", table->header_horiz_top_visibility, header_horiz_top_visibility);
        error++;
      }
    header_horiz_top_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_horiz_top_visibility", &header_horiz_top_visibility)
        && header_horiz_top_visibility == table->header_horiz_top_visibility)
      {
        pass ("TABLE.header_horiz_top_visibility [BS] set+1 %hu", header_horiz_top_visibility);
      }
    else
      {
        fail ("TABLE.header_horiz_top_visibility [BS] set+1 %hu != %hu", table->header_horiz_top_visibility, header_horiz_top_visibility);
        error++;
      }
    table->header_horiz_top_visibility--;

  }
  {
    BITCODE_BS header_row_alignment;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_row_alignment", &header_row_alignment, NULL)
        && header_row_alignment == table->header_row_alignment)
      {
        pass ("TABLE.header_row_alignment [BS] %hu", header_row_alignment);
      }
    else
      {
        fail ("TABLE.header_row_alignment [BS] %hu != %hu", table->header_row_alignment, header_row_alignment);
        error++;
      }
    header_row_alignment++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_row_alignment", &header_row_alignment)
        && header_row_alignment == table->header_row_alignment)
      {
        pass ("TABLE.header_row_alignment [BS] set+1 %hu", header_row_alignment);
      }
    else
      {
        fail ("TABLE.header_row_alignment [BS] set+1 %hu != %hu", table->header_row_alignment, header_row_alignment);
        error++;
      }
    table->header_row_alignment--;

  }
  {
    BITCODE_CMC header_row_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_row_color", &header_row_color, NULL)
        && !memcmp (&header_row_color, &table->header_row_color, sizeof (table->header_row_color)))
      {
        pass ("TABLE.header_row_color [CMC]");
      }
    else
      {
        fail ("TABLE.header_row_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_CMC header_row_fill_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_row_fill_color", &header_row_fill_color, NULL)
        && !memcmp (&header_row_fill_color, &table->header_row_fill_color, sizeof (table->header_row_fill_color)))
      {
        pass ("TABLE.header_row_fill_color [CMC]");
      }
    else
      {
        fail ("TABLE.header_row_fill_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_B header_row_fill_none;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_row_fill_none", &header_row_fill_none, NULL)
        && header_row_fill_none == table->header_row_fill_none)
      {
        pass ("TABLE.header_row_fill_none [B] " FORMAT_B "", header_row_fill_none);
      }
    else
      {
        fail ("TABLE.header_row_fill_none [B] " FORMAT_B " != " FORMAT_B "", table->header_row_fill_none, header_row_fill_none);
        error++;
      }
    header_row_fill_none++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_row_fill_none", &header_row_fill_none)
        && header_row_fill_none == table->header_row_fill_none)
      {
        pass ("TABLE.header_row_fill_none [B] set+1 " FORMAT_B "", header_row_fill_none);
      }
    else
      {
        fail ("TABLE.header_row_fill_none [B] set+1 " FORMAT_B " != " FORMAT_B "", table->header_row_fill_none, header_row_fill_none);
        error++;
      }
    table->header_row_fill_none--;

  }
  {
    BITCODE_BD header_row_height;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_row_height", &header_row_height, NULL)
        && header_row_height == table->header_row_height)
      {
        pass ("TABLE.header_row_height [BD] %g", header_row_height);
      }
    else
      {
        fail ("TABLE.header_row_height [BD] %g != %g", table->header_row_height, header_row_height);
        error++;
      }
    header_row_height++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_row_height", &header_row_height)
        && header_row_height == table->header_row_height)
      {
        pass ("TABLE.header_row_height [BD] set+1 %g", header_row_height);
      }
    else
      {
        fail ("TABLE.header_row_height [BD] set+1 %g != %g", table->header_row_height, header_row_height);
        error++;
      }
    table->header_row_height--;

  }
  {
    BITCODE_H header_row_style_override;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_row_style_override", &header_row_style_override, NULL)
        && !memcmp (&header_row_style_override, &table->header_row_style_override, sizeof (table->header_row_style_override)))
      {
        pass ("TABLE.header_row_style_override [H]");
      }
    else
      {
        fail ("TABLE.header_row_style_override [H]");
        error++;
      }
  }
  {
    BITCODE_B header_suppressed;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_suppressed", &header_suppressed, NULL)
        && header_suppressed == table->header_suppressed)
      {
        pass ("TABLE.header_suppressed [B] " FORMAT_B "", header_suppressed);
      }
    else
      {
        fail ("TABLE.header_suppressed [B] " FORMAT_B " != " FORMAT_B "", table->header_suppressed, header_suppressed);
        error++;
      }
    header_suppressed++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_suppressed", &header_suppressed)
        && header_suppressed == table->header_suppressed)
      {
        pass ("TABLE.header_suppressed [B] set+1 " FORMAT_B "", header_suppressed);
      }
    else
      {
        fail ("TABLE.header_suppressed [B] set+1 " FORMAT_B " != " FORMAT_B "", table->header_suppressed, header_suppressed);
        error++;
      }
    table->header_suppressed--;

  }
  {
    BITCODE_H header_text_style;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_text_style", &header_text_style, NULL)
        && !memcmp (&header_text_style, &table->header_text_style, sizeof (table->header_text_style)))
      {
        pass ("TABLE.header_text_style [H]");
      }
    else
      {
        fail ("TABLE.header_text_style [H]");
        error++;
      }
  }
  {
    BITCODE_CMC header_vert_ins_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_vert_ins_color", &header_vert_ins_color, NULL)
        && !memcmp (&header_vert_ins_color, &table->header_vert_ins_color, sizeof (table->header_vert_ins_color)))
      {
        pass ("TABLE.header_vert_ins_color [CMC]");
      }
    else
      {
        fail ("TABLE.header_vert_ins_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS header_vert_ins_linewt;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_vert_ins_linewt", &header_vert_ins_linewt, NULL)
        && header_vert_ins_linewt == table->header_vert_ins_linewt)
      {
        pass ("TABLE.header_vert_ins_linewt [BS] %hu", header_vert_ins_linewt);
      }
    else
      {
        fail ("TABLE.header_vert_ins_linewt [BS] %hu != %hu", table->header_vert_ins_linewt, header_vert_ins_linewt);
        error++;
      }
    header_vert_ins_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_vert_ins_linewt", &header_vert_ins_linewt)
        && header_vert_ins_linewt == table->header_vert_ins_linewt)
      {
        pass ("TABLE.header_vert_ins_linewt [BS] set+1 %hu", header_vert_ins_linewt);
      }
    else
      {
        fail ("TABLE.header_vert_ins_linewt [BS] set+1 %hu != %hu", table->header_vert_ins_linewt, header_vert_ins_linewt);
        error++;
      }
    table->header_vert_ins_linewt--;

  }
  {
    BITCODE_BS header_vert_ins_visibility;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_vert_ins_visibility", &header_vert_ins_visibility, NULL)
        && header_vert_ins_visibility == table->header_vert_ins_visibility)
      {
        pass ("TABLE.header_vert_ins_visibility [BS] %hu", header_vert_ins_visibility);
      }
    else
      {
        fail ("TABLE.header_vert_ins_visibility [BS] %hu != %hu", table->header_vert_ins_visibility, header_vert_ins_visibility);
        error++;
      }
    header_vert_ins_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_vert_ins_visibility", &header_vert_ins_visibility)
        && header_vert_ins_visibility == table->header_vert_ins_visibility)
      {
        pass ("TABLE.header_vert_ins_visibility [BS] set+1 %hu", header_vert_ins_visibility);
      }
    else
      {
        fail ("TABLE.header_vert_ins_visibility [BS] set+1 %hu != %hu", table->header_vert_ins_visibility, header_vert_ins_visibility);
        error++;
      }
    table->header_vert_ins_visibility--;

  }
  {
    BITCODE_CMC header_vert_left_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_vert_left_color", &header_vert_left_color, NULL)
        && !memcmp (&header_vert_left_color, &table->header_vert_left_color, sizeof (table->header_vert_left_color)))
      {
        pass ("TABLE.header_vert_left_color [CMC]");
      }
    else
      {
        fail ("TABLE.header_vert_left_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS header_vert_left_linewt;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_vert_left_linewt", &header_vert_left_linewt, NULL)
        && header_vert_left_linewt == table->header_vert_left_linewt)
      {
        pass ("TABLE.header_vert_left_linewt [BS] %hu", header_vert_left_linewt);
      }
    else
      {
        fail ("TABLE.header_vert_left_linewt [BS] %hu != %hu", table->header_vert_left_linewt, header_vert_left_linewt);
        error++;
      }
    header_vert_left_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_vert_left_linewt", &header_vert_left_linewt)
        && header_vert_left_linewt == table->header_vert_left_linewt)
      {
        pass ("TABLE.header_vert_left_linewt [BS] set+1 %hu", header_vert_left_linewt);
      }
    else
      {
        fail ("TABLE.header_vert_left_linewt [BS] set+1 %hu != %hu", table->header_vert_left_linewt, header_vert_left_linewt);
        error++;
      }
    table->header_vert_left_linewt--;

  }
  {
    BITCODE_BS header_vert_left_visibility;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_vert_left_visibility", &header_vert_left_visibility, NULL)
        && header_vert_left_visibility == table->header_vert_left_visibility)
      {
        pass ("TABLE.header_vert_left_visibility [BS] %hu", header_vert_left_visibility);
      }
    else
      {
        fail ("TABLE.header_vert_left_visibility [BS] %hu != %hu", table->header_vert_left_visibility, header_vert_left_visibility);
        error++;
      }
    header_vert_left_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_vert_left_visibility", &header_vert_left_visibility)
        && header_vert_left_visibility == table->header_vert_left_visibility)
      {
        pass ("TABLE.header_vert_left_visibility [BS] set+1 %hu", header_vert_left_visibility);
      }
    else
      {
        fail ("TABLE.header_vert_left_visibility [BS] set+1 %hu != %hu", table->header_vert_left_visibility, header_vert_left_visibility);
        error++;
      }
    table->header_vert_left_visibility--;

  }
  {
    BITCODE_CMC header_vert_right_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_vert_right_color", &header_vert_right_color, NULL)
        && !memcmp (&header_vert_right_color, &table->header_vert_right_color, sizeof (table->header_vert_right_color)))
      {
        pass ("TABLE.header_vert_right_color [CMC]");
      }
    else
      {
        fail ("TABLE.header_vert_right_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS header_vert_right_linewt;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_vert_right_linewt", &header_vert_right_linewt, NULL)
        && header_vert_right_linewt == table->header_vert_right_linewt)
      {
        pass ("TABLE.header_vert_right_linewt [BS] %hu", header_vert_right_linewt);
      }
    else
      {
        fail ("TABLE.header_vert_right_linewt [BS] %hu != %hu", table->header_vert_right_linewt, header_vert_right_linewt);
        error++;
      }
    header_vert_right_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_vert_right_linewt", &header_vert_right_linewt)
        && header_vert_right_linewt == table->header_vert_right_linewt)
      {
        pass ("TABLE.header_vert_right_linewt [BS] set+1 %hu", header_vert_right_linewt);
      }
    else
      {
        fail ("TABLE.header_vert_right_linewt [BS] set+1 %hu != %hu", table->header_vert_right_linewt, header_vert_right_linewt);
        error++;
      }
    table->header_vert_right_linewt--;

  }
  {
    BITCODE_BS header_vert_right_visibility;
    if (dwg_dynapi_entity_value(table, "TABLE", "header_vert_right_visibility", &header_vert_right_visibility, NULL)
        && header_vert_right_visibility == table->header_vert_right_visibility)
      {
        pass ("TABLE.header_vert_right_visibility [BS] %hu", header_vert_right_visibility);
      }
    else
      {
        fail ("TABLE.header_vert_right_visibility [BS] %hu != %hu", table->header_vert_right_visibility, header_vert_right_visibility);
        error++;
      }
    header_vert_right_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_vert_right_visibility", &header_vert_right_visibility)
        && header_vert_right_visibility == table->header_vert_right_visibility)
      {
        pass ("TABLE.header_vert_right_visibility [BS] set+1 %hu", header_vert_right_visibility);
      }
    else
      {
        fail ("TABLE.header_vert_right_visibility [BS] set+1 %hu != %hu", table->header_vert_right_visibility, header_vert_right_visibility);
        error++;
      }
    table->header_vert_right_visibility--;

  }
  {
    BITCODE_3BD hor_dir;
    if (dwg_dynapi_entity_value(table, "TABLE", "hor_dir", &hor_dir, NULL)
        && !memcmp (&hor_dir, &table->hor_dir, sizeof (table->hor_dir)))
      {
        pass ("TABLE.hor_dir [3BD]");
      }
    else
      {
        fail ("TABLE.hor_dir [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD horiz_cell_margin;
    if (dwg_dynapi_entity_value(table, "TABLE", "horiz_cell_margin", &horiz_cell_margin, NULL)
        && horiz_cell_margin == table->horiz_cell_margin)
      {
        pass ("TABLE.horiz_cell_margin [BD] %g", horiz_cell_margin);
      }
    else
      {
        fail ("TABLE.horiz_cell_margin [BD] %g != %g", table->horiz_cell_margin, horiz_cell_margin);
        error++;
      }
    horiz_cell_margin++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "horiz_cell_margin", &horiz_cell_margin)
        && horiz_cell_margin == table->horiz_cell_margin)
      {
        pass ("TABLE.horiz_cell_margin [BD] set+1 %g", horiz_cell_margin);
      }
    else
      {
        fail ("TABLE.horiz_cell_margin [BD] set+1 %g != %g", table->horiz_cell_margin, horiz_cell_margin);
        error++;
      }
    table->horiz_cell_margin--;

  }
  {
    BITCODE_3BD horiz_direction;
    if (dwg_dynapi_entity_value(table, "TABLE", "horiz_direction", &horiz_direction, NULL)
        && !memcmp (&horiz_direction, &table->horiz_direction, sizeof (table->horiz_direction)))
      {
        pass ("TABLE.horiz_direction [3BD]");
      }
    else
      {
        fail ("TABLE.horiz_direction [3BD]");
        error++;
      }
  }
  {
    BITCODE_3BD insertion_point;
    if (dwg_dynapi_entity_value(table, "TABLE", "insertion_point", &insertion_point, NULL)
        && !memcmp (&insertion_point, &table->insertion_point, sizeof (table->insertion_point)))
      {
        pass ("TABLE.insertion_point [3BD]");
      }
    else
      {
        fail ("TABLE.insertion_point [3BD]");
        error++;
      }
  }
  {
    BITCODE_H last_attrib;
    if (dwg_dynapi_entity_value(table, "TABLE", "last_attrib", &last_attrib, NULL)
        && !memcmp (&last_attrib, &table->last_attrib, sizeof (table->last_attrib)))
      {
        pass ("TABLE.last_attrib [H]");
      }
    else
      {
        fail ("TABLE.last_attrib [H]");
        error++;
      }
  }
  {
    BITCODE_BL num_break_heights;
    if (dwg_dynapi_entity_value(table, "TABLE", "num_break_heights", &num_break_heights, NULL)
        && num_break_heights == table->num_break_heights)
      {
        pass ("TABLE.num_break_heights [BL] %u", num_break_heights);
      }
    else
      {
        fail ("TABLE.num_break_heights [BL] %u != %u", table->num_break_heights, num_break_heights);
        error++;
      }
    num_break_heights++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "num_break_heights", &num_break_heights)
        && num_break_heights == table->num_break_heights)
      {
        pass ("TABLE.num_break_heights [BL] set+1 %u", num_break_heights);
      }
    else
      {
        fail ("TABLE.num_break_heights [BL] set+1 %u != %u", table->num_break_heights, num_break_heights);
        error++;
      }
    table->num_break_heights--;

  }
  {
    BITCODE_BL num_break_rows;
    if (dwg_dynapi_entity_value(table, "TABLE", "num_break_rows", &num_break_rows, NULL)
        && num_break_rows == table->num_break_rows)
      {
        pass ("TABLE.num_break_rows [BL] %u", num_break_rows);
      }
    else
      {
        fail ("TABLE.num_break_rows [BL] %u != %u", table->num_break_rows, num_break_rows);
        error++;
      }
    num_break_rows++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "num_break_rows", &num_break_rows)
        && num_break_rows == table->num_break_rows)
      {
        pass ("TABLE.num_break_rows [BL] set+1 %u", num_break_rows);
      }
    else
      {
        fail ("TABLE.num_break_rows [BL] set+1 %u != %u", table->num_break_rows, num_break_rows);
        error++;
      }
    table->num_break_rows--;

  }
  {
    unsigned long num_cells;
    if (dwg_dynapi_entity_value(table, "TABLE", "num_cells", &num_cells, NULL)
        && num_cells == table->num_cells)
      {
        pass ("TABLE.num_cells [unsigned long] %lu", num_cells);
      }
    else
      {
        fail ("TABLE.num_cells [unsigned long] %lu != %lu", table->num_cells, num_cells);
        error++;
      }
    num_cells++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "num_cells", &num_cells)
        && num_cells == table->num_cells)
      {
        pass ("TABLE.num_cells [unsigned long] set+1 %lu", num_cells);
      }
    else
      {
        fail ("TABLE.num_cells [unsigned long] set+1 %lu != %lu", table->num_cells, num_cells);
        error++;
      }
    table->num_cells--;

  }
  {
    BITCODE_BL num_cols;
    if (dwg_dynapi_entity_value(table, "TABLE", "num_cols", &num_cols, NULL)
        && num_cols == table->num_cols)
      {
        pass ("TABLE.num_cols [BL] %u", num_cols);
      }
    else
      {
        fail ("TABLE.num_cols [BL] %u != %u", table->num_cols, num_cols);
        error++;
      }
    num_cols++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "num_cols", &num_cols)
        && num_cols == table->num_cols)
      {
        pass ("TABLE.num_cols [BL] set+1 %u", num_cols);
      }
    else
      {
        fail ("TABLE.num_cols [BL] set+1 %u != %u", table->num_cols, num_cols);
        error++;
      }
    table->num_cols--;

  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value(table, "TABLE", "num_owned", &num_owned, NULL)
        && num_owned == table->num_owned)
      {
        pass ("TABLE.num_owned [BL] %u", num_owned);
      }
    else
      {
        fail ("TABLE.num_owned [BL] %u != %u", table->num_owned, num_owned);
        error++;
      }
    num_owned++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "num_owned", &num_owned)
        && num_owned == table->num_owned)
      {
        pass ("TABLE.num_owned [BL] set+1 %u", num_owned);
      }
    else
      {
        fail ("TABLE.num_owned [BL] set+1 %u != %u", table->num_owned, num_owned);
        error++;
      }
    table->num_owned--;

  }
  {
    BITCODE_BL num_rows;
    if (dwg_dynapi_entity_value(table, "TABLE", "num_rows", &num_rows, NULL)
        && num_rows == table->num_rows)
      {
        pass ("TABLE.num_rows [BL] %u", num_rows);
      }
    else
      {
        fail ("TABLE.num_rows [BL] %u != %u", table->num_rows, num_rows);
        error++;
      }
    num_rows++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "num_rows", &num_rows)
        && num_rows == table->num_rows)
      {
        pass ("TABLE.num_rows [BL] set+1 %u", num_rows);
      }
    else
      {
        fail ("TABLE.num_rows [BL] set+1 %u != %u", table->num_rows, num_rows);
        error++;
      }
    table->num_rows--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(table, "TABLE", "parent", &parent, NULL)
        && !memcmp (&parent, &table->parent, sizeof (table->parent)))
      {
        pass ("TABLE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("TABLE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_BD rotation;
    if (dwg_dynapi_entity_value(table, "TABLE", "rotation", &rotation, NULL)
        && rotation == table->rotation)
      {
        pass ("TABLE.rotation [BD] %g", rotation);
      }
    else
      {
        fail ("TABLE.rotation [BD] %g != %g", table->rotation, rotation);
        error++;
      }
    rotation++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "rotation", &rotation)
        && rotation == table->rotation)
      {
        pass ("TABLE.rotation [BD] set+1 %g", rotation);
      }
    else
      {
        fail ("TABLE.rotation [BD] set+1 %g != %g", table->rotation, rotation);
        error++;
      }
    table->rotation--;

  }
  {
    BITCODE_BD* row_heights;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_row_heights", &count, NULL)
        && dwg_dynapi_entity_value (table, "TABLE", "row_heights", &row_heights, NULL)
        && row_heights == table->row_heights)
      {
        pass ("TABLE.row_heights [BD*] * %u num_row_heights", count);
      }
    else
      {
        fail ("TABLE.row_heights [BD*] * %u num_row_heights", count);
        error++;
      }
  }
  {
    BITCODE_3BD scale;
    if (dwg_dynapi_entity_value(table, "TABLE", "scale", &scale, NULL)
        && !memcmp (&scale, &table->scale, sizeof (table->scale)))
      {
        pass ("TABLE.scale [3BD]");
      }
    else
      {
        fail ("TABLE.scale [3BD]");
        error++;
      }
  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value(table, "TABLE", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &table->seqend, sizeof (table->seqend)))
      {
        pass ("TABLE.seqend [H]");
      }
    else
      {
        fail ("TABLE.seqend [H]");
        error++;
      }
  }
  {
    BITCODE_BL table_flag_override;
    if (dwg_dynapi_entity_value(table, "TABLE", "table_flag_override", &table_flag_override, NULL)
        && table_flag_override == table->table_flag_override)
      {
        pass ("TABLE.table_flag_override [BL] %u", table_flag_override);
      }
    else
      {
        fail ("TABLE.table_flag_override [BL] %u != %u", table->table_flag_override, table_flag_override);
        error++;
      }
    table_flag_override++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "table_flag_override", &table_flag_override)
        && table_flag_override == table->table_flag_override)
      {
        pass ("TABLE.table_flag_override [BL] set+1 %u", table_flag_override);
      }
    else
      {
        fail ("TABLE.table_flag_override [BL] set+1 %u != %u", table->table_flag_override, table_flag_override);
        error++;
      }
    table->table_flag_override--;

  }
  {
    BITCODE_H table_style_id;
    if (dwg_dynapi_entity_value(table, "TABLE", "table_style_id", &table_style_id, NULL)
        && !memcmp (&table_style_id, &table->table_style_id, sizeof (table->table_style_id)))
      {
        pass ("TABLE.table_style_id [H]");
      }
    else
      {
        fail ("TABLE.table_style_id [H]");
        error++;
      }
  }
  {
    BITCODE_CMC title_horiz_bottom_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_horiz_bottom_color", &title_horiz_bottom_color, NULL)
        && !memcmp (&title_horiz_bottom_color, &table->title_horiz_bottom_color, sizeof (table->title_horiz_bottom_color)))
      {
        pass ("TABLE.title_horiz_bottom_color [CMC]");
      }
    else
      {
        fail ("TABLE.title_horiz_bottom_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS title_horiz_bottom_linewt;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_horiz_bottom_linewt", &title_horiz_bottom_linewt, NULL)
        && title_horiz_bottom_linewt == table->title_horiz_bottom_linewt)
      {
        pass ("TABLE.title_horiz_bottom_linewt [BS] %hu", title_horiz_bottom_linewt);
      }
    else
      {
        fail ("TABLE.title_horiz_bottom_linewt [BS] %hu != %hu", table->title_horiz_bottom_linewt, title_horiz_bottom_linewt);
        error++;
      }
    title_horiz_bottom_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_horiz_bottom_linewt", &title_horiz_bottom_linewt)
        && title_horiz_bottom_linewt == table->title_horiz_bottom_linewt)
      {
        pass ("TABLE.title_horiz_bottom_linewt [BS] set+1 %hu", title_horiz_bottom_linewt);
      }
    else
      {
        fail ("TABLE.title_horiz_bottom_linewt [BS] set+1 %hu != %hu", table->title_horiz_bottom_linewt, title_horiz_bottom_linewt);
        error++;
      }
    table->title_horiz_bottom_linewt--;

  }
  {
    BITCODE_BS title_horiz_bottom_visibility;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_horiz_bottom_visibility", &title_horiz_bottom_visibility, NULL)
        && title_horiz_bottom_visibility == table->title_horiz_bottom_visibility)
      {
        pass ("TABLE.title_horiz_bottom_visibility [BS] %hu", title_horiz_bottom_visibility);
      }
    else
      {
        fail ("TABLE.title_horiz_bottom_visibility [BS] %hu != %hu", table->title_horiz_bottom_visibility, title_horiz_bottom_visibility);
        error++;
      }
    title_horiz_bottom_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_horiz_bottom_visibility", &title_horiz_bottom_visibility)
        && title_horiz_bottom_visibility == table->title_horiz_bottom_visibility)
      {
        pass ("TABLE.title_horiz_bottom_visibility [BS] set+1 %hu", title_horiz_bottom_visibility);
      }
    else
      {
        fail ("TABLE.title_horiz_bottom_visibility [BS] set+1 %hu != %hu", table->title_horiz_bottom_visibility, title_horiz_bottom_visibility);
        error++;
      }
    table->title_horiz_bottom_visibility--;

  }
  {
    BITCODE_CMC title_horiz_ins_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_horiz_ins_color", &title_horiz_ins_color, NULL)
        && !memcmp (&title_horiz_ins_color, &table->title_horiz_ins_color, sizeof (table->title_horiz_ins_color)))
      {
        pass ("TABLE.title_horiz_ins_color [CMC]");
      }
    else
      {
        fail ("TABLE.title_horiz_ins_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS title_horiz_ins_linewt;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_horiz_ins_linewt", &title_horiz_ins_linewt, NULL)
        && title_horiz_ins_linewt == table->title_horiz_ins_linewt)
      {
        pass ("TABLE.title_horiz_ins_linewt [BS] %hu", title_horiz_ins_linewt);
      }
    else
      {
        fail ("TABLE.title_horiz_ins_linewt [BS] %hu != %hu", table->title_horiz_ins_linewt, title_horiz_ins_linewt);
        error++;
      }
    title_horiz_ins_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_horiz_ins_linewt", &title_horiz_ins_linewt)
        && title_horiz_ins_linewt == table->title_horiz_ins_linewt)
      {
        pass ("TABLE.title_horiz_ins_linewt [BS] set+1 %hu", title_horiz_ins_linewt);
      }
    else
      {
        fail ("TABLE.title_horiz_ins_linewt [BS] set+1 %hu != %hu", table->title_horiz_ins_linewt, title_horiz_ins_linewt);
        error++;
      }
    table->title_horiz_ins_linewt--;

  }
  {
    BITCODE_BS title_horiz_ins_visibility;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_horiz_ins_visibility", &title_horiz_ins_visibility, NULL)
        && title_horiz_ins_visibility == table->title_horiz_ins_visibility)
      {
        pass ("TABLE.title_horiz_ins_visibility [BS] %hu", title_horiz_ins_visibility);
      }
    else
      {
        fail ("TABLE.title_horiz_ins_visibility [BS] %hu != %hu", table->title_horiz_ins_visibility, title_horiz_ins_visibility);
        error++;
      }
    title_horiz_ins_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_horiz_ins_visibility", &title_horiz_ins_visibility)
        && title_horiz_ins_visibility == table->title_horiz_ins_visibility)
      {
        pass ("TABLE.title_horiz_ins_visibility [BS] set+1 %hu", title_horiz_ins_visibility);
      }
    else
      {
        fail ("TABLE.title_horiz_ins_visibility [BS] set+1 %hu != %hu", table->title_horiz_ins_visibility, title_horiz_ins_visibility);
        error++;
      }
    table->title_horiz_ins_visibility--;

  }
  {
    BITCODE_CMC title_horiz_top_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_horiz_top_color", &title_horiz_top_color, NULL)
        && !memcmp (&title_horiz_top_color, &table->title_horiz_top_color, sizeof (table->title_horiz_top_color)))
      {
        pass ("TABLE.title_horiz_top_color [CMC]");
      }
    else
      {
        fail ("TABLE.title_horiz_top_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS title_horiz_top_linewt;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_horiz_top_linewt", &title_horiz_top_linewt, NULL)
        && title_horiz_top_linewt == table->title_horiz_top_linewt)
      {
        pass ("TABLE.title_horiz_top_linewt [BS] %hu", title_horiz_top_linewt);
      }
    else
      {
        fail ("TABLE.title_horiz_top_linewt [BS] %hu != %hu", table->title_horiz_top_linewt, title_horiz_top_linewt);
        error++;
      }
    title_horiz_top_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_horiz_top_linewt", &title_horiz_top_linewt)
        && title_horiz_top_linewt == table->title_horiz_top_linewt)
      {
        pass ("TABLE.title_horiz_top_linewt [BS] set+1 %hu", title_horiz_top_linewt);
      }
    else
      {
        fail ("TABLE.title_horiz_top_linewt [BS] set+1 %hu != %hu", table->title_horiz_top_linewt, title_horiz_top_linewt);
        error++;
      }
    table->title_horiz_top_linewt--;

  }
  {
    BITCODE_BS title_horiz_top_visibility;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_horiz_top_visibility", &title_horiz_top_visibility, NULL)
        && title_horiz_top_visibility == table->title_horiz_top_visibility)
      {
        pass ("TABLE.title_horiz_top_visibility [BS] %hu", title_horiz_top_visibility);
      }
    else
      {
        fail ("TABLE.title_horiz_top_visibility [BS] %hu != %hu", table->title_horiz_top_visibility, title_horiz_top_visibility);
        error++;
      }
    title_horiz_top_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_horiz_top_visibility", &title_horiz_top_visibility)
        && title_horiz_top_visibility == table->title_horiz_top_visibility)
      {
        pass ("TABLE.title_horiz_top_visibility [BS] set+1 %hu", title_horiz_top_visibility);
      }
    else
      {
        fail ("TABLE.title_horiz_top_visibility [BS] set+1 %hu != %hu", table->title_horiz_top_visibility, title_horiz_top_visibility);
        error++;
      }
    table->title_horiz_top_visibility--;

  }
  {
    BITCODE_BS title_row_alignment;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_row_alignment", &title_row_alignment, NULL)
        && title_row_alignment == table->title_row_alignment)
      {
        pass ("TABLE.title_row_alignment [BS] %hu", title_row_alignment);
      }
    else
      {
        fail ("TABLE.title_row_alignment [BS] %hu != %hu", table->title_row_alignment, title_row_alignment);
        error++;
      }
    title_row_alignment++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_row_alignment", &title_row_alignment)
        && title_row_alignment == table->title_row_alignment)
      {
        pass ("TABLE.title_row_alignment [BS] set+1 %hu", title_row_alignment);
      }
    else
      {
        fail ("TABLE.title_row_alignment [BS] set+1 %hu != %hu", table->title_row_alignment, title_row_alignment);
        error++;
      }
    table->title_row_alignment--;

  }
  {
    BITCODE_CMC title_row_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_row_color", &title_row_color, NULL)
        && !memcmp (&title_row_color, &table->title_row_color, sizeof (table->title_row_color)))
      {
        pass ("TABLE.title_row_color [CMC]");
      }
    else
      {
        fail ("TABLE.title_row_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_CMC title_row_fill_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_row_fill_color", &title_row_fill_color, NULL)
        && !memcmp (&title_row_fill_color, &table->title_row_fill_color, sizeof (table->title_row_fill_color)))
      {
        pass ("TABLE.title_row_fill_color [CMC]");
      }
    else
      {
        fail ("TABLE.title_row_fill_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_B title_row_fill_none;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_row_fill_none", &title_row_fill_none, NULL)
        && title_row_fill_none == table->title_row_fill_none)
      {
        pass ("TABLE.title_row_fill_none [B] " FORMAT_B "", title_row_fill_none);
      }
    else
      {
        fail ("TABLE.title_row_fill_none [B] " FORMAT_B " != " FORMAT_B "", table->title_row_fill_none, title_row_fill_none);
        error++;
      }
    title_row_fill_none++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_row_fill_none", &title_row_fill_none)
        && title_row_fill_none == table->title_row_fill_none)
      {
        pass ("TABLE.title_row_fill_none [B] set+1 " FORMAT_B "", title_row_fill_none);
      }
    else
      {
        fail ("TABLE.title_row_fill_none [B] set+1 " FORMAT_B " != " FORMAT_B "", table->title_row_fill_none, title_row_fill_none);
        error++;
      }
    table->title_row_fill_none--;

  }
  {
    BITCODE_BD title_row_height;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_row_height", &title_row_height, NULL)
        && title_row_height == table->title_row_height)
      {
        pass ("TABLE.title_row_height [BD] %g", title_row_height);
      }
    else
      {
        fail ("TABLE.title_row_height [BD] %g != %g", table->title_row_height, title_row_height);
        error++;
      }
    title_row_height++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_row_height", &title_row_height)
        && title_row_height == table->title_row_height)
      {
        pass ("TABLE.title_row_height [BD] set+1 %g", title_row_height);
      }
    else
      {
        fail ("TABLE.title_row_height [BD] set+1 %g != %g", table->title_row_height, title_row_height);
        error++;
      }
    table->title_row_height--;

  }
  {
    BITCODE_H title_row_style_override;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_row_style_override", &title_row_style_override, NULL)
        && !memcmp (&title_row_style_override, &table->title_row_style_override, sizeof (table->title_row_style_override)))
      {
        pass ("TABLE.title_row_style_override [H]");
      }
    else
      {
        fail ("TABLE.title_row_style_override [H]");
        error++;
      }
  }
  {
    BITCODE_B title_suppressed;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_suppressed", &title_suppressed, NULL)
        && title_suppressed == table->title_suppressed)
      {
        pass ("TABLE.title_suppressed [B] " FORMAT_B "", title_suppressed);
      }
    else
      {
        fail ("TABLE.title_suppressed [B] " FORMAT_B " != " FORMAT_B "", table->title_suppressed, title_suppressed);
        error++;
      }
    title_suppressed++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_suppressed", &title_suppressed)
        && title_suppressed == table->title_suppressed)
      {
        pass ("TABLE.title_suppressed [B] set+1 " FORMAT_B "", title_suppressed);
      }
    else
      {
        fail ("TABLE.title_suppressed [B] set+1 " FORMAT_B " != " FORMAT_B "", table->title_suppressed, title_suppressed);
        error++;
      }
    table->title_suppressed--;

  }
  {
    BITCODE_H title_text_style;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_text_style", &title_text_style, NULL)
        && !memcmp (&title_text_style, &table->title_text_style, sizeof (table->title_text_style)))
      {
        pass ("TABLE.title_text_style [H]");
      }
    else
      {
        fail ("TABLE.title_text_style [H]");
        error++;
      }
  }
  {
    BITCODE_CMC title_vert_ins_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_vert_ins_color", &title_vert_ins_color, NULL)
        && !memcmp (&title_vert_ins_color, &table->title_vert_ins_color, sizeof (table->title_vert_ins_color)))
      {
        pass ("TABLE.title_vert_ins_color [CMC]");
      }
    else
      {
        fail ("TABLE.title_vert_ins_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS title_vert_ins_linewt;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_vert_ins_linewt", &title_vert_ins_linewt, NULL)
        && title_vert_ins_linewt == table->title_vert_ins_linewt)
      {
        pass ("TABLE.title_vert_ins_linewt [BS] %hu", title_vert_ins_linewt);
      }
    else
      {
        fail ("TABLE.title_vert_ins_linewt [BS] %hu != %hu", table->title_vert_ins_linewt, title_vert_ins_linewt);
        error++;
      }
    title_vert_ins_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_vert_ins_linewt", &title_vert_ins_linewt)
        && title_vert_ins_linewt == table->title_vert_ins_linewt)
      {
        pass ("TABLE.title_vert_ins_linewt [BS] set+1 %hu", title_vert_ins_linewt);
      }
    else
      {
        fail ("TABLE.title_vert_ins_linewt [BS] set+1 %hu != %hu", table->title_vert_ins_linewt, title_vert_ins_linewt);
        error++;
      }
    table->title_vert_ins_linewt--;

  }
  {
    BITCODE_BS title_vert_ins_visibility;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_vert_ins_visibility", &title_vert_ins_visibility, NULL)
        && title_vert_ins_visibility == table->title_vert_ins_visibility)
      {
        pass ("TABLE.title_vert_ins_visibility [BS] %hu", title_vert_ins_visibility);
      }
    else
      {
        fail ("TABLE.title_vert_ins_visibility [BS] %hu != %hu", table->title_vert_ins_visibility, title_vert_ins_visibility);
        error++;
      }
    title_vert_ins_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_vert_ins_visibility", &title_vert_ins_visibility)
        && title_vert_ins_visibility == table->title_vert_ins_visibility)
      {
        pass ("TABLE.title_vert_ins_visibility [BS] set+1 %hu", title_vert_ins_visibility);
      }
    else
      {
        fail ("TABLE.title_vert_ins_visibility [BS] set+1 %hu != %hu", table->title_vert_ins_visibility, title_vert_ins_visibility);
        error++;
      }
    table->title_vert_ins_visibility--;

  }
  {
    BITCODE_CMC title_vert_left_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_vert_left_color", &title_vert_left_color, NULL)
        && !memcmp (&title_vert_left_color, &table->title_vert_left_color, sizeof (table->title_vert_left_color)))
      {
        pass ("TABLE.title_vert_left_color [CMC]");
      }
    else
      {
        fail ("TABLE.title_vert_left_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS title_vert_left_linewt;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_vert_left_linewt", &title_vert_left_linewt, NULL)
        && title_vert_left_linewt == table->title_vert_left_linewt)
      {
        pass ("TABLE.title_vert_left_linewt [BS] %hu", title_vert_left_linewt);
      }
    else
      {
        fail ("TABLE.title_vert_left_linewt [BS] %hu != %hu", table->title_vert_left_linewt, title_vert_left_linewt);
        error++;
      }
    title_vert_left_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_vert_left_linewt", &title_vert_left_linewt)
        && title_vert_left_linewt == table->title_vert_left_linewt)
      {
        pass ("TABLE.title_vert_left_linewt [BS] set+1 %hu", title_vert_left_linewt);
      }
    else
      {
        fail ("TABLE.title_vert_left_linewt [BS] set+1 %hu != %hu", table->title_vert_left_linewt, title_vert_left_linewt);
        error++;
      }
    table->title_vert_left_linewt--;

  }
  {
    BITCODE_BS title_vert_left_visibility;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_vert_left_visibility", &title_vert_left_visibility, NULL)
        && title_vert_left_visibility == table->title_vert_left_visibility)
      {
        pass ("TABLE.title_vert_left_visibility [BS] %hu", title_vert_left_visibility);
      }
    else
      {
        fail ("TABLE.title_vert_left_visibility [BS] %hu != %hu", table->title_vert_left_visibility, title_vert_left_visibility);
        error++;
      }
    title_vert_left_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_vert_left_visibility", &title_vert_left_visibility)
        && title_vert_left_visibility == table->title_vert_left_visibility)
      {
        pass ("TABLE.title_vert_left_visibility [BS] set+1 %hu", title_vert_left_visibility);
      }
    else
      {
        fail ("TABLE.title_vert_left_visibility [BS] set+1 %hu != %hu", table->title_vert_left_visibility, title_vert_left_visibility);
        error++;
      }
    table->title_vert_left_visibility--;

  }
  {
    BITCODE_CMC title_vert_right_color;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_vert_right_color", &title_vert_right_color, NULL)
        && !memcmp (&title_vert_right_color, &table->title_vert_right_color, sizeof (table->title_vert_right_color)))
      {
        pass ("TABLE.title_vert_right_color [CMC]");
      }
    else
      {
        fail ("TABLE.title_vert_right_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BS title_vert_right_linewt;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_vert_right_linewt", &title_vert_right_linewt, NULL)
        && title_vert_right_linewt == table->title_vert_right_linewt)
      {
        pass ("TABLE.title_vert_right_linewt [BS] %hu", title_vert_right_linewt);
      }
    else
      {
        fail ("TABLE.title_vert_right_linewt [BS] %hu != %hu", table->title_vert_right_linewt, title_vert_right_linewt);
        error++;
      }
    title_vert_right_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_vert_right_linewt", &title_vert_right_linewt)
        && title_vert_right_linewt == table->title_vert_right_linewt)
      {
        pass ("TABLE.title_vert_right_linewt [BS] set+1 %hu", title_vert_right_linewt);
      }
    else
      {
        fail ("TABLE.title_vert_right_linewt [BS] set+1 %hu != %hu", table->title_vert_right_linewt, title_vert_right_linewt);
        error++;
      }
    table->title_vert_right_linewt--;

  }
  {
    BITCODE_BS title_vert_right_visibility;
    if (dwg_dynapi_entity_value(table, "TABLE", "title_vert_right_visibility", &title_vert_right_visibility, NULL)
        && title_vert_right_visibility == table->title_vert_right_visibility)
      {
        pass ("TABLE.title_vert_right_visibility [BS] %hu", title_vert_right_visibility);
      }
    else
      {
        fail ("TABLE.title_vert_right_visibility [BS] %hu != %hu", table->title_vert_right_visibility, title_vert_right_visibility);
        error++;
      }
    title_vert_right_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_vert_right_visibility", &title_vert_right_visibility)
        && title_vert_right_visibility == table->title_vert_right_visibility)
      {
        pass ("TABLE.title_vert_right_visibility [BS] set+1 %hu", title_vert_right_visibility);
      }
    else
      {
        fail ("TABLE.title_vert_right_visibility [BS] set+1 %hu != %hu", table->title_vert_right_visibility, title_vert_right_visibility);
        error++;
      }
    table->title_vert_right_visibility--;

  }
  {
    BITCODE_B unknown_b;
    if (dwg_dynapi_entity_value(table, "TABLE", "unknown_b", &unknown_b, NULL)
        && unknown_b == table->unknown_b)
      {
        pass ("TABLE.unknown_b [B] " FORMAT_B "", unknown_b);
      }
    else
      {
        fail ("TABLE.unknown_b [B] " FORMAT_B " != " FORMAT_B "", table->unknown_b, unknown_b);
        error++;
      }
    unknown_b++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "unknown_b", &unknown_b)
        && unknown_b == table->unknown_b)
      {
        pass ("TABLE.unknown_b [B] set+1 " FORMAT_B "", unknown_b);
      }
    else
      {
        fail ("TABLE.unknown_b [B] set+1 " FORMAT_B " != " FORMAT_B "", table->unknown_b, unknown_b);
        error++;
      }
    table->unknown_b--;

  }
  {
    BITCODE_BL unknown_bl;
    if (dwg_dynapi_entity_value(table, "TABLE", "unknown_bl", &unknown_bl, NULL)
        && unknown_bl == table->unknown_bl)
      {
        pass ("TABLE.unknown_bl [BL] %u", unknown_bl);
      }
    else
      {
        fail ("TABLE.unknown_bl [BL] %u != %u", table->unknown_bl, unknown_bl);
        error++;
      }
    unknown_bl++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "unknown_bl", &unknown_bl)
        && unknown_bl == table->unknown_bl)
      {
        pass ("TABLE.unknown_bl [BL] set+1 %u", unknown_bl);
      }
    else
      {
        fail ("TABLE.unknown_bl [BL] set+1 %u != %u", table->unknown_bl, unknown_bl);
        error++;
      }
    table->unknown_bl--;

  }
  {
    BITCODE_BL unknown_bl1;
    if (dwg_dynapi_entity_value(table, "TABLE", "unknown_bl1", &unknown_bl1, NULL)
        && unknown_bl1 == table->unknown_bl1)
      {
        pass ("TABLE.unknown_bl1 [BL] %u", unknown_bl1);
      }
    else
      {
        fail ("TABLE.unknown_bl1 [BL] %u != %u", table->unknown_bl1, unknown_bl1);
        error++;
      }
    unknown_bl1++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "unknown_bl1", &unknown_bl1)
        && unknown_bl1 == table->unknown_bl1)
      {
        pass ("TABLE.unknown_bl1 [BL] set+1 %u", unknown_bl1);
      }
    else
      {
        fail ("TABLE.unknown_bl1 [BL] set+1 %u != %u", table->unknown_bl1, unknown_bl1);
        error++;
      }
    table->unknown_bl1--;

  }
  {
    BITCODE_BS unknown_bs;
    if (dwg_dynapi_entity_value(table, "TABLE", "unknown_bs", &unknown_bs, NULL)
        && unknown_bs == table->unknown_bs)
      {
        pass ("TABLE.unknown_bs [BS] %hu", unknown_bs);
      }
    else
      {
        fail ("TABLE.unknown_bs [BS] %hu != %hu", table->unknown_bs, unknown_bs);
        error++;
      }
    unknown_bs++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "unknown_bs", &unknown_bs)
        && unknown_bs == table->unknown_bs)
      {
        pass ("TABLE.unknown_bs [BS] set+1 %hu", unknown_bs);
      }
    else
      {
        fail ("TABLE.unknown_bs [BS] set+1 %hu != %hu", table->unknown_bs, unknown_bs);
        error++;
      }
    table->unknown_bs--;

  }
  {
    BITCODE_H unknown_h;
    if (dwg_dynapi_entity_value(table, "TABLE", "unknown_h", &unknown_h, NULL)
        && !memcmp (&unknown_h, &table->unknown_h, sizeof (table->unknown_h)))
      {
        pass ("TABLE.unknown_h [H]");
      }
    else
      {
        fail ("TABLE.unknown_h [H]");
        error++;
      }
  }
  {
    BITCODE_RC unknown_rc;
    if (dwg_dynapi_entity_value(table, "TABLE", "unknown_rc", &unknown_rc, NULL)
        && unknown_rc == table->unknown_rc)
      {
        pass ("TABLE.unknown_rc [RC] %u", unknown_rc);
      }
    else
      {
        fail ("TABLE.unknown_rc [RC] %u != %u", table->unknown_rc, unknown_rc);
        error++;
      }
    unknown_rc++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "unknown_rc", &unknown_rc)
        && unknown_rc == table->unknown_rc)
      {
        pass ("TABLE.unknown_rc [RC] set+1 %u", unknown_rc);
      }
    else
      {
        fail ("TABLE.unknown_rc [RC] set+1 %u != %u", table->unknown_rc, unknown_rc);
        error++;
      }
    table->unknown_rc--;

  }
  {
    BITCODE_BD vert_cell_margin;
    if (dwg_dynapi_entity_value(table, "TABLE", "vert_cell_margin", &vert_cell_margin, NULL)
        && vert_cell_margin == table->vert_cell_margin)
      {
        pass ("TABLE.vert_cell_margin [BD] %g", vert_cell_margin);
      }
    else
      {
        fail ("TABLE.vert_cell_margin [BD] %g != %g", table->vert_cell_margin, vert_cell_margin);
        error++;
      }
    vert_cell_margin++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "vert_cell_margin", &vert_cell_margin)
        && vert_cell_margin == table->vert_cell_margin)
      {
        pass ("TABLE.vert_cell_margin [BD] set+1 %g", vert_cell_margin);
      }
    else
      {
        fail ("TABLE.vert_cell_margin [BD] set+1 %g != %g", table->vert_cell_margin, vert_cell_margin);
        error++;
      }
    table->vert_cell_margin--;

  }
  return error;
}
static int test_TEXT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_TEXT *restrict text = obj->tio.entity->tio.TEXT;
  {
    BITCODE_2DPOINT alignment_pt;
    if (dwg_dynapi_entity_value(text, "TEXT", "alignment_pt", &alignment_pt, NULL)
        && !memcmp (&alignment_pt, &text->alignment_pt, sizeof (text->alignment_pt)))
      {
        pass ("TEXT.alignment_pt [2DPOINT]");
      }
    else
      {
        fail ("TEXT.alignment_pt [2DPOINT]");
        error++;
      }
  }
  {
    BITCODE_RC dataflags;
    if (dwg_dynapi_entity_value(text, "TEXT", "dataflags", &dataflags, NULL)
        && dataflags == text->dataflags)
      {
        pass ("TEXT.dataflags [RC] %u", dataflags);
      }
    else
      {
        fail ("TEXT.dataflags [RC] %u != %u", text->dataflags, dataflags);
        error++;
      }
    dataflags++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "dataflags", &dataflags)
        && dataflags == text->dataflags)
      {
        pass ("TEXT.dataflags [RC] set+1 %u", dataflags);
      }
    else
      {
        fail ("TEXT.dataflags [RC] set+1 %u != %u", text->dataflags, dataflags);
        error++;
      }
    text->dataflags--;

  }
  {
    BITCODE_RD elevation;
    if (dwg_dynapi_entity_value(text, "TEXT", "elevation", &elevation, NULL)
        && elevation == text->elevation)
      {
        pass ("TEXT.elevation [RD] %g", elevation);
      }
    else
      {
        fail ("TEXT.elevation [RD] %g != %g", text->elevation, elevation);
        error++;
      }
    elevation++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "elevation", &elevation)
        && elevation == text->elevation)
      {
        pass ("TEXT.elevation [RD] set+1 %g", elevation);
      }
    else
      {
        fail ("TEXT.elevation [RD] set+1 %g != %g", text->elevation, elevation);
        error++;
      }
    text->elevation--;

  }
  {
    BITCODE_3DPOINT extrusion;
    if (dwg_dynapi_entity_value(text, "TEXT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &text->extrusion, sizeof (text->extrusion)))
      {
        pass ("TEXT.extrusion [3DPOINT]");
      }
    else
      {
        fail ("TEXT.extrusion [3DPOINT]");
        error++;
      }
  }
  {
    BITCODE_BS generation;
    if (dwg_dynapi_entity_value(text, "TEXT", "generation", &generation, NULL)
        && generation == text->generation)
      {
        pass ("TEXT.generation [BS] %hu", generation);
      }
    else
      {
        fail ("TEXT.generation [BS] %hu != %hu", text->generation, generation);
        error++;
      }
    generation++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "generation", &generation)
        && generation == text->generation)
      {
        pass ("TEXT.generation [BS] set+1 %hu", generation);
      }
    else
      {
        fail ("TEXT.generation [BS] set+1 %hu != %hu", text->generation, generation);
        error++;
      }
    text->generation--;

  }
  {
    BITCODE_RD height;
    if (dwg_dynapi_entity_value(text, "TEXT", "height", &height, NULL)
        && height == text->height)
      {
        pass ("TEXT.height [RD] %g", height);
      }
    else
      {
        fail ("TEXT.height [RD] %g != %g", text->height, height);
        error++;
      }
    height++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "height", &height)
        && height == text->height)
      {
        pass ("TEXT.height [RD] set+1 %g", height);
      }
    else
      {
        fail ("TEXT.height [RD] set+1 %g != %g", text->height, height);
        error++;
      }
    text->height--;

  }
  {
    BITCODE_BS horiz_alignment;
    if (dwg_dynapi_entity_value(text, "TEXT", "horiz_alignment", &horiz_alignment, NULL)
        && horiz_alignment == text->horiz_alignment)
      {
        pass ("TEXT.horiz_alignment [BS] %hu", horiz_alignment);
      }
    else
      {
        fail ("TEXT.horiz_alignment [BS] %hu != %hu", text->horiz_alignment, horiz_alignment);
        error++;
      }
    horiz_alignment++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "horiz_alignment", &horiz_alignment)
        && horiz_alignment == text->horiz_alignment)
      {
        pass ("TEXT.horiz_alignment [BS] set+1 %hu", horiz_alignment);
      }
    else
      {
        fail ("TEXT.horiz_alignment [BS] set+1 %hu != %hu", text->horiz_alignment, horiz_alignment);
        error++;
      }
    text->horiz_alignment--;

  }
  {
    BITCODE_2DPOINT insertion_pt;
    if (dwg_dynapi_entity_value(text, "TEXT", "insertion_pt", &insertion_pt, NULL)
        && !memcmp (&insertion_pt, &text->insertion_pt, sizeof (text->insertion_pt)))
      {
        pass ("TEXT.insertion_pt [2DPOINT]");
      }
    else
      {
        fail ("TEXT.insertion_pt [2DPOINT]");
        error++;
      }
  }
  {
    BITCODE_RD oblique_ang;
    if (dwg_dynapi_entity_value(text, "TEXT", "oblique_ang", &oblique_ang, NULL)
        && oblique_ang == text->oblique_ang)
      {
        pass ("TEXT.oblique_ang [RD] %g", oblique_ang);
      }
    else
      {
        fail ("TEXT.oblique_ang [RD] %g != %g", text->oblique_ang, oblique_ang);
        error++;
      }
    oblique_ang++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "oblique_ang", &oblique_ang)
        && oblique_ang == text->oblique_ang)
      {
        pass ("TEXT.oblique_ang [RD] set+1 %g", oblique_ang);
      }
    else
      {
        fail ("TEXT.oblique_ang [RD] set+1 %g != %g", text->oblique_ang, oblique_ang);
        error++;
      }
    text->oblique_ang--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(text, "TEXT", "parent", &parent, NULL)
        && !memcmp (&parent, &text->parent, sizeof (text->parent)))
      {
        pass ("TEXT.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("TEXT.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_RD rotation;
    if (dwg_dynapi_entity_value(text, "TEXT", "rotation", &rotation, NULL)
        && rotation == text->rotation)
      {
        pass ("TEXT.rotation [RD] %g", rotation);
      }
    else
      {
        fail ("TEXT.rotation [RD] %g != %g", text->rotation, rotation);
        error++;
      }
    rotation++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "rotation", &rotation)
        && rotation == text->rotation)
      {
        pass ("TEXT.rotation [RD] set+1 %g", rotation);
      }
    else
      {
        fail ("TEXT.rotation [RD] set+1 %g != %g", text->rotation, rotation);
        error++;
      }
    text->rotation--;

  }
  {
    BITCODE_H style;
    if (dwg_dynapi_entity_value(text, "TEXT", "style", &style, NULL)
        && !memcmp (&style, &text->style, sizeof (text->style)))
      {
        pass ("TEXT.style [H]");
      }
    else
      {
        fail ("TEXT.style [H]");
        error++;
      }
  }
  {
    BITCODE_TV text_value;
    if (dwg_dynapi_entity_value(text, "TEXT", "text_value", &text_value, NULL)
        && !strcmp ((char *)text_value, (char *)text->text_value))
      {
        pass ("TEXT.text_value [TV] '%s' <> '%s'", text_value, text->text_value);
      }
    else
      {
        fail ("TEXT.text_value [TV] '%s' <> '%s'", text_value, text->text_value);
        error++;
      }
  }
  {
    BITCODE_RD thickness;
    if (dwg_dynapi_entity_value(text, "TEXT", "thickness", &thickness, NULL)
        && thickness == text->thickness)
      {
        pass ("TEXT.thickness [RD] %g", thickness);
      }
    else
      {
        fail ("TEXT.thickness [RD] %g != %g", text->thickness, thickness);
        error++;
      }
    thickness++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "thickness", &thickness)
        && thickness == text->thickness)
      {
        pass ("TEXT.thickness [RD] set+1 %g", thickness);
      }
    else
      {
        fail ("TEXT.thickness [RD] set+1 %g != %g", text->thickness, thickness);
        error++;
      }
    text->thickness--;

  }
  {
    BITCODE_BS vert_alignment;
    if (dwg_dynapi_entity_value(text, "TEXT", "vert_alignment", &vert_alignment, NULL)
        && vert_alignment == text->vert_alignment)
      {
        pass ("TEXT.vert_alignment [BS] %hu", vert_alignment);
      }
    else
      {
        fail ("TEXT.vert_alignment [BS] %hu != %hu", text->vert_alignment, vert_alignment);
        error++;
      }
    vert_alignment++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "vert_alignment", &vert_alignment)
        && vert_alignment == text->vert_alignment)
      {
        pass ("TEXT.vert_alignment [BS] set+1 %hu", vert_alignment);
      }
    else
      {
        fail ("TEXT.vert_alignment [BS] set+1 %hu != %hu", text->vert_alignment, vert_alignment);
        error++;
      }
    text->vert_alignment--;

  }
  {
    BITCODE_RD width_factor;
    if (dwg_dynapi_entity_value(text, "TEXT", "width_factor", &width_factor, NULL)
        && width_factor == text->width_factor)
      {
        pass ("TEXT.width_factor [RD] %g", width_factor);
      }
    else
      {
        fail ("TEXT.width_factor [RD] %g != %g", text->width_factor, width_factor);
        error++;
      }
    width_factor++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "width_factor", &width_factor)
        && width_factor == text->width_factor)
      {
        pass ("TEXT.width_factor [RD] set+1 %g", width_factor);
      }
    else
      {
        fail ("TEXT.width_factor [RD] set+1 %g != %g", text->width_factor, width_factor);
        error++;
      }
    text->width_factor--;

  }
  return error;
}
static int test_TOLERANCE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_TOLERANCE *restrict tolerance = obj->tio.entity->tio.TOLERANCE;
  {
    BITCODE_BD dimgap;
    if (dwg_dynapi_entity_value(tolerance, "TOLERANCE", "dimgap", &dimgap, NULL)
        && dimgap == tolerance->dimgap)
      {
        pass ("TOLERANCE.dimgap [BD] %g", dimgap);
      }
    else
      {
        fail ("TOLERANCE.dimgap [BD] %g != %g", tolerance->dimgap, dimgap);
        error++;
      }
    dimgap++;
    if (dwg_dynapi_entity_set_value (tolerance, "TOLERANCE", "dimgap", &dimgap)
        && dimgap == tolerance->dimgap)
      {
        pass ("TOLERANCE.dimgap [BD] set+1 %g", dimgap);
      }
    else
      {
        fail ("TOLERANCE.dimgap [BD] set+1 %g != %g", tolerance->dimgap, dimgap);
        error++;
      }
    tolerance->dimgap--;

  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value(tolerance, "TOLERANCE", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &tolerance->dimstyle, sizeof (tolerance->dimstyle)))
      {
        pass ("TOLERANCE.dimstyle [H]");
      }
    else
      {
        fail ("TOLERANCE.dimstyle [H]");
        error++;
      }
  }
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value(tolerance, "TOLERANCE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &tolerance->extrusion, sizeof (tolerance->extrusion)))
      {
        pass ("TOLERANCE.extrusion [3BD]");
      }
    else
      {
        fail ("TOLERANCE.extrusion [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD height;
    if (dwg_dynapi_entity_value(tolerance, "TOLERANCE", "height", &height, NULL)
        && height == tolerance->height)
      {
        pass ("TOLERANCE.height [BD] %g", height);
      }
    else
      {
        fail ("TOLERANCE.height [BD] %g != %g", tolerance->height, height);
        error++;
      }
    height++;
    if (dwg_dynapi_entity_set_value (tolerance, "TOLERANCE", "height", &height)
        && height == tolerance->height)
      {
        pass ("TOLERANCE.height [BD] set+1 %g", height);
      }
    else
      {
        fail ("TOLERANCE.height [BD] set+1 %g != %g", tolerance->height, height);
        error++;
      }
    tolerance->height--;

  }
  {
    BITCODE_3BD ins_pt;
    if (dwg_dynapi_entity_value(tolerance, "TOLERANCE", "ins_pt", &ins_pt, NULL)
        && !memcmp (&ins_pt, &tolerance->ins_pt, sizeof (tolerance->ins_pt)))
      {
        pass ("TOLERANCE.ins_pt [3BD]");
      }
    else
      {
        fail ("TOLERANCE.ins_pt [3BD]");
        error++;
      }
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(tolerance, "TOLERANCE", "parent", &parent, NULL)
        && !memcmp (&parent, &tolerance->parent, sizeof (tolerance->parent)))
      {
        pass ("TOLERANCE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("TOLERANCE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_TV text_string;
    if (dwg_dynapi_entity_value(tolerance, "TOLERANCE", "text_string", &text_string, NULL)
        && !strcmp ((char *)text_string, (char *)tolerance->text_string))
      {
        pass ("TOLERANCE.text_string [TV] '%s' <> '%s'", text_string, tolerance->text_string);
      }
    else
      {
        fail ("TOLERANCE.text_string [TV] '%s' <> '%s'", text_string, tolerance->text_string);
        error++;
      }
  }
  {
    BITCODE_BS unknown_short;
    if (dwg_dynapi_entity_value(tolerance, "TOLERANCE", "unknown_short", &unknown_short, NULL)
        && unknown_short == tolerance->unknown_short)
      {
        pass ("TOLERANCE.unknown_short [BS] %hu", unknown_short);
      }
    else
      {
        fail ("TOLERANCE.unknown_short [BS] %hu != %hu", tolerance->unknown_short, unknown_short);
        error++;
      }
    unknown_short++;
    if (dwg_dynapi_entity_set_value (tolerance, "TOLERANCE", "unknown_short", &unknown_short)
        && unknown_short == tolerance->unknown_short)
      {
        pass ("TOLERANCE.unknown_short [BS] set+1 %hu", unknown_short);
      }
    else
      {
        fail ("TOLERANCE.unknown_short [BS] set+1 %hu != %hu", tolerance->unknown_short, unknown_short);
        error++;
      }
    tolerance->unknown_short--;

  }
  {
    BITCODE_3BD x_direction;
    if (dwg_dynapi_entity_value(tolerance, "TOLERANCE", "x_direction", &x_direction, NULL)
        && !memcmp (&x_direction, &tolerance->x_direction, sizeof (tolerance->x_direction)))
      {
        pass ("TOLERANCE.x_direction [3BD]");
      }
    else
      {
        fail ("TOLERANCE.x_direction [3BD]");
        error++;
      }
  }
  return error;
}
static int test_TRACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_TRACE *restrict trace = obj->tio.entity->tio.TRACE;
  {
    BITCODE_2RD corner1;
    if (dwg_dynapi_entity_value(trace, "TRACE", "corner1", &corner1, NULL)
        && !memcmp (&corner1, &trace->corner1, sizeof (trace->corner1)))
      {
        pass ("TRACE.corner1 [2RD]");
      }
    else
      {
        fail ("TRACE.corner1 [2RD]");
        error++;
      }
  }
  {
    BITCODE_2RD corner2;
    if (dwg_dynapi_entity_value(trace, "TRACE", "corner2", &corner2, NULL)
        && !memcmp (&corner2, &trace->corner2, sizeof (trace->corner2)))
      {
        pass ("TRACE.corner2 [2RD]");
      }
    else
      {
        fail ("TRACE.corner2 [2RD]");
        error++;
      }
  }
  {
    BITCODE_2RD corner3;
    if (dwg_dynapi_entity_value(trace, "TRACE", "corner3", &corner3, NULL)
        && !memcmp (&corner3, &trace->corner3, sizeof (trace->corner3)))
      {
        pass ("TRACE.corner3 [2RD]");
      }
    else
      {
        fail ("TRACE.corner3 [2RD]");
        error++;
      }
  }
  {
    BITCODE_2RD corner4;
    if (dwg_dynapi_entity_value(trace, "TRACE", "corner4", &corner4, NULL)
        && !memcmp (&corner4, &trace->corner4, sizeof (trace->corner4)))
      {
        pass ("TRACE.corner4 [2RD]");
      }
    else
      {
        fail ("TRACE.corner4 [2RD]");
        error++;
      }
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value(trace, "TRACE", "elevation", &elevation, NULL)
        && elevation == trace->elevation)
      {
        pass ("TRACE.elevation [BD] %g", elevation);
      }
    else
      {
        fail ("TRACE.elevation [BD] %g != %g", trace->elevation, elevation);
        error++;
      }
    elevation++;
    if (dwg_dynapi_entity_set_value (trace, "TRACE", "elevation", &elevation)
        && elevation == trace->elevation)
      {
        pass ("TRACE.elevation [BD] set+1 %g", elevation);
      }
    else
      {
        fail ("TRACE.elevation [BD] set+1 %g != %g", trace->elevation, elevation);
        error++;
      }
    trace->elevation--;

  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value(trace, "TRACE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &trace->extrusion, sizeof (trace->extrusion)))
      {
        pass ("TRACE.extrusion [BE]");
      }
    else
      {
        fail ("TRACE.extrusion [BE]");
        error++;
      }
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(trace, "TRACE", "parent", &parent, NULL)
        && !memcmp (&parent, &trace->parent, sizeof (trace->parent)))
      {
        pass ("TRACE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("TRACE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value(trace, "TRACE", "thickness", &thickness, NULL)
        && thickness == trace->thickness)
      {
        pass ("TRACE.thickness [BT] " FORMAT_BT "", thickness);
      }
    else
      {
        fail ("TRACE.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", trace->thickness, thickness);
        error++;
      }
    if (dwg_dynapi_entity_set_value (trace, "TRACE", "thickness", &thickness)
        && thickness == trace->thickness)
      {
        pass ("TRACE.thickness [BT] set+1 " FORMAT_BT "", thickness);
      }
    else
      {
        fail ("TRACE.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", trace->thickness, thickness);
        error++;
      }
    trace->thickness--;

  }
  return error;
}
static int test_UNDERLAY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_UNDERLAY *restrict underlay = obj->tio.entity->tio.UNDERLAY;
  {
    BITCODE_BD angle;
    if (dwg_dynapi_entity_value(underlay, "UNDERLAY", "angle", &angle, NULL)
        && angle == underlay->angle)
      {
        pass ("UNDERLAY.angle [BD] %g", angle);
      }
    else
      {
        fail ("UNDERLAY.angle [BD] %g != %g", underlay->angle, angle);
        error++;
      }
    angle++;
    if (dwg_dynapi_entity_set_value (underlay, "UNDERLAY", "angle", &angle)
        && angle == underlay->angle)
      {
        pass ("UNDERLAY.angle [BD] set+1 %g", angle);
      }
    else
      {
        fail ("UNDERLAY.angle [BD] set+1 %g != %g", underlay->angle, angle);
        error++;
      }
    underlay->angle--;

  }
  {
    BITCODE_2RD* clip_verts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "num_clip_verts", &count, NULL)
        && dwg_dynapi_entity_value (underlay, "UNDERLAY", "clip_verts", &clip_verts, NULL)
        && clip_verts == underlay->clip_verts)
      {
        pass ("UNDERLAY.clip_verts [2RD*] * %u num_clip_verts", count);
      }
    else
      {
        fail ("UNDERLAY.clip_verts [2RD*] * %u num_clip_verts", count);
        error++;
      }
  }
  {
    BITCODE_RC contrast;
    if (dwg_dynapi_entity_value(underlay, "UNDERLAY", "contrast", &contrast, NULL)
        && contrast == underlay->contrast)
      {
        pass ("UNDERLAY.contrast [RC] %u", contrast);
      }
    else
      {
        fail ("UNDERLAY.contrast [RC] %u != %u", underlay->contrast, contrast);
        error++;
      }
    contrast++;
    if (dwg_dynapi_entity_set_value (underlay, "UNDERLAY", "contrast", &contrast)
        && contrast == underlay->contrast)
      {
        pass ("UNDERLAY.contrast [RC] set+1 %u", contrast);
      }
    else
      {
        fail ("UNDERLAY.contrast [RC] set+1 %u != %u", underlay->contrast, contrast);
        error++;
      }
    underlay->contrast--;

  }
  {
    BITCODE_H definition_id;
    if (dwg_dynapi_entity_value(underlay, "UNDERLAY", "definition_id", &definition_id, NULL)
        && !memcmp (&definition_id, &underlay->definition_id, sizeof (underlay->definition_id)))
      {
        pass ("UNDERLAY.definition_id [H]");
      }
    else
      {
        fail ("UNDERLAY.definition_id [H]");
        error++;
      }
  }
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value(underlay, "UNDERLAY", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &underlay->extrusion, sizeof (underlay->extrusion)))
      {
        pass ("UNDERLAY.extrusion [3BD]");
      }
    else
      {
        fail ("UNDERLAY.extrusion [3BD]");
        error++;
      }
  }
  {
    BITCODE_RC fade;
    if (dwg_dynapi_entity_value(underlay, "UNDERLAY", "fade", &fade, NULL)
        && fade == underlay->fade)
      {
        pass ("UNDERLAY.fade [RC] %u", fade);
      }
    else
      {
        fail ("UNDERLAY.fade [RC] %u != %u", underlay->fade, fade);
        error++;
      }
    fade++;
    if (dwg_dynapi_entity_set_value (underlay, "UNDERLAY", "fade", &fade)
        && fade == underlay->fade)
      {
        pass ("UNDERLAY.fade [RC] set+1 %u", fade);
      }
    else
      {
        fail ("UNDERLAY.fade [RC] set+1 %u != %u", underlay->fade, fade);
        error++;
      }
    underlay->fade--;

  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value(underlay, "UNDERLAY", "flag", &flag, NULL)
        && flag == underlay->flag)
      {
        pass ("UNDERLAY.flag [RC] %u", flag);
      }
    else
      {
        fail ("UNDERLAY.flag [RC] %u != %u", underlay->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (underlay, "UNDERLAY", "flag", &flag)
        && flag == underlay->flag)
      {
        pass ("UNDERLAY.flag [RC] set+1 %u", flag);
      }
    else
      {
        fail ("UNDERLAY.flag [RC] set+1 %u != %u", underlay->flag, flag);
        error++;
      }
    underlay->flag--;

  }
  {
    BITCODE_3BD insertion_pt;
    if (dwg_dynapi_entity_value(underlay, "UNDERLAY", "insertion_pt", &insertion_pt, NULL)
        && !memcmp (&insertion_pt, &underlay->insertion_pt, sizeof (underlay->insertion_pt)))
      {
        pass ("UNDERLAY.insertion_pt [3BD]");
      }
    else
      {
        fail ("UNDERLAY.insertion_pt [3BD]");
        error++;
      }
  }
  {
    BITCODE_BL num_clip_verts;
    if (dwg_dynapi_entity_value(underlay, "UNDERLAY", "num_clip_verts", &num_clip_verts, NULL)
        && num_clip_verts == underlay->num_clip_verts)
      {
        pass ("UNDERLAY.num_clip_verts [BL] %u", num_clip_verts);
      }
    else
      {
        fail ("UNDERLAY.num_clip_verts [BL] %u != %u", underlay->num_clip_verts, num_clip_verts);
        error++;
      }
    num_clip_verts++;
    if (dwg_dynapi_entity_set_value (underlay, "UNDERLAY", "num_clip_verts", &num_clip_verts)
        && num_clip_verts == underlay->num_clip_verts)
      {
        pass ("UNDERLAY.num_clip_verts [BL] set+1 %u", num_clip_verts);
      }
    else
      {
        fail ("UNDERLAY.num_clip_verts [BL] set+1 %u != %u", underlay->num_clip_verts, num_clip_verts);
        error++;
      }
    underlay->num_clip_verts--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(underlay, "UNDERLAY", "parent", &parent, NULL)
        && !memcmp (&parent, &underlay->parent, sizeof (underlay->parent)))
      {
        pass ("UNDERLAY.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("UNDERLAY.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_3BD scale;
    if (dwg_dynapi_entity_value(underlay, "UNDERLAY", "scale", &scale, NULL)
        && !memcmp (&scale, &underlay->scale, sizeof (underlay->scale)))
      {
        pass ("UNDERLAY.scale [3BD]");
      }
    else
      {
        fail ("UNDERLAY.scale [3BD]");
        error++;
      }
  }
  {
    BITCODE_H underlay_layer;
    if (dwg_dynapi_entity_value(underlay, "UNDERLAY", "underlay_layer", &underlay_layer, NULL)
        && !memcmp (&underlay_layer, &underlay->underlay_layer, sizeof (underlay->underlay_layer)))
      {
        pass ("UNDERLAY.underlay_layer [H]");
      }
    else
      {
        fail ("UNDERLAY.underlay_layer [H]");
        error++;
      }
  }
  return error;
}
static int test_UNKNOWN_ENT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_UNKNOWN_ENT *restrict unknown_ent = obj->tio.entity->tio.UNKNOWN_ENT;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(unknown_ent, "UNKNOWN_ENT", "parent", &parent, NULL)
        && !memcmp (&parent, &unknown_ent->parent, sizeof (unknown_ent->parent)))
      {
        pass ("UNKNOWN_ENT.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("UNKNOWN_ENT.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  return error;
}
static int test_VERTEX_2D (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_VERTEX_2D *restrict vertex_2d = obj->tio.entity->tio.VERTEX_2D;
  {
    BITCODE_BD bulge;
    if (dwg_dynapi_entity_value(vertex_2d, "VERTEX_2D", "bulge", &bulge, NULL)
        && bulge == vertex_2d->bulge)
      {
        pass ("VERTEX_2D.bulge [BD] %g", bulge);
      }
    else
      {
        fail ("VERTEX_2D.bulge [BD] %g != %g", vertex_2d->bulge, bulge);
        error++;
      }
    bulge++;
    if (dwg_dynapi_entity_set_value (vertex_2d, "VERTEX_2D", "bulge", &bulge)
        && bulge == vertex_2d->bulge)
      {
        pass ("VERTEX_2D.bulge [BD] set+1 %g", bulge);
      }
    else
      {
        fail ("VERTEX_2D.bulge [BD] set+1 %g != %g", vertex_2d->bulge, bulge);
        error++;
      }
    vertex_2d->bulge--;

  }
  {
    BITCODE_BD end_width;
    if (dwg_dynapi_entity_value(vertex_2d, "VERTEX_2D", "end_width", &end_width, NULL)
        && end_width == vertex_2d->end_width)
      {
        pass ("VERTEX_2D.end_width [BD] %g", end_width);
      }
    else
      {
        fail ("VERTEX_2D.end_width [BD] %g != %g", vertex_2d->end_width, end_width);
        error++;
      }
    end_width++;
    if (dwg_dynapi_entity_set_value (vertex_2d, "VERTEX_2D", "end_width", &end_width)
        && end_width == vertex_2d->end_width)
      {
        pass ("VERTEX_2D.end_width [BD] set+1 %g", end_width);
      }
    else
      {
        fail ("VERTEX_2D.end_width [BD] set+1 %g != %g", vertex_2d->end_width, end_width);
        error++;
      }
    vertex_2d->end_width--;

  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value(vertex_2d, "VERTEX_2D", "flag", &flag, NULL)
        && flag == vertex_2d->flag)
      {
        pass ("VERTEX_2D.flag [RC] %u", flag);
      }
    else
      {
        fail ("VERTEX_2D.flag [RC] %u != %u", vertex_2d->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (vertex_2d, "VERTEX_2D", "flag", &flag)
        && flag == vertex_2d->flag)
      {
        pass ("VERTEX_2D.flag [RC] set+1 %u", flag);
      }
    else
      {
        fail ("VERTEX_2D.flag [RC] set+1 %u != %u", vertex_2d->flag, flag);
        error++;
      }
    vertex_2d->flag--;

  }
  {
    BITCODE_BL id;
    if (dwg_dynapi_entity_value(vertex_2d, "VERTEX_2D", "id", &id, NULL)
        && id == vertex_2d->id)
      {
        pass ("VERTEX_2D.id [BL] %u", id);
      }
    else
      {
        fail ("VERTEX_2D.id [BL] %u != %u", vertex_2d->id, id);
        error++;
      }
    id++;
    if (dwg_dynapi_entity_set_value (vertex_2d, "VERTEX_2D", "id", &id)
        && id == vertex_2d->id)
      {
        pass ("VERTEX_2D.id [BL] set+1 %u", id);
      }
    else
      {
        fail ("VERTEX_2D.id [BL] set+1 %u != %u", vertex_2d->id, id);
        error++;
      }
    vertex_2d->id--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(vertex_2d, "VERTEX_2D", "parent", &parent, NULL)
        && !memcmp (&parent, &vertex_2d->parent, sizeof (vertex_2d->parent)))
      {
        pass ("VERTEX_2D.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("VERTEX_2D.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value(vertex_2d, "VERTEX_2D", "point", &point, NULL)
        && !memcmp (&point, &vertex_2d->point, sizeof (vertex_2d->point)))
      {
        pass ("VERTEX_2D.point [3BD]");
      }
    else
      {
        fail ("VERTEX_2D.point [3BD]");
        error++;
      }
  }
  {
    BITCODE_BD start_width;
    if (dwg_dynapi_entity_value(vertex_2d, "VERTEX_2D", "start_width", &start_width, NULL)
        && start_width == vertex_2d->start_width)
      {
        pass ("VERTEX_2D.start_width [BD] %g", start_width);
      }
    else
      {
        fail ("VERTEX_2D.start_width [BD] %g != %g", vertex_2d->start_width, start_width);
        error++;
      }
    start_width++;
    if (dwg_dynapi_entity_set_value (vertex_2d, "VERTEX_2D", "start_width", &start_width)
        && start_width == vertex_2d->start_width)
      {
        pass ("VERTEX_2D.start_width [BD] set+1 %g", start_width);
      }
    else
      {
        fail ("VERTEX_2D.start_width [BD] set+1 %g != %g", vertex_2d->start_width, start_width);
        error++;
      }
    vertex_2d->start_width--;

  }
  {
    BITCODE_BD tangent_dir;
    if (dwg_dynapi_entity_value(vertex_2d, "VERTEX_2D", "tangent_dir", &tangent_dir, NULL)
        && tangent_dir == vertex_2d->tangent_dir)
      {
        pass ("VERTEX_2D.tangent_dir [BD] %g", tangent_dir);
      }
    else
      {
        fail ("VERTEX_2D.tangent_dir [BD] %g != %g", vertex_2d->tangent_dir, tangent_dir);
        error++;
      }
    tangent_dir++;
    if (dwg_dynapi_entity_set_value (vertex_2d, "VERTEX_2D", "tangent_dir", &tangent_dir)
        && tangent_dir == vertex_2d->tangent_dir)
      {
        pass ("VERTEX_2D.tangent_dir [BD] set+1 %g", tangent_dir);
      }
    else
      {
        fail ("VERTEX_2D.tangent_dir [BD] set+1 %g != %g", vertex_2d->tangent_dir, tangent_dir);
        error++;
      }
    vertex_2d->tangent_dir--;

  }
  return error;
}
static int test_VERTEX_3D (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_VERTEX_3D *restrict vertex_3d = obj->tio.entity->tio.VERTEX_3D;
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value(vertex_3d, "VERTEX_3D", "flag", &flag, NULL)
        && flag == vertex_3d->flag)
      {
        pass ("VERTEX_3D.flag [RC] %u", flag);
      }
    else
      {
        fail ("VERTEX_3D.flag [RC] %u != %u", vertex_3d->flag, flag);
        error++;
      }
    flag++;
    if (dwg_dynapi_entity_set_value (vertex_3d, "VERTEX_3D", "flag", &flag)
        && flag == vertex_3d->flag)
      {
        pass ("VERTEX_3D.flag [RC] set+1 %u", flag);
      }
    else
      {
        fail ("VERTEX_3D.flag [RC] set+1 %u != %u", vertex_3d->flag, flag);
        error++;
      }
    vertex_3d->flag--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(vertex_3d, "VERTEX_3D", "parent", &parent, NULL)
        && !memcmp (&parent, &vertex_3d->parent, sizeof (vertex_3d->parent)))
      {
        pass ("VERTEX_3D.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("VERTEX_3D.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value(vertex_3d, "VERTEX_3D", "point", &point, NULL)
        && !memcmp (&point, &vertex_3d->point, sizeof (vertex_3d->point)))
      {
        pass ("VERTEX_3D.point [3BD]");
      }
    else
      {
        fail ("VERTEX_3D.point [3BD]");
        error++;
      }
  }
  return error;
}
static int test_VERTEX_PFACE_FACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_VERTEX_PFACE_FACE *restrict vertex_pface_face = obj->tio.entity->tio.VERTEX_PFACE_FACE;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(vertex_pface_face, "VERTEX_PFACE_FACE", "parent", &parent, NULL)
        && !memcmp (&parent, &vertex_pface_face->parent, sizeof (vertex_pface_face->parent)))
      {
        pass ("VERTEX_PFACE_FACE.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("VERTEX_PFACE_FACE.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_BS vertind[4];
    if (dwg_dynapi_entity_value(vertex_pface_face, "VERTEX_PFACE_FACE", "vertind[4]", &vertind, NULL)
        && !memcmp (&vertind, &vertex_pface_face->vertind, sizeof (vertex_pface_face->vertind)))
      {
        pass ("VERTEX_PFACE_FACE.vertind[4] [BS]");
      }
    else
      {
        fail ("VERTEX_PFACE_FACE.vertind[4] [BS]");
        error++;
      }
  }
  return error;
}
static int test_VIEWPORT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_VIEWPORT *restrict viewport = obj->tio.entity->tio.VIEWPORT;
  {
    BITCODE_CMC ambient_color;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "ambient_color", &ambient_color, NULL)
        && !memcmp (&ambient_color, &viewport->ambient_color, sizeof (viewport->ambient_color)))
      {
        pass ("VIEWPORT.ambient_color [CMC]");
      }
    else
      {
        fail ("VIEWPORT.ambient_color [CMC]");
        error++;
      }
  }
  {
    BITCODE_BD back_clip_z;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "back_clip_z", &back_clip_z, NULL)
        && back_clip_z == viewport->back_clip_z)
      {
        pass ("VIEWPORT.back_clip_z [BD] %g", back_clip_z);
      }
    else
      {
        fail ("VIEWPORT.back_clip_z [BD] %g != %g", viewport->back_clip_z, back_clip_z);
        error++;
      }
    back_clip_z++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "back_clip_z", &back_clip_z)
        && back_clip_z == viewport->back_clip_z)
      {
        pass ("VIEWPORT.back_clip_z [BD] set+1 %g", back_clip_z);
      }
    else
      {
        fail ("VIEWPORT.back_clip_z [BD] set+1 %g != %g", viewport->back_clip_z, back_clip_z);
        error++;
      }
    viewport->back_clip_z--;

  }
  {
    BITCODE_BD brightness;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "brightness", &brightness, NULL)
        && brightness == viewport->brightness)
      {
        pass ("VIEWPORT.brightness [BD] %g", brightness);
      }
    else
      {
        fail ("VIEWPORT.brightness [BD] %g != %g", viewport->brightness, brightness);
        error++;
      }
    brightness++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "brightness", &brightness)
        && brightness == viewport->brightness)
      {
        pass ("VIEWPORT.brightness [BD] set+1 %g", brightness);
      }
    else
      {
        fail ("VIEWPORT.brightness [BD] set+1 %g != %g", viewport->brightness, brightness);
        error++;
      }
    viewport->brightness--;

  }
  {
    BITCODE_3BD center;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "center", &center, NULL)
        && !memcmp (&center, &viewport->center, sizeof (viewport->center)))
      {
        pass ("VIEWPORT.center [3BD]");
      }
    else
      {
        fail ("VIEWPORT.center [3BD]");
        error++;
      }
  }
  {
    BITCODE_BS circle_zoom;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "circle_zoom", &circle_zoom, NULL)
        && circle_zoom == viewport->circle_zoom)
      {
        pass ("VIEWPORT.circle_zoom [BS] %hu", circle_zoom);
      }
    else
      {
        fail ("VIEWPORT.circle_zoom [BS] %hu != %hu", viewport->circle_zoom, circle_zoom);
        error++;
      }
    circle_zoom++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "circle_zoom", &circle_zoom)
        && circle_zoom == viewport->circle_zoom)
      {
        pass ("VIEWPORT.circle_zoom [BS] set+1 %hu", circle_zoom);
      }
    else
      {
        fail ("VIEWPORT.circle_zoom [BS] set+1 %hu != %hu", viewport->circle_zoom, circle_zoom);
        error++;
      }
    viewport->circle_zoom--;

  }
  {
    BITCODE_BD contrast;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "contrast", &contrast, NULL)
        && contrast == viewport->contrast)
      {
        pass ("VIEWPORT.contrast [BD] %g", contrast);
      }
    else
      {
        fail ("VIEWPORT.contrast [BD] %g != %g", viewport->contrast, contrast);
        error++;
      }
    contrast++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "contrast", &contrast)
        && contrast == viewport->contrast)
      {
        pass ("VIEWPORT.contrast [BD] set+1 %g", contrast);
      }
    else
      {
        fail ("VIEWPORT.contrast [BD] set+1 %g != %g", viewport->contrast, contrast);
        error++;
      }
    viewport->contrast--;

  }
  {
    BITCODE_RC default_lighting_type;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "default_lighting_type", &default_lighting_type, NULL)
        && default_lighting_type == viewport->default_lighting_type)
      {
        pass ("VIEWPORT.default_lighting_type [RC] %u", default_lighting_type);
      }
    else
      {
        fail ("VIEWPORT.default_lighting_type [RC] %u != %u", viewport->default_lighting_type, default_lighting_type);
        error++;
      }
    default_lighting_type++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "default_lighting_type", &default_lighting_type)
        && default_lighting_type == viewport->default_lighting_type)
      {
        pass ("VIEWPORT.default_lighting_type [RC] set+1 %u", default_lighting_type);
      }
    else
      {
        fail ("VIEWPORT.default_lighting_type [RC] set+1 %u != %u", viewport->default_lighting_type, default_lighting_type);
        error++;
      }
    viewport->default_lighting_type--;

  }
  {
    BITCODE_BD front_clip_z;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "front_clip_z", &front_clip_z, NULL)
        && front_clip_z == viewport->front_clip_z)
      {
        pass ("VIEWPORT.front_clip_z [BD] %g", front_clip_z);
      }
    else
      {
        fail ("VIEWPORT.front_clip_z [BD] %g != %g", viewport->front_clip_z, front_clip_z);
        error++;
      }
    front_clip_z++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "front_clip_z", &front_clip_z)
        && front_clip_z == viewport->front_clip_z)
      {
        pass ("VIEWPORT.front_clip_z [BD] set+1 %g", front_clip_z);
      }
    else
      {
        fail ("VIEWPORT.front_clip_z [BD] set+1 %g != %g", viewport->front_clip_z, front_clip_z);
        error++;
      }
    viewport->front_clip_z--;

  }
  {
    BITCODE_BS grid_major;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "grid_major", &grid_major, NULL)
        && grid_major == viewport->grid_major)
      {
        pass ("VIEWPORT.grid_major [BS] %hu", grid_major);
      }
    else
      {
        fail ("VIEWPORT.grid_major [BS] %hu != %hu", viewport->grid_major, grid_major);
        error++;
      }
    grid_major++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "grid_major", &grid_major)
        && grid_major == viewport->grid_major)
      {
        pass ("VIEWPORT.grid_major [BS] set+1 %hu", grid_major);
      }
    else
      {
        fail ("VIEWPORT.grid_major [BS] set+1 %hu != %hu", viewport->grid_major, grid_major);
        error++;
      }
    viewport->grid_major--;

  }
  {
    BITCODE_2RD grid_spacing;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "grid_spacing", &grid_spacing, NULL)
        && !memcmp (&grid_spacing, &viewport->grid_spacing, sizeof (viewport->grid_spacing)))
      {
        pass ("VIEWPORT.grid_spacing [2RD]");
      }
    else
      {
        fail ("VIEWPORT.grid_spacing [2RD]");
        error++;
      }
  }
  {
    BITCODE_BD height;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "height", &height, NULL)
        && height == viewport->height)
      {
        pass ("VIEWPORT.height [BD] %g", height);
      }
    else
      {
        fail ("VIEWPORT.height [BD] %g != %g", viewport->height, height);
        error++;
      }
    height++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "height", &height)
        && height == viewport->height)
      {
        pass ("VIEWPORT.height [BD] set+1 %g", height);
      }
    else
      {
        fail ("VIEWPORT.height [BD] set+1 %g != %g", viewport->height, height);
        error++;
      }
    viewport->height--;

  }
  {
    BITCODE_RS id;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "id", &id, NULL)
        && id == viewport->id)
      {
        pass ("VIEWPORT.id [RS] %hu", id);
      }
    else
      {
        fail ("VIEWPORT.id [RS] %hu != %hu", viewport->id, id);
        error++;
      }
    id++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "id", &id)
        && id == viewport->id)
      {
        pass ("VIEWPORT.id [RS] set+1 %hu", id);
      }
    else
      {
        fail ("VIEWPORT.id [RS] set+1 %hu != %hu", viewport->id, id);
        error++;
      }
    viewport->id--;

  }
  {
    BITCODE_BD lens_length;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "lens_length", &lens_length, NULL)
        && lens_length == viewport->lens_length)
      {
        pass ("VIEWPORT.lens_length [BD] %g", lens_length);
      }
    else
      {
        fail ("VIEWPORT.lens_length [BD] %g != %g", viewport->lens_length, lens_length);
        error++;
      }
    lens_length++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "lens_length", &lens_length)
        && lens_length == viewport->lens_length)
      {
        pass ("VIEWPORT.lens_length [BD] set+1 %g", lens_length);
      }
    else
      {
        fail ("VIEWPORT.lens_length [BD] set+1 %g != %g", viewport->lens_length, lens_length);
        error++;
      }
    viewport->lens_length--;

  }
  {
    BITCODE_BL num_frozen_layers;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "num_frozen_layers", &num_frozen_layers, NULL)
        && num_frozen_layers == viewport->num_frozen_layers)
      {
        pass ("VIEWPORT.num_frozen_layers [BL] %u", num_frozen_layers);
      }
    else
      {
        fail ("VIEWPORT.num_frozen_layers [BL] %u != %u", viewport->num_frozen_layers, num_frozen_layers);
        error++;
      }
    num_frozen_layers++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "num_frozen_layers", &num_frozen_layers)
        && num_frozen_layers == viewport->num_frozen_layers)
      {
        pass ("VIEWPORT.num_frozen_layers [BL] set+1 %u", num_frozen_layers);
      }
    else
      {
        fail ("VIEWPORT.num_frozen_layers [BL] set+1 %u != %u", viewport->num_frozen_layers, num_frozen_layers);
        error++;
      }
    viewport->num_frozen_layers--;

  }
  {
    BITCODE_RS on_off;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "on_off", &on_off, NULL)
        && on_off == viewport->on_off)
      {
        pass ("VIEWPORT.on_off [RS] %hu", on_off);
      }
    else
      {
        fail ("VIEWPORT.on_off [RS] %hu != %hu", viewport->on_off, on_off);
        error++;
      }
    on_off++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "on_off", &on_off)
        && on_off == viewport->on_off)
      {
        pass ("VIEWPORT.on_off [RS] set+1 %hu", on_off);
      }
    else
      {
        fail ("VIEWPORT.on_off [RS] set+1 %hu != %hu", viewport->on_off, on_off);
        error++;
      }
    viewport->on_off--;

  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "parent", &parent, NULL)
        && !memcmp (&parent, &viewport->parent, sizeof (viewport->parent)))
      {
        pass ("VIEWPORT.parent [struct _dwg_object_entity*]");
      }
    else
      {
        fail ("VIEWPORT.parent [struct _dwg_object_entity*]");
        error++;
      }
  }
  {
    BITCODE_RC render_mode;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "render_mode", &render_mode, NULL)
        && render_mode == viewport->render_mode)
      {
        pass ("VIEWPORT.render_mode [RC] %u", render_mode);
      }
    else
      {
        fail ("VIEWPORT.render_mode [RC] %u != %u", viewport->render_mode, render_mode);
        error++;
      }
    render_mode++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "render_mode", &render_mode)
        && render_mode == viewport->render_mode)
      {
        pass ("VIEWPORT.render_mode [RC] set+1 %u", render_mode);
      }
    else
      {
        fail ("VIEWPORT.render_mode [RC] set+1 %u != %u", viewport->render_mode, render_mode);
        error++;
      }
    viewport->render_mode--;

  }
  {
    BITCODE_BS shadeplot_mode;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "shadeplot_mode", &shadeplot_mode, NULL)
        && shadeplot_mode == viewport->shadeplot_mode)
      {
        pass ("VIEWPORT.shadeplot_mode [BS] %hu", shadeplot_mode);
      }
    else
      {
        fail ("VIEWPORT.shadeplot_mode [BS] %hu != %hu", viewport->shadeplot_mode, shadeplot_mode);
        error++;
      }
    shadeplot_mode++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "shadeplot_mode", &shadeplot_mode)
        && shadeplot_mode == viewport->shadeplot_mode)
      {
        pass ("VIEWPORT.shadeplot_mode [BS] set+1 %hu", shadeplot_mode);
      }
    else
      {
        fail ("VIEWPORT.shadeplot_mode [BS] set+1 %hu != %hu", viewport->shadeplot_mode, shadeplot_mode);
        error++;
      }
    viewport->shadeplot_mode--;

  }
  {
    BITCODE_BD snap_angle;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "snap_angle", &snap_angle, NULL)
        && snap_angle == viewport->snap_angle)
      {
        pass ("VIEWPORT.snap_angle [BD] %g", snap_angle);
      }
    else
      {
        fail ("VIEWPORT.snap_angle [BD] %g != %g", viewport->snap_angle, snap_angle);
        error++;
      }
    snap_angle++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "snap_angle", &snap_angle)
        && snap_angle == viewport->snap_angle)
      {
        pass ("VIEWPORT.snap_angle [BD] set+1 %g", snap_angle);
      }
    else
      {
        fail ("VIEWPORT.snap_angle [BD] set+1 %g != %g", viewport->snap_angle, snap_angle);
        error++;
      }
    viewport->snap_angle--;

  }
  {
    BITCODE_2RD snap_base;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "snap_base", &snap_base, NULL)
        && !memcmp (&snap_base, &viewport->snap_base, sizeof (viewport->snap_base)))
      {
        pass ("VIEWPORT.snap_base [2RD]");
      }
    else
      {
        fail ("VIEWPORT.snap_base [2RD]");
        error++;
      }
  }
  {
    BITCODE_2RD snap_spacing;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "snap_spacing", &snap_spacing, NULL)
        && !memcmp (&snap_spacing, &viewport->snap_spacing, sizeof (viewport->snap_spacing)))
      {
        pass ("VIEWPORT.snap_spacing [2RD]");
      }
    else
      {
        fail ("VIEWPORT.snap_spacing [2RD]");
        error++;
      }
  }
  {
    BITCODE_BL status_flag;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "status_flag", &status_flag, NULL)
        && status_flag == viewport->status_flag)
      {
        pass ("VIEWPORT.status_flag [BL] %u", status_flag);
      }
    else
      {
        fail ("VIEWPORT.status_flag [BL] %u != %u", viewport->status_flag, status_flag);
        error++;
      }
    status_flag++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "status_flag", &status_flag)
        && status_flag == viewport->status_flag)
      {
        pass ("VIEWPORT.status_flag [BL] set+1 %u", status_flag);
      }
    else
      {
        fail ("VIEWPORT.status_flag [BL] set+1 %u != %u", viewport->status_flag, status_flag);
        error++;
      }
    viewport->status_flag--;

  }
  {
    BITCODE_TV style_sheet;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "style_sheet", &style_sheet, NULL)
        && !strcmp ((char *)style_sheet, (char *)viewport->style_sheet))
      {
        pass ("VIEWPORT.style_sheet [TV] '%s' <> '%s'", style_sheet, viewport->style_sheet);
      }
    else
      {
        fail ("VIEWPORT.style_sheet [TV] '%s' <> '%s'", style_sheet, viewport->style_sheet);
        error++;
      }
  }
  {
    BITCODE_B ucs_at_origin;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "ucs_at_origin", &ucs_at_origin, NULL)
        && ucs_at_origin == viewport->ucs_at_origin)
      {
        pass ("VIEWPORT.ucs_at_origin [B] " FORMAT_B "", ucs_at_origin);
      }
    else
      {
        fail ("VIEWPORT.ucs_at_origin [B] " FORMAT_B " != " FORMAT_B "", viewport->ucs_at_origin, ucs_at_origin);
        error++;
      }
    ucs_at_origin++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "ucs_at_origin", &ucs_at_origin)
        && ucs_at_origin == viewport->ucs_at_origin)
      {
        pass ("VIEWPORT.ucs_at_origin [B] set+1 " FORMAT_B "", ucs_at_origin);
      }
    else
      {
        fail ("VIEWPORT.ucs_at_origin [B] set+1 " FORMAT_B " != " FORMAT_B "", viewport->ucs_at_origin, ucs_at_origin);
        error++;
      }
    viewport->ucs_at_origin--;

  }
  {
    BITCODE_BD ucs_elevation;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "ucs_elevation", &ucs_elevation, NULL)
        && ucs_elevation == viewport->ucs_elevation)
      {
        pass ("VIEWPORT.ucs_elevation [BD] %g", ucs_elevation);
      }
    else
      {
        fail ("VIEWPORT.ucs_elevation [BD] %g != %g", viewport->ucs_elevation, ucs_elevation);
        error++;
      }
    ucs_elevation++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "ucs_elevation", &ucs_elevation)
        && ucs_elevation == viewport->ucs_elevation)
      {
        pass ("VIEWPORT.ucs_elevation [BD] set+1 %g", ucs_elevation);
      }
    else
      {
        fail ("VIEWPORT.ucs_elevation [BD] set+1 %g != %g", viewport->ucs_elevation, ucs_elevation);
        error++;
      }
    viewport->ucs_elevation--;

  }
  {
    BITCODE_3BD ucs_origin;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "ucs_origin", &ucs_origin, NULL)
        && !memcmp (&ucs_origin, &viewport->ucs_origin, sizeof (viewport->ucs_origin)))
      {
        pass ("VIEWPORT.ucs_origin [3BD]");
      }
    else
      {
        fail ("VIEWPORT.ucs_origin [3BD]");
        error++;
      }
  }
  {
    BITCODE_BS ucs_ortho_view_type;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "ucs_ortho_view_type", &ucs_ortho_view_type, NULL)
        && ucs_ortho_view_type == viewport->ucs_ortho_view_type)
      {
        pass ("VIEWPORT.ucs_ortho_view_type [BS] %hu", ucs_ortho_view_type);
      }
    else
      {
        fail ("VIEWPORT.ucs_ortho_view_type [BS] %hu != %hu", viewport->ucs_ortho_view_type, ucs_ortho_view_type);
        error++;
      }
    ucs_ortho_view_type++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "ucs_ortho_view_type", &ucs_ortho_view_type)
        && ucs_ortho_view_type == viewport->ucs_ortho_view_type)
      {
        pass ("VIEWPORT.ucs_ortho_view_type [BS] set+1 %hu", ucs_ortho_view_type);
      }
    else
      {
        fail ("VIEWPORT.ucs_ortho_view_type [BS] set+1 %hu != %hu", viewport->ucs_ortho_view_type, ucs_ortho_view_type);
        error++;
      }
    viewport->ucs_ortho_view_type--;

  }
  {
    BITCODE_B ucs_per_viewport;
    if (dwg_dynapi_entity_value(viewport, "VIEWPORT", "ucs_per_viewport", &ucs_per_viewport, NULL)
        && ucs_per_viewport == viewport->ucs_per_viewport)
      {
        pass ("VIEWPORT.ucs_per_viewport [B] " FORMAT_B "", ucs_per_viewport);
      }
    else
      {
        fail ("VIEWPORT.ucs_per_viewport [B] " FORMAT_B " != " FORMAT_B "", viewport->ucs_per_viewport, ucs_per_viewport);
        error++;
      }
    ucs_per_viewport++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "ucs_per_viewport", &ucs_per_viewport)
        && ucs_per_viewport == viewport->ucs_per_viewport)
      {
        pass ("VIEWPORT.ucs_per_viewport [B] set+1 " FORMAT_B "", ucs_per_viewport);
      }
    else
      {
        fail ("VIEWPORT.ucs_per_viewport [B] set+1 " FORMAT_B " != " FORMAT_B "", viewport->ucs_per_viewport, ucs_per_viewpo