#!/usr/bin/perl

use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

use Gtk 0.4;
use Gtk::Install::Files;

if (not defined $Gtk::Install::Files::CORE) {
	print "Unable to locate library directory containing Gtk 0.4 installation tools.\n";
	print "Please make sure Gtk 0.4 (or higher) is installed prior to building this module.\n";
	exit;
}


print "Configuring Gnome/Perl... Note that additional packages can be added\n";
print "by giving switches to Makefile.PL, including:\n";

foreach (<config/*.pl>) {
	next unless m!config/pkg-(.*)\.pl!;
	my ($name) = $1;
	next if $name =~ /^gnome([-\d\.]*)$/;
	print "\t--with-$name\n";
}

$CORE = $Gtk::Install::Files::CORE;


# Search for a gnomeConf.sh file (waiting for gnome-config) ...
# One can also 'source' in the shell the proper gnomeConf.sh file
# before running perl Makefile.PL.
if (!defined $ENV{GTKXMHTML_LIBS} || !defined $ENV{GNOMEUI_LIBS}) {
    foreach (qw{/opt/lib /usr/local/lib /usr/lib /usr/X11R6/lib /opt/gnome/lib }) {
        open(GNOMEC, "$_/gnomeConf.sh") || next;
        my $f= join('', <GNOMEC>);
        close GNOMEC;
        # simple sh2pl hack
        $f =~ s/$/;/gm;
        $f =~ s/^(\w+)=/\$ENV{\1}=/gm;
        eval $f;
        last;
    }
}

@defines = ();
$libs = $Gtk::Install::Files::libs;
$inc = $Gtk::Install::Files::inc;

$libs =~ s/\s+/ /g;
$inc =~ s/\s+/ /g;

$typemap = ["GnomeTypemap"];
$object = 'GnomeDefs.o PerlGnomeExt.o';
$pm = {
	'Gnome.pm' => '$(INST_LIBDIR)/Gnome.pm',
	'GnomeTypes.pm' => '$(INST_ARCHLIBDIR)/Gnome/Types.pm',
};

@clean = qw(GnomeTypes.pm GnomeTypemap GnomeDefs.c GnomeDefs.h Objects.xpl boxed.xsh extension.xsh objects.xsh 
			PerlGnomeExt.c PerlGnomeExt.h PerlGnomeInt.h IFiles.pm);

%xs = ();
%typemaps = ();
%defs = ();
%boot = ();


do_package("gnome");

foreach (@ARGV) {
	if (/^--with-/) {
		do_package($');
	}
}


$inc = "-I$CORE $inc";

$pm->{"IFiles.pm"} = '$(INST_ARCHLIBDIR)/Gnome/Install/Files.pm';

@L = (LIBS => [$libs]);

if (defined $inc and $inc !~ /^\s*$/) {
        @I = (INC => $inc);
} else {
        @I = (); #e.g, INC => -I/usr/other/include
}


add_typemap (map ("$CORE/$_", @Gtk::Install::Files::typemaps));
add_headers ('"PerlGtkExt.h"', '"GtkDefs.h"' );

add_headers(@Gtk::Install::Files::headers);


@a = ('-f', 'Gnome', '-p', 'Gtk=Gtk', '-p', 'Gdk=Gtk::Gdk', '-p', 'Gnome=Gnome', '-p', 'Panel=Gnome::Panel', '-m', 'Gnome');
foreach (sort {$defs{$a} <=> $defs{$b}} keys %defs) {
	push @a, '-d', $_;
}
foreach (sort {$headers{$a} <=> $headers{$b}} keys %headers) {
	push @a, '-i', $_;
}

#system(@a);
#foreach (split(' ', (do 'Objects.xpl'))) {
#	add_xs($_);
#}

require "$CORE/gendefs.pl";

print "G(", join(', ', @a), ")\n";

add_xs(gendefs::gendefs(@a));

#gendefs::gendefs("-d", "config/pkg-gnome.defs", "-f", "Gnome", '-i', '"PerlGtkExt.h"', "-i", '"GtkDefs.h"', "-i", "<argp.h>", "-i", "<libgnomeui/libgnomeui.h>", "-p", "Gtk=Gtk", "-p", "Gdk=Gtk::Gdk", "-p", "Gnome=Gnome", "-m", "Gnome");

#$xfiles = { "Gnome.xs" => "Gnome.c", "GnomeCalculator.xs" => "GnomeCalculator.c", "GnomeAbout.xs" => "GnomeAbout.c" };
#$object = "Gnome.o GnomeCalculator.o GnomeDefs.o PerlGnomeExt.o GnomeAbout.o";
##@typemap = (map ("$CORE/$_", @Gtk::Install::Files::typemaps), "GnomeTypemap");
#@clean = qw(GnomeTypes.pm GnomeTypemap GnomeDefs.c GnomeDefs.h Objects.xpl PerlGnomeExt.c PerlGnomeExt.h PerlGnomeInt.h
# boxed.xsh extension.xsh objects.xsh);


$xfiles = {};

foreach (sort {$xs{$a} <=> $xs{$b}} keys %xs) {
	my($xs) = $_;
	s/\.xs$/.c/;
	$xfiles->{$xs} = $_;
	s/\.c$/.o/;
	$object .= " $_";
}

foreach (<*.xs>) {
	if (not exists $xfiles->{$_}) {
		s/\.xs$/.c/;
		push @clean, $_;
	}
}

open (EXT, ">extension.xsh");
print EXT "\n\n# Do not edit this file, as it is automatically generated by Makefile.PL\n\n";
print EXT "BOOT:\n{\n";

foreach (sort {$boot{$a} <=> $boot{$b}} keys %boot) {
	my($b) = $_;
	$b =~ s/::/__/g;
	$b = "boot_$b";
	print EXT "extern void $b(CV *cv);\n";
}
foreach (sort {$boot{$a} <=> $boot{$b}} keys %boot) {
	my($b) = $_;
	$b =~ s/::/__/g;
	$b = "boot_$b";
	print EXT "callXS($b, cv, mark);\n";
}

print EXT "}\n";
close(EXT);

foreach (sort {$typemap{$a} <=> $typemap{$b}} keys %typemap) {
	push @$typemap, $_;
}

use File::Basename;

foreach ( 'GnomeDefs.h', 'PerlGnomeExt.h') {
	$pm->{$_} = '$(INST_ARCHLIBDIR)/Gnome/Install/' . basename($_);
}

open(I, ">IFiles.pm");
print I <<'EOT';
#!/usr/bin/perl

package Gtk::Install::Files;

@typemaps = qw(
EOT

foreach (@$typemap) {
	my($b) = basename($_);
	print I "	$b\n";
	$pm->{$_} = '$(INST_ARCHLIBDIR)/Gnome/Install/' . $b;
}

print I <<'EOT';
);

@defs = qw(
EOT

foreach (sort {$defs{$a} <=> $defs{$b}} keys %defs) {
	my($b) = basename($_);
	print I "	$b\n";
	$pm->{$_} = '$(INST_ARCHLIBDIR)/Gnome/Install/' . $b;
}

print I <<'EOT';
);

@headers = qw(
EOT

foreach (sort {$headers{$a} <=> $headers{$b}} keys %headers) {
	print I "	$_\n";
}

print I <<'EOT';
);

EOT

print I "\$libs = '$libs';\n";
print I "\$inc = '$inc';\n";

print I <<'EOT';

$CORE = undef;
foreach (@INC) {
	if ( -f $_ . "/Gnome/Install/Files.pm") {
		$CORE = $_ . "/Gnome/Install/";
		last;
	}
}

1;

EOT

close(I);


WriteMakefile(
    'NAME'  => 'Gnome',
    'VERSION_FROM'  => 'Gnome.pm',
    'PM' => $pm,
    'TYPEMAPS' => $typemap,
    'XS' => $xfiles,
    'XSOPT' => '-noversioncheck',
    'DEFINE'    => join(' ',@defines),
    'OBJECT' => $object,
    'XSPROTOARG' => '-noprototypes',
    'clean' => {FILES => join(' ', @clean)},
    'depend' => {'Gnome.c' => 'objects.xsh boxed.xsh PerlGnomeExt.h'},
    @I,
    @L,
);


sub MY::postamble {
'
PerlGnomeExt.h PerlGnomeExt.c PerlGnomeInt.h: '.$CORE.'/genext.pl
	$(PERL) '.$CORE.'/genext.pl Gnome

';
}




$add = 0;
sub add_xs
{
	foreach (@_) { $xs{$_} = $add++; }
}

sub remove_xs
{
	foreach (@_) { delete $xs{$_}; }
}

sub add_typemap
{
	foreach (@_) { $typemap{$_} = $add++; }
}

sub remove_typemap
{
	foreach (@_) { delete $typemap{$_}; }
}

sub add_defs
{
	foreach (@_) { $defs{$_} = $add++; }
}

sub remove_defs
{
	foreach (@_) { delete $defs{$_}; }
}

sub add_headers
{
	foreach (@_) { $headers{$_} = $add++; }
}

sub remove_headers
{
	foreach (@_) { delete $headers{$_}; }
}

sub add_boot
{
	foreach (@_) { $boot{$_} = $add++; }
}

sub remove_boot
{
	foreach (@_) { delete $boot{$_}; }
}


sub do_package
{
	my($p) = @_;
	if (-f "config/pkg-$p.pl") {
		if (-f "config/pkg-$p.typemap") {
			add_typemap "config/pkg-$p.typemap";
		}
		if (-f "config/pkg-$p.defs") {
			add_defs "config/pkg-$p.defs";
		}
		do "config/pkg-$p.pl";
	} else {
		print "Unknown package '$p'\n";
	}
}
