/* CSL - Common Sound Layer
 * Copyright (C) 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __CSL_PCM_H__
#define __CSL_PCM_H__


#include	<csl/csldefs.h>
#include	<csl/cslmain.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* --- CSL PCM API --- */
typedef	struct _CslPcmStream	CslPcmStream;
typedef	struct _CslPcmStatus	CslPcmStatus;
struct _CslPcmStatus
{
/* FIXME: */
  CslPcmStream *stream;
  unsigned int	rate;			/* sampling rate in HZ */
  unsigned int	n_channels;
  unsigned int	n_bits;			/* (0==floats) n_bytes_per_value = (n_bits + 7) / 8 */
  unsigned int  n_buffer_values;	/* n_packet_values * n_buffer_packets */
  unsigned int	n_packet_values;
  unsigned int	n_buffer_packets;
  unsigned int	n_buffer_values_left;	/* # of values left to read or write */
  unsigned int	n_packets_left;		/* # of empty packets left to read or write */
  unsigned int	padding[128];
/*
  CSL_PCM_PARAM_SERVER_LATENCY,
  CSL_PCM_PARAM_TOTAL_LATENCY,
  CSL_PCM_PARAM_BLOCKING,
*/
};
typedef enum		/* keep in sync with cslarts.idl */
{
  /* size (obligatory) */
  CSL_PCM_FORMAT_SIZE_8                         = 0x0008,
  CSL_PCM_FORMAT_SIZE_16                        = 0x0010,
  CSL_PCM_FORMAT_SIZE_32                        = 0x0020,
  CSL_PCM_FORMAT_SIZE_MASK                      = 0x00FF,

  /* endianess (obligatory for size > 8) */
  CSL_PCM_FORMAT_ENDIAN_LE                      = 0x0100,
  CSL_PCM_FORMAT_ENDIAN_BE                      = 0x0200,
  CSL_PCM_FORMAT_ENDIAN_MASK                    = 0x0F00,

  /* encoding (obligatory) */
  CSL_PCM_FORMAT_ENCODING_LINEAR_SIGNED         = 0x1000,
  CSL_PCM_FORMAT_ENCODING_LINEAR_UNSIGNED       = 0x2000,
  CSL_PCM_FORMAT_ENCODING_FLOAT                 = 0x3000,
  CSL_PCM_FORMAT_ENCODING_MASK                  = 0xF000,

  /* aliases: */
  CSL_PCM_FORMAT_U8                             = 0x2008,
  CSL_PCM_FORMAT_S16_LE                         = 0x1110,
  CSL_PCM_FORMAT_S16_BE                         = 0x1210,
  CSL_PCM_FORMAT_FLOAT_LE                       = 0x3120,
  CSL_PCM_FORMAT_FLOAT_BE                       = 0x3220
} CslPcmFormatType;

CslErrorType	csl_pcm_open_output		(CslDriver       *driver,
						 const char	 *role,
						 unsigned int	  rate,
						 unsigned int	  n_channels,
						 CslPcmFormatType format,
						 CslPcmStream	**stream_p);
CslErrorType	csl_pcm_open_input		(CslDriver	 *driver,
						 const char	 *role,
						 unsigned int	  rate,
						 unsigned int	  n_channels,
						 CslPcmFormatType format,
						 CslPcmStream   **stream_p);
CslPcmFormatType csl_pcm_get_format		(CslPcmStream	 *stream);
void		 csl_pcm_close			(CslPcmStream	 *stream);
/* return n_bytes processed or -1==error (FIXME: need is_broken()) */
int		 csl_pcm_read			(CslPcmStream	 *stream,
						 unsigned int	  n_bytes,
						 void		 *bytes);
int		 csl_pcm_write			(CslPcmStream	 *stream,
						 unsigned int	  n_bytes,
						 void		 *bytes);
CslErrorType	 csl_pcm_get_status		(CslPcmStream	 *stream,
						 CslPcmStatus	 *status);
CslErrorType	 csl_pcm_flush			(CslPcmStream	 *stream);
CslErrorType	 csl_pcm_sink			(CslPcmStream	 *stream);
CslErrorType	 csl_pcm_activate		(CslPcmStream	 *stream);
CslErrorType	 csl_pcm_suspend		(CslPcmStream	 *stream);


/* --- advanced API --- */
#define CSL_PCM_CHANNEL_FRONT_LEFT	"<front-left>"
#define CSL_PCM_CHANNEL_FRONT_RIGHT	"<front-right>"
#define CSL_PCM_CHANNEL_CENTER		"<center>"
#define CSL_PCM_CHANNEL_REAR_LEFT	"<rear-left>"
#define CSL_PCM_CHANNEL_REAR_RIGHT	"<rear-right>"
#define CSL_PCM_CHANNEL_SUB_WOOFER	"<sub-woofer>"

/* buffer_size always in n_bytes */
CslErrorType	csl_pcm_set_title		(CslPcmStream	*stream,
						 const char	*title);
char*		csl_pcm_dup_title		(CslPcmStream	*stream); /* needs free() */
CslErrorType	csl_pcm_set_stream_mode		(CslPcmStream	*stream,
						 unsigned int	 buffer_size);
CslErrorType	csl_pcm_set_stream_watermark	(CslPcmStream	*stream,
						 unsigned int	 n_bytes);
void		csl_pcm_get_stream_settings	(CslPcmStream	*stream,
						 unsigned int	*buffer_size_p,
						 unsigned int	*byte_watermark_p);
CslErrorType	csl_pcm_set_packet_mode		(CslPcmStream	*stream,
						 unsigned int	 n_packets,
						 unsigned int	 packet_size);
CslErrorType	csl_pcm_set_packet_watermark	(CslPcmStream	*stream,
						 unsigned int	 n_packets);
void		csl_pcm_get_packet_settings	(CslPcmStream	*stream,
						 unsigned int	*n_packets_p,
						 unsigned int	*packet_size_p,
						 unsigned int	*packet_watermark_p);
char**		csl_pcm_list_channel_mappings	(CslDriver	*driver,
						 unsigned int	*n_maps_p);
CslErrorType	csl_pcm_set_channel_mapping	(CslPcmStream	*stream,
						 unsigned int	 channel,
						 const char	*mapping);
char*		csl_pcm_dup_channel_mapping	(CslPcmStream	*stream,
						 unsigned int	 channel);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __CSL_PCM_H__ */
