/* CSL - Common Sound Layer
 * Copyright (C) 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef CSL_ADAPTER_IMPL_H
#define CSL_ADAPTER_IMPL_H

#include "cslarts.h"

namespace CSL {

class Stream_impl;
class Adapter_impl : virtual public Adapter_skel {
protected:
	struct WaitBufferLevel;

	std::list<Stream> streams;
	std::list<WaitBufferLevel *> levelWaits;
	long nextID;

public:
	Adapter_impl();

	// IDL:
	long open(const string& role, Direction dir);
	bool setParams(long streamID, const StreamParams& params);
    void setTitle(long streamID, const std::string& title);
	void close(long streamID);
	void write(long streamID, const std::vector<Arts::mcopbyte>& bytes);
	std::vector<Arts::mcopbyte> *read(long streamID, long bytes);
	void activate(long streamID);
	void suspend(long streamID);
	bool active(long streamID);
	StreamStatus status(long streamID);
	void clearBuffer(long streamID);
	long waitBufferLevel(long streamID, long bufferUsed);
	void waitPlayed(long streamID);
	std::vector<string> *channelMaps(long streamID);
	bool setChannelMapping(long streamID, long channel, const string& mapping);
	string getChannelMapping(long streamID, long channel);

	void levelChanged(Stream_impl *stream, long level);
	void removeWait(WaitBufferLevel *wait);

	// internal:
	Stream findStream(long streamID);
	bool streamParamsSupported(const StreamParams& params);

	// format normalization:
	static StreamFormat normalizeFormat(StreamFormat format);
};

};
#endif /* CSL_ADAPTER_IMPL_H */
/****
 * Local Variables:
 * Mode:C
 * c-set-style:linux
 * indent-tabs-mode:nil
 * c-basic-offset:4
 * tab-width:4
 * End:
 */
