/* GNU moe - My Own Editor
   Copyright (C) 2005-2023 Antonio Diaz Diaz.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace Encoding {

void base64_encode( const std::string & in, std::string & out );

bool base64_decode( const std::string & in, std::string & out,
                    long * const idxp );

bool quoted_printable_decode( const std::string & in, std::string & out,
                              long * const idxp );

unsigned char rot13( const unsigned char ch );
unsigned char rot47( const unsigned char ch );

bool ascii_encode( const std::string & in, std::string & out );

void ucs_to_utf8( const int code, std::string & out );
bool utf8_encode( const std::string & in, std::string & out, const bool force );
int utf8_to_ucs( const std::string & seq, const unsigned long i, int * const lenp );
int utf8_decode( const std::string & in, std::string & out, long * const idxp,
                 const bool force );
int remove_utf8_out_of_range( const std::string & in, std::string & out,
                              long * const idxp );

} // end namespace Encoding
