;;; d-readonly.el --- A readonly lock to prevent accidental editing of certain files

;; Copyright (C) 2013 Davin Pearson
;;
;; Author/Maintainer: m4_davin_pearson
;; Keywords: read-only file protection
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;; This file prevents you from accidentally editing certain precious
;; files.  To override this feature, press f7 to toggle the read only
;; status of a buffer.

;;; m4_limitation_of_warranty

;;; m4_install_instructions(d-readonly)

;;; Known Bugs:

;; None!

;;; Code:

;; NOTE: bug fix for emacs 23.* lacking this function
(if (not (fboundp 'read-only-mode))
    (defun read-only-mode (arg &rest args)
      (interactive)
      (toggle-read-only arg)))

(when (and (boundp 'prefs-home-emacs-p) prefs-home-emacs-p (not noninteractive))
  (add-hook 'find-file-hook 'd-readonly)
  (add-hook 'dired-mode-hook 'd-readonly)
  ;;(add-hook 'dired-mode-hook 'd-ding)
  )

(defun d-readonly ()
  ;;(d-foo)
  " abcdefghijklmnopqrstuvwxyz abcdefghijklmnopqrstuvwxyz abcdefghijklmnopqrstuvwxyz abcdefghijklmnopqrstuvwxyz abcdefghijklmnopqrstuvwxyz"
  ;;(message "d-readonly")
  ;;(sit-for 1)
  (save-match-data
    (let ((file (or (buffer-file-name) dired-directory)))
      ;;(debug "Ramjet")
      ;;(message "file=%s" file)
      (if (and (file-directory-p file) (not (string-match "/$" file)))
          (setq file (concat file "/")))
      ;;(d-beeps "file=%s" file)
      (cond

       ((eq major-mode 'dired-mode)
        (setq truncate-lines t))

       ((string-match "\\.temp$" file)
        (read-only-mode 1))

       ((string= (buffer-name) " *d-speedbar*")
        (read-only-mode 1))

       ((string-match "/jtw-tutorials" default-directory)
        (read-only-mode -1))

       ((string-match "/J.T.W/" default-directory)
        (read-only-mode -1))

       ((string-match "/Downloads/" file)
        (setq truncate-lines t)
        (read-only-mode 1))

       ((string-match "/lisp\\+\\+-projects/" file)
        ;;(d-beeps "c++-projects file=%s" file)
        (setq truncate-lines t)
        (read-only-mode -1)
        )

       ((or (string-match "~/c2java/" file)
            (string-match "hairy-lemon/src/50webs-com/research/2015/c2java-1\\.12/" file))
        (read-only-mode -1))

       ((string-match "hairy-lemon/src/50webs-com/research/2015/c2java-1\\.[0-9]+/" file)
        (read-only-mode 1))

       ((string-match "/java-projects/" file)
        (setq truncate-lines t)
        (setq tab-width 5)
        (read-only-mode -1))

       ((string-match "/imported-stuff/" file)
        (read-only-mode 1))

       ((string-match "/var/www/" file)
        (read-only-mode -1))

       ((string-match "^d:/home/hairy-lemon/output/index.html$" file)
        (read-only-mode -1))

       ((string-match "\\(log\\.txt\\|pdf\\.php\\)$" file)
        (setq truncate-lines t)
        (setq tab-width 3)
        (read-only-mode -1))

       ((string-match "[a-z]:/wamp/" file)
        ;;(d-beeps "c:/wamp/")
        (setq truncate-lines t)
        (setq tab-width 3)
        (read-only-mode -1))

       ((string-match "e:/Driver Pack Solution/" file)
        ;;(d-beeps "e:/Driver Pack Solution/")
        (setq truncate-lines t)
        (setq tab-width 3)
        (read-only-mode 1))

       ((let ((case-fold-search t))
          (and (string-match "/output/" file)
               (string-match "\\.html?$" file)))
        (read-only-mode 1))

       ((let ((case-fold-search t))
          (string-match "/hairy-lemon/" file))
        (read-only-mode -1))

       ((string-match "allegro" file)
        (read-only-mode 1))

       ((string-match "wordpress" file)
        (read-only-mode -1))

       ((string-match "/Program Files/" file)
        (read-only-mode 1))

       ((and prefs-home-emacs-p (string-match "/ro[a-z]*/" file))
        (read-only-mode 1))

       ((string-match "\\.\\(gz\\|rpm\\|tar\\|tgz\\|zip\\)$" file)
        (read-only-mode 1))

       ((string-match "\\.\\(class\\|dll\\|exe\\|lnk\\|o\\)$" file)
        (read-only-mode 1))

       ((string-match "\\.\\(dvi\\|gif\\|jpg\\|mpg\\|pdf\\|ps\\|tga\\)$" file)
        (read-only-mode 1))

       ((string-match (getenv "HOME") file)
        ;;(d-beeps "foo")
        (read-only-mode -1)
        (setq truncate-lines t))

       ((string-match "[a-z]:/" file)
        (read-only-mode 1))

       ((string-match "/dlisp/" file)
        (read-only-mode -1))

       (t
        (read-only-mode 1))))))

(defun d-toggle-read-only ()
  (interactive)
  (if buffer-read-only
      (read-only-mode -1)
    (read-only-mode 1)))

(global-set-key [f7] 'd-toggle-read-only)

(provide 'd-readonly)
;;; d-readonly.el ends here
