#/bin/sh
#
#
# Filename:   key-modifier/km-mouse.sh
# Created:  
# 
# Description:
#
#  Test the Xnee functionality
#       key modifier options
#
#
 
 
 
 
# name of myself
MYNAME=km-mouse.sh
 
 
# source useful funs
if [ ! -f etc/base_funs ]; 
then 
    echo "Can't find the file: base_funs"  
    echo "Start me up in the xnee test dir "
    exit
else 
    . etc/base_funs
fi 
 
init_test 
parse_me "$*"

#######################################################################

KEYBOARD_DEVICE=/dev/swkeybd
FILE=km-mouse.log
rm $FILE

# main ..... I guess
verify_device swkeybd



function verify_swmouse()
{
    LEFT=$1
    UP=$2
    DOWN=$3
    RIGHT=$4



    SW_LEFT=$(cat /proc/swmouse | awk ' BEGIN { FS="[:;]" }  {print $2 }')
    SW_UP=$(cat /proc/swmouse | awk ' BEGIN { FS="[:;]" }  {print $4 }')
    SW_DOWN=$(cat /proc/swmouse | awk ' BEGIN { FS="[:;]" }  {print $3 }')
    SW_RIGHT=$(cat /proc/swmouse | awk ' BEGIN { FS="[:;]" }  {print $5 }')

    verbose "-------------------------"
    verbose "-  swmouse verification -"

    verbose "-    left -"
    verify_same $SW_LEFT $LEFT
    verbose "-    up -"
    verify_same $SW_UP $UP
    verbose "-    down -"
    verify_same $SW_DOWN $DOWN
    verbose "-    right -"
    verify_same $SW_RIGHT $RIGHT
    verbose "------------------------- finished "
}


function test_stop()
{
    MOD=$1
    KEY=$2

    LEFT=$3
    UP=$4
    DOWN=$5
    RIGHT=$6
    
    TOT_PIX=$(( $LEFT + $UP + $DOWN + $RIGHT))

    get_in_position
    zero_mouse

    killall xnee
    $XNEE --record --device-event-range 6 --loops -1  -o $FILE -sk $MOD,$KEY &
    
    sleep 2
    move_mouse   r $RIGHT
    move_mouse   d $DOWN
    move_mouse   l $UP
    move_mouse   u $LEFT
    sleep 2
    
    
    verbose "Trying to stop...."
    if [ "$MOD" == "Alt" ];
	then
	verbose " with $MOD $KEY"
	fake_alt_  $KEY
    else
	verbose " with $KEY since MOD=$MOD"
	press_key $KEY
    fi
    sleep 2
    
    MOUSE_NRS=$(grep "0,6"  $FILE | wc -l)
    verbose "file length $MOUSE_NRS  ($TOT_PIX)"

    verify_same $MOUSE_NRS $TOT_PIX

    verify_swmouse     $LEFT    $UP    $DOWN    $RIGHT
}


function test_pause_resume()
{
    P_MOD=$1
    P_KEY=$2

    R_MOD=$3
    R_KEY=$4
    
    LEFT=$5
    UP=$6
    DOWN=$7
    RIGHT=$8
    
    

    MODIFIERS="-rk $R_MOD,$R_KEY -pk $P_MOD,$P_KEY"
    TOT_PIX=$(( $LEFT + $UP + $DOWN + $RIGHT ))

    get_in_position
    zero_mouse

    killall xnee
    $XNEE --record --mouse --loops -1  -o $FILE $MODIFIERS &

    # move the mouse
    # this shall be recorded    
    sleep 2
    move_mouse   r $RIGHT
    move_mouse   d $DOWN
    move_mouse   l $UP
    move_mouse   u $LEFT
    sleep 2
    
    MOUSE_NRS=$(grep "0,6"  $FILE | wc -l)
    verbose "file length $MOUSE_NRS  ($TOT_PIX)"

    verify_same $MOUSE_NRS $TOT_PIX

    verbose "Trying to pause...."
    if [ "$P_MOD" == "Alt" ];
	then
	verbose " with $P_MOD $P_KEY"
	fake_alt_  $P_KEY
    else
	verbose " with $P_KEY since MOD=$P_MOD"
	press_key $P_KEY
    fi
    sleep 2
    

    MOUSE_NRS=$(grep "0,6"  $FILE | wc -l)
    verbose "file length $MOUSE_NRS  ($TOT_PIX)"

    # move the mouse
    # this shall NOT be recorded    
    sleep 2
    move_mouse   r $RIGHT
    move_mouse   d $DOWN
    move_mouse   l $UP
    move_mouse   u $LEFT
    sleep 2
 

    MOUSE_NRS=$(grep "0,6"  $FILE | wc -l)
    verbose "mouse motions: $MOUSE_NRS   (tot=$TOT_PIX)"
    verify_same     $MOUSE_NRS     $TOT_PIX
    verify_not_same $MOUSE_NRS     $(( $TOT_PIX * 2 ))


    verbose "Trying to resume...."
    if [ "$R_MOD" == "Alt" ];
	then
	verbose " with $R_MOD $R_KEY"
	fake_alt_  $R_KEY
    else
	verbose " with $R_KEY since MOD=R_$MOD"
	press_key $R_KEY
    fi
    sleep 2
    



    # move the mouse
    # this shall be recorded    
    sleep 2
    move_mouse   r $RIGHT
    move_mouse   d $DOWN
    move_mouse   l $UP
    move_mouse   u $LEFT
    sleep 2

    MOUSE_NRS=$(grep "0,6"  $FILE | wc -l)
    verbose "file length $MOUSE_NRS  $(( $TOT_PIX * 2 ))"
    verify_same     $MOUSE_NRS $(( $TOT_PIX * 2 ))
    verify_not_same $MOUSE_NRS $(( $TOT_PIX * 3 ))

    verify_swmouse $(( $LEFT * 3 )) $(( $UP* 3 )) $(( $DOWN * 3 ))  $(( $RIGHT * 3 ))

    killall xnee
}


test_stop Alt e 10 20 30 20
test_stop Any e 30 20 40 50

test_pause_resume Any p Any r 17 23 57 69
test_pause_resume Any p Any r 10 20 30 40


result_log $MYNAME 

