.ig
Copyright (C) 1989-2000, 2001 Free Software Foundation, Inc.

Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
..
.de TQ
.br
.ns
.TP \\$1
..
.\" Like TP, but if specified indent is more than half
.\" the current line-length - indent, use the default indent.
.de Tp
.ie \\n(.$=0:((0\\$1)*2u>(\\n(.lu-\\n(.iu)) .TP
.el .TP "\\$1"
..
.TH GROFF @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
groff \- front end for the groff document formatting system
.SH SYNOPSIS
.nr a \n(.j
.ad l
.nr i \n(.i
.in +\w'\fBgroff 'u
.ti \niu
.B groff
.de OP
.ie \\n(.$-1 .RI "[\ \fB\\$1\fP" "\\$2" "\ ]"
.el .RB "[\ " "\\$1" "\ ]"
..
.OP \-abeghilpstvzCEGNRSUVXZ
.OP \-w name
.OP \-W name
.OP \-m name
.OP \-F dir
.OP \-I dir
.OP \-T dev
.OP \-f fam
.OP \-M dir
.OP \-d cs
.OP \-r cn
.OP \-n num
.OP \-o list
.OP \-P arg
.OP \-L arg
.RI "[\ " files\|.\|.\|. "\ ]"
.br
.ad \na
.PP
It is possible to have whitespace between a command line option and its
parameter.
.SH DESCRIPTION
.B groff
is a front-end to the groff document formatting system.
Normally it runs the
.B @g@troff
program and a postprocessor appropriate for the selected
device.
Available devices are:
.TP
.B ps
For PostScript printers and previewers
.TP
.B dvi
For TeX dvi format.
.TP
.B X75
For a 75dpi X11 previewer.
.TP
.B X100
For a 100dpi X11 previewer.
.TP
.B ascii
For typewriter-like devices.
.TP
.B latin1
For typewriter-like devices using the ISO Latin-1 (ISO 8859-1) character set.
.TP
.B utf8
For typewriter-like devices using the Unicode (ISO 10646) character set with
UTF-8 encoding.
.TP
.B cp1047
For typewriter-like devices which use the EBCDIC code page IBM cp1047
(e.g. OS/390 Unix).
.TP 
.B lj4
For an HP LaserJet4-compatible (or other PCL5-compatible) printer.
.TP
.B lbp
For Canon CAPSL printers (LBP-4 and LBP-8 series laser printers).
.TP
.B html
To produce HTML output.
.LP
The postprocessor to be used for a device is specified by the
.B postpro
command in the device description file.
This can be overridden with the
.B \-X
option.
.LP
The default device is
.BR @DEVICE@ .
It can optionally preprocess with any of
.BR @g@pic ,
.BR @g@eqn ,
.BR @g@grn ,
.BR grap ,
.BR @g@tbl ,
.BR @g@refer ,
or
.B @g@soelim.
.LP
Options without an argument can be grouped behind a single
.BR \- .
A filename of
.B \-
denotes the standard input.
.LP
The
.B grog
command can be used to guess the correct groff command to use to
format a file.
.SH OPTIONS
.TP
.B \-h
Print a help message.
.TP
.B \-e
Preprocess with @g@eqn.
.TP
.B \-t
Preprocess with @g@tbl.
.TP
.B \-g
Preprocess with @g@grn.
.TP
.B \-G
Preprocess with grap.
.TP
.B \-p
Preprocess with @g@pic.
.TP
.B \-s
Preprocess with @g@soelim.
.TP
.BI \-I dir
This option is as described in
.BR @g@soelim (@MAN1EXT@).
This option implies the
.B \-s
option.
.TP
.B \-R
Preprocess with @g@refer.
No mechanism is provided for passing arguments to 
.B @g@refer
because most @g@refer options have equivalent commands
which can be included in the file.
See
.BR @g@refer (@MAN1EXT@)
for more details.
.TP
.B \-v
Make programs run by
.B groff
print out their version number.
.TP
.B \-V
Print the pipeline on stdout instead of executing it.
.TP
.B \-z
Suppress output from
.BR @g@troff .
Only error messages will be printed.
.TP
.B \-Z
Do not postprocess the output of
.BR @g@troff .
Normally
.B groff
will automatically run the appropriate postprocessor.
.TP
.BI \-P arg
Pass
.I arg
to the postprocessor.
Each argument should be passed with a separate
.B \-P
option.
Note that
.B groff
does not prepend
.B \-
to
.I arg
before passing it to the postprocessor.
.TP
.B \-l
Send the output to a spooler for printing.
The command used for this is specified by the
.B print
command in the device description file (if not present,
.B \-l
has no effect).
.TP
.BI \-L arg
Pass
.I arg
to the spooler.
Each argument should be passed with a separate
.B \-L
option.
Note that
.B groff
does not prepend
.B \-
to
.I arg
before passing it to the postprocessor.
If there is no
.B print
command in the device description file,
.B \-L
is ignored.
.TP
.BI \-T dev
Prepare output for device
.IR dev .
The default device is
.BR @DEVICE@ .
.TP
.B \-X
Preview with
.B gxditview
instead of using the usual postprocessor.
.B Groff
passes
.B gxditview
a
.B -printCommand
option which will make the
.B Print
action do what
.B groff
would have done if the
.B -l
option had been given.
This is unlikely to produce good results except with
.BR \-Tps .
.TP
.B \-N
Don't allow newlines with eqn delimiters.
This is the same as the
.B \-N
option in
.BR @g@eqn .
.TP
.B \-S
Safer mode.  Pass the
.B \-S
option to
.B @g@pic
and disable the following
.B @g@troff
requests:
.BR .open ,
.BR .opena ,
.BR .pso ,
.BR .sy ,
and
.BR .pi .
For security reasons, safer mode is enabled by default.
.TP
.B \-U
Unsafe mode.  Reverts to the old unsafe behaviour.
.TP
.B \-a
.TQ
.B \-b
.TQ
.B \-i
.TQ
.B \-C
.TQ
.B \-E
.TQ
.BI \-w name
.TQ
.BI \-W name
.TQ
.BI \-m name
.TQ
.BI \-o list
.TQ
.BI \-d cs
.TQ
.BI \-r cn
.TQ
.BI \-F dir
.TQ
.BI \-M dir
.TQ
.BI \-f fam
.TQ
.BI \-n num
These are as described in
.BR @g@troff (@MAN1EXT@) .
.SH ENVIRONMENT
.TP
.SM
.B GROFF_COMMAND_PREFIX
If this is set
.IR X ,
then
.B groff
will run
.IB X troff
instead of
.BR @g@troff .
This also applies to
.BR tbl ,
.BR pic ,
.BR eqn ,
.BR grn ,
.BR refer ,
and
.BR soelim .
It does not apply to
.BR grap ,
.BR grops ,
.BR grodvi ,
.BR grotty ,
.BR grolj4 ,
.BR grohtml ,
and
.BR gxditview .
.TP
.SM
.B GROFF_TMAC_PATH
A colon separated list of directories in which to search for
macro files in addition to the default directories.
See
.BR troff (1)
for more details.
.TP
.SM
.B GROFF_TYPESETTER
Default device.
.TP
.SM
.B GROFF_FONT_PATH
A colon separated list of directories in which to search for the
.BI dev name
directory in addition to the default one.
See
.BR troff (1)
for more details.
.TP
.SM
.B GROFF_BIN_PATH
This search path, followed by
.BR PATH ,
will be used for commands executed by
.BR groff .
If not set, `@BINDIR@' is prepended to
.BR PATH .
.TP
.SM
.B GROFF_TMPDIR
The directory in which temporary files will be created.
If this is not set and
.B
.SM TMPDIR
is set, temporary files will be created in that directory.
Otherwise temporary files will be created in
.BR /tmp .
The
.BR grops (@MAN1EXT@)
and
.BR @g@refer (@MAN1EXT@)
commands can create temporary files.
.SH FILES
.Tp \w'\fB@FONTDIR@/dev\fIname\fB/DESC'u+3n
.BI @FONTDIR@/dev name /DESC
Device description file for device
.IR name .
.TP
.BI @FONTDIR@/dev name / F
Font file for font
.I F
of device
.IR name .
.LP
Note that on EBCDIC hosts, output devices
.BR ascii ,
.BR latin1 ,
and
.B utf8
aren't available.
Similarly,
.B cp1047
is not available on ASCII based operating systems.
.SH EXAMPLE
To print the man page
.B foo.1
to the standard output using the latin-1 output device and
.B less
as the pager, the following command can be used:
.IP
.B groff -mandoc -Tlatin1 foo.1 | less
.PP
Alternatively, you can say
.IP
.B groff -m mandoc -Tlatin1 foo.1 | less
.SH AUTHOR
James Clark <jjc@jclark.com>
.SH BUGS
Report bugs to bug-groff@gnu.org.
Include a complete, self-contained example
that will allow the bug to be reproduced,
and say which version of groff you are using.
.SH COPYRIGHT
Copyright \(co 1989-2000 Free Software Foundation, Inc.
.LP
groff is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.
.LP
groff is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.
.LP
You should have received a copy of the GNU General Public License along
with groff; see the file COPYING.  If not, write to the Free Software
Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
.SH AVAILABILITY
The most recent released version of groff is always available for
anonymous ftp from ftp.gnu.org in the directory gnu/groff.
.LP
.B groff
only supports the freely available
.B grap
implementation written by Ted Faber <faber@lunabase.org>.
The actual version can be found at
.IP
\%http://www.lunabase.org/~faber/Vault/software/grap/
.SH "SEE ALSO"
.BR grog (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@),
.BR @g@tbl (@MAN1EXT@),
.BR @g@pic (@MAN1EXT@),
.BR @g@eqn (@MAN1EXT@),
.BR @g@grn (@MAN1EXT@),
.BR grap (1),
.BR @g@soelim (@MAN1EXT@),
.BR @g@refer (@MAN1EXT@),
.BR grops (@MAN1EXT@),
.BR grodvi (@MAN1EXT@),
.BR grotty (@MAN1EXT@),
.BR grolj4 (@MAN1EXT@),
.BR grolbp (@MAN1EXT@),
.BR grohtml (@MAN1EXT@),
.BR gxditview (@MAN1EXT@),
.BR groff_font (@MAN5EXT@),
.BR groff_out (@MAN5EXT@),
.BR groff_man (@MAN7EXT@),
.BR groff_ms (@MAN7EXT@),
.BR groff_me (@MAN7EXT@),
.BR groff_char (@MAN7EXT@)
.
.\" Local Variables:
.\" mode: nroff
.\" End:
