/*
 * Copyright (C) 2003, 2013 Free Software Foundation, Inc.
 *
 * This file is part of GNU Classpath Extensions (classpathx).
 * For more information please visit https://www.gnu.org/software/classpathx/
 *
 * classpathx is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * classpathx is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with classpathx.
 * If not, see <http://www.gnu.org/licenses/>.
 */
package javax.servlet.jsp.tagext;

/**
 * <p>
 * Information on the scripting variables that are created/modified by
 * a tag (at run-time). This information is provided by
 * TagExtraInfo classes and it is used by the translation phase of JSP.
 * </p>
 * <p>
 * Scripting variables generated by a custom action have an associated
 * scope of either AT_BEGIN, NESTED, or AT_END.
 * </p>
 * @version 2.1
 * @author Arnaud Vandyck - arnaud.vandyck@ulg.ac.be
 */
public class VariableInfo
{

    /**
     * Scope information that scripting variable is visible only within
     * the start/end tags. 
     * @see {@link http://java.sun.com/j2ee/1.4/docs/api/constant-values.html#javax.servlet.jsp.tagext.VariableInfo.NESTED Constant Field Values}
     */  
    public static final int NESTED = 0;

    /**
     * Scope information that scripting variable is visible after start tag.
     * @see {@link http://java.sun.com/j2ee/1.4/docs/api/constant-values.html#javax.servlet.jsp.tagext.VariableInfo.AT_BEGIN Constant Field Values}
     */
    public static final int AT_BEGIN = 1;

    /**
     * Scope information that scripting variable is visible after end tag.
     * @see {@link http://java.sun.com/j2ee/1.4/docs/api/constant-values.html#javax.servlet.jsp.tagext.VariableInfo.AT_END Constant Field Values}
     */
    public static final int AT_END = 2;

    private String varName;
    private String className;
    private boolean declare;
    private int scope;

    /**
     * Constructor.
     * 
     * @param varName The name of the scripting variable
     * @param className The type of this variable
     * @param declare If true, it is a new variable
     * (in some languages this will require a declaration) scope
     */
    public VariableInfo(String varName,
            String className,
            boolean declare,
            int scope)
    {
        this.varName = varName;
        this.className = className;
        this.declare = declare;
        this.scope = scope;
    }

    /**
     * Get the VarName value.
     * @return the VarName value.
     */
    public String getVarName()
    {
        return varName;
    }

    /**
     * Get the ClassName value.
     * @return the ClassName value.
     */
    public String getClassName()
    {
        return className;
    }

    /**
     * Get the Declare value.
     * @return the Declare value.
     */
    public boolean getDeclare()
    {
        return declare;
    }

    /**
     * Get the Scope value.
     * @return the Scope value.
     */
    public int getScope()
    {
        return scope;
    }

}
