/* tngetc.c */

/* Copyright 1997 by Eberhard Mattes <mattes@azu.informatik.uni-stuttgart.de>
   Donated to the public domain.  No warranty.

   1997-01-04 Initial version
   1997-01-18 Fix various bugs
   1997-04-05 Reorganize library, don't trap SIGALRM */

#include <stdlib.h>
#include <errno.h>
#include <signal.h>
#include <unistd.h>
#include <syslog.h>
#include "firewall.h"
#include "libemtn.h"
#include "tnint.h"

int tn_getc (tnconn *t)
{
  char c;
  int n;

  do
    {
      n = read (t->fd, &c, 1);
    } while (n == -1 && errno == EINTR);
  if (n == -1)
    {
      syslog (LLEV, "tn_getc: %m");
      exit (1);
    }
  else if (n == 0)
    {
      syslog (LLEV, "tn_getc: connection closed");
      exit (1);
    }
  return (unsigned char)c;
}
